/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.commandline.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.URL;
import java.rmi.MarshalException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import weblogic.descriptor.BeanAlreadyExistsException;
import weblogic.kernel.Kernel;
import weblogic.management.MBeanCreationException;
import weblogic.management.MBeanHome;
import weblogic.management.ManagementError;
import weblogic.management.RemoteMBeanServer;
import weblogic.management.WebLogicMBean;
import weblogic.management.WebLogicObjectName;
import weblogic.management.commandline.CommandDescription;
import weblogic.management.commandline.CommandLineArgs;
import weblogic.management.commandline.OutputFormatter;
import weblogic.management.commandline.tools.AdminToolHelper;
import weblogic.management.commandline.tools.ClusterAdminCommandLineInvoker;
import weblogic.management.commandline.tools.JDBCCommandLineInvoker;
import weblogic.management.commandline.tools.ServerAdminCommandLineInvoker;
import weblogic.management.commandline.tools.ServerInfoCommandLineInvoker;
import weblogic.management.commo.CommoAdminTool;
import weblogic.management.configuration.ConfigurationError;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.internal.ManagementTextTextFormatter;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.rjvm.PeerGoneException;
import weblogic.rmi.extensions.RemoteRuntimeException;
import weblogic.utils.StringUtils;

public final class MBeanCommandLineInvoker {
    static final String OK_STRING = "Ok";
    private static final boolean debug = false;
    private CommandLineArgs params = null;
    private MBeanHome adminHome = null;
    private Set matchedMBeans = null;
    private OutputFormatter out = null;
    private boolean EXIT = false;
    private boolean batchMode = false;
    private PrintStream printStream = System.out;
    private boolean commoMbeanType = false;
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String URL = "url";
    private static final String INPUTFILE = "inputfile";
    private static final String DEFAULT_URL = "http://localhost:7001";
    private static final String COMMAND = "cmd";
    private static final Set NON_COMMAND_ADMIN_OPTIONS = new HashSet<Object>(Arrays.asList((Object[])new String[]{"username", "password", "url", "inputfile"}));

    public MBeanCommandLineInvoker(CommandLineArgs commandLineArgs, PrintStream printStream) throws Exception {
        try {
            this.params = commandLineArgs;
            if (printStream != null) {
                this.printStream = printStream;
            }
            if (printStream != null) {
                AdminToolHelper.printStream = printStream;
            }
            this.doCommandline();
        }
        catch (Exception exception) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printException(exception);
            }
            throw exception;
        }
    }

    public MBeanCommandLineInvoker(String[] stringArray, PrintStream printStream, MBeanHome mBeanHome) throws Exception {
        this.params = new CommandLineArgs(stringArray);
        if (printStream != null) {
            this.printStream = printStream;
        }
        this.adminHome = mBeanHome;
        this.doCommandline();
    }

    public MBeanCommandLineInvoker(CommandLineArgs commandLineArgs, PrintStream printStream, MBeanHome mBeanHome) throws Exception {
        this.params = commandLineArgs;
        if (printStream != null) {
            this.printStream = printStream;
        }
        this.adminHome = mBeanHome;
        this.doCommandline();
    }

    public MBeanCommandLineInvoker(String[] stringArray, PrintStream printStream) throws Exception {
        this(new CommandLineArgs(stringArray), printStream);
    }

    public static void main(String[] stringArray) throws Exception {
        MBeanCommandLineInvoker mBeanCommandLineInvoker = new MBeanCommandLineInvoker(stringArray, System.out);
    }

    private void processCommoMBeans() throws JMException, Exception {
        if (Kernel.isServer()) {
            return;
        }
        RemoteMBeanServer remoteMBeanServer = null;
        try {
            remoteMBeanServer = this.adminHome.getMBeanServer();
        }
        catch (Exception exception) {
            AdminToolHelper.printException(exception, true);
            throw exception;
        }
        CommoAdminTool.doIt(this.params, remoteMBeanServer, remoteMBeanServer.getDefaultDomain(), this.adminHome);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doCommandline() throws Exception {
        try {
            this.adminHome = this.params.getAdminHome();
            if (this.adminHome == null) {
                if (this.params.getAdminUrl() != null) {
                    this.adminHome = AdminToolHelper.getAdminMBeanHome(this.params);
                    this.params.setUrl(this.params.getAdminUrl());
                } else {
                    this.adminHome = AdminToolHelper.getMBeanHome(this.params);
                }
            }
            if (this.params.getCommoType()) {
                this.processCommoMBeans();
                this.commoMbeanType = true;
                return;
            }
            if (this.params.getOperation() != 33 && this.params.getMBeanObjName() != null) {
                try {
                    RemoteMBeanServer remoteMBeanServer = this.adminHome.getMBeanServer();
                    if (remoteMBeanServer.isInstanceOf(new ObjectName(this.params.getMBeanObjName()), "weblogic.management.commo.StandardInterface")) {
                        this.processCommoMBeans();
                        this.commoMbeanType = true;
                        return;
                    }
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    // empty catch block
                }
            }
            if (this.params.getOperation() != 50 && this.params.getOperation() != 29 && this.params.getOperation() != 36 && this.params.getOperation() != 52) {
                this.listMatchedMBeans();
            }
            this.out = new OutputFormatter(this.printStream, this.params.isPretty());
            if (this.commoMbeanType) return;
            this.doOperation();
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (AdminToolHelper.printDone) throw illegalArgumentException;
            AdminToolHelper.printException(illegalArgumentException);
            AdminToolHelper.printDone = true;
            throw illegalArgumentException;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printException(malformedObjectNameException, true);
                AdminToolHelper.printDone = true;
            }
            this.printStream.println("Usage:\n" + CommandLineArgs.getUsageString());
            throw malformedObjectNameException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (AdminToolHelper.printDone) throw instanceNotFoundException;
            this.printStream.println(managementTextTextFormatter.getCouldNotFindInstance(this.params.getMBeanObjName()));
            AdminToolHelper.printDone = true;
            throw instanceNotFoundException;
        }
        catch (RemoteRuntimeException remoteRuntimeException) {
            Throwable throwable = remoteRuntimeException.getNestedException();
            if (throwable instanceof PeerGoneException) {
                return;
            }
            if (AdminToolHelper.printDone) throw remoteRuntimeException;
            AdminToolHelper.printException((Exception)((Object)remoteRuntimeException), true);
            AdminToolHelper.printDone = true;
            throw remoteRuntimeException;
        }
        catch (ConnectException connectException) {
            if (AdminToolHelper.printDone) throw connectException;
            AdminToolHelper.printException("java.net.ConnectException", connectException);
            AdminToolHelper.printDone = true;
            throw connectException;
        }
        catch (IOException iOException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (AdminToolHelper.printDone) throw iOException;
            AdminToolHelper.printException(managementTextTextFormatter.getErrorWriting(), iOException);
            AdminToolHelper.printDone = true;
            throw iOException;
        }
        catch (MBeanException mBeanException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (AdminToolHelper.printDone) throw mBeanException;
            AdminToolHelper.printException(mBeanException.getTargetException().getClass().getName(), mBeanException.getTargetException());
            AdminToolHelper.printDone = true;
            throw mBeanException;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeOperationsException) {
                RuntimeOperationsException runtimeOperationsException = (RuntimeOperationsException)exception;
                if (!(runtimeOperationsException.getTargetException() instanceof RemoteRuntimeException)) return;
            }
            if (exception instanceof AttributeNotFoundException) {
                if (this.params.showNoMessages() || AdminToolHelper.printDone) return;
                AdminToolHelper.printException("Attribute not found", exception);
                AdminToolHelper.printDone = true;
                return;
            }
            if (this.params.showNoMessages() || AdminToolHelper.printDone) throw exception;
            AdminToolHelper.printException(exception);
            AdminToolHelper.printDone = true;
            throw exception;
        }
    }

    private void doOperation() throws Exception {
        switch (this.params.getOperation()) {
            case 31: {
                this.doGet();
                break;
            }
            case 32: {
                this.doSet();
                break;
            }
            case 33: {
                this.doCreate();
                break;
            }
            case 34: {
                this.doDelete();
                break;
            }
            case 35: {
                this.doInvoke();
                break;
            }
            case 29: {
                this.doQuery();
                break;
            }
            case 36: {
                this.doBatchOperation();
            }
        }
    }

    private void doBatchOperation() throws Exception {
        int n;
        this.batchMode = this.params.showNoMessages();
        ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
        String[] stringArray = this.getCommands();
        if (this.adminHome == null) {
            try {
                this.adminHome = this.params.getAdminUrl() != null ? AdminToolHelper.getAdminMBeanHome(this.params) : AdminToolHelper.getMBeanHome(this.params);
            }
            catch (Exception exception) {
                AdminToolHelper.printException(exception, false);
            }
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String[] stringArray2 = null;
        boolean bl = this.params.isBatchCmdVerbose();
        int n5 = n = stringArray != null ? stringArray.length : 0;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (string.trim().length() < 1 || string.trim().startsWith("#")) continue;
            string = string.replaceAll("\"\"", "_WLS_EMPTYSTR_");
            string = "-batchCmd " + string;
            boolean bl2 = false;
            if (this.params.getAdminUrl() != null) {
                int n6;
                int n7 = n6 = stringArray2 != null ? stringArray2.length : 0;
                for (int j = 0; j < n6; ++j) {
                    void var14_21 = stringArray2[j];
                    if (!var14_21.startsWith("-adminurl")) continue;
                    bl2 = true;
                }
                if (!bl2) {
                    string = " -adminurl " + this.params.getAdminUrl() + " " + string;
                }
            }
            if (this.batchMode) {
                string = string + " -showNoMessages";
            }
            if (string.indexOf("\"") > -1 || string.indexOf("'") > -1) {
                Object object;
                int n8;
                Vector<Object> vector = new Vector<Object>();
                String[] stringArray3 = StringUtils.splitCompletely((String)string, (String)"\"");
                for (n8 = 0; n8 < stringArray3.length; ++n8) {
                    stringArray3[n8].trim();
                    object = StringUtils.splitCompletely((String)stringArray3[n8]);
                    for (int j = 0; j < ((String[])object).length; ++j) {
                        vector.add(object[j]);
                    }
                    if (++n8 >= stringArray3.length) continue;
                    vector.add(stringArray3[n8]);
                }
                stringArray2 = new String[vector.size()];
                for (n8 = 0; n8 < vector.size(); ++n8) {
                    object = (String)vector.get(n8);
                    if (((String)object).equals("_WLS_EMPTYSTR_")) {
                        object = "";
                    }
                    stringArray2[n8] = object;
                }
            } else {
                stringArray2 = StringUtils.splitCompletely((String)string);
            }
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray2[j].equals("_WLS_EMPTYSTR_")) continue;
                stringArray2[j] = "";
            }
            try {
                if (bl) {
                    System.out.println("\nExecuting command: " + StringUtils.join((String[])StringUtils.splitCompletely((String)stringArray[i]), (String)" ") + "\n");
                }
                CommandLineArgs commandLineArgs = new CommandLineArgs(this.params.getUsername(), this.params.getPassword(), this.params.getURL(), stringArray2);
                CommandDescription commandDescription = commandLineArgs.getCommandDescription(commandLineArgs.getOperationString());
                ++n2;
                if (commandDescription.getGenericType() == 104) {
                    new MBeanCommandLineInvoker(commandLineArgs, System.out, this.adminHome);
                } else if (commandDescription.getGenericType() == 103) {
                    new JDBCCommandLineInvoker(commandLineArgs, System.out, this.adminHome);
                } else if (commandDescription.getGenericType() == 101) {
                    new ServerInfoCommandLineInvoker(commandLineArgs, System.out, this.adminHome);
                } else if (commandDescription.getGenericType() == 102) {
                    new ServerAdminCommandLineInvoker(commandLineArgs, System.out, this.adminHome);
                } else if (commandDescription.getGenericType() == 105) {
                    new ClusterAdminCommandLineInvoker(commandLineArgs, System.out, this.adminHome);
                }
                ++n4;
                continue;
            }
            catch (Exception exception) {
                if (this.params.continueOnError()) {
                    System.out.println("\nError executing command in batch file " + this.params.getBatchFileName() + " at line number: " + (i + 1));
                    ++n3;
                    continue;
                }
                System.out.println("\nError: " + this.params.getBatchFileName() + " at line number: " + (i + 1));
                ++n3;
                break;
            }
        }
        if (bl) {
            System.out.println("\n---------------------------------------------------------------------------------------------");
            System.out.println("---------------------------------------------------------------------------------------------");
            System.out.println("Batch Command Results: ");
            System.out.println("Total Commands Executed: " + n2);
            System.out.println("Commands Successful: " + n4);
            System.out.println("Commands Failed: " + n3);
        }
    }

    private void doQuery() throws Exception {
        try {
            ObjectName objectName = new ObjectName(this.params.getObjectNamePattern());
            Set<ObjectName> set = this.adminHome.getMBeanServer().queryNames(objectName, null);
            Iterator<ObjectName> iterator = set.iterator();
            boolean bl = false;
            AttributeList attributeList = new AttributeList();
            if (!iterator.hasNext()) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                this.printStream.println(managementTextTextFormatter.getNoMBeansFound());
                return;
            }
            while (iterator.hasNext()) {
                ObjectName objectName2 = null;
                ObjectName objectName3 = null;
                objectName3 = iterator.next();
                if (objectName3 == null) continue;
                String[] stringArray = null;
                try {
                    objectName2 = objectName3;
                    stringArray = this.getAllAttribute(objectName2);
                    attributeList = this.adminHome.getMBeanServer().getAttributes(objectName2, stringArray);
                    MBeanInfo mBeanInfo = this.adminHome.getMBeanServer().getMBeanInfo(objectName2);
                    MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
                    ModelMBeanAttributeInfo[] modelMBeanAttributeInfoArray = null;
                    if (null != mBeanAttributeInfoArray && ModelMBeanAttributeInfo[].class.isAssignableFrom(mBeanAttributeInfoArray.getClass())) {
                        modelMBeanAttributeInfoArray = (ModelMBeanAttributeInfo[])mBeanAttributeInfoArray;
                    }
                    block8: for (int i = 0; i < attributeList.size(); ++i) {
                        Attribute attribute = (Attribute)attributeList.get(i);
                        String string = attribute.getName();
                        for (int j = 0; j < modelMBeanAttributeInfoArray.length; ++j) {
                            if (!modelMBeanAttributeInfoArray[j].getName().equals(string) || !this.isEncrypted(modelMBeanAttributeInfoArray[j]) || attribute.getValue() == null) continue;
                            attributeList.set(i, new Attribute(string, "******"));
                            continue block8;
                        }
                    }
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    AdminToolHelper.printException(instanceNotFoundException);
                    throw instanceNotFoundException;
                }
                catch (ReflectionException reflectionException) {
                    AdminToolHelper.printException(reflectionException);
                    throw reflectionException;
                }
                this.out.mbeanBegin(objectName2.toString());
                this.out.printAttribs(attributeList, stringArray);
                this.out.mbeanEnd();
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            AdminToolHelper.printException(managementTextTextFormatter.getPatternNotUnderstood(), malformedObjectNameException, false);
            throw malformedObjectNameException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            AdminToolHelper.printException("", instanceNotFoundException, true);
            throw instanceNotFoundException;
        }
        catch (JMException jMException) {
            AdminToolHelper.printException("", jMException, true);
            throw jMException;
        }
    }

    private boolean isEncrypted(ModelMBeanAttributeInfo modelMBeanAttributeInfo) {
        Boolean bl = (Boolean)modelMBeanAttributeInfo.getDescriptor().getFieldValue("com.bea.encrypted");
        if (bl != null) {
            return bl;
        }
        return false;
    }

    private boolean isExcluded(ModelMBeanAttributeInfo modelMBeanAttributeInfo) {
        Boolean bl = (Boolean)modelMBeanAttributeInfo.getDescriptor().getFieldValue("com.bea.exclude");
        if (bl != null) {
            return bl;
        }
        return false;
    }

    private void doGet() throws Exception {
        AttributeList attributeList = new AttributeList();
        Iterator iterator = this.matchedMBeans.iterator();
        if (!iterator.hasNext()) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            this.printStream.println(managementTextTextFormatter.getNoMBeansFound());
            return;
        }
        while (iterator.hasNext()) {
            Object object;
            WebLogicMBean webLogicMBean = (WebLogicMBean)iterator.next();
            String[] stringArray = null;
            try {
                ModelMBeanAttributeInfo[] modelMBeanAttributeInfoArray;
                stringArray = this.getAllAttribute(webLogicMBean);
                try {
                    if (stringArray.length == 1) {
                        attributeList.add(new Attribute(stringArray[0], webLogicMBean.getAttribute(stringArray[0])));
                    } else {
                        attributeList = webLogicMBean.getAttributes(stringArray);
                    }
                }
                catch (RemoteRuntimeException remoteRuntimeException) {
                    if (remoteRuntimeException.getNestedException() instanceof MarshalException) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            try {
                                modelMBeanAttributeInfoArray = webLogicMBean.getAttribute(stringArray[i]);
                                attributeList.add(new Attribute(stringArray[i], modelMBeanAttributeInfoArray));
                                continue;
                            }
                            catch (RemoteRuntimeException remoteRuntimeException2) {
                                if (remoteRuntimeException2.getNestedException() instanceof MarshalException) continue;
                                throw remoteRuntimeException2;
                            }
                        }
                    }
                    throw remoteRuntimeException;
                }
                catch (RuntimeErrorException runtimeErrorException) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        try {
                            modelMBeanAttributeInfoArray = webLogicMBean.getAttribute(stringArray[i]);
                            attributeList.add(new Attribute(stringArray[i], modelMBeanAttributeInfoArray));
                            continue;
                        }
                        catch (RuntimeErrorException runtimeErrorException2) {
                            // empty catch block
                        }
                    }
                }
                MBeanInfo mBeanInfo = MBeanCommandLineInvoker.getMBeanInfo(webLogicMBean);
                object = mBeanInfo.getAttributes();
                modelMBeanAttributeInfoArray = null;
                if (null != object && ModelMBeanAttributeInfo[].class.isAssignableFrom(object.getClass())) {
                    modelMBeanAttributeInfoArray = (ModelMBeanAttributeInfo[])object;
                }
                block15: for (int i = 0; i < attributeList.size(); ++i) {
                    Attribute attribute = (Attribute)attributeList.get(i);
                    String string = attribute.getName();
                    for (int j = 0; j < modelMBeanAttributeInfoArray.length; ++j) {
                        if (!modelMBeanAttributeInfoArray[j].getName().equals(string) || !this.isEncrypted(modelMBeanAttributeInfoArray[j]) || attribute.getValue() == null) continue;
                        attributeList.set(i, new Attribute(string, "******"));
                        continue block15;
                    }
                }
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                AdminToolHelper.printException(instanceNotFoundException);
                AdminToolHelper.printDone = true;
                throw instanceNotFoundException;
            }
            catch (ReflectionException reflectionException) {
                AdminToolHelper.printException(reflectionException);
                AdminToolHelper.printDone = true;
                throw reflectionException;
            }
            catch (RemoteRuntimeException remoteRuntimeException) {
                object = remoteRuntimeException.getNestedException();
                if (object instanceof PeerGoneException) {
                    return;
                }
                AdminToolHelper.printException((Exception)((Object)remoteRuntimeException));
                AdminToolHelper.printDone = true;
                throw remoteRuntimeException;
            }
            catch (RuntimeErrorException runtimeErrorException) {
                if (runtimeErrorException.getTargetError() instanceof ManagementError) {
                    if (((ManagementError)((Object)runtimeErrorException.getTargetError())).getNestedError() instanceof AttributeNotFoundException) {
                        object = "";
                        for (int i = 0; i < stringArray.length; ++i) {
                            object = (String)object + " " + stringArray[i];
                        }
                        ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                        this.printStream.println(managementTextTextFormatter.getInvalidParameterError((String)object));
                        AdminToolHelper.printDone = true;
                        throw runtimeErrorException;
                    }
                }
                AdminToolHelper.printException(runtimeErrorException);
                AdminToolHelper.printDone = true;
                throw runtimeErrorException;
            }
            this.out.mbeanBegin(webLogicMBean.getObjectName().toString());
            this.out.printAttribs(attributeList, stringArray);
            this.out.mbeanEnd();
            attributeList.clear();
        }
    }

    private void doSet() throws Exception {
        Iterator iterator = this.matchedMBeans.iterator();
        if (!iterator.hasNext()) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            this.printStream.println(managementTextTextFormatter.getNoMBeansFound());
            return;
        }
        AttributeList attributeList = this.params.getAttribList();
        if (0 == attributeList.size()) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            this.printStream.println(managementTextTextFormatter.getNoProp());
            return;
        }
        WebLogicMBean webLogicMBean = null;
        while (iterator.hasNext()) {
            webLogicMBean = (WebLogicMBean)iterator.next();
            for (Attribute attribute : attributeList) {
                webLogicMBean.setAttribute(attribute);
            }
        }
        if (!this.params.showNoMessages()) {
            this.out.println(OK_STRING);
        }
    }

    private void doCreate() throws Exception {
        WebLogicObjectName webLogicObjectName = null;
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        Vector<Object> vector = new Vector<Object>();
        try {
            Object object;
            Object object2;
            Object object3;
            StringTokenizer stringTokenizer;
            String string;
            String string2;
            if (null != this.params.getNewMBeanName()) {
                string2 = this.params.getDomainName();
                if (null == string2) {
                    string2 = this.getDefaultDomain();
                }
                webLogicObjectName = new WebLogicObjectName(this.params.getNewMBeanName(), this.params.getMBeanType(), string2);
            } else if (null != this.params.getMBeanObjName()) {
                string2 = this.params.getMBeanObjName();
                int n = string2.indexOf(58);
                string = string2.substring(n + 1, string2.length());
                stringTokenizer = new StringTokenizer(string, ",");
                int n2 = 0;
                while (stringTokenizer.hasMoreElements()) {
                    object3 = stringTokenizer.nextToken();
                    object2 = new StringTokenizer((String)object3, "=");
                    object = null;
                    String string3 = null;
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        object = ((StringTokenizer)object2).nextToken();
                        string3 = ((StringTokenizer)object2).nextToken();
                        if (((String)object).equals("Name") || ((String)object).equals("Type") || ((String)object).equals("Location")) continue;
                        vector.add(n2, object);
                        ++n2;
                        hashMap.put(object, string3);
                    }
                }
                webLogicObjectName = new WebLogicObjectName(this.params.getMBeanObjName());
            }
            string2 = webLogicObjectName.getType();
            String string4 = webLogicObjectName.getName();
            string = webLogicObjectName.getDomain();
            stringTokenizer = null;
            Hashtable hashtable = webLogicObjectName.getKeyPropertyList();
            object3 = hashMap.keySet().iterator();
            if (stringTokenizer == null && !hashMap.isEmpty()) {
                object2 = null;
                object = hashMap.keySet().iterator();
                int n = 0;
                while (object.hasNext()) {
                    object.next();
                    String string5 = (String)vector.get(n);
                    ++n;
                    String string6 = (String)hashMap.get(string5);
                    if (object2 == null) {
                        try {
                            object2 = this.adminHome.getAdminMBean(string6, string5, string);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (object2 != null) continue;
                        object2 = (ConfigurationMBean)this.adminHome.createAdminMBean(string6, string5, string);
                        continue;
                    }
                    object2 = (ConfigurationMBean)this.adminHome.createAdminMBean(string6, string5, string, (ConfigurationMBean)object2);
                }
                stringTokenizer = object2;
            }
            object2 = null;
            if (string2 == null) {
                throw new MBeanCreationException("Type is null");
            }
            if (string2.endsWith("Config")) {
                object = new ManagementTextTextFormatter();
                throw new MBeanCreationException(object.getConfigCreateError());
            }
            if (string2.endsWith("Runtime")) {
                object = new ManagementTextTextFormatter();
                throw new MBeanCreationException(object.getRuntimeCreateError());
            }
            object2 = stringTokenizer != null ? this.adminHome.createAdminMBean(string4, string2, string, (ConfigurationMBean)((Object)stringTokenizer)) : this.adminHome.createAdminMBean(string4, string2, string);
        }
        catch (MBeanCreationException mBeanCreationException) {
            if (mBeanCreationException.getCause() instanceof BeanAlreadyExistsException) {
                this.completeOnDuplicate(webLogicObjectName);
                if (this.params.isVerbose()) {
                    mBeanCreationException.getCause().printStackTrace();
                } else {
                    return;
                }
            }
            if (mBeanCreationException.getNested() instanceof BeanAlreadyExistsException || mBeanCreationException.getNestedException() instanceof BeanAlreadyExistsException) {
                this.completeOnDuplicate(webLogicObjectName);
                if (this.params.isVerbose()) {
                    mBeanCreationException.getCause().printStackTrace();
                } else {
                    return;
                }
            }
            if (this.params.getMBeanObjName() != null && this.adminHome.getMBeanServer().isRegistered(new ObjectName(this.params.getMBeanObjName()))) {
                this.completeOnDuplicate(webLogicObjectName);
                throw mBeanCreationException;
            }
            if (this.params.getMBeanObjName() != null && this.params.getMBeanType() != null) {
                try {
                    this.processCommoMBeans();
                    this.commoMbeanType = true;
                    return;
                }
                catch (JMException jMException) {
                    if (!this.params.showNoMessages() && !AdminToolHelper.printDone) {
                        AdminToolHelper.printException(jMException);
                        AdminToolHelper.printDone = true;
                    }
                    throw jMException;
                }
            }
            if (this.params.isVerbose()) {
                AdminToolHelper.printException((Exception)((Object)mBeanCreationException));
            }
            if (this.hasAlreadyExists(mBeanCreationException)) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                System.out.println("\n" + managementTextTextFormatter.getInstanceAlreadyExists(webLogicObjectName.toString()));
                AdminToolHelper.printDone = true;
                throw mBeanCreationException;
            }
            if (mBeanCreationException.getNestedException() instanceof ClassNotFoundException || mBeanCreationException.getNestedException() instanceof ConfigurationError) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                System.out.println("\n" + managementTextTextFormatter.getInvalidMBeanType(webLogicObjectName.getType()));
                AdminToolHelper.printDone = true;
                throw mBeanCreationException;
            }
            if (!this.params.showNoMessages() && !AdminToolHelper.printDone) {
                AdminToolHelper.printException((Exception)((Object)mBeanCreationException), false);
                AdminToolHelper.printDone = true;
            }
            throw mBeanCreationException;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            if (!this.params.showNoMessages() && !AdminToolHelper.printDone) {
                AdminToolHelper.printException(malformedObjectNameException);
                AdminToolHelper.printDone = true;
            }
            throw malformedObjectNameException;
        }
        catch (Exception exception) {
            if (this.hasAlreadyExists(exception)) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                System.out.println("\n" + managementTextTextFormatter.getInstanceAlreadyExists(webLogicObjectName.toString()));
                AdminToolHelper.printDone = true;
            }
            throw exception;
        }
        if (!this.params.showNoMessages()) {
            this.out.println(OK_STRING);
        }
    }

    private boolean hasAlreadyExists(Throwable throwable) {
        Throwable throwable2 = throwable.getCause();
        if (throwable2 == null) {
            return false;
        }
        if (throwable2 instanceof InstanceAlreadyExistsException || throwable2 instanceof BeanAlreadyExistsException) {
            return true;
        }
        return this.hasAlreadyExists(throwable2);
    }

    private void completeOnDuplicate(WebLogicObjectName webLogicObjectName) {
        ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
        System.out.println("\n" + managementTextTextFormatter.getInstanceAlreadyExists(webLogicObjectName.toString()));
        AdminToolHelper.printDone = true;
    }

    private void doDelete() throws Exception {
        Object var1_1 = null;
        if (null != this.params.getNewMBeanName() && null != this.params.getMBeanType()) {
            WebLogicMBean webLogicMBean;
            Set set = this.adminHome.getMBeansByType(this.params.getMBeanType());
            Iterator iterator = set.iterator();
            if (!iterator.hasNext()) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!this.params.showNoMessages()) {
                    this.printStream.println(managementTextTextFormatter.getNoMBeansFound());
                }
                return;
            }
            boolean bl = false;
            while (iterator.hasNext()) {
                webLogicMBean = (WebLogicMBean)iterator.next();
                if (!webLogicMBean.getName().equals(this.params.getNewMBeanName())) continue;
                this.adminHome.deleteMBean(webLogicMBean);
                System.out.println("\nDeleted MBean with Object Name: " + webLogicMBean.getObjectName());
                bl = true;
            }
            if (!bl) {
                webLogicMBean = new ManagementTextTextFormatter();
                if (!this.params.showNoMessages()) {
                    this.printStream.println(webLogicMBean.getNoMBeansFound());
                }
            }
        } else {
            Iterator iterator = this.matchedMBeans.iterator();
            if (!iterator.hasNext()) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!this.params.showNoMessages()) {
                    this.printStream.println(managementTextTextFormatter.getNoMBeansFound());
                }
                return;
            }
            while (iterator.hasNext()) {
                try {
                    WebLogicMBean webLogicMBean = (WebLogicMBean)iterator.next();
                    this.adminHome.deleteMBean(webLogicMBean);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    if (!this.params.showNoMessages() && !AdminToolHelper.printDone) {
                        AdminToolHelper.printException(instanceNotFoundException);
                        AdminToolHelper.printDone = true;
                    }
                    throw instanceNotFoundException;
                }
                catch (MBeanRegistrationException mBeanRegistrationException) {
                    if (!this.params.showNoMessages() && !AdminToolHelper.printDone) {
                        AdminToolHelper.printException(mBeanRegistrationException);
                        AdminToolHelper.printDone = true;
                    }
                    throw mBeanRegistrationException;
                }
            }
            if (!this.params.showNoMessages()) {
                this.out.println(OK_STRING);
            }
        }
    }

    private void doInvoke() throws Exception {
        Iterator iterator = this.matchedMBeans.iterator();
        if (!iterator.hasNext()) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!this.params.showNoMessages()) {
                this.printStream.println(managementTextTextFormatter.getNoMBeansFound());
            }
            return;
        }
        while (iterator.hasNext()) {
            Object object = null;
            WebLogicMBean webLogicMBean = (WebLogicMBean)iterator.next();
            try {
                String[] stringArray = this.getMethodSignature(webLogicMBean, this.params.getMethodName());
                object = webLogicMBean.invoke(this.params.getMethodName(), this.params.getMethodArguments(stringArray), stringArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!this.params.showNoMessages() && !AdminToolHelper.printDone) {
                    AdminToolHelper.printException(illegalArgumentException);
                    AdminToolHelper.printDone = true;
                }
                throw illegalArgumentException;
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                if (!this.params.showNoMessages() && !AdminToolHelper.printDone) {
                    AdminToolHelper.printException(instanceNotFoundException);
                    AdminToolHelper.printDone = true;
                }
                throw instanceNotFoundException;
            }
            catch (MBeanException mBeanException) {
                if (!this.params.showNoMessages() && !AdminToolHelper.printDone) {
                    AdminToolHelper.printException(mBeanException);
                    AdminToolHelper.printDone = true;
                }
                throw mBeanException;
            }
            catch (ReflectionException reflectionException) {
                if (!this.params.showNoMessages() && !AdminToolHelper.printDone) {
                    if (reflectionException.getCause() instanceof NoSuchMethodException) {
                        this.printStream.println("Method " + this.params.getMethodName() + " Not available on MBean " + webLogicMBean.getObjectName());
                        AdminToolHelper.printDone = true;
                    } else {
                        reflectionException.printStackTrace();
                        AdminToolHelper.printDone = true;
                    }
                }
                throw reflectionException;
            }
            catch (RemoteRuntimeException remoteRuntimeException) {
                Throwable throwable = remoteRuntimeException.getNestedException();
                if (throwable != null) {
                    if (throwable instanceof PeerGoneException) {
                        return;
                    }
                    if (!this.params.showNoMessages() && !AdminToolHelper.printDone) {
                        AdminToolHelper.printException((Exception)throwable, true);
                        AdminToolHelper.printDone = true;
                    }
                    throw remoteRuntimeException;
                }
                if (!this.params.showNoMessages() && !AdminToolHelper.printDone) {
                    AdminToolHelper.printException((Exception)((Object)remoteRuntimeException), true);
                    AdminToolHelper.printDone = true;
                }
                throw remoteRuntimeException;
            }
            catch (Exception exception) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printException("\n" + managementTextTextFormatter.getCouldNotInvoke() + " method " + this.params.getMethodName() + " on MBean: " + webLogicMBean.getObjectName().toString() + " due to ", exception, false);
                    AdminToolHelper.printDone = true;
                }
                throw exception;
            }
            catch (Throwable throwable) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!this.params.showNoMessages()) {
                    this.printStream.println(managementTextTextFormatter.getCouldNotInvoke() + webLogicMBean.getObjectName() + ", " + throwable);
                }
                return;
            }
            this.out.mbeanBegin(webLogicMBean.getObjectName().toString());
            this.out.printReturnValue(this.params.getMethodName(), object);
            this.out.mbeanEnd();
        }
        if (!this.params.showNoMessages()) {
            this.out.println(OK_STRING);
        }
    }

    private void listMatchedMBeans() throws Exception {
        WebLogicObjectName webLogicObjectName = null;
        if (33 == this.params.getOperation()) {
            return;
        }
        this.matchedMBeans = new HashSet();
        if (null != this.params.getMBeanObjName()) {
            webLogicObjectName = new WebLogicObjectName(this.params.getMBeanObjName());
            try {
                WebLogicMBean webLogicMBean = this.adminHome.getMBean((ObjectName)webLogicObjectName);
                this.matchedMBeans.add(this.adminHome.getMBean((ObjectName)webLogicObjectName));
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                if (this.adminHome.getMBeanServer().isRegistered((ObjectName)webLogicObjectName)) {
                    this.processCommoMBeans();
                    this.commoMbeanType = true;
                    return;
                }
                throw instanceNotFoundException;
            }
            catch (ClassCastException classCastException) {
                if (this.adminHome.getMBeanServer().isRegistered((ObjectName)webLogicObjectName)) {
                    this.processCommoMBeans();
                    this.commoMbeanType = true;
                    return;
                }
                throw classCastException;
            }
        } else if (null != this.params.getMBeanType()) {
            if (this.isTypeMalformed(this.params.getMBeanType())) {
                return;
            }
            Set set = null;
            set = this.params.getAdminUrl() != null ? this.adminHome.getMBeansByType(this.params.getMBeanType()) : AdminToolHelper.getLocalMBeanHome(this.params).getMBeansByType(this.params.getMBeanType());
            if (set.size() == 0) {
                try {
                    this.processCommoMBeans();
                    this.commoMbeanType = true;
                    return;
                }
                catch (JMException jMException) {
                    AdminToolHelper.printException(jMException, false);
                    throw jMException;
                }
            }
            this.matchedMBeans.addAll(set);
        } else {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            AdminToolHelper.printErrorMessage(managementTextTextFormatter.getNoMBeanNameOrType(), false);
            AdminToolHelper.printDone = true;
            throw new Exception();
        }
    }

    private boolean isTypeMalformed(String string) {
        return string.indexOf(":") != -1 || string.indexOf(",") != -1 || string.indexOf("=") != -1;
    }

    private String[] getCommands() throws IOException {
        Map map = MBeanCommandLineInvoker.parseInputURL(new File(this.params.getBatchFileName()).toURL().toExternalForm());
        List list = (List)map.get(COMMAND);
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        return stringArray;
    }

    private static Map parseInputURL(String string) throws IOException {
        String string2;
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(new URL(string).openStream()));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Vector<String> vector = new Vector<String>();
        while ((string2 = lineNumberReader.readLine()) != null) {
            int n = string2.indexOf("=");
            if (n != -1) {
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                if (NON_COMMAND_ADMIN_OPTIONS.contains(string3)) {
                    hashMap.put(string3, string4);
                    continue;
                }
                vector.add(string2);
                continue;
            }
            vector.add(string2);
        }
        hashMap.put(COMMAND, vector);
        return hashMap;
    }

    private String[] getAllAttribute(Object object) throws InstanceNotFoundException, ReflectionException, ConfigurationException, IntrospectionException {
        WebLogicMBean webLogicMBean = null;
        ObjectName objectName = null;
        if (object instanceof WebLogicMBean) {
            webLogicMBean = (WebLogicMBean)object;
        } else {
            objectName = (ObjectName)object;
        }
        AttributeList attributeList = this.params.getAttribList();
        int n = attributeList.size();
        String[] stringArray = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        MBeanInfo mBeanInfo = null;
        mBeanInfo = webLogicMBean != null ? MBeanCommandLineInvoker.getMBeanInfo(webLogicMBean) : this.adminHome.getMBeanServer().getMBeanInfo(objectName);
        MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
        ModelMBeanAttributeInfo[] modelMBeanAttributeInfoArray = null;
        if (null != mBeanAttributeInfoArray && ModelMBeanAttributeInfo[].class.isAssignableFrom(mBeanAttributeInfoArray.getClass())) {
            modelMBeanAttributeInfoArray = (ModelMBeanAttributeInfo[])mBeanAttributeInfoArray;
        }
        if (0 != n) {
            for (int i = 0; i < n; ++i) {
                Attribute attribute = (Attribute)attributeList.get(i);
                if (attribute.getName().equals("MBeanInfo")) continue;
                boolean bl = false;
                if (null != modelMBeanAttributeInfoArray) {
                    for (int j = 0; j < modelMBeanAttributeInfoArray.length; ++j) {
                        if (!modelMBeanAttributeInfoArray[j].getName().equals(attribute.getName()) || !this.isExcluded(modelMBeanAttributeInfoArray[j]) || !this.params.exclude()) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) continue;
                arrayList.add(attribute.getName());
            }
        } else {
            for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
                if (mBeanAttributeInfoArray[i].getName().equals("MBeanInfo") || null == modelMBeanAttributeInfoArray || this.isExcluded(modelMBeanAttributeInfoArray[i]) && this.params.exclude()) continue;
                arrayList.add(mBeanAttributeInfoArray[i].getName());
            }
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private String getDefaultDomain() throws Exception {
        ServerRuntimeMBean serverRuntimeMBean = null;
        String string = "mydomain";
        try {
            Set set = this.adminHome.getMBeansByType("ServerRuntime");
            Iterator iterator = set.iterator();
            if (iterator.hasNext()) {
                serverRuntimeMBean = (ServerRuntimeMBean)iterator.next();
                string = serverRuntimeMBean.getObjectName().getDomain();
            }
        }
        catch (RemoteRuntimeException remoteRuntimeException) {
            Throwable throwable = remoteRuntimeException.getNestedException();
            if (throwable instanceof PeerGoneException) {
                return string;
            }
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!this.params.showNoMessages()) {
                AdminToolHelper.printException(managementTextTextFormatter.getRemExpServerRuntime(), (Exception)((Object)remoteRuntimeException));
            }
            throw remoteRuntimeException;
        }
        return string;
    }

    private String[] getMethodSignature(WebLogicMBean webLogicMBean, String string) throws InstanceNotFoundException, ConfigurationException {
        MBeanInfo mBeanInfo = MBeanCommandLineInvoker.getMBeanInfo(webLogicMBean);
        String[] stringArray = null;
        IllegalArgumentException illegalArgumentException = null;
        MBeanOperationInfo[] mBeanOperationInfoArray = mBeanInfo.getOperations();
        for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
            if (!mBeanOperationInfoArray[i].getName().equalsIgnoreCase(string)) continue;
            MBeanParameterInfo[] mBeanParameterInfoArray = mBeanOperationInfoArray[i].getSignature();
            stringArray = new String[mBeanParameterInfoArray.length];
            for (int j = 0; j < mBeanParameterInfoArray.length; ++j) {
                stringArray[j] = mBeanParameterInfoArray[j].getType();
            }
            try {
                Object[] objectArray = this.params.getMethodArguments(stringArray);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                illegalArgumentException = illegalArgumentException2;
                continue;
            }
            return stringArray;
        }
        if (null != illegalArgumentException) {
            throw illegalArgumentException;
        }
        ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
        throw new InstanceNotFoundException(managementTextTextFormatter.getInstanceMethNotFound(string, webLogicMBean.getObjectName().toString()));
    }

    public static MBeanInfo getMBeanInfo(WebLogicMBean webLogicMBean) throws ConfigurationException {
        return webLogicMBean.getMBeanInfo();
    }
}

