/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.commandline.tools;

import java.io.IOException;
import weblogic.management.configuration.MachineMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.ServerStartMBean;
import weblogic.nodemanager.mbean.NodeManagerRuntime;
import weblogic.nodemanager.mbean.NodeManagerTask;
import weblogic.utils.Debug;

public final class MigratableServerLifeCycleTask {
    private static final boolean DEBUG = true;
    private final int healthCheckInterval;
    private final MachineMBean machine;
    private final ServerStartMBean server;
    private final ServerMBean migServer;
    private final String migIPAddress;
    private final String serverName;
    private final String domainName;

    MigratableServerLifeCycleTask(ServerMBean serverMBean, String string) {
        this.migServer = serverMBean;
        this.serverName = this.migServer.getName();
        this.healthCheckInterval = serverMBean.getCluster().getHealthCheckIntervalMillis();
        this.migIPAddress = this.migServer.getListenAddress();
        this.server = this.migServer.getServerStart();
        this.machine = this.migServer.getMachine();
        this.domainName = string;
    }

    void startServer(MachineMBean machineMBean) throws IOException {
        NodeManagerTask nodeManagerTask = null;
        NodeManagerRuntime nodeManagerRuntime = NodeManagerRuntime.getInstance(machineMBean);
        nodeManagerTask = nodeManagerRuntime.start(this.migServer);
        while (!nodeManagerTask.isFinished()) {
            try {
                nodeManagerTask.waitForFinish();
            }
            catch (InterruptedException interruptedException) {}
        }
        String string = nodeManagerRuntime.getState(this.migServer);
        Debug.say((String)(this.serverName + " is now in " + string + " state"));
    }

    void isMachineReachable(MachineMBean machineMBean) throws IOException {
        NodeManagerRuntime nodeManagerRuntime = NodeManagerRuntime.getInstance(machineMBean);
        String string = nodeManagerRuntime.getState(this.migServer);
        Debug.say((String)(this.machine.getName() + " is reachable"));
    }

    void stopServer() throws IOException {
        Object var1_1 = null;
        NodeManagerRuntime nodeManagerRuntime = NodeManagerRuntime.getInstance(this.machine);
        nodeManagerRuntime.kill(this.migServer);
        Debug.say((String)(this.serverName + " is shutdown now"));
    }
}

