/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.commandline.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.naming.Context;
import weblogic.common.T3Client;
import weblogic.common.T3ExecuteException;
import weblogic.common.T3User;
import weblogic.management.MBeanHome;
import weblogic.management.WebLogicObjectName;
import weblogic.management.commandline.CommandLineArgs;
import weblogic.management.commandline.OutputFormatter;
import weblogic.management.commandline.tools.AdminToolHelper;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.internal.ManagementTextTextFormatter;
import weblogic.management.runtime.ServerLifeCycleRuntimeMBean;
import weblogic.management.runtime.ServerLifeCycleTaskRuntimeMBean;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.rjvm.PeerGoneException;
import weblogic.rmi.extensions.RemoteRuntimeException;
import weblogic.server.ServerLifecycleException;

public final class ServerAdminCommandLineInvoker {
    static final String OK_STRING = "Ok";
    static CommandLineArgs params = null;
    static PrintWriter printLog = null;
    static T3Client t3 = null;
    static AdminToolHelper toolHelper = null;
    MBeanHome adminHome = null;
    Context ctx = null;
    OutputFormatter out = null;
    private static boolean CONTINUE = true;
    private static PrintStream printStream = System.out;
    private boolean EXIT = false;

    public ServerAdminCommandLineInvoker(CommandLineArgs commandLineArgs, PrintStream printStream) throws Exception {
        try {
            params = commandLineArgs;
            if (printStream != null) {
                ServerAdminCommandLineInvoker.printStream = printStream;
            }
            toolHelper = new AdminToolHelper(commandLineArgs);
            this.doCommandline();
        }
        catch (Exception exception) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                AdminToolHelper.printException(exception);
            }
            throw exception;
        }
    }

    public ServerAdminCommandLineInvoker(String[] stringArray, PrintStream printStream, MBeanHome mBeanHome) throws Exception {
        params = new CommandLineArgs(stringArray);
        if (printStream != null) {
            ServerAdminCommandLineInvoker.printStream = printStream;
        }
        this.adminHome = mBeanHome;
        toolHelper = new AdminToolHelper(params);
        this.doCommandline();
    }

    public ServerAdminCommandLineInvoker(CommandLineArgs commandLineArgs, PrintStream printStream, MBeanHome mBeanHome) throws Exception {
        params = commandLineArgs;
        if (printStream != null) {
            ServerAdminCommandLineInvoker.printStream = printStream;
        }
        this.adminHome = mBeanHome;
        toolHelper = new AdminToolHelper(params);
        this.doCommandline();
    }

    public ServerAdminCommandLineInvoker(String[] stringArray, PrintStream printStream) throws Exception {
        this(new CommandLineArgs(stringArray), printStream);
    }

    public static void main(String[] stringArray) throws Exception {
        ServerAdminCommandLineInvoker serverAdminCommandLineInvoker = new ServerAdminCommandLineInvoker(stringArray, System.out);
    }

    static void connect(String string, T3User t3User) throws IOException, T3ExecuteException {
        try {
            t3 = new T3Client(string, t3User);
            t3.connect();
        }
        catch (UnknownHostException unknownHostException) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                AdminToolHelper.printErrorMessage(managementTextTextFormatter.getUnknownHost(string), CONTINUE);
            }
            throw unknownHostException;
        }
        catch (java.rmi.ConnectException connectException) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                AdminToolHelper.printErrorMessage(managementTextTextFormatter.getConnectFailedError(string), CONTINUE);
            }
            throw connectException;
        }
        catch (T3ExecuteException t3ExecuteException) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                AdminToolHelper.printErrorMessage(managementTextTextFormatter.getFailedConnect(string) + "[" + t3ExecuteException.getMessage() + "]", CONTINUE);
            }
            throw t3ExecuteException;
        }
        catch (IOException iOException) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                AdminToolHelper.printErrorMessage(managementTextTextFormatter.getFailedConnect(string) + " [" + iOException.getMessage() + "]", CONTINUE);
            }
            throw iOException;
        }
        catch (SecurityException securityException) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                AdminToolHelper.printErrorMessage(managementTextTextFormatter.getGuestDisabledException() + "\n", CONTINUE);
            }
            throw securityException;
        }
    }

    static void executeShutdownCommand(CommandLineArgs commandLineArgs) throws Exception {
        block41: {
            WebLogicObjectName webLogicObjectName;
            Iterator iterator;
            if (commandLineArgs.getOperation() == 26 && toolHelper.isNextArgInt(0)) {
                ServerAdminCommandLineInvoker.executeShutdownCommandOldSyntax(commandLineArgs);
            }
            AdminToolHelper.shutdownCommand = true;
            Context context = null;
            Object var3_2 = null;
            MBeanHome mBeanHome = null;
            MBeanHome mBeanHome2 = null;
            boolean bl = false;
            ServerMBean serverMBean = null;
            ServerMBean serverMBean2 = null;
            Object var9_8 = null;
            Object var10_9 = null;
            ServerRuntimeMBean serverRuntimeMBean = null;
            Object var12_11 = null;
            ServerLifeCycleRuntimeMBean serverLifeCycleRuntimeMBean = null;
            ServerLifeCycleTaskRuntimeMBean serverLifeCycleTaskRuntimeMBean = null;
            boolean bl2 = false;
            String string = null;
            boolean bl3 = false;
            String string2 = toolHelper.nextArg("", 0);
            try {
                try {
                    context = ServerAdminCommandLineInvoker.getInitialContext(commandLineArgs);
                }
                catch (Exception exception) {
                    ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                    if (!AdminToolHelper.printDone) {
                        AdminToolHelper.printDone = true;
                        System.err.println(managementTextTextFormatter.getFailedConnect(commandLineArgs.getURL()) + "[" + exception + "]");
                    }
                    throw exception;
                }
                mBeanHome = (MBeanHome)context.lookup("weblogic.management.home.localhome");
                iterator = mBeanHome.getMBeansByType("ServerRuntime").iterator();
                serverRuntimeMBean = (ServerRuntimeMBean)iterator.next();
                string = serverRuntimeMBean.getName();
                webLogicObjectName = new WebLogicObjectName(string, "ServerConfig", mBeanHome.getDomainName(), string);
                serverMBean2 = (ServerMBean)mBeanHome.getMBean((ObjectName)webLogicObjectName);
            }
            catch (Exception exception) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.err.println(managementTextTextFormatter.getExceptionMsg(exception.getMessage()));
                }
                throw exception;
            }
            try {
                ManagementTextTextFormatter managementTextTextFormatter;
                bl2 = string2.equals("") || string2.equals("-ignoreExistingSessions") || string2.equals("-timeout");
                if (serverRuntimeMBean.isAdminServer()) {
                    bl3 = true;
                    mBeanHome2 = mBeanHome;
                }
                if (!(bl3 || bl2 || string2.equals(string))) {
                    ManagementTextTextFormatter managementTextTextFormatter2 = new ManagementTextTextFormatter();
                    String string3 = managementTextTextFormatter2.getShuttingViaNonAdminNotAllowed();
                    System.err.println(string3);
                    AdminToolHelper.printDone = true;
                    throw new Exception(string3);
                }
                if (bl2 || string2.equals(string)) {
                    if (commandLineArgs.getOperation() == 26) {
                        try {
                            ManagementTextTextFormatter managementTextTextFormatter3 = new ManagementTextTextFormatter();
                            System.out.println("\n" + managementTextTextFormatter3.getShutdownSuccess(string));
                            System.out.flush();
                            serverRuntimeMBean.shutdown(commandLineArgs.getTimeout(), commandLineArgs.getIgnoreSessions());
                            System.out.println("\n" + managementTextTextFormatter3.getServerShutdownSuccessfully(string));
                            return;
                        }
                        catch (RemoteRuntimeException remoteRuntimeException) {
                            ManagementTextTextFormatter managementTextTextFormatter4 = new ManagementTextTextFormatter();
                            System.out.println("\n" + managementTextTextFormatter4.getServerShutdownSuccessfully(string));
                            System.out.flush();
                            return;
                        }
                        catch (ServerLifecycleException serverLifecycleException) {
                            ManagementTextTextFormatter managementTextTextFormatter5 = new ManagementTextTextFormatter();
                            if (!AdminToolHelper.printDone) {
                                AdminToolHelper.printDone = true;
                                System.err.println(managementTextTextFormatter5.getShuttingdownServerFailed(string));
                                System.out.flush();
                            }
                            throw serverLifecycleException;
                        }
                    }
                    try {
                        serverRuntimeMBean.forceShutdown();
                        ManagementTextTextFormatter managementTextTextFormatter6 = new ManagementTextTextFormatter();
                        System.out.println(managementTextTextFormatter6.getServerForceShutdownSuccessfully(string));
                        return;
                    }
                    catch (RemoteRuntimeException remoteRuntimeException) {
                        ManagementTextTextFormatter managementTextTextFormatter7 = new ManagementTextTextFormatter();
                        System.out.println(managementTextTextFormatter7.getServerForceShutdownSuccessfully(string));
                        return;
                    }
                    catch (ServerLifecycleException serverLifecycleException) {
                        ManagementTextTextFormatter managementTextTextFormatter8 = new ManagementTextTextFormatter();
                        if (!AdminToolHelper.printDone) {
                            AdminToolHelper.printDone = true;
                            System.err.println(managementTextTextFormatter8.getShuttingdownServerFailed(string));
                            System.out.flush();
                        }
                        throw serverLifecycleException;
                    }
                }
                if (!bl3) {
                    int n = commandLineArgs.getURL().indexOf(58);
                    String string4 = commandLineArgs.getURL().substring(0, n);
                    String string5 = serverRuntimeMBean.getAdminServerHost();
                    int n2 = serverRuntimeMBean.getAdminServerListenPort();
                    try {
                        context = ServerAdminCommandLineInvoker.getInitialContext(string4 + "://" + string5 + ":" + n2, commandLineArgs.getUsername(), commandLineArgs.getPassword());
                    }
                    catch (Exception exception) {
                        ManagementTextTextFormatter managementTextTextFormatter9 = new ManagementTextTextFormatter();
                        if (!AdminToolHelper.printDone) {
                            System.err.println(managementTextTextFormatter9.getShuttingdownServerFailed(string));
                            AdminToolHelper.printDone = true;
                        }
                        throw exception;
                    }
                    mBeanHome2 = (MBeanHome)context.lookup("weblogic.management.home.localhome");
                    iterator = mBeanHome2.getMBeansByType("ServerRuntime").iterator();
                    ServerRuntimeMBean serverRuntimeMBean2 = (ServerRuntimeMBean)iterator.next();
                    mBeanHome2 = (MBeanHome)context.lookup("weblogic.management.adminhome");
                    webLogicObjectName = new WebLogicObjectName(string, "Server", mBeanHome2.getDomainName());
                    try {
                        serverMBean = (ServerMBean)mBeanHome2.getMBean((ObjectName)webLogicObjectName);
                        string2 = string;
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {
                        ManagementTextTextFormatter managementTextTextFormatter10 = new ManagementTextTextFormatter();
                        System.err.println(managementTextTextFormatter10.getServerNotConfigured(string, mBeanHome2.getDomainName()));
                        AdminToolHelper.printDone = true;
                        throw instanceNotFoundException;
                    }
                }
                try {
                    mBeanHome2 = (MBeanHome)context.lookup("weblogic.management.adminhome");
                    if (bl2) {
                        serverMBean = serverMBean2;
                    } else {
                        webLogicObjectName = new WebLogicObjectName(string2, "Server", mBeanHome2.getDomainName());
                        serverMBean = (ServerMBean)mBeanHome2.getMBean((ObjectName)webLogicObjectName);
                    }
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    ManagementTextTextFormatter managementTextTextFormatter11 = new ManagementTextTextFormatter();
                    System.err.println(managementTextTextFormatter11.getServerNotConfigured(string2, mBeanHome2.getDomainName()));
                    AdminToolHelper.printDone = true;
                    throw instanceNotFoundException;
                }
                serverLifeCycleRuntimeMBean = (ServerLifeCycleRuntimeMBean)mBeanHome2.getMBean(serverMBean.getName(), "ServerLifeCycleRuntime", mBeanHome2.getDomainName());
                if (commandLineArgs.getOperation() == 26) {
                    managementTextTextFormatter = new ManagementTextTextFormatter();
                    System.out.println("\n" + managementTextTextFormatter.getShutdownSuccess(string2));
                    serverLifeCycleTaskRuntimeMBean = serverLifeCycleRuntimeMBean.shutdown(commandLineArgs.getTimeout(), commandLineArgs.getIgnoreSessions());
                } else {
                    serverLifeCycleTaskRuntimeMBean = serverLifeCycleRuntimeMBean.forceShutdown();
                }
                if (serverLifeCycleTaskRuntimeMBean != null && serverLifeCycleTaskRuntimeMBean.isRunning()) {
                    do {
                        Thread.sleep(1000L);
                    } while (serverLifeCycleTaskRuntimeMBean.isRunning());
                }
                printLog = new PrintWriter(System.out);
                if (serverLifeCycleTaskRuntimeMBean.getStatus().equals("TASK COMPLETED")) {
                    if (commandLineArgs.getOperation() == 26) {
                        managementTextTextFormatter = new ManagementTextTextFormatter();
                        System.out.println("\n" + managementTextTextFormatter.getServerShutdownSuccessfully(string2));
                    } else {
                        managementTextTextFormatter = new ManagementTextTextFormatter();
                        System.out.println(managementTextTextFormatter.getServerForceShutdownSuccessfully(string2));
                    }
                    break block41;
                }
                String string6 = "";
                if (serverLifeCycleTaskRuntimeMBean.getError() != null) {
                    managementTextTextFormatter = new ManagementTextTextFormatter();
                    string6 = managementTextTextFormatter.getExceptionMsg(serverLifeCycleTaskRuntimeMBean.getError().getMessage());
                }
                if (commandLineArgs.getOperation() == 26) {
                    managementTextTextFormatter = new ManagementTextTextFormatter();
                    System.err.println(managementTextTextFormatter.getShuttingdownServerFailed(string2));
                    AdminToolHelper.printDone = true;
                    System.err.println(string6);
                    throw new Exception();
                }
                managementTextTextFormatter = new ManagementTextTextFormatter();
                System.err.println(managementTextTextFormatter.getForceShuttingdownServerFailed(string2));
                System.err.println(string6);
                AdminToolHelper.printDone = true;
                throw new Exception();
            }
            catch (Exception exception) {
                if (!AdminToolHelper.printDone) {
                    ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                    System.err.println(managementTextTextFormatter.getExceptionMsg(exception.getMessage()));
                    AdminToolHelper.printDone = true;
                }
                throw exception;
            }
        }
    }

    static void executeShutdownCommandOldSyntax(CommandLineArgs commandLineArgs) throws Exception {
        AdminToolHelper.shutdownCommand = true;
        String string = "";
        String string2 = "";
        int n = toolHelper.nextArg(-1, 0);
        string = toolHelper.nextArg("", 1);
        try {
            ServerAdminCommandLineInvoker.connect(commandLineArgs.getURL(), new T3User(commandLineArgs.getUsername(), commandLineArgs.getPassword()));
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (commandLineArgs.isUsingBootProperties()) {
                MBeanHome mBeanHome = AdminToolHelper.getMBeanHome(commandLineArgs);
            }
            System.out.println(managementTextTextFormatter.getShutdownSequenceInitiated());
            string2 = ServerAdminCommandLineInvoker.t3.services.admin().shut(string, n);
            t3 = null;
        }
        catch (T3ExecuteException t3ExecuteException) {
            if (t3ExecuteException.getNestedException() instanceof SecurityException) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.out.println(managementTextTextFormatter.getConnSecException());
                }
                throw t3ExecuteException;
            }
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.out.println(managementTextTextFormatter.getFailShutdown(commandLineArgs.getURL()) + t3ExecuteException.getNestedException());
            }
            throw t3ExecuteException;
        }
        catch (ServerLifecycleException serverLifecycleException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.err.println(managementTextTextFormatter.getShuttingdownServerFailed(commandLineArgs.getURL()));
            }
            throw serverLifecycleException;
        }
        catch (SecurityException securityException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.out.println(managementTextTextFormatter.getConnSecException());
            }
            throw securityException;
        }
    }

    static HashSet setServerPropertiesFiles(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        return hashSet;
    }

    static HashSet setClusterPropertiesFiles(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        return hashSet;
    }

    static String[] getServerPropertiesFiles(HashSet hashSet) {
        if (hashSet == null) {
            return new String[0];
        }
        String[] stringArray = new String[hashSet.size()];
        stringArray = hashSet.toArray(stringArray);
        return stringArray;
    }

    static String[] getClusterPropertiesFiles(HashSet hashSet) {
        if (hashSet == null) {
            return new String[0];
        }
        String[] stringArray = new String[hashSet.size()];
        stringArray = hashSet.toArray(stringArray);
        return stringArray;
    }

    static String executeCancelShutCommand(CommandLineArgs commandLineArgs) throws Exception {
        System.out.println("This command has been removed.");
        String string = "This command has been removed";
        return string;
    }

    static String executeShutCommand(CommandLineArgs commandLineArgs) throws Exception {
        AdminToolHelper.shutdownCommand = true;
        int n = toolHelper.nextArg(-1, 0);
        String string = "";
        String string2 = "";
        string = toolHelper.nextArg("", 1);
        try {
            Object object;
            ServerAdminCommandLineInvoker.connect(commandLineArgs.getURL(), new T3User(commandLineArgs.getUsername(), commandLineArgs.getPassword()));
            if (commandLineArgs.isUsingBootProperties()) {
                object = AdminToolHelper.getMBeanHome(commandLineArgs);
            }
            object = new ManagementTextTextFormatter();
            System.out.println(object.getShutdownSequenceInitiated());
            string2 = ServerAdminCommandLineInvoker.t3.services.admin().shut(string, n);
            t3 = null;
            return string2;
        }
        catch (T3ExecuteException t3ExecuteException) {
            if (t3ExecuteException.getNestedException() instanceof SecurityException) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.out.println(managementTextTextFormatter.getConnSecException());
                }
                throw t3ExecuteException;
            }
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.out.println(managementTextTextFormatter.getFailShutdown(commandLineArgs.getURL()) + t3ExecuteException.getNestedException());
            }
            throw t3ExecuteException;
        }
        catch (SecurityException securityException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.out.println(managementTextTextFormatter.getConnSecException());
            }
            throw securityException;
        }
    }

    static void executeLockCommand(CommandLineArgs commandLineArgs) throws Exception {
        String string;
        Context context = null;
        MBeanHome mBeanHome = null;
        boolean bl = false;
        ServerMBean serverMBean = null;
        ServerLifeCycleRuntimeMBean serverLifeCycleRuntimeMBean = null;
        ServerLifeCycleTaskRuntimeMBean serverLifeCycleTaskRuntimeMBean = null;
        ServerRuntimeMBean serverRuntimeMBean = null;
        String string2 = null;
        try {
            try {
                context = ServerAdminCommandLineInvoker.getInitialContext(commandLineArgs);
            }
            catch (Exception exception) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.err.println(managementTextTextFormatter.getFailedConnect(commandLineArgs.getURL()) + "[" + exception + "]");
                }
                throw exception;
            }
            mBeanHome = (MBeanHome)context.lookup("weblogic.management.home.localhome");
            string = mBeanHome.getMBeanServer().getServerName();
            serverRuntimeMBean = (ServerRuntimeMBean)mBeanHome.getMBean(string, "ServerRuntime", mBeanHome.getDomainName(), string);
            serverMBean = (ServerMBean)mBeanHome.getMBean(string, "Server");
            serverLifeCycleRuntimeMBean = (ServerLifeCycleRuntimeMBean)mBeanHome.getMBean(serverMBean.getName(), "ServerLifeCycleRuntime", mBeanHome.getActiveDomain().getName());
            string2 = serverRuntimeMBean.getName();
            string2 = serverLifeCycleRuntimeMBean.getName();
        }
        catch (Exception exception) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                AdminToolHelper.printException(exception);
            }
            throw exception;
        }
        try {
            serverLifeCycleTaskRuntimeMBean = serverLifeCycleRuntimeMBean.suspend();
            if (serverLifeCycleTaskRuntimeMBean != null && serverLifeCycleTaskRuntimeMBean.isRunning()) {
                do {
                    Thread.sleep(1000L);
                } while (serverLifeCycleTaskRuntimeMBean.isRunning());
            }
            if (serverLifeCycleTaskRuntimeMBean.getStatus().equals("TASK COMPLETED")) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                System.out.println(managementTextTextFormatter.getLockSuccess(string2));
                return;
            }
            string = "";
            if (serverLifeCycleTaskRuntimeMBean.getError() != null) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                string = managementTextTextFormatter.getExceptionMsg(serverLifeCycleTaskRuntimeMBean.getError().getMessage());
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    AdminToolHelper.printErrorMessage(string, false);
                }
                throw new Exception();
            }
        }
        catch (Exception exception) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            System.err.println(managementTextTextFormatter.getLockFailed(string2));
            managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.err.println(managementTextTextFormatter.getExceptionMsg(exception.getMessage()));
            }
            throw exception;
        }
    }

    static void executeOldLockCommand(CommandLineArgs commandLineArgs) throws Exception {
        System.out.println("This command has been deprecated and removed. Please use suspend instead");
    }

    static void executeOldUnLockCommand(CommandLineArgs commandLineArgs) throws Exception {
        System.out.println("This command has been deprecated and removed. Please use resume instead");
    }

    static void executeUnLockCommand(CommandLineArgs commandLineArgs) throws Exception {
        String string;
        Context context = null;
        MBeanHome mBeanHome = null;
        boolean bl = false;
        Object var5_4 = null;
        ServerRuntimeMBean serverRuntimeMBean = null;
        ServerLifeCycleRuntimeMBean serverLifeCycleRuntimeMBean = null;
        ServerLifeCycleTaskRuntimeMBean serverLifeCycleTaskRuntimeMBean = null;
        String string2 = null;
        try {
            try {
                context = ServerAdminCommandLineInvoker.getInitialContext(commandLineArgs);
            }
            catch (Exception exception) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.err.println(managementTextTextFormatter.getFailedConnect(commandLineArgs.getURL()) + "[" + exception + "]");
                }
                throw exception;
            }
            mBeanHome = (MBeanHome)context.lookup("weblogic.management.home.localhome");
            string = mBeanHome.getMBeanServer().getServerName();
            serverRuntimeMBean = (ServerRuntimeMBean)mBeanHome.getMBean(string, "ServerRuntime", mBeanHome.getDomainName(), string);
            serverLifeCycleRuntimeMBean = (ServerLifeCycleRuntimeMBean)mBeanHome.getMBean(string, "ServerLifeCycleRuntime");
            string2 = serverLifeCycleRuntimeMBean.getName();
        }
        catch (Exception exception) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.err.println(managementTextTextFormatter.getExceptionMsg(exception.getMessage()));
            }
            throw exception;
        }
        try {
            serverLifeCycleTaskRuntimeMBean = serverLifeCycleRuntimeMBean.resume();
            if (serverLifeCycleTaskRuntimeMBean.getStatus().equals("TASK COMPLETED")) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                System.out.println(managementTextTextFormatter.getUnLockSuccess(string2));
                return;
            }
            string = "";
            if (serverLifeCycleTaskRuntimeMBean.getError() != null) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                string = managementTextTextFormatter.getExceptionMsg(serverLifeCycleTaskRuntimeMBean.getError().getMessage());
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    AdminToolHelper.printErrorMessage(string, false);
                }
                throw new Exception();
            }
        }
        catch (Exception exception) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            System.err.println(managementTextTextFormatter.getUnlockFail(string2));
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                AdminToolHelper.printException(exception);
            }
            throw exception;
        }
    }

    static void executeStartCommand(CommandLineArgs commandLineArgs) throws Exception {
        Context context = null;
        ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
        String string = toolHelper.nextArg("", 0);
        try {
            ServerLifeCycleTaskRuntimeMBean serverLifeCycleTaskRuntimeMBean;
            if (string.equals("")) {
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.err.println(managementTextTextFormatter.getServerNameArgRequired());
                }
                throw new Exception();
            }
            try {
                context = ServerAdminCommandLineInvoker.getInitialContext(commandLineArgs);
            }
            catch (Exception exception) {
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.err.println(managementTextTextFormatter.getFailedConnect(commandLineArgs.getURL()) + "[" + exception + "]");
                }
                throw exception;
            }
            MBeanHome mBeanHome = (MBeanHome)context.lookup("weblogic.management.home.localhome");
            Iterator iterator = mBeanHome.getMBeansByType("ServerRuntime").iterator();
            ServerRuntimeMBean serverRuntimeMBean = (ServerRuntimeMBean)iterator.next();
            String string2 = serverRuntimeMBean.getName();
            if (!serverRuntimeMBean.isAdminServer()) {
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.err.println(managementTextTextFormatter.getAdminServerUrlRequired(commandLineArgs.getURL()));
                }
                throw new Exception();
            }
            if (string2.equals(string)) {
                System.err.println(managementTextTextFormatter.getServerAlreadyRunning(string));
                return;
            }
            boolean bl = false;
            ServerMBean serverMBean2 = null;
            for (ServerMBean serverMBean2 : mBeanHome.getMBeansByType("Server")) {
                if (!serverMBean2.getName().equals(string)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.err.println(managementTextTextFormatter.getServerNotConfigured(string, mBeanHome.getDomainName()));
                }
                throw new Exception();
            }
            ServerLifeCycleRuntimeMBean serverLifeCycleRuntimeMBean = (ServerLifeCycleRuntimeMBean)mBeanHome.getMBean(serverMBean2.getName(), "ServerLifeCycleRuntime", mBeanHome.getActiveDomain().getName());
            if (commandLineArgs.getOperation() == 21) {
                serverLifeCycleTaskRuntimeMBean = serverLifeCycleRuntimeMBean.start();
            } else {
                System.out.println(managementTextTextFormatter.getStartInStandbyModeDeperecated());
                serverLifeCycleTaskRuntimeMBean = serverLifeCycleRuntimeMBean.start();
            }
            if (serverLifeCycleTaskRuntimeMBean != null && serverLifeCycleTaskRuntimeMBean.isRunning()) {
                do {
                    Thread.sleep(1000L);
                } while (serverLifeCycleTaskRuntimeMBean.isRunning());
            }
            printLog = new PrintWriter(System.out);
            if (!serverLifeCycleTaskRuntimeMBean.getStatus().equals("TASK COMPLETED")) {
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.out.println(managementTextTextFormatter.getStartingServerFailed(string));
                    if (serverLifeCycleTaskRuntimeMBean.getError() != null) {
                        System.err.println(managementTextTextFormatter.getExceptionMsg(serverLifeCycleTaskRuntimeMBean.getError().getMessage()));
                    }
                }
                throw new Exception();
            }
            System.out.println(managementTextTextFormatter.getServerStartedSuccessfully(string));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.err.println(managementTextTextFormatter.getExceptionMsg(instanceNotFoundException.getMessage()));
            }
            throw instanceNotFoundException;
        }
        catch (SecurityException securityException) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.err.println(managementTextTextFormatter.getExceptionMsg(securityException.getMessage()));
            }
            throw securityException;
        }
        catch (Exception exception) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.err.println(managementTextTextFormatter.getExceptionMsg(exception.getMessage()));
            }
            throw exception;
        }
    }

    static void executeResumeCommand(CommandLineArgs commandLineArgs) throws Exception {
        Context context = null;
        MBeanHome mBeanHome = null;
        boolean bl = false;
        ServerMBean serverMBean = null;
        ServerRuntimeMBean serverRuntimeMBean = null;
        ServerLifeCycleTaskRuntimeMBean serverLifeCycleTaskRuntimeMBean = null;
        String string = null;
        String string2 = toolHelper.nextArg("", 0);
        try {
            try {
                context = ServerAdminCommandLineInvoker.getInitialContext(commandLineArgs);
            }
            catch (Exception exception) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.err.println(managementTextTextFormatter.getFailedConnect(commandLineArgs.getURL()) + "[" + exception + "]");
                }
                throw exception;
            }
            mBeanHome = (MBeanHome)context.lookup("weblogic.management.home.localhome");
            Iterator iterator = mBeanHome.getMBeansByType("ServerRuntime").iterator();
            serverRuntimeMBean = (ServerRuntimeMBean)iterator.next();
            string = serverRuntimeMBean.getName();
        }
        catch (Exception exception) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.err.println(managementTextTextFormatter.getExceptionMsg(exception.getMessage()));
            }
            throw exception;
        }
        try {
            if (string2.equals("") || string2.equals(string)) {
                try {
                    serverRuntimeMBean.resume();
                    ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                    System.out.println(managementTextTextFormatter.getServerResumedSuccessfully(string));
                    return;
                }
                catch (Exception exception) {
                    ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                    System.err.println(managementTextTextFormatter.getResumingServerFailed(string));
                    managementTextTextFormatter = new ManagementTextTextFormatter();
                    if (!AdminToolHelper.printDone) {
                        AdminToolHelper.printDone = true;
                        System.err.println(managementTextTextFormatter.getExceptionMsg(exception.getMessage()));
                    }
                    throw exception;
                }
            }
            if (!serverRuntimeMBean.isAdminServer()) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.err.println(managementTextTextFormatter.getUrlOfAdminServerRequired(commandLineArgs.getURL()));
                }
                throw new Exception();
            }
            try {
                serverMBean = (ServerMBean)mBeanHome.getMBean(string2, "Server", mBeanHome.getDomainName());
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.err.println(managementTextTextFormatter.getServerNotConfigured(string2, mBeanHome.getDomainName()));
                }
                throw instanceNotFoundException;
            }
            ServerLifeCycleRuntimeMBean serverLifeCycleRuntimeMBean = (ServerLifeCycleRuntimeMBean)mBeanHome.getMBean(serverMBean.getName(), "ServerLifeCycleRuntime", mBeanHome.getActiveDomain().getName());
            serverLifeCycleTaskRuntimeMBean = serverLifeCycleRuntimeMBean.resume();
            if (serverLifeCycleTaskRuntimeMBean != null && serverLifeCycleTaskRuntimeMBean.isRunning()) {
                do {
                    Thread.sleep(1000L);
                } while (serverLifeCycleTaskRuntimeMBean.isRunning());
            }
            printLog = new PrintWriter(System.out);
            if (!serverLifeCycleTaskRuntimeMBean.getStatus().equals("TASK COMPLETED")) {
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                    System.err.println(managementTextTextFormatter.getResumingServerFailed(string2));
                    if (serverLifeCycleTaskRuntimeMBean.getError() != null) {
                        managementTextTextFormatter = new ManagementTextTextFormatter();
                        System.err.println(managementTextTextFormatter.getExceptionMsg(serverLifeCycleTaskRuntimeMBean.getError().getMessage()));
                    }
                }
                throw new Exception();
            }
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            System.out.println(managementTextTextFormatter.getServerResumedSuccessfully(string2));
        }
        catch (SecurityException securityException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.err.println(managementTextTextFormatter.getExceptionMsg(securityException.getMessage()));
            }
            throw securityException;
        }
        catch (Exception exception) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.err.println(managementTextTextFormatter.getExceptionMsg(exception.getMessage()));
            }
            throw exception;
        }
    }

    void doOperation() throws Exception {
        String string = "";
        switch (params.getOperation()) {
            case 4: {
                string = ServerAdminCommandLineInvoker.executeShutCommand(params);
                break;
            }
            case 11: {
                string = ServerAdminCommandLineInvoker.executeCancelShutCommand(params);
                break;
            }
            case 8: {
                ServerAdminCommandLineInvoker.executeLockCommand(params);
                break;
            }
            case 9: {
                ServerAdminCommandLineInvoker.executeOldUnLockCommand(params);
                break;
            }
            case 21: 
            case 22: {
                ServerAdminCommandLineInvoker.executeStartCommand(params);
                break;
            }
            case 25: {
                ServerAdminCommandLineInvoker.executeResumeCommand(params);
                break;
            }
            case 26: 
            case 27: {
                ServerAdminCommandLineInvoker.executeShutdownCommand(params);
                break;
            }
            case 43: {
                throw new UnsupportedOperationException(" Discover Managed Server is not supported in WLS 9.0.0.0");
            }
        }
        System.out.println(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doCommandline() throws Exception {
        try {
            if (this.adminHome == null) {
                if (params.getAdminUrl() != null) {
                    params.setUrl(params.getAdminUrl());
                    this.adminHome = AdminToolHelper.getAdminMBeanHome(params);
                } else {
                    this.adminHome = AdminToolHelper.getMBeanHome(params);
                }
            }
            this.out = new OutputFormatter(printStream, params.isPretty());
            this.doOperation();
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (AdminToolHelper.printDone) throw illegalArgumentException;
            AdminToolHelper.printException(illegalArgumentException);
            AdminToolHelper.printDone = true;
            throw illegalArgumentException;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printException(malformedObjectNameException, true);
                AdminToolHelper.printDone = true;
            }
            printStream.println("Usage:\n" + CommandLineArgs.getUsageString());
            throw malformedObjectNameException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (AdminToolHelper.printDone) throw instanceNotFoundException;
            printStream.println(managementTextTextFormatter.getCouldNotFindInstance(params.getMBeanObjName()));
            AdminToolHelper.printDone = true;
            throw instanceNotFoundException;
        }
        catch (RemoteRuntimeException remoteRuntimeException) {
            Throwable throwable = remoteRuntimeException.getNestedException();
            if (throwable instanceof PeerGoneException) {
                return;
            }
            if (AdminToolHelper.printDone) throw remoteRuntimeException;
            AdminToolHelper.printException((Exception)((Object)remoteRuntimeException), true);
            AdminToolHelper.printDone = true;
            throw remoteRuntimeException;
        }
        catch (ConnectException connectException) {
            if (AdminToolHelper.printDone) throw connectException;
            AdminToolHelper.printException("java.net.ConnectException", connectException);
            AdminToolHelper.printDone = true;
            throw connectException;
        }
        catch (IOException iOException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (AdminToolHelper.printDone) throw iOException;
            AdminToolHelper.printException(managementTextTextFormatter.getErrorWriting(), iOException);
            AdminToolHelper.printDone = true;
            throw iOException;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeOperationsException) {
                RuntimeOperationsException runtimeOperationsException = (RuntimeOperationsException)exception;
                if (!(runtimeOperationsException.getTargetException() instanceof RemoteRuntimeException)) return;
            }
            if (exception instanceof ClassCastException) {
                return;
            }
            if (params.showNoMessages() || AdminToolHelper.printDone) throw exception;
            AdminToolHelper.printException(exception);
            AdminToolHelper.printDone = true;
            throw exception;
        }
    }

    private static Context getInitialContext(String string, String string2, String string3) throws Exception {
        return AdminToolHelper.getInitialContext(string, string2, string3);
    }

    private static Context getInitialContext(CommandLineArgs commandLineArgs) throws Exception {
        return AdminToolHelper.getInitialContext(commandLineArgs);
    }
}

