/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.commandline.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.management.InstanceNotFoundException;
import javax.management.RuntimeOperationsException;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import weblogic.common.T3Client;
import weblogic.common.T3ExecuteException;
import weblogic.common.T3User;
import weblogic.jndi.Environment;
import weblogic.management.MBeanHome;
import weblogic.management.commandline.CommandLineArgs;
import weblogic.management.commandline.OutputFormatter;
import weblogic.management.commandline.tools.AdminToolHelper;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.internal.ManagementTextTextFormatter;
import weblogic.management.runtime.ServerLifeCycleRuntimeMBean;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.rjvm.PeerGoneException;
import weblogic.rmi.extensions.RemoteRuntimeException;

public final class ServerInfoCommandLineInvoker {
    static final String OK_STRING = "Ok";
    private static final int TIME_ROUNDOFF = 1;
    private static final int TIME_TRUNCATE = 2;
    static CommandLineArgs params = null;
    static T3Client t3 = null;
    static AdminToolHelper toolHelper = null;
    MBeanHome adminHome = null;
    Context ctx = null;
    OutputFormatter out = null;
    private static boolean CONTINUE = true;
    private static PrintStream printStream = System.out;
    private boolean EXIT = false;
    private boolean batchMode = false;

    public ServerInfoCommandLineInvoker(CommandLineArgs commandLineArgs, PrintStream printStream) throws Exception {
        try {
            params = commandLineArgs;
            if (printStream != null) {
                ServerInfoCommandLineInvoker.printStream = printStream;
            }
            toolHelper = new AdminToolHelper(commandLineArgs);
            this.doCommandline();
        }
        catch (Exception exception) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                AdminToolHelper.printException(exception);
            }
            throw exception;
        }
    }

    public ServerInfoCommandLineInvoker(String[] stringArray, PrintStream printStream, MBeanHome mBeanHome) throws Exception {
        params = new CommandLineArgs(stringArray);
        if (printStream != null) {
            ServerInfoCommandLineInvoker.printStream = printStream;
        }
        this.adminHome = mBeanHome;
        toolHelper = new AdminToolHelper(params);
        this.doCommandline();
    }

    public ServerInfoCommandLineInvoker(CommandLineArgs commandLineArgs, PrintStream printStream, MBeanHome mBeanHome) throws Exception {
        params = commandLineArgs;
        if (printStream != null) {
            ServerInfoCommandLineInvoker.printStream = printStream;
        }
        this.adminHome = mBeanHome;
        toolHelper = new AdminToolHelper(params);
        this.doCommandline();
    }

    public ServerInfoCommandLineInvoker(String[] stringArray, PrintStream printStream) throws Exception {
        this(new CommandLineArgs(stringArray), printStream);
    }

    public static void main(String[] stringArray) throws Exception {
        ServerInfoCommandLineInvoker serverInfoCommandLineInvoker = new ServerInfoCommandLineInvoker(stringArray, System.out);
    }

    static String executeCommandConnect(CommandLineArgs commandLineArgs) throws Exception {
        int n = toolHelper.nextArg(1, 0);
        String string = "";
        long l = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            long l2 = System.currentTimeMillis();
            Context context = ServerInfoCommandLineInvoker.getInitialContext(commandLineArgs);
            long l3 = System.currentTimeMillis() - l2;
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            System.out.println(managementTextTextFormatter.getConnectOutput(i, l3));
        }
        long l4 = System.currentTimeMillis() - l;
        string = "  RTT = ~" + l4 + " milliseconds, or ~" + l4 / (long)n + " milliseconds/connection";
        return string;
    }

    static String executePingCommand(CommandLineArgs commandLineArgs) throws Exception {
        String string = "";
        int n = toolHelper.nextArg(1, 0);
        int n2 = toolHelper.nextArg(100, 1);
        if (t3 == null) {
            ServerInfoCommandLineInvoker.connect(commandLineArgs.getURL(), new T3User(commandLineArgs.getUsername(), commandLineArgs.getPassword()));
        }
        if (n == 0) {
            string = "0 pings sent";
        } else {
            byte[] byArray = new byte[n2];
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            String string2 = n != 1 ? managementTextTextFormatter.getPluralPing() : managementTextTextFormatter.getSingularPing();
            String string3 = n2 != 1 ? managementTextTextFormatter.getPluralByte() : managementTextTextFormatter.getSingularByte();
            System.out.println(managementTextTextFormatter.getPingCount(n, string2, n2, string3));
            long l = System.currentTimeMillis();
            for (int i = 0; i < n; ++i) {
                ServerInfoCommandLineInvoker.t3.services.admin().ping(byArray);
            }
            long l2 = System.currentTimeMillis() - l;
            string = "  RTT = ~" + l2 + " milliseconds, or ~" + l2 / (long)n + " milliseconds/packet";
        }
        return string;
    }

    static String executeVersionCommand(CommandLineArgs commandLineArgs) throws Exception {
        String string = "";
        Context context = null;
        MBeanHome mBeanHome = null;
        ServerRuntimeMBean serverRuntimeMBean = null;
        try {
            try {
                context = ServerInfoCommandLineInvoker.getInitialContext(commandLineArgs);
            }
            catch (Exception exception) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.err.println(managementTextTextFormatter.getFailedConnect(ServerInfoCommandLineInvoker.getURL()) + "[" + exception + "]");
                }
                throw exception;
            }
            mBeanHome = (MBeanHome)context.lookup("weblogic.management.home.localhome");
            Iterator iterator = mBeanHome.getMBeansByType("ServerRuntime").iterator();
            serverRuntimeMBean = (ServerRuntimeMBean)iterator.next();
            string = serverRuntimeMBean.getWeblogicVersion();
            return string;
        }
        catch (Exception exception) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.err.println(managementTextTextFormatter.getExceptionMsg(exception.getMessage()));
            }
            throw exception;
        }
    }

    static void executeGetStateCommand(CommandLineArgs commandLineArgs) throws Exception {
        Context context = null;
        MBeanHome mBeanHome = null;
        boolean bl = false;
        ServerMBean serverMBean = null;
        ServerRuntimeMBean serverRuntimeMBean = null;
        String string = null;
        String string2 = toolHelper.nextArg("", 0);
        try {
            try {
                context = ServerInfoCommandLineInvoker.getInitialContext(commandLineArgs);
            }
            catch (Exception exception) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.err.println(managementTextTextFormatter.getFailedConnect(ServerInfoCommandLineInvoker.getURL()) + "[" + exception + "]");
                }
                throw exception;
            }
            mBeanHome = (MBeanHome)context.lookup("weblogic.management.home.localhome");
            Iterator iterator = mBeanHome.getMBeansByType("ServerRuntime").iterator();
            serverRuntimeMBean = (ServerRuntimeMBean)iterator.next();
            string = serverRuntimeMBean.getName();
        }
        catch (Exception exception) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.err.println(managementTextTextFormatter.getExceptionMsg(exception.getMessage()));
            }
            throw exception;
        }
        try {
            if (string2.equals("") || string2.equals(string)) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.out.println(managementTextTextFormatter.getCurrentStateOfServer(string, serverRuntimeMBean.getState()));
                }
                return;
            }
            if (!serverRuntimeMBean.isAdminServer()) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.err.println(managementTextTextFormatter.getUrlOfAdminServerRequired(ServerInfoCommandLineInvoker.getURL()));
                }
                throw new Exception();
            }
            try {
                serverMBean = (ServerMBean)mBeanHome.getMBean(string2, "Server", mBeanHome.getDomainName());
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.err.println(managementTextTextFormatter.getServerNotConfigured(string2, mBeanHome.getDomainName()));
                }
                throw instanceNotFoundException;
            }
            catch (Exception exception) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.err.println(managementTextTextFormatter.getExceptionMsg(exception.getMessage()));
                }
                throw exception;
            }
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            ServerLifeCycleRuntimeMBean serverLifeCycleRuntimeMBean = (ServerLifeCycleRuntimeMBean)mBeanHome.getMBean(serverMBean.getName(), "ServerLifeCycleRuntime", mBeanHome.getActiveDomain().getName());
            System.out.println(managementTextTextFormatter.getCurrentStateOfServer(string2, serverLifeCycleRuntimeMBean.getState()));
        }
        catch (Exception exception) {
            if (serverMBean == null) {
                throw exception;
            }
            if (serverMBean.getExpectedToRun()) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                System.out.println(managementTextTextFormatter.getCurrentStateOfServer(string2, "UNKNOWN"));
            }
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            System.out.println(managementTextTextFormatter.getCurrentStateOfServer(string2, "SHUTDOWN"));
        }
    }

    static void executeListCommand(CommandLineArgs commandLineArgs) throws Exception {
        String string;
        Environment environment = new Environment();
        String string2 = toolHelper.nextArg("", 0);
        if (commandLineArgs.getUsername().length() != 0) {
            environment.setSecurityPrincipal(commandLineArgs.getUsername());
            environment.setSecurityCredentials(commandLineArgs.getPassword());
        }
        if ((string = commandLineArgs.getURL()).startsWith("iiop")) {
            string = "t3" + string.substring(4);
        }
        environment.setProviderUrl(string);
        try {
            Context context = environment.getInitialContext();
            NamingEnumeration<NameClassPair> namingEnumeration = context.list(string2);
            if (namingEnumeration.hasMoreElements()) {
                String string3 = string2.length() == 0 ? "InitialContext" : string2;
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                System.out.println(managementTextTextFormatter.getContents(string3));
                while (namingEnumeration.hasMoreElements()) {
                    System.out.println("  " + namingEnumeration.nextElement());
                }
            }
        }
        catch (CommunicationException communicationException) {
            Throwable throwable = communicationException.getRootCause();
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.err.println(managementTextTextFormatter.getFailedConnect(ServerInfoCommandLineInvoker.getURL()) + " [" + throwable.getMessage() + "]");
            }
            if (commandLineArgs.isVerbose()) {
                communicationException.printStackTrace();
            }
            throw communicationException;
        }
        catch (AuthenticationException authenticationException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.out.println(managementTextTextFormatter.getAuthException());
            }
            throw authenticationException;
        }
        catch (SecurityException securityException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.out.println(managementTextTextFormatter.getSecException());
            }
            throw securityException;
        }
        catch (NamingException namingException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.out.println(managementTextTextFormatter.getFailBinding(namingException.getMessage()));
                namingException.printStackTrace();
            }
            if (commandLineArgs.isVerbose()) {
                namingException.printStackTrace();
            }
            throw namingException;
        }
    }

    static void executeThreadDumpCommand(CommandLineArgs commandLineArgs) throws Exception {
        ServerInfoCommandLineInvoker.connect(commandLineArgs.getURL(), new T3User(commandLineArgs.getUsername(), commandLineArgs.getPassword()));
        try {
            ServerInfoCommandLineInvoker.t3.services.admin().threadDump();
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            System.out.println(managementTextTextFormatter.getThreadDumpAvailable());
        }
        catch (T3ExecuteException t3ExecuteException) {
            if (t3ExecuteException.getNestedException().toString().indexOf("SecurityException") != -1) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.out.println(managementTextTextFormatter.getSecExceptionThreadDump());
                }
                throw t3ExecuteException;
            }
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.out.println(managementTextTextFormatter.getFailThreadDump() + t3ExecuteException.getNestedException().toString());
            }
            throw t3ExecuteException;
        }
    }

    static void connect(String string, T3User t3User) throws IOException, T3ExecuteException {
        try {
            if (string.startsWith("iiop")) {
                string = "t3" + string.substring(4);
            }
            t3 = new T3Client(string, t3User);
            t3.connect();
        }
        catch (UnknownHostException unknownHostException) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                AdminToolHelper.printErrorMessage(managementTextTextFormatter.getUnknownHost(string), CONTINUE);
            }
            throw unknownHostException;
        }
        catch (java.rmi.ConnectException connectException) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                AdminToolHelper.printErrorMessage(managementTextTextFormatter.getConnectFailedError(string), CONTINUE);
            }
            throw connectException;
        }
        catch (T3ExecuteException t3ExecuteException) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                AdminToolHelper.printErrorMessage(managementTextTextFormatter.getFailedConnect(string) + "[" + t3ExecuteException.getMessage() + "]", CONTINUE);
            }
            throw t3ExecuteException;
        }
        catch (IOException iOException) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                AdminToolHelper.printErrorMessage(managementTextTextFormatter.getFailedConnect(string) + " [" + iOException.getMessage() + "]", CONTINUE);
            }
            throw iOException;
        }
        catch (SecurityException securityException) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                AdminToolHelper.printErrorMessage(managementTextTextFormatter.getGuestDisabledException() + "\n", CONTINUE);
            }
            throw securityException;
        }
    }

    void doOperation() throws Exception {
        String string = "";
        switch (params.getOperation()) {
            case 7: {
                string = ServerInfoCommandLineInvoker.executeCommandConnect(params);
                break;
            }
            case 2: {
                string = ServerInfoCommandLineInvoker.executePingCommand(params);
                break;
            }
            case 6: {
                string = ServerInfoCommandLineInvoker.executeVersionCommand(params);
                break;
            }
            case 10: {
                ServerInfoCommandLineInvoker.executeListCommand(params);
                break;
            }
            case 18: {
                ServerInfoCommandLineInvoker.executeThreadDumpCommand(params);
                break;
            }
            case 19: {
                ServerInfoCommandLineInvoker.executeCommandServerLog();
                break;
            }
            case 28: {
                ServerInfoCommandLineInvoker.executeGetStateCommand(params);
            }
        }
        System.out.println("\n" + string);
    }

    private static void executeCommandServerLog() throws Exception {
        String string = params.getHttpURL();
        String string2 = toolHelper.nextArg("", 0);
        String string3 = toolHelper.nextArg("", 1);
        Date date = ServerInfoCommandLineInvoker.convStr2Date(string2, 2);
        Date date2 = ServerInfoCommandLineInvoker.convStr2Date(string3, 1);
        String string4 = params.getUsername();
        String string5 = params.getPassword();
        String string6 = "logicalName=ServerLog";
        String string7 = null;
        if (date != null) {
            string7 = "beginTimestamp=" + date.getTime();
        }
        String string8 = null;
        if (date2 != null) {
            string8 = "endTimestamp=" + date2.getTime();
        }
        String string9 = string + "/" + "bea_wls_diagnostics" + "/" + "accessor" + "?" + string6;
        if (string7 != null) {
            string9 = string9 + "&" + string7;
        }
        if (string8 != null) {
            string9 = string9 + "&" + string8;
        }
        System.err.println("Query = " + string9);
        URL uRL = new URL(string9);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestProperty("username", string4);
        httpURLConnection.setRequestProperty("password", string5);
        httpURLConnection.setDoOutput(false);
        httpURLConnection.setDoInput(true);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
        }
        catch (Exception exception) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            System.out.println("\n" + managementTextTextFormatter.getGettingLogFileError() + exception.getMessage());
            AdminToolHelper.printDone = true;
            throw new Exception(managementTextTextFormatter.getGettingLogFileError() + exception.getMessage());
        }
        String string10 = null;
        try {
            while (null != (string10 = bufferedReader.readLine())) {
                System.out.println(string10);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static String augmentDate(String string, String string2, int n) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":/- ");
        switch (stringTokenizer.countTokens()) {
            case 0: {
                return string;
            }
            case 1: {
                calendar.set(11, Integer.parseInt(stringTokenizer.nextToken()));
                switch (n) {
                    case 2: {
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        break;
                    }
                    case 1: {
                        calendar.set(12, 59);
                        calendar.set(13, 59);
                        break;
                    }
                }
                return simpleDateFormat.format(calendar.getTime()).toString();
            }
            case 2: {
                if (0 < string.indexOf("/")) {
                    calendar.set(2, Integer.parseInt(stringTokenizer.nextToken()) - 1);
                    calendar.set(5, Integer.parseInt(stringTokenizer.nextToken()));
                    switch (n) {
                        case 2: {
                            calendar.set(11, 0);
                            calendar.set(12, 0);
                            calendar.set(13, 0);
                            break;
                        }
                        case 1: {
                            calendar.set(11, 23);
                            calendar.set(12, 59);
                            calendar.set(13, 59);
                            break;
                        }
                    }
                } else {
                    calendar.set(11, Integer.parseInt(stringTokenizer.nextToken()));
                    calendar.set(12, Integer.parseInt(stringTokenizer.nextToken()));
                    switch (n) {
                        case 2: {
                            calendar.set(13, 0);
                            break;
                        }
                        case 1: {
                            calendar.set(13, 59);
                            break;
                        }
                    }
                }
                return simpleDateFormat.format(calendar.getTime()).toString();
            }
        }
        return string;
    }

    private static Date convStr2Date(String string, int n) {
        String[] stringArray = new String[]{"yyyy MM dd HH mm ss", "yyyy MM dd HH mm", "yyyy MM dd HH", "yyyy MM dd", "MMM dd yyyy HH mm ss", "MMM dd yyyy HH mm", "MMM dd yyyy HH", "MMM dd yyyy"};
        Date date = null;
        String string2 = null;
        string2 = ServerInfoCommandLineInvoker.augmentDate(string, stringArray[0], n);
        String string3 = string2.trim();
        if (string3.equals("")) {
            return null;
        }
        string3 = string3.replace('/', ' ');
        string3 = string3.replace('-', ' ');
        string3 = string3.replace(':', ' ');
        string3 = string3.replace(',', ' ');
        Calendar calendar = Calendar.getInstance();
        ParsePosition parsePosition = new ParsePosition(0);
        for (int i = 0; i < stringArray.length && null == date; ++i) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(stringArray[i]);
            simpleDateFormat.setCalendar(calendar);
            date = simpleDateFormat.parse(string3, parsePosition);
        }
        return date;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doCommandline() throws Exception {
        try {
            if (params.getOperation() != 41 && this.adminHome == null) {
                if (params.getAdminUrl() != null) {
                    this.adminHome = AdminToolHelper.getAdminMBeanHome(params);
                    params.setUrl(params.getAdminUrl());
                } else {
                    this.adminHome = AdminToolHelper.getMBeanHome(params);
                }
            }
            this.out = new OutputFormatter(printStream, params.isPretty());
            this.doOperation();
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (AdminToolHelper.printDone) throw illegalArgumentException;
            AdminToolHelper.printDone = true;
            AdminToolHelper.printException(illegalArgumentException);
            throw illegalArgumentException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (AdminToolHelper.printDone) throw instanceNotFoundException;
            printStream.println(managementTextTextFormatter.getCouldNotFindInstance(params.getMBeanObjName()));
            AdminToolHelper.printDone = true;
            throw instanceNotFoundException;
        }
        catch (RemoteRuntimeException remoteRuntimeException) {
            Throwable throwable = remoteRuntimeException.getNestedException();
            if (throwable instanceof PeerGoneException) {
                return;
            }
            if (AdminToolHelper.printDone) throw remoteRuntimeException;
            AdminToolHelper.printException((Exception)((Object)remoteRuntimeException), true);
            AdminToolHelper.printDone = true;
            throw remoteRuntimeException;
        }
        catch (ConnectException connectException) {
            if (AdminToolHelper.printDone) throw connectException;
            AdminToolHelper.printDone = true;
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            AdminToolHelper.printErrorMessage(managementTextTextFormatter.getConnectFailedError(ServerInfoCommandLineInvoker.getURL()), CONTINUE);
            throw connectException;
        }
        catch (IOException iOException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (AdminToolHelper.printDone) throw iOException;
            AdminToolHelper.printException(managementTextTextFormatter.getErrorWriting(), iOException);
            AdminToolHelper.printDone = true;
            throw iOException;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeOperationsException) {
                RuntimeOperationsException runtimeOperationsException = (RuntimeOperationsException)exception;
                if (!(runtimeOperationsException.getTargetException() instanceof RemoteRuntimeException)) return;
            }
            if (params.showNoMessages() || AdminToolHelper.printDone) throw exception;
            AdminToolHelper.printException(exception);
            AdminToolHelper.printDone = true;
            throw exception;
        }
    }

    static boolean isServerAlive(List list, String string) {
        boolean bl = false;
        for (String string2 : list) {
            if (!string2.equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static Context getInitialContext(String string, String string2, String string3) throws Exception {
        return AdminToolHelper.getInitialContext(string, string2, string3);
    }

    private static Context getInitialContext(CommandLineArgs commandLineArgs) throws Exception {
        return AdminToolHelper.getInitialContext(commandLineArgs);
    }

    private static String getURL() {
        String string = params.getAdminUrl();
        if (string == null) {
            string = params.getURL();
        }
        return string;
    }
}

