/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.commo;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import weblogic.management.MBeanHome;
import weblogic.management.RemoteMBeanServer;
import weblogic.management.WebLogicMBean;
import weblogic.management.commandline.CommandLineArgs;
import weblogic.management.commandline.OutputFormatter;
import weblogic.management.commo.CommoOperationsException;
import weblogic.management.commo.StandardInterface;
import weblogic.management.commo.internal.CommoCommandLineTextFormatter;
import weblogic.management.configuration.SecurityConfigurationMBean;
import weblogic.management.internal.ManagementTextTextFormatter;
import weblogic.management.jmx.MBeanServerInvocationHandler;
import weblogic.management.security.RealmMBean;
import weblogic.management.security.authentication.UserLockoutManagerMBean;

public class CommoAdminTool {
    DocumentBuilderFactory factory;
    DocumentBuilder docBuilder;
    MBeanServer mbs = null;
    MBeanHome home = null;
    CommandLineArgs params = null;
    static List mbeanTypes = new ArrayList();

    public CommoAdminTool(CommandLineArgs commandLineArgs, MBeanServer mBeanServer) {
        this.mbs = mBeanServer;
        this.params = commandLineArgs;
    }

    public CommoAdminTool(CommandLineArgs commandLineArgs, MBeanServer mBeanServer, MBeanHome mBeanHome) {
        this.mbs = mBeanServer;
        this.params = commandLineArgs;
        this.home = mBeanHome;
    }

    private static void printNotSupported() {
        System.out.println("Create's, Delete's and Set's on Security MBeans which include MBean's of types,\nweblogic.management.security.RealmMBean,\nweblogic.management.security.authentication.UserLockoutManagerMBean\nand any Security Provider MBeans are not supported via weblogic.Admin.\nPlease use weblogic.WLST.");
    }

    public static void doIt(CommandLineArgs commandLineArgs, MBeanServer mBeanServer, String string, MBeanHome mBeanHome) throws Exception {
        switch (commandLineArgs.getOperation()) {
            case 32: 
            case 33: 
            case 34: {
                CommoAdminTool.printNotSupported();
                break;
            }
            case 31: {
                new CommoAdminTool(commandLineArgs, mBeanServer, mBeanHome).executeNewGetOperation(string);
                break;
            }
            case 35: {
                new CommoAdminTool(commandLineArgs, mBeanServer, mBeanHome).executeNewInvokeOperation();
                break;
            }
            case 29: {
                new CommoAdminTool(commandLineArgs, mBeanServer, mBeanHome).executeQueryOperation(string);
            }
        }
    }

    boolean isEncrypted(ModelMBeanAttributeInfo modelMBeanAttributeInfo) {
        Boolean bl = (Boolean)modelMBeanAttributeInfo.getDescriptor().getFieldValue("encrypted");
        if (bl != null) {
            return bl;
        }
        return false;
    }

    boolean isExcluded(ModelMBeanAttributeInfo modelMBeanAttributeInfo) {
        Boolean bl = (Boolean)modelMBeanAttributeInfo.getDescriptor().getFieldValue("exclude");
        if (bl != null) {
            return bl;
        }
        return false;
    }

    boolean isOperationExcluded(ModelMBeanOperationInfo modelMBeanOperationInfo) {
        Boolean bl = (Boolean)modelMBeanOperationInfo.getDescriptor().getFieldValue("exclude");
        if (bl != null) {
            return bl;
        }
        return false;
    }

    private AttributeList getAttributes(MBeanHome mBeanHome, ObjectName objectName) throws Exception {
        RemoteMBeanServer remoteMBeanServer = mBeanHome.getMBeanServer();
        ModelMBeanInfo modelMBeanInfo = (ModelMBeanInfo)((Object)remoteMBeanServer.getMBeanInfo(objectName));
        ModelMBeanAttributeInfo[] modelMBeanAttributeInfoArray = (ModelMBeanAttributeInfo[])modelMBeanInfo.getAttributes();
        ArrayList<String> arrayList = new ArrayList<String>();
        AttributeList attributeList = new AttributeList();
        for (int i = 0; i < modelMBeanAttributeInfoArray.length; ++i) {
            String string = modelMBeanAttributeInfoArray[i].getName();
            if (this.isExcluded(modelMBeanAttributeInfoArray[i]) || arrayList.contains(string) || string.equals("MBeanInfo")) continue;
            arrayList.add(string);
            Object object = remoteMBeanServer.getAttribute(objectName, string);
            if (this.isEncrypted(modelMBeanAttributeInfoArray[i])) {
                attributeList.add(new Attribute(string, "******"));
                continue;
            }
            attributeList.add(new Attribute(string, object));
        }
        return attributeList;
    }

    private ObjectName getObjectName(Object object) {
        if (Proxy.isProxyClass(object.getClass())) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(object);
            if (invocationHandler instanceof MBeanServerInvocationHandler) {
                return MBeanServerInvocationHandler.getObjectName((Object)object);
            }
            if (object instanceof WebLogicMBean) {
                return ((WebLogicMBean)object).getObjectName();
            }
            if (object instanceof StandardInterface) {
                return ((StandardInterface)object).wls_getObjectName();
            }
        } else {
            if (object instanceof WebLogicMBean) {
                return ((WebLogicMBean)object).getObjectName();
            }
            if (object instanceof StandardInterface) {
                return ((StandardInterface)object).wls_getObjectName();
            }
        }
        return null;
    }

    public void executeNewGetOperation(String string) throws Exception {
        Object object;
        Object object2;
        AttributeList attributeList;
        Object object3;
        ManagementTextTextFormatter managementTextTextFormatter;
        Object object4;
        String string2;
        ObjectName objectName = new ObjectName(this.home.getDomainName() + ":Name=" + this.home.getDomainName() + ",Type=SecurityConfiguration");
        SecurityConfigurationMBean securityConfigurationMBean = (SecurityConfigurationMBean)this.home.getMBean(objectName);
        String string3 = this.params.getMBeanObjName();
        String string4 = string2 = CommandLineArgs.typeMunged ? null : this.params.getMBeanType();
        if (string2 != null && string2.indexOf(".") == -1) {
            ManagementTextTextFormatter managementTextTextFormatter2 = new ManagementTextTextFormatter();
            System.out.println(managementTextTextFormatter2.getNoMBeansFound());
            return;
        }
        if (string3 != null && !this.mbs.isRegistered(new ObjectName(string3))) {
            ManagementTextTextFormatter managementTextTextFormatter3 = new ManagementTextTextFormatter();
            System.out.println(managementTextTextFormatter3.getNoMBeansFound());
            return;
        }
        String string5 = this.params.getNewMBeanName();
        if (string3 != null) {
            object4 = securityConfigurationMBean.getRealms();
            for (int i = 0; i < ((RealmMBean[])object4).length; ++i) {
                managementTextTextFormatter = object4[i];
                if (!this.getObjectName(managementTextTextFormatter).toString().equals(string3)) continue;
                String[] stringArray = null;
                if (this.params.getAttribList() != null && this.params.getAttribList().size() != 0) {
                    this.printAttributes(this.params.getAttribList(), stringArray, this.getObjectName(managementTextTextFormatter).toString());
                } else {
                    AttributeList attributeList2 = this.getAttributes(this.home, this.getObjectName(managementTextTextFormatter));
                    stringArray = this.getNamesFromAttrList(attributeList2);
                    this.printAttributes(attributeList2, stringArray, this.getObjectName(managementTextTextFormatter).toString());
                }
                return;
            }
            object3 = securityConfigurationMBean.findDefaultRealm().getUserLockoutManager();
            if (this.getObjectName(object3).toString().equals(string3)) {
                managementTextTextFormatter = this.getAttributes(this.home, this.getObjectName(object3));
                String[] stringArray = this.getNamesFromAttrList((AttributeList)managementTextTextFormatter);
                this.printAttributes((AttributeList)managementTextTextFormatter, stringArray, this.getObjectName(object3).toString());
                return;
            }
            managementTextTextFormatter = null;
            attributeList = null;
            managementTextTextFormatter = null;
            attributeList = null;
            object2 = (ObjectName[])this.home.getMBeanServer().invoke(this.getObjectName(securityConfigurationMBean), "pre90getProviders", (Object[])managementTextTextFormatter, (String[])attributeList);
            for (int i = 0; i < ((Object[])object2).length; ++i) {
                object = object2[i];
                if (!object.toString().equals(string3)) continue;
                AttributeList attributeList3 = this.getAttributes(this.home, (ObjectName)object);
                String[] stringArray = this.getNamesFromAttrList(attributeList3);
                this.printAttributes(attributeList3, stringArray, object.toString());
                return;
            }
        }
        if (this.params.getMBeanType() != null) {
            if (this.params.getMBeanType().equals("weblogic.management.security.Realm")) {
                object4 = securityConfigurationMBean.getRealms();
                for (int i = 0; i < ((RealmMBean[])object4).length; ++i) {
                    managementTextTextFormatter = object4[i];
                    attributeList = this.getAttributes(this.home, this.getObjectName(managementTextTextFormatter));
                    object2 = this.getNamesFromAttrList(attributeList);
                    this.printAttributes(attributeList, (String[])object2, this.getObjectName(managementTextTextFormatter).toString());
                }
            } else if (this.params.getMBeanType().equals("weblogic.management.security.authentication.UserLockoutManager")) {
                object4 = securityConfigurationMBean.findDefaultRealm().getUserLockoutManager();
                if (this.getObjectName(object4).toString().equals(string3)) {
                    object3 = this.getAttributes(this.home, this.getObjectName(object4));
                    managementTextTextFormatter = this.getNamesFromAttrList((AttributeList)object3);
                    this.printAttributes((AttributeList)object3, (String[])managementTextTextFormatter, this.getObjectName(object4).toString());
                }
            } else {
                object4 = null;
                object3 = null;
                object4 = null;
                object3 = null;
                managementTextTextFormatter = (ObjectName[])this.home.getMBeanServer().invoke(this.getObjectName(securityConfigurationMBean), "pre90getProviders", (Object[])object4, (String[])object3);
                for (int i = 0; i < ((Object[])managementTextTextFormatter).length; ++i) {
                    object2 = managementTextTextFormatter[i];
                    if (string3 != null) {
                        if (!((ObjectName)object2).toString().equals(string3)) continue;
                        AttributeList attributeList4 = this.getAttributes(this.home, (ObjectName)object2);
                        object = this.getNamesFromAttrList(attributeList4);
                        this.printAttributes(attributeList4, (String[])object, ((ObjectName)object2).toString());
                        return;
                    }
                    ModelMBeanInfo modelMBeanInfo = (ModelMBeanInfo)((Object)this.home.getMBeanServer().getMBeanInfo((ObjectName)object2));
                    object = modelMBeanInfo.getMBeanDescriptor();
                    String string6 = (String)object.getFieldValue("interfaceclassname");
                    String string7 = string6.substring(0, string6.lastIndexOf("MBean"));
                    if (!string2.equals(string7)) continue;
                    AttributeList attributeList5 = this.getAttributes(this.home, (ObjectName)object2);
                    String[] stringArray = this.getNamesFromAttrList(attributeList5);
                    this.printAttributes(attributeList5, stringArray, ((ObjectName)object2).toString());
                }
            }
        } else {
            object4 = new ManagementTextTextFormatter();
            System.out.println(object4.getNoMBeansFound());
        }
    }

    public void executeQueryOperation(String string) throws Exception {
    }

    public void executeNewInvokeOperation() throws Exception {
        String string = CommandLineArgs.typeMunged ? null : this.params.getMBeanType();
        String string2 = this.params.getMBeanObjName();
        String string3 = this.params.getMethodName();
        Object[] objectArray = null;
        String[] stringArray = null;
        if (string2 != null) {
            stringArray = this.getMethodSignature(new ObjectName(string2), this.home.getMBeanServer(), this.params.getMethodName());
            objectArray = this.params.getMethodArguments(stringArray);
            Object object = null;
            object = this.home.getMBeanServer().invoke(new ObjectName(string2), string3, objectArray, stringArray);
            CommoCommandLineTextFormatter commoCommandLineTextFormatter = new CommoCommandLineTextFormatter();
            if (object != null) {
                System.out.println(object);
            } else {
                System.out.println(commoCommandLineTextFormatter.getOK());
            }
        } else {
            ObjectName objectName = new ObjectName(this.home.getDomainName() + ":Name=" + this.home.getDomainName() + ",Type=SecurityConfiguration");
            SecurityConfigurationMBean securityConfigurationMBean = (SecurityConfigurationMBean)this.home.getMBean(objectName);
            if (string.equals("weblogic.management.security.Realm")) {
                RealmMBean[] realmMBeanArray = securityConfigurationMBean.getRealms();
                for (int i = 0; i < realmMBeanArray.length; ++i) {
                    RealmMBean realmMBean = realmMBeanArray[i];
                    stringArray = this.getMethodSignature(this.getObjectName(realmMBean), this.home.getMBeanServer(), this.params.getMethodName());
                    objectArray = this.params.getMethodArguments(stringArray);
                    Object object = null;
                    object = this.home.getMBeanServer().invoke(this.getObjectName(realmMBean), string3, objectArray, stringArray);
                    CommoCommandLineTextFormatter commoCommandLineTextFormatter = new CommoCommandLineTextFormatter();
                    if (object != null) {
                        System.out.println(object);
                        continue;
                    }
                    System.out.println(commoCommandLineTextFormatter.getOK());
                }
            } else if (string.equals("weblogic.management.security.authentication.UserLockoutManager")) {
                UserLockoutManagerMBean userLockoutManagerMBean = securityConfigurationMBean.findDefaultRealm().getUserLockoutManager();
                stringArray = this.getMethodSignature(this.getObjectName(userLockoutManagerMBean), this.home.getMBeanServer(), this.params.getMethodName());
                objectArray = this.params.getMethodArguments(stringArray);
                Object object = null;
                object = this.home.getMBeanServer().invoke(this.getObjectName(userLockoutManagerMBean), string3, objectArray, stringArray);
                CommoCommandLineTextFormatter commoCommandLineTextFormatter = new CommoCommandLineTextFormatter();
                if (object != null) {
                    System.out.println(object);
                } else {
                    System.out.println(commoCommandLineTextFormatter.getOK());
                }
            } else {
                Object[] objectArray2 = null;
                String[] stringArray2 = null;
                objectArray2 = null;
                ObjectName[] objectNameArray = (ObjectName[])this.home.getMBeanServer().invoke(this.getObjectName(securityConfigurationMBean), "pre90getProviders", objectArray2, stringArray2);
                for (int i = 0; i < objectNameArray.length; ++i) {
                    stringArray = this.getMethodSignature(objectNameArray[i], this.home.getMBeanServer(), this.params.getMethodName());
                    objectArray = this.params.getMethodArguments(stringArray);
                    Object object = null;
                    object = this.home.getMBeanServer().invoke(objectNameArray[i], string3, objectArray, stringArray);
                    CommoCommandLineTextFormatter commoCommandLineTextFormatter = new CommoCommandLineTextFormatter();
                    if (object != null) {
                        System.out.println(object);
                        continue;
                    }
                    System.out.println(commoCommandLineTextFormatter.getOK());
                }
            }
        }
    }

    String[] getNamesFromAttrList(AttributeList attributeList) {
        Iterator iterator = attributeList.iterator();
        String[] stringArray = new String[attributeList.size()];
        int n = 0;
        while (iterator.hasNext()) {
            String string;
            Attribute attribute = (Attribute)iterator.next();
            stringArray[n] = string = attribute.getName();
            ++n;
        }
        return stringArray;
    }

    String[] getMethodSignature(ObjectName objectName, MBeanServer mBeanServer, String string) throws CommoOperationsException {
        String[] stringArray = null;
        try {
            MBeanInfo mBeanInfo = mBeanServer.getMBeanInfo(objectName);
            IllegalArgumentException illegalArgumentException = null;
            MBeanOperationInfo[] mBeanOperationInfoArray = mBeanInfo.getOperations();
            for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
                if (!mBeanOperationInfoArray[i].getName().equalsIgnoreCase(string)) continue;
                MBeanParameterInfo[] mBeanParameterInfoArray = mBeanOperationInfoArray[i].getSignature();
                stringArray = new String[mBeanParameterInfoArray.length];
                for (int j = 0; j < mBeanParameterInfoArray.length; ++j) {
                    stringArray[j] = mBeanParameterInfoArray[j].getType();
                }
                try {
                    Object[] objectArray = this.params.getMethodArguments(stringArray);
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    illegalArgumentException = illegalArgumentException2;
                    continue;
                }
                return stringArray;
            }
            if (null != illegalArgumentException) {
                throw illegalArgumentException;
            }
            CommoCommandLineTextFormatter commoCommandLineTextFormatter = new CommoCommandLineTextFormatter();
            System.out.println(commoCommandLineTextFormatter.getInstanceMethNotFound(string, objectName.toString()));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new CommoOperationsException((Exception)instanceNotFoundException);
        }
        catch (IntrospectionException introspectionException) {
            throw new CommoOperationsException((Exception)introspectionException);
        }
        catch (ReflectionException reflectionException) {
            throw new CommoOperationsException((Exception)reflectionException);
        }
        return stringArray;
    }

    void printAttributes(AttributeList attributeList, String[] stringArray, String string) {
        try {
            OutputFormatter outputFormatter = new OutputFormatter(System.out, this.params.isPretty());
            outputFormatter.mbeanBegin(string);
            outputFormatter.printAttribs(attributeList, stringArray);
            outputFormatter.mbeanEnd();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

