/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import weblogic.management.PrincipalInfo;
import weblogic.management.configuration.Group;
import weblogic.management.configuration.Principal;
import weblogic.management.configuration.RealmException;
import weblogic.management.configuration.RealmIterator;
import weblogic.management.configuration.User;
import weblogic.management.internal.RemoteRealmManager;

public final class Acl
implements Serializable {
    private static final long serialVersionUID = 397151266611957559L;
    private static boolean debug = false;
    private String name;
    private RemoteRealmManager helper;

    public Acl(String string, RemoteRealmManager remoteRealmManager) {
        this.name = string;
        this.helper = remoteRealmManager;
        if (debug) {
            this.trace("constructor");
        }
    }

    public String getName() {
        return this.name;
    }

    public String[] getPermissions() throws RealmException {
        if (debug) {
            this.trace("getPermissions");
        }
        try {
            return this.helper.getPermissions(this.getName());
        }
        catch (Throwable throwable) {
            throw new RealmException("Acl.getPermissions", throwable);
        }
    }

    public RealmIterator getGrantees(String string) throws RealmException {
        if (debug) {
            this.trace("getGrantees(" + string + ")");
        }
        try {
            return new RealmIterator(this.helper.getGrantees(this.getName(), string), new RealmIterator.ElementHandler(){

                public Object handle(Object object) {
                    PrincipalInfo principalInfo = (PrincipalInfo)object;
                    if (principalInfo.isGroup()) {
                        return new Group(principalInfo.getName(), Acl.this.helper);
                    }
                    return new User(principalInfo.getName(), Acl.this.helper);
                }
            });
        }
        catch (Throwable throwable) {
            throw new RealmException("Acl.getGrantees", throwable);
        }
    }

    public void grantPermission(Principal principal, String string) throws RealmException {
        if (debug) {
            this.trace("grantPermission(" + principal.getName() + "," + string + ")");
        }
        try {
            this.helper.grantPermission(this.getName(), principal.getName(), string);
        }
        catch (Throwable throwable) {
            throw new RealmException("Acl.grantPermission", throwable);
        }
    }

    public void revokePermission(Principal principal, String string) throws RealmException {
        if (debug) {
            this.trace("revokePermission(" + principal.getName() + "," + string + ")");
        }
        try {
            this.helper.revokePermission(this.getName(), principal.getName(), string);
        }
        catch (Throwable throwable) {
            throw new RealmException("Acl.revokePermission", throwable);
        }
    }

    private void trace(String string) {
        System.out.println("Acl " + this.getName() + " " + string);
    }
}

