/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.BasicDeploymentMBeanImpl;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.SubDeploymentMBeanImpl;
import weblogic.management.mbeans.custom.AppDeployment;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;

public class AppDeploymentMBeanImpl
extends BasicDeploymentMBeanImpl
implements AppDeploymentMBean,
Serializable {
    private String _AbsoluteInstallDir;
    private String _AbsolutePlanDir;
    private String _AbsolutePlanPath;
    private String _AbsoluteSourcePath;
    private String _AltDescriptorPath;
    private String _AltWLSDescriptorPath;
    private ApplicationMBean _AppMBean;
    private String _ApplicationIdentifier;
    private String _ApplicationName;
    private boolean _AutoDeployedApp;
    private boolean _BackgroundDeployment;
    private byte[] _DeploymentPlan;
    private DeploymentPlanBean _DeploymentPlanDescriptor;
    private byte[] _DeploymentPlanExternalDescriptors;
    private String _InstallDir;
    private boolean _InternalApp;
    private String _LocalInstallDir;
    private String _LocalPlanDir;
    private String _LocalPlanPath;
    private String _LocalSourcePath;
    private String _Name;
    private String[] _OnDemandContextPaths;
    private boolean _OnDemandDisplayRefresh;
    private String _PlanDir;
    private String _PlanPath;
    private String _RootStagingDir;
    private String _SecurityDDModel;
    private String _SourcePath;
    private String _StagingMode;
    private boolean _ValidateDDSecurityData;
    private String _VersionIdentifier;
    private AppDeployment _customizer;
    private static SchemaHelper2 _schemaHelper;

    public AppDeploymentMBeanImpl() {
        try {
            this._customizer = new AppDeployment(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public AppDeploymentMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new AppDeployment(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getInstallDir() {
        return this._InstallDir;
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public String getSourcePath() {
        return this._customizer.getSourcePath();
    }

    public boolean isInstallDirSet() {
        return this._isSet(14);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isSourcePathSet() {
        return this._isSet(10);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setSourcePath(String string) {
        string = string == null ? null : string.trim();
        String string2 = this.getSourcePath();
        this._customizer.setSourcePath(string);
        this._postSet(10, string2, string);
    }

    public String getPlanDir() {
        return this._customizer.getPlanDir();
    }

    public boolean isPlanDirSet() {
        return this._isSet(15);
    }

    public String getPlanPath() {
        return this._customizer.getPlanPath();
    }

    public boolean isPlanPathSet() {
        return this._isSet(16);
    }

    public String getVersionIdentifier() {
        return this._customizer.getVersionIdentifier();
    }

    public boolean isVersionIdentifierSet() {
        return this._isSet(17);
    }

    public void setVersionIdentifier(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._VersionIdentifier;
        this._VersionIdentifier = string;
        this._postSet(17, string2, string);
    }

    public boolean isValidateDDSecurityData() {
        return this._ValidateDDSecurityData;
    }

    public boolean isValidateDDSecurityDataSet() {
        return this._isSet(18);
    }

    public void setValidateDDSecurityData(boolean bl) {
        boolean bl2 = this._ValidateDDSecurityData;
        this._ValidateDDSecurityData = bl;
        this._postSet(18, bl2, bl);
    }

    public String getSecurityDDModel() {
        return this._SecurityDDModel;
    }

    public boolean isSecurityDDModelSet() {
        return this._isSet(19);
    }

    public String getStagingMode() {
        return this._customizer.getStagingMode();
    }

    public boolean isStagingModeSet() {
        return this._isSet(20);
    }

    public void setInstallDir(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._InstallDir;
        this._InstallDir = string;
        this._postSet(14, string2, string);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void setPlanDir(String string) {
        string = string == null ? null : string.trim();
        String string2 = this.getPlanDir();
        this._customizer.setPlanDir(string);
        this._postSet(15, string2, string);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setPlanPath(String string) {
        string = string == null ? null : string.trim();
        String string2 = this.getPlanPath();
        this._customizer.setPlanPath(string);
        this._postSet(16, string2, string);
    }

    public void setStagingMode(String string) throws ManagementException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{AppDeploymentMBean.DEFAULT_STAGE, "nostage", "stage", "external_stage"};
        string = LegalChecks.checkInEnum((String)"StagingMode", (String)string, (String[])stringArray);
        String string2 = this.getStagingMode();
        this._customizer.setStagingMode(string);
        this._postSet(20, string2, string);
    }

    public String getAltDescriptorPath() {
        return this._AltDescriptorPath;
    }

    public boolean isAltDescriptorPathSet() {
        return this._isSet(21);
    }

    public void setAltDescriptorPath(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._AltDescriptorPath;
        this._AltDescriptorPath = string;
        this._postSet(21, string2, string);
    }

    public String getAltWLSDescriptorPath() {
        return this._AltWLSDescriptorPath;
    }

    public boolean isAltWLSDescriptorPathSet() {
        return this._isSet(22);
    }

    public void setAltWLSDescriptorPath(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._AltWLSDescriptorPath;
        this._AltWLSDescriptorPath = string;
        this._postSet(22, string2, string);
    }

    public void setSecurityDDModel(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"DDOnly", "CustomRoles", "CustomRolesAndPolicies", "Advanced"};
        string = LegalChecks.checkInEnum((String)"SecurityDDModel", (String)string, (String[])stringArray);
        String string2 = this._SecurityDDModel;
        this._SecurityDDModel = string;
        this._postSet(19, string2, string);
    }

    public String getApplicationIdentifier() {
        return this._customizer.getApplicationIdentifier();
    }

    public boolean isApplicationIdentifierSet() {
        return this._isSet(23);
    }

    public void setApplicationIdentifier(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ApplicationIdentifier;
        this._ApplicationIdentifier = string;
        this._postSet(23, string2, string);
    }

    public String getApplicationName() {
        return this._customizer.getApplicationName();
    }

    public boolean isApplicationNameSet() {
        return this._isSet(24);
    }

    public void setApplicationName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ApplicationName;
        this._ApplicationName = string;
        this._postSet(24, string2, string);
    }

    public ApplicationMBean getAppMBean() {
        return this._customizer.getAppMBean();
    }

    public boolean isAppMBeanSet() {
        return this._isSet(25);
    }

    public void setAppMBean(ApplicationMBean applicationMBean) throws InvalidAttributeValueException {
        this._AppMBean = applicationMBean;
    }

    public boolean isInternalApp() {
        return this._InternalApp;
    }

    public boolean isInternalAppSet() {
        return this._isSet(26);
    }

    public void setInternalApp(boolean bl) {
        this._InternalApp = bl;
    }

    public boolean isBackgroundDeployment() {
        return this._BackgroundDeployment;
    }

    public boolean isBackgroundDeploymentSet() {
        return this._isSet(27);
    }

    public void setBackgroundDeployment(boolean bl) {
        this._BackgroundDeployment = bl;
    }

    public boolean isAutoDeployedApp() {
        return this._customizer.isAutoDeployedApp();
    }

    public boolean isAutoDeployedAppSet() {
        return this._isSet(28);
    }

    public void setAutoDeployedApp(boolean bl) throws InvalidAttributeValueException {
        this._AutoDeployedApp = bl;
    }

    public DeploymentPlanBean getDeploymentPlanDescriptor() {
        return this._customizer.getDeploymentPlanDescriptor();
    }

    public boolean isDeploymentPlanDescriptorSet() {
        return this._isSet(29);
    }

    public void setDeploymentPlanDescriptor(DeploymentPlanBean deploymentPlanBean) {
        this._customizer.setDeploymentPlanDescriptor(deploymentPlanBean);
    }

    public String[] getOnDemandContextPaths() {
        return this._OnDemandContextPaths;
    }

    public boolean isOnDemandContextPathsSet() {
        return this._isSet(30);
    }

    public void setOnDemandContextPaths(String[] stringArray) {
        stringArray = stringArray == null ? new String[]{} : stringArray;
        stringArray = this._getHelper()._trimElements(stringArray);
        this._OnDemandContextPaths = stringArray;
    }

    public boolean isOnDemandDisplayRefresh() {
        return this._OnDemandDisplayRefresh;
    }

    public boolean isOnDemandDisplayRefreshSet() {
        return this._isSet(31);
    }

    public void setOnDemandDisplayRefresh(boolean bl) {
        this._OnDemandDisplayRefresh = bl;
    }

    public String getAbsoluteInstallDir() {
        return this._customizer.getAbsoluteInstallDir();
    }

    public boolean isAbsoluteInstallDirSet() {
        return this._isSet(32);
    }

    public void setAbsoluteInstallDir(String string) throws InvalidAttributeValueException {
        this._AbsoluteInstallDir = string = string == null ? null : string.trim();
    }

    public String getAbsolutePlanPath() {
        return this._customizer.getAbsolutePlanPath();
    }

    public boolean isAbsolutePlanPathSet() {
        return this._isSet(33);
    }

    public void setAbsolutePlanPath(String string) throws InvalidAttributeValueException {
        this._AbsolutePlanPath = string = string == null ? null : string.trim();
    }

    public String getAbsolutePlanDir() {
        return this._customizer.getAbsolutePlanDir();
    }

    public boolean isAbsolutePlanDirSet() {
        return this._isSet(34);
    }

    public void setAbsolutePlanDir(String string) throws InvalidAttributeValueException {
        this._AbsolutePlanDir = string = string == null ? null : string.trim();
    }

    public String getAbsoluteSourcePath() {
        return this._customizer.getAbsoluteSourcePath();
    }

    public boolean isAbsoluteSourcePathSet() {
        return this._isSet(35);
    }

    public void setAbsoluteSourcePath(String string) throws InvalidAttributeValueException {
        this._AbsoluteSourcePath = string = string == null ? null : string.trim();
    }

    public String getLocalInstallDir() {
        return this._customizer.getLocalInstallDir();
    }

    public boolean isLocalInstallDirSet() {
        return this._isSet(36);
    }

    public void setLocalInstallDir(String string) throws InvalidAttributeValueException {
        this._LocalInstallDir = string = string == null ? null : string.trim();
    }

    public String getLocalPlanPath() {
        return this._customizer.getLocalPlanPath();
    }

    public boolean isLocalPlanPathSet() {
        return this._isSet(37);
    }

    public void setLocalPlanPath(String string) throws InvalidAttributeValueException {
        this._LocalPlanPath = string = string == null ? null : string.trim();
    }

    public String getLocalPlanDir() {
        try {
            return this._customizer.getLocalPlanDir();
        }
        catch (IOException iOException) {
            throw new UndeclaredThrowableException(iOException);
        }
    }

    public boolean isLocalPlanDirSet() {
        return this._isSet(38);
    }

    public void setLocalPlanDir(String string) throws InvalidAttributeValueException {
        this._LocalPlanDir = string = string == null ? null : string.trim();
    }

    public String getLocalSourcePath() {
        return this._customizer.getLocalSourcePath();
    }

    public boolean isLocalSourcePathSet() {
        return this._isSet(39);
    }

    public void setLocalSourcePath(String string) throws InvalidAttributeValueException {
        this._LocalSourcePath = string = string == null ? null : string.trim();
    }

    public String getRootStagingDir() {
        return this._customizer.getRootStagingDir();
    }

    public boolean isRootStagingDirSet() {
        return this._isSet(40);
    }

    public void setRootStagingDir(String string) throws InvalidAttributeValueException {
        this._RootStagingDir = string = string == null ? null : string.trim();
    }

    public String getStagingMode(String string) {
        return this._customizer.getStagingMode(string);
    }

    public byte[] getDeploymentPlan() {
        return this._customizer.getDeploymentPlan();
    }

    public boolean isDeploymentPlanSet() {
        return this._isSet(41);
    }

    public void setDeploymentPlan(byte[] byArray) throws InvalidAttributeValueException {
        this._DeploymentPlan = byArray;
    }

    public byte[] getDeploymentPlanExternalDescriptors() {
        return this._customizer.getDeploymentPlanExternalDescriptors();
    }

    public boolean isDeploymentPlanExternalDescriptorsSet() {
        return this._isSet(42);
    }

    public void setDeploymentPlanExternalDescriptors(byte[] byArray) throws InvalidAttributeValueException {
        this._DeploymentPlanExternalDescriptors = byArray;
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 32;
        }
        try {
            switch (n) {
                case 32: {
                    this._AbsoluteInstallDir = null;
                    if (bl) break;
                }
                case 34: {
                    this._AbsolutePlanDir = null;
                    if (bl) break;
                }
                case 33: {
                    this._AbsolutePlanPath = null;
                    if (bl) break;
                }
                case 35: {
                    this._AbsoluteSourcePath = null;
                    if (bl) break;
                }
                case 21: {
                    this._AltDescriptorPath = null;
                    if (bl) break;
                }
                case 22: {
                    this._AltWLSDescriptorPath = null;
                    if (bl) break;
                }
                case 25: {
                    this._AppMBean = null;
                    if (bl) break;
                }
                case 23: {
                    this._ApplicationIdentifier = null;
                    if (bl) break;
                }
                case 24: {
                    this._ApplicationName = null;
                    if (bl) break;
                }
                case 41: {
                    this._DeploymentPlan = new byte[0];
                    if (bl) break;
                }
                case 29: {
                    this._customizer.setDeploymentPlanDescriptor(null);
                    if (bl) break;
                }
                case 42: {
                    this._DeploymentPlanExternalDescriptors = new byte[0];
                    if (bl) break;
                }
                case 14: {
                    this._InstallDir = null;
                    if (bl) break;
                }
                case 36: {
                    this._LocalInstallDir = null;
                    if (bl) break;
                }
                case 38: {
                    this._LocalPlanDir = null;
                    if (bl) break;
                }
                case 37: {
                    this._LocalPlanPath = null;
                    if (bl) break;
                }
                case 39: {
                    this._LocalSourcePath = null;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 30: {
                    this._OnDemandContextPaths = new String[0];
                    if (bl) break;
                }
                case 15: {
                    this._customizer.setPlanDir(null);
                    if (bl) break;
                }
                case 16: {
                    this._customizer.setPlanPath(null);
                    if (bl) break;
                }
                case 40: {
                    this._RootStagingDir = null;
                    if (bl) break;
                }
                case 19: {
                    String string = this._SecurityDDModel = this.isEditable() ? AppDeployment.getInitialSecurityDDModel(this) : "DDOnly";
                    if (this.isEditable()) {
                        this._markSet(19, true);
                    }
                    if (bl) break;
                }
                case 10: {
                    this._customizer.setSourcePath(null);
                    if (bl) break;
                }
                case 20: {
                    this._customizer.setStagingMode(AppDeploymentMBean.DEFAULT_STAGE);
                    if (bl) break;
                }
                case 17: {
                    this._VersionIdentifier = null;
                    if (bl) break;
                }
                case 28: {
                    this._AutoDeployedApp = false;
                    if (bl) break;
                }
                case 27: {
                    this._BackgroundDeployment = false;
                    if (bl) break;
                }
                case 26: {
                    this._InternalApp = false;
                    if (bl) break;
                }
                case 31: {
                    this._OnDemandDisplayRefresh = false;
                    if (bl) break;
                }
                case 18: {
                    this._ValidateDDSecurityData = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "AppDeployment";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AbsoluteInstallDir")) {
            String string2 = this._AbsoluteInstallDir;
            this._AbsoluteInstallDir = (String)object;
            this._postSet(32, string2, this._AbsoluteInstallDir);
            return;
        }
        if (string.equals("AbsolutePlanDir")) {
            String string3 = this._AbsolutePlanDir;
            this._AbsolutePlanDir = (String)object;
            this._postSet(34, string3, this._AbsolutePlanDir);
            return;
        }
        if (string.equals("AbsolutePlanPath")) {
            String string4 = this._AbsolutePlanPath;
            this._AbsolutePlanPath = (String)object;
            this._postSet(33, string4, this._AbsolutePlanPath);
            return;
        }
        if (string.equals("AbsoluteSourcePath")) {
            String string5 = this._AbsoluteSourcePath;
            this._AbsoluteSourcePath = (String)object;
            this._postSet(35, string5, this._AbsoluteSourcePath);
            return;
        }
        if (string.equals("AltDescriptorPath")) {
            String string6 = this._AltDescriptorPath;
            this._AltDescriptorPath = (String)object;
            this._postSet(21, string6, this._AltDescriptorPath);
            return;
        }
        if (string.equals("AltWLSDescriptorPath")) {
            String string7 = this._AltWLSDescriptorPath;
            this._AltWLSDescriptorPath = (String)object;
            this._postSet(22, string7, this._AltWLSDescriptorPath);
            return;
        }
        if (string.equals("AppMBean")) {
            ApplicationMBean applicationMBean = this._AppMBean;
            this._AppMBean = (ApplicationMBean)object;
            this._postSet(25, applicationMBean, this._AppMBean);
            return;
        }
        if (string.equals("ApplicationIdentifier")) {
            String string8 = this._ApplicationIdentifier;
            this._ApplicationIdentifier = (String)object;
            this._postSet(23, string8, this._ApplicationIdentifier);
            return;
        }
        if (string.equals("ApplicationName")) {
            String string9 = this._ApplicationName;
            this._ApplicationName = (String)object;
            this._postSet(24, string9, this._ApplicationName);
            return;
        }
        if (string.equals("AutoDeployedApp")) {
            boolean bl = this._AutoDeployedApp;
            this._AutoDeployedApp = (Boolean)object;
            this._postSet(28, bl, this._AutoDeployedApp);
            return;
        }
        if (string.equals("BackgroundDeployment")) {
            boolean bl = this._BackgroundDeployment;
            this._BackgroundDeployment = (Boolean)object;
            this._postSet(27, bl, this._BackgroundDeployment);
            return;
        }
        if (string.equals("DeploymentPlan")) {
            byte[] byArray = this._DeploymentPlan;
            this._DeploymentPlan = (byte[])object;
            this._postSet(41, byArray, this._DeploymentPlan);
            return;
        }
        if (string.equals("DeploymentPlanDescriptor")) {
            DeploymentPlanBean deploymentPlanBean = this._DeploymentPlanDescriptor;
            this._DeploymentPlanDescriptor = (DeploymentPlanBean)object;
            this._postSet(29, deploymentPlanBean, this._DeploymentPlanDescriptor);
            return;
        }
        if (string.equals("DeploymentPlanExternalDescriptors")) {
            byte[] byArray = this._DeploymentPlanExternalDescriptors;
            this._DeploymentPlanExternalDescriptors = (byte[])object;
            this._postSet(42, byArray, this._DeploymentPlanExternalDescriptors);
            return;
        }
        if (string.equals("InstallDir")) {
            String string10 = this._InstallDir;
            this._InstallDir = (String)object;
            this._postSet(14, string10, this._InstallDir);
            return;
        }
        if (string.equals("InternalApp")) {
            boolean bl = this._InternalApp;
            this._InternalApp = (Boolean)object;
            this._postSet(26, bl, this._InternalApp);
            return;
        }
        if (string.equals("LocalInstallDir")) {
            String string11 = this._LocalInstallDir;
            this._LocalInstallDir = (String)object;
            this._postSet(36, string11, this._LocalInstallDir);
            return;
        }
        if (string.equals("LocalPlanDir")) {
            String string12 = this._LocalPlanDir;
            this._LocalPlanDir = (String)object;
            this._postSet(38, string12, this._LocalPlanDir);
            return;
        }
        if (string.equals("LocalPlanPath")) {
            String string13 = this._LocalPlanPath;
            this._LocalPlanPath = (String)object;
            this._postSet(37, string13, this._LocalPlanPath);
            return;
        }
        if (string.equals("LocalSourcePath")) {
            String string14 = this._LocalSourcePath;
            this._LocalSourcePath = (String)object;
            this._postSet(39, string14, this._LocalSourcePath);
            return;
        }
        if (string.equals("Name")) {
            String string15 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string15, this._Name);
            return;
        }
        if (string.equals("OnDemandContextPaths")) {
            String[] stringArray = this._OnDemandContextPaths;
            this._OnDemandContextPaths = (String[])object;
            this._postSet(30, stringArray, this._OnDemandContextPaths);
            return;
        }
        if (string.equals("OnDemandDisplayRefresh")) {
            boolean bl = this._OnDemandDisplayRefresh;
            this._OnDemandDisplayRefresh = (Boolean)object;
            this._postSet(31, bl, this._OnDemandDisplayRefresh);
            return;
        }
        if (string.equals("PlanDir")) {
            String string16 = this._PlanDir;
            this._PlanDir = (String)object;
            this._postSet(15, string16, this._PlanDir);
            return;
        }
        if (string.equals("PlanPath")) {
            String string17 = this._PlanPath;
            this._PlanPath = (String)object;
            this._postSet(16, string17, this._PlanPath);
            return;
        }
        if (string.equals("RootStagingDir")) {
            String string18 = this._RootStagingDir;
            this._RootStagingDir = (String)object;
            this._postSet(40, string18, this._RootStagingDir);
            return;
        }
        if (string.equals("SecurityDDModel")) {
            String string19 = this._SecurityDDModel;
            this._SecurityDDModel = (String)object;
            this._postSet(19, string19, this._SecurityDDModel);
            return;
        }
        if (string.equals("SourcePath")) {
            String string20 = this._SourcePath;
            this._SourcePath = (String)object;
            this._postSet(10, string20, this._SourcePath);
            return;
        }
        if (string.equals("StagingMode")) {
            String string21 = this._StagingMode;
            this._StagingMode = (String)object;
            this._postSet(20, string21, this._StagingMode);
            return;
        }
        if (string.equals("ValidateDDSecurityData")) {
            boolean bl = this._ValidateDDSecurityData;
            this._ValidateDDSecurityData = (Boolean)object;
            this._postSet(18, bl, this._ValidateDDSecurityData);
            return;
        }
        if (string.equals("VersionIdentifier")) {
            String string22 = this._VersionIdentifier;
            this._VersionIdentifier = (String)object;
            this._postSet(17, string22, this._VersionIdentifier);
            return;
        }
        if (string.equals("customizer")) {
            AppDeployment appDeployment = this._customizer;
            this._customizer = (AppDeployment)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AbsoluteInstallDir")) {
            return this._AbsoluteInstallDir;
        }
        if (string.equals("AbsolutePlanDir")) {
            return this._AbsolutePlanDir;
        }
        if (string.equals("AbsolutePlanPath")) {
            return this._AbsolutePlanPath;
        }
        if (string.equals("AbsoluteSourcePath")) {
            return this._AbsoluteSourcePath;
        }
        if (string.equals("AltDescriptorPath")) {
            return this._AltDescriptorPath;
        }
        if (string.equals("AltWLSDescriptorPath")) {
            return this._AltWLSDescriptorPath;
        }
        if (string.equals("AppMBean")) {
            return this._AppMBean;
        }
        if (string.equals("ApplicationIdentifier")) {
            return this._ApplicationIdentifier;
        }
        if (string.equals("ApplicationName")) {
            return this._ApplicationName;
        }
        if (string.equals("AutoDeployedApp")) {
            return new Boolean(this._AutoDeployedApp);
        }
        if (string.equals("BackgroundDeployment")) {
            return new Boolean(this._BackgroundDeployment);
        }
        if (string.equals("DeploymentPlan")) {
            return this._DeploymentPlan;
        }
        if (string.equals("DeploymentPlanDescriptor")) {
            return this._DeploymentPlanDescriptor;
        }
        if (string.equals("DeploymentPlanExternalDescriptors")) {
            return this._DeploymentPlanExternalDescriptors;
        }
        if (string.equals("InstallDir")) {
            return this._InstallDir;
        }
        if (string.equals("InternalApp")) {
            return new Boolean(this._InternalApp);
        }
        if (string.equals("LocalInstallDir")) {
            return this._LocalInstallDir;
        }
        if (string.equals("LocalPlanDir")) {
            return this._LocalPlanDir;
        }
        if (string.equals("LocalPlanPath")) {
            return this._LocalPlanPath;
        }
        if (string.equals("LocalSourcePath")) {
            return this._LocalSourcePath;
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("OnDemandContextPaths")) {
            return this._OnDemandContextPaths;
        }
        if (string.equals("OnDemandDisplayRefresh")) {
            return new Boolean(this._OnDemandDisplayRefresh);
        }
        if (string.equals("PlanDir")) {
            return this._PlanDir;
        }
        if (string.equals("PlanPath")) {
            return this._PlanPath;
        }
        if (string.equals("RootStagingDir")) {
            return this._RootStagingDir;
        }
        if (string.equals("SecurityDDModel")) {
            return this._SecurityDDModel;
        }
        if (string.equals("SourcePath")) {
            return this._SourcePath;
        }
        if (string.equals("StagingMode")) {
            return this._StagingMode;
        }
        if (string.equals("ValidateDDSecurityData")) {
            return new Boolean(this._ValidateDDSecurityData);
        }
        if (string.equals("VersionIdentifier")) {
            return this._VersionIdentifier;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends BasicDeploymentMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 20: {
                    if (string.equals("absolute-install-dir")) {
                        return 32;
                    }
                    if (!string.equals("absolute-source-path")) break;
                    return 35;
                }
                case 17: {
                    if (string.equals("absolute-plan-dir")) {
                        return 34;
                    }
                    if (string.equals("local-install-dir")) {
                        return 36;
                    }
                    if (string.equals("local-source-path")) {
                        return 39;
                    }
                    if (!string.equals("auto-deployed-app")) break;
                    return 28;
                }
                case 18: {
                    if (string.equals("absolute-plan-path")) {
                        return 33;
                    }
                    if (!string.equals("version-identifier")) break;
                    return 17;
                }
                case 19: {
                    if (!string.equals("alt-descriptor-path")) break;
                    return 21;
                }
                case 22: {
                    if (string.equals("altwls-descriptor-path")) {
                        return 22;
                    }
                    if (string.equals("application-identifier")) {
                        return 23;
                    }
                    if (!string.equals("on-demand-context-path")) break;
                    return 30;
                }
                case 9: {
                    if (string.equals("appm-bean")) {
                        return 25;
                    }
                    if (!string.equals("plan-path")) break;
                    return 16;
                }
                case 16: {
                    if (string.equals("application-name")) {
                        return 24;
                    }
                    if (string.equals("root-staging-dir")) {
                        return 40;
                    }
                    if (!string.equals("securitydd-model")) break;
                    return 19;
                }
                case 15: {
                    if (string.equals("deployment-plan")) {
                        return 41;
                    }
                    if (!string.equals("local-plan-path")) break;
                    return 37;
                }
                case 26: {
                    if (!string.equals("deployment-plan-descriptor")) break;
                    return 29;
                }
                case 35: {
                    if (!string.equals("deployment-plan-external-descriptor")) break;
                    return 42;
                }
                case 11: {
                    if (string.equals("install-dir")) {
                        return 14;
                    }
                    if (!string.equals("source-path")) break;
                    return 10;
                }
                case 14: {
                    if (!string.equals("local-plan-dir")) break;
                    return 38;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 8: {
                    if (!string.equals("plan-dir")) break;
                    return 15;
                }
                case 12: {
                    if (string.equals("staging-mode")) {
                        return 20;
                    }
                    if (!string.equals("internal-app")) break;
                    return 26;
                }
                case 21: {
                    if (!string.equals("background-deployment")) break;
                    return 27;
                }
                case 25: {
                    if (!string.equals("on-demand-display-refresh")) break;
                    return 31;
                }
                case 24: {
                    if (!string.equals("validatedd-security-data")) break;
                    return 18;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                case 11: {
                    return new SubDeploymentMBeanImpl.SchemaHelper2();
                }
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 32: {
                    return "absolute-install-dir";
                }
                case 34: {
                    return "absolute-plan-dir";
                }
                case 33: {
                    return "absolute-plan-path";
                }
                case 35: {
                    return "absolute-source-path";
                }
                case 21: {
                    return "alt-descriptor-path";
                }
                case 22: {
                    return "altwls-descriptor-path";
                }
                case 25: {
                    return "appm-bean";
                }
                case 23: {
                    return "application-identifier";
                }
                case 24: {
                    return "application-name";
                }
                case 41: {
                    return "deployment-plan";
                }
                case 29: {
                    return "deployment-plan-descriptor";
                }
                case 42: {
                    return "deployment-plan-external-descriptor";
                }
                case 14: {
                    return "install-dir";
                }
                case 36: {
                    return "local-install-dir";
                }
                case 38: {
                    return "local-plan-dir";
                }
                case 37: {
                    return "local-plan-path";
                }
                case 39: {
                    return "local-source-path";
                }
                case 2: {
                    return "name";
                }
                case 30: {
                    return "on-demand-context-path";
                }
                case 15: {
                    return "plan-dir";
                }
                case 16: {
                    return "plan-path";
                }
                case 40: {
                    return "root-staging-dir";
                }
                case 19: {
                    return "securitydd-model";
                }
                case 10: {
                    return "source-path";
                }
                case 20: {
                    return "staging-mode";
                }
                case 17: {
                    return "version-identifier";
                }
                case 28: {
                    return "auto-deployed-app";
                }
                case 27: {
                    return "background-deployment";
                }
                case 26: {
                    return "internal-app";
                }
                case 31: {
                    return "on-demand-display-refresh";
                }
                case 18: {
                    return "validatedd-security-data";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 41: {
                    return true;
                }
                case 42: {
                    return true;
                }
                case 30: {
                    return true;
                }
                case 11: {
                    return true;
                }
                case 7: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                case 11: {
                    return true;
                }
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends BasicDeploymentMBeanImpl.Helper {
        private AppDeploymentMBeanImpl bean;

        protected Helper(AppDeploymentMBeanImpl appDeploymentMBeanImpl) {
            super(appDeploymentMBeanImpl);
            this.bean = appDeploymentMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 32: {
                    return "AbsoluteInstallDir";
                }
                case 34: {
                    return "AbsolutePlanDir";
                }
                case 33: {
                    return "AbsolutePlanPath";
                }
                case 35: {
                    return "AbsoluteSourcePath";
                }
                case 21: {
                    return "AltDescriptorPath";
                }
                case 22: {
                    return "AltWLSDescriptorPath";
                }
                case 25: {
                    return "AppMBean";
                }
                case 23: {
                    return "ApplicationIdentifier";
                }
                case 24: {
                    return "ApplicationName";
                }
                case 41: {
                    return "DeploymentPlan";
                }
                case 29: {
                    return "DeploymentPlanDescriptor";
                }
                case 42: {
                    return "DeploymentPlanExternalDescriptors";
                }
                case 14: {
                    return "InstallDir";
                }
                case 36: {
                    return "LocalInstallDir";
                }
                case 38: {
                    return "LocalPlanDir";
                }
                case 37: {
                    return "LocalPlanPath";
                }
                case 39: {
                    return "LocalSourcePath";
                }
                case 2: {
                    return "Name";
                }
                case 30: {
                    return "OnDemandContextPaths";
                }
                case 15: {
                    return "PlanDir";
                }
                case 16: {
                    return "PlanPath";
                }
                case 40: {
                    return "RootStagingDir";
                }
                case 19: {
                    return "SecurityDDModel";
                }
                case 10: {
                    return "SourcePath";
                }
                case 20: {
                    return "StagingMode";
                }
                case 17: {
                    return "VersionIdentifier";
                }
                case 28: {
                    return "AutoDeployedApp";
                }
                case 27: {
                    return "BackgroundDeployment";
                }
                case 26: {
                    return "InternalApp";
                }
                case 31: {
                    return "OnDemandDisplayRefresh";
                }
                case 18: {
                    return "ValidateDDSecurityData";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("AbsoluteInstallDir")) {
                return 32;
            }
            if (string.equals("AbsolutePlanDir")) {
                return 34;
            }
            if (string.equals("AbsolutePlanPath")) {
                return 33;
            }
            if (string.equals("AbsoluteSourcePath")) {
                return 35;
            }
            if (string.equals("AltDescriptorPath")) {
                return 21;
            }
            if (string.equals("AltWLSDescriptorPath")) {
                return 22;
            }
            if (string.equals("AppMBean")) {
                return 25;
            }
            if (string.equals("ApplicationIdentifier")) {
                return 23;
            }
            if (string.equals("ApplicationName")) {
                return 24;
            }
            if (string.equals("DeploymentPlan")) {
                return 41;
            }
            if (string.equals("DeploymentPlanDescriptor")) {
                return 29;
            }
            if (string.equals("DeploymentPlanExternalDescriptors")) {
                return 42;
            }
            if (string.equals("InstallDir")) {
                return 14;
            }
            if (string.equals("LocalInstallDir")) {
                return 36;
            }
            if (string.equals("LocalPlanDir")) {
                return 38;
            }
            if (string.equals("LocalPlanPath")) {
                return 37;
            }
            if (string.equals("LocalSourcePath")) {
                return 39;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("OnDemandContextPaths")) {
                return 30;
            }
            if (string.equals("PlanDir")) {
                return 15;
            }
            if (string.equals("PlanPath")) {
                return 16;
            }
            if (string.equals("RootStagingDir")) {
                return 40;
            }
            if (string.equals("SecurityDDModel")) {
                return 19;
            }
            if (string.equals("SourcePath")) {
                return 10;
            }
            if (string.equals("StagingMode")) {
                return 20;
            }
            if (string.equals("VersionIdentifier")) {
                return 17;
            }
            if (string.equals("AutoDeployedApp")) {
                return 28;
            }
            if (string.equals("BackgroundDeployment")) {
                return 27;
            }
            if (string.equals("InternalApp")) {
                return 26;
            }
            if (string.equals("OnDemandDisplayRefresh")) {
                return 31;
            }
            if (string.equals("ValidateDDSecurityData")) {
                return 18;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList<ArrayIterator> arrayList = new ArrayList<ArrayIterator>();
            arrayList.add(new ArrayIterator((Object[])this.bean.getSubDeployments()));
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isAbsoluteInstallDirSet()) {
                    stringBuffer.append("AbsoluteInstallDir");
                    stringBuffer.append(String.valueOf(this.bean.getAbsoluteInstallDir()));
                }
                if (this.bean.isAbsolutePlanDirSet()) {
                    stringBuffer.append("AbsolutePlanDir");
                    stringBuffer.append(String.valueOf(this.bean.getAbsolutePlanDir()));
                }
                if (this.bean.isAbsolutePlanPathSet()) {
                    stringBuffer.append("AbsolutePlanPath");
                    stringBuffer.append(String.valueOf(this.bean.getAbsolutePlanPath()));
                }
                if (this.bean.isAbsoluteSourcePathSet()) {
                    stringBuffer.append("AbsoluteSourcePath");
                    stringBuffer.append(String.valueOf(this.bean.getAbsoluteSourcePath()));
                }
                if (this.bean.isAltDescriptorPathSet()) {
                    stringBuffer.append("AltDescriptorPath");
                    stringBuffer.append(String.valueOf(this.bean.getAltDescriptorPath()));
                }
                if (this.bean.isAltWLSDescriptorPathSet()) {
                    stringBuffer.append("AltWLSDescriptorPath");
                    stringBuffer.append(String.valueOf(this.bean.getAltWLSDescriptorPath()));
                }
                if (this.bean.isAppMBeanSet()) {
                    stringBuffer.append("AppMBean");
                    stringBuffer.append(String.valueOf(this.bean.getAppMBean()));
                }
                if (this.bean.isApplicationIdentifierSet()) {
                    stringBuffer.append("ApplicationIdentifier");
                    stringBuffer.append(String.valueOf(this.bean.getApplicationIdentifier()));
                }
                if (this.bean.isApplicationNameSet()) {
                    stringBuffer.append("ApplicationName");
                    stringBuffer.append(String.valueOf(this.bean.getApplicationName()));
                }
                if (this.bean.isDeploymentPlanSet()) {
                    stringBuffer.append("DeploymentPlan");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getDeploymentPlan())));
                }
                if (this.bean.isDeploymentPlanDescriptorSet()) {
                    stringBuffer.append("DeploymentPlanDescriptor");
                    stringBuffer.append(String.valueOf(this.bean.getDeploymentPlanDescriptor()));
                }
                if (this.bean.isDeploymentPlanExternalDescriptorsSet()) {
                    stringBuffer.append("DeploymentPlanExternalDescriptors");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getDeploymentPlanExternalDescriptors())));
                }
                if (this.bean.isInstallDirSet()) {
                    stringBuffer.append("InstallDir");
                    stringBuffer.append(String.valueOf(this.bean.getInstallDir()));
                }
                if (this.bean.isLocalInstallDirSet()) {
                    stringBuffer.append("LocalInstallDir");
                    stringBuffer.append(String.valueOf(this.bean.getLocalInstallDir()));
                }
                if (this.bean.isLocalPlanDirSet()) {
                    stringBuffer.append("LocalPlanDir");
                    stringBuffer.append(String.valueOf(this.bean.getLocalPlanDir()));
                }
                if (this.bean.isLocalPlanPathSet()) {
                    stringBuffer.append("LocalPlanPath");
                    stringBuffer.append(String.valueOf(this.bean.getLocalPlanPath()));
                }
                if (this.bean.isLocalSourcePathSet()) {
                    stringBuffer.append("LocalSourcePath");
                    stringBuffer.append(String.valueOf(this.bean.getLocalSourcePath()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isOnDemandContextPathsSet()) {
                    stringBuffer.append("OnDemandContextPaths");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getOnDemandContextPaths())));
                }
                if (this.bean.isPlanDirSet()) {
                    stringBuffer.append("PlanDir");
                    stringBuffer.append(String.valueOf(this.bean.getPlanDir()));
                }
                if (this.bean.isPlanPathSet()) {
                    stringBuffer.append("PlanPath");
                    stringBuffer.append(String.valueOf(this.bean.getPlanPath()));
                }
                if (this.bean.isRootStagingDirSet()) {
                    stringBuffer.append("RootStagingDir");
                    stringBuffer.append(String.valueOf(this.bean.getRootStagingDir()));
                }
                if (this.bean.isSecurityDDModelSet()) {
                    stringBuffer.append("SecurityDDModel");
                    stringBuffer.append(String.valueOf(this.bean.getSecurityDDModel()));
                }
                if (this.bean.isSourcePathSet()) {
                    stringBuffer.append("SourcePath");
                    stringBuffer.append(String.valueOf(this.bean.getSourcePath()));
                }
                if (this.bean.isStagingModeSet()) {
                    stringBuffer.append("StagingMode");
                    stringBuffer.append(String.valueOf(this.bean.getStagingMode()));
                }
                if (this.bean.isVersionIdentifierSet()) {
                    stringBuffer.append("VersionIdentifier");
                    stringBuffer.append(String.valueOf(this.bean.getVersionIdentifier()));
                }
                if (this.bean.isAutoDeployedAppSet()) {
                    stringBuffer.append("AutoDeployedApp");
                    stringBuffer.append(String.valueOf(this.bean.isAutoDeployedApp()));
                }
                if (this.bean.isBackgroundDeploymentSet()) {
                    stringBuffer.append("BackgroundDeployment");
                    stringBuffer.append(String.valueOf(this.bean.isBackgroundDeployment()));
                }
                if (this.bean.isInternalAppSet()) {
                    stringBuffer.append("InternalApp");
                    stringBuffer.append(String.valueOf(this.bean.isInternalApp()));
                }
                if (this.bean.isOnDemandDisplayRefreshSet()) {
                    stringBuffer.append("OnDemandDisplayRefresh");
                    stringBuffer.append(String.valueOf(this.bean.isOnDemandDisplayRefresh()));
                }
                if (this.bean.isValidateDDSecurityDataSet()) {
                    stringBuffer.append("ValidateDDSecurityData");
                    stringBuffer.append(String.valueOf(this.bean.isValidateDDSecurityData()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                AppDeploymentMBeanImpl appDeploymentMBeanImpl = (AppDeploymentMBeanImpl)abstractDescriptorBean;
                this.computeDiff("AltDescriptorPath", this.bean.getAltDescriptorPath(), appDeploymentMBeanImpl.getAltDescriptorPath(), true);
                this.computeDiff("AltWLSDescriptorPath", this.bean.getAltWLSDescriptorPath(), appDeploymentMBeanImpl.getAltWLSDescriptorPath(), true);
                this.computeDiff("ApplicationIdentifier", this.bean.getApplicationIdentifier(), appDeploymentMBeanImpl.getApplicationIdentifier(), false);
                this.computeDiff("ApplicationName", this.bean.getApplicationName(), appDeploymentMBeanImpl.getApplicationName(), false);
                this.computeDiff("InstallDir", this.bean.getInstallDir(), appDeploymentMBeanImpl.getInstallDir(), false);
                this.computeDiff("Name", this.bean.getName(), appDeploymentMBeanImpl.getName(), false);
                this.computeDiff("PlanDir", this.bean.getPlanDir(), appDeploymentMBeanImpl.getPlanDir(), true);
                this.computeDiff("PlanPath", this.bean.getPlanPath(), appDeploymentMBeanImpl.getPlanPath(), true);
                this.computeDiff("SecurityDDModel", this.bean.getSecurityDDModel(), appDeploymentMBeanImpl.getSecurityDDModel(), false);
                this.computeDiff("SourcePath", this.bean.getSourcePath(), appDeploymentMBeanImpl.getSourcePath(), false);
                this.computeDiff("StagingMode", this.bean.getStagingMode(), appDeploymentMBeanImpl.getStagingMode(), true);
                this.computeDiff("VersionIdentifier", this.bean.getVersionIdentifier(), appDeploymentMBeanImpl.getVersionIdentifier(), false);
                this.computeDiff("ValidateDDSecurityData", this.bean.isValidateDDSecurityData(), appDeploymentMBeanImpl.isValidateDDSecurityData(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                AppDeploymentMBeanImpl appDeploymentMBeanImpl = (AppDeploymentMBeanImpl)beanUpdateEvent.getSourceBean();
                AppDeploymentMBeanImpl appDeploymentMBeanImpl2 = (AppDeploymentMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (!(string.equals("AbsoluteInstallDir") || string.equals("AbsolutePlanDir") || string.equals("AbsolutePlanPath") || string.equals("AbsoluteSourcePath"))) {
                    if (string.equals("AltDescriptorPath")) {
                        appDeploymentMBeanImpl.setAltDescriptorPath(appDeploymentMBeanImpl2.getAltDescriptorPath());
                        appDeploymentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                    } else if (string.equals("AltWLSDescriptorPath")) {
                        appDeploymentMBeanImpl.setAltWLSDescriptorPath(appDeploymentMBeanImpl2.getAltWLSDescriptorPath());
                        appDeploymentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                    } else if (!string.equals("AppMBean")) {
                        if (string.equals("ApplicationIdentifier")) {
                            appDeploymentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                        } else if (string.equals("ApplicationName")) {
                            appDeploymentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                        } else if (!(string.equals("DeploymentPlan") || string.equals("DeploymentPlanDescriptor") || string.equals("DeploymentPlanExternalDescriptors"))) {
                            if (string.equals("InstallDir")) {
                                appDeploymentMBeanImpl.setInstallDir(appDeploymentMBeanImpl2.getInstallDir());
                                appDeploymentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                            } else if (!(string.equals("LocalInstallDir") || string.equals("LocalPlanDir") || string.equals("LocalPlanPath") || string.equals("LocalSourcePath"))) {
                                if (string.equals("Name")) {
                                    appDeploymentMBeanImpl.setName(appDeploymentMBeanImpl2.getName());
                                    appDeploymentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                                } else if (!string.equals("OnDemandContextPaths")) {
                                    if (string.equals("PlanDir")) {
                                        appDeploymentMBeanImpl.setPlanDir(appDeploymentMBeanImpl2.getPlanDir());
                                        appDeploymentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                                    } else if (string.equals("PlanPath")) {
                                        appDeploymentMBeanImpl.setPlanPath(appDeploymentMBeanImpl2.getPlanPath());
                                        appDeploymentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                                    } else if (!string.equals("RootStagingDir")) {
                                        if (string.equals("SecurityDDModel")) {
                                            appDeploymentMBeanImpl.setSecurityDDModel(appDeploymentMBeanImpl2.getSecurityDDModel());
                                            appDeploymentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                                        } else if (string.equals("SourcePath")) {
                                            appDeploymentMBeanImpl.setSourcePath(appDeploymentMBeanImpl2.getSourcePath());
                                            appDeploymentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                                        } else if (string.equals("StagingMode")) {
                                            appDeploymentMBeanImpl.setStagingMode(appDeploymentMBeanImpl2.getStagingMode());
                                            appDeploymentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                                        } else if (string.equals("VersionIdentifier")) {
                                            appDeploymentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                                        } else if (!(string.equals("AutoDeployedApp") || string.equals("BackgroundDeployment") || string.equals("InternalApp") || string.equals("OnDemandDisplayRefresh"))) {
                                            if (string.equals("ValidateDDSecurityData")) {
                                                appDeploymentMBeanImpl.setValidateDDSecurityData(appDeploymentMBeanImpl2.isValidateDDSecurityData());
                                                appDeploymentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                                            } else {
                                                super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                AppDeploymentMBeanImpl appDeploymentMBeanImpl = (AppDeploymentMBeanImpl)abstractDescriptorBean;
                super.finishCopy(appDeploymentMBeanImpl, bl, list);
                if ((list == null || !list.contains("AltDescriptorPath")) && this.bean.isAltDescriptorPathSet()) {
                    appDeploymentMBeanImpl.setAltDescriptorPath(this.bean.getAltDescriptorPath());
                }
                if ((list == null || !list.contains("AltWLSDescriptorPath")) && this.bean.isAltWLSDescriptorPathSet()) {
                    appDeploymentMBeanImpl.setAltWLSDescriptorPath(this.bean.getAltWLSDescriptorPath());
                }
                if (list != null && list.contains("ApplicationIdentifier") || this.bean.isApplicationIdentifierSet()) {
                    // empty if block
                }
                if (list != null && list.contains("ApplicationName") || this.bean.isApplicationNameSet()) {
                    // empty if block
                }
                if ((list == null || !list.contains("InstallDir")) && this.bean.isInstallDirSet()) {
                    appDeploymentMBeanImpl.setInstallDir(this.bean.getInstallDir());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    appDeploymentMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("PlanDir")) && this.bean.isPlanDirSet()) {
                    appDeploymentMBeanImpl.setPlanDir(this.bean.getPlanDir());
                }
                if ((list == null || !list.contains("PlanPath")) && this.bean.isPlanPathSet()) {
                    appDeploymentMBeanImpl.setPlanPath(this.bean.getPlanPath());
                }
                if ((list == null || !list.contains("SecurityDDModel")) && this.bean.isSecurityDDModelSet()) {
                    appDeploymentMBeanImpl.setSecurityDDModel(this.bean.getSecurityDDModel());
                }
                if ((list == null || !list.contains("SourcePath")) && this.bean.isSourcePathSet()) {
                    appDeploymentMBeanImpl.setSourcePath(this.bean.getSourcePath());
                }
                if ((list == null || !list.contains("StagingMode")) && this.bean.isStagingModeSet()) {
                    appDeploymentMBeanImpl.setStagingMode(this.bean.getStagingMode());
                }
                if (list != null && list.contains("VersionIdentifier") || this.bean.isVersionIdentifierSet()) {
                    // empty if block
                }
                if ((list == null || !list.contains("ValidateDDSecurityData")) && this.bean.isValidateDDSecurityDataSet()) {
                    appDeploymentMBeanImpl.setValidateDDSecurityData(this.bean.isValidateDDSecurityData());
                }
                return appDeploymentMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getAppMBean(), clazz, object);
        }
    }
}

