/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.deploy.internal.targetserver.DeployHelper;
import weblogic.descriptor.BeanRemoveRejectedException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BootstrapProperties;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ComponentMBean;
import weblogic.management.configuration.ComponentMBeanImpl;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.ConnectorComponentMBean;
import weblogic.management.configuration.ConnectorComponentMBeanImpl;
import weblogic.management.configuration.EJBComponentMBean;
import weblogic.management.configuration.EJBComponentMBeanImpl;
import weblogic.management.configuration.JDBCPoolComponentMBean;
import weblogic.management.configuration.JDBCPoolComponentMBeanImpl;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.WebAppComponentMBean;
import weblogic.management.configuration.WebAppComponentMBeanImpl;
import weblogic.management.configuration.WebServiceComponentMBean;
import weblogic.management.configuration.WebServiceComponentMBeanImpl;
import weblogic.management.deploy.DeploymentCompatibilityEventHandler;
import weblogic.management.mbeans.custom.Application;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;

public class ApplicationMBeanImpl
extends ConfigurationMBeanImpl
implements ApplicationMBean,
Serializable {
    private String _AltDescriptorPath;
    private String _AltWLSDescriptorPath;
    private AppDeploymentMBean _AppDeployment;
    private ComponentMBean[] _Components;
    private ConnectorComponentMBean[] _ConnectorComponents;
    private boolean _DelegationEnabled;
    private boolean _Deployed;
    private int _DeploymentTimeout;
    private String _DeploymentType;
    private EJBComponentMBean[] _EJBComponents;
    private boolean _Ear;
    private String _FullPath;
    private boolean _InternalApp;
    private int _InternalType;
    private JDBCPoolComponentMBean[] _JDBCPoolComponents;
    private int _LoadOrder;
    private String _Name;
    private String _Notes;
    private String _Path;
    private String[] _StagedTargets;
    private String _StagingMode;
    private String _StagingPath;
    private boolean _TwoPhase;
    private WebAppComponentMBean[] _WebAppComponents;
    private WebServiceComponentMBean[] _WebServiceComponents;
    private Application _customizer;
    private static SchemaHelper2 _schemaHelper;

    public ApplicationMBeanImpl() {
        try {
            this._customizer = new Application(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public ApplicationMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new Application(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public String getPath() {
        return this._customizer.getPath();
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isPathSet() {
        return this._isSet(7);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setPath(String string) throws ManagementException, InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this.getPath();
        this._customizer.setPath(string);
        this._postSet(7, string2, string);
    }

    public ComponentMBean[] getComponents() {
        return this._customizer.getComponents();
    }

    public String getNotes() {
        return this._customizer.getNotes();
    }

    public boolean isComponentsSet() {
        return this._isSet(8);
    }

    public boolean isNotesSet() {
        return this._isSet(3);
    }

    public boolean addComponent(ComponentMBean componentMBean) throws InvalidAttributeValueException, DistributedManagementException {
        this._getHelper()._ensureNonNull((Object)componentMBean);
        if (!((AbstractDescriptorBean)componentMBean).isChildProperty((DescriptorBean)this, 8)) {
            ComponentMBean[] componentMBeanArray = (ComponentMBean[])this._getHelper()._extendArray((Object)this.getComponents(), ComponentMBean.class, (Object)componentMBean);
            try {
                this.setComponents(componentMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public void setNotes(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String string2 = this.getNotes();
        this._customizer.setNotes(string);
        this._postSet(3, string2, string);
    }

    public boolean removeComponent(ComponentMBean componentMBean) throws InvalidAttributeValueException, DistributedManagementException {
        ComponentMBean[] componentMBeanArray = this.getComponents();
        ComponentMBean[] componentMBeanArray2 = (ComponentMBean[])this._getHelper()._removeElement((Object)componentMBeanArray, ComponentMBean.class, (Object)componentMBean);
        if (componentMBeanArray2.length != componentMBeanArray.length) {
            try {
                this.setComponents(componentMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public void setComponents(ComponentMBean[] componentMBeanArray) {
        componentMBeanArray = componentMBeanArray == null ? new ComponentMBeanImpl[]{} : componentMBeanArray;
        this._Components = componentMBeanArray;
    }

    public WebAppComponentMBean createWebAppComponent(String string) {
        WebAppComponentMBeanImpl webAppComponentMBeanImpl = new WebAppComponentMBeanImpl(this, -1);
        try {
            webAppComponentMBeanImpl.setName(string);
            this.addWebAppComponent(webAppComponentMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return webAppComponentMBeanImpl;
    }

    public void destroyWebAppComponent(WebAppComponentMBean webAppComponentMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(webAppComponentMBean, 9);
                WebAppComponentMBean[] webAppComponentMBeanArray = this.getWebAppComponents();
                WebAppComponentMBean[] webAppComponentMBeanArray2 = (WebAppComponentMBean[])this._getHelper()._removeElement((Object)webAppComponentMBeanArray, WebAppComponentMBean.class, (Object)webAppComponentMBean);
                if (webAppComponentMBeanArray.length == webAppComponentMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)webAppComponentMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)webAppComponentMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setWebAppComponents(webAppComponentMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public WebAppComponentMBean lookupWebAppComponent(String string) {
        for (WebAppComponentMBeanImpl webAppComponentMBeanImpl : Arrays.asList((Object[])this._WebAppComponents)) {
            String string2 = string;
            if (!webAppComponentMBeanImpl.getName().equals(string2)) continue;
            return webAppComponentMBeanImpl;
        }
        return null;
    }

    public void addWebAppComponent(WebAppComponentMBean webAppComponentMBean) {
        this._getHelper()._ensureNonNull((Object)webAppComponentMBean);
        if (!((AbstractDescriptorBean)webAppComponentMBean).isChildProperty((DescriptorBean)this, 9)) {
            WebAppComponentMBean[] webAppComponentMBeanArray = this._isSet(9) ? (WebAppComponentMBean[])this._getHelper()._extendArray((Object)this.getWebAppComponents(), WebAppComponentMBean.class, (Object)webAppComponentMBean) : new WebAppComponentMBean[]{webAppComponentMBean};
            try {
                this.setWebAppComponents(webAppComponentMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public WebAppComponentMBean[] getWebAppComponents() {
        return this._WebAppComponents;
    }

    public boolean isWebAppComponentsSet() {
        return this._isSet(9);
    }

    public void removeWebAppComponent(WebAppComponentMBean webAppComponentMBean) {
        this.destroyWebAppComponent(webAppComponentMBean);
    }

    public void setWebAppComponents(WebAppComponentMBean[] webAppComponentMBeanArray) throws InvalidAttributeValueException {
        webAppComponentMBeanArray = webAppComponentMBeanArray == null ? new WebAppComponentMBeanImpl[]{} : webAppComponentMBeanArray;
        for (int i = 0; i < webAppComponentMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)webAppComponentMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 9)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, true);
            this._postCreate(abstractDescriptorBean);
        }
        WebAppComponentMBean[] webAppComponentMBeanArray2 = this._WebAppComponents;
        this._WebAppComponents = webAppComponentMBeanArray;
        this._postSet(9, webAppComponentMBeanArray2, webAppComponentMBeanArray);
    }

    public boolean isEar() {
        return this._customizer.isEar();
    }

    public boolean isEarSet() {
        return this._isSet(10);
    }

    public void setEar(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._Ear;
        this._Ear = bl;
        this._postSet(10, bl2, bl);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public String getFullPath() {
        return this._customizer.getFullPath();
    }

    public boolean isFullPathSet() {
        return this._isSet(11);
    }

    public void setFullPath(String string) throws InvalidAttributeValueException {
        this._FullPath = string = string == null ? null : string.trim();
    }

    public boolean isInternalApp() {
        return this._customizer.isInternalApp();
    }

    public boolean isInternalAppSet() {
        return this._isSet(12);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setInternalApp(boolean bl) {
        this._customizer.setInternalApp(bl);
    }

    public String getStagingPath() {
        return this._StagingPath;
    }

    public boolean isStagingPathSet() {
        return this._isSet(13);
    }

    public void setStagingPath(String string) throws InvalidAttributeValueException {
        this._StagingPath = string = string == null ? null : string.trim();
    }

    public String[] getStagedTargets() {
        return this._StagedTargets;
    }

    public boolean isStagedTargetsSet() {
        return this._isSet(14);
    }

    public void addStagedTarget(String string) {
        this._getHelper()._ensureNonNull((Object)string);
        String[] stringArray = this._isSet(14) ? (String[])this._getHelper()._extendArray((Object)this.getStagedTargets(), String.class, (Object)string) : new String[]{string};
        try {
            this.setStagedTargets(stringArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public void removeStagedTarget(String string) {
        String[] stringArray = this.getStagedTargets();
        String[] stringArray2 = (String[])this._getHelper()._removeElement((Object)stringArray, String.class, (Object)string);
        if (stringArray2.length != stringArray.length) {
            try {
                this.setStagedTargets(stringArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void setStagedTargets(String[] stringArray) {
        stringArray = stringArray == null ? new String[]{} : stringArray;
        stringArray = this._getHelper()._trimElements(stringArray);
        String[] stringArray2 = this._StagedTargets;
        this._StagedTargets = stringArray;
        this._postSet(14, stringArray2, stringArray);
    }

    public void unstageTargets(String[] stringArray) {
        this._customizer.unstageTargets(stringArray);
    }

    public String getStagingMode() {
        if (!this._isSet(15)) {
            try {
                return DeployHelper.determineDefaultStagingMode(this.getParent().getName()) == "nostage" ? "nostage" : (DeployHelper.determineDefaultStagingMode(this.getParent().getName()) == ServerMBean.DEFAULT_STAGE ? ApplicationMBean.DEFAULT_STAGE : "stage");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getStagingMode();
    }

    public boolean isStagingModeSet() {
        return this._isSet(15);
    }

    public void setStagingMode(String string) throws ManagementException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{ApplicationMBean.DEFAULT_STAGE, "nostage", "stage", "external_stage"};
        string = LegalChecks.checkInEnum((String)"StagingMode", (String)string, (String[])stringArray);
        String string2 = this.getStagingMode();
        this._customizer.setStagingMode(string);
        this._postSet(15, string2, string);
    }

    public boolean stagingEnabled(String string) {
        return this._customizer.stagingEnabled(string);
    }

    public boolean staged(String string) {
        return this._customizer.staged(string);
    }

    public boolean useStagingDirectory(String string) {
        return this._customizer.useStagingDirectory(string);
    }

    public void sendAppLevelNotification(String string, String string2, String string3) {
        this._customizer.sendAppLevelNotification(string, string2, string3);
    }

    public void sendModuleNotification(String string, String string2, String string3, String string4, String string5, String string6, long l) {
        this._customizer.sendModuleNotification(string, string2, string3, string4, string5, string6, l);
    }

    public boolean isTwoPhase() {
        return this._customizer.isTwoPhase();
    }

    public boolean isTwoPhaseSet() {
        return this._isSet(16);
    }

    public void setTwoPhase(boolean bl) {
        boolean bl2 = this._TwoPhase;
        this._TwoPhase = bl;
        this._postSet(16, bl2, bl);
    }

    public int getLoadOrder() {
        return this._LoadOrder;
    }

    public boolean isLoadOrderSet() {
        return this._isSet(17);
    }

    public void setLoadOrder(int n) {
        int n2 = this._LoadOrder;
        this._LoadOrder = n;
        this._postSet(17, n2, n);
    }

    public String getDeploymentType() {
        return this._customizer.getDeploymentType();
    }

    public boolean isDeploymentTypeSet() {
        return this._isSet(18);
    }

    public void setDeploymentType(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{ApplicationMBean.TYPE_EAR, ApplicationMBean.TYPE_EXPLODED_EAR, ApplicationMBean.TYPE_COMPONENT, ApplicationMBean.TYPE_EXPLODED_COMPONENT, ApplicationMBean.TYPE_UNKNOWN};
        string = LegalChecks.checkInEnum((String)"DeploymentType", (String)string, (String[])stringArray);
        this._customizer.setDeploymentType(string);
    }

    public int getDeploymentTimeout() {
        return this._DeploymentTimeout;
    }

    public boolean isDeploymentTimeoutSet() {
        return this._isSet(19);
    }

    public void setDeploymentTimeout(int n) {
        int n2 = this._DeploymentTimeout;
        this._DeploymentTimeout = n;
        this._postSet(19, n2, n);
    }

    public String getAltDescriptorPath() {
        return this._AltDescriptorPath;
    }

    public boolean isAltDescriptorPathSet() {
        return this._isSet(20);
    }

    public void setAltDescriptorPath(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._AltDescriptorPath;
        this._AltDescriptorPath = string;
        this._postSet(20, string2, string);
    }

    public String getAltWLSDescriptorPath() {
        return this._AltWLSDescriptorPath;
    }

    public boolean isAltWLSDescriptorPathSet() {
        return this._isSet(21);
    }

    public void setAltWLSDescriptorPath(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._AltWLSDescriptorPath;
        this._AltWLSDescriptorPath = string;
        this._postSet(21, string2, string);
    }

    public void refreshDDsIfNeeded(String[] stringArray, String[] stringArray2) {
        this._customizer.refreshDDsIfNeeded(stringArray, stringArray2);
    }

    public boolean isDeployed() {
        return this._customizer.isDeployed();
    }

    public boolean isDeployedSet() {
        return this._isSet(22);
    }

    public void setDeployed(boolean bl) {
        boolean bl2 = this.isDeployed();
        this._customizer.setDeployed(bl);
        this._postSet(22, bl2, bl);
    }

    public EJBComponentMBean createEJBComponent(String string) {
        EJBComponentMBeanImpl eJBComponentMBeanImpl = new EJBComponentMBeanImpl(this, -1);
        try {
            eJBComponentMBeanImpl.setName(string);
            this.addEJBComponent(eJBComponentMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return eJBComponentMBeanImpl;
    }

    public void destroyEJBComponent(EJBComponentMBean eJBComponentMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(eJBComponentMBean, 23);
                EJBComponentMBean[] eJBComponentMBeanArray = this.getEJBComponents();
                EJBComponentMBean[] eJBComponentMBeanArray2 = (EJBComponentMBean[])this._getHelper()._removeElement((Object)eJBComponentMBeanArray, EJBComponentMBean.class, (Object)eJBComponentMBean);
                if (eJBComponentMBeanArray.length == eJBComponentMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)eJBComponentMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)eJBComponentMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setEJBComponents(eJBComponentMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public EJBComponentMBean lookupEJBComponent(String string) {
        for (EJBComponentMBeanImpl eJBComponentMBeanImpl : Arrays.asList((Object[])this._EJBComponents)) {
            String string2 = string;
            if (!eJBComponentMBeanImpl.getName().equals(string2)) continue;
            return eJBComponentMBeanImpl;
        }
        return null;
    }

    public void addEJBComponent(EJBComponentMBean eJBComponentMBean) {
        this._getHelper()._ensureNonNull((Object)eJBComponentMBean);
        if (!((AbstractDescriptorBean)eJBComponentMBean).isChildProperty((DescriptorBean)this, 23)) {
            EJBComponentMBean[] eJBComponentMBeanArray = this._isSet(23) ? (EJBComponentMBean[])this._getHelper()._extendArray((Object)this.getEJBComponents(), EJBComponentMBean.class, (Object)eJBComponentMBean) : new EJBComponentMBean[]{eJBComponentMBean};
            try {
                this.setEJBComponents(eJBComponentMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public EJBComponentMBean[] getEJBComponents() {
        return this._EJBComponents;
    }

    public boolean isEJBComponentsSet() {
        return this._isSet(23);
    }

    public void removeEJBComponent(EJBComponentMBean eJBComponentMBean) {
        this.destroyEJBComponent(eJBComponentMBean);
    }

    public void setEJBComponents(EJBComponentMBean[] eJBComponentMBeanArray) throws InvalidAttributeValueException {
        eJBComponentMBeanArray = eJBComponentMBeanArray == null ? new EJBComponentMBeanImpl[]{} : eJBComponentMBeanArray;
        for (int i = 0; i < eJBComponentMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)eJBComponentMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 23)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, true);
            this._postCreate(abstractDescriptorBean);
        }
        EJBComponentMBean[] eJBComponentMBeanArray2 = this._EJBComponents;
        this._EJBComponents = eJBComponentMBeanArray;
        this._postSet(23, eJBComponentMBeanArray2, eJBComponentMBeanArray);
    }

    public ConnectorComponentMBean createConnectorComponent(String string) {
        ConnectorComponentMBeanImpl connectorComponentMBeanImpl = new ConnectorComponentMBeanImpl(this, -1);
        try {
            connectorComponentMBeanImpl.setName(string);
            this.addConnectorComponent(connectorComponentMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return connectorComponentMBeanImpl;
    }

    public void destroyConnectorComponent(ConnectorComponentMBean connectorComponentMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(connectorComponentMBean, 24);
                ConnectorComponentMBean[] connectorComponentMBeanArray = this.getConnectorComponents();
                ConnectorComponentMBean[] connectorComponentMBeanArray2 = (ConnectorComponentMBean[])this._getHelper()._removeElement((Object)connectorComponentMBeanArray, ConnectorComponentMBean.class, (Object)connectorComponentMBean);
                if (connectorComponentMBeanArray.length == connectorComponentMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)connectorComponentMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)connectorComponentMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setConnectorComponents(connectorComponentMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public ConnectorComponentMBean lookupConnectorComponent(String string) {
        for (ConnectorComponentMBeanImpl connectorComponentMBeanImpl : Arrays.asList((Object[])this._ConnectorComponents)) {
            String string2 = string;
            if (!connectorComponentMBeanImpl.getName().equals(string2)) continue;
            return connectorComponentMBeanImpl;
        }
        return null;
    }

    public void addConnectorComponent(ConnectorComponentMBean connectorComponentMBean) {
        this._getHelper()._ensureNonNull((Object)connectorComponentMBean);
        if (!((AbstractDescriptorBean)connectorComponentMBean).isChildProperty((DescriptorBean)this, 24)) {
            ConnectorComponentMBean[] connectorComponentMBeanArray = this._isSet(24) ? (ConnectorComponentMBean[])this._getHelper()._extendArray((Object)this.getConnectorComponents(), ConnectorComponentMBean.class, (Object)connectorComponentMBean) : new ConnectorComponentMBean[]{connectorComponentMBean};
            try {
                this.setConnectorComponents(connectorComponentMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public ConnectorComponentMBean[] getConnectorComponents() {
        return this._ConnectorComponents;
    }

    public boolean isConnectorComponentsSet() {
        return this._isSet(24);
    }

    public void removeConnectorComponent(ConnectorComponentMBean connectorComponentMBean) {
        this.destroyConnectorComponent(connectorComponentMBean);
    }

    public void setConnectorComponents(ConnectorComponentMBean[] connectorComponentMBeanArray) throws InvalidAttributeValueException {
        connectorComponentMBeanArray = connectorComponentMBeanArray == null ? new ConnectorComponentMBeanImpl[]{} : connectorComponentMBeanArray;
        for (int i = 0; i < connectorComponentMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)connectorComponentMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 24)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, true);
            this._postCreate(abstractDescriptorBean);
        }
        ConnectorComponentMBean[] connectorComponentMBeanArray2 = this._ConnectorComponents;
        this._ConnectorComponents = connectorComponentMBeanArray;
        this._postSet(24, connectorComponentMBeanArray2, connectorComponentMBeanArray);
    }

    public WebServiceComponentMBean createWebServiceComponent(String string) {
        WebServiceComponentMBeanImpl webServiceComponentMBeanImpl = new WebServiceComponentMBeanImpl(this, -1);
        try {
            webServiceComponentMBeanImpl.setName(string);
            this.addWebServiceComponent(webServiceComponentMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return webServiceComponentMBeanImpl;
    }

    public void destroyWebServiceComponent(WebServiceComponentMBean webServiceComponentMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(webServiceComponentMBean, 25);
                WebServiceComponentMBean[] webServiceComponentMBeanArray = this.getWebServiceComponents();
                WebServiceComponentMBean[] webServiceComponentMBeanArray2 = (WebServiceComponentMBean[])this._getHelper()._removeElement((Object)webServiceComponentMBeanArray, WebServiceComponentMBean.class, (Object)webServiceComponentMBean);
                if (webServiceComponentMBeanArray.length == webServiceComponentMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)webServiceComponentMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)webServiceComponentMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setWebServiceComponents(webServiceComponentMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public ComponentMBean createDummyComponent(String string) {
        ComponentMBeanImpl componentMBeanImpl = new ComponentMBeanImpl(this, -1);
        try {
            componentMBeanImpl.setName(string);
            this.addComponent(componentMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return componentMBeanImpl;
    }

    public WebServiceComponentMBean lookupWebServiceComponent(String string) {
        for (WebServiceComponentMBeanImpl webServiceComponentMBeanImpl : Arrays.asList((Object[])this._WebServiceComponents)) {
            String string2 = string;
            if (!webServiceComponentMBeanImpl.getName().equals(string2)) continue;
            return webServiceComponentMBeanImpl;
        }
        return null;
    }

    public void addWebServiceComponent(WebServiceComponentMBean webServiceComponentMBean) {
        this._getHelper()._ensureNonNull((Object)webServiceComponentMBean);
        if (!((AbstractDescriptorBean)webServiceComponentMBean).isChildProperty((DescriptorBean)this, 25)) {
            WebServiceComponentMBean[] webServiceComponentMBeanArray = this._isSet(25) ? (WebServiceComponentMBean[])this._getHelper()._extendArray((Object)this.getWebServiceComponents(), WebServiceComponentMBean.class, (Object)webServiceComponentMBean) : new WebServiceComponentMBean[]{webServiceComponentMBean};
            try {
                this.setWebServiceComponents(webServiceComponentMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public WebServiceComponentMBean[] getWebServiceComponents() {
        return this._WebServiceComponents;
    }

    public boolean isWebServiceComponentsSet() {
        return this._isSet(25);
    }

    public void removeWebServiceComponent(WebServiceComponentMBean webServiceComponentMBean) {
        this.destroyWebServiceComponent(webServiceComponentMBean);
    }

    public void setWebServiceComponents(WebServiceComponentMBean[] webServiceComponentMBeanArray) throws InvalidAttributeValueException {
        webServiceComponentMBeanArray = webServiceComponentMBeanArray == null ? new WebServiceComponentMBeanImpl[]{} : webServiceComponentMBeanArray;
        for (int i = 0; i < webServiceComponentMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)webServiceComponentMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 25)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, true);
            this._postCreate(abstractDescriptorBean);
        }
        WebServiceComponentMBean[] webServiceComponentMBeanArray2 = this._WebServiceComponents;
        this._WebServiceComponents = webServiceComponentMBeanArray;
        this._postSet(25, webServiceComponentMBeanArray2, webServiceComponentMBeanArray);
    }

    public JDBCPoolComponentMBean createJDBCPoolComponent(String string) {
        JDBCPoolComponentMBeanImpl jDBCPoolComponentMBeanImpl = new JDBCPoolComponentMBeanImpl(this, -1);
        try {
            jDBCPoolComponentMBeanImpl.setName(string);
            this.addJDBCPoolComponent(jDBCPoolComponentMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return jDBCPoolComponentMBeanImpl;
    }

    public void destroyJDBCPoolComponent(JDBCPoolComponentMBean jDBCPoolComponentMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(jDBCPoolComponentMBean, 26);
                JDBCPoolComponentMBean[] jDBCPoolComponentMBeanArray = this.getJDBCPoolComponents();
                JDBCPoolComponentMBean[] jDBCPoolComponentMBeanArray2 = (JDBCPoolComponentMBean[])this._getHelper()._removeElement((Object)jDBCPoolComponentMBeanArray, JDBCPoolComponentMBean.class, (Object)jDBCPoolComponentMBean);
                if (jDBCPoolComponentMBeanArray.length == jDBCPoolComponentMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)jDBCPoolComponentMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)jDBCPoolComponentMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setJDBCPoolComponents(jDBCPoolComponentMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public JDBCPoolComponentMBean lookupJDBCPoolComponent(String string) {
        for (JDBCPoolComponentMBeanImpl jDBCPoolComponentMBeanImpl : Arrays.asList((Object[])this._JDBCPoolComponents)) {
            String string2 = string;
            if (!jDBCPoolComponentMBeanImpl.getName().equals(string2)) continue;
            return jDBCPoolComponentMBeanImpl;
        }
        return null;
    }

    public void addJDBCPoolComponent(JDBCPoolComponentMBean jDBCPoolComponentMBean) {
        this._getHelper()._ensureNonNull((Object)jDBCPoolComponentMBean);
        if (!((AbstractDescriptorBean)jDBCPoolComponentMBean).isChildProperty((DescriptorBean)this, 26)) {
            JDBCPoolComponentMBean[] jDBCPoolComponentMBeanArray = this._isSet(26) ? (JDBCPoolComponentMBean[])this._getHelper()._extendArray((Object)this.getJDBCPoolComponents(), JDBCPoolComponentMBean.class, (Object)jDBCPoolComponentMBean) : new JDBCPoolComponentMBean[]{jDBCPoolComponentMBean};
            try {
                this.setJDBCPoolComponents(jDBCPoolComponentMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public JDBCPoolComponentMBean[] getJDBCPoolComponents() {
        return this._JDBCPoolComponents;
    }

    public boolean isJDBCPoolComponentsSet() {
        return this._isSet(26);
    }

    public void removeJDBCPoolComponent(JDBCPoolComponentMBean jDBCPoolComponentMBean) {
        this.destroyJDBCPoolComponent(jDBCPoolComponentMBean);
    }

    public void setJDBCPoolComponents(JDBCPoolComponentMBean[] jDBCPoolComponentMBeanArray) throws InvalidAttributeValueException {
        jDBCPoolComponentMBeanArray = jDBCPoolComponentMBeanArray == null ? new JDBCPoolComponentMBeanImpl[]{} : jDBCPoolComponentMBeanArray;
        for (int i = 0; i < jDBCPoolComponentMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)jDBCPoolComponentMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 26)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, true);
            this._postCreate(abstractDescriptorBean);
        }
        JDBCPoolComponentMBean[] jDBCPoolComponentMBeanArray2 = this._JDBCPoolComponents;
        this._JDBCPoolComponents = jDBCPoolComponentMBeanArray;
        this._postSet(26, jDBCPoolComponentMBeanArray2, jDBCPoolComponentMBeanArray);
    }

    public int getInternalType() {
        return this._customizer.getInternalType();
    }

    public boolean isInternalTypeSet() {
        return this._isSet(27);
    }

    public void setInternalType(int n) throws InvalidAttributeValueException {
        this._InternalType = n;
    }

    public void setAppDeployment(AppDeploymentMBean appDeploymentMBean) {
        this._AppDeployment = appDeploymentMBean;
    }

    public AppDeploymentMBean getAppDeployment() {
        return this._customizer.getAppDeployment();
    }

    public boolean isAppDeploymentSet() {
        return this._isSet(28);
    }

    public AppDeploymentMBean returnDeployableUnit() {
        return this._customizer.returnDeployableUnit();
    }

    public void setDelegationEnabled(boolean bl) {
        this._customizer.setDelegationEnabled(bl);
    }

    public boolean isDelegationEnabled() {
        return this._customizer.isDelegationEnabled();
    }

    public boolean isDelegationEnabledSet() {
        return this._isSet(29);
    }

    public void addHandler(DeploymentCompatibilityEventHandler deploymentCompatibilityEventHandler) {
        this._customizer.addHandler(deploymentCompatibilityEventHandler);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 20;
        }
        try {
            switch (n) {
                case 20: {
                    this._AltDescriptorPath = null;
                    if (bl) break;
                }
                case 21: {
                    this._AltWLSDescriptorPath = null;
                    if (bl) break;
                }
                case 28: {
                    this._AppDeployment = null;
                    if (bl) break;
                }
                case 8: {
                    this._Components = new ComponentMBean[0];
                    if (bl) break;
                }
                case 24: {
                    this._ConnectorComponents = new ConnectorComponentMBean[0];
                    if (bl) break;
                }
                case 19: {
                    this._DeploymentTimeout = 3600000;
                    if (bl) break;
                }
                case 18: {
                    this._customizer.setDeploymentType(ApplicationMBean.TYPE_UNKNOWN);
                    if (bl) break;
                }
                case 23: {
                    this._EJBComponents = new EJBComponentMBean[0];
                    if (bl) break;
                }
                case 11: {
                    this._FullPath = null;
                    if (bl) break;
                }
                case 27: {
                    this._InternalType = 0;
                    if (bl) break;
                }
                case 26: {
                    this._JDBCPoolComponents = new JDBCPoolComponentMBean[0];
                    if (bl) break;
                }
                case 17: {
                    this._LoadOrder = 100;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 3: {
                    this._customizer.setNotes(null);
                    if (bl) break;
                }
                case 7: {
                    this._customizer.setPath(null);
                    if (bl) break;
                }
                case 14: {
                    this._StagedTargets = new String[0];
                    if (bl) break;
                }
                case 15: {
                    this._customizer.setStagingMode(null);
                    if (bl) break;
                }
                case 13: {
                    this._StagingPath = null;
                    if (bl) break;
                }
                case 9: {
                    this._WebAppComponents = new WebAppComponentMBean[0];
                    if (bl) break;
                }
                case 25: {
                    this._WebServiceComponents = new WebServiceComponentMBean[0];
                    if (bl) break;
                }
                case 29: {
                    this._customizer.setDelegationEnabled(false);
                    if (bl) break;
                }
                case 22: {
                    this._customizer.setDeployed(false);
                    if (bl) break;
                }
                case 10: {
                    this._Ear = false;
                    if (bl) break;
                }
                case 12: {
                    this._customizer.setInternalApp(false);
                    if (bl) break;
                }
                case 16: {
                    this._TwoPhase = true;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "Application";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AltDescriptorPath")) {
            String string2 = this._AltDescriptorPath;
            this._AltDescriptorPath = (String)object;
            this._postSet(20, string2, this._AltDescriptorPath);
            return;
        }
        if (string.equals("AltWLSDescriptorPath")) {
            String string3 = this._AltWLSDescriptorPath;
            this._AltWLSDescriptorPath = (String)object;
            this._postSet(21, string3, this._AltWLSDescriptorPath);
            return;
        }
        if (string.equals("AppDeployment")) {
            AppDeploymentMBean appDeploymentMBean = this._AppDeployment;
            this._AppDeployment = (AppDeploymentMBean)object;
            this._postSet(28, appDeploymentMBean, this._AppDeployment);
            return;
        }
        if (string.equals("Components")) {
            ComponentMBean[] componentMBeanArray = this._Components;
            this._Components = (ComponentMBean[])object;
            this._postSet(8, componentMBeanArray, this._Components);
            return;
        }
        if (string.equals("ConnectorComponents")) {
            ConnectorComponentMBean[] connectorComponentMBeanArray = this._ConnectorComponents;
            this._ConnectorComponents = (ConnectorComponentMBean[])object;
            this._postSet(24, connectorComponentMBeanArray, this._ConnectorComponents);
            return;
        }
        if (string.equals("DelegationEnabled")) {
            boolean bl = this._DelegationEnabled;
            this._DelegationEnabled = (Boolean)object;
            this._postSet(29, bl, this._DelegationEnabled);
            return;
        }
        if (string.equals("Deployed")) {
            boolean bl = this._Deployed;
            this._Deployed = (Boolean)object;
            this._postSet(22, bl, this._Deployed);
            return;
        }
        if (string.equals("DeploymentTimeout")) {
            int n = this._DeploymentTimeout;
            this._DeploymentTimeout = (Integer)object;
            this._postSet(19, n, this._DeploymentTimeout);
            return;
        }
        if (string.equals("DeploymentType")) {
            String string4 = this._DeploymentType;
            this._DeploymentType = (String)object;
            this._postSet(18, string4, this._DeploymentType);
            return;
        }
        if (string.equals("EJBComponents")) {
            EJBComponentMBean[] eJBComponentMBeanArray = this._EJBComponents;
            this._EJBComponents = (EJBComponentMBean[])object;
            this._postSet(23, eJBComponentMBeanArray, this._EJBComponents);
            return;
        }
        if (string.equals("Ear")) {
            boolean bl = this._Ear;
            this._Ear = (Boolean)object;
            this._postSet(10, bl, this._Ear);
            return;
        }
        if (string.equals("FullPath")) {
            String string5 = this._FullPath;
            this._FullPath = (String)object;
            this._postSet(11, string5, this._FullPath);
            return;
        }
        if (string.equals("InternalApp")) {
            boolean bl = this._InternalApp;
            this._InternalApp = (Boolean)object;
            this._postSet(12, bl, this._InternalApp);
            return;
        }
        if (string.equals("InternalType")) {
            int n = this._InternalType;
            this._InternalType = (Integer)object;
            this._postSet(27, n, this._InternalType);
            return;
        }
        if (string.equals("JDBCPoolComponents")) {
            JDBCPoolComponentMBean[] jDBCPoolComponentMBeanArray = this._JDBCPoolComponents;
            this._JDBCPoolComponents = (JDBCPoolComponentMBean[])object;
            this._postSet(26, jDBCPoolComponentMBeanArray, this._JDBCPoolComponents);
            return;
        }
        if (string.equals("LoadOrder")) {
            int n = this._LoadOrder;
            this._LoadOrder = (Integer)object;
            this._postSet(17, n, this._LoadOrder);
            return;
        }
        if (string.equals("Name")) {
            String string6 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string6, this._Name);
            return;
        }
        if (string.equals("Notes")) {
            String string7 = this._Notes;
            this._Notes = (String)object;
            this._postSet(3, string7, this._Notes);
            return;
        }
        if (string.equals("Path")) {
            String string8 = this._Path;
            this._Path = (String)object;
            this._postSet(7, string8, this._Path);
            return;
        }
        if (string.equals("StagedTargets")) {
            String[] stringArray = this._StagedTargets;
            this._StagedTargets = (String[])object;
            this._postSet(14, stringArray, this._StagedTargets);
            return;
        }
        if (string.equals("StagingMode")) {
            String string9 = this._StagingMode;
            this._StagingMode = (String)object;
            this._postSet(15, string9, this._StagingMode);
            return;
        }
        if (string.equals("StagingPath")) {
            String string10 = this._StagingPath;
            this._StagingPath = (String)object;
            this._postSet(13, string10, this._StagingPath);
            return;
        }
        if (string.equals("TwoPhase")) {
            boolean bl = this._TwoPhase;
            this._TwoPhase = (Boolean)object;
            this._postSet(16, bl, this._TwoPhase);
            return;
        }
        if (string.equals("WebAppComponents")) {
            WebAppComponentMBean[] webAppComponentMBeanArray = this._WebAppComponents;
            this._WebAppComponents = (WebAppComponentMBean[])object;
            this._postSet(9, webAppComponentMBeanArray, this._WebAppComponents);
            return;
        }
        if (string.equals("WebServiceComponents")) {
            WebServiceComponentMBean[] webServiceComponentMBeanArray = this._WebServiceComponents;
            this._WebServiceComponents = (WebServiceComponentMBean[])object;
            this._postSet(25, webServiceComponentMBeanArray, this._WebServiceComponents);
            return;
        }
        if (string.equals("customizer")) {
            Application application = this._customizer;
            this._customizer = (Application)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AltDescriptorPath")) {
            return this._AltDescriptorPath;
        }
        if (string.equals("AltWLSDescriptorPath")) {
            return this._AltWLSDescriptorPath;
        }
        if (string.equals("AppDeployment")) {
            return this._AppDeployment;
        }
        if (string.equals("Components")) {
            return this._Components;
        }
        if (string.equals("ConnectorComponents")) {
            return this._ConnectorComponents;
        }
        if (string.equals("DelegationEnabled")) {
            return new Boolean(this._DelegationEnabled);
        }
        if (string.equals("Deployed")) {
            return new Boolean(this._Deployed);
        }
        if (string.equals("DeploymentTimeout")) {
            return new Integer(this._DeploymentTimeout);
        }
        if (string.equals("DeploymentType")) {
            return this._DeploymentType;
        }
        if (string.equals("EJBComponents")) {
            return this._EJBComponents;
        }
        if (string.equals("Ear")) {
            return new Boolean(this._Ear);
        }
        if (string.equals("FullPath")) {
            return this._FullPath;
        }
        if (string.equals("InternalApp")) {
            return new Boolean(this._InternalApp);
        }
        if (string.equals("InternalType")) {
            return new Integer(this._InternalType);
        }
        if (string.equals("JDBCPoolComponents")) {
            return this._JDBCPoolComponents;
        }
        if (string.equals("LoadOrder")) {
            return new Integer(this._LoadOrder);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("Notes")) {
            return this._Notes;
        }
        if (string.equals("Path")) {
            return this._Path;
        }
        if (string.equals("StagedTargets")) {
            return this._StagedTargets;
        }
        if (string.equals("StagingMode")) {
            return this._StagingMode;
        }
        if (string.equals("StagingPath")) {
            return this._StagingPath;
        }
        if (string.equals("TwoPhase")) {
            return new Boolean(this._TwoPhase);
        }
        if (string.equals("WebAppComponents")) {
            return this._WebAppComponents;
        }
        if (string.equals("WebServiceComponents")) {
            return this._WebServiceComponents;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 19: {
                    if (string.equals("alt-descriptor-path")) {
                        return 20;
                    }
                    if (string.equals("connector-component")) {
                        return 24;
                    }
                    if (!string.equals("jdbc-pool-component")) break;
                    return 26;
                }
                case 22: {
                    if (!string.equals("altwls-descriptor-path")) break;
                    return 21;
                }
                case 14: {
                    if (!string.equals("app-deployment")) break;
                    return 28;
                }
                case 9: {
                    if (string.equals("component")) {
                        return 8;
                    }
                    if (string.equals("full-path")) {
                        return 11;
                    }
                    if (!string.equals("two-phase")) break;
                    return 16;
                }
                case 18: {
                    if (string.equals("deployment-timeout")) {
                        return 19;
                    }
                    if (!string.equals("delegation-enabled")) break;
                    return 29;
                }
                case 15: {
                    if (!string.equals("deployment-type")) break;
                    return 18;
                }
                case 13: {
                    if (string.equals("ejb-component")) {
                        return 23;
                    }
                    if (string.equals("internal-type")) {
                        return 27;
                    }
                    if (!string.equals("staged-target")) break;
                    return 14;
                }
                case 10: {
                    if (!string.equals("load-order")) break;
                    return 17;
                }
                case 4: {
                    if (string.equals("name")) {
                        return 2;
                    }
                    if (!string.equals("path")) break;
                    return 7;
                }
                case 5: {
                    if (!string.equals("notes")) break;
                    return 3;
                }
                case 12: {
                    if (string.equals("staging-mode")) {
                        return 15;
                    }
                    if (string.equals("staging-path")) {
                        return 13;
                    }
                    if (!string.equals("internal-app")) break;
                    return 12;
                }
                case 17: {
                    if (!string.equals("web-app-component")) break;
                    return 9;
                }
                case 21: {
                    if (!string.equals("web-service-component")) break;
                    return 25;
                }
                case 8: {
                    if (!string.equals("deployed")) break;
                    return 22;
                }
                case 3: {
                    if (!string.equals("ear")) break;
                    return 10;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                case 24: {
                    return new ConnectorComponentMBeanImpl.SchemaHelper2();
                }
                case 23: {
                    return new EJBComponentMBeanImpl.SchemaHelper2();
                }
                case 26: {
                    return new JDBCPoolComponentMBeanImpl.SchemaHelper2();
                }
                case 9: {
                    return new WebAppComponentMBeanImpl.SchemaHelper2();
                }
                case 25: {
                    return new WebServiceComponentMBeanImpl.SchemaHelper2();
                }
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 20: {
                    return "alt-descriptor-path";
                }
                case 21: {
                    return "altwls-descriptor-path";
                }
                case 28: {
                    return "app-deployment";
                }
                case 8: {
                    return "component";
                }
                case 24: {
                    return "connector-component";
                }
                case 19: {
                    return "deployment-timeout";
                }
                case 18: {
                    return "deployment-type";
                }
                case 23: {
                    return "ejb-component";
                }
                case 11: {
                    return "full-path";
                }
                case 27: {
                    return "internal-type";
                }
                case 26: {
                    return "jdbc-pool-component";
                }
                case 17: {
                    return "load-order";
                }
                case 2: {
                    return "name";
                }
                case 3: {
                    return "notes";
                }
                case 7: {
                    return "path";
                }
                case 14: {
                    return "staged-target";
                }
                case 15: {
                    return "staging-mode";
                }
                case 13: {
                    return "staging-path";
                }
                case 9: {
                    return "web-app-component";
                }
                case 25: {
                    return "web-service-component";
                }
                case 29: {
                    return "delegation-enabled";
                }
                case 22: {
                    return "deployed";
                }
                case 10: {
                    return "ear";
                }
                case 12: {
                    return "internal-app";
                }
                case 16: {
                    return "two-phase";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 8: {
                    return true;
                }
                case 24: {
                    return true;
                }
                case 23: {
                    return true;
                }
                case 26: {
                    return true;
                }
                case 14: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 25: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                case 24: {
                    return true;
                }
                case 23: {
                    return true;
                }
                case 26: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 25: {
                    return true;
                }
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private ApplicationMBeanImpl bean;

        protected Helper(ApplicationMBeanImpl applicationMBeanImpl) {
            super(applicationMBeanImpl);
            this.bean = applicationMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 20: {
                    return "AltDescriptorPath";
                }
                case 21: {
                    return "AltWLSDescriptorPath";
                }
                case 28: {
                    return "AppDeployment";
                }
                case 8: {
                    return "Components";
                }
                case 24: {
                    return "ConnectorComponents";
                }
                case 19: {
                    return "DeploymentTimeout";
                }
                case 18: {
                    return "DeploymentType";
                }
                case 23: {
                    return "EJBComponents";
                }
                case 11: {
                    return "FullPath";
                }
                case 27: {
                    return "InternalType";
                }
                case 26: {
                    return "JDBCPoolComponents";
                }
                case 17: {
                    return "LoadOrder";
                }
                case 2: {
                    return "Name";
                }
                case 3: {
                    return "Notes";
                }
                case 7: {
                    return "Path";
                }
                case 14: {
                    return "StagedTargets";
                }
                case 15: {
                    return "StagingMode";
                }
                case 13: {
                    return "StagingPath";
                }
                case 9: {
                    return "WebAppComponents";
                }
                case 25: {
                    return "WebServiceComponents";
                }
                case 29: {
                    return "DelegationEnabled";
                }
                case 22: {
                    return "Deployed";
                }
                case 10: {
                    return "Ear";
                }
                case 12: {
                    return "InternalApp";
                }
                case 16: {
                    return "TwoPhase";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("AltDescriptorPath")) {
                return 20;
            }
            if (string.equals("AltWLSDescriptorPath")) {
                return 21;
            }
            if (string.equals("AppDeployment")) {
                return 28;
            }
            if (string.equals("Components")) {
                return 8;
            }
            if (string.equals("ConnectorComponents")) {
                return 24;
            }
            if (string.equals("DeploymentTimeout")) {
                return 19;
            }
            if (string.equals("DeploymentType")) {
                return 18;
            }
            if (string.equals("EJBComponents")) {
                return 23;
            }
            if (string.equals("FullPath")) {
                return 11;
            }
            if (string.equals("InternalType")) {
                return 27;
            }
            if (string.equals("JDBCPoolComponents")) {
                return 26;
            }
            if (string.equals("LoadOrder")) {
                return 17;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("Notes")) {
                return 3;
            }
            if (string.equals("Path")) {
                return 7;
            }
            if (string.equals("StagedTargets")) {
                return 14;
            }
            if (string.equals("StagingMode")) {
                return 15;
            }
            if (string.equals("StagingPath")) {
                return 13;
            }
            if (string.equals("WebAppComponents")) {
                return 9;
            }
            if (string.equals("WebServiceComponents")) {
                return 25;
            }
            if (string.equals("DelegationEnabled")) {
                return 29;
            }
            if (string.equals("Deployed")) {
                return 22;
            }
            if (string.equals("Ear")) {
                return 10;
            }
            if (string.equals("InternalApp")) {
                return 12;
            }
            if (string.equals("TwoPhase")) {
                return 16;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList<ArrayIterator> arrayList = new ArrayList<ArrayIterator>();
            arrayList.add(new ArrayIterator((Object[])this.bean.getConnectorComponents()));
            arrayList.add(new ArrayIterator((Object[])this.bean.getEJBComponents()));
            arrayList.add(new ArrayIterator((Object[])this.bean.getJDBCPoolComponents()));
            arrayList.add(new ArrayIterator((Object[])this.bean.getWebAppComponents()));
            arrayList.add(new ArrayIterator((Object[])this.bean.getWebServiceComponents()));
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                int n;
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isAltDescriptorPathSet()) {
                    stringBuffer.append("AltDescriptorPath");
                    stringBuffer.append(String.valueOf(this.bean.getAltDescriptorPath()));
                }
                if (this.bean.isAltWLSDescriptorPathSet()) {
                    stringBuffer.append("AltWLSDescriptorPath");
                    stringBuffer.append(String.valueOf(this.bean.getAltWLSDescriptorPath()));
                }
                if (this.bean.isAppDeploymentSet()) {
                    stringBuffer.append("AppDeployment");
                    stringBuffer.append(String.valueOf(this.bean.getAppDeployment()));
                }
                if (this.bean.isComponentsSet()) {
                    stringBuffer.append("Components");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getComponents())));
                }
                l2 = 0L;
                for (n = 0; n < this.bean.getConnectorComponents().length; ++n) {
                    l2 ^= this.computeChildHashValue(this.bean.getConnectorComponents()[n]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isDeploymentTimeoutSet()) {
                    stringBuffer.append("DeploymentTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getDeploymentTimeout()));
                }
                if (this.bean.isDeploymentTypeSet()) {
                    stringBuffer.append("DeploymentType");
                    stringBuffer.append(String.valueOf(this.bean.getDeploymentType()));
                }
                l2 = 0L;
                for (n = 0; n < this.bean.getEJBComponents().length; ++n) {
                    l2 ^= this.computeChildHashValue(this.bean.getEJBComponents()[n]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isFullPathSet()) {
                    stringBuffer.append("FullPath");
                    stringBuffer.append(String.valueOf(this.bean.getFullPath()));
                }
                if (this.bean.isInternalTypeSet()) {
                    stringBuffer.append("InternalType");
                    stringBuffer.append(String.valueOf(this.bean.getInternalType()));
                }
                l2 = 0L;
                for (n = 0; n < this.bean.getJDBCPoolComponents().length; ++n) {
                    l2 ^= this.computeChildHashValue(this.bean.getJDBCPoolComponents()[n]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isLoadOrderSet()) {
                    stringBuffer.append("LoadOrder");
                    stringBuffer.append(String.valueOf(this.bean.getLoadOrder()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isNotesSet()) {
                    stringBuffer.append("Notes");
                    stringBuffer.append(String.valueOf(this.bean.getNotes()));
                }
                if (this.bean.isPathSet()) {
                    stringBuffer.append("Path");
                    stringBuffer.append(String.valueOf(this.bean.getPath()));
                }
                if (this.bean.isStagedTargetsSet()) {
                    stringBuffer.append("StagedTargets");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getStagedTargets())));
                }
                if (this.bean.isStagingModeSet()) {
                    stringBuffer.append("StagingMode");
                    stringBuffer.append(String.valueOf(this.bean.getStagingMode()));
                }
                if (this.bean.isStagingPathSet()) {
                    stringBuffer.append("StagingPath");
                    stringBuffer.append(String.valueOf(this.bean.getStagingPath()));
                }
                l2 = 0L;
                for (n = 0; n < this.bean.getWebAppComponents().length; ++n) {
                    l2 ^= this.computeChildHashValue(this.bean.getWebAppComponents()[n]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                l2 = 0L;
                for (n = 0; n < this.bean.getWebServiceComponents().length; ++n) {
                    l2 ^= this.computeChildHashValue(this.bean.getWebServiceComponents()[n]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isDelegationEnabledSet()) {
                    stringBuffer.append("DelegationEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isDelegationEnabled()));
                }
                if (this.bean.isDeployedSet()) {
                    stringBuffer.append("Deployed");
                    stringBuffer.append(String.valueOf(this.bean.isDeployed()));
                }
                if (this.bean.isEarSet()) {
                    stringBuffer.append("Ear");
                    stringBuffer.append(String.valueOf(this.bean.isEar()));
                }
                if (this.bean.isInternalAppSet()) {
                    stringBuffer.append("InternalApp");
                    stringBuffer.append(String.valueOf(this.bean.isInternalApp()));
                }
                if (this.bean.isTwoPhaseSet()) {
                    stringBuffer.append("TwoPhase");
                    stringBuffer.append(String.valueOf(this.bean.isTwoPhase()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                ApplicationMBeanImpl applicationMBeanImpl = (ApplicationMBeanImpl)abstractDescriptorBean;
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("AltDescriptorPath", this.bean.getAltDescriptorPath(), applicationMBeanImpl.getAltDescriptorPath(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("AltWLSDescriptorPath", this.bean.getAltWLSDescriptorPath(), applicationMBeanImpl.getAltWLSDescriptorPath(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeChildDiff("ConnectorComponents", this.bean.getConnectorComponents(), applicationMBeanImpl.getConnectorComponents(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("DeploymentTimeout", this.bean.getDeploymentTimeout(), applicationMBeanImpl.getDeploymentTimeout(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeChildDiff("EJBComponents", this.bean.getEJBComponents(), applicationMBeanImpl.getEJBComponents(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeChildDiff("JDBCPoolComponents", this.bean.getJDBCPoolComponents(), applicationMBeanImpl.getJDBCPoolComponents(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LoadOrder", this.bean.getLoadOrder(), applicationMBeanImpl.getLoadOrder(), false);
                }
                this.computeDiff("Name", this.bean.getName(), applicationMBeanImpl.getName(), false);
                this.computeDiff("Notes", this.bean.getNotes(), applicationMBeanImpl.getNotes(), true);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("Path", this.bean.getPath(), applicationMBeanImpl.getPath(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("StagedTargets", this.bean.getStagedTargets(), applicationMBeanImpl.getStagedTargets(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("StagingMode", this.bean.getStagingMode(), applicationMBeanImpl.getStagingMode(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeChildDiff("WebAppComponents", this.bean.getWebAppComponents(), applicationMBeanImpl.getWebAppComponents(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeChildDiff("WebServiceComponents", this.bean.getWebServiceComponents(), applicationMBeanImpl.getWebServiceComponents(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("Deployed", this.bean.isDeployed(), applicationMBeanImpl.isDeployed(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("Ear", this.bean.isEar(), applicationMBeanImpl.isEar(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("TwoPhase", this.bean.isTwoPhase(), applicationMBeanImpl.isTwoPhase(), true);
                }
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                ApplicationMBeanImpl applicationMBeanImpl = (ApplicationMBeanImpl)beanUpdateEvent.getSourceBean();
                ApplicationMBeanImpl applicationMBeanImpl2 = (ApplicationMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("AltDescriptorPath")) {
                    applicationMBeanImpl.setAltDescriptorPath(applicationMBeanImpl2.getAltDescriptorPath());
                    applicationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                } else if (string.equals("AltWLSDescriptorPath")) {
                    applicationMBeanImpl.setAltWLSDescriptorPath(applicationMBeanImpl2.getAltWLSDescriptorPath());
                    applicationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                } else if (!string.equals("AppDeployment") && !string.equals("Components")) {
                    if (string.equals("ConnectorComponents")) {
                        if (n == 2) {
                            propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                            applicationMBeanImpl.addConnectorComponent((ConnectorComponentMBean)propertyUpdate.getAddedObject());
                        } else if (n == 3) {
                            applicationMBeanImpl.removeConnectorComponent((ConnectorComponentMBean)propertyUpdate.getRemovedObject());
                        } else {
                            throw new AssertionError((Object)("Invalid type: " + n));
                        }
                        if (applicationMBeanImpl.getConnectorComponents() == null || applicationMBeanImpl.getConnectorComponents().length == 0) {
                            applicationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                        }
                    } else if (string.equals("DeploymentTimeout")) {
                        applicationMBeanImpl.setDeploymentTimeout(applicationMBeanImpl2.getDeploymentTimeout());
                        applicationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                    } else if (!string.equals("DeploymentType")) {
                        if (string.equals("EJBComponents")) {
                            if (n == 2) {
                                propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                                applicationMBeanImpl.addEJBComponent((EJBComponentMBean)propertyUpdate.getAddedObject());
                            } else if (n == 3) {
                                applicationMBeanImpl.removeEJBComponent((EJBComponentMBean)propertyUpdate.getRemovedObject());
                            } else {
                                throw new AssertionError((Object)("Invalid type: " + n));
                            }
                            if (applicationMBeanImpl.getEJBComponents() == null || applicationMBeanImpl.getEJBComponents().length == 0) {
                                applicationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                            }
                        } else if (!string.equals("FullPath") && !string.equals("InternalType")) {
                            if (string.equals("JDBCPoolComponents")) {
                                if (n == 2) {
                                    propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                                    applicationMBeanImpl.addJDBCPoolComponent((JDBCPoolComponentMBean)propertyUpdate.getAddedObject());
                                } else if (n == 3) {
                                    applicationMBeanImpl.removeJDBCPoolComponent((JDBCPoolComponentMBean)propertyUpdate.getRemovedObject());
                                } else {
                                    throw new AssertionError((Object)("Invalid type: " + n));
                                }
                                if (applicationMBeanImpl.getJDBCPoolComponents() == null || applicationMBeanImpl.getJDBCPoolComponents().length == 0) {
                                    applicationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 26);
                                }
                            } else if (string.equals("LoadOrder")) {
                                applicationMBeanImpl.setLoadOrder(applicationMBeanImpl2.getLoadOrder());
                                applicationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                            } else if (string.equals("Name")) {
                                applicationMBeanImpl.setName(applicationMBeanImpl2.getName());
                                applicationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                            } else if (string.equals("Notes")) {
                                applicationMBeanImpl.setNotes(applicationMBeanImpl2.getNotes());
                                applicationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 3);
                            } else if (string.equals("Path")) {
                                applicationMBeanImpl.setPath(applicationMBeanImpl2.getPath());
                                applicationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                            } else if (string.equals("StagedTargets")) {
                                if (n == 2) {
                                    propertyUpdate.resetAddedObject(propertyUpdate.getAddedObject());
                                    applicationMBeanImpl.addStagedTarget((String)propertyUpdate.getAddedObject());
                                } else if (n == 3) {
                                    applicationMBeanImpl.removeStagedTarget((String)propertyUpdate.getRemovedObject());
                                } else {
                                    throw new AssertionError((Object)("Invalid type: " + n));
                                }
                                if (applicationMBeanImpl.getStagedTargets() == null || applicationMBeanImpl.getStagedTargets().length == 0) {
                                    applicationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                                }
                            } else if (string.equals("StagingMode")) {
                                applicationMBeanImpl.setStagingMode(applicationMBeanImpl2.getStagingMode());
                                applicationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                            } else if (!string.equals("StagingPath")) {
                                if (string.equals("WebAppComponents")) {
                                    if (n == 2) {
                                        propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                                        applicationMBeanImpl.addWebAppComponent((WebAppComponentMBean)propertyUpdate.getAddedObject());
                                    } else if (n == 3) {
                                        applicationMBeanImpl.removeWebAppComponent((WebAppComponentMBean)propertyUpdate.getRemovedObject());
                                    } else {
                                        throw new AssertionError((Object)("Invalid type: " + n));
                                    }
                                    if (applicationMBeanImpl.getWebAppComponents() == null || applicationMBeanImpl.getWebAppComponents().length == 0) {
                                        applicationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                                    }
                                } else if (string.equals("WebServiceComponents")) {
                                    if (n == 2) {
                                        propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                                        applicationMBeanImpl.addWebServiceComponent((WebServiceComponentMBean)propertyUpdate.getAddedObject());
                                    } else if (n == 3) {
                                        applicationMBeanImpl.removeWebServiceComponent((WebServiceComponentMBean)propertyUpdate.getRemovedObject());
                                    } else {
                                        throw new AssertionError((Object)("Invalid type: " + n));
                                    }
                                    if (applicationMBeanImpl.getWebServiceComponents() == null || applicationMBeanImpl.getWebServiceComponents().length == 0) {
                                        applicationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                                    }
                                } else if (!string.equals("DelegationEnabled")) {
                                    if (string.equals("Deployed")) {
                                        applicationMBeanImpl.setDeployed(applicationMBeanImpl2.isDeployed());
                                        applicationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                                    } else if (string.equals("Ear")) {
                                        applicationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                                    } else if (!string.equals("InternalApp")) {
                                        if (string.equals("TwoPhase")) {
                                            applicationMBeanImpl.setTwoPhase(applicationMBeanImpl2.isTwoPhase());
                                            applicationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                                        } else {
                                            super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                int n;
                ComponentMBean[] componentMBeanArray;
                ComponentMBean[] componentMBeanArray2;
                ApplicationMBeanImpl applicationMBeanImpl = (ApplicationMBeanImpl)abstractDescriptorBean;
                super.finishCopy(applicationMBeanImpl, bl, list);
                if (bl && (list == null || !list.contains("AltDescriptorPath")) && this.bean.isAltDescriptorPathSet()) {
                    applicationMBeanImpl.setAltDescriptorPath(this.bean.getAltDescriptorPath());
                }
                if (bl && (list == null || !list.contains("AltWLSDescriptorPath")) && this.bean.isAltWLSDescriptorPathSet()) {
                    applicationMBeanImpl.setAltWLSDescriptorPath(this.bean.getAltWLSDescriptorPath());
                }
                if (bl && (list == null || !list.contains("ConnectorComponents")) && this.bean.isConnectorComponentsSet() && !applicationMBeanImpl._isSet(24)) {
                    componentMBeanArray2 = this.bean.getConnectorComponents();
                    componentMBeanArray = new ConnectorComponentMBean[componentMBeanArray2.length];
                    for (n = 0; n < componentMBeanArray.length; ++n) {
                        componentMBeanArray[n] = (ConnectorComponentMBean)this.createCopy((AbstractDescriptorBean)componentMBeanArray2[n], bl);
                    }
                    applicationMBeanImpl.setConnectorComponents((ConnectorComponentMBean[])componentMBeanArray);
                }
                if (bl && (list == null || !list.contains("DeploymentTimeout")) && this.bean.isDeploymentTimeoutSet()) {
                    applicationMBeanImpl.setDeploymentTimeout(this.bean.getDeploymentTimeout());
                }
                if (bl && (list == null || !list.contains("EJBComponents")) && this.bean.isEJBComponentsSet() && !applicationMBeanImpl._isSet(23)) {
                    componentMBeanArray2 = this.bean.getEJBComponents();
                    componentMBeanArray = new EJBComponentMBean[componentMBeanArray2.length];
                    for (n = 0; n < componentMBeanArray.length; ++n) {
                        componentMBeanArray[n] = (EJBComponentMBean)this.createCopy((AbstractDescriptorBean)componentMBeanArray2[n], bl);
                    }
                    applicationMBeanImpl.setEJBComponents((EJBComponentMBean[])componentMBeanArray);
                }
                if (bl && (list == null || !list.contains("JDBCPoolComponents")) && this.bean.isJDBCPoolComponentsSet() && !applicationMBeanImpl._isSet(26)) {
                    componentMBeanArray2 = this.bean.getJDBCPoolComponents();
                    componentMBeanArray = new JDBCPoolComponentMBean[componentMBeanArray2.length];
                    for (n = 0; n < componentMBeanArray.length; ++n) {
                        componentMBeanArray[n] = (JDBCPoolComponentMBean)this.createCopy((AbstractDescriptorBean)componentMBeanArray2[n], bl);
                    }
                    applicationMBeanImpl.setJDBCPoolComponents((JDBCPoolComponentMBean[])componentMBeanArray);
                }
                if (bl && (list == null || !list.contains("LoadOrder")) && this.bean.isLoadOrderSet()) {
                    applicationMBeanImpl.setLoadOrder(this.bean.getLoadOrder());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    applicationMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("Notes")) && this.bean.isNotesSet()) {
                    applicationMBeanImpl.setNotes(this.bean.getNotes());
                }
                if (bl && (list == null || !list.contains("Path")) && this.bean.isPathSet()) {
                    applicationMBeanImpl.setPath(this.bean.getPath());
                }
                if (bl && (list == null || !list.contains("StagedTargets")) && this.bean.isStagedTargetsSet()) {
                    String[] stringArray = this.bean.getStagedTargets();
                    applicationMBeanImpl.setStagedTargets(stringArray == null ? null : (String[])stringArray.clone());
                }
                if (bl && (list == null || !list.contains("StagingMode")) && this.bean.isStagingModeSet()) {
                    applicationMBeanImpl.setStagingMode(this.bean.getStagingMode());
                }
                if (bl && (list == null || !list.contains("WebAppComponents")) && this.bean.isWebAppComponentsSet() && !applicationMBeanImpl._isSet(9)) {
                    componentMBeanArray2 = this.bean.getWebAppComponents();
                    componentMBeanArray = new WebAppComponentMBean[componentMBeanArray2.length];
                    for (n = 0; n < componentMBeanArray.length; ++n) {
                        componentMBeanArray[n] = (WebAppComponentMBean)this.createCopy((AbstractDescriptorBean)componentMBeanArray2[n], bl);
                    }
                    applicationMBeanImpl.setWebAppComponents((WebAppComponentMBean[])componentMBeanArray);
                }
                if (bl && (list == null || !list.contains("WebServiceComponents")) && this.bean.isWebServiceComponentsSet() && !applicationMBeanImpl._isSet(25)) {
                    componentMBeanArray2 = this.bean.getWebServiceComponents();
                    componentMBeanArray = new WebServiceComponentMBean[componentMBeanArray2.length];
                    for (n = 0; n < componentMBeanArray.length; ++n) {
                        componentMBeanArray[n] = (WebServiceComponentMBean)this.createCopy((AbstractDescriptorBean)componentMBeanArray2[n], bl);
                    }
                    applicationMBeanImpl.setWebServiceComponents((WebServiceComponentMBean[])componentMBeanArray);
                }
                if (bl && (list == null || !list.contains("Deployed")) && this.bean.isDeployedSet()) {
                    applicationMBeanImpl.setDeployed(this.bean.isDeployed());
                }
                if (!bl || list != null && list.contains("Ear") || this.bean.isEarSet()) {
                    // empty if block
                }
                if (bl && (list == null || !list.contains("TwoPhase")) && this.bean.isTwoPhaseSet()) {
                    applicationMBeanImpl.setTwoPhase(this.bean.isTwoPhase());
                }
                return applicationMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getAppDeployment(), clazz, object);
            this.inferSubTree(this.bean.getComponents(), clazz, object);
            this.inferSubTree(this.bean.getConnectorComponents(), clazz, object);
            this.inferSubTree(this.bean.getEJBComponents(), clazz, object);
            this.inferSubTree(this.bean.getJDBCPoolComponents(), clazz, object);
            this.inferSubTree(this.bean.getWebAppComponents(), clazz, object);
            this.inferSubTree(this.bean.getWebServiceComponents(), clazz, object);
        }
    }
}

