/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.util.Enumeration;
import java.util.Properties;
import weblogic.management.configuration.BridgeDestinationCommonMBean;
import weblogic.management.configuration.BridgeDestinationMBean;
import weblogic.management.configuration.JMSBridgeDestinationMBean;
import weblogic.management.configuration.MessagingBridgeMBean;
import weblogic.management.internal.ManagementTextTextFormatter;

public final class BridgeLegalHelper {
    private static final boolean debug = false;

    public static void validateBridgeDestinations(MessagingBridgeMBean messagingBridgeMBean) throws IllegalArgumentException {
        BridgeDestinationCommonMBean bridgeDestinationCommonMBean = messagingBridgeMBean.getSourceDestination();
        BridgeDestinationCommonMBean bridgeDestinationCommonMBean2 = messagingBridgeMBean.getTargetDestination();
        if (bridgeDestinationCommonMBean == null || bridgeDestinationCommonMBean2 == null) {
            return;
        }
        if (bridgeDestinationCommonMBean.getName().equals(bridgeDestinationCommonMBean2.getName())) {
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getSameSourceTargetException(messagingBridgeMBean.getName()));
        }
        Properties properties = null;
        properties = bridgeDestinationCommonMBean instanceof JMSBridgeDestinationMBean ? BridgeLegalHelper.createProperties(((JMSBridgeDestinationMBean)bridgeDestinationCommonMBean).getConnectionURL(), ((JMSBridgeDestinationMBean)bridgeDestinationCommonMBean).getInitialContextFactory(), ((JMSBridgeDestinationMBean)bridgeDestinationCommonMBean).getConnectionFactoryJNDIName(), ((JMSBridgeDestinationMBean)bridgeDestinationCommonMBean).getDestinationJNDIName(), ((JMSBridgeDestinationMBean)bridgeDestinationCommonMBean).getDestinationType()) : ((BridgeDestinationMBean)bridgeDestinationCommonMBean).getProperties();
        Properties properties2 = null;
        properties2 = bridgeDestinationCommonMBean2 instanceof JMSBridgeDestinationMBean ? BridgeLegalHelper.createProperties(((JMSBridgeDestinationMBean)bridgeDestinationCommonMBean2).getConnectionURL(), ((JMSBridgeDestinationMBean)bridgeDestinationCommonMBean2).getInitialContextFactory(), ((JMSBridgeDestinationMBean)bridgeDestinationCommonMBean2).getConnectionFactoryJNDIName(), ((JMSBridgeDestinationMBean)bridgeDestinationCommonMBean2).getDestinationJNDIName(), ((JMSBridgeDestinationMBean)bridgeDestinationCommonMBean2).getDestinationType()) : ((BridgeDestinationMBean)bridgeDestinationCommonMBean2).getProperties();
        if (!BridgeLegalHelper.notSameDestinations(properties, properties2)) {
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getSameSourceTargetException(messagingBridgeMBean.getName()));
        }
    }

    public static boolean notSameDestinations(Properties properties, Properties properties2) {
        String string;
        if (properties == null || properties.size() == 0) {
            return properties2 != null && properties2.size() != 0;
        }
        if (properties2 == null || properties2.size() == 0) {
            return true;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        Properties properties3 = (Properties)properties2.clone();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            String string3 = properties2.getProperty(string);
            if (string2 == null) {
                if (string3 == null) continue;
                return true;
            }
            if (string3 == null) {
                return true;
            }
            if (!string2.equals(string3)) {
                return true;
            }
            properties3.remove(string);
        }
        enumeration = properties3.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (properties3.getProperty(string) == null) continue;
            return true;
        }
        return false;
    }

    public static Properties createProperties(String string, String string2, String string3, String string4, String string5) {
        Properties properties = new Properties();
        if (string != null && string.length() > 0) {
            properties.put("ConnectionURL", string);
        }
        if (string2 != null) {
            properties.put("InitialContextFactory", string2);
        } else {
            properties.put("InitialContextFactory", "weblogic.jndi.WLInitialContextFactory");
        }
        if (string3 != null) {
            properties.put("ConnectionFactoryJNDIName", string3);
        }
        if (string4 != null) {
            properties.put("DestinationJNDIName", string4);
        }
        if (string5 != null) {
            properties.put("DestinationType", string5);
        }
        return properties;
    }
}

