/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.configuration.CacheAsyncListenersMBean;
import weblogic.management.configuration.CacheAsyncListenersMBeanImpl;
import weblogic.management.configuration.CacheExpirationMBean;
import weblogic.management.configuration.CacheExpirationMBeanImpl;
import weblogic.management.configuration.CacheLoaderMBean;
import weblogic.management.configuration.CacheLoaderMBeanImpl;
import weblogic.management.configuration.CacheMBean;
import weblogic.management.configuration.CacheStoreMBean;
import weblogic.management.configuration.CacheStoreMBeanImpl;
import weblogic.management.configuration.CacheTransactionMBean;
import weblogic.management.configuration.CacheTransactionMBeanImpl;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DeploymentMBeanImpl;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;

public class CacheMBeanImpl
extends DeploymentMBeanImpl
implements CacheMBean,
Serializable {
    private CacheAsyncListenersMBean _AsyncListeners;
    private String _EvictionPolicy;
    private CacheExpirationMBean _Expiration;
    private String _JNDIName;
    private CacheLoaderMBean _Loader;
    private int _MaxCacheUnits;
    private CacheStoreMBean _Store;
    private CacheTransactionMBean _Transactional;
    private String _WorkManager;
    private static SchemaHelper2 _schemaHelper;

    public CacheMBeanImpl() {
        this._initializeProperty(-1);
    }

    public CacheMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public String getJNDIName() {
        if (!this._isSet(9)) {
            try {
                return "com/bea/cache/" + this.getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._JNDIName;
    }

    public boolean isJNDINameSet() {
        return this._isSet(9);
    }

    public void setJNDIName(String string) {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonNull((String)"JNDIName", (Object)string);
        String string2 = this._JNDIName;
        this._JNDIName = string;
        this._postSet(9, string2, string);
    }

    public int getMaxCacheUnits() {
        return this._MaxCacheUnits;
    }

    public boolean isMaxCacheUnitsSet() {
        return this._isSet(10);
    }

    public void setMaxCacheUnits(int n) {
        LegalChecks.checkMin((String)"MaxCacheUnits", (int)n, (int)1);
        int n2 = this._MaxCacheUnits;
        this._MaxCacheUnits = n;
        this._postSet(10, n2, n);
    }

    public CacheExpirationMBean getExpiration() {
        return this._Expiration;
    }

    public boolean isExpirationSet() {
        return this._isSet(11) || this._isAnythingSet((AbstractDescriptorBean)this.getExpiration());
    }

    public void setExpiration(CacheExpirationMBean cacheExpirationMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)cacheExpirationMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 11)) {
            this._postCreate(abstractDescriptorBean);
        }
        CacheExpirationMBean cacheExpirationMBean2 = this._Expiration;
        this._Expiration = cacheExpirationMBean;
        this._postSet(11, cacheExpirationMBean2, cacheExpirationMBean);
    }

    public String getEvictionPolicy() {
        return this._EvictionPolicy;
    }

    public boolean isEvictionPolicySet() {
        return this._isSet(12);
    }

    public void setEvictionPolicy(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"LRU", "NRU", "FIFO", "LFU"};
        string = LegalChecks.checkInEnum((String)"EvictionPolicy", (String)string, (String[])stringArray);
        String string2 = this._EvictionPolicy;
        this._EvictionPolicy = string;
        this._postSet(12, string2, string);
    }

    public String getWorkManager() {
        return this._WorkManager;
    }

    public boolean isWorkManagerSet() {
        return this._isSet(13);
    }

    public void setWorkManager(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._WorkManager;
        this._WorkManager = string;
        this._postSet(13, string2, string);
    }

    public CacheLoaderMBean getLoader() {
        return this._Loader;
    }

    public boolean isLoaderSet() {
        return this._isSet(14) || this._isAnythingSet((AbstractDescriptorBean)this.getLoader());
    }

    public void setLoader(CacheLoaderMBean cacheLoaderMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)cacheLoaderMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 14)) {
            this._postCreate(abstractDescriptorBean);
        }
        CacheLoaderMBean cacheLoaderMBean2 = this._Loader;
        this._Loader = cacheLoaderMBean;
        this._postSet(14, cacheLoaderMBean2, cacheLoaderMBean);
    }

    public CacheStoreMBean getStore() {
        return this._Store;
    }

    public boolean isStoreSet() {
        return this._isSet(15) || this._isAnythingSet((AbstractDescriptorBean)this.getStore());
    }

    public void setStore(CacheStoreMBean cacheStoreMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)cacheStoreMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 15)) {
            this._postCreate(abstractDescriptorBean);
        }
        CacheStoreMBean cacheStoreMBean2 = this._Store;
        this._Store = cacheStoreMBean;
        this._postSet(15, cacheStoreMBean2, cacheStoreMBean);
    }

    public CacheTransactionMBean getTransactional() {
        return this._Transactional;
    }

    public boolean isTransactionalSet() {
        return this._isSet(16) || this._isAnythingSet((AbstractDescriptorBean)this.getTransactional());
    }

    public void setTransactional(CacheTransactionMBean cacheTransactionMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)cacheTransactionMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 16)) {
            this._postCreate(abstractDescriptorBean);
        }
        CacheTransactionMBean cacheTransactionMBean2 = this._Transactional;
        this._Transactional = cacheTransactionMBean;
        this._postSet(16, cacheTransactionMBean2, cacheTransactionMBean);
    }

    public CacheAsyncListenersMBean getAsyncListeners() {
        return this._AsyncListeners;
    }

    public boolean isAsyncListenersSet() {
        return this._isSet(17) || this._isAnythingSet((AbstractDescriptorBean)this.getAsyncListeners());
    }

    public void setAsyncListeners(CacheAsyncListenersMBean cacheAsyncListenersMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)cacheAsyncListenersMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 17)) {
            this._postCreate(abstractDescriptorBean);
        }
        CacheAsyncListenersMBean cacheAsyncListenersMBean2 = this._AsyncListeners;
        this._AsyncListeners = cacheAsyncListenersMBean;
        this._postSet(17, cacheAsyncListenersMBean2, cacheAsyncListenersMBean);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet() || this.isAsyncListenersSet() || this.isExpirationSet() || this.isLoaderSet() || this.isStoreSet() || this.isTransactionalSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 17;
        }
        try {
            switch (n) {
                case 17: {
                    this._AsyncListeners = new CacheAsyncListenersMBeanImpl(this, 17);
                    this._postCreate((AbstractDescriptorBean)this._AsyncListeners);
                    if (bl) break;
                }
                case 12: {
                    this._EvictionPolicy = "LFU";
                    if (bl) break;
                }
                case 11: {
                    this._Expiration = new CacheExpirationMBeanImpl(this, 11);
                    this._postCreate((AbstractDescriptorBean)this._Expiration);
                    if (bl) break;
                }
                case 9: {
                    this._JNDIName = null;
                    if (bl) break;
                }
                case 14: {
                    this._Loader = new CacheLoaderMBeanImpl(this, 14);
                    this._postCreate((AbstractDescriptorBean)this._Loader);
                    if (bl) break;
                }
                case 10: {
                    this._MaxCacheUnits = 64;
                    if (bl) break;
                }
                case 15: {
                    this._Store = new CacheStoreMBeanImpl(this, 15);
                    this._postCreate((AbstractDescriptorBean)this._Store);
                    if (bl) break;
                }
                case 16: {
                    this._Transactional = new CacheTransactionMBeanImpl(this, 16);
                    this._postCreate((AbstractDescriptorBean)this._Transactional);
                    if (bl) break;
                }
                case 13: {
                    this._WorkManager = null;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "Cache";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AsyncListeners")) {
            CacheAsyncListenersMBean cacheAsyncListenersMBean = this._AsyncListeners;
            this._AsyncListeners = (CacheAsyncListenersMBean)object;
            this._postSet(17, cacheAsyncListenersMBean, this._AsyncListeners);
            return;
        }
        if (string.equals("EvictionPolicy")) {
            String string2 = this._EvictionPolicy;
            this._EvictionPolicy = (String)object;
            this._postSet(12, string2, this._EvictionPolicy);
            return;
        }
        if (string.equals("Expiration")) {
            CacheExpirationMBean cacheExpirationMBean = this._Expiration;
            this._Expiration = (CacheExpirationMBean)object;
            this._postSet(11, cacheExpirationMBean, this._Expiration);
            return;
        }
        if (string.equals("JNDIName")) {
            String string3 = this._JNDIName;
            this._JNDIName = (String)object;
            this._postSet(9, string3, this._JNDIName);
            return;
        }
        if (string.equals("Loader")) {
            CacheLoaderMBean cacheLoaderMBean = this._Loader;
            this._Loader = (CacheLoaderMBean)object;
            this._postSet(14, cacheLoaderMBean, this._Loader);
            return;
        }
        if (string.equals("MaxCacheUnits")) {
            int n = this._MaxCacheUnits;
            this._MaxCacheUnits = (Integer)object;
            this._postSet(10, n, this._MaxCacheUnits);
            return;
        }
        if (string.equals("Store")) {
            CacheStoreMBean cacheStoreMBean = this._Store;
            this._Store = (CacheStoreMBean)object;
            this._postSet(15, cacheStoreMBean, this._Store);
            return;
        }
        if (string.equals("Transactional")) {
            CacheTransactionMBean cacheTransactionMBean = this._Transactional;
            this._Transactional = (CacheTransactionMBean)object;
            this._postSet(16, cacheTransactionMBean, this._Transactional);
            return;
        }
        if (string.equals("WorkManager")) {
            String string4 = this._WorkManager;
            this._WorkManager = (String)object;
            this._postSet(13, string4, this._WorkManager);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AsyncListeners")) {
            return this._AsyncListeners;
        }
        if (string.equals("EvictionPolicy")) {
            return this._EvictionPolicy;
        }
        if (string.equals("Expiration")) {
            return this._Expiration;
        }
        if (string.equals("JNDIName")) {
            return this._JNDIName;
        }
        if (string.equals("Loader")) {
            return this._Loader;
        }
        if (string.equals("MaxCacheUnits")) {
            return new Integer(this._MaxCacheUnits);
        }
        if (string.equals("Store")) {
            return this._Store;
        }
        if (string.equals("Transactional")) {
            return this._Transactional;
        }
        if (string.equals("WorkManager")) {
            return this._WorkManager;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends DeploymentMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 15: {
                    if (string.equals("async-listeners")) {
                        return 17;
                    }
                    if (string.equals("eviction-policy")) {
                        return 12;
                    }
                    if (!string.equals("max-cache-units")) break;
                    return 10;
                }
                case 10: {
                    if (!string.equals("expiration")) break;
                    return 11;
                }
                case 9: {
                    if (!string.equals("jndi-name")) break;
                    return 9;
                }
                case 6: {
                    if (!string.equals("loader")) break;
                    return 14;
                }
                case 5: {
                    if (!string.equals("store")) break;
                    return 15;
                }
                case 13: {
                    if (!string.equals("transactional")) break;
                    return 16;
                }
                case 12: {
                    if (!string.equals("work-manager")) break;
                    return 13;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                case 17: {
                    return new CacheAsyncListenersMBeanImpl.SchemaHelper2();
                }
                case 11: {
                    return new CacheExpirationMBeanImpl.SchemaHelper2();
                }
                case 14: {
                    return new CacheLoaderMBeanImpl.SchemaHelper2();
                }
                case 15: {
                    return new CacheStoreMBeanImpl.SchemaHelper2();
                }
                case 16: {
                    return new CacheTransactionMBeanImpl.SchemaHelper2();
                }
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 17: {
                    return "async-listeners";
                }
                case 12: {
                    return "eviction-policy";
                }
                case 11: {
                    return "expiration";
                }
                case 9: {
                    return "jndi-name";
                }
                case 14: {
                    return "loader";
                }
                case 10: {
                    return "max-cache-units";
                }
                case 15: {
                    return "store";
                }
                case 16: {
                    return "transactional";
                }
                case 13: {
                    return "work-manager";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 7: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                case 17: {
                    return true;
                }
                case 11: {
                    return true;
                }
                case 14: {
                    return true;
                }
                case 15: {
                    return true;
                }
                case 16: {
                    return true;
                }
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends DeploymentMBeanImpl.Helper {
        private CacheMBeanImpl bean;

        protected Helper(CacheMBeanImpl cacheMBeanImpl) {
            super(cacheMBeanImpl);
            this.bean = cacheMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 17: {
                    return "AsyncListeners";
                }
                case 12: {
                    return "EvictionPolicy";
                }
                case 11: {
                    return "Expiration";
                }
                case 9: {
                    return "JNDIName";
                }
                case 14: {
                    return "Loader";
                }
                case 10: {
                    return "MaxCacheUnits";
                }
                case 15: {
                    return "Store";
                }
                case 16: {
                    return "Transactional";
                }
                case 13: {
                    return "WorkManager";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("AsyncListeners")) {
                return 17;
            }
            if (string.equals("EvictionPolicy")) {
                return 12;
            }
            if (string.equals("Expiration")) {
                return 11;
            }
            if (string.equals("JNDIName")) {
                return 9;
            }
            if (string.equals("Loader")) {
                return 14;
            }
            if (string.equals("MaxCacheUnits")) {
                return 10;
            }
            if (string.equals("Store")) {
                return 15;
            }
            if (string.equals("Transactional")) {
                return 16;
            }
            if (string.equals("WorkManager")) {
                return 13;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList<ArrayIterator> arrayList = new ArrayList<ArrayIterator>();
            if (this.bean.getAsyncListeners() != null) {
                arrayList.add(new ArrayIterator((Object[])new CacheAsyncListenersMBean[]{this.bean.getAsyncListeners()}));
            }
            if (this.bean.getExpiration() != null) {
                arrayList.add(new ArrayIterator((Object[])new CacheExpirationMBean[]{this.bean.getExpiration()}));
            }
            if (this.bean.getLoader() != null) {
                arrayList.add(new ArrayIterator((Object[])new CacheLoaderMBean[]{this.bean.getLoader()}));
            }
            if (this.bean.getStore() != null) {
                arrayList.add(new ArrayIterator((Object[])new CacheStoreMBean[]{this.bean.getStore()}));
            }
            if (this.bean.getTransactional() != null) {
                arrayList.add(new ArrayIterator((Object[])new CacheTransactionMBean[]{this.bean.getTransactional()}));
            }
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                l2 = this.computeChildHashValue(this.bean.getAsyncListeners());
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isEvictionPolicySet()) {
                    stringBuffer.append("EvictionPolicy");
                    stringBuffer.append(String.valueOf(this.bean.getEvictionPolicy()));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getExpiration())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isJNDINameSet()) {
                    stringBuffer.append("JNDIName");
                    stringBuffer.append(String.valueOf(this.bean.getJNDIName()));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getLoader())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isMaxCacheUnitsSet()) {
                    stringBuffer.append("MaxCacheUnits");
                    stringBuffer.append(String.valueOf(this.bean.getMaxCacheUnits()));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getStore())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getTransactional())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isWorkManagerSet()) {
                    stringBuffer.append("WorkManager");
                    stringBuffer.append(String.valueOf(this.bean.getWorkManager()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                CacheMBeanImpl cacheMBeanImpl = (CacheMBeanImpl)abstractDescriptorBean;
                this.computeSubDiff("AsyncListeners", this.bean.getAsyncListeners(), cacheMBeanImpl.getAsyncListeners());
                this.computeDiff("EvictionPolicy", this.bean.getEvictionPolicy(), cacheMBeanImpl.getEvictionPolicy(), false);
                this.computeSubDiff("Expiration", this.bean.getExpiration(), cacheMBeanImpl.getExpiration());
                this.computeDiff("JNDIName", this.bean.getJNDIName(), cacheMBeanImpl.getJNDIName(), false);
                this.computeSubDiff("Loader", this.bean.getLoader(), cacheMBeanImpl.getLoader());
                this.computeDiff("MaxCacheUnits", this.bean.getMaxCacheUnits(), cacheMBeanImpl.getMaxCacheUnits(), true);
                this.computeSubDiff("Store", this.bean.getStore(), cacheMBeanImpl.getStore());
                this.computeSubDiff("Transactional", this.bean.getTransactional(), cacheMBeanImpl.getTransactional());
                this.computeDiff("WorkManager", this.bean.getWorkManager(), cacheMBeanImpl.getWorkManager(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                CacheMBeanImpl cacheMBeanImpl = (CacheMBeanImpl)beanUpdateEvent.getSourceBean();
                CacheMBeanImpl cacheMBeanImpl2 = (CacheMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("AsyncListeners")) {
                    if (n == 2) {
                        cacheMBeanImpl.setAsyncListeners((CacheAsyncListenersMBean)this.createCopy((AbstractDescriptorBean)cacheMBeanImpl2.getAsyncListeners()));
                    } else if (n == 3) {
                        cacheMBeanImpl._destroySingleton("AsyncListeners", cacheMBeanImpl.getAsyncListeners());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    cacheMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else if (string.equals("EvictionPolicy")) {
                    cacheMBeanImpl.setEvictionPolicy(cacheMBeanImpl2.getEvictionPolicy());
                    cacheMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("Expiration")) {
                    if (n == 2) {
                        cacheMBeanImpl.setExpiration((CacheExpirationMBean)this.createCopy((AbstractDescriptorBean)cacheMBeanImpl2.getExpiration()));
                    } else if (n == 3) {
                        cacheMBeanImpl._destroySingleton("Expiration", cacheMBeanImpl.getExpiration());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    cacheMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("JNDIName")) {
                    cacheMBeanImpl.setJNDIName(cacheMBeanImpl2.getJNDIName());
                    cacheMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("Loader")) {
                    if (n == 2) {
                        cacheMBeanImpl.setLoader((CacheLoaderMBean)this.createCopy((AbstractDescriptorBean)cacheMBeanImpl2.getLoader()));
                    } else if (n == 3) {
                        cacheMBeanImpl._destroySingleton("Loader", cacheMBeanImpl.getLoader());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    cacheMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("MaxCacheUnits")) {
                    cacheMBeanImpl.setMaxCacheUnits(cacheMBeanImpl2.getMaxCacheUnits());
                    cacheMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("Store")) {
                    if (n == 2) {
                        cacheMBeanImpl.setStore((CacheStoreMBean)this.createCopy((AbstractDescriptorBean)cacheMBeanImpl2.getStore()));
                    } else if (n == 3) {
                        cacheMBeanImpl._destroySingleton("Store", cacheMBeanImpl.getStore());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    cacheMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("Transactional")) {
                    if (n == 2) {
                        cacheMBeanImpl.setTransactional((CacheTransactionMBean)this.createCopy((AbstractDescriptorBean)cacheMBeanImpl2.getTransactional()));
                    } else if (n == 3) {
                        cacheMBeanImpl._destroySingleton("Transactional", cacheMBeanImpl.getTransactional());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    cacheMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else if (string.equals("WorkManager")) {
                    cacheMBeanImpl.setWorkManager(cacheMBeanImpl2.getWorkManager());
                    cacheMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                ConfigurationMBean configurationMBean;
                CacheMBeanImpl cacheMBeanImpl = (CacheMBeanImpl)abstractDescriptorBean;
                super.finishCopy(cacheMBeanImpl, bl, list);
                if (!(list != null && list.contains("AsyncListeners") || !this.bean.isAsyncListenersSet() || cacheMBeanImpl._isSet(17))) {
                    configurationMBean = this.bean.getAsyncListeners();
                    cacheMBeanImpl.setAsyncListeners(null);
                    cacheMBeanImpl.setAsyncListeners(configurationMBean == null ? null : (CacheAsyncListenersMBean)this.createCopy((AbstractDescriptorBean)configurationMBean, bl));
                }
                if ((list == null || !list.contains("EvictionPolicy")) && this.bean.isEvictionPolicySet()) {
                    cacheMBeanImpl.setEvictionPolicy(this.bean.getEvictionPolicy());
                }
                if (!(list != null && list.contains("Expiration") || !this.bean.isExpirationSet() || cacheMBeanImpl._isSet(11))) {
                    configurationMBean = this.bean.getExpiration();
                    cacheMBeanImpl.setExpiration(null);
                    cacheMBeanImpl.setExpiration(configurationMBean == null ? null : (CacheExpirationMBean)this.createCopy((AbstractDescriptorBean)configurationMBean, bl));
                }
                if ((list == null || !list.contains("JNDIName")) && this.bean.isJNDINameSet()) {
                    cacheMBeanImpl.setJNDIName(this.bean.getJNDIName());
                }
                if (!(list != null && list.contains("Loader") || !this.bean.isLoaderSet() || cacheMBeanImpl._isSet(14))) {
                    configurationMBean = this.bean.getLoader();
                    cacheMBeanImpl.setLoader(null);
                    cacheMBeanImpl.setLoader(configurationMBean == null ? null : (CacheLoaderMBean)this.createCopy((AbstractDescriptorBean)configurationMBean, bl));
                }
                if ((list == null || !list.contains("MaxCacheUnits")) && this.bean.isMaxCacheUnitsSet()) {
                    cacheMBeanImpl.setMaxCacheUnits(this.bean.getMaxCacheUnits());
                }
                if (!(list != null && list.contains("Store") || !this.bean.isStoreSet() || cacheMBeanImpl._isSet(15))) {
                    configurationMBean = this.bean.getStore();
                    cacheMBeanImpl.setStore(null);
                    cacheMBeanImpl.setStore(configurationMBean == null ? null : (CacheStoreMBean)this.createCopy((AbstractDescriptorBean)configurationMBean, bl));
                }
                if (!(list != null && list.contains("Transactional") || !this.bean.isTransactionalSet() || cacheMBeanImpl._isSet(16))) {
                    configurationMBean = this.bean.getTransactional();
                    cacheMBeanImpl.setTransactional(null);
                    cacheMBeanImpl.setTransactional(configurationMBean == null ? null : (CacheTransactionMBean)this.createCopy((AbstractDescriptorBean)configurationMBean, bl));
                }
                if ((list == null || !list.contains("WorkManager")) && this.bean.isWorkManagerSet()) {
                    cacheMBeanImpl.setWorkManager(this.bean.getWorkManager());
                }
                return cacheMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getAsyncListeners(), clazz, object);
            this.inferSubTree(this.bean.getExpiration(), clazz, object);
            this.inferSubTree(this.bean.getLoader(), clazz, object);
            this.inferSubTree(this.bean.getStore(), clazz, object);
            this.inferSubTree(this.bean.getTransactional(), clazz, object);
        }
    }
}

