/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.configuration.CacheTransactionMBean;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.utils.collections.CombinedIterator;

public class CacheTransactionMBeanImpl
extends ConfigurationMBeanImpl
implements CacheTransactionMBean,
Serializable {
    private String _Concurrency;
    private String _IsolationLevel;
    private static SchemaHelper2 _schemaHelper;

    public CacheTransactionMBeanImpl() {
        this._initializeProperty(-1);
    }

    public CacheTransactionMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public String getConcurrency() {
        return this._Concurrency;
    }

    public boolean isConcurrencySet() {
        return this._isSet(7);
    }

    public void setConcurrency(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Pessimistic", "Optimistic", "None"};
        string = LegalChecks.checkInEnum((String)"Concurrency", (String)string, (String[])stringArray);
        String string2 = this._Concurrency;
        this._Concurrency = string;
        this._postSet(7, string2, string);
    }

    public String getIsolationLevel() {
        return this._IsolationLevel;
    }

    public boolean isIsolationLevelSet() {
        return this._isSet(8);
    }

    public void setIsolationLevel(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"ReadUncommitted", "ReadCommitted", "RepeatableRead"};
        string = LegalChecks.checkInEnum((String)"IsolationLevel", (String)string, (String[])stringArray);
        String string2 = this._IsolationLevel;
        this._IsolationLevel = string;
        this._postSet(8, string2, string);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 7;
        }
        try {
            switch (n) {
                case 7: {
                    this._Concurrency = "None";
                    if (bl) break;
                }
                case 8: {
                    this._IsolationLevel = "RepeatableRead";
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "CacheTransaction";
    }

    public void putValue(String string, Object object) {
        if (string.equals("Concurrency")) {
            String string2 = this._Concurrency;
            this._Concurrency = (String)object;
            this._postSet(7, string2, this._Concurrency);
            return;
        }
        if (string.equals("IsolationLevel")) {
            String string3 = this._IsolationLevel;
            this._IsolationLevel = (String)object;
            this._postSet(8, string3, this._IsolationLevel);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("Concurrency")) {
            return this._Concurrency;
        }
        if (string.equals("IsolationLevel")) {
            return this._IsolationLevel;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 11: {
                    if (!string.equals("concurrency")) break;
                    return 7;
                }
                case 15: {
                    if (!string.equals("isolation-level")) break;
                    return 8;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 7: {
                    return "concurrency";
                }
                case 8: {
                    return "isolation-level";
                }
            }
            return super.getElementName(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private CacheTransactionMBeanImpl bean;

        protected Helper(CacheTransactionMBeanImpl cacheTransactionMBeanImpl) {
            super(cacheTransactionMBeanImpl);
            this.bean = cacheTransactionMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 7: {
                    return "Concurrency";
                }
                case 8: {
                    return "IsolationLevel";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("Concurrency")) {
                return 7;
            }
            if (string.equals("IsolationLevel")) {
                return 8;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isConcurrencySet()) {
                    stringBuffer.append("Concurrency");
                    stringBuffer.append(String.valueOf(this.bean.getConcurrency()));
                }
                if (this.bean.isIsolationLevelSet()) {
                    stringBuffer.append("IsolationLevel");
                    stringBuffer.append(String.valueOf(this.bean.getIsolationLevel()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                CacheTransactionMBeanImpl cacheTransactionMBeanImpl = (CacheTransactionMBeanImpl)abstractDescriptorBean;
                this.computeDiff("Concurrency", this.bean.getConcurrency(), cacheTransactionMBeanImpl.getConcurrency(), false);
                this.computeDiff("IsolationLevel", this.bean.getIsolationLevel(), cacheTransactionMBeanImpl.getIsolationLevel(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                CacheTransactionMBeanImpl cacheTransactionMBeanImpl = (CacheTransactionMBeanImpl)beanUpdateEvent.getSourceBean();
                CacheTransactionMBeanImpl cacheTransactionMBeanImpl2 = (CacheTransactionMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("Concurrency")) {
                    cacheTransactionMBeanImpl.setConcurrency(cacheTransactionMBeanImpl2.getConcurrency());
                    cacheTransactionMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("IsolationLevel")) {
                    cacheTransactionMBeanImpl.setIsolationLevel(cacheTransactionMBeanImpl2.getIsolationLevel());
                    cacheTransactionMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                CacheTransactionMBeanImpl cacheTransactionMBeanImpl = (CacheTransactionMBeanImpl)abstractDescriptorBean;
                super.finishCopy(cacheTransactionMBeanImpl, bl, list);
                if ((list == null || !list.contains("Concurrency")) && this.bean.isConcurrencySet()) {
                    cacheTransactionMBeanImpl.setConcurrency(this.bean.getConcurrency());
                }
                if ((list == null || !list.contains("IsolationLevel")) && this.bean.isIsolationLevelSet()) {
                    cacheTransactionMBeanImpl.setIsolationLevel(this.bean.getIsolationLevel());
                }
                return cacheTransactionMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

