/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.configuration.BasicRealmMBean;
import weblogic.management.configuration.CachingRealmMBean;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.utils.collections.CombinedIterator;

public class CachingRealmMBeanImpl
extends ConfigurationMBeanImpl
implements CachingRealmMBean,
Serializable {
    private boolean _ACLCacheEnable;
    private int _ACLCacheSize;
    private int _ACLCacheTTLNegative;
    private int _ACLCacheTTLPositive;
    private boolean _AuthenticationCacheEnable;
    private int _AuthenticationCacheSize;
    private int _AuthenticationCacheTTLNegative;
    private int _AuthenticationCacheTTLPositive;
    private BasicRealmMBean _BasicRealm;
    private boolean _CacheCaseSensitive;
    private boolean _GroupCacheEnable;
    private int _GroupCacheSize;
    private int _GroupCacheTTLNegative;
    private int _GroupCacheTTLPositive;
    private int _GroupMembershipCacheTTL;
    private boolean _PermissionCacheEnable;
    private int _PermissionCacheSize;
    private int _PermissionCacheTTLNegative;
    private int _PermissionCacheTTLPositive;
    private boolean _UserCacheEnable;
    private int _UserCacheSize;
    private int _UserCacheTTLNegative;
    private int _UserCacheTTLPositive;
    private static SchemaHelper2 _schemaHelper;

    public CachingRealmMBeanImpl() {
        this._initializeProperty(-1);
    }

    public CachingRealmMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public BasicRealmMBean getBasicRealm() {
        return this._BasicRealm;
    }

    public String getBasicRealmAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getBasicRealm();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isBasicRealmSet() {
        return this._isSet(7);
    }

    public void setBasicRealmAsString(String string) {
        if (string == null || string.length() == 0) {
            BasicRealmMBean basicRealmMBean = this._BasicRealm;
            this._initializeProperty(7);
            this._postSet(7, basicRealmMBean, this._BasicRealm);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, BasicRealmMBean.class, new ReferenceManager.Resolver(this, 7){

                public void resolveReference(Object object) {
                    try {
                        CachingRealmMBeanImpl.this.setBasicRealm((BasicRealmMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setBasicRealm(BasicRealmMBean basicRealmMBean) throws InvalidAttributeValueException {
        BasicRealmMBean basicRealmMBean2;
        if (basicRealmMBean != null) {
            basicRealmMBean2 = new ResolvedReference(this, 7, (AbstractDescriptorBean)basicRealmMBean){

                protected Object getPropertyValue() {
                    return CachingRealmMBeanImpl.this.getBasicRealm();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)basicRealmMBean, (ResolvedReference)basicRealmMBean2);
        }
        basicRealmMBean2 = this._BasicRealm;
        this._BasicRealm = basicRealmMBean;
        this._postSet(7, basicRealmMBean2, basicRealmMBean);
    }

    public boolean getCacheCaseSensitive() {
        return this._CacheCaseSensitive;
    }

    public boolean isCacheCaseSensitiveSet() {
        return this._isSet(8);
    }

    public void setCacheCaseSensitive(boolean bl) {
        boolean bl2 = this._CacheCaseSensitive;
        this._CacheCaseSensitive = bl;
        this._postSet(8, bl2, bl);
    }

    public boolean getACLCacheEnable() {
        return this._ACLCacheEnable;
    }

    public boolean isACLCacheEnableSet() {
        return this._isSet(9);
    }

    public void setACLCacheEnable(boolean bl) {
        boolean bl2 = this._ACLCacheEnable;
        this._ACLCacheEnable = bl;
        this._postSet(9, bl2, bl);
    }

    public boolean getAuthenticationCacheEnable() {
        return this._AuthenticationCacheEnable;
    }

    public boolean isAuthenticationCacheEnableSet() {
        return this._isSet(10);
    }

    public void setAuthenticationCacheEnable(boolean bl) {
        boolean bl2 = this._AuthenticationCacheEnable;
        this._AuthenticationCacheEnable = bl;
        this._postSet(10, bl2, bl);
    }

    public boolean getGroupCacheEnable() {
        return this._GroupCacheEnable;
    }

    public boolean isGroupCacheEnableSet() {
        return this._isSet(11);
    }

    public void setGroupCacheEnable(boolean bl) {
        boolean bl2 = this._GroupCacheEnable;
        this._GroupCacheEnable = bl;
        this._postSet(11, bl2, bl);
    }

    public boolean getPermissionCacheEnable() {
        return this._PermissionCacheEnable;
    }

    public boolean isPermissionCacheEnableSet() {
        return this._isSet(12);
    }

    public void setPermissionCacheEnable(boolean bl) {
        boolean bl2 = this._PermissionCacheEnable;
        this._PermissionCacheEnable = bl;
        this._postSet(12, bl2, bl);
    }

    public boolean getUserCacheEnable() {
        return this._UserCacheEnable;
    }

    public boolean isUserCacheEnableSet() {
        return this._isSet(13);
    }

    public void setUserCacheEnable(boolean bl) {
        boolean bl2 = this._UserCacheEnable;
        this._UserCacheEnable = bl;
        this._postSet(13, bl2, bl);
    }

    public int getACLCacheSize() {
        return this._ACLCacheSize;
    }

    public boolean isACLCacheSizeSet() {
        return this._isSet(14);
    }

    public void setACLCacheSize(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ACLCacheSize", (long)n, (long)17L, (long)65537L);
        int n2 = this._ACLCacheSize;
        this._ACLCacheSize = n;
        this._postSet(14, n2, n);
    }

    public int getAuthenticationCacheSize() {
        return this._AuthenticationCacheSize;
    }

    public boolean isAuthenticationCacheSizeSet() {
        return this._isSet(15);
    }

    public void setAuthenticationCacheSize(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"AuthenticationCacheSize", (long)n, (long)17L, (long)65537L);
        int n2 = this._AuthenticationCacheSize;
        this._AuthenticationCacheSize = n;
        this._postSet(15, n2, n);
    }

    public int getGroupCacheSize() {
        return this._GroupCacheSize;
    }

    public boolean isGroupCacheSizeSet() {
        return this._isSet(16);
    }

    public void setGroupCacheSize(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"GroupCacheSize", (long)n, (long)17L, (long)65537L);
        int n2 = this._GroupCacheSize;
        this._GroupCacheSize = n;
        this._postSet(16, n2, n);
    }

    public int getPermissionCacheSize() {
        return this._PermissionCacheSize;
    }

    public boolean isPermissionCacheSizeSet() {
        return this._isSet(17);
    }

    public void setPermissionCacheSize(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"PermissionCacheSize", (long)n, (long)17L, (long)65537L);
        int n2 = this._PermissionCacheSize;
        this._PermissionCacheSize = n;
        this._postSet(17, n2, n);
    }

    public int getUserCacheSize() {
        return this._UserCacheSize;
    }

    public boolean isUserCacheSizeSet() {
        return this._isSet(18);
    }

    public void setUserCacheSize(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"UserCacheSize", (long)n, (long)17L, (long)65537L);
        int n2 = this._UserCacheSize;
        this._UserCacheSize = n;
        this._postSet(18, n2, n);
    }

    public int getACLCacheTTLPositive() {
        return this._ACLCacheTTLPositive;
    }

    public boolean isACLCacheTTLPositiveSet() {
        return this._isSet(19);
    }

    public void setACLCacheTTLPositive(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ACLCacheTTLPositive", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this._ACLCacheTTLPositive;
        this._ACLCacheTTLPositive = n;
        this._postSet(19, n2, n);
    }

    public int getGroupCacheTTLPositive() {
        return this._GroupCacheTTLPositive;
    }

    public boolean isGroupCacheTTLPositiveSet() {
        return this._isSet(20);
    }

    public void setGroupCacheTTLPositive(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"GroupCacheTTLPositive", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this._GroupCacheTTLPositive;
        this._GroupCacheTTLPositive = n;
        this._postSet(20, n2, n);
    }

    public int getAuthenticationCacheTTLPositive() {
        return this._AuthenticationCacheTTLPositive;
    }

    public boolean isAuthenticationCacheTTLPositiveSet() {
        return this._isSet(21);
    }

    public void setAuthenticationCacheTTLPositive(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"AuthenticationCacheTTLPositive", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this._AuthenticationCacheTTLPositive;
        this._AuthenticationCacheTTLPositive = n;
        this._postSet(21, n2, n);
    }

    public int getPermissionCacheTTLPositive() {
        return this._PermissionCacheTTLPositive;
    }

    public boolean isPermissionCacheTTLPositiveSet() {
        return this._isSet(22);
    }

    public void setPermissionCacheTTLPositive(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"PermissionCacheTTLPositive", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this._PermissionCacheTTLPositive;
        this._PermissionCacheTTLPositive = n;
        this._postSet(22, n2, n);
    }

    public int getUserCacheTTLPositive() {
        return this._UserCacheTTLPositive;
    }

    public boolean isUserCacheTTLPositiveSet() {
        return this._isSet(23);
    }

    public void setUserCacheTTLPositive(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"UserCacheTTLPositive", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this._UserCacheTTLPositive;
        this._UserCacheTTLPositive = n;
        this._postSet(23, n2, n);
    }

    public int getACLCacheTTLNegative() {
        return this._ACLCacheTTLNegative;
    }

    public boolean isACLCacheTTLNegativeSet() {
        return this._isSet(24);
    }

    public void setACLCacheTTLNegative(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ACLCacheTTLNegative", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this._ACLCacheTTLNegative;
        this._ACLCacheTTLNegative = n;
        this._postSet(24, n2, n);
    }

    public int getGroupCacheTTLNegative() {
        return this._GroupCacheTTLNegative;
    }

    public boolean isGroupCacheTTLNegativeSet() {
        return this._isSet(25);
    }

    public void setGroupCacheTTLNegative(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"GroupCacheTTLNegative", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this._GroupCacheTTLNegative;
        this._GroupCacheTTLNegative = n;
        this._postSet(25, n2, n);
    }

    public int getAuthenticationCacheTTLNegative() {
        return this._AuthenticationCacheTTLNegative;
    }

    public boolean isAuthenticationCacheTTLNegativeSet() {
        return this._isSet(26);
    }

    public void setAuthenticationCacheTTLNegative(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"AuthenticationCacheTTLNegative", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this._AuthenticationCacheTTLNegative;
        this._AuthenticationCacheTTLNegative = n;
        this._postSet(26, n2, n);
    }

    public int getPermissionCacheTTLNegative() {
        return this._PermissionCacheTTLNegative;
    }

    public boolean isPermissionCacheTTLNegativeSet() {
        return this._isSet(27);
    }

    public void setPermissionCacheTTLNegative(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"PermissionCacheTTLNegative", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this._PermissionCacheTTLNegative;
        this._PermissionCacheTTLNegative = n;
        this._postSet(27, n2, n);
    }

    public int getUserCacheTTLNegative() {
        return this._UserCacheTTLNegative;
    }

    public boolean isUserCacheTTLNegativeSet() {
        return this._isSet(28);
    }

    public void setUserCacheTTLNegative(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"UserCacheTTLNegative", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this._UserCacheTTLNegative;
        this._UserCacheTTLNegative = n;
        this._postSet(28, n2, n);
    }

    public int getGroupMembershipCacheTTL() {
        return this._GroupMembershipCacheTTL;
    }

    public boolean isGroupMembershipCacheTTLSet() {
        return this._isSet(29);
    }

    public void setGroupMembershipCacheTTL(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"GroupMembershipCacheTTL", (int)n, (int)0);
        int n2 = this._GroupMembershipCacheTTL;
        this._GroupMembershipCacheTTL = n;
        this._postSet(29, n2, n);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 9;
        }
        try {
            switch (n) {
                case 9: {
                    this._ACLCacheEnable = true;
                    if (bl) break;
                }
                case 14: {
                    this._ACLCacheSize = 211;
                    if (bl) break;
                }
                case 24: {
                    this._ACLCacheTTLNegative = 10;
                    if (bl) break;
                }
                case 19: {
                    this._ACLCacheTTLPositive = 60;
                    if (bl) break;
                }
                case 10: {
                    this._AuthenticationCacheEnable = true;
                    if (bl) break;
                }
                case 15: {
                    this._AuthenticationCacheSize = 211;
                    if (bl) break;
                }
                case 26: {
                    this._AuthenticationCacheTTLNegative = 10;
                    if (bl) break;
                }
                case 21: {
                    this._AuthenticationCacheTTLPositive = 60;
                    if (bl) break;
                }
                case 7: {
                    this._BasicRealm = null;
                    if (bl) break;
                }
                case 8: {
                    this._CacheCaseSensitive = true;
                    if (bl) break;
                }
                case 11: {
                    this._GroupCacheEnable = true;
                    if (bl) break;
                }
                case 16: {
                    this._GroupCacheSize = 211;
                    if (bl) break;
                }
                case 25: {
                    this._GroupCacheTTLNegative = 10;
                    if (bl) break;
                }
                case 20: {
                    this._GroupCacheTTLPositive = 60;
                    if (bl) break;
                }
                case 29: {
                    this._GroupMembershipCacheTTL = 300;
                    if (bl) break;
                }
                case 12: {
                    this._PermissionCacheEnable = true;
                    if (bl) break;
                }
                case 17: {
                    this._PermissionCacheSize = 211;
                    if (bl) break;
                }
                case 27: {
                    this._PermissionCacheTTLNegative = 10;
                    if (bl) break;
                }
                case 22: {
                    this._PermissionCacheTTLPositive = 60;
                    if (bl) break;
                }
                case 13: {
                    this._UserCacheEnable = true;
                    if (bl) break;
                }
                case 18: {
                    this._UserCacheSize = 211;
                    if (bl) break;
                }
                case 28: {
                    this._UserCacheTTLNegative = 10;
                    if (bl) break;
                }
                case 23: {
                    this._UserCacheTTLPositive = 60;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "CachingRealm";
    }

    public void putValue(String string, Object object) {
        if (string.equals("ACLCacheEnable")) {
            boolean bl = this._ACLCacheEnable;
            this._ACLCacheEnable = (Boolean)object;
            this._postSet(9, bl, this._ACLCacheEnable);
            return;
        }
        if (string.equals("ACLCacheSize")) {
            int n = this._ACLCacheSize;
            this._ACLCacheSize = (Integer)object;
            this._postSet(14, n, this._ACLCacheSize);
            return;
        }
        if (string.equals("ACLCacheTTLNegative")) {
            int n = this._ACLCacheTTLNegative;
            this._ACLCacheTTLNegative = (Integer)object;
            this._postSet(24, n, this._ACLCacheTTLNegative);
            return;
        }
        if (string.equals("ACLCacheTTLPositive")) {
            int n = this._ACLCacheTTLPositive;
            this._ACLCacheTTLPositive = (Integer)object;
            this._postSet(19, n, this._ACLCacheTTLPositive);
            return;
        }
        if (string.equals("AuthenticationCacheEnable")) {
            boolean bl = this._AuthenticationCacheEnable;
            this._AuthenticationCacheEnable = (Boolean)object;
            this._postSet(10, bl, this._AuthenticationCacheEnable);
            return;
        }
        if (string.equals("AuthenticationCacheSize")) {
            int n = this._AuthenticationCacheSize;
            this._AuthenticationCacheSize = (Integer)object;
            this._postSet(15, n, this._AuthenticationCacheSize);
            return;
        }
        if (string.equals("AuthenticationCacheTTLNegative")) {
            int n = this._AuthenticationCacheTTLNegative;
            this._AuthenticationCacheTTLNegative = (Integer)object;
            this._postSet(26, n, this._AuthenticationCacheTTLNegative);
            return;
        }
        if (string.equals("AuthenticationCacheTTLPositive")) {
            int n = this._AuthenticationCacheTTLPositive;
            this._AuthenticationCacheTTLPositive = (Integer)object;
            this._postSet(21, n, this._AuthenticationCacheTTLPositive);
            return;
        }
        if (string.equals("BasicRealm")) {
            BasicRealmMBean basicRealmMBean = this._BasicRealm;
            this._BasicRealm = (BasicRealmMBean)object;
            this._postSet(7, basicRealmMBean, this._BasicRealm);
            return;
        }
        if (string.equals("CacheCaseSensitive")) {
            boolean bl = this._CacheCaseSensitive;
            this._CacheCaseSensitive = (Boolean)object;
            this._postSet(8, bl, this._CacheCaseSensitive);
            return;
        }
        if (string.equals("GroupCacheEnable")) {
            boolean bl = this._GroupCacheEnable;
            this._GroupCacheEnable = (Boolean)object;
            this._postSet(11, bl, this._GroupCacheEnable);
            return;
        }
        if (string.equals("GroupCacheSize")) {
            int n = this._GroupCacheSize;
            this._GroupCacheSize = (Integer)object;
            this._postSet(16, n, this._GroupCacheSize);
            return;
        }
        if (string.equals("GroupCacheTTLNegative")) {
            int n = this._GroupCacheTTLNegative;
            this._GroupCacheTTLNegative = (Integer)object;
            this._postSet(25, n, this._GroupCacheTTLNegative);
            return;
        }
        if (string.equals("GroupCacheTTLPositive")) {
            int n = this._GroupCacheTTLPositive;
            this._GroupCacheTTLPositive = (Integer)object;
            this._postSet(20, n, this._GroupCacheTTLPositive);
            return;
        }
        if (string.equals("GroupMembershipCacheTTL")) {
            int n = this._GroupMembershipCacheTTL;
            this._GroupMembershipCacheTTL = (Integer)object;
            this._postSet(29, n, this._GroupMembershipCacheTTL);
            return;
        }
        if (string.equals("PermissionCacheEnable")) {
            boolean bl = this._PermissionCacheEnable;
            this._PermissionCacheEnable = (Boolean)object;
            this._postSet(12, bl, this._PermissionCacheEnable);
            return;
        }
        if (string.equals("PermissionCacheSize")) {
            int n = this._PermissionCacheSize;
            this._PermissionCacheSize = (Integer)object;
            this._postSet(17, n, this._PermissionCacheSize);
            return;
        }
        if (string.equals("PermissionCacheTTLNegative")) {
            int n = this._PermissionCacheTTLNegative;
            this._PermissionCacheTTLNegative = (Integer)object;
            this._postSet(27, n, this._PermissionCacheTTLNegative);
            return;
        }
        if (string.equals("PermissionCacheTTLPositive")) {
            int n = this._PermissionCacheTTLPositive;
            this._PermissionCacheTTLPositive = (Integer)object;
            this._postSet(22, n, this._PermissionCacheTTLPositive);
            return;
        }
        if (string.equals("UserCacheEnable")) {
            boolean bl = this._UserCacheEnable;
            this._UserCacheEnable = (Boolean)object;
            this._postSet(13, bl, this._UserCacheEnable);
            return;
        }
        if (string.equals("UserCacheSize")) {
            int n = this._UserCacheSize;
            this._UserCacheSize = (Integer)object;
            this._postSet(18, n, this._UserCacheSize);
            return;
        }
        if (string.equals("UserCacheTTLNegative")) {
            int n = this._UserCacheTTLNegative;
            this._UserCacheTTLNegative = (Integer)object;
            this._postSet(28, n, this._UserCacheTTLNegative);
            return;
        }
        if (string.equals("UserCacheTTLPositive")) {
            int n = this._UserCacheTTLPositive;
            this._UserCacheTTLPositive = (Integer)object;
            this._postSet(23, n, this._UserCacheTTLPositive);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("ACLCacheEnable")) {
            return new Boolean(this._ACLCacheEnable);
        }
        if (string.equals("ACLCacheSize")) {
            return new Integer(this._ACLCacheSize);
        }
        if (string.equals("ACLCacheTTLNegative")) {
            return new Integer(this._ACLCacheTTLNegative);
        }
        if (string.equals("ACLCacheTTLPositive")) {
            return new Integer(this._ACLCacheTTLPositive);
        }
        if (string.equals("AuthenticationCacheEnable")) {
            return new Boolean(this._AuthenticationCacheEnable);
        }
        if (string.equals("AuthenticationCacheSize")) {
            return new Integer(this._AuthenticationCacheSize);
        }
        if (string.equals("AuthenticationCacheTTLNegative")) {
            return new Integer(this._AuthenticationCacheTTLNegative);
        }
        if (string.equals("AuthenticationCacheTTLPositive")) {
            return new Integer(this._AuthenticationCacheTTLPositive);
        }
        if (string.equals("BasicRealm")) {
            return this._BasicRealm;
        }
        if (string.equals("CacheCaseSensitive")) {
            return new Boolean(this._CacheCaseSensitive);
        }
        if (string.equals("GroupCacheEnable")) {
            return new Boolean(this._GroupCacheEnable);
        }
        if (string.equals("GroupCacheSize")) {
            return new Integer(this._GroupCacheSize);
        }
        if (string.equals("GroupCacheTTLNegative")) {
            return new Integer(this._GroupCacheTTLNegative);
        }
        if (string.equals("GroupCacheTTLPositive")) {
            return new Integer(this._GroupCacheTTLPositive);
        }
        if (string.equals("GroupMembershipCacheTTL")) {
            return new Integer(this._GroupMembershipCacheTTL);
        }
        if (string.equals("PermissionCacheEnable")) {
            return new Boolean(this._PermissionCacheEnable);
        }
        if (string.equals("PermissionCacheSize")) {
            return new Integer(this._PermissionCacheSize);
        }
        if (string.equals("PermissionCacheTTLNegative")) {
            return new Integer(this._PermissionCacheTTLNegative);
        }
        if (string.equals("PermissionCacheTTLPositive")) {
            return new Integer(this._PermissionCacheTTLPositive);
        }
        if (string.equals("UserCacheEnable")) {
            return new Boolean(this._UserCacheEnable);
        }
        if (string.equals("UserCacheSize")) {
            return new Integer(this._UserCacheSize);
        }
        if (string.equals("UserCacheTTLNegative")) {
            return new Integer(this._UserCacheTTLNegative);
        }
        if (string.equals("UserCacheTTLPositive")) {
            return new Integer(this._UserCacheTTLPositive);
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 16: {
                    if (string.equals("acl-cache-enable")) {
                        return 9;
                    }
                    if (!string.equals("group-cache-size")) break;
                    return 16;
                }
                case 14: {
                    if (!string.equals("acl-cache-size")) break;
                    return 14;
                }
                case 21: {
                    if (string.equals("acl-cachettl-negative")) {
                        return 24;
                    }
                    if (string.equals("acl-cachettl-positive")) {
                        return 19;
                    }
                    if (!string.equals("permission-cache-size")) break;
                    return 17;
                }
                case 27: {
                    if (!string.equals("authentication-cache-enable")) break;
                    return 10;
                }
                case 25: {
                    if (string.equals("authentication-cache-size")) {
                        return 15;
                    }
                    if (!string.equals("group-membership-cachettl")) break;
                    return 29;
                }
                case 32: {
                    if (string.equals("authentication-cachettl-negative")) {
                        return 26;
                    }
                    if (!string.equals("authentication-cachettl-positive")) break;
                    return 21;
                }
                case 11: {
                    if (!string.equals("basic-realm")) break;
                    return 7;
                }
                case 20: {
                    if (!string.equals("cache-case-sensitive")) break;
                    return 8;
                }
                case 18: {
                    if (!string.equals("group-cache-enable")) break;
                    return 11;
                }
                case 23: {
                    if (string.equals("group-cachettl-negative")) {
                        return 25;
                    }
                    if (string.equals("group-cachettl-positive")) {
                        return 20;
                    }
                    if (!string.equals("permission-cache-enable")) break;
                    return 12;
                }
                case 28: {
                    if (string.equals("permission-cachettl-negative")) {
                        return 27;
                    }
                    if (!string.equals("permission-cachettl-positive")) break;
                    return 22;
                }
                case 17: {
                    if (!string.equals("user-cache-enable")) break;
                    return 13;
                }
                case 15: {
                    if (!string.equals("user-cache-size")) break;
                    return 18;
                }
                case 22: {
                    if (string.equals("user-cachettl-negative")) {
                        return 28;
                    }
                    if (!string.equals("user-cachettl-positive")) break;
                    return 23;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 9: {
                    return "acl-cache-enable";
                }
                case 14: {
                    return "acl-cache-size";
                }
                case 24: {
                    return "acl-cachettl-negative";
                }
                case 19: {
                    return "acl-cachettl-positive";
                }
                case 10: {
                    return "authentication-cache-enable";
                }
                case 15: {
                    return "authentication-cache-size";
                }
                case 26: {
                    return "authentication-cachettl-negative";
                }
                case 21: {
                    return "authentication-cachettl-positive";
                }
                case 7: {
                    return "basic-realm";
                }
                case 8: {
                    return "cache-case-sensitive";
                }
                case 11: {
                    return "group-cache-enable";
                }
                case 16: {
                    return "group-cache-size";
                }
                case 25: {
                    return "group-cachettl-negative";
                }
                case 20: {
                    return "group-cachettl-positive";
                }
                case 29: {
                    return "group-membership-cachettl";
                }
                case 12: {
                    return "permission-cache-enable";
                }
                case 17: {
                    return "permission-cache-size";
                }
                case 27: {
                    return "permission-cachettl-negative";
                }
                case 22: {
                    return "permission-cachettl-positive";
                }
                case 13: {
                    return "user-cache-enable";
                }
                case 18: {
                    return "user-cache-size";
                }
                case 28: {
                    return "user-cachettl-negative";
                }
                case 23: {
                    return "user-cachettl-positive";
                }
            }
            return super.getElementName(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private CachingRealmMBeanImpl bean;

        protected Helper(CachingRealmMBeanImpl cachingRealmMBeanImpl) {
            super(cachingRealmMBeanImpl);
            this.bean = cachingRealmMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 9: {
                    return "ACLCacheEnable";
                }
                case 14: {
                    return "ACLCacheSize";
                }
                case 24: {
                    return "ACLCacheTTLNegative";
                }
                case 19: {
                    return "ACLCacheTTLPositive";
                }
                case 10: {
                    return "AuthenticationCacheEnable";
                }
                case 15: {
                    return "AuthenticationCacheSize";
                }
                case 26: {
                    return "AuthenticationCacheTTLNegative";
                }
                case 21: {
                    return "AuthenticationCacheTTLPositive";
                }
                case 7: {
                    return "BasicRealm";
                }
                case 8: {
                    return "CacheCaseSensitive";
                }
                case 11: {
                    return "GroupCacheEnable";
                }
                case 16: {
                    return "GroupCacheSize";
                }
                case 25: {
                    return "GroupCacheTTLNegative";
                }
                case 20: {
                    return "GroupCacheTTLPositive";
                }
                case 29: {
                    return "GroupMembershipCacheTTL";
                }
                case 12: {
                    return "PermissionCacheEnable";
                }
                case 17: {
                    return "PermissionCacheSize";
                }
                case 27: {
                    return "PermissionCacheTTLNegative";
                }
                case 22: {
                    return "PermissionCacheTTLPositive";
                }
                case 13: {
                    return "UserCacheEnable";
                }
                case 18: {
                    return "UserCacheSize";
                }
                case 28: {
                    return "UserCacheTTLNegative";
                }
                case 23: {
                    return "UserCacheTTLPositive";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("ACLCacheEnable")) {
                return 9;
            }
            if (string.equals("ACLCacheSize")) {
                return 14;
            }
            if (string.equals("ACLCacheTTLNegative")) {
                return 24;
            }
            if (string.equals("ACLCacheTTLPositive")) {
                return 19;
            }
            if (string.equals("AuthenticationCacheEnable")) {
                return 10;
            }
            if (string.equals("AuthenticationCacheSize")) {
                return 15;
            }
            if (string.equals("AuthenticationCacheTTLNegative")) {
                return 26;
            }
            if (string.equals("AuthenticationCacheTTLPositive")) {
                return 21;
            }
            if (string.equals("BasicRealm")) {
                return 7;
            }
            if (string.equals("CacheCaseSensitive")) {
                return 8;
            }
            if (string.equals("GroupCacheEnable")) {
                return 11;
            }
            if (string.equals("GroupCacheSize")) {
                return 16;
            }
            if (string.equals("GroupCacheTTLNegative")) {
                return 25;
            }
            if (string.equals("GroupCacheTTLPositive")) {
                return 20;
            }
            if (string.equals("GroupMembershipCacheTTL")) {
                return 29;
            }
            if (string.equals("PermissionCacheEnable")) {
                return 12;
            }
            if (string.equals("PermissionCacheSize")) {
                return 17;
            }
            if (string.equals("PermissionCacheTTLNegative")) {
                return 27;
            }
            if (string.equals("PermissionCacheTTLPositive")) {
                return 22;
            }
            if (string.equals("UserCacheEnable")) {
                return 13;
            }
            if (string.equals("UserCacheSize")) {
                return 18;
            }
            if (string.equals("UserCacheTTLNegative")) {
                return 28;
            }
            if (string.equals("UserCacheTTLPositive")) {
                return 23;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isACLCacheEnableSet()) {
                    stringBuffer.append("ACLCacheEnable");
                    stringBuffer.append(String.valueOf(this.bean.getACLCacheEnable()));
                }
                if (this.bean.isACLCacheSizeSet()) {
                    stringBuffer.append("ACLCacheSize");
                    stringBuffer.append(String.valueOf(this.bean.getACLCacheSize()));
                }
                if (this.bean.isACLCacheTTLNegativeSet()) {
                    stringBuffer.append("ACLCacheTTLNegative");
                    stringBuffer.append(String.valueOf(this.bean.getACLCacheTTLNegative()));
                }
                if (this.bean.isACLCacheTTLPositiveSet()) {
                    stringBuffer.append("ACLCacheTTLPositive");
                    stringBuffer.append(String.valueOf(this.bean.getACLCacheTTLPositive()));
                }
                if (this.bean.isAuthenticationCacheEnableSet()) {
                    stringBuffer.append("AuthenticationCacheEnable");
                    stringBuffer.append(String.valueOf(this.bean.getAuthenticationCacheEnable()));
                }
                if (this.bean.isAuthenticationCacheSizeSet()) {
                    stringBuffer.append("AuthenticationCacheSize");
                    stringBuffer.append(String.valueOf(this.bean.getAuthenticationCacheSize()));
                }
                if (this.bean.isAuthenticationCacheTTLNegativeSet()) {
                    stringBuffer.append("AuthenticationCacheTTLNegative");
                    stringBuffer.append(String.valueOf(this.bean.getAuthenticationCacheTTLNegative()));
                }
                if (this.bean.isAuthenticationCacheTTLPositiveSet()) {
                    stringBuffer.append("AuthenticationCacheTTLPositive");
                    stringBuffer.append(String.valueOf(this.bean.getAuthenticationCacheTTLPositive()));
                }
                if (this.bean.isBasicRealmSet()) {
                    stringBuffer.append("BasicRealm");
                    stringBuffer.append(String.valueOf(this.bean.getBasicRealm()));
                }
                if (this.bean.isCacheCaseSensitiveSet()) {
                    stringBuffer.append("CacheCaseSensitive");
                    stringBuffer.append(String.valueOf(this.bean.getCacheCaseSensitive()));
                }
                if (this.bean.isGroupCacheEnableSet()) {
                    stringBuffer.append("GroupCacheEnable");
                    stringBuffer.append(String.valueOf(this.bean.getGroupCacheEnable()));
                }
                if (this.bean.isGroupCacheSizeSet()) {
                    stringBuffer.append("GroupCacheSize");
                    stringBuffer.append(String.valueOf(this.bean.getGroupCacheSize()));
                }
                if (this.bean.isGroupCacheTTLNegativeSet()) {
                    stringBuffer.append("GroupCacheTTLNegative");
                    stringBuffer.append(String.valueOf(this.bean.getGroupCacheTTLNegative()));
                }
                if (this.bean.isGroupCacheTTLPositiveSet()) {
                    stringBuffer.append("GroupCacheTTLPositive");
                    stringBuffer.append(String.valueOf(this.bean.getGroupCacheTTLPositive()));
                }
                if (this.bean.isGroupMembershipCacheTTLSet()) {
                    stringBuffer.append("GroupMembershipCacheTTL");
                    stringBuffer.append(String.valueOf(this.bean.getGroupMembershipCacheTTL()));
                }
                if (this.bean.isPermissionCacheEnableSet()) {
                    stringBuffer.append("PermissionCacheEnable");
                    stringBuffer.append(String.valueOf(this.bean.getPermissionCacheEnable()));
                }
                if (this.bean.isPermissionCacheSizeSet()) {
                    stringBuffer.append("PermissionCacheSize");
                    stringBuffer.append(String.valueOf(this.bean.getPermissionCacheSize()));
                }
                if (this.bean.isPermissionCacheTTLNegativeSet()) {
                    stringBuffer.append("PermissionCacheTTLNegative");
                    stringBuffer.append(String.valueOf(this.bean.getPermissionCacheTTLNegative()));
                }
                if (this.bean.isPermissionCacheTTLPositiveSet()) {
                    stringBuffer.append("PermissionCacheTTLPositive");
                    stringBuffer.append(String.valueOf(this.bean.getPermissionCacheTTLPositive()));
                }
                if (this.bean.isUserCacheEnableSet()) {
                    stringBuffer.append("UserCacheEnable");
                    stringBuffer.append(String.valueOf(this.bean.getUserCacheEnable()));
                }
                if (this.bean.isUserCacheSizeSet()) {
                    stringBuffer.append("UserCacheSize");
                    stringBuffer.append(String.valueOf(this.bean.getUserCacheSize()));
                }
                if (this.bean.isUserCacheTTLNegativeSet()) {
                    stringBuffer.append("UserCacheTTLNegative");
                    stringBuffer.append(String.valueOf(this.bean.getUserCacheTTLNegative()));
                }
                if (this.bean.isUserCacheTTLPositiveSet()) {
                    stringBuffer.append("UserCacheTTLPositive");
                    stringBuffer.append(String.valueOf(this.bean.getUserCacheTTLPositive()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                CachingRealmMBeanImpl cachingRealmMBeanImpl = (CachingRealmMBeanImpl)abstractDescriptorBean;
                this.computeDiff("ACLCacheEnable", this.bean.getACLCacheEnable(), cachingRealmMBeanImpl.getACLCacheEnable(), false);
                this.computeDiff("ACLCacheSize", this.bean.getACLCacheSize(), cachingRealmMBeanImpl.getACLCacheSize(), false);
                this.computeDiff("ACLCacheTTLNegative", this.bean.getACLCacheTTLNegative(), cachingRealmMBeanImpl.getACLCacheTTLNegative(), false);
                this.computeDiff("ACLCacheTTLPositive", this.bean.getACLCacheTTLPositive(), cachingRealmMBeanImpl.getACLCacheTTLPositive(), false);
                this.computeDiff("AuthenticationCacheEnable", this.bean.getAuthenticationCacheEnable(), cachingRealmMBeanImpl.getAuthenticationCacheEnable(), false);
                this.computeDiff("AuthenticationCacheSize", this.bean.getAuthenticationCacheSize(), cachingRealmMBeanImpl.getAuthenticationCacheSize(), false);
                this.computeDiff("AuthenticationCacheTTLNegative", this.bean.getAuthenticationCacheTTLNegative(), cachingRealmMBeanImpl.getAuthenticationCacheTTLNegative(), false);
                this.computeDiff("AuthenticationCacheTTLPositive", this.bean.getAuthenticationCacheTTLPositive(), cachingRealmMBeanImpl.getAuthenticationCacheTTLPositive(), false);
                this.computeDiff("BasicRealm", this.bean.getBasicRealm(), cachingRealmMBeanImpl.getBasicRealm(), false);
                this.computeDiff("CacheCaseSensitive", this.bean.getCacheCaseSensitive(), cachingRealmMBeanImpl.getCacheCaseSensitive(), false);
                this.computeDiff("GroupCacheEnable", this.bean.getGroupCacheEnable(), cachingRealmMBeanImpl.getGroupCacheEnable(), false);
                this.computeDiff("GroupCacheSize", this.bean.getGroupCacheSize(), cachingRealmMBeanImpl.getGroupCacheSize(), false);
                this.computeDiff("GroupCacheTTLNegative", this.bean.getGroupCacheTTLNegative(), cachingRealmMBeanImpl.getGroupCacheTTLNegative(), false);
                this.computeDiff("GroupCacheTTLPositive", this.bean.getGroupCacheTTLPositive(), cachingRealmMBeanImpl.getGroupCacheTTLPositive(), false);
                this.computeDiff("GroupMembershipCacheTTL", this.bean.getGroupMembershipCacheTTL(), cachingRealmMBeanImpl.getGroupMembershipCacheTTL(), false);
                this.computeDiff("PermissionCacheEnable", this.bean.getPermissionCacheEnable(), cachingRealmMBeanImpl.getPermissionCacheEnable(), false);
                this.computeDiff("PermissionCacheSize", this.bean.getPermissionCacheSize(), cachingRealmMBeanImpl.getPermissionCacheSize(), false);
                this.computeDiff("PermissionCacheTTLNegative", this.bean.getPermissionCacheTTLNegative(), cachingRealmMBeanImpl.getPermissionCacheTTLNegative(), false);
                this.computeDiff("PermissionCacheTTLPositive", this.bean.getPermissionCacheTTLPositive(), cachingRealmMBeanImpl.getPermissionCacheTTLPositive(), false);
                this.computeDiff("UserCacheEnable", this.bean.getUserCacheEnable(), cachingRealmMBeanImpl.getUserCacheEnable(), false);
                this.computeDiff("UserCacheSize", this.bean.getUserCacheSize(), cachingRealmMBeanImpl.getUserCacheSize(), false);
                this.computeDiff("UserCacheTTLNegative", this.bean.getUserCacheTTLNegative(), cachingRealmMBeanImpl.getUserCacheTTLNegative(), false);
                this.computeDiff("UserCacheTTLPositive", this.bean.getUserCacheTTLPositive(), cachingRealmMBeanImpl.getUserCacheTTLPositive(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                CachingRealmMBeanImpl cachingRealmMBeanImpl = (CachingRealmMBeanImpl)beanUpdateEvent.getSourceBean();
                CachingRealmMBeanImpl cachingRealmMBeanImpl2 = (CachingRealmMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("ACLCacheEnable")) {
                    cachingRealmMBeanImpl.setACLCacheEnable(cachingRealmMBeanImpl2.getACLCacheEnable());
                    cachingRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("ACLCacheSize")) {
                    cachingRealmMBeanImpl.setACLCacheSize(cachingRealmMBeanImpl2.getACLCacheSize());
                    cachingRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("ACLCacheTTLNegative")) {
                    cachingRealmMBeanImpl.setACLCacheTTLNegative(cachingRealmMBeanImpl2.getACLCacheTTLNegative());
                    cachingRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                } else if (string.equals("ACLCacheTTLPositive")) {
                    cachingRealmMBeanImpl.setACLCacheTTLPositive(cachingRealmMBeanImpl2.getACLCacheTTLPositive());
                    cachingRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                } else if (string.equals("AuthenticationCacheEnable")) {
                    cachingRealmMBeanImpl.setAuthenticationCacheEnable(cachingRealmMBeanImpl2.getAuthenticationCacheEnable());
                    cachingRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("AuthenticationCacheSize")) {
                    cachingRealmMBeanImpl.setAuthenticationCacheSize(cachingRealmMBeanImpl2.getAuthenticationCacheSize());
                    cachingRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("AuthenticationCacheTTLNegative")) {
                    cachingRealmMBeanImpl.setAuthenticationCacheTTLNegative(cachingRealmMBeanImpl2.getAuthenticationCacheTTLNegative());
                    cachingRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 26);
                } else if (string.equals("AuthenticationCacheTTLPositive")) {
                    cachingRealmMBeanImpl.setAuthenticationCacheTTLPositive(cachingRealmMBeanImpl2.getAuthenticationCacheTTLPositive());
                    cachingRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                } else if (string.equals("BasicRealm")) {
                    cachingRealmMBeanImpl.setBasicRealmAsString(cachingRealmMBeanImpl2.getBasicRealmAsString());
                    cachingRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("CacheCaseSensitive")) {
                    cachingRealmMBeanImpl.setCacheCaseSensitive(cachingRealmMBeanImpl2.getCacheCaseSensitive());
                    cachingRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("GroupCacheEnable")) {
                    cachingRealmMBeanImpl.setGroupCacheEnable(cachingRealmMBeanImpl2.getGroupCacheEnable());
                    cachingRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("GroupCacheSize")) {
                    cachingRealmMBeanImpl.setGroupCacheSize(cachingRealmMBeanImpl2.getGroupCacheSize());
                    cachingRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else if (string.equals("GroupCacheTTLNegative")) {
                    cachingRealmMBeanImpl.setGroupCacheTTLNegative(cachingRealmMBeanImpl2.getGroupCacheTTLNegative());
                    cachingRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                } else if (string.equals("GroupCacheTTLPositive")) {
                    cachingRealmMBeanImpl.setGroupCacheTTLPositive(cachingRealmMBeanImpl2.getGroupCacheTTLPositive());
                    cachingRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                } else if (string.equals("GroupMembershipCacheTTL")) {
                    cachingRealmMBeanImpl.setGroupMembershipCacheTTL(cachingRealmMBeanImpl2.getGroupMembershipCacheTTL());
                    cachingRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 29);
                } else if (string.equals("PermissionCacheEnable")) {
                    cachingRealmMBeanImpl.setPermissionCacheEnable(cachingRealmMBeanImpl2.getPermissionCacheEnable());
                    cachingRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("PermissionCacheSize")) {
                    cachingRealmMBeanImpl.setPermissionCacheSize(cachingRealmMBeanImpl2.getPermissionCacheSize());
                    cachingRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else if (string.equals("PermissionCacheTTLNegative")) {
                    cachingRealmMBeanImpl.setPermissionCacheTTLNegative(cachingRealmMBeanImpl2.getPermissionCacheTTLNegative());
                    cachingRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 27);
                } else if (string.equals("PermissionCacheTTLPositive")) {
                    cachingRealmMBeanImpl.setPermissionCacheTTLPositive(cachingRealmMBeanImpl2.getPermissionCacheTTLPositive());
                    cachingRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                } else if (string.equals("UserCacheEnable")) {
                    cachingRealmMBeanImpl.setUserCacheEnable(cachingRealmMBeanImpl2.getUserCacheEnable());
                    cachingRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("UserCacheSize")) {
                    cachingRealmMBeanImpl.setUserCacheSize(cachingRealmMBeanImpl2.getUserCacheSize());
                    cachingRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                } else if (string.equals("UserCacheTTLNegative")) {
                    cachingRealmMBeanImpl.setUserCacheTTLNegative(cachingRealmMBeanImpl2.getUserCacheTTLNegative());
                    cachingRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 28);
                } else if (string.equals("UserCacheTTLPositive")) {
                    cachingRealmMBeanImpl.setUserCacheTTLPositive(cachingRealmMBeanImpl2.getUserCacheTTLPositive());
                    cachingRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                CachingRealmMBeanImpl cachingRealmMBeanImpl = (CachingRealmMBeanImpl)abstractDescriptorBean;
                super.finishCopy(cachingRealmMBeanImpl, bl, list);
                if ((list == null || !list.contains("ACLCacheEnable")) && this.bean.isACLCacheEnableSet()) {
                    cachingRealmMBeanImpl.setACLCacheEnable(this.bean.getACLCacheEnable());
                }
                if ((list == null || !list.contains("ACLCacheSize")) && this.bean.isACLCacheSizeSet()) {
                    cachingRealmMBeanImpl.setACLCacheSize(this.bean.getACLCacheSize());
                }
                if ((list == null || !list.contains("ACLCacheTTLNegative")) && this.bean.isACLCacheTTLNegativeSet()) {
                    cachingRealmMBeanImpl.setACLCacheTTLNegative(this.bean.getACLCacheTTLNegative());
                }
                if ((list == null || !list.contains("ACLCacheTTLPositive")) && this.bean.isACLCacheTTLPositiveSet()) {
                    cachingRealmMBeanImpl.setACLCacheTTLPositive(this.bean.getACLCacheTTLPositive());
                }
                if ((list == null || !list.contains("AuthenticationCacheEnable")) && this.bean.isAuthenticationCacheEnableSet()) {
                    cachingRealmMBeanImpl.setAuthenticationCacheEnable(this.bean.getAuthenticationCacheEnable());
                }
                if ((list == null || !list.contains("AuthenticationCacheSize")) && this.bean.isAuthenticationCacheSizeSet()) {
                    cachingRealmMBeanImpl.setAuthenticationCacheSize(this.bean.getAuthenticationCacheSize());
                }
                if ((list == null || !list.contains("AuthenticationCacheTTLNegative")) && this.bean.isAuthenticationCacheTTLNegativeSet()) {
                    cachingRealmMBeanImpl.setAuthenticationCacheTTLNegative(this.bean.getAuthenticationCacheTTLNegative());
                }
                if ((list == null || !list.contains("AuthenticationCacheTTLPositive")) && this.bean.isAuthenticationCacheTTLPositiveSet()) {
                    cachingRealmMBeanImpl.setAuthenticationCacheTTLPositive(this.bean.getAuthenticationCacheTTLPositive());
                }
                if ((list == null || !list.contains("BasicRealm")) && this.bean.isBasicRealmSet()) {
                    cachingRealmMBeanImpl._unSet(cachingRealmMBeanImpl, 7);
                    cachingRealmMBeanImpl.setBasicRealmAsString(this.bean.getBasicRealmAsString());
                }
                if ((list == null || !list.contains("CacheCaseSensitive")) && this.bean.isCacheCaseSensitiveSet()) {
                    cachingRealmMBeanImpl.setCacheCaseSensitive(this.bean.getCacheCaseSensitive());
                }
                if ((list == null || !list.contains("GroupCacheEnable")) && this.bean.isGroupCacheEnableSet()) {
                    cachingRealmMBeanImpl.setGroupCacheEnable(this.bean.getGroupCacheEnable());
                }
                if ((list == null || !list.contains("GroupCacheSize")) && this.bean.isGroupCacheSizeSet()) {
                    cachingRealmMBeanImpl.setGroupCacheSize(this.bean.getGroupCacheSize());
                }
                if ((list == null || !list.contains("GroupCacheTTLNegative")) && this.bean.isGroupCacheTTLNegativeSet()) {
                    cachingRealmMBeanImpl.setGroupCacheTTLNegative(this.bean.getGroupCacheTTLNegative());
                }
                if ((list == null || !list.contains("GroupCacheTTLPositive")) && this.bean.isGroupCacheTTLPositiveSet()) {
                    cachingRealmMBeanImpl.setGroupCacheTTLPositive(this.bean.getGroupCacheTTLPositive());
                }
                if ((list == null || !list.contains("GroupMembershipCacheTTL")) && this.bean.isGroupMembershipCacheTTLSet()) {
                    cachingRealmMBeanImpl.setGroupMembershipCacheTTL(this.bean.getGroupMembershipCacheTTL());
                }
                if ((list == null || !list.contains("PermissionCacheEnable")) && this.bean.isPermissionCacheEnableSet()) {
                    cachingRealmMBeanImpl.setPermissionCacheEnable(this.bean.getPermissionCacheEnable());
                }
                if ((list == null || !list.contains("PermissionCacheSize")) && this.bean.isPermissionCacheSizeSet()) {
                    cachingRealmMBeanImpl.setPermissionCacheSize(this.bean.getPermissionCacheSize());
                }
                if ((list == null || !list.contains("PermissionCacheTTLNegative")) && this.bean.isPermissionCacheTTLNegativeSet()) {
                    cachingRealmMBeanImpl.setPermissionCacheTTLNegative(this.bean.getPermissionCacheTTLNegative());
                }
                if ((list == null || !list.contains("PermissionCacheTTLPositive")) && this.bean.isPermissionCacheTTLPositiveSet()) {
                    cachingRealmMBeanImpl.setPermissionCacheTTLPositive(this.bean.getPermissionCacheTTLPositive());
                }
                if ((list == null || !list.contains("UserCacheEnable")) && this.bean.isUserCacheEnableSet()) {
                    cachingRealmMBeanImpl.setUserCacheEnable(this.bean.getUserCacheEnable());
                }
                if ((list == null || !list.contains("UserCacheSize")) && this.bean.isUserCacheSizeSet()) {
                    cachingRealmMBeanImpl.setUserCacheSize(this.bean.getUserCacheSize());
                }
                if ((list == null || !list.contains("UserCacheTTLNegative")) && this.bean.isUserCacheTTLNegativeSet()) {
                    cachingRealmMBeanImpl.setUserCacheTTLNegative(this.bean.getUserCacheTTLNegative());
                }
                if ((list == null || !list.contains("UserCacheTTLPositive")) && this.bean.isUserCacheTTLPositiveSet()) {
                    cachingRealmMBeanImpl.setUserCacheTTLPositive(this.bean.getUserCacheTTLPositive());
                }
                return cachingRealmMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getBasicRealm(), clazz, object);
        }
    }
}

