/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorValidateException;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.configuration.CertRevocCaMBean;
import weblogic.management.configuration.CertRevocMBean;
import weblogic.management.configuration.CertRevocValidator;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.utils.collections.CombinedIterator;

public class CertRevocCaMBeanImpl
extends ConfigurationMBeanImpl
implements CertRevocCaMBean,
Serializable {
    private boolean _CheckingDisabled;
    private boolean _CrlDpBackgroundDownloadEnabled;
    private long _CrlDpDownloadTimeout;
    private boolean _CrlDpEnabled;
    private String _CrlDpUrl;
    private String _CrlDpUrlUsage;
    private String _DistinguishedName;
    private boolean _FailOnUnknownRevocStatus;
    private String _MethodOrder;
    private boolean _OcspNonceEnabled;
    private String _OcspResponderCertIssuerName;
    private String _OcspResponderCertSerialNumber;
    private String _OcspResponderCertSubjectName;
    private String _OcspResponderExplicitTrustMethod;
    private String _OcspResponderUrl;
    private String _OcspResponderUrlUsage;
    private boolean _OcspResponseCacheEnabled;
    private long _OcspResponseTimeout;
    private int _OcspTimeTolerance;
    private static SchemaHelper2 _schemaHelper;

    public CertRevocCaMBeanImpl() {
        this._initializeProperty(-1);
    }

    public CertRevocCaMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public String getDistinguishedName() {
        return this._DistinguishedName;
    }

    public boolean isDistinguishedNameSet() {
        return this._isSet(7);
    }

    public void setDistinguishedName(String string) {
        string = string == null ? null : string.trim();
        CertRevocValidator.validateX500PrincipalDN(string);
        String string2 = this._DistinguishedName;
        this._DistinguishedName = string;
        this._postSet(7, string2, string);
    }

    public boolean isCheckingDisabled() {
        return this._CheckingDisabled;
    }

    public boolean isCheckingDisabledSet() {
        return this._isSet(8);
    }

    public void setCheckingDisabled(boolean bl) {
        boolean bl2 = this._CheckingDisabled;
        this._CheckingDisabled = bl;
        this._postSet(8, bl2, bl);
    }

    public boolean isFailOnUnknownRevocStatus() {
        if (!this._isSet(9)) {
            try {
                return ((CertRevocMBean)this.getParent()).isFailOnUnknownRevocStatus();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._FailOnUnknownRevocStatus;
    }

    public boolean isFailOnUnknownRevocStatusSet() {
        return this._isSet(9);
    }

    public void setFailOnUnknownRevocStatus(boolean bl) {
        boolean bl2 = this._FailOnUnknownRevocStatus;
        this._FailOnUnknownRevocStatus = bl;
        this._postSet(9, bl2, bl);
    }

    public String getMethodOrder() {
        if (!this._isSet(10)) {
            try {
                return ((CertRevocMBean)this.getParent()).getMethodOrder();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._MethodOrder;
    }

    public boolean isMethodOrderSet() {
        return this._isSet(10);
    }

    public void setMethodOrder(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{CertRevocMBean.METHOD_OCSP, CertRevocMBean.METHOD_CRL, CertRevocMBean.METHOD_OCSP_THEN_CRL, CertRevocMBean.METHOD_CRL_THEN_OCSP};
        string = LegalChecks.checkInEnum((String)"MethodOrder", (String)string, (String[])stringArray);
        String string2 = this._MethodOrder;
        this._MethodOrder = string;
        this._postSet(10, string2, string);
    }

    public String getOcspResponderUrl() {
        return this._OcspResponderUrl;
    }

    public boolean isOcspResponderUrlSet() {
        return this._isSet(11);
    }

    public void setOcspResponderUrl(String string) {
        string = string == null ? null : string.trim();
        CertRevocValidator.validateURL(string);
        String string2 = this._OcspResponderUrl;
        this._OcspResponderUrl = string;
        this._postSet(11, string2, string);
    }

    public String getOcspResponderUrlUsage() {
        return this._OcspResponderUrlUsage;
    }

    public boolean isOcspResponderUrlUsageSet() {
        return this._isSet(12);
    }

    public void setOcspResponderUrlUsage(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{CertRevocCaMBean.USAGE_FAILOVER, CertRevocCaMBean.USAGE_OVERRIDE};
        string = LegalChecks.checkInEnum((String)"OcspResponderUrlUsage", (String)string, (String[])stringArray);
        String string2 = this._OcspResponderUrlUsage;
        this._OcspResponderUrlUsage = string;
        this._postSet(12, string2, string);
    }

    public String getOcspResponderExplicitTrustMethod() {
        return this._OcspResponderExplicitTrustMethod;
    }

    public boolean isOcspResponderExplicitTrustMethodSet() {
        return this._isSet(13);
    }

    public void setOcspResponderExplicitTrustMethod(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{CertRevocCaMBean.OCSP_EXPLICIT_TRUST_METHOD_NONE, CertRevocCaMBean.OCSP_EXPLICIT_TRUST_METHOD_USE_SUBJECT, CertRevocCaMBean.OCSP_EXPLICIT_TRUST_METHOD_USE_ISSUER_SERIAL_NUMBER};
        string = LegalChecks.checkInEnum((String)"OcspResponderExplicitTrustMethod", (String)string, (String[])stringArray);
        String string2 = this._OcspResponderExplicitTrustMethod;
        this._OcspResponderExplicitTrustMethod = string;
        this._postSet(13, string2, string);
    }

    public String getOcspResponderCertSubjectName() {
        return this._OcspResponderCertSubjectName;
    }

    public boolean isOcspResponderCertSubjectNameSet() {
        return this._isSet(14);
    }

    public void setOcspResponderCertSubjectName(String string) {
        string = string == null ? null : string.trim();
        CertRevocValidator.validateX500PrincipalDN(string);
        String string2 = this._OcspResponderCertSubjectName;
        this._OcspResponderCertSubjectName = string;
        this._postSet(14, string2, string);
    }

    public String getOcspResponderCertIssuerName() {
        return this._OcspResponderCertIssuerName;
    }

    public boolean isOcspResponderCertIssuerNameSet() {
        return this._isSet(15);
    }

    public void setOcspResponderCertIssuerName(String string) {
        string = string == null ? null : string.trim();
        CertRevocValidator.validateX500PrincipalDN(string);
        String string2 = this._OcspResponderCertIssuerName;
        this._OcspResponderCertIssuerName = string;
        this._postSet(15, string2, string);
    }

    public String getOcspResponderCertSerialNumber() {
        return this._OcspResponderCertSerialNumber;
    }

    public boolean isOcspResponderCertSerialNumberSet() {
        return this._isSet(16);
    }

    public void setOcspResponderCertSerialNumber(String string) {
        string = string == null ? null : string.trim();
        CertRevocValidator.validateCertSerialNumber(string);
        String string2 = this._OcspResponderCertSerialNumber;
        this._OcspResponderCertSerialNumber = string;
        this._postSet(16, string2, string);
    }

    public boolean isOcspNonceEnabled() {
        if (!this._isSet(17)) {
            try {
                return ((CertRevocMBean)this.getParent()).isOcspNonceEnabled();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._OcspNonceEnabled;
    }

    public boolean isOcspNonceEnabledSet() {
        return this._isSet(17);
    }

    public void setOcspNonceEnabled(boolean bl) {
        boolean bl2 = this._OcspNonceEnabled;
        this._OcspNonceEnabled = bl;
        this._postSet(17, bl2, bl);
    }

    public boolean isOcspResponseCacheEnabled() {
        if (!this._isSet(18)) {
            try {
                return ((CertRevocMBean)this.getParent()).isOcspResponseCacheEnabled();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._OcspResponseCacheEnabled;
    }

    public boolean isOcspResponseCacheEnabledSet() {
        return this._isSet(18);
    }

    public void setOcspResponseCacheEnabled(boolean bl) {
        boolean bl2 = this._OcspResponseCacheEnabled;
        this._OcspResponseCacheEnabled = bl;
        this._postSet(18, bl2, bl);
    }

    public long getOcspResponseTimeout() {
        if (!this._isSet(19)) {
            try {
                return ((CertRevocMBean)this.getParent()).getOcspResponseTimeout();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._OcspResponseTimeout;
    }

    public boolean isOcspResponseTimeoutSet() {
        return this._isSet(19);
    }

    public void setOcspResponseTimeout(long l) {
        LegalChecks.checkInRange((String)"OcspResponseTimeout", (long)l, (long)1L, (long)300L);
        long l2 = this._OcspResponseTimeout;
        this._OcspResponseTimeout = l;
        this._postSet(19, l2, l);
    }

    public int getOcspTimeTolerance() {
        if (!this._isSet(20)) {
            try {
                return ((CertRevocMBean)this.getParent()).getOcspTimeTolerance();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._OcspTimeTolerance;
    }

    public boolean isOcspTimeToleranceSet() {
        return this._isSet(20);
    }

    public void setOcspTimeTolerance(int n) {
        LegalChecks.checkInRange((String)"OcspTimeTolerance", (long)n, (long)0L, (long)900L);
        int n2 = this._OcspTimeTolerance;
        this._OcspTimeTolerance = n;
        this._postSet(20, n2, n);
    }

    public boolean isCrlDpEnabled() {
        if (!this._isSet(21)) {
            try {
                return ((CertRevocMBean)this.getParent()).isCrlDpEnabled();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._CrlDpEnabled;
    }

    public boolean isCrlDpEnabledSet() {
        return this._isSet(21);
    }

    public void setCrlDpEnabled(boolean bl) {
        boolean bl2 = this._CrlDpEnabled;
        this._CrlDpEnabled = bl;
        this._postSet(21, bl2, bl);
    }

    public long getCrlDpDownloadTimeout() {
        if (!this._isSet(22)) {
            try {
                return ((CertRevocMBean)this.getParent()).getCrlDpDownloadTimeout();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._CrlDpDownloadTimeout;
    }

    public boolean isCrlDpDownloadTimeoutSet() {
        return this._isSet(22);
    }

    public void setCrlDpDownloadTimeout(long l) {
        LegalChecks.checkInRange((String)"CrlDpDownloadTimeout", (long)l, (long)1L, (long)300L);
        long l2 = this._CrlDpDownloadTimeout;
        this._CrlDpDownloadTimeout = l;
        this._postSet(22, l2, l);
    }

    public boolean isCrlDpBackgroundDownloadEnabled() {
        if (!this._isSet(23)) {
            try {
                return ((CertRevocMBean)this.getParent()).isCrlDpBackgroundDownloadEnabled();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._CrlDpBackgroundDownloadEnabled;
    }

    public boolean isCrlDpBackgroundDownloadEnabledSet() {
        return this._isSet(23);
    }

    public void setCrlDpBackgroundDownloadEnabled(boolean bl) {
        boolean bl2 = this._CrlDpBackgroundDownloadEnabled;
        this._CrlDpBackgroundDownloadEnabled = bl;
        this._postSet(23, bl2, bl);
    }

    public String getCrlDpUrl() {
        return this._CrlDpUrl;
    }

    public boolean isCrlDpUrlSet() {
        return this._isSet(24);
    }

    public void setCrlDpUrl(String string) {
        string = string == null ? null : string.trim();
        CertRevocValidator.validateURL(string);
        String string2 = this._CrlDpUrl;
        this._CrlDpUrl = string;
        this._postSet(24, string2, string);
    }

    public String getCrlDpUrlUsage() {
        return this._CrlDpUrlUsage;
    }

    public boolean isCrlDpUrlUsageSet() {
        return this._isSet(25);
    }

    public void setCrlDpUrlUsage(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{CertRevocCaMBean.USAGE_FAILOVER, CertRevocCaMBean.USAGE_OVERRIDE};
        string = LegalChecks.checkInEnum((String)"CrlDpUrlUsage", (String)string, (String[])stringArray);
        String string2 = this._CrlDpUrlUsage;
        this._CrlDpUrlUsage = string;
        this._postSet(25, string2, string);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 22;
        }
        try {
            switch (n) {
                case 22: {
                    this._CrlDpDownloadTimeout = 0L;
                    if (bl) break;
                }
                case 24: {
                    this._CrlDpUrl = CertRevocCaMBean.DEFAULT_CRL_DP_URL;
                    if (bl) break;
                }
                case 25: {
                    this._CrlDpUrlUsage = CertRevocCaMBean.DEFAULT_CRL_DP_URL_USAGE;
                    if (bl) break;
                }
                case 7: {
                    this._DistinguishedName = CertRevocCaMBean.DEFAULT_DISTINGUISHED_NAME;
                    if (bl) break;
                }
                case 10: {
                    this._MethodOrder = null;
                    if (bl) break;
                }
                case 15: {
                    this._OcspResponderCertIssuerName = CertRevocCaMBean.DEFAULT_OCSP_RESPONDER_CERT_ISSUER_NAME;
                    if (bl) break;
                }
                case 16: {
                    this._OcspResponderCertSerialNumber = CertRevocCaMBean.DEFAULT_OCSP_RESPONDER_CERT_SERIAL_NUMBER;
                    if (bl) break;
                }
                case 14: {
                    this._OcspResponderCertSubjectName = CertRevocCaMBean.DEFAULT_OCSP_RESPONDER_CERT_SUBJECT_NAME;
                    if (bl) break;
                }
                case 13: {
                    this._OcspResponderExplicitTrustMethod = CertRevocCaMBean.DEFAULT_OCSP_RESPONDER_EXPLICIT_TRUST_METHOD;
                    if (bl) break;
                }
                case 11: {
                    this._OcspResponderUrl = CertRevocCaMBean.DEFAULT_OCSP_RESPONDER_URL;
                    if (bl) break;
                }
                case 12: {
                    this._OcspResponderUrlUsage = CertRevocCaMBean.DEFAULT_OCSP_RESPONDER_URL_USAGE;
                    if (bl) break;
                }
                case 19: {
                    this._OcspResponseTimeout = 0L;
                    if (bl) break;
                }
                case 20: {
                    this._OcspTimeTolerance = 0;
                    if (bl) break;
                }
                case 8: {
                    this._CheckingDisabled = CertRevocCaMBean.DEFAULT_CHECKING_DISABLED;
                    if (bl) break;
                }
                case 23: {
                    this._CrlDpBackgroundDownloadEnabled = false;
                    if (bl) break;
                }
                case 21: {
                    this._CrlDpEnabled = false;
                    if (bl) break;
                }
                case 9: {
                    this._FailOnUnknownRevocStatus = false;
                    if (bl) break;
                }
                case 17: {
                    this._OcspNonceEnabled = false;
                    if (bl) break;
                }
                case 18: {
                    this._OcspResponseCacheEnabled = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "CertRevocCa";
    }

    public void putValue(String string, Object object) {
        if (string.equals("CheckingDisabled")) {
            boolean bl = this._CheckingDisabled;
            this._CheckingDisabled = (Boolean)object;
            this._postSet(8, bl, this._CheckingDisabled);
            return;
        }
        if (string.equals("CrlDpBackgroundDownloadEnabled")) {
            boolean bl = this._CrlDpBackgroundDownloadEnabled;
            this._CrlDpBackgroundDownloadEnabled = (Boolean)object;
            this._postSet(23, bl, this._CrlDpBackgroundDownloadEnabled);
            return;
        }
        if (string.equals("CrlDpDownloadTimeout")) {
            long l = this._CrlDpDownloadTimeout;
            this._CrlDpDownloadTimeout = (Long)object;
            this._postSet(22, l, this._CrlDpDownloadTimeout);
            return;
        }
        if (string.equals("CrlDpEnabled")) {
            boolean bl = this._CrlDpEnabled;
            this._CrlDpEnabled = (Boolean)object;
            this._postSet(21, bl, this._CrlDpEnabled);
            return;
        }
        if (string.equals("CrlDpUrl")) {
            String string2 = this._CrlDpUrl;
            this._CrlDpUrl = (String)object;
            this._postSet(24, string2, this._CrlDpUrl);
            return;
        }
        if (string.equals("CrlDpUrlUsage")) {
            String string3 = this._CrlDpUrlUsage;
            this._CrlDpUrlUsage = (String)object;
            this._postSet(25, string3, this._CrlDpUrlUsage);
            return;
        }
        if (string.equals("DistinguishedName")) {
            String string4 = this._DistinguishedName;
            this._DistinguishedName = (String)object;
            this._postSet(7, string4, this._DistinguishedName);
            return;
        }
        if (string.equals("FailOnUnknownRevocStatus")) {
            boolean bl = this._FailOnUnknownRevocStatus;
            this._FailOnUnknownRevocStatus = (Boolean)object;
            this._postSet(9, bl, this._FailOnUnknownRevocStatus);
            return;
        }
        if (string.equals("MethodOrder")) {
            String string5 = this._MethodOrder;
            this._MethodOrder = (String)object;
            this._postSet(10, string5, this._MethodOrder);
            return;
        }
        if (string.equals("OcspNonceEnabled")) {
            boolean bl = this._OcspNonceEnabled;
            this._OcspNonceEnabled = (Boolean)object;
            this._postSet(17, bl, this._OcspNonceEnabled);
            return;
        }
        if (string.equals("OcspResponderCertIssuerName")) {
            String string6 = this._OcspResponderCertIssuerName;
            this._OcspResponderCertIssuerName = (String)object;
            this._postSet(15, string6, this._OcspResponderCertIssuerName);
            return;
        }
        if (string.equals("OcspResponderCertSerialNumber")) {
            String string7 = this._OcspResponderCertSerialNumber;
            this._OcspResponderCertSerialNumber = (String)object;
            this._postSet(16, string7, this._OcspResponderCertSerialNumber);
            return;
        }
        if (string.equals("OcspResponderCertSubjectName")) {
            String string8 = this._OcspResponderCertSubjectName;
            this._OcspResponderCertSubjectName = (String)object;
            this._postSet(14, string8, this._OcspResponderCertSubjectName);
            return;
        }
        if (string.equals("OcspResponderExplicitTrustMethod")) {
            String string9 = this._OcspResponderExplicitTrustMethod;
            this._OcspResponderExplicitTrustMethod = (String)object;
            this._postSet(13, string9, this._OcspResponderExplicitTrustMethod);
            return;
        }
        if (string.equals("OcspResponderUrl")) {
            String string10 = this._OcspResponderUrl;
            this._OcspResponderUrl = (String)object;
            this._postSet(11, string10, this._OcspResponderUrl);
            return;
        }
        if (string.equals("OcspResponderUrlUsage")) {
            String string11 = this._OcspResponderUrlUsage;
            this._OcspResponderUrlUsage = (String)object;
            this._postSet(12, string11, this._OcspResponderUrlUsage);
            return;
        }
        if (string.equals("OcspResponseCacheEnabled")) {
            boolean bl = this._OcspResponseCacheEnabled;
            this._OcspResponseCacheEnabled = (Boolean)object;
            this._postSet(18, bl, this._OcspResponseCacheEnabled);
            return;
        }
        if (string.equals("OcspResponseTimeout")) {
            long l = this._OcspResponseTimeout;
            this._OcspResponseTimeout = (Long)object;
            this._postSet(19, l, this._OcspResponseTimeout);
            return;
        }
        if (string.equals("OcspTimeTolerance")) {
            int n = this._OcspTimeTolerance;
            this._OcspTimeTolerance = (Integer)object;
            this._postSet(20, n, this._OcspTimeTolerance);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("CheckingDisabled")) {
            return new Boolean(this._CheckingDisabled);
        }
        if (string.equals("CrlDpBackgroundDownloadEnabled")) {
            return new Boolean(this._CrlDpBackgroundDownloadEnabled);
        }
        if (string.equals("CrlDpDownloadTimeout")) {
            return new Long(this._CrlDpDownloadTimeout);
        }
        if (string.equals("CrlDpEnabled")) {
            return new Boolean(this._CrlDpEnabled);
        }
        if (string.equals("CrlDpUrl")) {
            return this._CrlDpUrl;
        }
        if (string.equals("CrlDpUrlUsage")) {
            return this._CrlDpUrlUsage;
        }
        if (string.equals("DistinguishedName")) {
            return this._DistinguishedName;
        }
        if (string.equals("FailOnUnknownRevocStatus")) {
            return new Boolean(this._FailOnUnknownRevocStatus);
        }
        if (string.equals("MethodOrder")) {
            return this._MethodOrder;
        }
        if (string.equals("OcspNonceEnabled")) {
            return new Boolean(this._OcspNonceEnabled);
        }
        if (string.equals("OcspResponderCertIssuerName")) {
            return this._OcspResponderCertIssuerName;
        }
        if (string.equals("OcspResponderCertSerialNumber")) {
            return this._OcspResponderCertSerialNumber;
        }
        if (string.equals("OcspResponderCertSubjectName")) {
            return this._OcspResponderCertSubjectName;
        }
        if (string.equals("OcspResponderExplicitTrustMethod")) {
            return this._OcspResponderExplicitTrustMethod;
        }
        if (string.equals("OcspResponderUrl")) {
            return this._OcspResponderUrl;
        }
        if (string.equals("OcspResponderUrlUsage")) {
            return this._OcspResponderUrlUsage;
        }
        if (string.equals("OcspResponseCacheEnabled")) {
            return new Boolean(this._OcspResponseCacheEnabled);
        }
        if (string.equals("OcspResponseTimeout")) {
            return new Long(this._OcspResponseTimeout);
        }
        if (string.equals("OcspTimeTolerance")) {
            return new Integer(this._OcspTimeTolerance);
        }
        return super.getValue(string);
    }

    public static void validateGeneration() {
        String[] stringArray;
        try {
            stringArray = new String[]{CertRevocCaMBean.USAGE_FAILOVER, CertRevocCaMBean.USAGE_OVERRIDE};
            LegalChecks.checkInEnum((String)"CrlDpUrlUsage", (String)CertRevocCaMBean.DEFAULT_CRL_DP_URL_USAGE, (String[])stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("Default value for a property  should be one of the legal values. Refer annotation legalValues on property CrlDpUrlUsage in CertRevocCaMBean" + illegalArgumentException.getMessage());
        }
        try {
            stringArray = new String[]{CertRevocCaMBean.OCSP_EXPLICIT_TRUST_METHOD_NONE, CertRevocCaMBean.OCSP_EXPLICIT_TRUST_METHOD_USE_SUBJECT, CertRevocCaMBean.OCSP_EXPLICIT_TRUST_METHOD_USE_ISSUER_SERIAL_NUMBER};
            LegalChecks.checkInEnum((String)"OcspResponderExplicitTrustMethod", (String)CertRevocCaMBean.DEFAULT_OCSP_RESPONDER_EXPLICIT_TRUST_METHOD, (String[])stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("Default value for a property  should be one of the legal values. Refer annotation legalValues on property OcspResponderExplicitTrustMethod in CertRevocCaMBean" + illegalArgumentException.getMessage());
        }
        try {
            stringArray = new String[]{CertRevocCaMBean.USAGE_FAILOVER, CertRevocCaMBean.USAGE_OVERRIDE};
            LegalChecks.checkInEnum((String)"OcspResponderUrlUsage", (String)CertRevocCaMBean.DEFAULT_OCSP_RESPONDER_URL_USAGE, (String[])stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("Default value for a property  should be one of the legal values. Refer annotation legalValues on property OcspResponderUrlUsage in CertRevocCaMBean" + illegalArgumentException.getMessage());
        }
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 23: {
                    if (!string.equals("crl-dp-download-timeout")) break;
                    return 22;
                }
                case 10: {
                    if (!string.equals("crl-dp-url")) break;
                    return 24;
                }
                case 16: {
                    if (!string.equals("crl-dp-url-usage")) break;
                    return 25;
                }
                case 18: {
                    if (string.equals("distinguished-name")) {
                        return 7;
                    }
                    if (string.equals("ocsp-responder-url")) {
                        return 11;
                    }
                    if (!string.equals("ocsp-nonce-enabled")) break;
                    return 17;
                }
                case 12: {
                    if (!string.equals("method-order")) break;
                    return 10;
                }
                case 31: {
                    if (!string.equals("ocsp-responder-cert-issuer-name")) break;
                    return 15;
                }
                case 33: {
                    if (!string.equals("ocsp-responder-cert-serial-number")) break;
                    return 16;
                }
                case 32: {
                    if (!string.equals("ocsp-responder-cert-subject-name")) break;
                    return 14;
                }
                case 36: {
                    if (!string.equals("ocsp-responder-explicit-trust-method")) break;
                    return 13;
                }
                case 24: {
                    if (!string.equals("ocsp-responder-url-usage")) break;
                    return 12;
                }
                case 21: {
                    if (!string.equals("ocsp-response-timeout")) break;
                    return 19;
                }
                case 19: {
                    if (!string.equals("ocsp-time-tolerance")) break;
                    return 20;
                }
                case 17: {
                    if (!string.equals("checking-disabled")) break;
                    return 8;
                }
                case 34: {
                    if (!string.equals("crl-dp-background-download-enabled")) break;
                    return 23;
                }
                case 14: {
                    if (!string.equals("crl-dp-enabled")) break;
                    return 21;
                }
                case 28: {
                    if (!string.equals("fail-on-unknown-revoc-status")) break;
                    return 9;
                }
                case 27: {
                    if (!string.equals("ocsp-response-cache-enabled")) break;
                    return 18;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 22: {
                    return "crl-dp-download-timeout";
                }
                case 24: {
                    return "crl-dp-url";
                }
                case 25: {
                    return "crl-dp-url-usage";
                }
                case 7: {
                    return "distinguished-name";
                }
                case 10: {
                    return "method-order";
                }
                case 15: {
                    return "ocsp-responder-cert-issuer-name";
                }
                case 16: {
                    return "ocsp-responder-cert-serial-number";
                }
                case 14: {
                    return "ocsp-responder-cert-subject-name";
                }
                case 13: {
                    return "ocsp-responder-explicit-trust-method";
                }
                case 11: {
                    return "ocsp-responder-url";
                }
                case 12: {
                    return "ocsp-responder-url-usage";
                }
                case 19: {
                    return "ocsp-response-timeout";
                }
                case 20: {
                    return "ocsp-time-tolerance";
                }
                case 8: {
                    return "checking-disabled";
                }
                case 23: {
                    return "crl-dp-background-download-enabled";
                }
                case 21: {
                    return "crl-dp-enabled";
                }
                case 9: {
                    return "fail-on-unknown-revoc-status";
                }
                case 17: {
                    return "ocsp-nonce-enabled";
                }
                case 18: {
                    return "ocsp-response-cache-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private CertRevocCaMBeanImpl bean;

        protected Helper(CertRevocCaMBeanImpl certRevocCaMBeanImpl) {
            super(certRevocCaMBeanImpl);
            this.bean = certRevocCaMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 22: {
                    return "CrlDpDownloadTimeout";
                }
                case 24: {
                    return "CrlDpUrl";
                }
                case 25: {
                    return "CrlDpUrlUsage";
                }
                case 7: {
                    return "DistinguishedName";
                }
                case 10: {
                    return "MethodOrder";
                }
                case 15: {
                    return "OcspResponderCertIssuerName";
                }
                case 16: {
                    return "OcspResponderCertSerialNumber";
                }
                case 14: {
                    return "OcspResponderCertSubjectName";
                }
                case 13: {
                    return "OcspResponderExplicitTrustMethod";
                }
                case 11: {
                    return "OcspResponderUrl";
                }
                case 12: {
                    return "OcspResponderUrlUsage";
                }
                case 19: {
                    return "OcspResponseTimeout";
                }
                case 20: {
                    return "OcspTimeTolerance";
                }
                case 8: {
                    return "CheckingDisabled";
                }
                case 23: {
                    return "CrlDpBackgroundDownloadEnabled";
                }
                case 21: {
                    return "CrlDpEnabled";
                }
                case 9: {
                    return "FailOnUnknownRevocStatus";
                }
                case 17: {
                    return "OcspNonceEnabled";
                }
                case 18: {
                    return "OcspResponseCacheEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("CrlDpDownloadTimeout")) {
                return 22;
            }
            if (string.equals("CrlDpUrl")) {
                return 24;
            }
            if (string.equals("CrlDpUrlUsage")) {
                return 25;
            }
            if (string.equals("DistinguishedName")) {
                return 7;
            }
            if (string.equals("MethodOrder")) {
                return 10;
            }
            if (string.equals("OcspResponderCertIssuerName")) {
                return 15;
            }
            if (string.equals("OcspResponderCertSerialNumber")) {
                return 16;
            }
            if (string.equals("OcspResponderCertSubjectName")) {
                return 14;
            }
            if (string.equals("OcspResponderExplicitTrustMethod")) {
                return 13;
            }
            if (string.equals("OcspResponderUrl")) {
                return 11;
            }
            if (string.equals("OcspResponderUrlUsage")) {
                return 12;
            }
            if (string.equals("OcspResponseTimeout")) {
                return 19;
            }
            if (string.equals("OcspTimeTolerance")) {
                return 20;
            }
            if (string.equals("CheckingDisabled")) {
                return 8;
            }
            if (string.equals("CrlDpBackgroundDownloadEnabled")) {
                return 23;
            }
            if (string.equals("CrlDpEnabled")) {
                return 21;
            }
            if (string.equals("FailOnUnknownRevocStatus")) {
                return 9;
            }
            if (string.equals("OcspNonceEnabled")) {
                return 17;
            }
            if (string.equals("OcspResponseCacheEnabled")) {
                return 18;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isCrlDpDownloadTimeoutSet()) {
                    stringBuffer.append("CrlDpDownloadTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getCrlDpDownloadTimeout()));
                }
                if (this.bean.isCrlDpUrlSet()) {
                    stringBuffer.append("CrlDpUrl");
                    stringBuffer.append(String.valueOf(this.bean.getCrlDpUrl()));
                }
                if (this.bean.isCrlDpUrlUsageSet()) {
                    stringBuffer.append("CrlDpUrlUsage");
                    stringBuffer.append(String.valueOf(this.bean.getCrlDpUrlUsage()));
                }
                if (this.bean.isDistinguishedNameSet()) {
                    stringBuffer.append("DistinguishedName");
                    stringBuffer.append(String.valueOf(this.bean.getDistinguishedName()));
                }
                if (this.bean.isMethodOrderSet()) {
                    stringBuffer.append("MethodOrder");
                    stringBuffer.append(String.valueOf(this.bean.getMethodOrder()));
                }
                if (this.bean.isOcspResponderCertIssuerNameSet()) {
                    stringBuffer.append("OcspResponderCertIssuerName");
                    stringBuffer.append(String.valueOf(this.bean.getOcspResponderCertIssuerName()));
                }
                if (this.bean.isOcspResponderCertSerialNumberSet()) {
                    stringBuffer.append("OcspResponderCertSerialNumber");
                    stringBuffer.append(String.valueOf(this.bean.getOcspResponderCertSerialNumber()));
                }
                if (this.bean.isOcspResponderCertSubjectNameSet()) {
                    stringBuffer.append("OcspResponderCertSubjectName");
                    stringBuffer.append(String.valueOf(this.bean.getOcspResponderCertSubjectName()));
                }
                if (this.bean.isOcspResponderExplicitTrustMethodSet()) {
                    stringBuffer.append("OcspResponderExplicitTrustMethod");
                    stringBuffer.append(String.valueOf(this.bean.getOcspResponderExplicitTrustMethod()));
                }
                if (this.bean.isOcspResponderUrlSet()) {
                    stringBuffer.append("OcspResponderUrl");
                    stringBuffer.append(String.valueOf(this.bean.getOcspResponderUrl()));
                }
                if (this.bean.isOcspResponderUrlUsageSet()) {
                    stringBuffer.append("OcspResponderUrlUsage");
                    stringBuffer.append(String.valueOf(this.bean.getOcspResponderUrlUsage()));
                }
                if (this.bean.isOcspResponseTimeoutSet()) {
                    stringBuffer.append("OcspResponseTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getOcspResponseTimeout()));
                }
                if (this.bean.isOcspTimeToleranceSet()) {
                    stringBuffer.append("OcspTimeTolerance");
                    stringBuffer.append(String.valueOf(this.bean.getOcspTimeTolerance()));
                }
                if (this.bean.isCheckingDisabledSet()) {
                    stringBuffer.append("CheckingDisabled");
                    stringBuffer.append(String.valueOf(this.bean.isCheckingDisabled()));
                }
                if (this.bean.isCrlDpBackgroundDownloadEnabledSet()) {
                    stringBuffer.append("CrlDpBackgroundDownloadEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isCrlDpBackgroundDownloadEnabled()));
                }
                if (this.bean.isCrlDpEnabledSet()) {
                    stringBuffer.append("CrlDpEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isCrlDpEnabled()));
                }
                if (this.bean.isFailOnUnknownRevocStatusSet()) {
                    stringBuffer.append("FailOnUnknownRevocStatus");
                    stringBuffer.append(String.valueOf(this.bean.isFailOnUnknownRevocStatus()));
                }
                if (this.bean.isOcspNonceEnabledSet()) {
                    stringBuffer.append("OcspNonceEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isOcspNonceEnabled()));
                }
                if (this.bean.isOcspResponseCacheEnabledSet()) {
                    stringBuffer.append("OcspResponseCacheEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isOcspResponseCacheEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                CertRevocCaMBeanImpl certRevocCaMBeanImpl = (CertRevocCaMBeanImpl)abstractDescriptorBean;
                this.computeDiff("CrlDpDownloadTimeout", this.bean.getCrlDpDownloadTimeout(), certRevocCaMBeanImpl.getCrlDpDownloadTimeout(), true);
                this.computeDiff("CrlDpUrl", this.bean.getCrlDpUrl(), certRevocCaMBeanImpl.getCrlDpUrl(), true);
                this.computeDiff("CrlDpUrlUsage", this.bean.getCrlDpUrlUsage(), certRevocCaMBeanImpl.getCrlDpUrlUsage(), true);
                this.computeDiff("DistinguishedName", this.bean.getDistinguishedName(), certRevocCaMBeanImpl.getDistinguishedName(), true);
                this.computeDiff("MethodOrder", this.bean.getMethodOrder(), certRevocCaMBeanImpl.getMethodOrder(), true);
                this.computeDiff("OcspResponderCertIssuerName", this.bean.getOcspResponderCertIssuerName(), certRevocCaMBeanImpl.getOcspResponderCertIssuerName(), true);
                this.computeDiff("OcspResponderCertSerialNumber", this.bean.getOcspResponderCertSerialNumber(), certRevocCaMBeanImpl.getOcspResponderCertSerialNumber(), true);
                this.computeDiff("OcspResponderCertSubjectName", this.bean.getOcspResponderCertSubjectName(), certRevocCaMBeanImpl.getOcspResponderCertSubjectName(), true);
                this.computeDiff("OcspResponderExplicitTrustMethod", this.bean.getOcspResponderExplicitTrustMethod(), certRevocCaMBeanImpl.getOcspResponderExplicitTrustMethod(), true);
                this.computeDiff("OcspResponderUrl", this.bean.getOcspResponderUrl(), certRevocCaMBeanImpl.getOcspResponderUrl(), true);
                this.computeDiff("OcspResponderUrlUsage", this.bean.getOcspResponderUrlUsage(), certRevocCaMBeanImpl.getOcspResponderUrlUsage(), true);
                this.computeDiff("OcspResponseTimeout", this.bean.getOcspResponseTimeout(), certRevocCaMBeanImpl.getOcspResponseTimeout(), true);
                this.computeDiff("OcspTimeTolerance", this.bean.getOcspTimeTolerance(), certRevocCaMBeanImpl.getOcspTimeTolerance(), true);
                this.computeDiff("CheckingDisabled", this.bean.isCheckingDisabled(), certRevocCaMBeanImpl.isCheckingDisabled(), true);
                this.computeDiff("CrlDpBackgroundDownloadEnabled", this.bean.isCrlDpBackgroundDownloadEnabled(), certRevocCaMBeanImpl.isCrlDpBackgroundDownloadEnabled(), true);
                this.computeDiff("CrlDpEnabled", this.bean.isCrlDpEnabled(), certRevocCaMBeanImpl.isCrlDpEnabled(), true);
                this.computeDiff("FailOnUnknownRevocStatus", this.bean.isFailOnUnknownRevocStatus(), certRevocCaMBeanImpl.isFailOnUnknownRevocStatus(), true);
                this.computeDiff("OcspNonceEnabled", this.bean.isOcspNonceEnabled(), certRevocCaMBeanImpl.isOcspNonceEnabled(), true);
                this.computeDiff("OcspResponseCacheEnabled", this.bean.isOcspResponseCacheEnabled(), certRevocCaMBeanImpl.isOcspResponseCacheEnabled(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                CertRevocCaMBeanImpl certRevocCaMBeanImpl = (CertRevocCaMBeanImpl)beanUpdateEvent.getSourceBean();
                CertRevocCaMBeanImpl certRevocCaMBeanImpl2 = (CertRevocCaMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("CrlDpDownloadTimeout")) {
                    certRevocCaMBeanImpl.setCrlDpDownloadTimeout(certRevocCaMBeanImpl2.getCrlDpDownloadTimeout());
                    certRevocCaMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                } else if (string.equals("CrlDpUrl")) {
                    certRevocCaMBeanImpl.setCrlDpUrl(certRevocCaMBeanImpl2.getCrlDpUrl());
                    certRevocCaMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                } else if (string.equals("CrlDpUrlUsage")) {
                    certRevocCaMBeanImpl.setCrlDpUrlUsage(certRevocCaMBeanImpl2.getCrlDpUrlUsage());
                    certRevocCaMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                } else if (string.equals("DistinguishedName")) {
                    certRevocCaMBeanImpl.setDistinguishedName(certRevocCaMBeanImpl2.getDistinguishedName());
                    certRevocCaMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("MethodOrder")) {
                    certRevocCaMBeanImpl.setMethodOrder(certRevocCaMBeanImpl2.getMethodOrder());
                    certRevocCaMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("OcspResponderCertIssuerName")) {
                    certRevocCaMBeanImpl.setOcspResponderCertIssuerName(certRevocCaMBeanImpl2.getOcspResponderCertIssuerName());
                    certRevocCaMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("OcspResponderCertSerialNumber")) {
                    certRevocCaMBeanImpl.setOcspResponderCertSerialNumber(certRevocCaMBeanImpl2.getOcspResponderCertSerialNumber());
                    certRevocCaMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else if (string.equals("OcspResponderCertSubjectName")) {
                    certRevocCaMBeanImpl.setOcspResponderCertSubjectName(certRevocCaMBeanImpl2.getOcspResponderCertSubjectName());
                    certRevocCaMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("OcspResponderExplicitTrustMethod")) {
                    certRevocCaMBeanImpl.setOcspResponderExplicitTrustMethod(certRevocCaMBeanImpl2.getOcspResponderExplicitTrustMethod());
                    certRevocCaMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("OcspResponderUrl")) {
                    certRevocCaMBeanImpl.setOcspResponderUrl(certRevocCaMBeanImpl2.getOcspResponderUrl());
                    certRevocCaMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("OcspResponderUrlUsage")) {
                    certRevocCaMBeanImpl.setOcspResponderUrlUsage(certRevocCaMBeanImpl2.getOcspResponderUrlUsage());
                    certRevocCaMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("OcspResponseTimeout")) {
                    certRevocCaMBeanImpl.setOcspResponseTimeout(certRevocCaMBeanImpl2.getOcspResponseTimeout());
                    certRevocCaMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                } else if (string.equals("OcspTimeTolerance")) {
                    certRevocCaMBeanImpl.setOcspTimeTolerance(certRevocCaMBeanImpl2.getOcspTimeTolerance());
                    certRevocCaMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                } else if (string.equals("CheckingDisabled")) {
                    certRevocCaMBeanImpl.setCheckingDisabled(certRevocCaMBeanImpl2.isCheckingDisabled());
                    certRevocCaMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("CrlDpBackgroundDownloadEnabled")) {
                    certRevocCaMBeanImpl.setCrlDpBackgroundDownloadEnabled(certRevocCaMBeanImpl2.isCrlDpBackgroundDownloadEnabled());
                    certRevocCaMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                } else if (string.equals("CrlDpEnabled")) {
                    certRevocCaMBeanImpl.setCrlDpEnabled(certRevocCaMBeanImpl2.isCrlDpEnabled());
                    certRevocCaMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                } else if (string.equals("FailOnUnknownRevocStatus")) {
                    certRevocCaMBeanImpl.setFailOnUnknownRevocStatus(certRevocCaMBeanImpl2.isFailOnUnknownRevocStatus());
                    certRevocCaMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("OcspNonceEnabled")) {
                    certRevocCaMBeanImpl.setOcspNonceEnabled(certRevocCaMBeanImpl2.isOcspNonceEnabled());
                    certRevocCaMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else if (string.equals("OcspResponseCacheEnabled")) {
                    certRevocCaMBeanImpl.setOcspResponseCacheEnabled(certRevocCaMBeanImpl2.isOcspResponseCacheEnabled());
                    certRevocCaMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                CertRevocCaMBeanImpl certRevocCaMBeanImpl = (CertRevocCaMBeanImpl)abstractDescriptorBean;
                super.finishCopy(certRevocCaMBeanImpl, bl, list);
                if ((list == null || !list.contains("CrlDpDownloadTimeout")) && this.bean.isCrlDpDownloadTimeoutSet()) {
                    certRevocCaMBeanImpl.setCrlDpDownloadTimeout(this.bean.getCrlDpDownloadTimeout());
                }
                if ((list == null || !list.contains("CrlDpUrl")) && this.bean.isCrlDpUrlSet()) {
                    certRevocCaMBeanImpl.setCrlDpUrl(this.bean.getCrlDpUrl());
                }
                if ((list == null || !list.contains("CrlDpUrlUsage")) && this.bean.isCrlDpUrlUsageSet()) {
                    certRevocCaMBeanImpl.setCrlDpUrlUsage(this.bean.getCrlDpUrlUsage());
                }
                if ((list == null || !list.contains("DistinguishedName")) && this.bean.isDistinguishedNameSet()) {
                    certRevocCaMBeanImpl.setDistinguishedName(this.bean.getDistinguishedName());
                }
                if ((list == null || !list.contains("MethodOrder")) && this.bean.isMethodOrderSet()) {
                    certRevocCaMBeanImpl.setMethodOrder(this.bean.getMethodOrder());
                }
                if ((list == null || !list.contains("OcspResponderCertIssuerName")) && this.bean.isOcspResponderCertIssuerNameSet()) {
                    certRevocCaMBeanImpl.setOcspResponderCertIssuerName(this.bean.getOcspResponderCertIssuerName());
                }
                if ((list == null || !list.contains("OcspResponderCertSerialNumber")) && this.bean.isOcspResponderCertSerialNumberSet()) {
                    certRevocCaMBeanImpl.setOcspResponderCertSerialNumber(this.bean.getOcspResponderCertSerialNumber());
                }
                if ((list == null || !list.contains("OcspResponderCertSubjectName")) && this.bean.isOcspResponderCertSubjectNameSet()) {
                    certRevocCaMBeanImpl.setOcspResponderCertSubjectName(this.bean.getOcspResponderCertSubjectName());
                }
                if ((list == null || !list.contains("OcspResponderExplicitTrustMethod")) && this.bean.isOcspResponderExplicitTrustMethodSet()) {
                    certRevocCaMBeanImpl.setOcspResponderExplicitTrustMethod(this.bean.getOcspResponderExplicitTrustMethod());
                }
                if ((list == null || !list.contains("OcspResponderUrl")) && this.bean.isOcspResponderUrlSet()) {
                    certRevocCaMBeanImpl.setOcspResponderUrl(this.bean.getOcspResponderUrl());
                }
                if ((list == null || !list.contains("OcspResponderUrlUsage")) && this.bean.isOcspResponderUrlUsageSet()) {
                    certRevocCaMBeanImpl.setOcspResponderUrlUsage(this.bean.getOcspResponderUrlUsage());
                }
                if ((list == null || !list.contains("OcspResponseTimeout")) && this.bean.isOcspResponseTimeoutSet()) {
                    certRevocCaMBeanImpl.setOcspResponseTimeout(this.bean.getOcspResponseTimeout());
                }
                if ((list == null || !list.contains("OcspTimeTolerance")) && this.bean.isOcspTimeToleranceSet()) {
                    certRevocCaMBeanImpl.setOcspTimeTolerance(this.bean.getOcspTimeTolerance());
                }
                if ((list == null || !list.contains("CheckingDisabled")) && this.bean.isCheckingDisabledSet()) {
                    certRevocCaMBeanImpl.setCheckingDisabled(this.bean.isCheckingDisabled());
                }
                if ((list == null || !list.contains("CrlDpBackgroundDownloadEnabled")) && this.bean.isCrlDpBackgroundDownloadEnabledSet()) {
                    certRevocCaMBeanImpl.setCrlDpBackgroundDownloadEnabled(this.bean.isCrlDpBackgroundDownloadEnabled());
                }
                if ((list == null || !list.contains("CrlDpEnabled")) && this.bean.isCrlDpEnabledSet()) {
                    certRevocCaMBeanImpl.setCrlDpEnabled(this.bean.isCrlDpEnabled());
                }
                if ((list == null || !list.contains("FailOnUnknownRevocStatus")) && this.bean.isFailOnUnknownRevocStatusSet()) {
                    certRevocCaMBeanImpl.setFailOnUnknownRevocStatus(this.bean.isFailOnUnknownRevocStatus());
                }
                if ((list == null || !list.contains("OcspNonceEnabled")) && this.bean.isOcspNonceEnabledSet()) {
                    certRevocCaMBeanImpl.setOcspNonceEnabled(this.bean.isOcspNonceEnabled());
                }
                if ((list == null || !list.contains("OcspResponseCacheEnabled")) && this.bean.isOcspResponseCacheEnabledSet()) {
                    certRevocCaMBeanImpl.setOcspResponseCacheEnabled(this.bean.isOcspResponseCacheEnabled());
                }
                return certRevocCaMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

