/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanRemoveRejectedException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorValidateException;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.configuration.CertRevocCaMBean;
import weblogic.management.configuration.CertRevocCaMBeanImpl;
import weblogic.management.configuration.CertRevocMBean;
import weblogic.management.configuration.CertRevocValidator;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;

public class CertRevocMBeanImpl
extends ConfigurationMBeanImpl
implements CertRevocMBean,
Serializable {
    private CertRevocCaMBean[] _CertRevocCas;
    private boolean _CheckingEnabled;
    private int _CrlCacheRefreshPeriodPercent;
    private String _CrlCacheType;
    private String _CrlCacheTypeLdapHostname;
    private int _CrlCacheTypeLdapPort;
    private int _CrlCacheTypeLdapSearchTimeout;
    private boolean _CrlDpBackgroundDownloadEnabled;
    private long _CrlDpDownloadTimeout;
    private boolean _CrlDpEnabled;
    private boolean _FailOnUnknownRevocStatus;
    private String _MethodOrder;
    private boolean _OcspNonceEnabled;
    private int _OcspResponseCacheCapacity;
    private boolean _OcspResponseCacheEnabled;
    private int _OcspResponseCacheRefreshPeriodPercent;
    private long _OcspResponseTimeout;
    private int _OcspTimeTolerance;
    private static SchemaHelper2 _schemaHelper;

    public CertRevocMBeanImpl() {
        this._initializeProperty(-1);
    }

    public CertRevocMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public boolean isCheckingEnabled() {
        return this._CheckingEnabled;
    }

    public boolean isCheckingEnabledSet() {
        return this._isSet(7);
    }

    public void setCheckingEnabled(boolean bl) {
        boolean bl2 = this._CheckingEnabled;
        this._CheckingEnabled = bl;
        this._postSet(7, bl2, bl);
    }

    public boolean isFailOnUnknownRevocStatus() {
        return this._FailOnUnknownRevocStatus;
    }

    public boolean isFailOnUnknownRevocStatusSet() {
        return this._isSet(8);
    }

    public void setFailOnUnknownRevocStatus(boolean bl) {
        boolean bl2 = this._FailOnUnknownRevocStatus;
        this._FailOnUnknownRevocStatus = bl;
        this._postSet(8, bl2, bl);
    }

    public String getMethodOrder() {
        return this._MethodOrder;
    }

    public boolean isMethodOrderSet() {
        return this._isSet(9);
    }

    public void setMethodOrder(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{CertRevocMBean.METHOD_OCSP, CertRevocMBean.METHOD_CRL, CertRevocMBean.METHOD_OCSP_THEN_CRL, CertRevocMBean.METHOD_CRL_THEN_OCSP};
        string = LegalChecks.checkInEnum((String)"MethodOrder", (String)string, (String[])stringArray);
        String string2 = this._MethodOrder;
        this._MethodOrder = string;
        this._postSet(9, string2, string);
    }

    public boolean isOcspNonceEnabled() {
        return this._OcspNonceEnabled;
    }

    public boolean isOcspNonceEnabledSet() {
        return this._isSet(10);
    }

    public void setOcspNonceEnabled(boolean bl) {
        boolean bl2 = this._OcspNonceEnabled;
        this._OcspNonceEnabled = bl;
        this._postSet(10, bl2, bl);
    }

    public boolean isOcspResponseCacheEnabled() {
        return this._OcspResponseCacheEnabled;
    }

    public boolean isOcspResponseCacheEnabledSet() {
        return this._isSet(11);
    }

    public void setOcspResponseCacheEnabled(boolean bl) {
        boolean bl2 = this._OcspResponseCacheEnabled;
        this._OcspResponseCacheEnabled = bl;
        this._postSet(11, bl2, bl);
    }

    public int getOcspResponseCacheCapacity() {
        return this._OcspResponseCacheCapacity;
    }

    public boolean isOcspResponseCacheCapacitySet() {
        return this._isSet(12);
    }

    public void setOcspResponseCacheCapacity(int n) {
        LegalChecks.checkInRange((String)"OcspResponseCacheCapacity", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this._OcspResponseCacheCapacity;
        this._OcspResponseCacheCapacity = n;
        this._postSet(12, n2, n);
    }

    public int getOcspResponseCacheRefreshPeriodPercent() {
        return this._OcspResponseCacheRefreshPeriodPercent;
    }

    public boolean isOcspResponseCacheRefreshPeriodPercentSet() {
        return this._isSet(13);
    }

    public void setOcspResponseCacheRefreshPeriodPercent(int n) {
        LegalChecks.checkInRange((String)"OcspResponseCacheRefreshPeriodPercent", (long)n, (long)1L, (long)100L);
        int n2 = this._OcspResponseCacheRefreshPeriodPercent;
        this._OcspResponseCacheRefreshPeriodPercent = n;
        this._postSet(13, n2, n);
    }

    public long getOcspResponseTimeout() {
        return this._OcspResponseTimeout;
    }

    public boolean isOcspResponseTimeoutSet() {
        return this._isSet(14);
    }

    public void setOcspResponseTimeout(long l) {
        LegalChecks.checkInRange((String)"OcspResponseTimeout", (long)l, (long)1L, (long)300L);
        long l2 = this._OcspResponseTimeout;
        this._OcspResponseTimeout = l;
        this._postSet(14, l2, l);
    }

    public int getOcspTimeTolerance() {
        return this._OcspTimeTolerance;
    }

    public boolean isOcspTimeToleranceSet() {
        return this._isSet(15);
    }

    public void setOcspTimeTolerance(int n) {
        LegalChecks.checkInRange((String)"OcspTimeTolerance", (long)n, (long)0L, (long)900L);
        int n2 = this._OcspTimeTolerance;
        this._OcspTimeTolerance = n;
        this._postSet(15, n2, n);
    }

    public String getCrlCacheType() {
        return this._CrlCacheType;
    }

    public boolean isCrlCacheTypeSet() {
        return this._isSet(16);
    }

    public void setCrlCacheType(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{CertRevocMBean.CRL_CACHE_TYPE_FILE, CertRevocMBean.CRL_CACHE_TYPE_LDAP};
        string = LegalChecks.checkInEnum((String)"CrlCacheType", (String)string, (String[])stringArray);
        String string2 = this._CrlCacheType;
        this._CrlCacheType = string;
        this._postSet(16, string2, string);
    }

    public String getCrlCacheTypeLdapHostname() {
        return this._CrlCacheTypeLdapHostname;
    }

    public boolean isCrlCacheTypeLdapHostnameSet() {
        return this._isSet(17);
    }

    public void setCrlCacheTypeLdapHostname(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._CrlCacheTypeLdapHostname;
        this._CrlCacheTypeLdapHostname = string;
        this._postSet(17, string2, string);
    }

    public int getCrlCacheTypeLdapPort() {
        return this._CrlCacheTypeLdapPort;
    }

    public boolean isCrlCacheTypeLdapPortSet() {
        return this._isSet(18);
    }

    public void setCrlCacheTypeLdapPort(int n) {
        CertRevocValidator.validatePort(n);
        int n2 = this._CrlCacheTypeLdapPort;
        this._CrlCacheTypeLdapPort = n;
        this._postSet(18, n2, n);
    }

    public int getCrlCacheTypeLdapSearchTimeout() {
        return this._CrlCacheTypeLdapSearchTimeout;
    }

    public boolean isCrlCacheTypeLdapSearchTimeoutSet() {
        return this._isSet(19);
    }

    public void setCrlCacheTypeLdapSearchTimeout(int n) {
        LegalChecks.checkInRange((String)"CrlCacheTypeLdapSearchTimeout", (long)n, (long)1L, (long)300L);
        int n2 = this._CrlCacheTypeLdapSearchTimeout;
        this._CrlCacheTypeLdapSearchTimeout = n;
        this._postSet(19, n2, n);
    }

    public int getCrlCacheRefreshPeriodPercent() {
        return this._CrlCacheRefreshPeriodPercent;
    }

    public boolean isCrlCacheRefreshPeriodPercentSet() {
        return this._isSet(20);
    }

    public void setCrlCacheRefreshPeriodPercent(int n) {
        LegalChecks.checkInRange((String)"CrlCacheRefreshPeriodPercent", (long)n, (long)1L, (long)100L);
        int n2 = this._CrlCacheRefreshPeriodPercent;
        this._CrlCacheRefreshPeriodPercent = n;
        this._postSet(20, n2, n);
    }

    public boolean isCrlDpEnabled() {
        return this._CrlDpEnabled;
    }

    public boolean isCrlDpEnabledSet() {
        return this._isSet(21);
    }

    public void setCrlDpEnabled(boolean bl) {
        boolean bl2 = this._CrlDpEnabled;
        this._CrlDpEnabled = bl;
        this._postSet(21, bl2, bl);
    }

    public long getCrlDpDownloadTimeout() {
        return this._CrlDpDownloadTimeout;
    }

    public boolean isCrlDpDownloadTimeoutSet() {
        return this._isSet(22);
    }

    public void setCrlDpDownloadTimeout(long l) {
        LegalChecks.checkInRange((String)"CrlDpDownloadTimeout", (long)l, (long)1L, (long)300L);
        long l2 = this._CrlDpDownloadTimeout;
        this._CrlDpDownloadTimeout = l;
        this._postSet(22, l2, l);
    }

    public boolean isCrlDpBackgroundDownloadEnabled() {
        return this._CrlDpBackgroundDownloadEnabled;
    }

    public boolean isCrlDpBackgroundDownloadEnabledSet() {
        return this._isSet(23);
    }

    public void setCrlDpBackgroundDownloadEnabled(boolean bl) {
        boolean bl2 = this._CrlDpBackgroundDownloadEnabled;
        this._CrlDpBackgroundDownloadEnabled = bl;
        this._postSet(23, bl2, bl);
    }

    public void addCertRevocCa(CertRevocCaMBean certRevocCaMBean) {
        this._getHelper()._ensureNonNull((Object)certRevocCaMBean);
        if (!((AbstractDescriptorBean)certRevocCaMBean).isChildProperty((DescriptorBean)this, 24)) {
            CertRevocCaMBean[] certRevocCaMBeanArray = this._isSet(24) ? (CertRevocCaMBean[])this._getHelper()._extendArray((Object)this.getCertRevocCas(), CertRevocCaMBean.class, (Object)certRevocCaMBean) : new CertRevocCaMBean[]{certRevocCaMBean};
            try {
                this.setCertRevocCas(certRevocCaMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public CertRevocCaMBean[] getCertRevocCas() {
        return this._CertRevocCas;
    }

    public boolean isCertRevocCasSet() {
        return this._isSet(24);
    }

    public void removeCertRevocCa(CertRevocCaMBean certRevocCaMBean) {
        this.destroyCertRevocCa(certRevocCaMBean);
    }

    public void setCertRevocCas(CertRevocCaMBean[] certRevocCaMBeanArray) throws InvalidAttributeValueException {
        certRevocCaMBeanArray = certRevocCaMBeanArray == null ? new CertRevocCaMBeanImpl[]{} : certRevocCaMBeanArray;
        for (int i = 0; i < certRevocCaMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)certRevocCaMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 24)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, false);
            this._postCreate(abstractDescriptorBean);
        }
        CertRevocCaMBean[] certRevocCaMBeanArray2 = this._CertRevocCas;
        this._CertRevocCas = certRevocCaMBeanArray;
        this._postSet(24, certRevocCaMBeanArray2, certRevocCaMBeanArray);
    }

    public CertRevocCaMBean createCertRevocCa(String string) {
        CertRevocCaMBeanImpl certRevocCaMBeanImpl = new CertRevocCaMBeanImpl(this, -1);
        try {
            certRevocCaMBeanImpl.setName(string);
            this.addCertRevocCa(certRevocCaMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return certRevocCaMBeanImpl;
    }

    public void destroyCertRevocCa(CertRevocCaMBean certRevocCaMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(certRevocCaMBean, 24);
                CertRevocCaMBean[] certRevocCaMBeanArray = this.getCertRevocCas();
                CertRevocCaMBean[] certRevocCaMBeanArray2 = (CertRevocCaMBean[])this._getHelper()._removeElement((Object)certRevocCaMBeanArray, CertRevocCaMBean.class, (Object)certRevocCaMBean);
                if (certRevocCaMBeanArray.length == certRevocCaMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)certRevocCaMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)certRevocCaMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setCertRevocCas(certRevocCaMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public CertRevocCaMBean lookupCertRevocCa(String string) {
        for (CertRevocCaMBeanImpl certRevocCaMBeanImpl : Arrays.asList((Object[])this._CertRevocCas)) {
            String string2 = string;
            if (!certRevocCaMBeanImpl.getName().equals(string2)) continue;
            return certRevocCaMBeanImpl;
        }
        return null;
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
        CertRevocValidator.validateCertRevoc(this);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 24;
        }
        try {
            switch (n) {
                case 24: {
                    this._CertRevocCas = new CertRevocCaMBean[0];
                    if (bl) break;
                }
                case 20: {
                    this._CrlCacheRefreshPeriodPercent = CertRevocMBean.DEFAULT_CRL_CACHE_REFRESH_PERIOD_PERCENT;
                    if (bl) break;
                }
                case 16: {
                    this._CrlCacheType = CertRevocMBean.DEFAULT_CRL_CACHE_TYPE;
                    if (bl) break;
                }
                case 17: {
                    this._CrlCacheTypeLdapHostname = CertRevocMBean.DEFAULT_CRL_CACHE_TYPE_LDAP_HOST_NAME;
                    if (bl) break;
                }
                case 18: {
                    this._CrlCacheTypeLdapPort = CertRevocMBean.DEFAULT_CRL_CACHE_TYPE_LDAP_PORT;
                    if (bl) break;
                }
                case 19: {
                    this._CrlCacheTypeLdapSearchTimeout = CertRevocMBean.DEFAULT_CRL_CACHE_TYPE_LDAP_SEARCH_TIMEOUT;
                    if (bl) break;
                }
                case 22: {
                    this._CrlDpDownloadTimeout = CertRevocMBean.DEFAULT_CRL_DP_DOWNLOAD_TIMEOUT;
                    if (bl) break;
                }
                case 9: {
                    this._MethodOrder = CertRevocMBean.DEFAULT_METHOD_ORDER;
                    if (bl) break;
                }
                case 12: {
                    this._OcspResponseCacheCapacity = CertRevocMBean.DEFAULT_OCSP_RESPONSE_CACHE_CAPACITY;
                    if (bl) break;
                }
                case 13: {
                    this._OcspResponseCacheRefreshPeriodPercent = CertRevocMBean.DEFAULT_OCSP_RESPONSE_CACHE_REFRESH_PERIOD_PERCENT;
                    if (bl) break;
                }
                case 14: {
                    this._OcspResponseTimeout = CertRevocMBean.DEFAULT_OCSP_RESPONSE_TIMEOUT;
                    if (bl) break;
                }
                case 15: {
                    this._OcspTimeTolerance = CertRevocMBean.DEFAULT_OCSP_TIME_TOLERANCE;
                    if (bl) break;
                }
                case 7: {
                    this._CheckingEnabled = CertRevocMBean.DEFAULT_CHECKING_ENABLED;
                    if (bl) break;
                }
                case 23: {
                    this._CrlDpBackgroundDownloadEnabled = CertRevocMBean.DEFAULT_CRL_DP_BACKGROUND_DOWNLOAD_ENABLED;
                    if (bl) break;
                }
                case 21: {
                    this._CrlDpEnabled = CertRevocMBean.DEFAULT_CRL_DP_ENABLED;
                    if (bl) break;
                }
                case 8: {
                    this._FailOnUnknownRevocStatus = CertRevocMBean.DEFAULT_FAIL_ON_UNKNOWN_REVOC_STATUS;
                    if (bl) break;
                }
                case 10: {
                    this._OcspNonceEnabled = CertRevocMBean.DEFAULT_OCSP_NONCE_ENABLED;
                    if (bl) break;
                }
                case 11: {
                    this._OcspResponseCacheEnabled = CertRevocMBean.DEFAULT_OCSP_RESPONSE_CACHE_ENABLED;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "CertRevoc";
    }

    public void putValue(String string, Object object) {
        if (string.equals("CertRevocCas")) {
            CertRevocCaMBean[] certRevocCaMBeanArray = this._CertRevocCas;
            this._CertRevocCas = (CertRevocCaMBean[])object;
            this._postSet(24, certRevocCaMBeanArray, this._CertRevocCas);
            return;
        }
        if (string.equals("CheckingEnabled")) {
            boolean bl = this._CheckingEnabled;
            this._CheckingEnabled = (Boolean)object;
            this._postSet(7, bl, this._CheckingEnabled);
            return;
        }
        if (string.equals("CrlCacheRefreshPeriodPercent")) {
            int n = this._CrlCacheRefreshPeriodPercent;
            this._CrlCacheRefreshPeriodPercent = (Integer)object;
            this._postSet(20, n, this._CrlCacheRefreshPeriodPercent);
            return;
        }
        if (string.equals("CrlCacheType")) {
            String string2 = this._CrlCacheType;
            this._CrlCacheType = (String)object;
            this._postSet(16, string2, this._CrlCacheType);
            return;
        }
        if (string.equals("CrlCacheTypeLdapHostname")) {
            String string3 = this._CrlCacheTypeLdapHostname;
            this._CrlCacheTypeLdapHostname = (String)object;
            this._postSet(17, string3, this._CrlCacheTypeLdapHostname);
            return;
        }
        if (string.equals("CrlCacheTypeLdapPort")) {
            int n = this._CrlCacheTypeLdapPort;
            this._CrlCacheTypeLdapPort = (Integer)object;
            this._postSet(18, n, this._CrlCacheTypeLdapPort);
            return;
        }
        if (string.equals("CrlCacheTypeLdapSearchTimeout")) {
            int n = this._CrlCacheTypeLdapSearchTimeout;
            this._CrlCacheTypeLdapSearchTimeout = (Integer)object;
            this._postSet(19, n, this._CrlCacheTypeLdapSearchTimeout);
            return;
        }
        if (string.equals("CrlDpBackgroundDownloadEnabled")) {
            boolean bl = this._CrlDpBackgroundDownloadEnabled;
            this._CrlDpBackgroundDownloadEnabled = (Boolean)object;
            this._postSet(23, bl, this._CrlDpBackgroundDownloadEnabled);
            return;
        }
        if (string.equals("CrlDpDownloadTimeout")) {
            long l = this._CrlDpDownloadTimeout;
            this._CrlDpDownloadTimeout = (Long)object;
            this._postSet(22, l, this._CrlDpDownloadTimeout);
            return;
        }
        if (string.equals("CrlDpEnabled")) {
            boolean bl = this._CrlDpEnabled;
            this._CrlDpEnabled = (Boolean)object;
            this._postSet(21, bl, this._CrlDpEnabled);
            return;
        }
        if (string.equals("FailOnUnknownRevocStatus")) {
            boolean bl = this._FailOnUnknownRevocStatus;
            this._FailOnUnknownRevocStatus = (Boolean)object;
            this._postSet(8, bl, this._FailOnUnknownRevocStatus);
            return;
        }
        if (string.equals("MethodOrder")) {
            String string4 = this._MethodOrder;
            this._MethodOrder = (String)object;
            this._postSet(9, string4, this._MethodOrder);
            return;
        }
        if (string.equals("OcspNonceEnabled")) {
            boolean bl = this._OcspNonceEnabled;
            this._OcspNonceEnabled = (Boolean)object;
            this._postSet(10, bl, this._OcspNonceEnabled);
            return;
        }
        if (string.equals("OcspResponseCacheCapacity")) {
            int n = this._OcspResponseCacheCapacity;
            this._OcspResponseCacheCapacity = (Integer)object;
            this._postSet(12, n, this._OcspResponseCacheCapacity);
            return;
        }
        if (string.equals("OcspResponseCacheEnabled")) {
            boolean bl = this._OcspResponseCacheEnabled;
            this._OcspResponseCacheEnabled = (Boolean)object;
            this._postSet(11, bl, this._OcspResponseCacheEnabled);
            return;
        }
        if (string.equals("OcspResponseCacheRefreshPeriodPercent")) {
            int n = this._OcspResponseCacheRefreshPeriodPercent;
            this._OcspResponseCacheRefreshPeriodPercent = (Integer)object;
            this._postSet(13, n, this._OcspResponseCacheRefreshPeriodPercent);
            return;
        }
        if (string.equals("OcspResponseTimeout")) {
            long l = this._OcspResponseTimeout;
            this._OcspResponseTimeout = (Long)object;
            this._postSet(14, l, this._OcspResponseTimeout);
            return;
        }
        if (string.equals("OcspTimeTolerance")) {
            int n = this._OcspTimeTolerance;
            this._OcspTimeTolerance = (Integer)object;
            this._postSet(15, n, this._OcspTimeTolerance);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("CertRevocCas")) {
            return this._CertRevocCas;
        }
        if (string.equals("CheckingEnabled")) {
            return new Boolean(this._CheckingEnabled);
        }
        if (string.equals("CrlCacheRefreshPeriodPercent")) {
            return new Integer(this._CrlCacheRefreshPeriodPercent);
        }
        if (string.equals("CrlCacheType")) {
            return this._CrlCacheType;
        }
        if (string.equals("CrlCacheTypeLdapHostname")) {
            return this._CrlCacheTypeLdapHostname;
        }
        if (string.equals("CrlCacheTypeLdapPort")) {
            return new Integer(this._CrlCacheTypeLdapPort);
        }
        if (string.equals("CrlCacheTypeLdapSearchTimeout")) {
            return new Integer(this._CrlCacheTypeLdapSearchTimeout);
        }
        if (string.equals("CrlDpBackgroundDownloadEnabled")) {
            return new Boolean(this._CrlDpBackgroundDownloadEnabled);
        }
        if (string.equals("CrlDpDownloadTimeout")) {
            return new Long(this._CrlDpDownloadTimeout);
        }
        if (string.equals("CrlDpEnabled")) {
            return new Boolean(this._CrlDpEnabled);
        }
        if (string.equals("FailOnUnknownRevocStatus")) {
            return new Boolean(this._FailOnUnknownRevocStatus);
        }
        if (string.equals("MethodOrder")) {
            return this._MethodOrder;
        }
        if (string.equals("OcspNonceEnabled")) {
            return new Boolean(this._OcspNonceEnabled);
        }
        if (string.equals("OcspResponseCacheCapacity")) {
            return new Integer(this._OcspResponseCacheCapacity);
        }
        if (string.equals("OcspResponseCacheEnabled")) {
            return new Boolean(this._OcspResponseCacheEnabled);
        }
        if (string.equals("OcspResponseCacheRefreshPeriodPercent")) {
            return new Integer(this._OcspResponseCacheRefreshPeriodPercent);
        }
        if (string.equals("OcspResponseTimeout")) {
            return new Long(this._OcspResponseTimeout);
        }
        if (string.equals("OcspTimeTolerance")) {
            return new Integer(this._OcspTimeTolerance);
        }
        return super.getValue(string);
    }

    public static void validateGeneration() {
        String[] stringArray;
        try {
            stringArray = new String[]{CertRevocMBean.CRL_CACHE_TYPE_FILE, CertRevocMBean.CRL_CACHE_TYPE_LDAP};
            LegalChecks.checkInEnum((String)"CrlCacheType", (String)CertRevocMBean.DEFAULT_CRL_CACHE_TYPE, (String[])stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("Default value for a property  should be one of the legal values. Refer annotation legalValues on property CrlCacheType in CertRevocMBean" + illegalArgumentException.getMessage());
        }
        try {
            stringArray = new String[]{CertRevocMBean.METHOD_OCSP, CertRevocMBean.METHOD_CRL, CertRevocMBean.METHOD_OCSP_THEN_CRL, CertRevocMBean.METHOD_CRL_THEN_OCSP};
            LegalChecks.checkInEnum((String)"MethodOrder", (String)CertRevocMBean.DEFAULT_METHOD_ORDER, (String[])stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("Default value for a property  should be one of the legal values. Refer annotation legalValues on property MethodOrder in CertRevocMBean" + illegalArgumentException.getMessage());
        }
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 13: {
                    if (!string.equals("cert-revoc-ca")) break;
                    return 24;
                }
                case 32: {
                    if (!string.equals("crl-cache-refresh-period-percent")) break;
                    return 20;
                }
                case 14: {
                    if (string.equals("crl-cache-type")) {
                        return 16;
                    }
                    if (!string.equals("crl-dp-enabled")) break;
                    return 21;
                }
                case 28: {
                    if (string.equals("crl-cache-type-ldap-hostname")) {
                        return 17;
                    }
                    if (string.equals("ocsp-response-cache-capacity")) {
                        return 12;
                    }
                    if (!string.equals("fail-on-unknown-revoc-status")) break;
                    return 8;
                }
                case 24: {
                    if (!string.equals("crl-cache-type-ldap-port")) break;
                    return 18;
                }
                case 34: {
                    if (string.equals("crl-cache-type-ldap-search-timeout")) {
                        return 19;
                    }
                    if (!string.equals("crl-dp-background-download-enabled")) break;
                    return 23;
                }
                case 23: {
                    if (!string.equals("crl-dp-download-timeout")) break;
                    return 22;
                }
                case 12: {
                    if (!string.equals("method-order")) break;
                    return 9;
                }
                case 42: {
                    if (!string.equals("ocsp-response-cache-refresh-period-percent")) break;
                    return 13;
                }
                case 21: {
                    if (!string.equals("ocsp-response-timeout")) break;
                    return 14;
                }
                case 19: {
                    if (!string.equals("ocsp-time-tolerance")) break;
                    return 15;
                }
                case 16: {
                    if (!string.equals("checking-enabled")) break;
                    return 7;
                }
                case 18: {
                    if (!string.equals("ocsp-nonce-enabled")) break;
                    return 10;
                }
                case 27: {
                    if (!string.equals("ocsp-response-cache-enabled")) break;
                    return 11;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                case 24: {
                    return new CertRevocCaMBeanImpl.SchemaHelper2();
                }
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 24: {
                    return "cert-revoc-ca";
                }
                case 20: {
                    return "crl-cache-refresh-period-percent";
                }
                case 16: {
                    return "crl-cache-type";
                }
                case 17: {
                    return "crl-cache-type-ldap-hostname";
                }
                case 18: {
                    return "crl-cache-type-ldap-port";
                }
                case 19: {
                    return "crl-cache-type-ldap-search-timeout";
                }
                case 22: {
                    return "crl-dp-download-timeout";
                }
                case 9: {
                    return "method-order";
                }
                case 12: {
                    return "ocsp-response-cache-capacity";
                }
                case 13: {
                    return "ocsp-response-cache-refresh-period-percent";
                }
                case 14: {
                    return "ocsp-response-timeout";
                }
                case 15: {
                    return "ocsp-time-tolerance";
                }
                case 7: {
                    return "checking-enabled";
                }
                case 23: {
                    return "crl-dp-background-download-enabled";
                }
                case 21: {
                    return "crl-dp-enabled";
                }
                case 8: {
                    return "fail-on-unknown-revoc-status";
                }
                case 10: {
                    return "ocsp-nonce-enabled";
                }
                case 11: {
                    return "ocsp-response-cache-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 24: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                case 24: {
                    return true;
                }
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private CertRevocMBeanImpl bean;

        protected Helper(CertRevocMBeanImpl certRevocMBeanImpl) {
            super(certRevocMBeanImpl);
            this.bean = certRevocMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 24: {
                    return "CertRevocCas";
                }
                case 20: {
                    return "CrlCacheRefreshPeriodPercent";
                }
                case 16: {
                    return "CrlCacheType";
                }
                case 17: {
                    return "CrlCacheTypeLdapHostname";
                }
                case 18: {
                    return "CrlCacheTypeLdapPort";
                }
                case 19: {
                    return "CrlCacheTypeLdapSearchTimeout";
                }
                case 22: {
                    return "CrlDpDownloadTimeout";
                }
                case 9: {
                    return "MethodOrder";
                }
                case 12: {
                    return "OcspResponseCacheCapacity";
                }
                case 13: {
                    return "OcspResponseCacheRefreshPeriodPercent";
                }
                case 14: {
                    return "OcspResponseTimeout";
                }
                case 15: {
                    return "OcspTimeTolerance";
                }
                case 7: {
                    return "CheckingEnabled";
                }
                case 23: {
                    return "CrlDpBackgroundDownloadEnabled";
                }
                case 21: {
                    return "CrlDpEnabled";
                }
                case 8: {
                    return "FailOnUnknownRevocStatus";
                }
                case 10: {
                    return "OcspNonceEnabled";
                }
                case 11: {
                    return "OcspResponseCacheEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("CertRevocCas")) {
                return 24;
            }
            if (string.equals("CrlCacheRefreshPeriodPercent")) {
                return 20;
            }
            if (string.equals("CrlCacheType")) {
                return 16;
            }
            if (string.equals("CrlCacheTypeLdapHostname")) {
                return 17;
            }
            if (string.equals("CrlCacheTypeLdapPort")) {
                return 18;
            }
            if (string.equals("CrlCacheTypeLdapSearchTimeout")) {
                return 19;
            }
            if (string.equals("CrlDpDownloadTimeout")) {
                return 22;
            }
            if (string.equals("MethodOrder")) {
                return 9;
            }
            if (string.equals("OcspResponseCacheCapacity")) {
                return 12;
            }
            if (string.equals("OcspResponseCacheRefreshPeriodPercent")) {
                return 13;
            }
            if (string.equals("OcspResponseTimeout")) {
                return 14;
            }
            if (string.equals("OcspTimeTolerance")) {
                return 15;
            }
            if (string.equals("CheckingEnabled")) {
                return 7;
            }
            if (string.equals("CrlDpBackgroundDownloadEnabled")) {
                return 23;
            }
            if (string.equals("CrlDpEnabled")) {
                return 21;
            }
            if (string.equals("FailOnUnknownRevocStatus")) {
                return 8;
            }
            if (string.equals("OcspNonceEnabled")) {
                return 10;
            }
            if (string.equals("OcspResponseCacheEnabled")) {
                return 11;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList<ArrayIterator> arrayList = new ArrayList<ArrayIterator>();
            arrayList.add(new ArrayIterator((Object[])this.bean.getCertRevocCas()));
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                l2 = 0L;
                for (int i = 0; i < this.bean.getCertRevocCas().length; ++i) {
                    l2 ^= this.computeChildHashValue(this.bean.getCertRevocCas()[i]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isCrlCacheRefreshPeriodPercentSet()) {
                    stringBuffer.append("CrlCacheRefreshPeriodPercent");
                    stringBuffer.append(String.valueOf(this.bean.getCrlCacheRefreshPeriodPercent()));
                }
                if (this.bean.isCrlCacheTypeSet()) {
                    stringBuffer.append("CrlCacheType");
                    stringBuffer.append(String.valueOf(this.bean.getCrlCacheType()));
                }
                if (this.bean.isCrlCacheTypeLdapHostnameSet()) {
                    stringBuffer.append("CrlCacheTypeLdapHostname");
                    stringBuffer.append(String.valueOf(this.bean.getCrlCacheTypeLdapHostname()));
                }
                if (this.bean.isCrlCacheTypeLdapPortSet()) {
                    stringBuffer.append("CrlCacheTypeLdapPort");
                    stringBuffer.append(String.valueOf(this.bean.getCrlCacheTypeLdapPort()));
                }
                if (this.bean.isCrlCacheTypeLdapSearchTimeoutSet()) {
                    stringBuffer.append("CrlCacheTypeLdapSearchTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getCrlCacheTypeLdapSearchTimeout()));
                }
                if (this.bean.isCrlDpDownloadTimeoutSet()) {
                    stringBuffer.append("CrlDpDownloadTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getCrlDpDownloadTimeout()));
                }
                if (this.bean.isMethodOrderSet()) {
                    stringBuffer.append("MethodOrder");
                    stringBuffer.append(String.valueOf(this.bean.getMethodOrder()));
                }
                if (this.bean.isOcspResponseCacheCapacitySet()) {
                    stringBuffer.append("OcspResponseCacheCapacity");
                    stringBuffer.append(String.valueOf(this.bean.getOcspResponseCacheCapacity()));
                }
                if (this.bean.isOcspResponseCacheRefreshPeriodPercentSet()) {
                    stringBuffer.append("OcspResponseCacheRefreshPeriodPercent");
                    stringBuffer.append(String.valueOf(this.bean.getOcspResponseCacheRefreshPeriodPercent()));
                }
                if (this.bean.isOcspResponseTimeoutSet()) {
                    stringBuffer.append("OcspResponseTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getOcspResponseTimeout()));
                }
                if (this.bean.isOcspTimeToleranceSet()) {
                    stringBuffer.append("OcspTimeTolerance");
                    stringBuffer.append(String.valueOf(this.bean.getOcspTimeTolerance()));
                }
                if (this.bean.isCheckingEnabledSet()) {
                    stringBuffer.append("CheckingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isCheckingEnabled()));
                }
                if (this.bean.isCrlDpBackgroundDownloadEnabledSet()) {
                    stringBuffer.append("CrlDpBackgroundDownloadEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isCrlDpBackgroundDownloadEnabled()));
                }
                if (this.bean.isCrlDpEnabledSet()) {
                    stringBuffer.append("CrlDpEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isCrlDpEnabled()));
                }
                if (this.bean.isFailOnUnknownRevocStatusSet()) {
                    stringBuffer.append("FailOnUnknownRevocStatus");
                    stringBuffer.append(String.valueOf(this.bean.isFailOnUnknownRevocStatus()));
                }
                if (this.bean.isOcspNonceEnabledSet()) {
                    stringBuffer.append("OcspNonceEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isOcspNonceEnabled()));
                }
                if (this.bean.isOcspResponseCacheEnabledSet()) {
                    stringBuffer.append("OcspResponseCacheEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isOcspResponseCacheEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                CertRevocMBeanImpl certRevocMBeanImpl = (CertRevocMBeanImpl)abstractDescriptorBean;
                this.computeChildDiff("CertRevocCas", this.bean.getCertRevocCas(), certRevocMBeanImpl.getCertRevocCas(), true);
                this.computeDiff("CrlCacheRefreshPeriodPercent", this.bean.getCrlCacheRefreshPeriodPercent(), certRevocMBeanImpl.getCrlCacheRefreshPeriodPercent(), true);
                this.computeDiff("CrlCacheType", this.bean.getCrlCacheType(), certRevocMBeanImpl.getCrlCacheType(), false);
                this.computeDiff("CrlCacheTypeLdapHostname", this.bean.getCrlCacheTypeLdapHostname(), certRevocMBeanImpl.getCrlCacheTypeLdapHostname(), false);
                this.computeDiff("CrlCacheTypeLdapPort", this.bean.getCrlCacheTypeLdapPort(), certRevocMBeanImpl.getCrlCacheTypeLdapPort(), false);
                this.computeDiff("CrlCacheTypeLdapSearchTimeout", this.bean.getCrlCacheTypeLdapSearchTimeout(), certRevocMBeanImpl.getCrlCacheTypeLdapSearchTimeout(), true);
                this.computeDiff("CrlDpDownloadTimeout", this.bean.getCrlDpDownloadTimeout(), certRevocMBeanImpl.getCrlDpDownloadTimeout(), true);
                this.computeDiff("MethodOrder", this.bean.getMethodOrder(), certRevocMBeanImpl.getMethodOrder(), true);
                this.computeDiff("OcspResponseCacheCapacity", this.bean.getOcspResponseCacheCapacity(), certRevocMBeanImpl.getOcspResponseCacheCapacity(), true);
                this.computeDiff("OcspResponseCacheRefreshPeriodPercent", this.bean.getOcspResponseCacheRefreshPeriodPercent(), certRevocMBeanImpl.getOcspResponseCacheRefreshPeriodPercent(), true);
                this.computeDiff("OcspResponseTimeout", this.bean.getOcspResponseTimeout(), certRevocMBeanImpl.getOcspResponseTimeout(), true);
                this.computeDiff("OcspTimeTolerance", this.bean.getOcspTimeTolerance(), certRevocMBeanImpl.getOcspTimeTolerance(), true);
                this.computeDiff("CheckingEnabled", this.bean.isCheckingEnabled(), certRevocMBeanImpl.isCheckingEnabled(), true);
                this.computeDiff("CrlDpBackgroundDownloadEnabled", this.bean.isCrlDpBackgroundDownloadEnabled(), certRevocMBeanImpl.isCrlDpBackgroundDownloadEnabled(), true);
                this.computeDiff("CrlDpEnabled", this.bean.isCrlDpEnabled(), certRevocMBeanImpl.isCrlDpEnabled(), true);
                this.computeDiff("FailOnUnknownRevocStatus", this.bean.isFailOnUnknownRevocStatus(), certRevocMBeanImpl.isFailOnUnknownRevocStatus(), true);
                this.computeDiff("OcspNonceEnabled", this.bean.isOcspNonceEnabled(), certRevocMBeanImpl.isOcspNonceEnabled(), true);
                this.computeDiff("OcspResponseCacheEnabled", this.bean.isOcspResponseCacheEnabled(), certRevocMBeanImpl.isOcspResponseCacheEnabled(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                CertRevocMBeanImpl certRevocMBeanImpl = (CertRevocMBeanImpl)beanUpdateEvent.getSourceBean();
                CertRevocMBeanImpl certRevocMBeanImpl2 = (CertRevocMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("CertRevocCas")) {
                    if (n == 2) {
                        propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                        certRevocMBeanImpl.addCertRevocCa((CertRevocCaMBean)propertyUpdate.getAddedObject());
                    } else if (n == 3) {
                        certRevocMBeanImpl.removeCertRevocCa((CertRevocCaMBean)propertyUpdate.getRemovedObject());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    if (certRevocMBeanImpl.getCertRevocCas() == null || certRevocMBeanImpl.getCertRevocCas().length == 0) {
                        certRevocMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                    }
                } else if (string.equals("CrlCacheRefreshPeriodPercent")) {
                    certRevocMBeanImpl.setCrlCacheRefreshPeriodPercent(certRevocMBeanImpl2.getCrlCacheRefreshPeriodPercent());
                    certRevocMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                } else if (string.equals("CrlCacheType")) {
                    certRevocMBeanImpl.setCrlCacheType(certRevocMBeanImpl2.getCrlCacheType());
                    certRevocMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else if (string.equals("CrlCacheTypeLdapHostname")) {
                    certRevocMBeanImpl.setCrlCacheTypeLdapHostname(certRevocMBeanImpl2.getCrlCacheTypeLdapHostname());
                    certRevocMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else if (string.equals("CrlCacheTypeLdapPort")) {
                    certRevocMBeanImpl.setCrlCacheTypeLdapPort(certRevocMBeanImpl2.getCrlCacheTypeLdapPort());
                    certRevocMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                } else if (string.equals("CrlCacheTypeLdapSearchTimeout")) {
                    certRevocMBeanImpl.setCrlCacheTypeLdapSearchTimeout(certRevocMBeanImpl2.getCrlCacheTypeLdapSearchTimeout());
                    certRevocMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                } else if (string.equals("CrlDpDownloadTimeout")) {
                    certRevocMBeanImpl.setCrlDpDownloadTimeout(certRevocMBeanImpl2.getCrlDpDownloadTimeout());
                    certRevocMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                } else if (string.equals("MethodOrder")) {
                    certRevocMBeanImpl.setMethodOrder(certRevocMBeanImpl2.getMethodOrder());
                    certRevocMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("OcspResponseCacheCapacity")) {
                    certRevocMBeanImpl.setOcspResponseCacheCapacity(certRevocMBeanImpl2.getOcspResponseCacheCapacity());
                    certRevocMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("OcspResponseCacheRefreshPeriodPercent")) {
                    certRevocMBeanImpl.setOcspResponseCacheRefreshPeriodPercent(certRevocMBeanImpl2.getOcspResponseCacheRefreshPeriodPercent());
                    certRevocMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("OcspResponseTimeout")) {
                    certRevocMBeanImpl.setOcspResponseTimeout(certRevocMBeanImpl2.getOcspResponseTimeout());
                    certRevocMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("OcspTimeTolerance")) {
                    certRevocMBeanImpl.setOcspTimeTolerance(certRevocMBeanImpl2.getOcspTimeTolerance());
                    certRevocMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("CheckingEnabled")) {
                    certRevocMBeanImpl.setCheckingEnabled(certRevocMBeanImpl2.isCheckingEnabled());
                    certRevocMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("CrlDpBackgroundDownloadEnabled")) {
                    certRevocMBeanImpl.setCrlDpBackgroundDownloadEnabled(certRevocMBeanImpl2.isCrlDpBackgroundDownloadEnabled());
                    certRevocMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                } else if (string.equals("CrlDpEnabled")) {
                    certRevocMBeanImpl.setCrlDpEnabled(certRevocMBeanImpl2.isCrlDpEnabled());
                    certRevocMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                } else if (string.equals("FailOnUnknownRevocStatus")) {
                    certRevocMBeanImpl.setFailOnUnknownRevocStatus(certRevocMBeanImpl2.isFailOnUnknownRevocStatus());
                    certRevocMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("OcspNonceEnabled")) {
                    certRevocMBeanImpl.setOcspNonceEnabled(certRevocMBeanImpl2.isOcspNonceEnabled());
                    certRevocMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("OcspResponseCacheEnabled")) {
                    certRevocMBeanImpl.setOcspResponseCacheEnabled(certRevocMBeanImpl2.isOcspResponseCacheEnabled());
                    certRevocMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                CertRevocMBeanImpl certRevocMBeanImpl = (CertRevocMBeanImpl)abstractDescriptorBean;
                super.finishCopy(certRevocMBeanImpl, bl, list);
                if (!(list != null && list.contains("CertRevocCas") || !this.bean.isCertRevocCasSet() || certRevocMBeanImpl._isSet(24))) {
                    CertRevocCaMBean[] certRevocCaMBeanArray = this.bean.getCertRevocCas();
                    CertRevocCaMBean[] certRevocCaMBeanArray2 = new CertRevocCaMBean[certRevocCaMBeanArray.length];
                    for (int i = 0; i < certRevocCaMBeanArray2.length; ++i) {
                        certRevocCaMBeanArray2[i] = (CertRevocCaMBean)this.createCopy((AbstractDescriptorBean)certRevocCaMBeanArray[i], bl);
                    }
                    certRevocMBeanImpl.setCertRevocCas(certRevocCaMBeanArray2);
                }
                if ((list == null || !list.contains("CrlCacheRefreshPeriodPercent")) && this.bean.isCrlCacheRefreshPeriodPercentSet()) {
                    certRevocMBeanImpl.setCrlCacheRefreshPeriodPercent(this.bean.getCrlCacheRefreshPeriodPercent());
                }
                if ((list == null || !list.contains("CrlCacheType")) && this.bean.isCrlCacheTypeSet()) {
                    certRevocMBeanImpl.setCrlCacheType(this.bean.getCrlCacheType());
                }
                if ((list == null || !list.contains("CrlCacheTypeLdapHostname")) && this.bean.isCrlCacheTypeLdapHostnameSet()) {
                    certRevocMBeanImpl.setCrlCacheTypeLdapHostname(this.bean.getCrlCacheTypeLdapHostname());
                }
                if ((list == null || !list.contains("CrlCacheTypeLdapPort")) && this.bean.isCrlCacheTypeLdapPortSet()) {
                    certRevocMBeanImpl.setCrlCacheTypeLdapPort(this.bean.getCrlCacheTypeLdapPort());
                }
                if ((list == null || !list.contains("CrlCacheTypeLdapSearchTimeout")) && this.bean.isCrlCacheTypeLdapSearchTimeoutSet()) {
                    certRevocMBeanImpl.setCrlCacheTypeLdapSearchTimeout(this.bean.getCrlCacheTypeLdapSearchTimeout());
                }
                if ((list == null || !list.contains("CrlDpDownloadTimeout")) && this.bean.isCrlDpDownloadTimeoutSet()) {
                    certRevocMBeanImpl.setCrlDpDownloadTimeout(this.bean.getCrlDpDownloadTimeout());
                }
                if ((list == null || !list.contains("MethodOrder")) && this.bean.isMethodOrderSet()) {
                    certRevocMBeanImpl.setMethodOrder(this.bean.getMethodOrder());
                }
                if ((list == null || !list.contains("OcspResponseCacheCapacity")) && this.bean.isOcspResponseCacheCapacitySet()) {
                    certRevocMBeanImpl.setOcspResponseCacheCapacity(this.bean.getOcspResponseCacheCapacity());
                }
                if ((list == null || !list.contains("OcspResponseCacheRefreshPeriodPercent")) && this.bean.isOcspResponseCacheRefreshPeriodPercentSet()) {
                    certRevocMBeanImpl.setOcspResponseCacheRefreshPeriodPercent(this.bean.getOcspResponseCacheRefreshPeriodPercent());
                }
                if ((list == null || !list.contains("OcspResponseTimeout")) && this.bean.isOcspResponseTimeoutSet()) {
                    certRevocMBeanImpl.setOcspResponseTimeout(this.bean.getOcspResponseTimeout());
                }
                if ((list == null || !list.contains("OcspTimeTolerance")) && this.bean.isOcspTimeToleranceSet()) {
                    certRevocMBeanImpl.setOcspTimeTolerance(this.bean.getOcspTimeTolerance());
                }
                if ((list == null || !list.contains("CheckingEnabled")) && this.bean.isCheckingEnabledSet()) {
                    certRevocMBeanImpl.setCheckingEnabled(this.bean.isCheckingEnabled());
                }
                if ((list == null || !list.contains("CrlDpBackgroundDownloadEnabled")) && this.bean.isCrlDpBackgroundDownloadEnabledSet()) {
                    certRevocMBeanImpl.setCrlDpBackgroundDownloadEnabled(this.bean.isCrlDpBackgroundDownloadEnabled());
                }
                if ((list == null || !list.contains("CrlDpEnabled")) && this.bean.isCrlDpEnabledSet()) {
                    certRevocMBeanImpl.setCrlDpEnabled(this.bean.isCrlDpEnabled());
                }
                if ((list == null || !list.contains("FailOnUnknownRevocStatus")) && this.bean.isFailOnUnknownRevocStatusSet()) {
                    certRevocMBeanImpl.setFailOnUnknownRevocStatus(this.bean.isFailOnUnknownRevocStatus());
                }
                if ((list == null || !list.contains("OcspNonceEnabled")) && this.bean.isOcspNonceEnabledSet()) {
                    certRevocMBeanImpl.setOcspNonceEnabled(this.bean.isOcspNonceEnabled());
                }
                if ((list == null || !list.contains("OcspResponseCacheEnabled")) && this.bean.isOcspResponseCacheEnabledSet()) {
                    certRevocMBeanImpl.setOcspResponseCacheEnabled(this.bean.isOcspResponseCacheEnabled());
                }
                return certRevocMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getCertRevocCas(), clazz, object);
        }
    }
}

