/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.math.BigInteger;
import java.net.URI;
import javax.security.auth.x500.X500Principal;
import weblogic.management.configuration.CertRevocCaMBean;
import weblogic.management.configuration.CertRevocMBean;

public class CertRevocValidator {
    public static void validateCertRevoc(CertRevocMBean certRevocMBean) throws IllegalArgumentException {
        CertRevocValidator.validateUniqueDn(certRevocMBean);
    }

    private static void validateUniqueDn(CertRevocMBean certRevocMBean) throws IllegalArgumentException {
        CertRevocCaMBean[] certRevocCaMBeanArray = certRevocMBean.getCertRevocCas();
        if (null == certRevocCaMBeanArray) {
            return;
        }
        for (CertRevocCaMBean certRevocCaMBean : certRevocCaMBeanArray) {
            X500Principal x500Principal;
            if (null == certRevocCaMBean || null == (x500Principal = CertRevocValidator.tryGetX500Principal(certRevocCaMBean))) continue;
            for (CertRevocCaMBean certRevocCaMBean2 : certRevocCaMBeanArray) {
                X500Principal x500Principal2;
                if (null == certRevocCaMBean2 || certRevocCaMBean == certRevocCaMBean2 || null == (x500Principal2 = CertRevocValidator.tryGetX500Principal(certRevocCaMBean2)) || !x500Principal.equals(x500Principal2)) continue;
                throw new IllegalArgumentException("Illegal duplicate distinguished name: " + x500Principal.getName());
            }
        }
    }

    private static X500Principal tryGetX500Principal(CertRevocCaMBean certRevocCaMBean) {
        X500Principal x500Principal = null;
        try {
            x500Principal = new X500Principal(certRevocCaMBean.getDistinguishedName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return x500Principal;
    }

    public static void validatePort(int n) {
        if (n != -1 && (n < 1 || n > 65535)) {
            throw new IllegalArgumentException("Illegal value for port: " + n);
        }
    }

    public static void validateX500PrincipalDN(String string) {
        if (null == string) {
            return;
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Illegal value for distinguished name: " + string);
        }
        try {
            new X500Principal(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Illegal value for distinguished name: " + string, exception);
        }
    }

    public static void validateURL(String string) {
        URI uRI;
        if (null == string) {
            return;
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Illegal value for URL: " + string);
        }
        try {
            uRI = new URI(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Illegal value for URL: " + string, exception);
        }
        if (!uRI.isAbsolute()) {
            throw new IllegalArgumentException("Illegal value for URL, must be absolute: " + string);
        }
        if (uRI.isOpaque()) {
            throw new IllegalArgumentException("Illegal value for URL, must not be opaque: " + string);
        }
    }

    public static void validateCertSerialNumber(String string) {
        if (null == string) {
            return;
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Illegal value for serial number: " + string);
        }
        String string2 = string.replaceAll("[ :]", "");
        if (string2.length() == 0) {
            throw new IllegalArgumentException("Illegal value for serial number: " + string);
        }
        try {
            new BigInteger(string2, 16);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Illegal value for serial number: " + string, exception);
        }
    }
}

