/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import weblogic.cluster.ClusterValidator;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.DatabaseLessLeasingBasisMBean;
import weblogic.management.configuration.DatabaseLessLeasingBasisMBeanImpl;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.MachineMBean;
import weblogic.management.configuration.MachineMBeanImpl;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.MigratableTargetMBeanImpl;
import weblogic.management.configuration.OverloadProtectionMBean;
import weblogic.management.configuration.OverloadProtectionMBeanImpl;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.ServerMBeanImpl;
import weblogic.management.configuration.TargetMBeanImpl;
import weblogic.management.mbeans.custom.Cluster;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;

public class ClusterMBeanImpl
extends TargetMBeanImpl
implements ClusterMBean,
Serializable {
    private int _AdditionalAutoMigrationAttempts;
    private int _AsyncSessionQueueTimeout;
    private String _AutoMigrationTableName;
    private MachineMBean[] _CandidateMachinesForMigratableServers;
    private boolean _ClientCertProxyEnabled;
    private String _ClusterAddress;
    private String _ClusterBroadcastChannel;
    private String _ClusterMessagingMode;
    private String _ClusterType;
    private int _ConsensusParticipants;
    private JDBCSystemResourceMBean _DataSourceForAutomaticMigration;
    private JDBCSystemResourceMBean _DataSourceForJobScheduler;
    private JDBCSystemResourceMBean _DataSourceForSessionPersistence;
    private DatabaseLessLeasingBasisMBean _DatabaseLessLeasingBasis;
    private int _DeathDetectorHeartbeatPeriod;
    private String _DefaultLoadAlgorithm;
    private int _FencingGracePeriodMillis;
    private int _FrontendHTTPPort;
    private int _FrontendHTTPSPort;
    private String _FrontendHost;
    private int _GreedySessionFlushInterval;
    private int _HTTPPingRetryCount;
    private int _HealthCheckIntervalMillis;
    private int _HealthCheckPeriodsUntilFencing;
    private boolean _HttpTraceSupportEnabled;
    private int _IdlePeriodsUntilTimeout;
    private int _InterClusterCommLinkHealthCheckInterval;
    private String _JobSchedulerTableName;
    private int _MaxServerCountForHttpPing;
    private boolean _MemberDeathDetectorEnabled;
    private int _MemberWarmupTimeoutSeconds;
    private boolean _MessageOrderingEnabled;
    private MigratableTargetMBean[] _MigratableTargets;
    private String _MigrationBasis;
    private long _MillisToSleepBetweenAutoMigrationAttempts;
    private String _MulticastAddress;
    private int _MulticastBufferSize;
    private boolean _MulticastDataEncryption;
    private int _MulticastPort;
    private int _MulticastSendDelay;
    private int _MulticastTTL;
    private String _Name;
    private int _NumberOfServersInClusterAddress;
    private boolean _OneWayRmiForReplicationEnabled;
    private OverloadProtectionMBean _OverloadProtection;
    private boolean _PersistSessionsOnShutdown;
    private String _RemoteClusterAddress;
    private String _ReplicationChannel;
    private boolean _ReplicationTimeoutEnabled;
    private boolean _SecureReplicationEnabled;
    private Set _ServerNames;
    private ServerMBean[] _Servers;
    private int _ServiceAgeThresholdSeconds;
    private int _SessionFlushInterval;
    private int _SessionFlushThreshold;
    private boolean _SessionLazyDeserializationEnabled;
    private String _SingletonSQLQueryHelper;
    private int _UnicastDiscoveryPeriodMillis;
    private String _WANSessionPersistenceTableName;
    private boolean _WeblogicPluginEnabled;
    private Cluster _customizer;
    private static SchemaHelper2 _schemaHelper;

    public ClusterMBeanImpl() {
        try {
            this._customizer = new Cluster(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public ClusterMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new Cluster(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public void addServer(ServerMBean serverMBean) {
        this._getHelper()._ensureNonNull((Object)serverMBean);
        if (!((AbstractDescriptorBean)serverMBean).isChildProperty((DescriptorBean)this, 8)) {
            ServerMBean[] serverMBeanArray = (ServerMBean[])this._getHelper()._extendArray((Object)this.getServers(), ServerMBean.class, (Object)serverMBean);
            try {
                this.setServers(serverMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public Set getServerNames() {
        return this._customizer.getServerNames();
    }

    public ServerMBean[] getServers() {
        return this._customizer.getServers();
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isServerNamesSet() {
        return this._isSet(7);
    }

    public boolean isServersSet() {
        return this._isSet(8);
    }

    public void removeServer(ServerMBean serverMBean) {
        ServerMBean[] serverMBeanArray = this.getServers();
        ServerMBean[] serverMBeanArray2 = (ServerMBean[])this._getHelper()._removeElement((Object)serverMBeanArray, ServerMBean.class, (Object)serverMBean);
        if (serverMBeanArray2.length != serverMBeanArray.length) {
            try {
                this.setServers(serverMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void setServerNames(Set set) throws InvalidAttributeValueException {
        this._ServerNames = set;
    }

    public void setServers(ServerMBean[] serverMBeanArray) throws InvalidAttributeValueException {
        serverMBeanArray = serverMBeanArray == null ? new ServerMBeanImpl[]{} : serverMBeanArray;
        this._Servers = serverMBeanArray;
    }

    public String getClusterAddress() {
        return this._ClusterAddress;
    }

    public boolean isClusterAddressSet() {
        return this._isSet(9);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setClusterAddress(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ClusterAddress;
        this._ClusterAddress = string;
        this._postSet(9, string2, string);
    }

    public String getMulticastAddress() {
        return this._customizer.getMulticastAddress();
    }

    public boolean isMulticastAddressSet() {
        return this._isSet(10);
    }

    public void setMulticastAddress(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        ClusterValidator.validateMulticastAddress(string);
        String string2 = this.getMulticastAddress();
        this._customizer.setMulticastAddress(string);
        this._postSet(10, string2, string);
    }

    public void setMulticastBufferSize(int n) {
        LegalChecks.checkMin((String)"MulticastBufferSize", (int)n, (int)64);
        int n2 = this._MulticastBufferSize;
        this._MulticastBufferSize = n;
        this._postSet(11, n2, n);
    }

    public int getMulticastBufferSize() {
        return this._MulticastBufferSize;
    }

    public boolean isMulticastBufferSizeSet() {
        return this._isSet(11);
    }

    public int getMulticastPort() {
        return this._MulticastPort;
    }

    public boolean isMulticastPortSet() {
        return this._isSet(12);
    }

    public void setMulticastPort(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"MulticastPort", (long)n, (long)1L, (long)65535L);
        int n2 = this._MulticastPort;
        this._MulticastPort = n;
        this._postSet(12, n2, n);
    }

    public int getMulticastTTL() {
        return this._MulticastTTL;
    }

    public boolean isMulticastTTLSet() {
        return this._isSet(13);
    }

    public void setMulticastTTL(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"MulticastTTL", (long)n, (long)1L, (long)255L);
        int n2 = this._MulticastTTL;
        this._MulticastTTL = n;
        this._postSet(13, n2, n);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public int getMulticastSendDelay() {
        return this._MulticastSendDelay;
    }

    public boolean isMulticastSendDelaySet() {
        return this._isSet(14);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setMulticastSendDelay(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"MulticastSendDelay", (long)n, (long)0L, (long)250L);
        int n2 = this._MulticastSendDelay;
        this._MulticastSendDelay = n;
        this._postSet(14, n2, n);
    }

    public String getDefaultLoadAlgorithm() {
        return this._DefaultLoadAlgorithm;
    }

    public boolean isDefaultLoadAlgorithmSet() {
        return this._isSet(15);
    }

    public void setDefaultLoadAlgorithm(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"round-robin", "weight-based", "random", "round-robin-affinity", "weight-based-affinity", "random-affinity"};
        string = LegalChecks.checkInEnum((String)"DefaultLoadAlgorithm", (String)string, (String[])stringArray);
        String string2 = this._DefaultLoadAlgorithm;
        this._DefaultLoadAlgorithm = string;
        this._postSet(15, string2, string);
    }

    public String getClusterMessagingMode() {
        return this._ClusterMessagingMode;
    }

    public boolean isClusterMessagingModeSet() {
        return this._isSet(16);
    }

    public void setClusterMessagingMode(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"multicast", "unicast"};
        string = LegalChecks.checkInEnum((String)"ClusterMessagingMode", (String)string, (String[])stringArray);
        String string2 = this._ClusterMessagingMode;
        this._ClusterMessagingMode = string;
        this._postSet(16, string2, string);
    }

    public String getClusterBroadcastChannel() {
        return this._ClusterBroadcastChannel;
    }

    public boolean isClusterBroadcastChannelSet() {
        return this._isSet(17);
    }

    public void setClusterBroadcastChannel(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ClusterBroadcastChannel;
        this._ClusterBroadcastChannel = string;
        this._postSet(17, string2, string);
    }

    public int getServiceAgeThresholdSeconds() {
        return this._ServiceAgeThresholdSeconds;
    }

    public boolean isServiceAgeThresholdSecondsSet() {
        return this._isSet(18);
    }

    public void setServiceAgeThresholdSeconds(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"ServiceAgeThresholdSeconds", (long)n, (long)0L, (long)65534L);
        int n2 = this._ServiceAgeThresholdSeconds;
        this._ServiceAgeThresholdSeconds = n;
        this._postSet(18, n2, n);
    }

    public HashMap start() {
        try {
            return this._customizer.start();
        }
        catch (RuntimeOperationsException runtimeOperationsException) {
            throw new UndeclaredThrowableException(runtimeOperationsException);
        }
    }

    public HashMap kill() {
        try {
            return this._customizer.kill();
        }
        catch (RuntimeOperationsException runtimeOperationsException) {
            throw new UndeclaredThrowableException(runtimeOperationsException);
        }
    }

    public void setClientCertProxyEnabled(boolean bl) {
        boolean bl2 = this._ClientCertProxyEnabled;
        this._ClientCertProxyEnabled = bl;
        this._postSet(19, bl2, bl);
    }

    public boolean isClientCertProxyEnabled() {
        return this._ClientCertProxyEnabled;
    }

    public boolean isClientCertProxyEnabledSet() {
        return this._isSet(19);
    }

    public void setWeblogicPluginEnabled(boolean bl) {
        boolean bl2 = this._WeblogicPluginEnabled;
        this._WeblogicPluginEnabled = bl;
        this._postSet(20, bl2, bl);
    }

    public boolean isWeblogicPluginEnabled() {
        return this._WeblogicPluginEnabled;
    }

    public boolean isWeblogicPluginEnabledSet() {
        return this._isSet(20);
    }

    public void addMigratableTarget(MigratableTargetMBean migratableTargetMBean) {
        this._getHelper()._ensureNonNull((Object)migratableTargetMBean);
        if (!((AbstractDescriptorBean)migratableTargetMBean).isChildProperty((DescriptorBean)this, 21)) {
            MigratableTargetMBean[] migratableTargetMBeanArray = (MigratableTargetMBean[])this._getHelper()._extendArray((Object)this.getMigratableTargets(), MigratableTargetMBean.class, (Object)migratableTargetMBean);
            try {
                this.setMigratableTargets(migratableTargetMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public MigratableTargetMBean[] getMigratableTargets() {
        return this._customizer.getMigratableTargets();
    }

    public boolean isMigratableTargetsSet() {
        return this._isSet(21);
    }

    public void removeMigratableTarget(MigratableTargetMBean migratableTargetMBean) {
        MigratableTargetMBean[] migratableTargetMBeanArray = this.getMigratableTargets();
        MigratableTargetMBean[] migratableTargetMBeanArray2 = (MigratableTargetMBean[])this._getHelper()._removeElement((Object)migratableTargetMBeanArray, MigratableTargetMBean.class, (Object)migratableTargetMBean);
        if (migratableTargetMBeanArray2.length != migratableTargetMBeanArray.length) {
            try {
                this.setMigratableTargets(migratableTargetMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void setMigratableTargets(MigratableTargetMBean[] migratableTargetMBeanArray) throws InvalidAttributeValueException {
        migratableTargetMBeanArray = migratableTargetMBeanArray == null ? new MigratableTargetMBeanImpl[]{} : migratableTargetMBeanArray;
        this._MigratableTargets = migratableTargetMBeanArray;
    }

    public int getMemberWarmupTimeoutSeconds() {
        return this._MemberWarmupTimeoutSeconds;
    }

    public boolean isMemberWarmupTimeoutSecondsSet() {
        return this._isSet(22);
    }

    public void setMemberWarmupTimeoutSeconds(int n) {
        LegalChecks.checkMin((String)"MemberWarmupTimeoutSeconds", (int)n, (int)0);
        int n2 = this._MemberWarmupTimeoutSeconds;
        this._MemberWarmupTimeoutSeconds = n;
        this._postSet(22, n2, n);
    }

    public void setHttpTraceSupportEnabled(boolean bl) {
        boolean bl2 = this._HttpTraceSupportEnabled;
        this._HttpTraceSupportEnabled = bl;
        this._postSet(23, bl2, bl);
    }

    public boolean isHttpTraceSupportEnabled() {
        return this._HttpTraceSupportEnabled;
    }

    public boolean isHttpTraceSupportEnabledSet() {
        return this._isSet(23);
    }

    public String getFrontendHost() {
        return this._FrontendHost;
    }

    public boolean isFrontendHostSet() {
        return this._isSet(24);
    }

    public void setFrontendHost(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._FrontendHost;
        this._FrontendHost = string;
        this._postSet(24, string2, string);
    }

    public int getFrontendHTTPPort() {
        return this._FrontendHTTPPort;
    }

    public boolean isFrontendHTTPPortSet() {
        return this._isSet(25);
    }

    public void setFrontendHTTPPort(int n) throws InvalidAttributeValueException {
        int n2 = this._FrontendHTTPPort;
        this._FrontendHTTPPort = n;
        this._postSet(25, n2, n);
    }

    public int getFrontendHTTPSPort() {
        return this._FrontendHTTPSPort;
    }

    public boolean isFrontendHTTPSPortSet() {
        return this._isSet(26);
    }

    public void setFrontendHTTPSPort(int n) throws InvalidAttributeValueException {
        int n2 = this._FrontendHTTPSPort;
        this._FrontendHTTPSPort = n;
        this._postSet(26, n2, n);
    }

    public int getIdlePeriodsUntilTimeout() {
        return this._IdlePeriodsUntilTimeout;
    }

    public boolean isIdlePeriodsUntilTimeoutSet() {
        return this._isSet(27);
    }

    public void setIdlePeriodsUntilTimeout(int n) {
        LegalChecks.checkMin((String)"IdlePeriodsUntilTimeout", (int)n, (int)3);
        int n2 = this._IdlePeriodsUntilTimeout;
        this._IdlePeriodsUntilTimeout = n;
        this._postSet(27, n2, n);
    }

    public void setRemoteClusterAddress(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._RemoteClusterAddress;
        this._RemoteClusterAddress = string;
        this._postSet(28, string2, string);
    }

    public String getRemoteClusterAddress() {
        return this._RemoteClusterAddress;
    }

    public boolean isRemoteClusterAddressSet() {
        return this._isSet(28);
    }

    public void setWANSessionPersistenceTableName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._WANSessionPersistenceTableName;
        this._WANSessionPersistenceTableName = string;
        this._postSet(29, string2, string);
    }

    public String getWANSessionPersistenceTableName() {
        return this._WANSessionPersistenceTableName;
    }

    public boolean isWANSessionPersistenceTableNameSet() {
        return this._isSet(29);
    }

    public String getReplicationChannel() {
        return this._ReplicationChannel;
    }

    public boolean isReplicationChannelSet() {
        return this._isSet(30);
    }

    public void setReplicationChannel(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._ReplicationChannel;
        this._ReplicationChannel = string;
        this._postSet(30, string2, string);
    }

    public int getInterClusterCommLinkHealthCheckInterval() {
        return this._InterClusterCommLinkHealthCheckInterval;
    }

    public boolean isInterClusterCommLinkHealthCheckIntervalSet() {
        return this._isSet(31);
    }

    public void setInterClusterCommLinkHealthCheckInterval(int n) {
        int n2 = this._InterClusterCommLinkHealthCheckInterval;
        this._InterClusterCommLinkHealthCheckInterval = n;
        this._postSet(31, n2, n);
    }

    public void setDataSourceForSessionPersistence(JDBCSystemResourceMBean jDBCSystemResourceMBean) {
        JDBCSystemResourceMBean jDBCSystemResourceMBean2;
        if (jDBCSystemResourceMBean != null) {
            jDBCSystemResourceMBean2 = new ResolvedReference(this, 32, (AbstractDescriptorBean)jDBCSystemResourceMBean){

                protected Object getPropertyValue() {
                    return ClusterMBeanImpl.this.getDataSourceForSessionPersistence();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)jDBCSystemResourceMBean, (ResolvedReference)jDBCSystemResourceMBean2);
        }
        jDBCSystemResourceMBean2 = this._DataSourceForSessionPersistence;
        this._DataSourceForSessionPersistence = jDBCSystemResourceMBean;
        this._postSet(32, jDBCSystemResourceMBean2, jDBCSystemResourceMBean);
    }

    public JDBCSystemResourceMBean getDataSourceForSessionPersistence() {
        return this._DataSourceForSessionPersistence;
    }

    public String getDataSourceForSessionPersistenceAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getDataSourceForSessionPersistence();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isDataSourceForSessionPersistenceSet() {
        return this._isSet(32);
    }

    public void setDataSourceForSessionPersistenceAsString(String string) {
        if (string == null || string.length() == 0) {
            JDBCSystemResourceMBean jDBCSystemResourceMBean = this._DataSourceForSessionPersistence;
            this._initializeProperty(32);
            this._postSet(32, jDBCSystemResourceMBean, this._DataSourceForSessionPersistence);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, JDBCSystemResourceMBean.class, new ReferenceManager.Resolver(this, 32){

                public void resolveReference(Object object) {
                    try {
                        ClusterMBeanImpl.this.setDataSourceForSessionPersistence((JDBCSystemResourceMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setDataSourceForJobScheduler(JDBCSystemResourceMBean jDBCSystemResourceMBean) {
        JDBCSystemResourceMBean jDBCSystemResourceMBean2;
        if (jDBCSystemResourceMBean != null) {
            jDBCSystemResourceMBean2 = new ResolvedReference(this, 33, (AbstractDescriptorBean)jDBCSystemResourceMBean){

                protected Object getPropertyValue() {
                    return ClusterMBeanImpl.this.getDataSourceForJobScheduler();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)jDBCSystemResourceMBean, (ResolvedReference)jDBCSystemResourceMBean2);
        }
        jDBCSystemResourceMBean2 = this._DataSourceForJobScheduler;
        this._DataSourceForJobScheduler = jDBCSystemResourceMBean;
        this._postSet(33, jDBCSystemResourceMBean2, jDBCSystemResourceMBean);
    }

    public JDBCSystemResourceMBean getDataSourceForJobScheduler() {
        return this._DataSourceForJobScheduler;
    }

    public String getDataSourceForJobSchedulerAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getDataSourceForJobScheduler();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isDataSourceForJobSchedulerSet() {
        return this._isSet(33);
    }

    public void setDataSourceForJobSchedulerAsString(String string) {
        if (string == null || string.length() == 0) {
            JDBCSystemResourceMBean jDBCSystemResourceMBean = this._DataSourceForJobScheduler;
            this._initializeProperty(33);
            this._postSet(33, jDBCSystemResourceMBean, this._DataSourceForJobScheduler);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, JDBCSystemResourceMBean.class, new ReferenceManager.Resolver(this, 33){

                public void resolveReference(Object object) {
                    try {
                        ClusterMBeanImpl.this.setDataSourceForJobScheduler((JDBCSystemResourceMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public String getJobSchedulerTableName() {
        return this._JobSchedulerTableName;
    }

    public boolean isJobSchedulerTableNameSet() {
        return this._isSet(34);
    }

    public void setJobSchedulerTableName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._JobSchedulerTableName;
        this._JobSchedulerTableName = string;
        this._postSet(34, string2, string);
    }

    public boolean getPersistSessionsOnShutdown() {
        return this._PersistSessionsOnShutdown;
    }

    public boolean isPersistSessionsOnShutdownSet() {
        return this._isSet(35);
    }

    public void setPersistSessionsOnShutdown(boolean bl) {
        boolean bl2 = this._PersistSessionsOnShutdown;
        this._PersistSessionsOnShutdown = bl;
        this._postSet(35, bl2, bl);
    }

    public void setAsyncSessionQueueTimeout(int n) {
        int n2 = this._AsyncSessionQueueTimeout;
        this._AsyncSessionQueueTimeout = n;
        this._postSet(36, n2, n);
    }

    public int getAsyncSessionQueueTimeout() {
        return this._AsyncSessionQueueTimeout;
    }

    public boolean isAsyncSessionQueueTimeoutSet() {
        return this._isSet(36);
    }

    public void setGreedySessionFlushInterval(int n) {
        int n2 = this._GreedySessionFlushInterval;
        this._GreedySessionFlushInterval = n;
        this._postSet(37, n2, n);
    }

    public int getGreedySessionFlushInterval() {
        return this._GreedySessionFlushInterval;
    }

    public boolean isGreedySessionFlushIntervalSet() {
        return this._isSet(37);
    }

    public void setSessionFlushInterval(int n) {
        int n2 = this._SessionFlushInterval;
        this._SessionFlushInterval = n;
        this._postSet(38, n2, n);
    }

    public int getSessionFlushInterval() {
        return this._SessionFlushInterval;
    }

    public boolean isSessionFlushIntervalSet() {
        return this._isSet(38);
    }

    public void setSessionFlushThreshold(int n) {
        int n2 = this._SessionFlushThreshold;
        this._SessionFlushThreshold = n;
        this._postSet(39, n2, n);
    }

    public int getSessionFlushThreshold() {
        return this._SessionFlushThreshold;
    }

    public boolean isSessionFlushThresholdSet() {
        return this._isSet(39);
    }

    public void addCandidateMachinesForMigratableServer(MachineMBean machineMBean) {
        this._getHelper()._ensureNonNull((Object)machineMBean);
        if (!((AbstractDescriptorBean)machineMBean).isChildProperty((DescriptorBean)this, 40)) {
            MachineMBean[] machineMBeanArray = this._isSet(40) ? (MachineMBean[])this._getHelper()._extendArray((Object)this.getCandidateMachinesForMigratableServers(), MachineMBean.class, (Object)machineMBean) : new MachineMBean[]{machineMBean};
            try {
                this.setCandidateMachinesForMigratableServers(machineMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public MachineMBean[] getCandidateMachinesForMigratableServers() {
        return this._CandidateMachinesForMigratableServers;
    }

    public String getCandidateMachinesForMigratableServersAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getCandidateMachinesForMigratableServers());
    }

    public boolean isCandidateMachinesForMigratableServersSet() {
        return this._isSet(40);
    }

    public void removeCandidateMachinesForMigratableServer(MachineMBean machineMBean) {
        MachineMBean[] machineMBeanArray = this.getCandidateMachinesForMigratableServers();
        MachineMBean[] machineMBeanArray2 = (MachineMBean[])this._getHelper()._removeElement((Object)machineMBeanArray, MachineMBean.class, (Object)machineMBean);
        if (machineMBeanArray2.length != machineMBeanArray.length) {
            try {
                this.setCandidateMachinesForMigratableServers(machineMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void setCandidateMachinesForMigratableServersAsString(String string) {
        if (string == null || string.length() == 0) {
            MachineMBean[] machineMBeanArray = this._CandidateMachinesForMigratableServers;
            this._initializeProperty(40);
            this._postSet(40, machineMBeanArray, this._CandidateMachinesForMigratableServers);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._CandidateMachinesForMigratableServers);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, MachineMBean.class, new ReferenceManager.Resolver(this, 40){

                    public void resolveReference(Object object) {
                        try {
                            ClusterMBeanImpl.this.addCandidateMachinesForMigratableServer((MachineMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (MachineMBean machineMBean : this._CandidateMachinesForMigratableServers) {
                    if (!string2.equals(machineMBean.getName())) continue;
                    try {
                        this.removeCandidateMachinesForMigratableServer(machineMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void setCandidateMachinesForMigratableServers(MachineMBean[] machineMBeanArray) {
        machineMBeanArray = machineMBeanArray == null ? new MachineMBeanImpl[]{} : machineMBeanArray;
        machineMBeanArray = (MachineMBean[])this._getHelper()._cleanAndValidateArray((Object)machineMBeanArray, MachineMBean.class);
        for (int i = 0; i < machineMBeanArray.length; ++i) {
            if (machineMBeanArray[i] == null) continue;
            ResolvedReference resolvedReference = new ResolvedReference(this, 40, (AbstractDescriptorBean)machineMBeanArray[i]){

                protected Object getPropertyValue() {
                    return ClusterMBeanImpl.this.getCandidateMachinesForMigratableServers();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)machineMBeanArray[i], resolvedReference);
        }
        MachineMBean[] machineMBeanArray2 = this._CandidateMachinesForMigratableServers;
        this._CandidateMachinesForMigratableServers = machineMBeanArray;
        this._postSet(40, machineMBeanArray2, machineMBeanArray);
    }

    public JDBCSystemResourceMBean getDataSourceForAutomaticMigration() {
        return this._DataSourceForAutomaticMigration;
    }

    public String getDataSourceForAutomaticMigrationAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getDataSourceForAutomaticMigration();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isDataSourceForAutomaticMigrationSet() {
        return this._isSet(41);
    }

    public void setDataSourceForAutomaticMigrationAsString(String string) {
        if (string == null || string.length() == 0) {
            JDBCSystemResourceMBean jDBCSystemResourceMBean = this._DataSourceForAutomaticMigration;
            this._initializeProperty(41);
            this._postSet(41, jDBCSystemResourceMBean, this._DataSourceForAutomaticMigration);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, JDBCSystemResourceMBean.class, new ReferenceManager.Resolver(this, 41){

                public void resolveReference(Object object) {
                    try {
                        ClusterMBeanImpl.this.setDataSourceForAutomaticMigration((JDBCSystemResourceMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setDataSourceForAutomaticMigration(JDBCSystemResourceMBean jDBCSystemResourceMBean) {
        JDBCSystemResourceMBean jDBCSystemResourceMBean2;
        if (jDBCSystemResourceMBean != null) {
            jDBCSystemResourceMBean2 = new ResolvedReference(this, 41, (AbstractDescriptorBean)jDBCSystemResourceMBean){

                protected Object getPropertyValue() {
                    return ClusterMBeanImpl.this.getDataSourceForAutomaticMigration();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)jDBCSystemResourceMBean, (ResolvedReference)jDBCSystemResourceMBean2);
        }
        jDBCSystemResourceMBean2 = this._DataSourceForAutomaticMigration;
        this._DataSourceForAutomaticMigration = jDBCSystemResourceMBean;
        this._postSet(41, jDBCSystemResourceMBean2, jDBCSystemResourceMBean);
    }

    public int getHealthCheckIntervalMillis() {
        return this._HealthCheckIntervalMillis;
    }

    public boolean isHealthCheckIntervalMillisSet() {
        return this._isSet(42);
    }

    public void setHealthCheckIntervalMillis(int n) {
        int n2 = this._HealthCheckIntervalMillis;
        this._HealthCheckIntervalMillis = n;
        this._postSet(42, n2, n);
    }

    public int getHealthCheckPeriodsUntilFencing() {
        return this._HealthCheckPeriodsUntilFencing;
    }

    public boolean isHealthCheckPeriodsUntilFencingSet() {
        return this._isSet(43);
    }

    public void setHealthCheckPeriodsUntilFencing(int n) {
        LegalChecks.checkMin((String)"HealthCheckPeriodsUntilFencing", (int)n, (int)2);
        int n2 = this._HealthCheckPeriodsUntilFencing;
        this._HealthCheckPeriodsUntilFencing = n;
        this._postSet(43, n2, n);
    }

    public int getFencingGracePeriodMillis() {
        return this._FencingGracePeriodMillis;
    }

    public boolean isFencingGracePeriodMillisSet() {
        return this._isSet(44);
    }

    public void setFencingGracePeriodMillis(int n) {
        int n2 = this._FencingGracePeriodMillis;
        this._FencingGracePeriodMillis = n;
        this._postSet(44, n2, n);
    }

    public String getSingletonSQLQueryHelper() {
        return this._SingletonSQLQueryHelper;
    }

    public boolean isSingletonSQLQueryHelperSet() {
        return this._isSet(45);
    }

    public void setSingletonSQLQueryHelper(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._SingletonSQLQueryHelper;
        this._SingletonSQLQueryHelper = string;
        this._postSet(45, string2, string);
    }

    public int getNumberOfServersInClusterAddress() {
        return this._NumberOfServersInClusterAddress;
    }

    public boolean isNumberOfServersInClusterAddressSet() {
        return this._isSet(46);
    }

    public void setNumberOfServersInClusterAddress(int n) {
        LegalChecks.checkMin((String)"NumberOfServersInClusterAddress", (int)n, (int)1);
        int n2 = this._NumberOfServersInClusterAddress;
        this._NumberOfServersInClusterAddress = n;
        this._postSet(46, n2, n);
    }

    public void setClusterType(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"none", "wan", "man"};
        string = LegalChecks.checkInEnum((String)"ClusterType", (String)string, (String[])stringArray);
        String string2 = this._ClusterType;
        this._ClusterType = string;
        this._postSet(47, string2, string);
    }

    public String getClusterType() {
        return this._ClusterType;
    }

    public boolean isClusterTypeSet() {
        return this._isSet(47);
    }

    public void setMulticastDataEncryption(boolean bl) {
        boolean bl2 = this._MulticastDataEncryption;
        this._MulticastDataEncryption = bl;
        this._postSet(48, bl2, bl);
    }

    public boolean getMulticastDataEncryption() {
        return this._MulticastDataEncryption;
    }

    public boolean isMulticastDataEncryptionSet() {
        return this._isSet(48);
    }

    public void setAutoMigrationTableName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._AutoMigrationTableName;
        this._AutoMigrationTableName = string;
        this._postSet(49, string2, string);
    }

    public String getAutoMigrationTableName() {
        return this._AutoMigrationTableName;
    }

    public boolean isAutoMigrationTableNameSet() {
        return this._isSet(49);
    }

    public int getAdditionalAutoMigrationAttempts() {
        return this._AdditionalAutoMigrationAttempts;
    }

    public boolean isAdditionalAutoMigrationAttemptsSet() {
        return this._isSet(50);
    }

    public void setAdditionalAutoMigrationAttempts(int n) {
        int n2 = this._AdditionalAutoMigrationAttempts;
        this._AdditionalAutoMigrationAttempts = n;
        this._postSet(50, n2, n);
    }

    public long getMillisToSleepBetweenAutoMigrationAttempts() {
        return this._MillisToSleepBetweenAutoMigrationAttempts;
    }

    public boolean isMillisToSleepBetweenAutoMigrationAttemptsSet() {
        return this._isSet(51);
    }

    public void setMillisToSleepBetweenAutoMigrationAttempts(long l) {
        long l2 = this._MillisToSleepBetweenAutoMigrationAttempts;
        this._MillisToSleepBetweenAutoMigrationAttempts = l;
        this._postSet(51, l2, l);
    }

    public void setReplicationTimeoutEnabled(boolean bl) {
        boolean bl2 = this._ReplicationTimeoutEnabled;
        this._ReplicationTimeoutEnabled = bl;
        this._postSet(54, bl2, bl);
    }

    public String getMigrationBasis() {
        return this._MigrationBasis;
    }

    public boolean isMigrationBasisSet() {
        return this._isSet(52);
    }

    public void setMigrationBasis(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"database", "consensus"};
        string = LegalChecks.checkInEnum((String)"MigrationBasis", (String)string, (String[])stringArray);
        String string2 = this._MigrationBasis;
        this._MigrationBasis = string;
        this._postSet(52, string2, string);
    }

    public int getConsensusParticipants() {
        return this._ConsensusParticipants;
    }

    public boolean isConsensusParticipantsSet() {
        return this._isSet(53);
    }

    public void setConsensusParticipants(int n) {
        LegalChecks.checkInRange((String)"ConsensusParticipants", (long)n, (long)0L, (long)65536L);
        int n2 = this._ConsensusParticipants;
        this._ConsensusParticipants = n;
        this._postSet(53, n2, n);
    }

    public boolean isReplicationTimeoutEnabled() {
        return this._ReplicationTimeoutEnabled;
    }

    public boolean isReplicationTimeoutEnabledSet() {
        return this._isSet(54);
    }

    public OverloadProtectionMBean getOverloadProtection() {
        return this._OverloadProtection;
    }

    public boolean isOverloadProtectionSet() {
        return this._isSet(55) || this._isAnythingSet((AbstractDescriptorBean)this.getOverloadProtection());
    }

    public void setOverloadProtection(OverloadProtectionMBean overloadProtectionMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)overloadProtectionMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 55)) {
            this._postCreate(abstractDescriptorBean);
        }
        OverloadProtectionMBean overloadProtectionMBean2 = this._OverloadProtection;
        this._OverloadProtection = overloadProtectionMBean;
        this._postSet(55, overloadProtectionMBean2, overloadProtectionMBean);
    }

    public DatabaseLessLeasingBasisMBean getDatabaseLessLeasingBasis() {
        return this._DatabaseLessLeasingBasis;
    }

    public boolean isDatabaseLessLeasingBasisSet() {
        return this._isSet(56) || this._isAnythingSet((AbstractDescriptorBean)this.getDatabaseLessLeasingBasis());
    }

    public void setDatabaseLessLeasingBasis(DatabaseLessLeasingBasisMBean databaseLessLeasingBasisMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)databaseLessLeasingBasisMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 56)) {
            this._postCreate(abstractDescriptorBean);
        }
        DatabaseLessLeasingBasisMBean databaseLessLeasingBasisMBean2 = this._DatabaseLessLeasingBasis;
        this._DatabaseLessLeasingBasis = databaseLessLeasingBasisMBean;
        this._postSet(56, databaseLessLeasingBasisMBean2, databaseLessLeasingBasisMBean);
    }

    public void setHTTPPingRetryCount(int n) {
        LegalChecks.checkMin((String)"HTTPPingRetryCount", (int)n, (int)0);
        int n2 = this._HTTPPingRetryCount;
        this._HTTPPingRetryCount = n;
        this._postSet(57, n2, n);
    }

    public int getHTTPPingRetryCount() {
        return this._HTTPPingRetryCount;
    }

    public boolean isHTTPPingRetryCountSet() {
        return this._isSet(57);
    }

    public void setMaxServerCountForHttpPing(int n) {
        LegalChecks.checkMin((String)"MaxServerCountForHttpPing", (int)n, (int)0);
        int n2 = this._MaxServerCountForHttpPing;
        this._MaxServerCountForHttpPing = n;
        this._postSet(58, n2, n);
    }

    public int getMaxServerCountForHttpPing() {
        return this._MaxServerCountForHttpPing;
    }

    public boolean isMaxServerCountForHttpPingSet() {
        return this._isSet(58);
    }

    public boolean isSecureReplicationEnabled() {
        return this._SecureReplicationEnabled;
    }

    public boolean isSecureReplicationEnabledSet() {
        return this._isSet(59);
    }

    public void setSecureReplicationEnabled(boolean bl) {
        boolean bl2 = this._SecureReplicationEnabled;
        this._SecureReplicationEnabled = bl;
        this._postSet(59, bl2, bl);
    }

    public void setUnicastDiscoveryPeriodMillis(int n) {
        LegalChecks.checkMin((String)"UnicastDiscoveryPeriodMillis", (int)n, (int)1000);
        int n2 = this._UnicastDiscoveryPeriodMillis;
        this._UnicastDiscoveryPeriodMillis = n;
        this._postSet(60, n2, n);
    }

    public int getUnicastDiscoveryPeriodMillis() {
        return this._UnicastDiscoveryPeriodMillis;
    }

    public boolean isUnicastDiscoveryPeriodMillisSet() {
        return this._isSet(60);
    }

    public void setMessageOrderingEnabled(boolean bl) {
        boolean bl2 = this._MessageOrderingEnabled;
        this._MessageOrderingEnabled = bl;
        this._postSet(61, bl2, bl);
    }

    public boolean isMessageOrderingEnabled() {
        return this._MessageOrderingEnabled;
    }

    public boolean isMessageOrderingEnabledSet() {
        return this._isSet(61);
    }

    public void setOneWayRmiForReplicationEnabled(boolean bl) {
        boolean bl2 = this._OneWayRmiForReplicationEnabled;
        this._OneWayRmiForReplicationEnabled = bl;
        this._postSet(62, bl2, bl);
    }

    public boolean isOneWayRmiForReplicationEnabled() {
        return this._OneWayRmiForReplicationEnabled;
    }

    public boolean isOneWayRmiForReplicationEnabledSet() {
        return this._isSet(62);
    }

    public void setSessionLazyDeserializationEnabled(boolean bl) {
        boolean bl2 = this._SessionLazyDeserializationEnabled;
        this._SessionLazyDeserializationEnabled = bl;
        this._postSet(63, bl2, bl);
    }

    public boolean isSessionLazyDeserializationEnabled() {
        if (!this._isSet(63)) {
            try {
                return ((DomainMBean)this.getParent()).isExalogicOptimizationsEnabled();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._SessionLazyDeserializationEnabled;
    }

    public boolean isSessionLazyDeserializationEnabledSet() {
        return this._isSet(63);
    }

    public void setDeathDetectorHeartbeatPeriod(int n) {
        LegalChecks.checkMin((String)"DeathDetectorHeartbeatPeriod", (int)n, (int)1);
        int n2 = this._DeathDetectorHeartbeatPeriod;
        this._DeathDetectorHeartbeatPeriod = n;
        this._postSet(64, n2, n);
    }

    public int getDeathDetectorHeartbeatPeriod() {
        return this._DeathDetectorHeartbeatPeriod;
    }

    public boolean isDeathDetectorHeartbeatPeriodSet() {
        return this._isSet(64);
    }

    public void setMemberDeathDetectorEnabled(boolean bl) {
        boolean bl2 = this._MemberDeathDetectorEnabled;
        this._MemberDeathDetectorEnabled = bl;
        this._postSet(65, bl2, bl);
    }

    public boolean isMemberDeathDetectorEnabled() {
        return this._MemberDeathDetectorEnabled;
    }

    public boolean isMemberDeathDetectorEnabledSet() {
        return this._isSet(65);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet() || this.isDatabaseLessLeasingBasisSet() || this.isOverloadProtectionSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 50;
        }
        try {
            switch (n) {
                case 50: {
                    this._AdditionalAutoMigrationAttempts = 3;
                    if (bl) break;
                }
                case 36: {
                    this._AsyncSessionQueueTimeout = 30;
                    if (bl) break;
                }
                case 49: {
                    this._AutoMigrationTableName = "ACTIVE";
                    if (bl) break;
                }
                case 40: {
                    this._CandidateMachinesForMigratableServers = new MachineMBean[0];
                    if (bl) break;
                }
                case 9: {
                    this._ClusterAddress = null;
                    if (bl) break;
                }
                case 17: {
                    this._ClusterBroadcastChannel = null;
                    if (bl) break;
                }
                case 16: {
                    this._ClusterMessagingMode = "multicast";
                    if (bl) break;
                }
                case 47: {
                    this._ClusterType = "none";
                    if (bl) break;
                }
                case 53: {
                    this._ConsensusParticipants = 0;
                    if (bl) break;
                }
                case 41: {
                    this._DataSourceForAutomaticMigration = null;
                    if (bl) break;
                }
                case 33: {
                    this._DataSourceForJobScheduler = null;
                    if (bl) break;
                }
                case 32: {
                    this._DataSourceForSessionPersistence = null;
                    if (bl) break;
                }
                case 56: {
                    this._DatabaseLessLeasingBasis = new DatabaseLessLeasingBasisMBeanImpl(this, 56);
                    this._postCreate((AbstractDescriptorBean)this._DatabaseLessLeasingBasis);
                    if (bl) break;
                }
                case 64: {
                    this._DeathDetectorHeartbeatPeriod = 1;
                    if (bl) break;
                }
                case 15: {
                    this._DefaultLoadAlgorithm = "round-robin";
                    if (bl) break;
                }
                case 44: {
                    this._FencingGracePeriodMillis = 30000;
                    if (bl) break;
                }
                case 25: {
                    this._FrontendHTTPPort = 0;
                    if (bl) break;
                }
                case 26: {
                    this._FrontendHTTPSPort = 0;
                    if (bl) break;
                }
                case 24: {
                    this._FrontendHost = null;
                    if (bl) break;
                }
                case 37: {
                    this._GreedySessionFlushInterval = 3;
                    if (bl) break;
                }
                case 57: {
                    this._HTTPPingRetryCount = 3;
                    if (bl) break;
                }
                case 42: {
                    this._HealthCheckIntervalMillis = 10000;
                    if (bl) break;
                }
                case 43: {
                    this._HealthCheckPeriodsUntilFencing = 3;
                    if (bl) break;
                }
                case 27: {
                    this._IdlePeriodsUntilTimeout = 3;
                    if (bl) break;
                }
                case 31: {
                    this._InterClusterCommLinkHealthCheckInterval = 30000;
                    if (bl) break;
                }
                case 34: {
                    this._JobSchedulerTableName = "weblogic_timers";
                    if (bl) break;
                }
                case 58: {
                    this._MaxServerCountForHttpPing = 0;
                    if (bl) break;
                }
                case 22: {
                    this._MemberWarmupTimeoutSeconds = 30;
                    if (bl) break;
                }
                case 21: {
                    this._MigratableTargets = new MigratableTargetMBean[0];
                    if (bl) break;
                }
                case 52: {
                    this._MigrationBasis = "database";
                    if (bl) break;
                }
                case 51: {
                    this._MillisToSleepBetweenAutoMigrationAttempts = 180000L;
                    if (bl) break;
                }
                case 10: {
                    this._customizer.setMulticastAddress("239.192.0.0");
                    if (bl) break;
                }
                case 11: {
                    this._MulticastBufferSize = 64;
                    if (bl) break;
                }
                case 48: {
                    this._MulticastDataEncryption = false;
                    if (bl) break;
                }
                case 12: {
                    this._MulticastPort = 7001;
                    if (bl) break;
                }
                case 14: {
                    this._MulticastSendDelay = 3;
                    if (bl) break;
                }
                case 13: {
                    this._MulticastTTL = 1;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 46: {
                    this._NumberOfServersInClusterAddress = 3;
                    if (bl) break;
                }
                case 55: {
                    this._OverloadProtection = new OverloadProtectionMBeanImpl(this, 55);
                    this._postCreate((AbstractDescriptorBean)this._OverloadProtection);
                    if (bl) break;
                }
                case 35: {
                    this._PersistSessionsOnShutdown = false;
                    if (bl) break;
                }
                case 28: {
                    this._RemoteClusterAddress = null;
                    if (bl) break;
                }
                case 30: {
                    this._ReplicationChannel = "ReplicationChannel";
                    if (bl) break;
                }
                case 7: {
                    this._ServerNames = null;
                    if (bl) break;
                }
                case 8: {
                    this._Servers = new ServerMBean[0];
                    if (bl) break;
                }
                case 18: {
                    this._ServiceAgeThresholdSeconds = 180;
                    if (bl) break;
                }
                case 38: {
                    this._SessionFlushInterval = 180;
                    if (bl) break;
                }
                case 39: {
                    this._SessionFlushThreshold = 10000;
                    if (bl) break;
                }
                case 45: {
                    this._SingletonSQLQueryHelper = "";
                    if (bl) break;
                }
                case 60: {
                    this._UnicastDiscoveryPeriodMillis = 3000;
                    if (bl) break;
                }
                case 29: {
                    this._WANSessionPersistenceTableName = "WLS_WAN_PERSISTENCE_TABLE";
                    if (bl) break;
                }
                case 19: {
                    this._ClientCertProxyEnabled = false;
                    if (bl) break;
                }
                case 23: {
                    this._HttpTraceSupportEnabled = false;
                    if (bl) break;
                }
                case 65: {
                    this._MemberDeathDetectorEnabled = false;
                    if (bl) break;
                }
                case 61: {
                    this._MessageOrderingEnabled = false;
                    if (bl) break;
                }
                case 62: {
                    this._OneWayRmiForReplicationEnabled = false;
                    if (bl) break;
                }
                case 54: {
                    this._ReplicationTimeoutEnabled = true;
                    if (bl) break;
                }
                case 59: {
                    this._SecureReplicationEnabled = false;
                    if (bl) break;
                }
                case 63: {
                    this._SessionLazyDeserializationEnabled = false;
                    if (bl) break;
                }
                case 20: {
                    this._WeblogicPluginEnabled = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "Cluster";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AdditionalAutoMigrationAttempts")) {
            int n = this._AdditionalAutoMigrationAttempts;
            this._AdditionalAutoMigrationAttempts = (Integer)object;
            this._postSet(50, n, this._AdditionalAutoMigrationAttempts);
            return;
        }
        if (string.equals("AsyncSessionQueueTimeout")) {
            int n = this._AsyncSessionQueueTimeout;
            this._AsyncSessionQueueTimeout = (Integer)object;
            this._postSet(36, n, this._AsyncSessionQueueTimeout);
            return;
        }
        if (string.equals("AutoMigrationTableName")) {
            String string2 = this._AutoMigrationTableName;
            this._AutoMigrationTableName = (String)object;
            this._postSet(49, string2, this._AutoMigrationTableName);
            return;
        }
        if (string.equals("CandidateMachinesForMigratableServers")) {
            MachineMBean[] machineMBeanArray = this._CandidateMachinesForMigratableServers;
            this._CandidateMachinesForMigratableServers = (MachineMBean[])object;
            this._postSet(40, machineMBeanArray, this._CandidateMachinesForMigratableServers);
            return;
        }
        if (string.equals("ClientCertProxyEnabled")) {
            boolean bl = this._ClientCertProxyEnabled;
            this._ClientCertProxyEnabled = (Boolean)object;
            this._postSet(19, bl, this._ClientCertProxyEnabled);
            return;
        }
        if (string.equals("ClusterAddress")) {
            String string3 = this._ClusterAddress;
            this._ClusterAddress = (String)object;
            this._postSet(9, string3, this._ClusterAddress);
            return;
        }
        if (string.equals("ClusterBroadcastChannel")) {
            String string4 = this._ClusterBroadcastChannel;
            this._ClusterBroadcastChannel = (String)object;
            this._postSet(17, string4, this._ClusterBroadcastChannel);
            return;
        }
        if (string.equals("ClusterMessagingMode")) {
            String string5 = this._ClusterMessagingMode;
            this._ClusterMessagingMode = (String)object;
            this._postSet(16, string5, this._ClusterMessagingMode);
            return;
        }
        if (string.equals("ClusterType")) {
            String string6 = this._ClusterType;
            this._ClusterType = (String)object;
            this._postSet(47, string6, this._ClusterType);
            return;
        }
        if (string.equals("ConsensusParticipants")) {
            int n = this._ConsensusParticipants;
            this._ConsensusParticipants = (Integer)object;
            this._postSet(53, n, this._ConsensusParticipants);
            return;
        }
        if (string.equals("DataSourceForAutomaticMigration")) {
            JDBCSystemResourceMBean jDBCSystemResourceMBean = this._DataSourceForAutomaticMigration;
            this._DataSourceForAutomaticMigration = (JDBCSystemResourceMBean)object;
            this._postSet(41, jDBCSystemResourceMBean, this._DataSourceForAutomaticMigration);
            return;
        }
        if (string.equals("DataSourceForJobScheduler")) {
            JDBCSystemResourceMBean jDBCSystemResourceMBean = this._DataSourceForJobScheduler;
            this._DataSourceForJobScheduler = (JDBCSystemResourceMBean)object;
            this._postSet(33, jDBCSystemResourceMBean, this._DataSourceForJobScheduler);
            return;
        }
        if (string.equals("DataSourceForSessionPersistence")) {
            JDBCSystemResourceMBean jDBCSystemResourceMBean = this._DataSourceForSessionPersistence;
            this._DataSourceForSessionPersistence = (JDBCSystemResourceMBean)object;
            this._postSet(32, jDBCSystemResourceMBean, this._DataSourceForSessionPersistence);
            return;
        }
        if (string.equals("DatabaseLessLeasingBasis")) {
            DatabaseLessLeasingBasisMBean databaseLessLeasingBasisMBean = this._DatabaseLessLeasingBasis;
            this._DatabaseLessLeasingBasis = (DatabaseLessLeasingBasisMBean)object;
            this._postSet(56, databaseLessLeasingBasisMBean, this._DatabaseLessLeasingBasis);
            return;
        }
        if (string.equals("DeathDetectorHeartbeatPeriod")) {
            int n = this._DeathDetectorHeartbeatPeriod;
            this._DeathDetectorHeartbeatPeriod = (Integer)object;
            this._postSet(64, n, this._DeathDetectorHeartbeatPeriod);
            return;
        }
        if (string.equals("DefaultLoadAlgorithm")) {
            String string7 = this._DefaultLoadAlgorithm;
            this._DefaultLoadAlgorithm = (String)object;
            this._postSet(15, string7, this._DefaultLoadAlgorithm);
            return;
        }
        if (string.equals("FencingGracePeriodMillis")) {
            int n = this._FencingGracePeriodMillis;
            this._FencingGracePeriodMillis = (Integer)object;
            this._postSet(44, n, this._FencingGracePeriodMillis);
            return;
        }
        if (string.equals("FrontendHTTPPort")) {
            int n = this._FrontendHTTPPort;
            this._FrontendHTTPPort = (Integer)object;
            this._postSet(25, n, this._FrontendHTTPPort);
            return;
        }
        if (string.equals("FrontendHTTPSPort")) {
            int n = this._FrontendHTTPSPort;
            this._FrontendHTTPSPort = (Integer)object;
            this._postSet(26, n, this._FrontendHTTPSPort);
            return;
        }
        if (string.equals("FrontendHost")) {
            String string8 = this._FrontendHost;
            this._FrontendHost = (String)object;
            this._postSet(24, string8, this._FrontendHost);
            return;
        }
        if (string.equals("GreedySessionFlushInterval")) {
            int n = this._GreedySessionFlushInterval;
            this._GreedySessionFlushInterval = (Integer)object;
            this._postSet(37, n, this._GreedySessionFlushInterval);
            return;
        }
        if (string.equals("HTTPPingRetryCount")) {
            int n = this._HTTPPingRetryCount;
            this._HTTPPingRetryCount = (Integer)object;
            this._postSet(57, n, this._HTTPPingRetryCount);
            return;
        }
        if (string.equals("HealthCheckIntervalMillis")) {
            int n = this._HealthCheckIntervalMillis;
            this._HealthCheckIntervalMillis = (Integer)object;
            this._postSet(42, n, this._HealthCheckIntervalMillis);
            return;
        }
        if (string.equals("HealthCheckPeriodsUntilFencing")) {
            int n = this._HealthCheckPeriodsUntilFencing;
            this._HealthCheckPeriodsUntilFencing = (Integer)object;
            this._postSet(43, n, this._HealthCheckPeriodsUntilFencing);
            return;
        }
        if (string.equals("HttpTraceSupportEnabled")) {
            boolean bl = this._HttpTraceSupportEnabled;
            this._HttpTraceSupportEnabled = (Boolean)object;
            this._postSet(23, bl, this._HttpTraceSupportEnabled);
            return;
        }
        if (string.equals("IdlePeriodsUntilTimeout")) {
            int n = this._IdlePeriodsUntilTimeout;
            this._IdlePeriodsUntilTimeout = (Integer)object;
            this._postSet(27, n, this._IdlePeriodsUntilTimeout);
            return;
        }
        if (string.equals("InterClusterCommLinkHealthCheckInterval")) {
            int n = this._InterClusterCommLinkHealthCheckInterval;
            this._InterClusterCommLinkHealthCheckInterval = (Integer)object;
            this._postSet(31, n, this._InterClusterCommLinkHealthCheckInterval);
            return;
        }
        if (string.equals("JobSchedulerTableName")) {
            String string9 = this._JobSchedulerTableName;
            this._JobSchedulerTableName = (String)object;
            this._postSet(34, string9, this._JobSchedulerTableName);
            return;
        }
        if (string.equals("MaxServerCountForHttpPing")) {
            int n = this._MaxServerCountForHttpPing;
            this._MaxServerCountForHttpPing = (Integer)object;
            this._postSet(58, n, this._MaxServerCountForHttpPing);
            return;
        }
        if (string.equals("MemberDeathDetectorEnabled")) {
            boolean bl = this._MemberDeathDetectorEnabled;
            this._MemberDeathDetectorEnabled = (Boolean)object;
            this._postSet(65, bl, this._MemberDeathDetectorEnabled);
            return;
        }
        if (string.equals("MemberWarmupTimeoutSeconds")) {
            int n = this._MemberWarmupTimeoutSeconds;
            this._MemberWarmupTimeoutSeconds = (Integer)object;
            this._postSet(22, n, this._MemberWarmupTimeoutSeconds);
            return;
        }
        if (string.equals("MessageOrderingEnabled")) {
            boolean bl = this._MessageOrderingEnabled;
            this._MessageOrderingEnabled = (Boolean)object;
            this._postSet(61, bl, this._MessageOrderingEnabled);
            return;
        }
        if (string.equals("MigratableTargets")) {
            MigratableTargetMBean[] migratableTargetMBeanArray = this._MigratableTargets;
            this._MigratableTargets = (MigratableTargetMBean[])object;
            this._postSet(21, migratableTargetMBeanArray, this._MigratableTargets);
            return;
        }
        if (string.equals("MigrationBasis")) {
            String string10 = this._MigrationBasis;
            this._MigrationBasis = (String)object;
            this._postSet(52, string10, this._MigrationBasis);
            return;
        }
        if (string.equals("MillisToSleepBetweenAutoMigrationAttempts")) {
            long l = this._MillisToSleepBetweenAutoMigrationAttempts;
            this._MillisToSleepBetweenAutoMigrationAttempts = (Long)object;
            this._postSet(51, l, this._MillisToSleepBetweenAutoMigrationAttempts);
            return;
        }
        if (string.equals("MulticastAddress")) {
            String string11 = this._MulticastAddress;
            this._MulticastAddress = (String)object;
            this._postSet(10, string11, this._MulticastAddress);
            return;
        }
        if (string.equals("MulticastBufferSize")) {
            int n = this._MulticastBufferSize;
            this._MulticastBufferSize = (Integer)object;
            this._postSet(11, n, this._MulticastBufferSize);
            return;
        }
        if (string.equals("MulticastDataEncryption")) {
            boolean bl = this._MulticastDataEncryption;
            this._MulticastDataEncryption = (Boolean)object;
            this._postSet(48, bl, this._MulticastDataEncryption);
            return;
        }
        if (string.equals("MulticastPort")) {
            int n = this._MulticastPort;
            this._MulticastPort = (Integer)object;
            this._postSet(12, n, this._MulticastPort);
            return;
        }
        if (string.equals("MulticastSendDelay")) {
            int n = this._MulticastSendDelay;
            this._MulticastSendDelay = (Integer)object;
            this._postSet(14, n, this._MulticastSendDelay);
            return;
        }
        if (string.equals("MulticastTTL")) {
            int n = this._MulticastTTL;
            this._MulticastTTL = (Integer)object;
            this._postSet(13, n, this._MulticastTTL);
            return;
        }
        if (string.equals("Name")) {
            String string12 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string12, this._Name);
            return;
        }
        if (string.equals("NumberOfServersInClusterAddress")) {
            int n = this._NumberOfServersInClusterAddress;
            this._NumberOfServersInClusterAddress = (Integer)object;
            this._postSet(46, n, this._NumberOfServersInClusterAddress);
            return;
        }
        if (string.equals("OneWayRmiForReplicationEnabled")) {
            boolean bl = this._OneWayRmiForReplicationEnabled;
            this._OneWayRmiForReplicationEnabled = (Boolean)object;
            this._postSet(62, bl, this._OneWayRmiForReplicationEnabled);
            return;
        }
        if (string.equals("OverloadProtection")) {
            OverloadProtectionMBean overloadProtectionMBean = this._OverloadProtection;
            this._OverloadProtection = (OverloadProtectionMBean)object;
            this._postSet(55, overloadProtectionMBean, this._OverloadProtection);
            return;
        }
        if (string.equals("PersistSessionsOnShutdown")) {
            boolean bl = this._PersistSessionsOnShutdown;
            this._PersistSessionsOnShutdown = (Boolean)object;
            this._postSet(35, bl, this._PersistSessionsOnShutdown);
            return;
        }
        if (string.equals("RemoteClusterAddress")) {
            String string13 = this._RemoteClusterAddress;
            this._RemoteClusterAddress = (String)object;
            this._postSet(28, string13, this._RemoteClusterAddress);
            return;
        }
        if (string.equals("ReplicationChannel")) {
            String string14 = this._ReplicationChannel;
            this._ReplicationChannel = (String)object;
            this._postSet(30, string14, this._ReplicationChannel);
            return;
        }
        if (string.equals("ReplicationTimeoutEnabled")) {
            boolean bl = this._ReplicationTimeoutEnabled;
            this._ReplicationTimeoutEnabled = (Boolean)object;
            this._postSet(54, bl, this._ReplicationTimeoutEnabled);
            return;
        }
        if (string.equals("SecureReplicationEnabled")) {
            boolean bl = this._SecureReplicationEnabled;
            this._SecureReplicationEnabled = (Boolean)object;
            this._postSet(59, bl, this._SecureReplicationEnabled);
            return;
        }
        if (string.equals("ServerNames")) {
            Set set = this._ServerNames;
            this._ServerNames = (Set)object;
            this._postSet(7, set, this._ServerNames);
            return;
        }
        if (string.equals("Servers")) {
            ServerMBean[] serverMBeanArray = this._Servers;
            this._Servers = (ServerMBean[])object;
            this._postSet(8, serverMBeanArray, this._Servers);
            return;
        }
        if (string.equals("ServiceAgeThresholdSeconds")) {
            int n = this._ServiceAgeThresholdSeconds;
            this._ServiceAgeThresholdSeconds = (Integer)object;
            this._postSet(18, n, this._ServiceAgeThresholdSeconds);
            return;
        }
        if (string.equals("SessionFlushInterval")) {
            int n = this._SessionFlushInterval;
            this._SessionFlushInterval = (Integer)object;
            this._postSet(38, n, this._SessionFlushInterval);
            return;
        }
        if (string.equals("SessionFlushThreshold")) {
            int n = this._SessionFlushThreshold;
            this._SessionFlushThreshold = (Integer)object;
            this._postSet(39, n, this._SessionFlushThreshold);
            return;
        }
        if (string.equals("SessionLazyDeserializationEnabled")) {
            boolean bl = this._SessionLazyDeserializationEnabled;
            this._SessionLazyDeserializationEnabled = (Boolean)object;
            this._postSet(63, bl, this._SessionLazyDeserializationEnabled);
            return;
        }
        if (string.equals("SingletonSQLQueryHelper")) {
            String string15 = this._SingletonSQLQueryHelper;
            this._SingletonSQLQueryHelper = (String)object;
            this._postSet(45, string15, this._SingletonSQLQueryHelper);
            return;
        }
        if (string.equals("UnicastDiscoveryPeriodMillis")) {
            int n = this._UnicastDiscoveryPeriodMillis;
            this._UnicastDiscoveryPeriodMillis = (Integer)object;
            this._postSet(60, n, this._UnicastDiscoveryPeriodMillis);
            return;
        }
        if (string.equals("WANSessionPersistenceTableName")) {
            String string16 = this._WANSessionPersistenceTableName;
            this._WANSessionPersistenceTableName = (String)object;
            this._postSet(29, string16, this._WANSessionPersistenceTableName);
            return;
        }
        if (string.equals("WeblogicPluginEnabled")) {
            boolean bl = this._WeblogicPluginEnabled;
            this._WeblogicPluginEnabled = (Boolean)object;
            this._postSet(20, bl, this._WeblogicPluginEnabled);
            return;
        }
        if (string.equals("customizer")) {
            Cluster cluster = this._customizer;
            this._customizer = (Cluster)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AdditionalAutoMigrationAttempts")) {
            return new Integer(this._AdditionalAutoMigrationAttempts);
        }
        if (string.equals("AsyncSessionQueueTimeout")) {
            return new Integer(this._AsyncSessionQueueTimeout);
        }
        if (string.equals("AutoMigrationTableName")) {
            return this._AutoMigrationTableName;
        }
        if (string.equals("CandidateMachinesForMigratableServers")) {
            return this._CandidateMachinesForMigratableServers;
        }
        if (string.equals("ClientCertProxyEnabled")) {
            return new Boolean(this._ClientCertProxyEnabled);
        }
        if (string.equals("ClusterAddress")) {
            return this._ClusterAddress;
        }
        if (string.equals("ClusterBroadcastChannel")) {
            return this._ClusterBroadcastChannel;
        }
        if (string.equals("ClusterMessagingMode")) {
            return this._ClusterMessagingMode;
        }
        if (string.equals("ClusterType")) {
            return this._ClusterType;
        }
        if (string.equals("ConsensusParticipants")) {
            return new Integer(this._ConsensusParticipants);
        }
        if (string.equals("DataSourceForAutomaticMigration")) {
            return this._DataSourceForAutomaticMigration;
        }
        if (string.equals("DataSourceForJobScheduler")) {
            return this._DataSourceForJobScheduler;
        }
        if (string.equals("DataSourceForSessionPersistence")) {
            return this._DataSourceForSessionPersistence;
        }
        if (string.equals("DatabaseLessLeasingBasis")) {
            return this._DatabaseLessLeasingBasis;
        }
        if (string.equals("DeathDetectorHeartbeatPeriod")) {
            return new Integer(this._DeathDetectorHeartbeatPeriod);
        }
        if (string.equals("DefaultLoadAlgorithm")) {
            return this._DefaultLoadAlgorithm;
        }
        if (string.equals("FencingGracePeriodMillis")) {
            return new Integer(this._FencingGracePeriodMillis);
        }
        if (string.equals("FrontendHTTPPort")) {
            return new Integer(this._FrontendHTTPPort);
        }
        if (string.equals("FrontendHTTPSPort")) {
            return new Integer(this._FrontendHTTPSPort);
        }
        if (string.equals("FrontendHost")) {
            return this._FrontendHost;
        }
        if (string.equals("GreedySessionFlushInterval")) {
            return new Integer(this._GreedySessionFlushInterval);
        }
        if (string.equals("HTTPPingRetryCount")) {
            return new Integer(this._HTTPPingRetryCount);
        }
        if (string.equals("HealthCheckIntervalMillis")) {
            return new Integer(this._HealthCheckIntervalMillis);
        }
        if (string.equals("HealthCheckPeriodsUntilFencing")) {
            return new Integer(this._HealthCheckPeriodsUntilFencing);
        }
        if (string.equals("HttpTraceSupportEnabled")) {
            return new Boolean(this._HttpTraceSupportEnabled);
        }
        if (string.equals("IdlePeriodsUntilTimeout")) {
            return new Integer(this._IdlePeriodsUntilTimeout);
        }
        if (string.equals("InterClusterCommLinkHealthCheckInterval")) {
            return new Integer(this._InterClusterCommLinkHealthCheckInterval);
        }
        if (string.equals("JobSchedulerTableName")) {
            return this._JobSchedulerTableName;
        }
        if (string.equals("MaxServerCountForHttpPing")) {
            return new Integer(this._MaxServerCountForHttpPing);
        }
        if (string.equals("MemberDeathDetectorEnabled")) {
            return new Boolean(this._MemberDeathDetectorEnabled);
        }
        if (string.equals("MemberWarmupTimeoutSeconds")) {
            return new Integer(this._MemberWarmupTimeoutSeconds);
        }
        if (string.equals("MessageOrderingEnabled")) {
            return new Boolean(this._MessageOrderingEnabled);
        }
        if (string.equals("MigratableTargets")) {
            return this._MigratableTargets;
        }
        if (string.equals("MigrationBasis")) {
            return this._MigrationBasis;
        }
        if (string.equals("MillisToSleepBetweenAutoMigrationAttempts")) {
            return new Long(this._MillisToSleepBetweenAutoMigrationAttempts);
        }
        if (string.equals("MulticastAddress")) {
            return this._MulticastAddress;
        }
        if (string.equals("MulticastBufferSize")) {
            return new Integer(this._MulticastBufferSize);
        }
        if (string.equals("MulticastDataEncryption")) {
            return new Boolean(this._MulticastDataEncryption);
        }
        if (string.equals("MulticastPort")) {
            return new Integer(this._MulticastPort);
        }
        if (string.equals("MulticastSendDelay")) {
            return new Integer(this._MulticastSendDelay);
        }
        if (string.equals("MulticastTTL")) {
            return new Integer(this._MulticastTTL);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("NumberOfServersInClusterAddress")) {
            return new Integer(this._NumberOfServersInClusterAddress);
        }
        if (string.equals("OneWayRmiForReplicationEnabled")) {
            return new Boolean(this._OneWayRmiForReplicationEnabled);
        }
        if (string.equals("OverloadProtection")) {
            return this._OverloadProtection;
        }
        if (string.equals("PersistSessionsOnShutdown")) {
            return new Boolean(this._PersistSessionsOnShutdown);
        }
        if (string.equals("RemoteClusterAddress")) {
            return this._RemoteClusterAddress;
        }
        if (string.equals("ReplicationChannel")) {
            return this._ReplicationChannel;
        }
        if (string.equals("ReplicationTimeoutEnabled")) {
            return new Boolean(this._ReplicationTimeoutEnabled);
        }
        if (string.equals("SecureReplicationEnabled")) {
            return new Boolean(this._SecureReplicationEnabled);
        }
        if (string.equals("ServerNames")) {
            return this._ServerNames;
        }
        if (string.equals("Servers")) {
            return this._Servers;
        }
        if (string.equals("ServiceAgeThresholdSeconds")) {
            return new Integer(this._ServiceAgeThresholdSeconds);
        }
        if (string.equals("SessionFlushInterval")) {
            return new Integer(this._SessionFlushInterval);
        }
        if (string.equals("SessionFlushThreshold")) {
            return new Integer(this._SessionFlushThreshold);
        }
        if (string.equals("SessionLazyDeserializationEnabled")) {
            return new Boolean(this._SessionLazyDeserializationEnabled);
        }
        if (string.equals("SingletonSQLQueryHelper")) {
            return this._SingletonSQLQueryHelper;
        }
        if (string.equals("UnicastDiscoveryPeriodMillis")) {
            return new Integer(this._UnicastDiscoveryPeriodMillis);
        }
        if (string.equals("WANSessionPersistenceTableName")) {
            return this._WANSessionPersistenceTableName;
        }
        if (string.equals("WeblogicPluginEnabled")) {
            return new Boolean(this._WeblogicPluginEnabled);
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends TargetMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 34: {
                    if (string.equals("additional-auto-migration-attempts")) {
                        return 50;
                    }
                    if (string.equals("health-check-periods-until-fencing")) {
                        return 43;
                    }
                    if (!string.equals("wan-session-persistence-table-name")) break;
                    return 29;
                }
                case 27: {
                    if (string.equals("async-session-queue-timeout")) {
                        return 36;
                    }
                    if (string.equals("database-less-leasing-basis")) {
                        return 56;
                    }
                    if (string.equals("fencing-grace-period-millis")) {
                        return 44;
                    }
                    if (!string.equals("replication-timeout-enabled")) break;
                    return 54;
                }
                case 25: {
                    if (string.equals("auto-migration-table-name")) {
                        return 49;
                    }
                    if (string.equals("cluster-broadcast-channel")) {
                        return 17;
                    }
                    if (string.equals("multicast-data-encryption")) {
                        return 48;
                    }
                    if (!string.equals("client-cert-proxy-enabled")) break;
                    return 19;
                }
                case 40: {
                    if (!string.equals("candidate-machines-for-migratable-server")) break;
                    return 40;
                }
                case 15: {
                    if (string.equals("cluster-address")) {
                        return 9;
                    }
                    if (!string.equals("migration-basis")) break;
                    return 52;
                }
                case 22: {
                    if (string.equals("cluster-messaging-mode")) {
                        return 16;
                    }
                    if (string.equals("consensus-participants")) {
                        return 53;
                    }
                    if (string.equals("default-load-algorithm")) {
                        return 15;
                    }
                    if (string.equals("remote-cluster-address")) {
                        return 28;
                    }
                    if (!string.equals("session-flush-interval")) break;
                    return 38;
                }
                case 12: {
                    if (string.equals("cluster-type")) {
                        return 47;
                    }
                    if (string.equals("multicastttl")) {
                        return 13;
                    }
                    if (!string.equals("server-names")) break;
                    return 7;
                }
                case 35: {
                    if (string.equals("data-source-for-automatic-migration")) {
                        return 41;
                    }
                    if (string.equals("data-source-for-session-persistence")) {
                        return 32;
                    }
                    if (!string.equals("one-way-rmi-for-replication-enabled")) break;
                    return 62;
                }
                case 29: {
                    if (string.equals("data-source-for-job-scheduler")) {
                        return 33;
                    }
                    if (string.equals("greedy-session-flush-interval")) {
                        return 37;
                    }
                    if (string.equals("member-warmup-timeout-seconds")) {
                        return 22;
                    }
                    if (string.equals("service-age-threshold-seconds")) {
                        return 18;
                    }
                    if (!string.equals("member-death-detector-enabled")) break;
                    return 65;
                }
                case 31: {
                    if (string.equals("death-detector-heartbeat-period")) {
                        return 64;
                    }
                    if (!string.equals("unicast-discovery-period-millis")) break;
                    return 60;
                }
                case 17: {
                    if (string.equals("frontendhttp-port")) {
                        return 25;
                    }
                    if (string.equals("migratable-target")) {
                        return 21;
                    }
                    if (!string.equals("multicast-address")) break;
                    return 10;
                }
                case 18: {
                    if (!string.equals("frontendhttps-port")) break;
                    return 26;
                }
                case 13: {
                    if (!string.equals("frontend-host")) break;
                    return 24;
                }
                case 21: {
                    if (string.equals("http-ping-retry-count")) {
                        return 57;
                    }
                    if (!string.equals("multicast-buffer-size")) break;
                    return 11;
                }
                case 28: {
                    if (string.equals("health-check-interval-millis")) {
                        return 42;
                    }
                    if (!string.equals("persist-sessions-on-shutdown")) break;
                    return 35;
                }
                case 26: {
                    if (string.equals("idle-periods-until-timeout")) {
                        return 27;
                    }
                    if (string.equals("singleton-sql-query-helper")) {
                        return 45;
                    }
                    if (string.equals("http-trace-support-enabled")) {
                        return 23;
                    }
                    if (!string.equals("secure-replication-enabled")) break;
                    return 59;
                }
                case 45: {
                    if (!string.equals("inter-cluster-comm-link-health-check-interval")) break;
                    return 31;
                }
                case 24: {
                    if (string.equals("job-scheduler-table-name")) {
                        return 34;
                    }
                    if (!string.equals("message-ordering-enabled")) break;
                    return 61;
                }
                case 30: {
                    if (!string.equals("max-server-count-for-http-ping")) break;
                    return 58;
                }
                case 47: {
                    if (!string.equals("millis-to-sleep-between-auto-migration-attempts")) break;
                    return 51;
                }
                case 14: {
                    if (!string.equals("multicast-port")) break;
                    return 12;
                }
                case 20: {
                    if (!string.equals("multicast-send-delay")) break;
                    return 14;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 36: {
                    if (string.equals("number-of-servers-in-cluster-address")) {
                        return 46;
                    }
                    if (!string.equals("session-lazy-deserialization-enabled")) break;
                    return 63;
                }
                case 19: {
                    if (string.equals("overload-protection")) {
                        return 55;
                    }
                    if (!string.equals("replication-channel")) break;
                    return 30;
                }
                case 6: {
                    if (!string.equals("server")) break;
                    return 8;
                }
                case 23: {
                    if (string.equals("session-flush-threshold")) {
                        return 39;
                    }
                    if (!string.equals("weblogic-plugin-enabled")) break;
                    return 20;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                case 56: {
                    return new DatabaseLessLeasingBasisMBeanImpl.SchemaHelper2();
                }
                case 55: {
                    return new OverloadProtectionMBeanImpl.SchemaHelper2();
                }
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 50: {
                    return "additional-auto-migration-attempts";
                }
                case 36: {
                    return "async-session-queue-timeout";
                }
                case 49: {
                    return "auto-migration-table-name";
                }
                case 40: {
                    return "candidate-machines-for-migratable-server";
                }
                case 9: {
                    return "cluster-address";
                }
                case 17: {
                    return "cluster-broadcast-channel";
                }
                case 16: {
                    return "cluster-messaging-mode";
                }
                case 47: {
                    return "cluster-type";
                }
                case 53: {
                    return "consensus-participants";
                }
                case 41: {
                    return "data-source-for-automatic-migration";
                }
                case 33: {
                    return "data-source-for-job-scheduler";
                }
                case 32: {
                    return "data-source-for-session-persistence";
                }
                case 56: {
                    return "database-less-leasing-basis";
                }
                case 64: {
                    return "death-detector-heartbeat-period";
                }
                case 15: {
                    return "default-load-algorithm";
                }
                case 44: {
                    return "fencing-grace-period-millis";
                }
                case 25: {
                    return "frontendhttp-port";
                }
                case 26: {
                    return "frontendhttps-port";
                }
                case 24: {
                    return "frontend-host";
                }
                case 37: {
                    return "greedy-session-flush-interval";
                }
                case 57: {
                    return "http-ping-retry-count";
                }
                case 42: {
                    return "health-check-interval-millis";
                }
                case 43: {
                    return "health-check-periods-until-fencing";
                }
                case 27: {
                    return "idle-periods-until-timeout";
                }
                case 31: {
                    return "inter-cluster-comm-link-health-check-interval";
                }
                case 34: {
                    return "job-scheduler-table-name";
                }
                case 58: {
                    return "max-server-count-for-http-ping";
                }
                case 22: {
                    return "member-warmup-timeout-seconds";
                }
                case 21: {
                    return "migratable-target";
                }
                case 52: {
                    return "migration-basis";
                }
                case 51: {
                    return "millis-to-sleep-between-auto-migration-attempts";
                }
                case 10: {
                    return "multicast-address";
                }
                case 11: {
                    return "multicast-buffer-size";
                }
                case 48: {
                    return "multicast-data-encryption";
                }
                case 12: {
                    return "multicast-port";
                }
                case 14: {
                    return "multicast-send-delay";
                }
                case 13: {
                    return "multicastttl";
                }
                case 2: {
                    return "name";
                }
                case 46: {
                    return "number-of-servers-in-cluster-address";
                }
                case 55: {
                    return "overload-protection";
                }
                case 35: {
                    return "persist-sessions-on-shutdown";
                }
                case 28: {
                    return "remote-cluster-address";
                }
                case 30: {
                    return "replication-channel";
                }
                case 7: {
                    return "server-names";
                }
                case 8: {
                    return "server";
                }
                case 18: {
                    return "service-age-threshold-seconds";
                }
                case 38: {
                    return "session-flush-interval";
                }
                case 39: {
                    return "session-flush-threshold";
                }
                case 45: {
                    return "singleton-sql-query-helper";
                }
                case 60: {
                    return "unicast-discovery-period-millis";
                }
                case 29: {
                    return "wan-session-persistence-table-name";
                }
                case 19: {
                    return "client-cert-proxy-enabled";
                }
                case 23: {
                    return "http-trace-support-enabled";
                }
                case 65: {
                    return "member-death-detector-enabled";
                }
                case 61: {
                    return "message-ordering-enabled";
                }
                case 62: {
                    return "one-way-rmi-for-replication-enabled";
                }
                case 54: {
                    return "replication-timeout-enabled";
                }
                case 59: {
                    return "secure-replication-enabled";
                }
                case 63: {
                    return "session-lazy-deserialization-enabled";
                }
                case 20: {
                    return "weblogic-plugin-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 40: {
                    return true;
                }
                case 21: {
                    return true;
                }
                case 8: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                case 56: {
                    return true;
                }
                case 55: {
                    return true;
                }
            }
            return super.isBean(n);
        }

        public boolean isConfigurable(int n) {
            switch (n) {
                case 9: {
                    return true;
                }
                case 17: {
                    return true;
                }
                case 16: {
                    return true;
                }
                case 53: {
                    return true;
                }
                case 64: {
                    return true;
                }
                case 15: {
                    return true;
                }
                case 25: {
                    return true;
                }
                case 26: {
                    return true;
                }
                case 24: {
                    return true;
                }
                case 57: {
                    return true;
                }
                case 52: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 11: {
                    return true;
                }
                case 12: {
                    return true;
                }
                case 14: {
                    return true;
                }
                case 13: {
                    return true;
                }
                case 18: {
                    return true;
                }
                case 60: {
                    return true;
                }
                case 59: {
                    return true;
                }
            }
            return super.isConfigurable(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends TargetMBeanImpl.Helper {
        private ClusterMBeanImpl bean;

        protected Helper(ClusterMBeanImpl clusterMBeanImpl) {
            super(clusterMBeanImpl);
            this.bean = clusterMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 50: {
                    return "AdditionalAutoMigrationAttempts";
                }
                case 36: {
                    return "AsyncSessionQueueTimeout";
                }
                case 49: {
                    return "AutoMigrationTableName";
                }
                case 40: {
                    return "CandidateMachinesForMigratableServers";
                }
                case 9: {
                    return "ClusterAddress";
                }
                case 17: {
                    return "ClusterBroadcastChannel";
                }
                case 16: {
                    return "ClusterMessagingMode";
                }
                case 47: {
                    return "ClusterType";
                }
                case 53: {
                    return "ConsensusParticipants";
                }
                case 41: {
                    return "DataSourceForAutomaticMigration";
                }
                case 33: {
                    return "DataSourceForJobScheduler";
                }
                case 32: {
                    return "DataSourceForSessionPersistence";
                }
                case 56: {
                    return "DatabaseLessLeasingBasis";
                }
                case 64: {
                    return "DeathDetectorHeartbeatPeriod";
                }
                case 15: {
                    return "DefaultLoadAlgorithm";
                }
                case 44: {
                    return "FencingGracePeriodMillis";
                }
                case 25: {
                    return "FrontendHTTPPort";
                }
                case 26: {
                    return "FrontendHTTPSPort";
                }
                case 24: {
                    return "FrontendHost";
                }
                case 37: {
                    return "GreedySessionFlushInterval";
                }
                case 57: {
                    return "HTTPPingRetryCount";
                }
                case 42: {
                    return "HealthCheckIntervalMillis";
                }
                case 43: {
                    return "HealthCheckPeriodsUntilFencing";
                }
                case 27: {
                    return "IdlePeriodsUntilTimeout";
                }
                case 31: {
                    return "InterClusterCommLinkHealthCheckInterval";
                }
                case 34: {
                    return "JobSchedulerTableName";
                }
                case 58: {
                    return "MaxServerCountForHttpPing";
                }
                case 22: {
                    return "MemberWarmupTimeoutSeconds";
                }
                case 21: {
                    return "MigratableTargets";
                }
                case 52: {
                    return "MigrationBasis";
                }
                case 51: {
                    return "MillisToSleepBetweenAutoMigrationAttempts";
                }
                case 10: {
                    return "MulticastAddress";
                }
                case 11: {
                    return "MulticastBufferSize";
                }
                case 48: {
                    return "MulticastDataEncryption";
                }
                case 12: {
                    return "MulticastPort";
                }
                case 14: {
                    return "MulticastSendDelay";
                }
                case 13: {
                    return "MulticastTTL";
                }
                case 2: {
                    return "Name";
                }
                case 46: {
                    return "NumberOfServersInClusterAddress";
                }
                case 55: {
                    return "OverloadProtection";
                }
                case 35: {
                    return "PersistSessionsOnShutdown";
                }
                case 28: {
                    return "RemoteClusterAddress";
                }
                case 30: {
                    return "ReplicationChannel";
                }
                case 7: {
                    return "ServerNames";
                }
                case 8: {
                    return "Servers";
                }
                case 18: {
                    return "ServiceAgeThresholdSeconds";
                }
                case 38: {
                    return "SessionFlushInterval";
                }
                case 39: {
                    return "SessionFlushThreshold";
                }
                case 45: {
                    return "SingletonSQLQueryHelper";
                }
                case 60: {
                    return "UnicastDiscoveryPeriodMillis";
                }
                case 29: {
                    return "WANSessionPersistenceTableName";
                }
                case 19: {
                    return "ClientCertProxyEnabled";
                }
                case 23: {
                    return "HttpTraceSupportEnabled";
                }
                case 65: {
                    return "MemberDeathDetectorEnabled";
                }
                case 61: {
                    return "MessageOrderingEnabled";
                }
                case 62: {
                    return "OneWayRmiForReplicationEnabled";
                }
                case 54: {
                    return "ReplicationTimeoutEnabled";
                }
                case 59: {
                    return "SecureReplicationEnabled";
                }
                case 63: {
                    return "SessionLazyDeserializationEnabled";
                }
                case 20: {
                    return "WeblogicPluginEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("AdditionalAutoMigrationAttempts")) {
                return 50;
            }
            if (string.equals("AsyncSessionQueueTimeout")) {
                return 36;
            }
            if (string.equals("AutoMigrationTableName")) {
                return 49;
            }
            if (string.equals("CandidateMachinesForMigratableServers")) {
                return 40;
            }
            if (string.equals("ClusterAddress")) {
                return 9;
            }
            if (string.equals("ClusterBroadcastChannel")) {
                return 17;
            }
            if (string.equals("ClusterMessagingMode")) {
                return 16;
            }
            if (string.equals("ClusterType")) {
                return 47;
            }
            if (string.equals("ConsensusParticipants")) {
                return 53;
            }
            if (string.equals("DataSourceForAutomaticMigration")) {
                return 41;
            }
            if (string.equals("DataSourceForJobScheduler")) {
                return 33;
            }
            if (string.equals("DataSourceForSessionPersistence")) {
                return 32;
            }
            if (string.equals("DatabaseLessLeasingBasis")) {
                return 56;
            }
            if (string.equals("DeathDetectorHeartbeatPeriod")) {
                return 64;
            }
            if (string.equals("DefaultLoadAlgorithm")) {
                return 15;
            }
            if (string.equals("FencingGracePeriodMillis")) {
                return 44;
            }
            if (string.equals("FrontendHTTPPort")) {
                return 25;
            }
            if (string.equals("FrontendHTTPSPort")) {
                return 26;
            }
            if (string.equals("FrontendHost")) {
                return 24;
            }
            if (string.equals("GreedySessionFlushInterval")) {
                return 37;
            }
            if (string.equals("HTTPPingRetryCount")) {
                return 57;
            }
            if (string.equals("HealthCheckIntervalMillis")) {
                return 42;
            }
            if (string.equals("HealthCheckPeriodsUntilFencing")) {
                return 43;
            }
            if (string.equals("IdlePeriodsUntilTimeout")) {
                return 27;
            }
            if (string.equals("InterClusterCommLinkHealthCheckInterval")) {
                return 31;
            }
            if (string.equals("JobSchedulerTableName")) {
                return 34;
            }
            if (string.equals("MaxServerCountForHttpPing")) {
                return 58;
            }
            if (string.equals("MemberWarmupTimeoutSeconds")) {
                return 22;
            }
            if (string.equals("MigratableTargets")) {
                return 21;
            }
            if (string.equals("MigrationBasis")) {
                return 52;
            }
            if (string.equals("MillisToSleepBetweenAutoMigrationAttempts")) {
                return 51;
            }
            if (string.equals("MulticastAddress")) {
                return 10;
            }
            if (string.equals("MulticastBufferSize")) {
                return 11;
            }
            if (string.equals("MulticastDataEncryption")) {
                return 48;
            }
            if (string.equals("MulticastPort")) {
                return 12;
            }
            if (string.equals("MulticastSendDelay")) {
                return 14;
            }
            if (string.equals("MulticastTTL")) {
                return 13;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("NumberOfServersInClusterAddress")) {
                return 46;
            }
            if (string.equals("OverloadProtection")) {
                return 55;
            }
            if (string.equals("PersistSessionsOnShutdown")) {
                return 35;
            }
            if (string.equals("RemoteClusterAddress")) {
                return 28;
            }
            if (string.equals("ReplicationChannel")) {
                return 30;
            }
            if (string.equals("ServerNames")) {
                return 7;
            }
            if (string.equals("Servers")) {
                return 8;
            }
            if (string.equals("ServiceAgeThresholdSeconds")) {
                return 18;
            }
            if (string.equals("SessionFlushInterval")) {
                return 38;
            }
            if (string.equals("SessionFlushThreshold")) {
                return 39;
            }
            if (string.equals("SingletonSQLQueryHelper")) {
                return 45;
            }
            if (string.equals("UnicastDiscoveryPeriodMillis")) {
                return 60;
            }
            if (string.equals("WANSessionPersistenceTableName")) {
                return 29;
            }
            if (string.equals("ClientCertProxyEnabled")) {
                return 19;
            }
            if (string.equals("HttpTraceSupportEnabled")) {
                return 23;
            }
            if (string.equals("MemberDeathDetectorEnabled")) {
                return 65;
            }
            if (string.equals("MessageOrderingEnabled")) {
                return 61;
            }
            if (string.equals("OneWayRmiForReplicationEnabled")) {
                return 62;
            }
            if (string.equals("ReplicationTimeoutEnabled")) {
                return 54;
            }
            if (string.equals("SecureReplicationEnabled")) {
                return 59;
            }
            if (string.equals("SessionLazyDeserializationEnabled")) {
                return 63;
            }
            if (string.equals("WeblogicPluginEnabled")) {
                return 20;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList<ArrayIterator> arrayList = new ArrayList<ArrayIterator>();
            if (this.bean.getDatabaseLessLeasingBasis() != null) {
                arrayList.add(new ArrayIterator((Object[])new DatabaseLessLeasingBasisMBean[]{this.bean.getDatabaseLessLeasingBasis()}));
            }
            if (this.bean.getOverloadProtection() != null) {
                arrayList.add(new ArrayIterator((Object[])new OverloadProtectionMBean[]{this.bean.getOverloadProtection()}));
            }
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isAdditionalAutoMigrationAttemptsSet()) {
                    stringBuffer.append("AdditionalAutoMigrationAttempts");
                    stringBuffer.append(String.valueOf(this.bean.getAdditionalAutoMigrationAttempts()));
                }
                if (this.bean.isAsyncSessionQueueTimeoutSet()) {
                    stringBuffer.append("AsyncSessionQueueTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getAsyncSessionQueueTimeout()));
                }
                if (this.bean.isAutoMigrationTableNameSet()) {
                    stringBuffer.append("AutoMigrationTableName");
                    stringBuffer.append(String.valueOf(this.bean.getAutoMigrationTableName()));
                }
                if (this.bean.isCandidateMachinesForMigratableServersSet()) {
                    stringBuffer.append("CandidateMachinesForMigratableServers");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getCandidateMachinesForMigratableServers())));
                }
                if (this.bean.isClusterAddressSet()) {
                    stringBuffer.append("ClusterAddress");
                    stringBuffer.append(String.valueOf(this.bean.getClusterAddress()));
                }
                if (this.bean.isClusterBroadcastChannelSet()) {
                    stringBuffer.append("ClusterBroadcastChannel");
                    stringBuffer.append(String.valueOf(this.bean.getClusterBroadcastChannel()));
                }
                if (this.bean.isClusterMessagingModeSet()) {
                    stringBuffer.append("ClusterMessagingMode");
                    stringBuffer.append(String.valueOf(this.bean.getClusterMessagingMode()));
                }
                if (this.bean.isClusterTypeSet()) {
                    stringBuffer.append("ClusterType");
                    stringBuffer.append(String.valueOf(this.bean.getClusterType()));
                }
                if (this.bean.isConsensusParticipantsSet()) {
                    stringBuffer.append("ConsensusParticipants");
                    stringBuffer.append(String.valueOf(this.bean.getConsensusParticipants()));
                }
                if (this.bean.isDataSourceForAutomaticMigrationSet()) {
                    stringBuffer.append("DataSourceForAutomaticMigration");
                    stringBuffer.append(String.valueOf(this.bean.getDataSourceForAutomaticMigration()));
                }
                if (this.bean.isDataSourceForJobSchedulerSet()) {
                    stringBuffer.append("DataSourceForJobScheduler");
                    stringBuffer.append(String.valueOf(this.bean.getDataSourceForJobScheduler()));
                }
                if (this.bean.isDataSourceForSessionPersistenceSet()) {
                    stringBuffer.append("DataSourceForSessionPersistence");
                    stringBuffer.append(String.valueOf(this.bean.getDataSourceForSessionPersistence()));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getDatabaseLessLeasingBasis())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isDeathDetectorHeartbeatPeriodSet()) {
                    stringBuffer.append("DeathDetectorHeartbeatPeriod");
                    stringBuffer.append(String.valueOf(this.bean.getDeathDetectorHeartbeatPeriod()));
                }
                if (this.bean.isDefaultLoadAlgorithmSet()) {
                    stringBuffer.append("DefaultLoadAlgorithm");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultLoadAlgorithm()));
                }
                if (this.bean.isFencingGracePeriodMillisSet()) {
                    stringBuffer.append("FencingGracePeriodMillis");
                    stringBuffer.append(String.valueOf(this.bean.getFencingGracePeriodMillis()));
                }
                if (this.bean.isFrontendHTTPPortSet()) {
                    stringBuffer.append("FrontendHTTPPort");
                    stringBuffer.append(String.valueOf(this.bean.getFrontendHTTPPort()));
                }
                if (this.bean.isFrontendHTTPSPortSet()) {
                    stringBuffer.append("FrontendHTTPSPort");
                    stringBuffer.append(String.valueOf(this.bean.getFrontendHTTPSPort()));
                }
                if (this.bean.isFrontendHostSet()) {
                    stringBuffer.append("FrontendHost");
                    stringBuffer.append(String.valueOf(this.bean.getFrontendHost()));
                }
                if (this.bean.isGreedySessionFlushIntervalSet()) {
                    stringBuffer.append("GreedySessionFlushInterval");
                    stringBuffer.append(String.valueOf(this.bean.getGreedySessionFlushInterval()));
                }
                if (this.bean.isHTTPPingRetryCountSet()) {
                    stringBuffer.append("HTTPPingRetryCount");
                    stringBuffer.append(String.valueOf(this.bean.getHTTPPingRetryCount()));
                }
                if (this.bean.isHealthCheckIntervalMillisSet()) {
                    stringBuffer.append("HealthCheckIntervalMillis");
                    stringBuffer.append(String.valueOf(this.bean.getHealthCheckIntervalMillis()));
                }
                if (this.bean.isHealthCheckPeriodsUntilFencingSet()) {
                    stringBuffer.append("HealthCheckPeriodsUntilFencing");
                    stringBuffer.append(String.valueOf(this.bean.getHealthCheckPeriodsUntilFencing()));
                }
                if (this.bean.isIdlePeriodsUntilTimeoutSet()) {
                    stringBuffer.append("IdlePeriodsUntilTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getIdlePeriodsUntilTimeout()));
                }
                if (this.bean.isInterClusterCommLinkHealthCheckIntervalSet()) {
                    stringBuffer.append("InterClusterCommLinkHealthCheckInterval");
                    stringBuffer.append(String.valueOf(this.bean.getInterClusterCommLinkHealthCheckInterval()));
                }
                if (this.bean.isJobSchedulerTableNameSet()) {
                    stringBuffer.append("JobSchedulerTableName");
                    stringBuffer.append(String.valueOf(this.bean.getJobSchedulerTableName()));
                }
                if (this.bean.isMaxServerCountForHttpPingSet()) {
                    stringBuffer.append("MaxServerCountForHttpPing");
                    stringBuffer.append(String.valueOf(this.bean.getMaxServerCountForHttpPing()));
                }
                if (this.bean.isMemberWarmupTimeoutSecondsSet()) {
                    stringBuffer.append("MemberWarmupTimeoutSeconds");
                    stringBuffer.append(String.valueOf(this.bean.getMemberWarmupTimeoutSeconds()));
                }
                if (this.bean.isMigratableTargetsSet()) {
                    stringBuffer.append("MigratableTargets");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getMigratableTargets())));
                }
                if (this.bean.isMigrationBasisSet()) {
                    stringBuffer.append("MigrationBasis");
                    stringBuffer.append(String.valueOf(this.bean.getMigrationBasis()));
                }
                if (this.bean.isMillisToSleepBetweenAutoMigrationAttemptsSet()) {
                    stringBuffer.append("MillisToSleepBetweenAutoMigrationAttempts");
                    stringBuffer.append(String.valueOf(this.bean.getMillisToSleepBetweenAutoMigrationAttempts()));
                }
                if (this.bean.isMulticastAddressSet()) {
                    stringBuffer.append("MulticastAddress");
                    stringBuffer.append(String.valueOf(this.bean.getMulticastAddress()));
                }
                if (this.bean.isMulticastBufferSizeSet()) {
                    stringBuffer.append("MulticastBufferSize");
                    stringBuffer.append(String.valueOf(this.bean.getMulticastBufferSize()));
                }
                if (this.bean.isMulticastDataEncryptionSet()) {
                    stringBuffer.append("MulticastDataEncryption");
                    stringBuffer.append(String.valueOf(this.bean.getMulticastDataEncryption()));
                }
                if (this.bean.isMulticastPortSet()) {
                    stringBuffer.append("MulticastPort");
                    stringBuffer.append(String.valueOf(this.bean.getMulticastPort()));
                }
                if (this.bean.isMulticastSendDelaySet()) {
                    stringBuffer.append("MulticastSendDelay");
                    stringBuffer.append(String.valueOf(this.bean.getMulticastSendDelay()));
                }
                if (this.bean.isMulticastTTLSet()) {
                    stringBuffer.append("MulticastTTL");
                    stringBuffer.append(String.valueOf(this.bean.getMulticastTTL()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isNumberOfServersInClusterAddressSet()) {
                    stringBuffer.append("NumberOfServersInClusterAddress");
                    stringBuffer.append(String.valueOf(this.bean.getNumberOfServersInClusterAddress()));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getOverloadProtection())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isPersistSessionsOnShutdownSet()) {
                    stringBuffer.append("PersistSessionsOnShutdown");
                    stringBuffer.append(String.valueOf(this.bean.getPersistSessionsOnShutdown()));
                }
                if (this.bean.isRemoteClusterAddressSet()) {
                    stringBuffer.append("RemoteClusterAddress");
                    stringBuffer.append(String.valueOf(this.bean.getRemoteClusterAddress()));
                }
                if (this.bean.isReplicationChannelSet()) {
                    stringBuffer.append("ReplicationChannel");
                    stringBuffer.append(String.valueOf(this.bean.getReplicationChannel()));
                }
                if (this.bean.isServerNamesSet()) {
                    stringBuffer.append("ServerNames");
                    stringBuffer.append(String.valueOf(this.bean.getServerNames()));
                }
                if (this.bean.isServersSet()) {
                    stringBuffer.append("Servers");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getServers())));
                }
                if (this.bean.isServiceAgeThresholdSecondsSet()) {
                    stringBuffer.append("ServiceAgeThresholdSeconds");
                    stringBuffer.append(String.valueOf(this.bean.getServiceAgeThresholdSeconds()));
                }
                if (this.bean.isSessionFlushIntervalSet()) {
                    stringBuffer.append("SessionFlushInterval");
                    stringBuffer.append(String.valueOf(this.bean.getSessionFlushInterval()));
                }
                if (this.bean.isSessionFlushThresholdSet()) {
                    stringBuffer.append("SessionFlushThreshold");
                    stringBuffer.append(String.valueOf(this.bean.getSessionFlushThreshold()));
                }
                if (this.bean.isSingletonSQLQueryHelperSet()) {
                    stringBuffer.append("SingletonSQLQueryHelper");
                    stringBuffer.append(String.valueOf(this.bean.getSingletonSQLQueryHelper()));
                }
                if (this.bean.isUnicastDiscoveryPeriodMillisSet()) {
                    stringBuffer.append("UnicastDiscoveryPeriodMillis");
                    stringBuffer.append(String.valueOf(this.bean.getUnicastDiscoveryPeriodMillis()));
                }
                if (this.bean.isWANSessionPersistenceTableNameSet()) {
                    stringBuffer.append("WANSessionPersistenceTableName");
                    stringBuffer.append(String.valueOf(this.bean.getWANSessionPersistenceTableName()));
                }
                if (this.bean.isClientCertProxyEnabledSet()) {
                    stringBuffer.append("ClientCertProxyEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isClientCertProxyEnabled()));
                }
                if (this.bean.isHttpTraceSupportEnabledSet()) {
                    stringBuffer.append("HttpTraceSupportEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isHttpTraceSupportEnabled()));
                }
                if (this.bean.isMemberDeathDetectorEnabledSet()) {
                    stringBuffer.append("MemberDeathDetectorEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isMemberDeathDetectorEnabled()));
                }
                if (this.bean.isMessageOrderingEnabledSet()) {
                    stringBuffer.append("MessageOrderingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isMessageOrderingEnabled()));
                }
                if (this.bean.isOneWayRmiForReplicationEnabledSet()) {
                    stringBuffer.append("OneWayRmiForReplicationEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isOneWayRmiForReplicationEnabled()));
                }
                if (this.bean.isReplicationTimeoutEnabledSet()) {
                    stringBuffer.append("ReplicationTimeoutEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isReplicationTimeoutEnabled()));
                }
                if (this.bean.isSecureReplicationEnabledSet()) {
                    stringBuffer.append("SecureReplicationEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isSecureReplicationEnabled()));
                }
                if (this.bean.isSessionLazyDeserializationEnabledSet()) {
                    stringBuffer.append("SessionLazyDeserializationEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isSessionLazyDeserializationEnabled()));
                }
                if (this.bean.isWeblogicPluginEnabledSet()) {
                    stringBuffer.append("WeblogicPluginEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isWeblogicPluginEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                ClusterMBeanImpl clusterMBeanImpl = (ClusterMBeanImpl)abstractDescriptorBean;
                this.computeDiff("AdditionalAutoMigrationAttempts", this.bean.getAdditionalAutoMigrationAttempts(), clusterMBeanImpl.getAdditionalAutoMigrationAttempts(), false);
                this.computeDiff("AsyncSessionQueueTimeout", this.bean.getAsyncSessionQueueTimeout(), clusterMBeanImpl.getAsyncSessionQueueTimeout(), true);
                this.computeDiff("AutoMigrationTableName", this.bean.getAutoMigrationTableName(), clusterMBeanImpl.getAutoMigrationTableName(), false);
                this.computeDiff("CandidateMachinesForMigratableServers", this.bean.getCandidateMachinesForMigratableServers(), clusterMBeanImpl.getCandidateMachinesForMigratableServers(), false);
                this.computeDiff("ClusterAddress", this.bean.getClusterAddress(), clusterMBeanImpl.getClusterAddress(), false);
                this.computeDiff("ClusterBroadcastChannel", this.bean.getClusterBroadcastChannel(), clusterMBeanImpl.getClusterBroadcastChannel(), false);
                this.computeDiff("ClusterMessagingMode", this.bean.getClusterMessagingMode(), clusterMBeanImpl.getClusterMessagingMode(), true);
                this.computeDiff("ClusterType", this.bean.getClusterType(), clusterMBeanImpl.getClusterType(), false);
                this.computeDiff("ConsensusParticipants", this.bean.getConsensusParticipants(), clusterMBeanImpl.getConsensusParticipants(), false);
                this.computeDiff("DataSourceForAutomaticMigration", this.bean.getDataSourceForAutomaticMigration(), clusterMBeanImpl.getDataSourceForAutomaticMigration(), false);
                this.computeDiff("DataSourceForJobScheduler", this.bean.getDataSourceForJobScheduler(), clusterMBeanImpl.getDataSourceForJobScheduler(), false);
                this.computeDiff("DataSourceForSessionPersistence", this.bean.getDataSourceForSessionPersistence(), clusterMBeanImpl.getDataSourceForSessionPersistence(), false);
                this.computeSubDiff("DatabaseLessLeasingBasis", this.bean.getDatabaseLessLeasingBasis(), clusterMBeanImpl.getDatabaseLessLeasingBasis());
                this.computeDiff("DeathDetectorHeartbeatPeriod", this.bean.getDeathDetectorHeartbeatPeriod(), clusterMBeanImpl.getDeathDetectorHeartbeatPeriod(), false);
                this.computeDiff("DefaultLoadAlgorithm", this.bean.getDefaultLoadAlgorithm(), clusterMBeanImpl.getDefaultLoadAlgorithm(), true);
                this.computeDiff("FencingGracePeriodMillis", this.bean.getFencingGracePeriodMillis(), clusterMBeanImpl.getFencingGracePeriodMillis(), false);
                this.computeDiff("FrontendHTTPPort", this.bean.getFrontendHTTPPort(), clusterMBeanImpl.getFrontendHTTPPort(), false);
                this.computeDiff("FrontendHTTPSPort", this.bean.getFrontendHTTPSPort(), clusterMBeanImpl.getFrontendHTTPSPort(), false);
                this.computeDiff("FrontendHost", this.bean.getFrontendHost(), clusterMBeanImpl.getFrontendHost(), false);
                this.computeDiff("GreedySessionFlushInterval", this.bean.getGreedySessionFlushInterval(), clusterMBeanImpl.getGreedySessionFlushInterval(), true);
                this.computeDiff("HTTPPingRetryCount", this.bean.getHTTPPingRetryCount(), clusterMBeanImpl.getHTTPPingRetryCount(), true);
                this.computeDiff("HealthCheckIntervalMillis", this.bean.getHealthCheckIntervalMillis(), clusterMBeanImpl.getHealthCheckIntervalMillis(), false);
                this.computeDiff("HealthCheckPeriodsUntilFencing", this.bean.getHealthCheckPeriodsUntilFencing(), clusterMBeanImpl.getHealthCheckPeriodsUntilFencing(), false);
                this.computeDiff("IdlePeriodsUntilTimeout", this.bean.getIdlePeriodsUntilTimeout(), clusterMBeanImpl.getIdlePeriodsUntilTimeout(), false);
                this.computeDiff("InterClusterCommLinkHealthCheckInterval", this.bean.getInterClusterCommLinkHealthCheckInterval(), clusterMBeanImpl.getInterClusterCommLinkHealthCheckInterval(), true);
                this.computeDiff("JobSchedulerTableName", this.bean.getJobSchedulerTableName(), clusterMBeanImpl.getJobSchedulerTableName(), false);
                this.computeDiff("MaxServerCountForHttpPing", this.bean.getMaxServerCountForHttpPing(), clusterMBeanImpl.getMaxServerCountForHttpPing(), true);
                this.computeDiff("MemberWarmupTimeoutSeconds", this.bean.getMemberWarmupTimeoutSeconds(), clusterMBeanImpl.getMemberWarmupTimeoutSeconds(), false);
                this.computeDiff("MigrationBasis", this.bean.getMigrationBasis(), clusterMBeanImpl.getMigrationBasis(), false);
                this.computeDiff("MillisToSleepBetweenAutoMigrationAttempts", this.bean.getMillisToSleepBetweenAutoMigrationAttempts(), clusterMBeanImpl.getMillisToSleepBetweenAutoMigrationAttempts(), false);
                this.computeDiff("MulticastAddress", this.bean.getMulticastAddress(), clusterMBeanImpl.getMulticastAddress(), false);
                this.computeDiff("MulticastBufferSize", this.bean.getMulticastBufferSize(), clusterMBeanImpl.getMulticastBufferSize(), false);
                this.computeDiff("MulticastDataEncryption", this.bean.getMulticastDataEncryption(), clusterMBeanImpl.getMulticastDataEncryption(), false);
                this.computeDiff("MulticastPort", this.bean.getMulticastPort(), clusterMBeanImpl.getMulticastPort(), false);
                this.computeDiff("MulticastSendDelay", this.bean.getMulticastSendDelay(), clusterMBeanImpl.getMulticastSendDelay(), false);
                this.computeDiff("MulticastTTL", this.bean.getMulticastTTL(), clusterMBeanImpl.getMulticastTTL(), false);
                this.computeDiff("Name", this.bean.getName(), clusterMBeanImpl.getName(), false);
                this.computeDiff("NumberOfServersInClusterAddress", this.bean.getNumberOfServersInClusterAddress(), clusterMBeanImpl.getNumberOfServersInClusterAddress(), false);
                this.computeSubDiff("OverloadProtection", this.bean.getOverloadProtection(), clusterMBeanImpl.getOverloadProtection());
                this.computeDiff("PersistSessionsOnShutdown", this.bean.getPersistSessionsOnShutdown(), clusterMBeanImpl.getPersistSessionsOnShutdown(), false);
                this.computeDiff("RemoteClusterAddress", this.bean.getRemoteClusterAddress(), clusterMBeanImpl.getRemoteClusterAddress(), false);
                this.computeDiff("ReplicationChannel", this.bean.getReplicationChannel(), clusterMBeanImpl.getReplicationChannel(), false);
                this.computeDiff("ServiceAgeThresholdSeconds", this.bean.getServiceAgeThresholdSeconds(), clusterMBeanImpl.getServiceAgeThresholdSeconds(), true);
                this.computeDiff("SessionFlushInterval", this.bean.getSessionFlushInterval(), clusterMBeanImpl.getSessionFlushInterval(), true);
                this.computeDiff("SessionFlushThreshold", this.bean.getSessionFlushThreshold(), clusterMBeanImpl.getSessionFlushThreshold(), true);
                this.computeDiff("SingletonSQLQueryHelper", this.bean.getSingletonSQLQueryHelper(), clusterMBeanImpl.getSingletonSQLQueryHelper(), false);
                this.computeDiff("UnicastDiscoveryPeriodMillis", this.bean.getUnicastDiscoveryPeriodMillis(), clusterMBeanImpl.getUnicastDiscoveryPeriodMillis(), true);
                this.computeDiff("WANSessionPersistenceTableName", this.bean.getWANSessionPersistenceTableName(), clusterMBeanImpl.getWANSessionPersistenceTableName(), false);
                this.computeDiff("ClientCertProxyEnabled", this.bean.isClientCertProxyEnabled(), clusterMBeanImpl.isClientCertProxyEnabled(), false);
                this.computeDiff("HttpTraceSupportEnabled", this.bean.isHttpTraceSupportEnabled(), clusterMBeanImpl.isHttpTraceSupportEnabled(), false);
                this.computeDiff("MemberDeathDetectorEnabled", this.bean.isMemberDeathDetectorEnabled(), clusterMBeanImpl.isMemberDeathDetectorEnabled(), false);
                this.computeDiff("MessageOrderingEnabled", this.bean.isMessageOrderingEnabled(), clusterMBeanImpl.isMessageOrderingEnabled(), false);
                this.computeDiff("OneWayRmiForReplicationEnabled", this.bean.isOneWayRmiForReplicationEnabled(), clusterMBeanImpl.isOneWayRmiForReplicationEnabled(), false);
                this.computeDiff("ReplicationTimeoutEnabled", this.bean.isReplicationTimeoutEnabled(), clusterMBeanImpl.isReplicationTimeoutEnabled(), false);
                this.computeDiff("SecureReplicationEnabled", this.bean.isSecureReplicationEnabled(), clusterMBeanImpl.isSecureReplicationEnabled(), false);
                this.computeDiff("SessionLazyDeserializationEnabled", this.bean.isSessionLazyDeserializationEnabled(), clusterMBeanImpl.isSessionLazyDeserializationEnabled(), false);
                this.computeDiff("WeblogicPluginEnabled", this.bean.isWeblogicPluginEnabled(), clusterMBeanImpl.isWeblogicPluginEnabled(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                ClusterMBeanImpl clusterMBeanImpl = (ClusterMBeanImpl)beanUpdateEvent.getSourceBean();
                ClusterMBeanImpl clusterMBeanImpl2 = (ClusterMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("AdditionalAutoMigrationAttempts")) {
                    clusterMBeanImpl.setAdditionalAutoMigrationAttempts(clusterMBeanImpl2.getAdditionalAutoMigrationAttempts());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 50);
                } else if (string.equals("AsyncSessionQueueTimeout")) {
                    clusterMBeanImpl.setAsyncSessionQueueTimeout(clusterMBeanImpl2.getAsyncSessionQueueTimeout());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 36);
                } else if (string.equals("AutoMigrationTableName")) {
                    clusterMBeanImpl.setAutoMigrationTableName(clusterMBeanImpl2.getAutoMigrationTableName());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 49);
                } else if (string.equals("CandidateMachinesForMigratableServers")) {
                    clusterMBeanImpl.setCandidateMachinesForMigratableServersAsString(clusterMBeanImpl2.getCandidateMachinesForMigratableServersAsString());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 40);
                } else if (string.equals("ClusterAddress")) {
                    clusterMBeanImpl.setClusterAddress(clusterMBeanImpl2.getClusterAddress());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("ClusterBroadcastChannel")) {
                    clusterMBeanImpl.setClusterBroadcastChannel(clusterMBeanImpl2.getClusterBroadcastChannel());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else if (string.equals("ClusterMessagingMode")) {
                    clusterMBeanImpl.setClusterMessagingMode(clusterMBeanImpl2.getClusterMessagingMode());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else if (string.equals("ClusterType")) {
                    clusterMBeanImpl.setClusterType(clusterMBeanImpl2.getClusterType());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 47);
                } else if (string.equals("ConsensusParticipants")) {
                    clusterMBeanImpl.setConsensusParticipants(clusterMBeanImpl2.getConsensusParticipants());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 53);
                } else if (string.equals("DataSourceForAutomaticMigration")) {
                    clusterMBeanImpl.setDataSourceForAutomaticMigrationAsString(clusterMBeanImpl2.getDataSourceForAutomaticMigrationAsString());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 41);
                } else if (string.equals("DataSourceForJobScheduler")) {
                    clusterMBeanImpl.setDataSourceForJobSchedulerAsString(clusterMBeanImpl2.getDataSourceForJobSchedulerAsString());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 33);
                } else if (string.equals("DataSourceForSessionPersistence")) {
                    clusterMBeanImpl.setDataSourceForSessionPersistenceAsString(clusterMBeanImpl2.getDataSourceForSessionPersistenceAsString());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 32);
                } else if (string.equals("DatabaseLessLeasingBasis")) {
                    if (n == 2) {
                        clusterMBeanImpl.setDatabaseLessLeasingBasis((DatabaseLessLeasingBasisMBean)this.createCopy((AbstractDescriptorBean)clusterMBeanImpl2.getDatabaseLessLeasingBasis()));
                    } else if (n == 3) {
                        clusterMBeanImpl._destroySingleton("DatabaseLessLeasingBasis", clusterMBeanImpl.getDatabaseLessLeasingBasis());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 56);
                } else if (string.equals("DeathDetectorHeartbeatPeriod")) {
                    clusterMBeanImpl.setDeathDetectorHeartbeatPeriod(clusterMBeanImpl2.getDeathDetectorHeartbeatPeriod());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 64);
                } else if (string.equals("DefaultLoadAlgorithm")) {
                    clusterMBeanImpl.setDefaultLoadAlgorithm(clusterMBeanImpl2.getDefaultLoadAlgorithm());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("FencingGracePeriodMillis")) {
                    clusterMBeanImpl.setFencingGracePeriodMillis(clusterMBeanImpl2.getFencingGracePeriodMillis());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 44);
                } else if (string.equals("FrontendHTTPPort")) {
                    clusterMBeanImpl.setFrontendHTTPPort(clusterMBeanImpl2.getFrontendHTTPPort());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                } else if (string.equals("FrontendHTTPSPort")) {
                    clusterMBeanImpl.setFrontendHTTPSPort(clusterMBeanImpl2.getFrontendHTTPSPort());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 26);
                } else if (string.equals("FrontendHost")) {
                    clusterMBeanImpl.setFrontendHost(clusterMBeanImpl2.getFrontendHost());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                } else if (string.equals("GreedySessionFlushInterval")) {
                    clusterMBeanImpl.setGreedySessionFlushInterval(clusterMBeanImpl2.getGreedySessionFlushInterval());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 37);
                } else if (string.equals("HTTPPingRetryCount")) {
                    clusterMBeanImpl.setHTTPPingRetryCount(clusterMBeanImpl2.getHTTPPingRetryCount());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 57);
                } else if (string.equals("HealthCheckIntervalMillis")) {
                    clusterMBeanImpl.setHealthCheckIntervalMillis(clusterMBeanImpl2.getHealthCheckIntervalMillis());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 42);
                } else if (string.equals("HealthCheckPeriodsUntilFencing")) {
                    clusterMBeanImpl.setHealthCheckPeriodsUntilFencing(clusterMBeanImpl2.getHealthCheckPeriodsUntilFencing());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 43);
                } else if (string.equals("IdlePeriodsUntilTimeout")) {
                    clusterMBeanImpl.setIdlePeriodsUntilTimeout(clusterMBeanImpl2.getIdlePeriodsUntilTimeout());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 27);
                } else if (string.equals("InterClusterCommLinkHealthCheckInterval")) {
                    clusterMBeanImpl.setInterClusterCommLinkHealthCheckInterval(clusterMBeanImpl2.getInterClusterCommLinkHealthCheckInterval());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 31);
                } else if (string.equals("JobSchedulerTableName")) {
                    clusterMBeanImpl.setJobSchedulerTableName(clusterMBeanImpl2.getJobSchedulerTableName());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 34);
                } else if (string.equals("MaxServerCountForHttpPing")) {
                    clusterMBeanImpl.setMaxServerCountForHttpPing(clusterMBeanImpl2.getMaxServerCountForHttpPing());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 58);
                } else if (string.equals("MemberWarmupTimeoutSeconds")) {
                    clusterMBeanImpl.setMemberWarmupTimeoutSeconds(clusterMBeanImpl2.getMemberWarmupTimeoutSeconds());
                    clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                } else if (!string.equals("MigratableTargets")) {
                    if (string.equals("MigrationBasis")) {
                        clusterMBeanImpl.setMigrationBasis(clusterMBeanImpl2.getMigrationBasis());
                        clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 52);
                    } else if (string.equals("MillisToSleepBetweenAutoMigrationAttempts")) {
                        clusterMBeanImpl.setMillisToSleepBetweenAutoMigrationAttempts(clusterMBeanImpl2.getMillisToSleepBetweenAutoMigrationAttempts());
                        clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 51);
                    } else if (string.equals("MulticastAddress")) {
                        clusterMBeanImpl.setMulticastAddress(clusterMBeanImpl2.getMulticastAddress());
                        clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                    } else if (string.equals("MulticastBufferSize")) {
                        clusterMBeanImpl.setMulticastBufferSize(clusterMBeanImpl2.getMulticastBufferSize());
                        clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                    } else if (string.equals("MulticastDataEncryption")) {
                        clusterMBeanImpl.setMulticastDataEncryption(clusterMBeanImpl2.getMulticastDataEncryption());
                        clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 48);
                    } else if (string.equals("MulticastPort")) {
                        clusterMBeanImpl.setMulticastPort(clusterMBeanImpl2.getMulticastPort());
                        clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                    } else if (string.equals("MulticastSendDelay")) {
                        clusterMBeanImpl.setMulticastSendDelay(clusterMBeanImpl2.getMulticastSendDelay());
                        clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                    } else if (string.equals("MulticastTTL")) {
                        clusterMBeanImpl.setMulticastTTL(clusterMBeanImpl2.getMulticastTTL());
                        clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                    } else if (string.equals("Name")) {
                        clusterMBeanImpl.setName(clusterMBeanImpl2.getName());
                        clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                    } else if (string.equals("NumberOfServersInClusterAddress")) {
                        clusterMBeanImpl.setNumberOfServersInClusterAddress(clusterMBeanImpl2.getNumberOfServersInClusterAddress());
                        clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 46);
                    } else if (string.equals("OverloadProtection")) {
                        if (n == 2) {
                            clusterMBeanImpl.setOverloadProtection((OverloadProtectionMBean)this.createCopy((AbstractDescriptorBean)clusterMBeanImpl2.getOverloadProtection()));
                        } else if (n == 3) {
                            clusterMBeanImpl._destroySingleton("OverloadProtection", clusterMBeanImpl.getOverloadProtection());
                        } else {
                            throw new AssertionError((Object)("Invalid type: " + n));
                        }
                        clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 55);
                    } else if (string.equals("PersistSessionsOnShutdown")) {
                        clusterMBeanImpl.setPersistSessionsOnShutdown(clusterMBeanImpl2.getPersistSessionsOnShutdown());
                        clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 35);
                    } else if (string.equals("RemoteClusterAddress")) {
                        clusterMBeanImpl.setRemoteClusterAddress(clusterMBeanImpl2.getRemoteClusterAddress());
                        clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 28);
                    } else if (string.equals("ReplicationChannel")) {
                        clusterMBeanImpl.setReplicationChannel(clusterMBeanImpl2.getReplicationChannel());
                        clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 30);
                    } else if (!string.equals("ServerNames") && !string.equals("Servers")) {
                        if (string.equals("ServiceAgeThresholdSeconds")) {
                            clusterMBeanImpl.setServiceAgeThresholdSeconds(clusterMBeanImpl2.getServiceAgeThresholdSeconds());
                            clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                        } else if (string.equals("SessionFlushInterval")) {
                            clusterMBeanImpl.setSessionFlushInterval(clusterMBeanImpl2.getSessionFlushInterval());
                            clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 38);
                        } else if (string.equals("SessionFlushThreshold")) {
                            clusterMBeanImpl.setSessionFlushThreshold(clusterMBeanImpl2.getSessionFlushThreshold());
                            clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 39);
                        } else if (string.equals("SingletonSQLQueryHelper")) {
                            clusterMBeanImpl.setSingletonSQLQueryHelper(clusterMBeanImpl2.getSingletonSQLQueryHelper());
                            clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 45);
                        } else if (string.equals("UnicastDiscoveryPeriodMillis")) {
                            clusterMBeanImpl.setUnicastDiscoveryPeriodMillis(clusterMBeanImpl2.getUnicastDiscoveryPeriodMillis());
                            clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 60);
                        } else if (string.equals("WANSessionPersistenceTableName")) {
                            clusterMBeanImpl.setWANSessionPersistenceTableName(clusterMBeanImpl2.getWANSessionPersistenceTableName());
                            clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 29);
                        } else if (string.equals("ClientCertProxyEnabled")) {
                            clusterMBeanImpl.setClientCertProxyEnabled(clusterMBeanImpl2.isClientCertProxyEnabled());
                            clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                        } else if (string.equals("HttpTraceSupportEnabled")) {
                            clusterMBeanImpl.setHttpTraceSupportEnabled(clusterMBeanImpl2.isHttpTraceSupportEnabled());
                            clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                        } else if (string.equals("MemberDeathDetectorEnabled")) {
                            clusterMBeanImpl.setMemberDeathDetectorEnabled(clusterMBeanImpl2.isMemberDeathDetectorEnabled());
                            clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 65);
                        } else if (string.equals("MessageOrderingEnabled")) {
                            clusterMBeanImpl.setMessageOrderingEnabled(clusterMBeanImpl2.isMessageOrderingEnabled());
                            clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 61);
                        } else if (string.equals("OneWayRmiForReplicationEnabled")) {
                            clusterMBeanImpl.setOneWayRmiForReplicationEnabled(clusterMBeanImpl2.isOneWayRmiForReplicationEnabled());
                            clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 62);
                        } else if (string.equals("ReplicationTimeoutEnabled")) {
                            clusterMBeanImpl.setReplicationTimeoutEnabled(clusterMBeanImpl2.isReplicationTimeoutEnabled());
                            clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 54);
                        } else if (string.equals("SecureReplicationEnabled")) {
                            clusterMBeanImpl.setSecureReplicationEnabled(clusterMBeanImpl2.isSecureReplicationEnabled());
                            clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 59);
                        } else if (string.equals("SessionLazyDeserializationEnabled")) {
                            clusterMBeanImpl.setSessionLazyDeserializationEnabled(clusterMBeanImpl2.isSessionLazyDeserializationEnabled());
                            clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 63);
                        } else if (string.equals("WeblogicPluginEnabled")) {
                            clusterMBeanImpl.setWeblogicPluginEnabled(clusterMBeanImpl2.isWeblogicPluginEnabled());
                            clusterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                        } else {
                            super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                ConfigurationMBean configurationMBean;
                ClusterMBeanImpl clusterMBeanImpl = (ClusterMBeanImpl)abstractDescriptorBean;
                super.finishCopy(clusterMBeanImpl, bl, list);
                if ((list == null || !list.contains("AdditionalAutoMigrationAttempts")) && this.bean.isAdditionalAutoMigrationAttemptsSet()) {
                    clusterMBeanImpl.setAdditionalAutoMigrationAttempts(this.bean.getAdditionalAutoMigrationAttempts());
                }
                if ((list == null || !list.contains("AsyncSessionQueueTimeout")) && this.bean.isAsyncSessionQueueTimeoutSet()) {
                    clusterMBeanImpl.setAsyncSessionQueueTimeout(this.bean.getAsyncSessionQueueTimeout());
                }
                if ((list == null || !list.contains("AutoMigrationTableName")) && this.bean.isAutoMigrationTableNameSet()) {
                    clusterMBeanImpl.setAutoMigrationTableName(this.bean.getAutoMigrationTableName());
                }
                if ((list == null || !list.contains("CandidateMachinesForMigratableServers")) && this.bean.isCandidateMachinesForMigratableServersSet()) {
                    clusterMBeanImpl._unSet(clusterMBeanImpl, 40);
                    clusterMBeanImpl.setCandidateMachinesForMigratableServersAsString(this.bean.getCandidateMachinesForMigratableServersAsString());
                }
                if ((list == null || !list.contains("ClusterAddress")) && this.bean.isClusterAddressSet()) {
                    clusterMBeanImpl.setClusterAddress(this.bean.getClusterAddress());
                }
                if ((list == null || !list.contains("ClusterBroadcastChannel")) && this.bean.isClusterBroadcastChannelSet()) {
                    clusterMBeanImpl.setClusterBroadcastChannel(this.bean.getClusterBroadcastChannel());
                }
                if ((list == null || !list.contains("ClusterMessagingMode")) && this.bean.isClusterMessagingModeSet()) {
                    clusterMBeanImpl.setClusterMessagingMode(this.bean.getClusterMessagingMode());
                }
                if ((list == null || !list.contains("ClusterType")) && this.bean.isClusterTypeSet()) {
                    clusterMBeanImpl.setClusterType(this.bean.getClusterType());
                }
                if ((list == null || !list.contains("ConsensusParticipants")) && this.bean.isConsensusParticipantsSet()) {
                    clusterMBeanImpl.setConsensusParticipants(this.bean.getConsensusParticipants());
                }
                if ((list == null || !list.contains("DataSourceForAutomaticMigration")) && this.bean.isDataSourceForAutomaticMigrationSet()) {
                    clusterMBeanImpl._unSet(clusterMBeanImpl, 41);
                    clusterMBeanImpl.setDataSourceForAutomaticMigrationAsString(this.bean.getDataSourceForAutomaticMigrationAsString());
                }
                if ((list == null || !list.contains("DataSourceForJobScheduler")) && this.bean.isDataSourceForJobSchedulerSet()) {
                    clusterMBeanImpl._unSet(clusterMBeanImpl, 33);
                    clusterMBeanImpl.setDataSourceForJobSchedulerAsString(this.bean.getDataSourceForJobSchedulerAsString());
                }
                if ((list == null || !list.contains("DataSourceForSessionPersistence")) && this.bean.isDataSourceForSessionPersistenceSet()) {
                    clusterMBeanImpl._unSet(clusterMBeanImpl, 32);
                    clusterMBeanImpl.setDataSourceForSessionPersistenceAsString(this.bean.getDataSourceForSessionPersistenceAsString());
                }
                if (!(list != null && list.contains("DatabaseLessLeasingBasis") || !this.bean.isDatabaseLessLeasingBasisSet() || clusterMBeanImpl._isSet(56))) {
                    configurationMBean = this.bean.getDatabaseLessLeasingBasis();
                    clusterMBeanImpl.setDatabaseLessLeasingBasis(null);
                    clusterMBeanImpl.setDatabaseLessLeasingBasis(configurationMBean == null ? null : (DatabaseLessLeasingBasisMBean)this.createCopy((AbstractDescriptorBean)configurationMBean, bl));
                }
                if ((list == null || !list.contains("DeathDetectorHeartbeatPeriod")) && this.bean.isDeathDetectorHeartbeatPeriodSet()) {
                    clusterMBeanImpl.setDeathDetectorHeartbeatPeriod(this.bean.getDeathDetectorHeartbeatPeriod());
                }
                if ((list == null || !list.contains("DefaultLoadAlgorithm")) && this.bean.isDefaultLoadAlgorithmSet()) {
                    clusterMBeanImpl.setDefaultLoadAlgorithm(this.bean.getDefaultLoadAlgorithm());
                }
                if ((list == null || !list.contains("FencingGracePeriodMillis")) && this.bean.isFencingGracePeriodMillisSet()) {
                    clusterMBeanImpl.setFencingGracePeriodMillis(this.bean.getFencingGracePeriodMillis());
                }
                if ((list == null || !list.contains("FrontendHTTPPort")) && this.bean.isFrontendHTTPPortSet()) {
                    clusterMBeanImpl.setFrontendHTTPPort(this.bean.getFrontendHTTPPort());
                }
                if ((list == null || !list.contains("FrontendHTTPSPort")) && this.bean.isFrontendHTTPSPortSet()) {
                    clusterMBeanImpl.setFrontendHTTPSPort(this.bean.getFrontendHTTPSPort());
                }
                if ((list == null || !list.contains("FrontendHost")) && this.bean.isFrontendHostSet()) {
                    clusterMBeanImpl.setFrontendHost(this.bean.getFrontendHost());
                }
                if ((list == null || !list.contains("GreedySessionFlushInterval")) && this.bean.isGreedySessionFlushIntervalSet()) {
                    clusterMBeanImpl.setGreedySessionFlushInterval(this.bean.getGreedySessionFlushInterval());
                }
                if ((list == null || !list.contains("HTTPPingRetryCount")) && this.bean.isHTTPPingRetryCountSet()) {
                    clusterMBeanImpl.setHTTPPingRetryCount(this.bean.getHTTPPingRetryCount());
                }
                if ((list == null || !list.contains("HealthCheckIntervalMillis")) && this.bean.isHealthCheckIntervalMillisSet()) {
                    clusterMBeanImpl.setHealthCheckIntervalMillis(this.bean.getHealthCheckIntervalMillis());
                }
                if ((list == null || !list.contains("HealthCheckPeriodsUntilFencing")) && this.bean.isHealthCheckPeriodsUntilFencingSet()) {
                    clusterMBeanImpl.setHealthCheckPeriodsUntilFencing(this.bean.getHealthCheckPeriodsUntilFencing());
                }
                if ((list == null || !list.contains("IdlePeriodsUntilTimeout")) && this.bean.isIdlePeriodsUntilTimeoutSet()) {
                    clusterMBeanImpl.setIdlePeriodsUntilTimeout(this.bean.getIdlePeriodsUntilTimeout());
                }
                if ((list == null || !list.contains("InterClusterCommLinkHealthCheckInterval")) && this.bean.isInterClusterCommLinkHealthCheckIntervalSet()) {
                    clusterMBeanImpl.setInterClusterCommLinkHealthCheckInterval(this.bean.getInterClusterCommLinkHealthCheckInterval());
                }
                if ((list == null || !list.contains("JobSchedulerTableName")) && this.bean.isJobSchedulerTableNameSet()) {
                    clusterMBeanImpl.setJobSchedulerTableName(this.bean.getJobSchedulerTableName());
                }
                if ((list == null || !list.contains("MaxServerCountForHttpPing")) && this.bean.isMaxServerCountForHttpPingSet()) {
                    clusterMBeanImpl.setMaxServerCountForHttpPing(this.bean.getMaxServerCountForHttpPing());
                }
                if ((list == null || !list.contains("MemberWarmupTimeoutSeconds")) && this.bean.isMemberWarmupTimeoutSecondsSet()) {
                    clusterMBeanImpl.setMemberWarmupTimeoutSeconds(this.bean.getMemberWarmupTimeoutSeconds());
                }
                if ((list == null || !list.contains("MigrationBasis")) && this.bean.isMigrationBasisSet()) {
                    clusterMBeanImpl.setMigrationBasis(this.bean.getMigrationBasis());
                }
                if ((list == null || !list.contains("MillisToSleepBetweenAutoMigrationAttempts")) && this.bean.isMillisToSleepBetweenAutoMigrationAttemptsSet()) {
                    clusterMBeanImpl.setMillisToSleepBetweenAutoMigrationAttempts(this.bean.getMillisToSleepBetweenAutoMigrationAttempts());
                }
                if ((list == null || !list.contains("MulticastAddress")) && this.bean.isMulticastAddressSet()) {
                    clusterMBeanImpl.setMulticastAddress(this.bean.getMulticastAddress());
                }
                if ((list == null || !list.contains("MulticastBufferSize")) && this.bean.isMulticastBufferSizeSet()) {
                    clusterMBeanImpl.setMulticastBufferSize(this.bean.getMulticastBufferSize());
                }
                if ((list == null || !list.contains("MulticastDataEncryption")) && this.bean.isMulticastDataEncryptionSet()) {
                    clusterMBeanImpl.setMulticastDataEncryption(this.bean.getMulticastDataEncryption());
                }
                if ((list == null || !list.contains("MulticastPort")) && this.bean.isMulticastPortSet()) {
                    clusterMBeanImpl.setMulticastPort(this.bean.getMulticastPort());
                }
                if ((list == null || !list.contains("MulticastSendDelay")) && this.bean.isMulticastSendDelaySet()) {
                    clusterMBeanImpl.setMulticastSendDelay(this.bean.getMulticastSendDelay());
                }
                if ((list == null || !list.contains("MulticastTTL")) && this.bean.isMulticastTTLSet()) {
                    clusterMBeanImpl.setMulticastTTL(this.bean.getMulticastTTL());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    clusterMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("NumberOfServersInClusterAddress")) && this.bean.isNumberOfServersInClusterAddressSet()) {
                    clusterMBeanImpl.setNumberOfServersInClusterAddress(this.bean.getNumberOfServersInClusterAddress());
                }
                if (!(list != null && list.contains("OverloadProtection") || !this.bean.isOverloadProtectionSet() || clusterMBeanImpl._isSet(55))) {
                    configurationMBean = this.bean.getOverloadProtection();
                    clusterMBeanImpl.setOverloadProtection(null);
                    clusterMBeanImpl.setOverloadProtection(configurationMBean == null ? null : (OverloadProtectionMBean)this.createCopy((AbstractDescriptorBean)configurationMBean, bl));
                }
                if ((list == null || !list.contains("PersistSessionsOnShutdown")) && this.bean.isPersistSessionsOnShutdownSet()) {
                    clusterMBeanImpl.setPersistSessionsOnShutdown(this.bean.getPersistSessionsOnShutdown());
                }
                if ((list == null || !list.contains("RemoteClusterAddress")) && this.bean.isRemoteClusterAddressSet()) {
                    clusterMBeanImpl.setRemoteClusterAddress(this.bean.getRemoteClusterAddress());
                }
                if ((list == null || !list.contains("ReplicationChannel")) && this.bean.isReplicationChannelSet()) {
                    clusterMBeanImpl.setReplicationChannel(this.bean.getReplicationChannel());
                }
                if ((list == null || !list.contains("ServiceAgeThresholdSeconds")) && this.bean.isServiceAgeThresholdSecondsSet()) {
                    clusterMBeanImpl.setServiceAgeThresholdSeconds(this.bean.getServiceAgeThresholdSeconds());
                }
                if ((list == null || !list.contains("SessionFlushInterval")) && this.bean.isSessionFlushIntervalSet()) {
                    clusterMBeanImpl.setSessionFlushInterval(this.bean.getSessionFlushInterval());
                }
                if ((list == null || !list.contains("SessionFlushThreshold")) && this.bean.isSessionFlushThresholdSet()) {
                    clusterMBeanImpl.setSessionFlushThreshold(this.bean.getSessionFlushThreshold());
                }
                if ((list == null || !list.contains("SingletonSQLQueryHelper")) && this.bean.isSingletonSQLQueryHelperSet()) {
                    clusterMBeanImpl.setSingletonSQLQueryHelper(this.bean.getSingletonSQLQueryHelper());
                }
                if ((list == null || !list.contains("UnicastDiscoveryPeriodMillis")) && this.bean.isUnicastDiscoveryPeriodMillisSet()) {
                    clusterMBeanImpl.setUnicastDiscoveryPeriodMillis(this.bean.getUnicastDiscoveryPeriodMillis());
                }
                if ((list == null || !list.contains("WANSessionPersistenceTableName")) && this.bean.isWANSessionPersistenceTableNameSet()) {
                    clusterMBeanImpl.setWANSessionPersistenceTableName(this.bean.getWANSessionPersistenceTableName());
                }
                if ((list == null || !list.contains("ClientCertProxyEnabled")) && this.bean.isClientCertProxyEnabledSet()) {
                    clusterMBeanImpl.setClientCertProxyEnabled(this.bean.isClientCertProxyEnabled());
                }
                if ((list == null || !list.contains("HttpTraceSupportEnabled")) && this.bean.isHttpTraceSupportEnabledSet()) {
                    clusterMBeanImpl.setHttpTraceSupportEnabled(this.bean.isHttpTraceSupportEnabled());
                }
                if ((list == null || !list.contains("MemberDeathDetectorEnabled")) && this.bean.isMemberDeathDetectorEnabledSet()) {
                    clusterMBeanImpl.setMemberDeathDetectorEnabled(this.bean.isMemberDeathDetectorEnabled());
                }
                if ((list == null || !list.contains("MessageOrderingEnabled")) && this.bean.isMessageOrderingEnabledSet()) {
                    clusterMBeanImpl.setMessageOrderingEnabled(this.bean.isMessageOrderingEnabled());
                }
                if ((list == null || !list.contains("OneWayRmiForReplicationEnabled")) && this.bean.isOneWayRmiForReplicationEnabledSet()) {
                    clusterMBeanImpl.setOneWayRmiForReplicationEnabled(this.bean.isOneWayRmiForReplicationEnabled());
                }
                if ((list == null || !list.contains("ReplicationTimeoutEnabled")) && this.bean.isReplicationTimeoutEnabledSet()) {
                    clusterMBeanImpl.setReplicationTimeoutEnabled(this.bean.isReplicationTimeoutEnabled());
                }
                if ((list == null || !list.contains("SecureReplicationEnabled")) && this.bean.isSecureReplicationEnabledSet()) {
                    clusterMBeanImpl.setSecureReplicationEnabled(this.bean.isSecureReplicationEnabled());
                }
                if ((list == null || !list.contains("SessionLazyDeserializationEnabled")) && this.bean.isSessionLazyDeserializationEnabledSet()) {
                    clusterMBeanImpl.setSessionLazyDeserializationEnabled(this.bean.isSessionLazyDeserializationEnabled());
                }
                if ((list == null || !list.contains("WeblogicPluginEnabled")) && this.bean.isWeblogicPluginEnabledSet()) {
                    clusterMBeanImpl.setWeblogicPluginEnabled(this.bean.isWeblogicPluginEnabled());
                }
                return clusterMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getCandidateMachinesForMigratableServers(), clazz, object);
            this.inferSubTree(this.bean.getDataSourceForAutomaticMigration(), clazz, object);
            this.inferSubTree(this.bean.getDataSourceForJobScheduler(), clazz, object);
            this.inferSubTree(this.bean.getDataSourceForSessionPersistence(), clazz, object);
            this.inferSubTree(this.bean.getDatabaseLessLeasingBasis(), clazz, object);
            this.inferSubTree(this.bean.getMigratableTargets(), clazz, object);
            this.inferSubTree(this.bean.getOverloadProtection(), clazz, object);
            this.inferSubTree(this.bean.getServers(), clazz, object);
        }
    }
}

