/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ClusterMBeanImpl;
import weblogic.management.configuration.TargetMBeanImplBeanInfo;
import weblogic.management.internal.mbean.BeanInfoHelper;

public class ClusterMBeanImplBeanInfo
extends TargetMBeanImplBeanInfo {
    public static Class INTERFACE_CLASS = ClusterMBean.class;

    public ClusterMBeanImplBeanInfo(boolean bl, String string) throws IntrospectionException {
        super(bl, string);
    }

    public ClusterMBeanImplBeanInfo() throws IntrospectionException {
    }

    protected BeanDescriptor buildBeanDescriptor() {
        Class clazz = null;
        try {
            clazz = ClusterMBeanImpl.class;
        }
        catch (Throwable throwable) {
            clazz = INTERFACE_CLASS;
        }
        BeanDescriptor beanDescriptor = new BeanDescriptor(clazz, null);
        beanDescriptor.setValue("package", "weblogic.management.configuration");
        String string = new String("This bean represents a cluster in the domain. Servers join a cluster by calling ServerMBean.setCluster with the logical name of the cluster. A configuration may define zero or more clusters. They may be looked up by logical name.  The name of a cluster denotes its logical cluster name.  <h3 class=\"TypeSafeDeprecation\">Deprecation of MBeanHome and Type-Safe Interfaces</h3>  <p class=\"TypeSafeDeprecation\">This is a type-safe interface for a WebLogic Server MBean, which you can import into your client classes and access through <code>weblogic.management.MBeanHome</code>. As of 9.0, the <code>MBeanHome</code> interface and all type-safe interfaces for WebLogic Server MBeans are deprecated. Instead, client classes that interact with WebLogic Server MBeans should use standard JMX design patterns in which clients use the <code>javax.management.MBeanServerConnection</code> interface to discover MBeans, attributes, and attribute types at runtime.</p> ").intern();
        beanDescriptor.setShortDescription(string);
        beanDescriptor.setValue("description", string);
        beanDescriptor.setValue("interfaceclassname", "weblogic.management.configuration.ClusterMBean");
        beanDescriptor.setValue("generatedByWLSInfoBinder", Boolean.TRUE);
        return beanDescriptor;
    }

    protected void buildPropertyDescriptors(Map map) throws IntrospectionException {
        String[] stringArray;
        String string;
        String string2;
        PropertyDescriptor propertyDescriptor = null;
        if (!map.containsKey("AdditionalAutoMigrationAttempts")) {
            string2 = "getAdditionalAutoMigrationAttempts";
            string = null;
            if (!this.readOnly) {
                string = "setAdditionalAutoMigrationAttempts";
            }
            propertyDescriptor = new PropertyDescriptor("AdditionalAutoMigrationAttempts", ClusterMBean.class, string2, string);
            map.put("AdditionalAutoMigrationAttempts", propertyDescriptor);
            propertyDescriptor.setValue("description", "A migratable server could fail to come up on every possible configured machine. This attribute controls how many further attempts, after the first one, should be tried.  Note that each attempt specified here indicates another full circuit of migrations amongst all the configured machines. So for a 3-server cluster, and the default value of 3, a total of 9 migrations will be attempted.  If it is set to -1, migrations will go on forever until the server starts. ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(3));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("AsyncSessionQueueTimeout")) {
            string2 = "getAsyncSessionQueueTimeout";
            string = null;
            if (!this.readOnly) {
                string = "setAsyncSessionQueueTimeout";
            }
            propertyDescriptor = new PropertyDescriptor("AsyncSessionQueueTimeout", ClusterMBean.class, string2, string);
            map.put("AsyncSessionQueueTimeout", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Interval in seconds until the producer thread will wait for the AsyncSessionQueue to become unblocked.  Should be similar to the RequestTimeOut as that will determine the longest that the queue should remain full.<p> ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(30));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("AutoMigrationTableName")) {
            string2 = "getAutoMigrationTableName";
            string = null;
            if (!this.readOnly) {
                string = "setAutoMigrationTableName";
            }
            propertyDescriptor = new PropertyDescriptor("AutoMigrationTableName", ClusterMBean.class, string2, string);
            map.put("AutoMigrationTableName", propertyDescriptor);
            propertyDescriptor.setValue("description", "Return the name of the table to be used for server migration. ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"ACTIVE");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("CandidateMachinesForMigratableServers")) {
            string2 = "getCandidateMachinesForMigratableServers";
            string = null;
            if (!this.readOnly) {
                string = "setCandidateMachinesForMigratableServers";
            }
            propertyDescriptor = new PropertyDescriptor("CandidateMachinesForMigratableServers", ClusterMBean.class, string2, string);
            map.put("CandidateMachinesForMigratableServers", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The set of machines (and order of preference) on which Node Manager will restart failed servers. (Requires you to enable each server for automatic migration.)</p>  <p>Each server can specify a subset of these cluster-wide candidates, which limits the machines on which the server can be restarted. Servers can also specify their own order of preference.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"ServerMBean#getCandidateMachinesForMigratableServers")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("ClusterAddress")) {
            string2 = "getClusterAddress";
            string = null;
            if (!this.readOnly) {
                string = "setClusterAddress";
            }
            propertyDescriptor = new PropertyDescriptor("ClusterAddress", ClusterMBean.class, string2, string);
            map.put("ClusterAddress", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The address that forms a portion of the URL a client uses to connect to this cluster, and that is used for generating EJB handles and entity EJB failover addresses. (This address may be either a DNS host name that maps to multiple IP addresses or a comma-separated list of single address host names or IP addresses.)</p>  <p>Defines the address to be used by clients to connect to this cluster. This address may be either a DNS host name that maps to multiple IP addresses or a comma separated list of single address host names or IP addresses. If network channels are configured, it is possible to set the cluster address on a per channel basis.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.NetworkChannelMBean#getClusterAddress")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("ClusterBroadcastChannel")) {
            string2 = "getClusterBroadcastChannel";
            string = null;
            if (!this.readOnly) {
                string = "setClusterBroadcastChannel";
            }
            propertyDescriptor = new PropertyDescriptor("ClusterBroadcastChannel", ClusterMBean.class, string2, string);
            map.put("ClusterBroadcastChannel", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies the channel used to handle communications within a cluster. If no channel is specified the default channel is used.</p> <p>ClusterBroadcastChannel is only are supported if the unicast messaging type is used. ");
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
        }
        if (!map.containsKey("ClusterMessagingMode")) {
            string2 = "getClusterMessagingMode";
            string = null;
            if (!this.readOnly) {
                string = "setClusterMessagingMode";
            }
            propertyDescriptor = new PropertyDescriptor("ClusterMessagingMode", ClusterMBean.class, string2, string);
            map.put("ClusterMessagingMode", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies the messaging type used in the cluster.</p> <p>Multicast messaging, the default, is provided for backwards compatibility.</p> <p>Unicast message is recommended for new clusters.</p> ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"multicast");
            propertyDescriptor.setValue("legalValues", new Object[]{"multicast", "unicast"});
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("ClusterType")) {
            string2 = "getClusterType";
            string = null;
            if (!this.readOnly) {
                string = "setClusterType";
            }
            propertyDescriptor = new PropertyDescriptor("ClusterType", ClusterMBean.class, string2, string);
            map.put("ClusterType", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Optimizes cross-cluster replication for the type of network that servers in the clusters use for administrative communication.</p>  <p>To enhance the reliability of HTTP sessions, you can configure servers in one cluster to replicate the session data to servers in a different cluster. In such an environment, configure the clusters to be one of the following types:</p>  <ul> <li><code>man</code> <p>If the clustered servers can send their data through a metro area network (man) in which latency is negligible. With this ClusterType value, servers replicate session state synchronously and in memory only. For example, when serverA in cluster1 starts an HTTP session, its backup server, serverB in cluster2, immediately replicates this session in memory to Server B.</p> </li>  <li><code>wan</code> <p>If the clusters are far apart or send their data through a wide area network (wan) that experiences significant network latency. With this ClusterType value, a server replicates session state synchronously to the backup server in the same cluster and asynchronously to a server in the remote cluster. For example, when serverA in cluster1 starts an HTTP session, it sends the data to serverB in cluster1 and then asynchronously sends data to serverX in cluster 2. ServerX will persist the session state in the database.</p>  <p>If you persist session data in a replicating database, and if you prefer to use the database to replicate the data instead of WebLogic Server, choose a cluster type of <code>wan</code> and leave the remote cluster address undefined. WebLogic Server saves the session data to the local database and assumes that the database replicates data as needed.</p> </li> </ul> ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"none");
            propertyDescriptor.setValue("legalValues", new Object[]{"none", "wan", "man"});
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("ConsensusParticipants")) {
            string2 = "getConsensusParticipants";
            string = null;
            if (!this.readOnly) {
                string = "setConsensusParticipants";
            }
            propertyDescriptor = new PropertyDescriptor("ConsensusParticipants", ClusterMBean.class, string2, string);
            map.put("ConsensusParticipants", propertyDescriptor);
            propertyDescriptor.setValue("description", "Controls the number of cluster participants in determining consensus. ");
            propertyDescriptor.setValue("legalMax", new Integer(65536));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("DataSourceForAutomaticMigration")) {
            string2 = "getDataSourceForAutomaticMigration";
            string = null;
            if (!this.readOnly) {
                string = "setDataSourceForAutomaticMigration";
            }
            propertyDescriptor = new PropertyDescriptor("DataSourceForAutomaticMigration", ClusterMBean.class, string2, string);
            map.put("DataSourceForAutomaticMigration", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The data source used by servers in the cluster during migration. (You must configure each Migratable Server within the cluster to use this data source.)</p> ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("DataSourceForJobScheduler")) {
            string2 = "getDataSourceForJobScheduler";
            string = null;
            if (!this.readOnly) {
                string = "setDataSourceForJobScheduler";
            }
            propertyDescriptor = new PropertyDescriptor("DataSourceForJobScheduler", ClusterMBean.class, string2, string);
            map.put("DataSourceForJobScheduler", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Data source required to support persistence of jobs scheduled with the job scheduler</p> ");
            propertyDescriptor.setValue("relationship", "reference");
        }
        if (!map.containsKey("DataSourceForSessionPersistence")) {
            string2 = "getDataSourceForSessionPersistence";
            string = null;
            if (!this.readOnly) {
                string = "setDataSourceForSessionPersistence";
            }
            propertyDescriptor = new PropertyDescriptor("DataSourceForSessionPersistence", ClusterMBean.class, string2, string);
            map.put("DataSourceForSessionPersistence", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>To support HTTP Session failover across data centers, a datasource is required to dump session state on disk.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("DatabaseLessLeasingBasis")) {
            string2 = "getDatabaseLessLeasingBasis";
            string = null;
            propertyDescriptor = new PropertyDescriptor("DatabaseLessLeasingBasis", ClusterMBean.class, string2, string);
            map.put("DatabaseLessLeasingBasis", propertyDescriptor);
            propertyDescriptor.setValue("description", "Get attributes associated with database less leasing basis used for server migration and singleton services. ");
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (!map.containsKey("DeathDetectorHeartbeatPeriod")) {
            string2 = "getDeathDetectorHeartbeatPeriod";
            string = null;
            if (!this.readOnly) {
                string = "setDeathDetectorHeartbeatPeriod";
            }
            propertyDescriptor = new PropertyDescriptor("DeathDetectorHeartbeatPeriod", ClusterMBean.class, string2, string);
            map.put("DeathDetectorHeartbeatPeriod", propertyDescriptor);
            propertyDescriptor.setValue("description", "Gets the DeathDetectory HeartbeatPeriod value. The ClusterMaster sends a heartbeat every period seconds to ascertian the health of a member. Members monitor this heartbeat in order to ascertain the health of the server hosting the DeathDetector.  In this case, the ClusterMaster. ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(1));
            propertyDescriptor.setValue("legalMin", new Integer(1));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("DefaultLoadAlgorithm")) {
            string2 = "getDefaultLoadAlgorithm";
            string = null;
            if (!this.readOnly) {
                string = "setDefaultLoadAlgorithm";
            }
            propertyDescriptor = new PropertyDescriptor("DefaultLoadAlgorithm", ClusterMBean.class, string2, string);
            map.put("DefaultLoadAlgorithm", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Defines the algorithm to be used for load-balancing between replicated services if none is specified for a particular service. The <tt>round-robin</tt> algorithm cycles through a list of WebLogic Server instances in order. <tt>Weight-based</tt> load balancing improves on the round-robin algorithm by taking into account a pre-assigned weight for each server. In <tt>random</tt> load balancing, requests are routed to servers at random.</p> ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"round-robin");
            propertyDescriptor.setValue("legalValues", new Object[]{"round-robin", "weight-based", "random", "round-robin-affinity", "weight-based-affinity", "random-affinity"});
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("FencingGracePeriodMillis")) {
            string2 = "getFencingGracePeriodMillis";
            string = null;
            if (!this.readOnly) {
                string = "setFencingGracePeriodMillis";
            }
            propertyDescriptor = new PropertyDescriptor("FencingGracePeriodMillis", ClusterMBean.class, string2, string);
            map.put("FencingGracePeriodMillis", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>During automatic migration, if the Cluster Master determines a server to be dead, it waits for this period of time (in milliseconds) before the Cluster Master migrates the service to another server in the cluster.</p> ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(30000));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("FrontendHTTPPort")) {
            string2 = "getFrontendHTTPPort";
            string = null;
            if (!this.readOnly) {
                string = "setFrontendHTTPPort";
            }
            propertyDescriptor = new PropertyDescriptor("FrontendHTTPPort", ClusterMBean.class, string2, string);
            map.put("FrontendHTTPPort", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The name of the HTTP port to which all redirected URLs will be sent.</p>  <p>Sets the FrontendHTTPPort for the default webserver (not virtual hosts) for all the servers in the cluster. Provides a method to ensure that the webapp will always have the correct PORT information, even when the request is coming through a firewall or a proxy. If this parameter is configured, the HOST header will be ignored and the information in this parameter will be used in its place, when constructing the absolute urls for redirects.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.WebServerMBean#getFrontendHTTPPort")};
            propertyDescriptor.setValue("see", stringArray);
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(0));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("FrontendHTTPSPort")) {
            string2 = "getFrontendHTTPSPort";
            string = null;
            if (!this.readOnly) {
                string = "setFrontendHTTPSPort";
            }
            propertyDescriptor = new PropertyDescriptor("FrontendHTTPSPort", ClusterMBean.class, string2, string);
            map.put("FrontendHTTPSPort", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The name of the secure HTTP port to which all redirected URLs will be sent.</p>  <p>Sets the FrontendHTTPSPort for the default webserver (not virtual hosts) for all the servers in the cluster. Provides a method to ensure that the webapp will always have the correct PORT information, even when the request is coming through a firewall or a proxy. If this parameter is configured, the HOST header will be ignored and the information in this parameter will be used in its place, when constructing the absolute urls for redirects.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.WebServerMBean#getFrontendHTTPSPort")};
            propertyDescriptor.setValue("see", stringArray);
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(0));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("FrontendHost")) {
            string2 = "getFrontendHost";
            string = null;
            if (!this.readOnly) {
                string = "setFrontendHost";
            }
            propertyDescriptor = new PropertyDescriptor("FrontendHost", ClusterMBean.class, string2, string);
            map.put("FrontendHost", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The name of the host to which all redirected URLs will be sent.</p>  <p>Sets the HTTP FrontendHost for the default webserver (not virtual hosts) for all the servers in the cluster. Provides a method to ensure that the webapp will always have the correct HOST information, even when the request is coming through a firewall or a proxy. If this parameter is configured, the HOST header will be ignored and the information in this parameter will be used in its place, when constructing the absolute urls for redirects.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.WebServerMBean#getFrontendHost")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("defaultValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("GreedySessionFlushInterval")) {
            string2 = "getGreedySessionFlushInterval";
            string = null;
            if (!this.readOnly) {
                string = "setGreedySessionFlushInterval";
            }
            propertyDescriptor = new PropertyDescriptor("GreedySessionFlushInterval", ClusterMBean.class, string2, string);
            map.put("GreedySessionFlushInterval", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Interval in seconds until HTTP Sessions are periodically flushed to secondary server. ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(3));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("HTTPPingRetryCount")) {
            string2 = "getHTTPPingRetryCount";
            string = null;
            if (!this.readOnly) {
                string = "setHTTPPingRetryCount";
            }
            propertyDescriptor = new PropertyDescriptor("HTTPPingRetryCount", ClusterMBean.class, string2, string);
            map.put("HTTPPingRetryCount", propertyDescriptor);
            propertyDescriptor.setValue("description", "Get the number of HTTP pings to execute before declaring a server unreachable. This comes into effect only when MaxServerCountForHTTPPing is > 0. ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(3));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("HealthCheckIntervalMillis")) {
            string2 = "getHealthCheckIntervalMillis";
            string = null;
            if (!this.readOnly) {
                string = "setHealthCheckIntervalMillis";
            }
            propertyDescriptor = new PropertyDescriptor("HealthCheckIntervalMillis", ClusterMBean.class, string2, string);
            map.put("HealthCheckIntervalMillis", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Interval in milliseconds at which Migratable Servers and Cluster Masters prove their liveness via the database.</p> ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(10000));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("HealthCheckPeriodsUntilFencing")) {
            string2 = "getHealthCheckPeriodsUntilFencing";
            string = null;
            if (!this.readOnly) {
                string = "setHealthCheckPeriodsUntilFencing";
            }
            propertyDescriptor = new PropertyDescriptor("HealthCheckPeriodsUntilFencing", ClusterMBean.class, string2, string);
            map.put("HealthCheckPeriodsUntilFencing", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Maximum number of periods that a cluster member will wait before timing out a Cluster Master and also the maximum number of periods the Cluster Master will wait before timing out a Migratable Server.</p> ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(3));
            propertyDescriptor.setValue("legalMin", new Integer(2));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("IdlePeriodsUntilTimeout")) {
            string2 = "getIdlePeriodsUntilTimeout";
            string = null;
            if (!this.readOnly) {
                string = "setIdlePeriodsUntilTimeout";
            }
            propertyDescriptor = new PropertyDescriptor("IdlePeriodsUntilTimeout", ClusterMBean.class, string2, string);
            map.put("IdlePeriodsUntilTimeout", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Maximum number of periods that a cluster member will wait before timing out a member of a cluster.</p>  <p>Maximum number of periods that a cluster member will wait before timing out a member of a cluster.</p> ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(3));
            propertyDescriptor.setValue("legalMin", new Integer(3));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("InterClusterCommLinkHealthCheckInterval")) {
            string2 = "getInterClusterCommLinkHealthCheckInterval";
            string = null;
            if (!this.readOnly) {
                string = "setInterClusterCommLinkHealthCheckInterval";
            }
            propertyDescriptor = new PropertyDescriptor("InterClusterCommLinkHealthCheckInterval", ClusterMBean.class, string2, string);
            map.put("InterClusterCommLinkHealthCheckInterval", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>If the cluster link between two clusters goes down, a trigger will run periodically to see if the link is restored. The duration is specified in milliseconds.</p> ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(30000));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("JobSchedulerTableName")) {
            string2 = "getJobSchedulerTableName";
            string = null;
            if (!this.readOnly) {
                string = "setJobSchedulerTableName";
            }
            propertyDescriptor = new PropertyDescriptor("JobSchedulerTableName", ClusterMBean.class, string2, string);
            map.put("JobSchedulerTableName", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The table name to use for storing timers active with the job scheduler</p> ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"weblogic_timers");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("MaxServerCountForHttpPing")) {
            string2 = "getMaxServerCountForHttpPing";
            string = null;
            if (!this.readOnly) {
                string = "setMaxServerCountForHttpPing";
            }
            propertyDescriptor = new PropertyDescriptor("MaxServerCountForHttpPing", ClusterMBean.class, string2, string);
            map.put("MaxServerCountForHttpPing", propertyDescriptor);
            propertyDescriptor.setValue("description", "Get the maximum number of servers that can be pinged via HTTP when the local server has lost multicast heartbeats from remote members. By default the server is taken out of the cluster when 3 consecutive heartbeats are lost. With this value > 0, the server attempts to ping the remote server point-to-point before declaring it unreachable. The ping is considered successful only when the cluster is in a stable state which means that the servers have already exchanged annoucements and the data on multicast is primarily liveliness heartbeat. <p> NOTE: This mechanism is useful only as a substitute for multicast heartbeats. If subsystems rely on sending data over multicast then they will continue to fail. If an application relies on WebLogic features that use multicast for sending and receiving data over multicast, this option is not useful. It is useful for HTTP session replication based applications where replication updates are sent point-to-point and multicast is only used to determine liveliness. </p> ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(0));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("MemberWarmupTimeoutSeconds")) {
            string2 = "getMemberWarmupTimeoutSeconds";
            string = null;
            if (!this.readOnly) {
                string = "setMemberWarmupTimeoutSeconds";
            }
            propertyDescriptor = new PropertyDescriptor("MemberWarmupTimeoutSeconds", ClusterMBean.class, string2, string);
            map.put("MemberWarmupTimeoutSeconds", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Maximum number of seconds that a cluster member will wait to discover and synchronize with other servers in the cluster. Normally, the member will be able to sync in 30 seconds. If the value of this attribute is higher, that does not necessarily mean that it will take longer for the member to warmup. Instead it defines an upper bound on the time that a server will wait to sync with the servers that it has discovered. If the value is set 0, servers will not attempt to discover other running server in the cluster during server initialization</p> ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(30));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("MigratableTargets")) {
            string2 = "getMigratableTargets";
            string = null;
            propertyDescriptor = new PropertyDescriptor("MigratableTargets", ClusterMBean.class, string2, string);
            map.put("MigratableTargets", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns all the MigratableTargets for this cluster</p> ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("transient", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("MigrationBasis")) {
            string2 = "getMigrationBasis";
            string = null;
            if (!this.readOnly) {
                string = "setMigrationBasis";
            }
            propertyDescriptor = new PropertyDescriptor("MigrationBasis", ClusterMBean.class, string2, string);
            map.put("MigrationBasis", propertyDescriptor);
            propertyDescriptor.setValue("description", "Controls the mechanism used for server and service migration. <ul> <li><b>Database</b> -- Requires the availability of a high-availability database, such as Oracle RAC, to store leasing information. <li><b>Consensus</b> -- Stores the leasing information in-memory within a cluster member. This option requires Node Manager to be configured and running. </ul> <p><b>Note:</b> Within a WebLogic Server installation, you can only use one type of leasing. Although it is possible to implement multiple features that use leasing within your environment, each must use the same kind of leasing. ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"database");
            propertyDescriptor.setValue("legalValues", new Object[]{"database", "consensus"});
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("MillisToSleepBetweenAutoMigrationAttempts")) {
            string2 = "getMillisToSleepBetweenAutoMigrationAttempts";
            string = null;
            if (!this.readOnly) {
                string = "setMillisToSleepBetweenAutoMigrationAttempts";
            }
            propertyDescriptor = new PropertyDescriptor("MillisToSleepBetweenAutoMigrationAttempts", ClusterMBean.class, string2, string);
            map.put("MillisToSleepBetweenAutoMigrationAttempts", propertyDescriptor);
            propertyDescriptor.setValue("description", "Controls how long of a pause there should be between the migration attempts described in getAdditionalAutoMigrationAttempts(). Note that this delay only happens when the server has failed to come up on every machine. ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getAdditionalAutoMigrationAttempts")};
            propertyDescriptor.setValue("see", stringArray);
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Long(180000L));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("MulticastAddress")) {
            string2 = "getMulticastAddress";
            string = null;
            if (!this.readOnly) {
                string = "setMulticastAddress";
            }
            propertyDescriptor = new PropertyDescriptor("MulticastAddress", ClusterMBean.class, string2, string);
            map.put("MulticastAddress", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The multicast address used by cluster members to communicate with each other.</p>  <p>The valid range is from from 224.0.0.0 to 239.255.255.255. The default value used by WebLogic Server is 239.192.0.0.  You should avoid using multicast addresses in the range x.0.0.1</p>  <p>This address should be unique to this cluster and should not be shared by other applications.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.ServerMBean#getInterfaceAddress"), BeanInfoHelper.encodeEntities((String)"#getMulticastPort")};
            propertyDescriptor.setValue("see", stringArray);
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"239.192.0.0");
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("MulticastBufferSize")) {
            string2 = "getMulticastBufferSize";
            string = null;
            if (!this.readOnly) {
                string = "setMulticastBufferSize";
            }
            propertyDescriptor = new PropertyDescriptor("MulticastBufferSize", ClusterMBean.class, string2, string);
            map.put("MulticastBufferSize", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The multicast socket send/receive buffer size (at least 64 kilobytes).</p>  <p>Returns the multicast socket send/receive buffer size.</p> ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(64));
            propertyDescriptor.setValue("legalMin", new Integer(64));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("MulticastDataEncryption")) {
            string2 = "getMulticastDataEncryption";
            string = null;
            if (!this.readOnly) {
                string = "setMulticastDataEncryption";
            }
            propertyDescriptor = new PropertyDescriptor("MulticastDataEncryption", ClusterMBean.class, string2, string);
            map.put("MulticastDataEncryption", propertyDescriptor);
            propertyDescriptor.setValue("description", "Enables multicast data to be encrypted. Only the multicast data is encrypted. Multicast header information is not encrypted. ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (BeanInfoHelper.isVersionCompliant((String)"7.0.0.0", null, (String)this.targetVersion) && !map.containsKey("MulticastPort")) {
            string2 = "getMulticastPort";
            string = null;
            if (!this.readOnly) {
                string = "setMulticastPort";
            }
            propertyDescriptor = new PropertyDescriptor("MulticastPort", ClusterMBean.class, string2, string);
            map.put("MulticastPort", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The multicast port (between 1 and 65535) used by cluster members to communicate with each other.</p>  <p>Defines the multicast port used by cluster members to communicate with each other.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#setMulticastPort"), BeanInfoHelper.encodeEntities((String)"#getMulticastAddress")};
            propertyDescriptor.setValue("see", stringArray);
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(7001));
            propertyDescriptor.setValue("legalMax", new Integer(65535));
            propertyDescriptor.setValue("legalMin", new Integer(1));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
            propertyDescriptor.setValue("since", "7.0.0.0");
        }
        if (!map.containsKey("MulticastSendDelay")) {
            string2 = "getMulticastSendDelay";
            string = null;
            if (!this.readOnly) {
                string = "setMulticastSendDelay";
            }
            propertyDescriptor = new PropertyDescriptor("MulticastSendDelay", ClusterMBean.class, string2, string);
            map.put("MulticastSendDelay", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The amount of time (between 0 and 250 milliseconds) to delay sending message fragments over multicast in order to avoid OS-level buffer overflow.</p>  <p>Defines the number of milliseconds to delay sending message fragments over multicast in order to avoid OS-level buffer overflow.</p> ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(3));
            propertyDescriptor.setValue("legalMax", new Integer(250));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("MulticastTTL")) {
            string2 = "getMulticastTTL";
            string = null;
            if (!this.readOnly) {
                string = "setMulticastTTL";
            }
            propertyDescriptor = new PropertyDescriptor("MulticastTTL", ClusterMBean.class, string2, string);
            map.put("MulticastTTL", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of network hops (between 1 and 255) that a cluster multicast message is allowed to travel.</p>  <p>Defines the number of network hops that a cluster multicast message is allowed to travel. 1 restricts the cluster to one subnet.</p> ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(1));
            propertyDescriptor.setValue("legalMax", new Integer(255));
            propertyDescriptor.setValue("legalMin", new Integer(1));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("Name")) {
            string2 = "getName";
            string = null;
            if (!this.readOnly) {
                string = "setName";
            }
            propertyDescriptor = new PropertyDescriptor("Name", ClusterMBean.class, string2, string);
            map.put("Name", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The user-specified name of this MBean instance.</p>  <p>This name is included as one of the key properties in the MBean's <code>javax.management.ObjectName</code>:<br clear=\"none\" /> <code>Name=<i>user-specified-name</i></code></p> ");
            propertyDescriptor.setValue("legalNull", Boolean.TRUE);
            propertyDescriptor.setValue("key", Boolean.TRUE);
        }
        if (!map.containsKey("NumberOfServersInClusterAddress")) {
            string2 = "getNumberOfServersInClusterAddress";
            string = null;
            if (!this.readOnly) {
                string = "setNumberOfServersInClusterAddress";
            }
            propertyDescriptor = new PropertyDescriptor("NumberOfServersInClusterAddress", ClusterMBean.class, string2, string);
            map.put("NumberOfServersInClusterAddress", propertyDescriptor);
            propertyDescriptor.setValue("description", "Number of servers to be listed from this cluster when generating a cluster address automatically. This setting has no effect if Cluster Address is explicitly set. ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getClusterAddress")};
            propertyDescriptor.setValue("see", stringArray);
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(3));
            propertyDescriptor.setValue("legalMin", new Integer(1));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("OverloadProtection")) {
            string2 = "getOverloadProtection";
            string = null;
            propertyDescriptor = new PropertyDescriptor("OverloadProtection", ClusterMBean.class, string2, string);
            map.put("OverloadProtection", propertyDescriptor);
            propertyDescriptor.setValue("description", "Get attributes related to server overload protection. The default values for all cluster members are set here. Individual servers can override them as needed. ");
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (!map.containsKey("PersistSessionsOnShutdown")) {
            string2 = "getPersistSessionsOnShutdown";
            string = null;
            if (!this.readOnly) {
                string = "setPersistSessionsOnShutdown";
            }
            propertyDescriptor = new PropertyDescriptor("PersistSessionsOnShutdown", ClusterMBean.class, string2, string);
            map.put("PersistSessionsOnShutdown", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>When shutting down servers, sessions are not updated. If the primary and secondary servers of a session are shut down with no session updates, the session will be lost. Turning on PersistSessionsOnShutdown will save any active sessions to the database specified in {@link ClusterMBean#getDataSourceForSessionPersistence()} when a server is shutdown. The sessions will not be written at any other time. (For example, they are not saved via this mechanism if there is a server crash.)</p>  <p>This attribute is applicable both to session persistence on server shutdown or session persistence across a WAN.</p>  <p>Rolling upgrade can potentially have a bad interaction with traditional in-memory session replication.  As managed servers are shutdown and upgraded, in-memory servlet sessions will be lost if both primary and secondary are rebooted before a new request arrives for the session.</p> ");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("RemoteClusterAddress")) {
            string2 = "getRemoteClusterAddress";
            string = null;
            if (!this.readOnly) {
                string = "setRemoteClusterAddress";
            }
            propertyDescriptor = new PropertyDescriptor("RemoteClusterAddress", ClusterMBean.class, string2, string);
            map.put("RemoteClusterAddress", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Set the foreign cluster. Cluster infrastructure uses this address to connect to foreign cluster for HTTP Session WAN/MAN failover.</p> ");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("ReplicationChannel")) {
            string2 = "getReplicationChannel";
            string = null;
            if (!this.readOnly) {
                string = "setReplicationChannel";
            }
            propertyDescriptor = new PropertyDescriptor("ReplicationChannel", ClusterMBean.class, string2, string);
            map.put("ReplicationChannel", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The channel name to be used for replication traffic. Cluster infrastructure uses this channel to send updates for HTTP sessions and stateful session beans. If none is set then the default channel will be used.</p>  <p>In order for this feature to work, the named channel must exist on all members of the cluster and must be configured to use the same protocol. It is valid for the selected channel to be configured to use a secure protocol.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#getRemoteClusterAddress")};
            propertyDescriptor.setValue("see", stringArray);
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"ReplicationChannel");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("Servers")) {
            string2 = "getServers";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Servers", ClusterMBean.class, string2, string);
            map.put("Servers", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The servers which have declared membership in this cluster.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("transient", Boolean.TRUE);
        }
        if (!map.containsKey("ServiceAgeThresholdSeconds")) {
            string2 = "getServiceAgeThresholdSeconds";
            string = null;
            if (!this.readOnly) {
                string = "setServiceAgeThresholdSeconds";
            }
            propertyDescriptor = new PropertyDescriptor("ServiceAgeThresholdSeconds", ClusterMBean.class, string2, string);
            map.put("ServiceAgeThresholdSeconds", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of seconds (between 0 and 65534) by which the age of two conflicting services must differ before one is considered older than the other.</p>  <p>Defines the number of seconds by which the age of two conflicting services must differ before one is considered older than the other.</p> ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(180));
            propertyDescriptor.setValue("legalMax", new Integer(65534));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("SessionFlushInterval")) {
            string2 = "getSessionFlushInterval";
            string = null;
            if (!this.readOnly) {
                string = "setSessionFlushInterval";
            }
            propertyDescriptor = new PropertyDescriptor("SessionFlushInterval", ClusterMBean.class, string2, string);
            map.put("SessionFlushInterval", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Interval in seconds until HTTP Sessions are periodically flushed to the backup cluster to dump session state on disk.</p> ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(180));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("SessionFlushThreshold")) {
            string2 = "getSessionFlushThreshold";
            string = null;
            if (!this.readOnly) {
                string = "setSessionFlushThreshold";
            }
            propertyDescriptor = new PropertyDescriptor("SessionFlushThreshold", ClusterMBean.class, string2, string);
            map.put("SessionFlushThreshold", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>When number of sessions to be flushed reaches this threshold limit, sessions will be flushed to the backup cluster before the flush interval. This helps the server to flush sessions faster under load.</p> ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(10000));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("SingletonSQLQueryHelper")) {
            string2 = "getSingletonSQLQueryHelper";
            string = null;
            if (!this.readOnly) {
                string = "setSingletonSQLQueryHelper";
            }
            propertyDescriptor = new PropertyDescriptor("SingletonSQLQueryHelper", ClusterMBean.class, string2, string);
            map.put("SingletonSQLQueryHelper", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Singleton Services uses certain SQL commands to talk to the database. By default, the commands are obtained from a WebLogic-supplied implementation of weblogic.cluster.singleton.QueryHelper. If the database is not suported, or the SQL needs to be more optimized or altered for a particular use case, one can change the class used by setting this variable. The classname provided will be loaded at boot time, and used to execute the various SQL queries.</p> ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("UnicastDiscoveryPeriodMillis")) {
            string2 = "getUnicastDiscoveryPeriodMillis";
            string = null;
            if (!this.readOnly) {
                string = "setUnicastDiscoveryPeriodMillis";
            }
            propertyDescriptor = new PropertyDescriptor("UnicastDiscoveryPeriodMillis", ClusterMBean.class, string2, string);
            map.put("UnicastDiscoveryPeriodMillis", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The timer period that determines how  often other members in the cluster are discovered in unicast messaging scheme. This is not applicable to multicast mode. It applies only to unicast mode.</p> ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(3000));
            propertyDescriptor.setValue("legalMin", new Integer(1000));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("WANSessionPersistenceTableName")) {
            string2 = "getWANSessionPersistenceTableName";
            string = null;
            if (!this.readOnly) {
                string = "setWANSessionPersistenceTableName";
            }
            propertyDescriptor = new PropertyDescriptor("WANSessionPersistenceTableName", ClusterMBean.class, string2, string);
            map.put("WANSessionPersistenceTableName", propertyDescriptor);
            propertyDescriptor.setValue("description", "Return the name of the table to be used for WAN session persistence. ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"WLS_WAN_PERSISTENCE_TABLE");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("ClientCertProxyEnabled")) {
            string2 = "isClientCertProxyEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setClientCertProxyEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("ClientCertProxyEnabled", ClusterMBean.class, string2, string);
            map.put("ClientCertProxyEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether to honor the WL-Proxy-Client-Cert header coming with the request or not. </p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.WebAppContainerMBean#isClientCertProxyEnabled()"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.ServerMBean#isClientCertProxyEnabled()")};
            propertyDescriptor.setValue("see", stringArray);
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("secureValue", new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("HttpTraceSupportEnabled")) {
            string2 = "isHttpTraceSupportEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setHttpTraceSupportEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("HttpTraceSupportEnabled", ClusterMBean.class, string2, string);
            map.put("HttpTraceSupportEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p> Returns the value of HttpTraceSupportEnabled. </p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.WebAppContainerMBean#isHttpTraceSupportEnabled"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.ServerMBean#isHttpTraceSupportEnabled")};
            propertyDescriptor.setValue("see", stringArray);
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (BeanInfoHelper.isVersionCompliant(null, null, (String)this.targetVersion) && !map.containsKey("MemberDeathDetectorEnabled")) {
            string2 = "isMemberDeathDetectorEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setMemberDeathDetectorEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("MemberDeathDetectorEnabled", ClusterMBean.class, string2, string);
            map.put("MemberDeathDetectorEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "Enables faster Automatic Service Migration times with Database Leasing Basis. ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
            propertyDescriptor.setValue("since", "true");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.3.3.0", null, (String)this.targetVersion) && !map.containsKey("MessageOrderingEnabled")) {
            string2 = "isMessageOrderingEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setMessageOrderingEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("MessageOrderingEnabled", ClusterMBean.class, string2, string);
            map.put("MessageOrderingEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Forces unicast messages to be processed in order. There are scenarios where JMS may update JNDI very frequently. It will result in a lot of messages over unicast. Due to the close proximity of messages the probability of out of order handling of messages increases which would trigger frequent state dumps. Frequent JNDI tree refresh may result in NameNotFoundException. Use this property to prevent out of order handling of messages.</p> ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
            propertyDescriptor.setValue("since", "10.3.3.0");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.3.4.0", null, (String)this.targetVersion) && !map.containsKey("OneWayRmiForReplicationEnabled")) {
            string2 = "isOneWayRmiForReplicationEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setOneWayRmiForReplicationEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("OneWayRmiForReplicationEnabled", ClusterMBean.class, string2, string);
            map.put("OneWayRmiForReplicationEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "Indicates if one-way RMI is being used for replication. One-way RMI also requires configuring replication ports on each server in the cluster. ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.ServerMBean#getReplicationPorts()")};
            propertyDescriptor.setValue("see", stringArray);
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
            propertyDescriptor.setValue("since", "10.3.4.0");
        }
        if (!map.containsKey("ReplicationTimeoutEnabled")) {
            string2 = "isReplicationTimeoutEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setReplicationTimeoutEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("ReplicationTimeoutEnabled", ClusterMBean.class, string2, string);
            map.put("ReplicationTimeoutEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "Indicates if timeout should be applied to session replication calls. ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (BeanInfoHelper.isVersionCompliant((String)"7.0.8.0", null, (String)this.targetVersion) && !map.containsKey("SecureReplicationEnabled")) {
            string2 = "isSecureReplicationEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setSecureReplicationEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("SecureReplicationEnabled", ClusterMBean.class, string2, string);
            map.put("SecureReplicationEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "Servers in a cluster replicate session data. If a replication channel is defined then the session data will be sent using the replication channel protocol and secured replication settings will be ignored. If no replication channel is defined and secured replication is enabled then session data for in-memory replication will be sent over SSL using the default secured channel. However, this added security for replication traffic comes with a significant cluster performance degradation. It should only be enabled if security is of greater concern than performance degradation. ");
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("configurable", Boolean.TRUE);
            propertyDescriptor.setValue("since", "7.0.8.0");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.3.4.0", null, (String)this.targetVersion) && !map.containsKey("SessionLazyDeserializationEnabled")) {
            string2 = "isSessionLazyDeserializationEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setSessionLazyDeserializationEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("SessionLazyDeserializationEnabled", ClusterMBean.class, string2, string);
            map.put("SessionLazyDeserializationEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "Enables increased efficiency with session replication. Enabling this attribute should be used only when configuring a WebLogic domain for Oracle Exalogic. For more information, see \"Enabling Exalogic-Specific Enhancements in Oracle WebLogic Server 11g Release 1 (10.3.4)\" in the Oracle Exalogic Deployment Guide. ");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
            propertyDescriptor.setValue("since", "10.3.4.0");
        }
        if (!map.containsKey("WeblogicPluginEnabled")) {
            string2 = "isWeblogicPluginEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setWeblogicPluginEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("WeblogicPluginEnabled", ClusterMBean.class, string2, string);
            map.put("WeblogicPluginEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether the proprietary <tt>WL-Proxy-Client-IP</tt> header should be used. (This needed only when WebLogic plugins are configured.)</p>  <p>Gets the weblogicPluginEnabled attribute of the ClusterMBean object</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.WebAppContainerMBean#isWeblogicPluginEnabled()"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.ServerMBean#isWeblogicPluginEnabled()")};
            propertyDescriptor.setValue("see", stringArray);
            ClusterMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("secureValue", new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        super.buildPropertyDescriptors(map);
    }

    private void fillinFactoryMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinCollectionMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinFinderMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinOperationMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        MethodDescriptor methodDescriptor;
        Method method = ClusterMBean.class.getMethod("freezeCurrentValue", String.class);
        Object object = new ParameterDescriptor[]{ClusterMBeanImplBeanInfo.createParameterDescriptor((String)"attributeName", null)};
        String string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, (ParameterDescriptor[])object);
            methodDescriptor.setValue("deprecated", "9.0.0.0 ");
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>If the specified attribute has not been set explicitly, and if the attribute has a default value, this operation forces the MBean to persist the default value.</p>  <p>Unless you use this operation, the default value is not saved and is subject to change if you update to a newer release of WebLogic Server. Invoking this operation isolates this MBean from the effects of such changes.</p>  <dl> <dt>Note:</dt>  <dd> <p>To insure that you are freezing the default value, invoke the <code>restoreDefaultValue</code> operation before you invoke this.</p> </dd> </dl>  <p>This operation has no effect if you invoke it on an attribute that does not provide a default value or on an attribute for which some other value has been set.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = ClusterMBean.class.getMethod("restoreDefaultValue", String.class);
        object = new ParameterDescriptor[]{ClusterMBeanImplBeanInfo.createParameterDescriptor((String)"attributeName", null)};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string) && !this.readOnly) {
            methodDescriptor = new MethodDescriptor(method, (ParameterDescriptor[])object);
            methodDescriptor.setValue("deprecated", "9.0.0.0 ");
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>If the specified attribute has a default value, this operation removes any value that has been set explicitly and causes the attribute to use the default value.</p>  <p>Default values are subject to change if you update to a newer release of WebLogic Server. To prevent the value from changing if you update to a newer release, invoke the <code>freezeCurrentValue</code> operation.</p>  <p>This operation has no effect if you invoke it on an attribute that does not provide a default value or on an attribute that is already using the default.</p> ");
            methodDescriptor.setValue("role", "operation");
            methodDescriptor.setValue("impact", "action");
        }
        if (!map.containsKey(object = BeanInfoHelper.buildMethodKey((Method)(method = ClusterMBean.class.getMethod("start", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            methodDescriptor.setValue("deprecated", "9.0.0.0 ");
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Used to start all the servers belonging to the Cluster. HashMap contains references to TaskRuntimeMBeans corresponding to each server in the Cluster, keyed using the server name.</p> ");
            methodDescriptor.setValue("exclude", Boolean.TRUE);
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(object = BeanInfoHelper.buildMethodKey((Method)(method = ClusterMBean.class.getMethod("kill", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            methodDescriptor.setValue("deprecated", "9.0.0.0 ");
            map.put(object, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Used to force a Shutdown of all the servers belonging to the Cluster.</p> ");
            methodDescriptor.setValue("exclude", Boolean.TRUE);
            methodDescriptor.setValue("role", "operation");
        }
    }

    protected void buildMethodDescriptors(Map map) throws IntrospectionException, NoSuchMethodException {
        this.fillinFinderMethodInfos(map);
        if (!this.readOnly) {
            this.fillinCollectionMethodInfos(map);
            this.fillinFactoryMethodInfos(map);
        }
        this.fillinOperationMethodInfos(map);
        super.buildMethodDescriptors(map);
    }

    protected void buildEventSetDescriptors(Map map) throws IntrospectionException {
    }
}

