/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import com.bea.logging.LoggingConfigValidator;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.beangen.StringHelper;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.ManagementException;
import weblogic.management.configuration.CommonLogMBean;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.LogFileMBeanImpl;
import weblogic.management.mbeans.custom.Log;
import weblogic.utils.collections.CombinedIterator;

public class CommonLogMBeanImpl
extends LogFileMBeanImpl
implements CommonLogMBean,
Serializable {
    private String _LogFileSeverity;
    private String _LoggerSeverity;
    private Properties _LoggerSeverityProperties;
    private String _Name;
    private int _StacktraceDepth;
    private String _StdoutFormat;
    private boolean _StdoutLogStack;
    private String _StdoutSeverity;
    private Log _customizer;
    private static SchemaHelper2 _schemaHelper;

    public CommonLogMBeanImpl() {
        try {
            this._customizer = new Log(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public CommonLogMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new Log(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getLoggerSeverity() {
        return this._LoggerSeverity;
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public boolean isLoggerSeveritySet() {
        return this._isSet(20);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public void setLoggerSeverity(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Trace", "Debug", "Info", "Notice", "Warning"};
        string = LegalChecks.checkInEnum((String)"LoggerSeverity", (String)string, (String[])stringArray);
        String string2 = this._LoggerSeverity;
        this._LoggerSeverity = string;
        this._postSet(20, string2, string);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public Properties getLoggerSeverityProperties() {
        return this._LoggerSeverityProperties;
    }

    public String getLoggerSeverityPropertiesAsString() {
        return StringHelper.objectToString((Object)this.getLoggerSeverityProperties());
    }

    public boolean isLoggerSeverityPropertiesSet() {
        return this._isSet(21);
    }

    public void setLoggerSeverityPropertiesAsString(String string) {
        try {
            this.setLoggerSeverityProperties(StringHelper.stringToProperties((String)string));
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public void setLoggerSeverityProperties(Properties properties) {
        LoggingConfigValidator.validateLoggerSeverityProperties((Properties)properties);
        Properties properties2 = this._LoggerSeverityProperties;
        this._LoggerSeverityProperties = properties;
        this._postSet(21, properties2, properties);
    }

    public String getLogFileSeverity() {
        return this._LogFileSeverity;
    }

    public boolean isLogFileSeveritySet() {
        return this._isSet(22);
    }

    public void setLogFileSeverity(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Trace", "Debug", "Info", "Notice", "Warning"};
        string = LegalChecks.checkInEnum((String)"LogFileSeverity", (String)string, (String[])stringArray);
        String string2 = this._LogFileSeverity;
        this._LogFileSeverity = string;
        this._postSet(22, string2, string);
    }

    public String getStdoutSeverity() {
        return this._StdoutSeverity;
    }

    public boolean isStdoutSeveritySet() {
        return this._isSet(23);
    }

    public void setStdoutSeverity(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Trace", "Debug", "Info", "Warning", "Error", "Notice", "Critical", "Alert", "Emergency", "Off"};
        string = LegalChecks.checkInEnum((String)"StdoutSeverity", (String)string, (String[])stringArray);
        String string2 = this._StdoutSeverity;
        this._StdoutSeverity = string;
        this._postSet(23, string2, string);
    }

    public String getStdoutFormat() {
        return this._StdoutFormat;
    }

    public boolean isStdoutFormatSet() {
        return this._isSet(24);
    }

    public void setStdoutFormat(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"standard", "noid"};
        string = LegalChecks.checkInEnum((String)"StdoutFormat", (String)string, (String[])stringArray);
        String string2 = this._StdoutFormat;
        this._StdoutFormat = string;
        this._postSet(24, string2, string);
    }

    public boolean isStdoutLogStack() {
        return this._StdoutLogStack;
    }

    public boolean isStdoutLogStackSet() {
        return this._isSet(25);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void setStdoutLogStack(boolean bl) {
        boolean bl2 = this._StdoutLogStack;
        this._StdoutLogStack = bl;
        this._postSet(25, bl2, bl);
    }

    public int getStacktraceDepth() {
        return this._StacktraceDepth;
    }

    public boolean isStacktraceDepthSet() {
        return this._isSet(26);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setStacktraceDepth(int n) {
        int n2 = this._StacktraceDepth;
        this._StacktraceDepth = n;
        this._postSet(26, n2, n);
    }

    public String computeLogFilePath() {
        return this._customizer.computeLogFilePath();
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 22;
        }
        try {
            switch (n) {
                case 22: {
                    this._LogFileSeverity = "Trace";
                    if (bl) break;
                }
                case 20: {
                    this._LoggerSeverity = "Info";
                    if (bl) break;
                }
                case 21: {
                    this._LoggerSeverityProperties = null;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 26: {
                    this._StacktraceDepth = 5;
                    if (bl) break;
                }
                case 24: {
                    this._StdoutFormat = "standard";
                    if (bl) break;
                }
                case 23: {
                    this._StdoutSeverity = "Notice";
                    if (bl) break;
                }
                case 25: {
                    this._StdoutLogStack = true;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "CommonLog";
    }

    public void putValue(String string, Object object) {
        if (string.equals("LogFileSeverity")) {
            String string2 = this._LogFileSeverity;
            this._LogFileSeverity = (String)object;
            this._postSet(22, string2, this._LogFileSeverity);
            return;
        }
        if (string.equals("LoggerSeverity")) {
            String string3 = this._LoggerSeverity;
            this._LoggerSeverity = (String)object;
            this._postSet(20, string3, this._LoggerSeverity);
            return;
        }
        if (string.equals("LoggerSeverityProperties")) {
            Properties properties = this._LoggerSeverityProperties;
            this._LoggerSeverityProperties = (Properties)object;
            this._postSet(21, properties, this._LoggerSeverityProperties);
            return;
        }
        if (string.equals("Name")) {
            String string4 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string4, this._Name);
            return;
        }
        if (string.equals("StacktraceDepth")) {
            int n = this._StacktraceDepth;
            this._StacktraceDepth = (Integer)object;
            this._postSet(26, n, this._StacktraceDepth);
            return;
        }
        if (string.equals("StdoutFormat")) {
            String string5 = this._StdoutFormat;
            this._StdoutFormat = (String)object;
            this._postSet(24, string5, this._StdoutFormat);
            return;
        }
        if (string.equals("StdoutLogStack")) {
            boolean bl = this._StdoutLogStack;
            this._StdoutLogStack = (Boolean)object;
            this._postSet(25, bl, this._StdoutLogStack);
            return;
        }
        if (string.equals("StdoutSeverity")) {
            String string6 = this._StdoutSeverity;
            this._StdoutSeverity = (String)object;
            this._postSet(23, string6, this._StdoutSeverity);
            return;
        }
        if (string.equals("customizer")) {
            Log log = this._customizer;
            this._customizer = (Log)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("LogFileSeverity")) {
            return this._LogFileSeverity;
        }
        if (string.equals("LoggerSeverity")) {
            return this._LoggerSeverity;
        }
        if (string.equals("LoggerSeverityProperties")) {
            return this._LoggerSeverityProperties;
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("StacktraceDepth")) {
            return new Integer(this._StacktraceDepth);
        }
        if (string.equals("StdoutFormat")) {
            return this._StdoutFormat;
        }
        if (string.equals("StdoutLogStack")) {
            return new Boolean(this._StdoutLogStack);
        }
        if (string.equals("StdoutSeverity")) {
            return this._StdoutSeverity;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends LogFileMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 17: {
                    if (!string.equals("log-file-severity")) break;
                    return 22;
                }
                case 15: {
                    if (string.equals("logger-severity")) {
                        return 20;
                    }
                    if (!string.equals("stdout-severity")) break;
                    return 23;
                }
                case 26: {
                    if (!string.equals("logger-severity-properties")) break;
                    return 21;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 16: {
                    if (string.equals("stacktrace-depth")) {
                        return 26;
                    }
                    if (!string.equals("stdout-log-stack")) break;
                    return 25;
                }
                case 13: {
                    if (!string.equals("stdout-format")) break;
                    return 24;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 22: {
                    return "log-file-severity";
                }
                case 20: {
                    return "logger-severity";
                }
                case 21: {
                    return "logger-severity-properties";
                }
                case 2: {
                    return "name";
                }
                case 26: {
                    return "stacktrace-depth";
                }
                case 24: {
                    return "stdout-format";
                }
                case 23: {
                    return "stdout-severity";
                }
                case 25: {
                    return "stdout-log-stack";
                }
            }
            return super.getElementName(n);
        }

        public boolean isConfigurable(int n) {
            switch (n) {
                case 15: {
                    return true;
                }
                case 8: {
                    return true;
                }
                case 13: {
                    return true;
                }
            }
            return super.isConfigurable(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends LogFileMBeanImpl.Helper {
        private CommonLogMBeanImpl bean;

        protected Helper(CommonLogMBeanImpl commonLogMBeanImpl) {
            super(commonLogMBeanImpl);
            this.bean = commonLogMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 22: {
                    return "LogFileSeverity";
                }
                case 20: {
                    return "LoggerSeverity";
                }
                case 21: {
                    return "LoggerSeverityProperties";
                }
                case 2: {
                    return "Name";
                }
                case 26: {
                    return "StacktraceDepth";
                }
                case 24: {
                    return "StdoutFormat";
                }
                case 23: {
                    return "StdoutSeverity";
                }
                case 25: {
                    return "StdoutLogStack";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("LogFileSeverity")) {
                return 22;
            }
            if (string.equals("LoggerSeverity")) {
                return 20;
            }
            if (string.equals("LoggerSeverityProperties")) {
                return 21;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("StacktraceDepth")) {
                return 26;
            }
            if (string.equals("StdoutFormat")) {
                return 24;
            }
            if (string.equals("StdoutSeverity")) {
                return 23;
            }
            if (string.equals("StdoutLogStack")) {
                return 25;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isLogFileSeveritySet()) {
                    stringBuffer.append("LogFileSeverity");
                    stringBuffer.append(String.valueOf(this.bean.getLogFileSeverity()));
                }
                if (this.bean.isLoggerSeveritySet()) {
                    stringBuffer.append("LoggerSeverity");
                    stringBuffer.append(String.valueOf(this.bean.getLoggerSeverity()));
                }
                if (this.bean.isLoggerSeverityPropertiesSet()) {
                    stringBuffer.append("LoggerSeverityProperties");
                    stringBuffer.append(String.valueOf(this.bean.getLoggerSeverityProperties()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isStacktraceDepthSet()) {
                    stringBuffer.append("StacktraceDepth");
                    stringBuffer.append(String.valueOf(this.bean.getStacktraceDepth()));
                }
                if (this.bean.isStdoutFormatSet()) {
                    stringBuffer.append("StdoutFormat");
                    stringBuffer.append(String.valueOf(this.bean.getStdoutFormat()));
                }
                if (this.bean.isStdoutSeveritySet()) {
                    stringBuffer.append("StdoutSeverity");
                    stringBuffer.append(String.valueOf(this.bean.getStdoutSeverity()));
                }
                if (this.bean.isStdoutLogStackSet()) {
                    stringBuffer.append("StdoutLogStack");
                    stringBuffer.append(String.valueOf(this.bean.isStdoutLogStack()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                CommonLogMBeanImpl commonLogMBeanImpl = (CommonLogMBeanImpl)abstractDescriptorBean;
                this.computeDiff("LogFileSeverity", this.bean.getLogFileSeverity(), commonLogMBeanImpl.getLogFileSeverity(), true);
                this.computeDiff("LoggerSeverity", this.bean.getLoggerSeverity(), commonLogMBeanImpl.getLoggerSeverity(), true);
                this.computeDiff("LoggerSeverityProperties", this.bean.getLoggerSeverityProperties(), commonLogMBeanImpl.getLoggerSeverityProperties(), true);
                this.computeDiff("Name", this.bean.getName(), commonLogMBeanImpl.getName(), false);
                this.computeDiff("StacktraceDepth", this.bean.getStacktraceDepth(), commonLogMBeanImpl.getStacktraceDepth(), true);
                this.computeDiff("StdoutFormat", this.bean.getStdoutFormat(), commonLogMBeanImpl.getStdoutFormat(), false);
                this.computeDiff("StdoutSeverity", this.bean.getStdoutSeverity(), commonLogMBeanImpl.getStdoutSeverity(), true);
                this.computeDiff("StdoutLogStack", this.bean.isStdoutLogStack(), commonLogMBeanImpl.isStdoutLogStack(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                CommonLogMBeanImpl commonLogMBeanImpl = (CommonLogMBeanImpl)beanUpdateEvent.getSourceBean();
                CommonLogMBeanImpl commonLogMBeanImpl2 = (CommonLogMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("LogFileSeverity")) {
                    commonLogMBeanImpl.setLogFileSeverity(commonLogMBeanImpl2.getLogFileSeverity());
                    commonLogMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                } else if (string.equals("LoggerSeverity")) {
                    commonLogMBeanImpl.setLoggerSeverity(commonLogMBeanImpl2.getLoggerSeverity());
                    commonLogMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                } else if (string.equals("LoggerSeverityProperties")) {
                    commonLogMBeanImpl.setLoggerSeverityProperties(commonLogMBeanImpl2.getLoggerSeverityProperties() == null ? null : (Properties)commonLogMBeanImpl2.getLoggerSeverityProperties().clone());
                    commonLogMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                } else if (string.equals("Name")) {
                    commonLogMBeanImpl.setName(commonLogMBeanImpl2.getName());
                    commonLogMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (string.equals("StacktraceDepth")) {
                    commonLogMBeanImpl.setStacktraceDepth(commonLogMBeanImpl2.getStacktraceDepth());
                    commonLogMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 26);
                } else if (string.equals("StdoutFormat")) {
                    commonLogMBeanImpl.setStdoutFormat(commonLogMBeanImpl2.getStdoutFormat());
                    commonLogMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                } else if (string.equals("StdoutSeverity")) {
                    commonLogMBeanImpl.setStdoutSeverity(commonLogMBeanImpl2.getStdoutSeverity());
                    commonLogMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                } else if (string.equals("StdoutLogStack")) {
                    commonLogMBeanImpl.setStdoutLogStack(commonLogMBeanImpl2.isStdoutLogStack());
                    commonLogMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                CommonLogMBeanImpl commonLogMBeanImpl = (CommonLogMBeanImpl)abstractDescriptorBean;
                super.finishCopy(commonLogMBeanImpl, bl, list);
                if ((list == null || !list.contains("LogFileSeverity")) && this.bean.isLogFileSeveritySet()) {
                    commonLogMBeanImpl.setLogFileSeverity(this.bean.getLogFileSeverity());
                }
                if ((list == null || !list.contains("LoggerSeverity")) && this.bean.isLoggerSeveritySet()) {
                    commonLogMBeanImpl.setLoggerSeverity(this.bean.getLoggerSeverity());
                }
                if ((list == null || !list.contains("LoggerSeverityProperties")) && this.bean.isLoggerSeverityPropertiesSet()) {
                    commonLogMBeanImpl.setLoggerSeverityProperties(this.bean.getLoggerSeverityProperties());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    commonLogMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("StacktraceDepth")) && this.bean.isStacktraceDepthSet()) {
                    commonLogMBeanImpl.setStacktraceDepth(this.bean.getStacktraceDepth());
                }
                if ((list == null || !list.contains("StdoutFormat")) && this.bean.isStdoutFormatSet()) {
                    commonLogMBeanImpl.setStdoutFormat(this.bean.getStdoutFormat());
                }
                if ((list == null || !list.contains("StdoutSeverity")) && this.bean.isStdoutSeveritySet()) {
                    commonLogMBeanImpl.setStdoutSeverity(this.bean.getStdoutSeverity());
                }
                if ((list == null || !list.contains("StdoutLogStack")) && this.bean.isStdoutLogStackSet()) {
                    commonLogMBeanImpl.setStdoutLogStack(this.bean.isStdoutLogStack());
                }
                return commonLogMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

