/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationExtensionMBean;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.mbeans.custom.ConfigurationExtension;
import weblogic.utils.collections.CombinedIterator;

public class ConfigurationExtensionMBeanImpl
extends ConfigurationMBeanImpl
implements ConfigurationExtensionMBean,
Serializable {
    private String _DescriptorFileName;
    private String _Name;
    private ConfigurationExtension _customizer;
    private static SchemaHelper2 _schemaHelper;

    public ConfigurationExtensionMBeanImpl() {
        try {
            this._customizer = new ConfigurationExtension(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public ConfigurationExtensionMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new ConfigurationExtension(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getDescriptorFileName() {
        if (!this._isSet(7)) {
            try {
                return this.getName() + ".xml";
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._DescriptorFileName;
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public boolean isDescriptorFileNameSet() {
        return this._isSet(7);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public void setDescriptorFileName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._DescriptorFileName;
        this._DescriptorFileName = string;
        this._postSet(7, string2, string);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 7;
        }
        try {
            switch (n) {
                case 7: {
                    this._DescriptorFileName = null;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "ConfigurationExtension";
    }

    public void putValue(String string, Object object) {
        if (string.equals("DescriptorFileName")) {
            String string2 = this._DescriptorFileName;
            this._DescriptorFileName = (String)object;
            this._postSet(7, string2, this._DescriptorFileName);
            return;
        }
        if (string.equals("Name")) {
            String string3 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string3, this._Name);
            return;
        }
        if (string.equals("customizer")) {
            ConfigurationExtension configurationExtension = this._customizer;
            this._customizer = (ConfigurationExtension)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("DescriptorFileName")) {
            return this._DescriptorFileName;
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 20: {
                    if (!string.equals("descriptor-file-name")) break;
                    return 7;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 7: {
                    return "descriptor-file-name";
                }
                case 2: {
                    return "name";
                }
            }
            return super.getElementName(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private ConfigurationExtensionMBeanImpl bean;

        protected Helper(ConfigurationExtensionMBeanImpl configurationExtensionMBeanImpl) {
            super(configurationExtensionMBeanImpl);
            this.bean = configurationExtensionMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 7: {
                    return "DescriptorFileName";
                }
                case 2: {
                    return "Name";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("DescriptorFileName")) {
                return 7;
            }
            if (string.equals("Name")) {
                return 2;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isDescriptorFileNameSet()) {
                    stringBuffer.append("DescriptorFileName");
                    stringBuffer.append(String.valueOf(this.bean.getDescriptorFileName()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                ConfigurationExtensionMBeanImpl configurationExtensionMBeanImpl = (ConfigurationExtensionMBeanImpl)abstractDescriptorBean;
                this.computeDiff("DescriptorFileName", this.bean.getDescriptorFileName(), configurationExtensionMBeanImpl.getDescriptorFileName(), false);
                this.computeDiff("Name", this.bean.getName(), configurationExtensionMBeanImpl.getName(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                ConfigurationExtensionMBeanImpl configurationExtensionMBeanImpl = (ConfigurationExtensionMBeanImpl)beanUpdateEvent.getSourceBean();
                ConfigurationExtensionMBeanImpl configurationExtensionMBeanImpl2 = (ConfigurationExtensionMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("DescriptorFileName")) {
                    configurationExtensionMBeanImpl.setDescriptorFileName(configurationExtensionMBeanImpl2.getDescriptorFileName());
                    configurationExtensionMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("Name")) {
                    configurationExtensionMBeanImpl.setName(configurationExtensionMBeanImpl2.getName());
                    configurationExtensionMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                ConfigurationExtensionMBeanImpl configurationExtensionMBeanImpl = (ConfigurationExtensionMBeanImpl)abstractDescriptorBean;
                super.finishCopy(configurationExtensionMBeanImpl, bl, list);
                if ((list == null || !list.contains("DescriptorFileName")) && this.bean.isDescriptorFileNameSet()) {
                    configurationExtensionMBeanImpl.setDescriptorFileName(this.bean.getDescriptorFileName());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    configurationExtensionMBeanImpl.setName(this.bean.getName());
                }
                return configurationExtensionMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

