/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.AbstractSchemaHelper2;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.WebLogicMBeanImpl;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.provider.custom.ConfigurationMBeanCustomizer;
import weblogic.utils.collections.CombinedIterator;

public class ConfigurationMBeanImpl
extends WebLogicMBeanImpl
implements ConfigurationMBean,
Serializable {
    private String _Comments;
    private boolean _DefaultedMBean;
    private String _Name;
    private String _Notes;
    private boolean _PersistenceEnabled;
    private ConfigurationMBeanCustomizer _customizer;
    private static SchemaHelper2 _schemaHelper;

    public ConfigurationMBeanImpl() {
        try {
            this._customizer = new ConfigurationMBeanCustomizer(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public ConfigurationMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new ConfigurationMBeanCustomizer(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public String getNotes() {
        return this._Notes;
    }

    public boolean isNotesSet() {
        return this._isSet(3);
    }

    public void setNotes(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String string2 = this._Notes;
        this._Notes = string;
        this._postSet(3, string2, string);
    }

    public boolean isPersistenceEnabled() {
        return this._PersistenceEnabled;
    }

    public boolean isPersistenceEnabledSet() {
        return this._isSet(4);
    }

    public void setPersistenceEnabled(boolean bl) {
        this._PersistenceEnabled = bl;
    }

    public boolean isDefaultedMBean() {
        return this._DefaultedMBean;
    }

    public boolean isDefaultedMBeanSet() {
        return this._isSet(5);
    }

    public void setDefaultedMBean(boolean bl) {
        this._DefaultedMBean = bl;
    }

    public String getComments() {
        return this._Comments;
    }

    public boolean isCommentsSet() {
        return this._isSet(6);
    }

    public void setComments(String string) {
        this._Comments = string = string == null ? null : string.trim();
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 6;
        }
        try {
            switch (n) {
                case 6: {
                    this._Comments = null;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 3: {
                    this._Notes = null;
                    if (bl) break;
                }
                case 5: {
                    this._DefaultedMBean = false;
                    if (bl) break;
                }
                case 4: {
                    this._PersistenceEnabled = true;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "Configuration";
    }

    public void putValue(String string, Object object) {
        if (string.equals("Comments")) {
            String string2 = this._Comments;
            this._Comments = (String)object;
            this._postSet(6, string2, this._Comments);
            return;
        }
        if (string.equals("DefaultedMBean")) {
            boolean bl = this._DefaultedMBean;
            this._DefaultedMBean = (Boolean)object;
            this._postSet(5, bl, this._DefaultedMBean);
            return;
        }
        if (string.equals("Name")) {
            String string3 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string3, this._Name);
            return;
        }
        if (string.equals("Notes")) {
            String string4 = this._Notes;
            this._Notes = (String)object;
            this._postSet(3, string4, this._Notes);
            return;
        }
        if (string.equals("PersistenceEnabled")) {
            boolean bl = this._PersistenceEnabled;
            this._PersistenceEnabled = (Boolean)object;
            this._postSet(4, bl, this._PersistenceEnabled);
            return;
        }
        if (string.equals("customizer")) {
            ConfigurationMBeanCustomizer configurationMBeanCustomizer = this._customizer;
            this._customizer = (ConfigurationMBeanCustomizer)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("Comments")) {
            return this._Comments;
        }
        if (string.equals("DefaultedMBean")) {
            return new Boolean(this._DefaultedMBean);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("Notes")) {
            return this._Notes;
        }
        if (string.equals("PersistenceEnabled")) {
            return new Boolean(this._PersistenceEnabled);
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends AbstractSchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 8: {
                    if (!string.equals("comments")) break;
                    return 6;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 5: {
                    if (!string.equals("notes")) break;
                    return 3;
                }
                case 15: {
                    if (!string.equals("defaultedm-bean")) break;
                    return 5;
                }
                case 19: {
                    if (!string.equals("persistence-enabled")) break;
                    return 4;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 6: {
                    return "comments";
                }
                case 2: {
                    return "name";
                }
                case 3: {
                    return "notes";
                }
                case 5: {
                    return "defaultedm-bean";
                }
                case 4: {
                    return "persistence-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends WebLogicMBeanImpl.Helper {
        private ConfigurationMBeanImpl bean;

        protected Helper(ConfigurationMBeanImpl configurationMBeanImpl) {
            super(configurationMBeanImpl);
            this.bean = configurationMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 6: {
                    return "Comments";
                }
                case 2: {
                    return "Name";
                }
                case 3: {
                    return "Notes";
                }
                case 5: {
                    return "DefaultedMBean";
                }
                case 4: {
                    return "PersistenceEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("Comments")) {
                return 6;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("Notes")) {
                return 3;
            }
            if (string.equals("DefaultedMBean")) {
                return 5;
            }
            if (string.equals("PersistenceEnabled")) {
                return 4;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isCommentsSet()) {
                    stringBuffer.append("Comments");
                    stringBuffer.append(String.valueOf(this.bean.getComments()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isNotesSet()) {
                    stringBuffer.append("Notes");
                    stringBuffer.append(String.valueOf(this.bean.getNotes()));
                }
                if (this.bean.isDefaultedMBeanSet()) {
                    stringBuffer.append("DefaultedMBean");
                    stringBuffer.append(String.valueOf(this.bean.isDefaultedMBean()));
                }
                if (this.bean.isPersistenceEnabledSet()) {
                    stringBuffer.append("PersistenceEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isPersistenceEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                ConfigurationMBeanImpl configurationMBeanImpl = (ConfigurationMBeanImpl)abstractDescriptorBean;
                this.computeDiff("Name", this.bean.getName(), configurationMBeanImpl.getName(), false);
                this.computeDiff("Notes", this.bean.getNotes(), configurationMBeanImpl.getNotes(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                ConfigurationMBeanImpl configurationMBeanImpl = (ConfigurationMBeanImpl)beanUpdateEvent.getSourceBean();
                ConfigurationMBeanImpl configurationMBeanImpl2 = (ConfigurationMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (!string.equals("Comments")) {
                    if (string.equals("Name")) {
                        configurationMBeanImpl.setName(configurationMBeanImpl2.getName());
                        configurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                    } else if (string.equals("Notes")) {
                        configurationMBeanImpl.setNotes(configurationMBeanImpl2.getNotes());
                        configurationMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 3);
                    } else if (!string.equals("DefaultedMBean") && !string.equals("PersistenceEnabled")) {
                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                ConfigurationMBeanImpl configurationMBeanImpl = (ConfigurationMBeanImpl)abstractDescriptorBean;
                super.finishCopy(configurationMBeanImpl, bl, list);
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    configurationMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("Notes")) && this.bean.isNotesSet()) {
                    configurationMBeanImpl.setNotes(this.bean.getNotes());
                }
                return configurationMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

