/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.ConfigurationPropertyMBean;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class ConfigurationPropertyMBeanImpl
extends ConfigurationMBeanImpl
implements ConfigurationPropertyMBean,
Serializable {
    private boolean _EncryptValueRequired;
    private String _EncryptedValue;
    private byte[] _EncryptedValueEncrypted;
    private String _Value;
    private static SchemaHelper2 _schemaHelper;

    public ConfigurationPropertyMBeanImpl() {
        this._initializeProperty(-1);
    }

    public ConfigurationPropertyMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public boolean isEncryptValueRequired() {
        return this._EncryptValueRequired;
    }

    public boolean isEncryptValueRequiredSet() {
        return this._isSet(7);
    }

    public void setEncryptValueRequired(boolean bl) {
        boolean bl2 = this._EncryptValueRequired;
        this._EncryptValueRequired = bl;
        this._postSet(7, bl2, bl);
    }

    public String getValue() {
        return this._Value;
    }

    public boolean isValueSet() {
        return this._isSet(8);
    }

    public void setValue(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._Value;
        this._Value = string;
        this._postSet(8, string2, string);
    }

    public String getEncryptedValue() {
        byte[] byArray = this.getEncryptedValueEncrypted();
        return byArray == null ? null : this._decrypt("EncryptedValue", byArray);
    }

    public boolean isEncryptedValueSet() {
        return this.isEncryptedValueEncryptedSet();
    }

    public void setEncryptedValue(String string) {
        string = string == null ? null : string.trim();
        try {
            this.setEncryptedValueEncrypted(string == null ? null : this._encrypt("EncryptedValue", string));
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            // empty catch block
        }
    }

    public byte[] getEncryptedValueEncrypted() {
        return this._getHelper()._cloneArray(this._EncryptedValueEncrypted);
    }

    public String getEncryptedValueEncryptedAsString() {
        byte[] byArray = this.getEncryptedValueEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isEncryptedValueEncryptedSet() {
        return this._isSet(10);
    }

    public void setEncryptedValueEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setEncryptedValueEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public void setEncryptedValueEncrypted(byte[] byArray) throws InvalidAttributeValueException {
        byte[] byArray2 = this._EncryptedValueEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: EncryptedValueEncrypted of ConfigurationPropertyMBean");
        }
        this._getHelper()._clearArray(this._EncryptedValueEncrypted);
        this._EncryptedValueEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(10, byArray2, byArray);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
            if (n == 9) {
                this._markSet(10, false);
            }
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 9;
        }
        try {
            switch (n) {
                case 9: {
                    this._EncryptedValueEncrypted = null;
                    if (bl) break;
                }
                case 10: {
                    this._EncryptedValueEncrypted = null;
                    if (bl) break;
                }
                case 8: {
                    this._Value = "";
                    if (bl) break;
                }
                case 7: {
                    this._EncryptValueRequired = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "ConfigurationProperty";
    }

    public void putValue(String string, Object object) {
        if (string.equals("EncryptValueRequired")) {
            boolean bl = this._EncryptValueRequired;
            this._EncryptValueRequired = (Boolean)object;
            this._postSet(7, bl, this._EncryptValueRequired);
            return;
        }
        if (string.equals("EncryptedValue")) {
            String string2 = this._EncryptedValue;
            this._EncryptedValue = (String)object;
            this._postSet(9, string2, this._EncryptedValue);
            return;
        }
        if (string.equals("EncryptedValueEncrypted")) {
            byte[] byArray = this._EncryptedValueEncrypted;
            this._EncryptedValueEncrypted = (byte[])object;
            this._postSet(10, byArray, this._EncryptedValueEncrypted);
            return;
        }
        if (string.equals("Value")) {
            String string3 = this._Value;
            this._Value = (String)object;
            this._postSet(8, string3, this._Value);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("EncryptValueRequired")) {
            return new Boolean(this._EncryptValueRequired);
        }
        if (string.equals("EncryptedValue")) {
            return this._EncryptedValue;
        }
        if (string.equals("EncryptedValueEncrypted")) {
            return this._EncryptedValueEncrypted;
        }
        if (string.equals("Value")) {
            return this._Value;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 15: {
                    if (!string.equals("encrypted-value")) break;
                    return 9;
                }
                case 25: {
                    if (!string.equals("encrypted-value-encrypted")) break;
                    return 10;
                }
                case 5: {
                    if (!string.equals("value")) break;
                    return 8;
                }
                case 22: {
                    if (!string.equals("encrypt-value-required")) break;
                    return 7;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 9: {
                    return "encrypted-value";
                }
                case 10: {
                    return "encrypted-value-encrypted";
                }
                case 8: {
                    return "value";
                }
                case 7: {
                    return "encrypt-value-required";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                default: 
            }
            return super.isArray(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private ConfigurationPropertyMBeanImpl bean;

        protected Helper(ConfigurationPropertyMBeanImpl configurationPropertyMBeanImpl) {
            super(configurationPropertyMBeanImpl);
            this.bean = configurationPropertyMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 9: {
                    return "EncryptedValue";
                }
                case 10: {
                    return "EncryptedValueEncrypted";
                }
                case 8: {
                    return "Value";
                }
                case 7: {
                    return "EncryptValueRequired";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("EncryptedValue")) {
                return 9;
            }
            if (string.equals("EncryptedValueEncrypted")) {
                return 10;
            }
            if (string.equals("Value")) {
                return 8;
            }
            if (string.equals("EncryptValueRequired")) {
                return 7;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isEncryptedValueSet()) {
                    stringBuffer.append("EncryptedValue");
                    stringBuffer.append(String.valueOf(this.bean.getEncryptedValue()));
                }
                if (this.bean.isEncryptedValueEncryptedSet()) {
                    stringBuffer.append("EncryptedValueEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getEncryptedValueEncrypted())));
                }
                if (this.bean.isValueSet()) {
                    stringBuffer.append("Value");
                    stringBuffer.append(String.valueOf(this.bean.getValue()));
                }
                if (this.bean.isEncryptValueRequiredSet()) {
                    stringBuffer.append("EncryptValueRequired");
                    stringBuffer.append(String.valueOf(this.bean.isEncryptValueRequired()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                ConfigurationPropertyMBeanImpl configurationPropertyMBeanImpl = (ConfigurationPropertyMBeanImpl)abstractDescriptorBean;
                this.computeDiff("EncryptedValueEncrypted", this.bean.getEncryptedValueEncrypted(), configurationPropertyMBeanImpl.getEncryptedValueEncrypted(), false);
                this.computeDiff("Value", this.bean.getValue(), configurationPropertyMBeanImpl.getValue(), true);
                this.computeDiff("EncryptValueRequired", this.bean.isEncryptValueRequired(), configurationPropertyMBeanImpl.isEncryptValueRequired(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                ConfigurationPropertyMBeanImpl configurationPropertyMBeanImpl = (ConfigurationPropertyMBeanImpl)beanUpdateEvent.getSourceBean();
                ConfigurationPropertyMBeanImpl configurationPropertyMBeanImpl2 = (ConfigurationPropertyMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (!string.equals("EncryptedValue")) {
                    if (string.equals("EncryptedValueEncrypted")) {
                        configurationPropertyMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                    } else if (string.equals("Value")) {
                        configurationPropertyMBeanImpl.setValue(configurationPropertyMBeanImpl2.getValue());
                        configurationPropertyMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                    } else if (string.equals("EncryptValueRequired")) {
                        configurationPropertyMBeanImpl.setEncryptValueRequired(configurationPropertyMBeanImpl2.isEncryptValueRequired());
                        configurationPropertyMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                    } else {
                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                ConfigurationPropertyMBeanImpl configurationPropertyMBeanImpl = (ConfigurationPropertyMBeanImpl)abstractDescriptorBean;
                super.finishCopy(configurationPropertyMBeanImpl, bl, list);
                if ((list == null || !list.contains("EncryptedValueEncrypted")) && this.bean.isEncryptedValueEncryptedSet()) {
                    byte[] byArray = this.bean.getEncryptedValueEncrypted();
                    configurationPropertyMBeanImpl.setEncryptedValueEncrypted(byArray == null ? null : (byte[])byArray.clone());
                }
                if ((list == null || !list.contains("Value")) && this.bean.isValueSet()) {
                    configurationPropertyMBeanImpl.setValue(this.bean.getValue());
                }
                if ((list == null || !list.contains("EncryptValueRequired")) && this.bean.isEncryptValueRequiredSet()) {
                    configurationPropertyMBeanImpl.setEncryptValueRequired(this.bean.isEncryptValueRequired());
                }
                return configurationPropertyMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

