/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.util.Arrays;

public class ConfigurationValidator {
    static char[] invalid_chars = new char[]{':', ',', '=', '*', '?', '%'};

    public static void validateName(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Name may not be null or empty string");
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (Arrays.binarySearch(invalid_chars, cArray[i]) < 0) continue;
            throw new IllegalArgumentException("Name '" + string + "' contains illegal character '" + cArray[i] + "'");
        }
    }

    public static void validateClassName(String string) throws IllegalArgumentException {
        if (string == null) {
            return;
        }
        if (string.endsWith(".class")) {
            throw new IllegalArgumentException("Invalid class name: " + string + " - Classnames may not end with '.class'");
        }
    }

    static {
        Arrays.sort(invalid_chars);
    }
}

