/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.beangen.StringHelper;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ComponentMBeanImpl;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.ConnectorComponentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.TargetMBeanImpl;
import weblogic.management.mbeans.custom.ConnectorComponent;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class ConnectorComponentMBeanImpl
extends ComponentMBeanImpl
implements ConnectorComponentMBean,
Serializable {
    private TargetMBean[] _ActivatedTargets;
    private ApplicationMBean _Application;
    private HashSet _AuthenticationMechanisms;
    private ClassLoader _ClassLoader;
    private Hashtable _ConfigProperties;
    private String _ConnectionFactoryDescription;
    private String _ConnectionFactoryImpl;
    private String _ConnectionFactoryInterface;
    private String _ConnectionFactoryName;
    private String _ConnectionImpl;
    private String _ConnectionInterface;
    private boolean _ConnectionProfilingEnabled;
    private String _Description;
    private String _DisplayName;
    private String _EisType;
    private String _LargeIcon;
    private String _LicenseDescription;
    private boolean _LicenseRequired;
    private String _ManagedConnectionFactoryClass;
    private int _MaxCapacity;
    private String _Name;
    private HashSet _SecurityPermissions;
    private String _SmallIcon;
    private String _SpecVersion;
    private TargetMBean[] _Targets;
    private String _TransactionSupport;
    private String _VendorName;
    private String _Version;
    private ConnectorComponent _customizer;
    private boolean _reauthenticationSupport;
    private static SchemaHelper2 _schemaHelper;

    public ConnectorComponentMBeanImpl() {
        try {
            this._customizer = new ConnectorComponent(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public ConnectorComponentMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new ConnectorComponent(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public ApplicationMBean getApplication() {
        return this._customizer.getApplication();
    }

    public String getDescription() {
        return this._Description;
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public TargetMBean[] getTargets() {
        return this._customizer.getTargets();
    }

    public String getTargetsAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getTargets());
    }

    public boolean isApplicationSet() {
        return this._isSet(9);
    }

    public boolean isDescriptionSet() {
        return this._isSet(12);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isTargetsSet() {
        return this._isSet(7);
    }

    public void setTargetsAsString(String string) {
        if (string == null || string.length() == 0) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._initializeProperty(7);
            this._postSet(7, targetMBeanArray, this._Targets);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._Targets);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, TargetMBean.class, new ReferenceManager.Resolver(this, 7){

                    public void resolveReference(Object object) {
                        try {
                            ConnectorComponentMBeanImpl.this.addTarget((TargetMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (TargetMBean targetMBean : this._Targets) {
                    if (!string2.equals(targetMBean.getName())) continue;
                    try {
                        this.removeTarget(targetMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void setApplication(ApplicationMBean applicationMBean) throws InvalidAttributeValueException {
        this._customizer.setApplication(applicationMBean);
    }

    public void setDescription(String string) throws InvalidAttributeValueException {
        this._Description = string = string == null ? null : string.trim();
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setTargets(TargetMBean[] targetMBeanArray) throws InvalidAttributeValueException, DistributedManagementException {
        targetMBeanArray = targetMBeanArray == null ? new TargetMBeanImpl[]{} : targetMBeanArray;
        targetMBeanArray = (TargetMBean[])this._getHelper()._cleanAndValidateArray((Object)targetMBeanArray, TargetMBean.class);
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            if (targetMBeanArray[i] == null) continue;
            ResolvedReference resolvedReference = new ResolvedReference(this, 7, (AbstractDescriptorBean)targetMBeanArray[i]){

                protected Object getPropertyValue() {
                    return ConnectorComponentMBeanImpl.this.getTargets();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)targetMBeanArray[i], resolvedReference);
        }
        TargetMBean[] targetMBeanArray2 = this.getTargets();
        this._customizer.setTargets(targetMBeanArray);
        this._postSet(7, targetMBeanArray2, targetMBeanArray);
    }

    public boolean addTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        this._getHelper()._ensureNonNull((Object)targetMBean);
        if (!((AbstractDescriptorBean)targetMBean).isChildProperty((DescriptorBean)this, 7)) {
            TargetMBean[] targetMBeanArray = (TargetMBean[])this._getHelper()._extendArray((Object)this.getTargets(), TargetMBean.class, (Object)targetMBean);
            try {
                this.setTargets(targetMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public String getDisplayName() {
        return this._DisplayName;
    }

    public boolean isDisplayNameSet() {
        return this._isSet(13);
    }

    public boolean removeTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        TargetMBean[] targetMBeanArray = this.getTargets();
        TargetMBean[] targetMBeanArray2 = (TargetMBean[])this._getHelper()._removeElement((Object)targetMBeanArray, TargetMBean.class, (Object)targetMBean);
        if (targetMBeanArray2.length != targetMBeanArray.length) {
            try {
                this.setTargets(targetMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public void setDisplayName(String string) throws InvalidAttributeValueException {
        this._DisplayName = string = string == null ? null : string.trim();
    }

    public TargetMBean[] getActivatedTargets() {
        return this._customizer.getActivatedTargets();
    }

    public String getEisType() {
        return this._EisType;
    }

    public boolean isActivatedTargetsSet() {
        return this._isSet(11);
    }

    public boolean isEisTypeSet() {
        return this._isSet(14);
    }

    public void addActivatedTarget(TargetMBean targetMBean) {
        this._getHelper()._ensureNonNull((Object)targetMBean);
        if (!((AbstractDescriptorBean)targetMBean).isChildProperty((DescriptorBean)this, 11)) {
            TargetMBean[] targetMBeanArray = (TargetMBean[])this._getHelper()._extendArray((Object)this.getActivatedTargets(), TargetMBean.class, (Object)targetMBean);
            try {
                this.setActivatedTargets(targetMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void setEisType(String string) throws InvalidAttributeValueException {
        this._EisType = string = string == null ? null : string.trim();
    }

    public String getSmallIcon() {
        return this._SmallIcon;
    }

    public boolean isSmallIconSet() {
        return this._isSet(15);
    }

    public void removeActivatedTarget(TargetMBean targetMBean) {
        TargetMBean[] targetMBeanArray = this.getActivatedTargets();
        TargetMBean[] targetMBeanArray2 = (TargetMBean[])this._getHelper()._removeElement((Object)targetMBeanArray, TargetMBean.class, (Object)targetMBean);
        if (targetMBeanArray2.length != targetMBeanArray.length) {
            try {
                this.setActivatedTargets(targetMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void setActivatedTargets(TargetMBean[] targetMBeanArray) {
        targetMBeanArray = targetMBeanArray == null ? new TargetMBeanImpl[]{} : targetMBeanArray;
        this._ActivatedTargets = targetMBeanArray;
    }

    public void setSmallIcon(String string) throws InvalidAttributeValueException {
        this._SmallIcon = string = string == null ? null : string.trim();
    }

    public boolean activated(TargetMBean targetMBean) {
        return this._customizer.activated(targetMBean);
    }

    public String getLargeIcon() {
        return this._LargeIcon;
    }

    public boolean isLargeIconSet() {
        return this._isSet(16);
    }

    public void refreshDDsIfNeeded(String[] stringArray) {
        this._customizer.refreshDDsIfNeeded(stringArray);
    }

    public void setLargeIcon(String string) throws InvalidAttributeValueException {
        this._LargeIcon = string = string == null ? null : string.trim();
    }

    public String getLicenseDescription() {
        return this._LicenseDescription;
    }

    public boolean isLicenseDescriptionSet() {
        return this._isSet(17);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void setLicenseDescription(String string) throws InvalidAttributeValueException {
        this._LicenseDescription = string = string == null ? null : string.trim();
    }

    public boolean getLicenseRequired() {
        return this._LicenseRequired;
    }

    public boolean isLicenseRequiredSet() {
        return this._isSet(18);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setLicenseRequired(boolean bl) throws InvalidAttributeValueException {
        this._LicenseRequired = bl;
    }

    public String getSpecVersion() {
        return this._SpecVersion;
    }

    public boolean isSpecVersionSet() {
        return this._isSet(19);
    }

    public void setSpecVersion(String string) throws InvalidAttributeValueException {
        this._SpecVersion = string = string == null ? null : string.trim();
    }

    public String getVendorName() {
        return this._VendorName;
    }

    public boolean isVendorNameSet() {
        return this._isSet(20);
    }

    public void setVendorName(String string) throws InvalidAttributeValueException {
        this._VendorName = string = string == null ? null : string.trim();
    }

    public String getVersion() {
        return this._Version;
    }

    public boolean isVersionSet() {
        return this._isSet(21);
    }

    public void setVersion(String string) throws InvalidAttributeValueException {
        this._Version = string = string == null ? null : string.trim();
    }

    public String getConnectionFactoryImpl() {
        return this._ConnectionFactoryImpl;
    }

    public boolean isConnectionFactoryImplSet() {
        return this._isSet(22);
    }

    public void setConnectionFactoryImpl(String string) throws InvalidAttributeValueException {
        this._ConnectionFactoryImpl = string = string == null ? null : string.trim();
    }

    public String getConnectionFactoryInterface() {
        return this._ConnectionFactoryInterface;
    }

    public boolean isConnectionFactoryInterfaceSet() {
        return this._isSet(23);
    }

    public void setConnectionFactoryInterface(String string) throws InvalidAttributeValueException {
        this._ConnectionFactoryInterface = string = string == null ? null : string.trim();
    }

    public String getConnectionImpl() {
        return this._ConnectionImpl;
    }

    public boolean isConnectionImplSet() {
        return this._isSet(24);
    }

    public void setConnectionImpl(String string) throws InvalidAttributeValueException {
        this._ConnectionImpl = string = string == null ? null : string.trim();
    }

    public String getConnectionInterface() {
        return this._ConnectionInterface;
    }

    public boolean isConnectionInterfaceSet() {
        return this._isSet(25);
    }

    public void setConnectionInterface(String string) throws InvalidAttributeValueException {
        this._ConnectionInterface = string = string == null ? null : string.trim();
    }

    public boolean getConnectionProfilingEnabled() {
        return this._ConnectionProfilingEnabled;
    }

    public boolean isConnectionProfilingEnabledSet() {
        return this._isSet(26);
    }

    public void setConnectionProfilingEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._ConnectionProfilingEnabled;
        this._ConnectionProfilingEnabled = bl;
        this._postSet(26, bl2, bl);
    }

    public String getManagedConnectionFactoryClass() {
        return this._ManagedConnectionFactoryClass;
    }

    public boolean isManagedConnectionFactoryClassSet() {
        return this._isSet(27);
    }

    public void setManagedConnectionFactoryClass(String string) throws InvalidAttributeValueException {
        this._ManagedConnectionFactoryClass = string = string == null ? null : string.trim();
    }

    public boolean getreauthenticationSupport() {
        return this._reauthenticationSupport;
    }

    public boolean isreauthenticationSupportSet() {
        return this._isSet(28);
    }

    public void setreauthenticationSupport(boolean bl) throws InvalidAttributeValueException {
        this._reauthenticationSupport = bl;
    }

    public String getTransactionSupport() {
        return this._TransactionSupport;
    }

    public boolean isTransactionSupportSet() {
        return this._isSet(29);
    }

    public void setTransactionSupport(String string) throws InvalidAttributeValueException {
        this._TransactionSupport = string = string == null ? null : string.trim();
    }

    public Hashtable getConfigProperties() {
        return this._ConfigProperties;
    }

    public boolean isConfigPropertiesSet() {
        return this._isSet(30);
    }

    public void setConfigProperties(Hashtable hashtable) {
        this._ConfigProperties = hashtable;
    }

    public HashSet getAuthenticationMechanisms() {
        return this._AuthenticationMechanisms;
    }

    public String getAuthenticationMechanismsAsString() {
        return StringHelper.objectToString((Object)this.getAuthenticationMechanisms());
    }

    public boolean isAuthenticationMechanismsSet() {
        return this._isSet(31);
    }

    public void setAuthenticationMechanismsAsString(String string) {
        try {
            this.setAuthenticationMechanisms(StringHelper.stringToHashSet((String)string));
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public void setAuthenticationMechanisms(HashSet hashSet) {
        HashSet hashSet2 = this._AuthenticationMechanisms;
        this._AuthenticationMechanisms = hashSet;
        this._postSet(31, hashSet2, hashSet);
    }

    public HashSet getSecurityPermissions() {
        return this._SecurityPermissions;
    }

    public boolean isSecurityPermissionsSet() {
        return this._isSet(32);
    }

    public void setSecurityPermissions(HashSet hashSet) {
        this._SecurityPermissions = hashSet;
    }

    public ClassLoader getClassLoader() {
        return this._ClassLoader;
    }

    public boolean isClassLoaderSet() {
        return this._isSet(33);
    }

    public void setClassLoader(ClassLoader classLoader) throws InvalidAttributeValueException {
        this._ClassLoader = classLoader;
    }

    public String getConnectionFactoryName() {
        return this._ConnectionFactoryName;
    }

    public boolean isConnectionFactoryNameSet() {
        return this._isSet(34);
    }

    public void setConnectionFactoryName(String string) throws InvalidAttributeValueException {
        this._ConnectionFactoryName = string = string == null ? null : string.trim();
    }

    public String getConnectionFactoryDescription() {
        return this._ConnectionFactoryDescription;
    }

    public boolean isConnectionFactoryDescriptionSet() {
        return this._isSet(35);
    }

    public void setConnectionFactoryDescription(String string) throws InvalidAttributeValueException {
        this._ConnectionFactoryDescription = string = string == null ? null : string.trim();
    }

    public int getMaxCapacity() {
        return this._MaxCapacity;
    }

    public boolean isMaxCapacitySet() {
        return this._isSet(36);
    }

    public void setMaxCapacity(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"MaxCapacity", (int)n, (int)1);
        this._MaxCapacity = n;
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 11;
        }
        try {
            switch (n) {
                case 11: {
                    this._ActivatedTargets = new TargetMBean[0];
                    if (bl) break;
                }
                case 9: {
                    this._customizer.setApplication(null);
                    if (bl) break;
                }
                case 31: {
                    this._AuthenticationMechanisms = null;
                    if (bl) break;
                }
                case 33: {
                    this._ClassLoader = null;
                    if (bl) break;
                }
                case 30: {
                    this._ConfigProperties = null;
                    if (bl) break;
                }
                case 35: {
                    this._ConnectionFactoryDescription = null;
                    if (bl) break;
                }
                case 22: {
                    this._ConnectionFactoryImpl = null;
                    if (bl) break;
                }
                case 23: {
                    this._ConnectionFactoryInterface = null;
                    if (bl) break;
                }
                case 34: {
                    this._ConnectionFactoryName = null;
                    if (bl) break;
                }
                case 24: {
                    this._ConnectionImpl = null;
                    if (bl) break;
                }
                case 25: {
                    this._ConnectionInterface = null;
                    if (bl) break;
                }
                case 26: {
                    this._ConnectionProfilingEnabled = false;
                    if (bl) break;
                }
                case 12: {
                    this._Description = null;
                    if (bl) break;
                }
                case 13: {
                    this._DisplayName = null;
                    if (bl) break;
                }
                case 14: {
                    this._EisType = null;
                    if (bl) break;
                }
                case 16: {
                    this._LargeIcon = null;
                    if (bl) break;
                }
                case 17: {
                    this._LicenseDescription = null;
                    if (bl) break;
                }
                case 18: {
                    this._LicenseRequired = false;
                    if (bl) break;
                }
                case 27: {
                    this._ManagedConnectionFactoryClass = null;
                    if (bl) break;
                }
                case 36: {
                    this._MaxCapacity = 10;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 32: {
                    this._SecurityPermissions = null;
                    if (bl) break;
                }
                case 15: {
                    this._SmallIcon = null;
                    if (bl) break;
                }
                case 19: {
                    this._SpecVersion = null;
                    if (bl) break;
                }
                case 7: {
                    this._customizer.setTargets(new TargetMBean[0]);
                    if (bl) break;
                }
                case 29: {
                    this._TransactionSupport = null;
                    if (bl) break;
                }
                case 20: {
                    this._VendorName = null;
                    if (bl) break;
                }
                case 21: {
                    this._Version = null;
                    if (bl) break;
                }
                case 28: {
                    this._reauthenticationSupport = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "ConnectorComponent";
    }

    public void putValue(String string, Object object) {
        if (string.equals("ActivatedTargets")) {
            TargetMBean[] targetMBeanArray = this._ActivatedTargets;
            this._ActivatedTargets = (TargetMBean[])object;
            this._postSet(11, targetMBeanArray, this._ActivatedTargets);
            return;
        }
        if (string.equals("Application")) {
            ApplicationMBean applicationMBean = this._Application;
            this._Application = (ApplicationMBean)object;
            this._postSet(9, applicationMBean, this._Application);
            return;
        }
        if (string.equals("AuthenticationMechanisms")) {
            HashSet hashSet = this._AuthenticationMechanisms;
            this._AuthenticationMechanisms = (HashSet)object;
            this._postSet(31, hashSet, this._AuthenticationMechanisms);
            return;
        }
        if (string.equals("ClassLoader")) {
            ClassLoader classLoader = this._ClassLoader;
            this._ClassLoader = (ClassLoader)object;
            this._postSet(33, classLoader, this._ClassLoader);
            return;
        }
        if (string.equals("ConfigProperties")) {
            Hashtable hashtable = this._ConfigProperties;
            this._ConfigProperties = (Hashtable)object;
            this._postSet(30, hashtable, this._ConfigProperties);
            return;
        }
        if (string.equals("ConnectionFactoryDescription")) {
            String string2 = this._ConnectionFactoryDescription;
            this._ConnectionFactoryDescription = (String)object;
            this._postSet(35, string2, this._ConnectionFactoryDescription);
            return;
        }
        if (string.equals("ConnectionFactoryImpl")) {
            String string3 = this._ConnectionFactoryImpl;
            this._ConnectionFactoryImpl = (String)object;
            this._postSet(22, string3, this._ConnectionFactoryImpl);
            return;
        }
        if (string.equals("ConnectionFactoryInterface")) {
            String string4 = this._ConnectionFactoryInterface;
            this._ConnectionFactoryInterface = (String)object;
            this._postSet(23, string4, this._ConnectionFactoryInterface);
            return;
        }
        if (string.equals("ConnectionFactoryName")) {
            String string5 = this._ConnectionFactoryName;
            this._ConnectionFactoryName = (String)object;
            this._postSet(34, string5, this._ConnectionFactoryName);
            return;
        }
        if (string.equals("ConnectionImpl")) {
            String string6 = this._ConnectionImpl;
            this._ConnectionImpl = (String)object;
            this._postSet(24, string6, this._ConnectionImpl);
            return;
        }
        if (string.equals("ConnectionInterface")) {
            String string7 = this._ConnectionInterface;
            this._ConnectionInterface = (String)object;
            this._postSet(25, string7, this._ConnectionInterface);
            return;
        }
        if (string.equals("ConnectionProfilingEnabled")) {
            boolean bl = this._ConnectionProfilingEnabled;
            this._ConnectionProfilingEnabled = (Boolean)object;
            this._postSet(26, bl, this._ConnectionProfilingEnabled);
            return;
        }
        if (string.equals("Description")) {
            String string8 = this._Description;
            this._Description = (String)object;
            this._postSet(12, string8, this._Description);
            return;
        }
        if (string.equals("DisplayName")) {
            String string9 = this._DisplayName;
            this._DisplayName = (String)object;
            this._postSet(13, string9, this._DisplayName);
            return;
        }
        if (string.equals("EisType")) {
            String string10 = this._EisType;
            this._EisType = (String)object;
            this._postSet(14, string10, this._EisType);
            return;
        }
        if (string.equals("LargeIcon")) {
            String string11 = this._LargeIcon;
            this._LargeIcon = (String)object;
            this._postSet(16, string11, this._LargeIcon);
            return;
        }
        if (string.equals("LicenseDescription")) {
            String string12 = this._LicenseDescription;
            this._LicenseDescription = (String)object;
            this._postSet(17, string12, this._LicenseDescription);
            return;
        }
        if (string.equals("LicenseRequired")) {
            boolean bl = this._LicenseRequired;
            this._LicenseRequired = (Boolean)object;
            this._postSet(18, bl, this._LicenseRequired);
            return;
        }
        if (string.equals("ManagedConnectionFactoryClass")) {
            String string13 = this._ManagedConnectionFactoryClass;
            this._ManagedConnectionFactoryClass = (String)object;
            this._postSet(27, string13, this._ManagedConnectionFactoryClass);
            return;
        }
        if (string.equals("MaxCapacity")) {
            int n = this._MaxCapacity;
            this._MaxCapacity = (Integer)object;
            this._postSet(36, n, this._MaxCapacity);
            return;
        }
        if (string.equals("Name")) {
            String string14 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string14, this._Name);
            return;
        }
        if (string.equals("SecurityPermissions")) {
            HashSet hashSet = this._SecurityPermissions;
            this._SecurityPermissions = (HashSet)object;
            this._postSet(32, hashSet, this._SecurityPermissions);
            return;
        }
        if (string.equals("SmallIcon")) {
            String string15 = this._SmallIcon;
            this._SmallIcon = (String)object;
            this._postSet(15, string15, this._SmallIcon);
            return;
        }
        if (string.equals("SpecVersion")) {
            String string16 = this._SpecVersion;
            this._SpecVersion = (String)object;
            this._postSet(19, string16, this._SpecVersion);
            return;
        }
        if (string.equals("Targets")) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._Targets = (TargetMBean[])object;
            this._postSet(7, targetMBeanArray, this._Targets);
            return;
        }
        if (string.equals("TransactionSupport")) {
            String string17 = this._TransactionSupport;
            this._TransactionSupport = (String)object;
            this._postSet(29, string17, this._TransactionSupport);
            return;
        }
        if (string.equals("VendorName")) {
            String string18 = this._VendorName;
            this._VendorName = (String)object;
            this._postSet(20, string18, this._VendorName);
            return;
        }
        if (string.equals("Version")) {
            String string19 = this._Version;
            this._Version = (String)object;
            this._postSet(21, string19, this._Version);
            return;
        }
        if (string.equals("customizer")) {
            ConnectorComponent connectorComponent = this._customizer;
            this._customizer = (ConnectorComponent)object;
            return;
        }
        if (string.equals("reauthenticationSupport")) {
            boolean bl = this._reauthenticationSupport;
            this._reauthenticationSupport = (Boolean)object;
            this._postSet(28, bl, this._reauthenticationSupport);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("ActivatedTargets")) {
            return this._ActivatedTargets;
        }
        if (string.equals("Application")) {
            return this._Application;
        }
        if (string.equals("AuthenticationMechanisms")) {
            return this._AuthenticationMechanisms;
        }
        if (string.equals("ClassLoader")) {
            return this._ClassLoader;
        }
        if (string.equals("ConfigProperties")) {
            return this._ConfigProperties;
        }
        if (string.equals("ConnectionFactoryDescription")) {
            return this._ConnectionFactoryDescription;
        }
        if (string.equals("ConnectionFactoryImpl")) {
            return this._ConnectionFactoryImpl;
        }
        if (string.equals("ConnectionFactoryInterface")) {
            return this._ConnectionFactoryInterface;
        }
        if (string.equals("ConnectionFactoryName")) {
            return this._ConnectionFactoryName;
        }
        if (string.equals("ConnectionImpl")) {
            return this._ConnectionImpl;
        }
        if (string.equals("ConnectionInterface")) {
            return this._ConnectionInterface;
        }
        if (string.equals("ConnectionProfilingEnabled")) {
            return new Boolean(this._ConnectionProfilingEnabled);
        }
        if (string.equals("Description")) {
            return this._Description;
        }
        if (string.equals("DisplayName")) {
            return this._DisplayName;
        }
        if (string.equals("EisType")) {
            return this._EisType;
        }
        if (string.equals("LargeIcon")) {
            return this._LargeIcon;
        }
        if (string.equals("LicenseDescription")) {
            return this._LicenseDescription;
        }
        if (string.equals("LicenseRequired")) {
            return new Boolean(this._LicenseRequired);
        }
        if (string.equals("ManagedConnectionFactoryClass")) {
            return this._ManagedConnectionFactoryClass;
        }
        if (string.equals("MaxCapacity")) {
            return new Integer(this._MaxCapacity);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("SecurityPermissions")) {
            return this._SecurityPermissions;
        }
        if (string.equals("SmallIcon")) {
            return this._SmallIcon;
        }
        if (string.equals("SpecVersion")) {
            return this._SpecVersion;
        }
        if (string.equals("Targets")) {
            return this._Targets;
        }
        if (string.equals("TransactionSupport")) {
            return this._TransactionSupport;
        }
        if (string.equals("VendorName")) {
            return this._VendorName;
        }
        if (string.equals("Version")) {
            return this._Version;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        if (string.equals("reauthenticationSupport")) {
            return new Boolean(this._reauthenticationSupport);
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ComponentMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 16: {
                    if (string.equals("activated-target")) {
                        return 11;
                    }
                    if (!string.equals("license-required")) break;
                    return 18;
                }
                case 11: {
                    if (string.equals("application")) {
                        return 9;
                    }
                    if (string.equals("description")) {
                        return 12;
                    }
                    if (!string.equals("vendor-name")) break;
                    return 20;
                }
                case 25: {
                    if (!string.equals("authentication-mechanisms")) break;
                    return 31;
                }
                case 12: {
                    if (string.equals("class-loader")) {
                        return 33;
                    }
                    if (string.equals("display-name")) {
                        return 13;
                    }
                    if (string.equals("max-capacity")) {
                        return 36;
                    }
                    if (!string.equals("spec-version")) break;
                    return 19;
                }
                case 17: {
                    if (!string.equals("config-properties")) break;
                    return 30;
                }
                case 30: {
                    if (!string.equals("connection-factory-description")) break;
                    return 35;
                }
                case 23: {
                    if (string.equals("connection-factory-impl")) {
                        return 22;
                    }
                    if (!string.equals("connection-factory-name")) break;
                    return 34;
                }
                case 28: {
                    if (string.equals("connection-factory-interface")) {
                        return 23;
                    }
                    if (!string.equals("connection-profiling-enabled")) break;
                    return 26;
                }
                case 15: {
                    if (!string.equals("connection-impl")) break;
                    return 24;
                }
                case 20: {
                    if (string.equals("connection-interface")) {
                        return 25;
                    }
                    if (!string.equals("security-permissions")) break;
                    return 32;
                }
                case 8: {
                    if (!string.equals("eis-type")) break;
                    return 14;
                }
                case 10: {
                    if (string.equals("large-icon")) {
                        return 16;
                    }
                    if (!string.equals("small-icon")) break;
                    return 15;
                }
                case 19: {
                    if (string.equals("license-description")) {
                        return 17;
                    }
                    if (!string.equals("transaction-support")) break;
                    return 29;
                }
                case 32: {
                    if (!string.equals("managed-connection-factory-class")) break;
                    return 27;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 6: {
                    if (!string.equals("target")) break;
                    return 7;
                }
                case 7: {
                    if (!string.equals("version")) break;
                    return 21;
                }
                case 24: {
                    if (!string.equals("reauthentication-support")) break;
                    return 28;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 11: {
                    return "activated-target";
                }
                case 9: {
                    return "application";
                }
                case 31: {
                    return "authentication-mechanisms";
                }
                case 33: {
                    return "class-loader";
                }
                case 30: {
                    return "config-properties";
                }
                case 35: {
                    return "connection-factory-description";
                }
                case 22: {
                    return "connection-factory-impl";
                }
                case 23: {
                    return "connection-factory-interface";
                }
                case 34: {
                    return "connection-factory-name";
                }
                case 24: {
                    return "connection-impl";
                }
                case 25: {
                    return "connection-interface";
                }
                case 26: {
                    return "connection-profiling-enabled";
                }
                case 12: {
                    return "description";
                }
                case 13: {
                    return "display-name";
                }
                case 14: {
                    return "eis-type";
                }
                case 16: {
                    return "large-icon";
                }
                case 17: {
                    return "license-description";
                }
                case 18: {
                    return "license-required";
                }
                case 27: {
                    return "managed-connection-factory-class";
                }
                case 36: {
                    return "max-capacity";
                }
                case 2: {
                    return "name";
                }
                case 32: {
                    return "security-permissions";
                }
                case 15: {
                    return "small-icon";
                }
                case 19: {
                    return "spec-version";
                }
                case 7: {
                    return "target";
                }
                case 29: {
                    return "transaction-support";
                }
                case 20: {
                    return "vendor-name";
                }
                case 21: {
                    return "version";
                }
                case 28: {
                    return "reauthentication-support";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 11: {
                    return true;
                }
                case 7: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isConfigurable(int n) {
            switch (n) {
                case 26: {
                    return true;
                }
            }
            return super.isConfigurable(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ComponentMBeanImpl.Helper {
        private ConnectorComponentMBeanImpl bean;

        protected Helper(ConnectorComponentMBeanImpl connectorComponentMBeanImpl) {
            super(connectorComponentMBeanImpl);
            this.bean = connectorComponentMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 11: {
                    return "ActivatedTargets";
                }
                case 9: {
                    return "Application";
                }
                case 31: {
                    return "AuthenticationMechanisms";
                }
                case 33: {
                    return "ClassLoader";
                }
                case 30: {
                    return "ConfigProperties";
                }
                case 35: {
                    return "ConnectionFactoryDescription";
                }
                case 22: {
                    return "ConnectionFactoryImpl";
                }
                case 23: {
                    return "ConnectionFactoryInterface";
                }
                case 34: {
                    return "ConnectionFactoryName";
                }
                case 24: {
                    return "ConnectionImpl";
                }
                case 25: {
                    return "ConnectionInterface";
                }
                case 26: {
                    return "ConnectionProfilingEnabled";
                }
                case 12: {
                    return "Description";
                }
                case 13: {
                    return "DisplayName";
                }
                case 14: {
                    return "EisType";
                }
                case 16: {
                    return "LargeIcon";
                }
                case 17: {
                    return "LicenseDescription";
                }
                case 18: {
                    return "LicenseRequired";
                }
                case 27: {
                    return "ManagedConnectionFactoryClass";
                }
                case 36: {
                    return "MaxCapacity";
                }
                case 2: {
                    return "Name";
                }
                case 32: {
                    return "SecurityPermissions";
                }
                case 15: {
                    return "SmallIcon";
                }
                case 19: {
                    return "SpecVersion";
                }
                case 7: {
                    return "Targets";
                }
                case 29: {
                    return "TransactionSupport";
                }
                case 20: {
                    return "VendorName";
                }
                case 21: {
                    return "Version";
                }
                case 28: {
                    return "reauthenticationSupport";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("ActivatedTargets")) {
                return 11;
            }
            if (string.equals("Application")) {
                return 9;
            }
            if (string.equals("AuthenticationMechanisms")) {
                return 31;
            }
            if (string.equals("ClassLoader")) {
                return 33;
            }
            if (string.equals("ConfigProperties")) {
                return 30;
            }
            if (string.equals("ConnectionFactoryDescription")) {
                return 35;
            }
            if (string.equals("ConnectionFactoryImpl")) {
                return 22;
            }
            if (string.equals("ConnectionFactoryInterface")) {
                return 23;
            }
            if (string.equals("ConnectionFactoryName")) {
                return 34;
            }
            if (string.equals("ConnectionImpl")) {
                return 24;
            }
            if (string.equals("ConnectionInterface")) {
                return 25;
            }
            if (string.equals("ConnectionProfilingEnabled")) {
                return 26;
            }
            if (string.equals("Description")) {
                return 12;
            }
            if (string.equals("DisplayName")) {
                return 13;
            }
            if (string.equals("EisType")) {
                return 14;
            }
            if (string.equals("LargeIcon")) {
                return 16;
            }
            if (string.equals("LicenseDescription")) {
                return 17;
            }
            if (string.equals("LicenseRequired")) {
                return 18;
            }
            if (string.equals("ManagedConnectionFactoryClass")) {
                return 27;
            }
            if (string.equals("MaxCapacity")) {
                return 36;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("SecurityPermissions")) {
                return 32;
            }
            if (string.equals("SmallIcon")) {
                return 15;
            }
            if (string.equals("SpecVersion")) {
                return 19;
            }
            if (string.equals("Targets")) {
                return 7;
            }
            if (string.equals("TransactionSupport")) {
                return 29;
            }
            if (string.equals("VendorName")) {
                return 20;
            }
            if (string.equals("Version")) {
                return 21;
            }
            if (string.equals("reauthenticationSupport")) {
                return 28;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isActivatedTargetsSet()) {
                    stringBuffer.append("ActivatedTargets");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getActivatedTargets())));
                }
                if (this.bean.isApplicationSet()) {
                    stringBuffer.append("Application");
                    stringBuffer.append(String.valueOf(this.bean.getApplication()));
                }
                if (this.bean.isAuthenticationMechanismsSet()) {
                    stringBuffer.append("AuthenticationMechanisms");
                    stringBuffer.append(String.valueOf(this.bean.getAuthenticationMechanisms()));
                }
                if (this.bean.isClassLoaderSet()) {
                    stringBuffer.append("ClassLoader");
                    stringBuffer.append(String.valueOf(this.bean.getClassLoader()));
                }
                if (this.bean.isConfigPropertiesSet()) {
                    stringBuffer.append("ConfigProperties");
                    stringBuffer.append(String.valueOf(this.bean.getConfigProperties()));
                }
                if (this.bean.isConnectionFactoryDescriptionSet()) {
                    stringBuffer.append("ConnectionFactoryDescription");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionFactoryDescription()));
                }
                if (this.bean.isConnectionFactoryImplSet()) {
                    stringBuffer.append("ConnectionFactoryImpl");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionFactoryImpl()));
                }
                if (this.bean.isConnectionFactoryInterfaceSet()) {
                    stringBuffer.append("ConnectionFactoryInterface");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionFactoryInterface()));
                }
                if (this.bean.isConnectionFactoryNameSet()) {
                    stringBuffer.append("ConnectionFactoryName");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionFactoryName()));
                }
                if (this.bean.isConnectionImplSet()) {
                    stringBuffer.append("ConnectionImpl");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionImpl()));
                }
                if (this.bean.isConnectionInterfaceSet()) {
                    stringBuffer.append("ConnectionInterface");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionInterface()));
                }
                if (this.bean.isConnectionProfilingEnabledSet()) {
                    stringBuffer.append("ConnectionProfilingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionProfilingEnabled()));
                }
                if (this.bean.isDescriptionSet()) {
                    stringBuffer.append("Description");
                    stringBuffer.append(String.valueOf(this.bean.getDescription()));
                }
                if (this.bean.isDisplayNameSet()) {
                    stringBuffer.append("DisplayName");
                    stringBuffer.append(String.valueOf(this.bean.getDisplayName()));
                }
                if (this.bean.isEisTypeSet()) {
                    stringBuffer.append("EisType");
                    stringBuffer.append(String.valueOf(this.bean.getEisType()));
                }
                if (this.bean.isLargeIconSet()) {
                    stringBuffer.append("LargeIcon");
                    stringBuffer.append(String.valueOf(this.bean.getLargeIcon()));
                }
                if (this.bean.isLicenseDescriptionSet()) {
                    stringBuffer.append("LicenseDescription");
                    stringBuffer.append(String.valueOf(this.bean.getLicenseDescription()));
                }
                if (this.bean.isLicenseRequiredSet()) {
                    stringBuffer.append("LicenseRequired");
                    stringBuffer.append(String.valueOf(this.bean.getLicenseRequired()));
                }
                if (this.bean.isManagedConnectionFactoryClassSet()) {
                    stringBuffer.append("ManagedConnectionFactoryClass");
                    stringBuffer.append(String.valueOf(this.bean.getManagedConnectionFactoryClass()));
                }
                if (this.bean.isMaxCapacitySet()) {
                    stringBuffer.append("MaxCapacity");
                    stringBuffer.append(String.valueOf(this.bean.getMaxCapacity()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isSecurityPermissionsSet()) {
                    stringBuffer.append("SecurityPermissions");
                    stringBuffer.append(String.valueOf(this.bean.getSecurityPermissions()));
                }
                if (this.bean.isSmallIconSet()) {
                    stringBuffer.append("SmallIcon");
                    stringBuffer.append(String.valueOf(this.bean.getSmallIcon()));
                }
                if (this.bean.isSpecVersionSet()) {
                    stringBuffer.append("SpecVersion");
                    stringBuffer.append(String.valueOf(this.bean.getSpecVersion()));
                }
                if (this.bean.isTargetsSet()) {
                    stringBuffer.append("Targets");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getTargets())));
                }
                if (this.bean.isTransactionSupportSet()) {
                    stringBuffer.append("TransactionSupport");
                    stringBuffer.append(String.valueOf(this.bean.getTransactionSupport()));
                }
                if (this.bean.isVendorNameSet()) {
                    stringBuffer.append("VendorName");
                    stringBuffer.append(String.valueOf(this.bean.getVendorName()));
                }
                if (this.bean.isVersionSet()) {
                    stringBuffer.append("Version");
                    stringBuffer.append(String.valueOf(this.bean.getVersion()));
                }
                if (this.bean.isreauthenticationSupportSet()) {
                    stringBuffer.append("reauthenticationSupport");
                    stringBuffer.append(String.valueOf(this.bean.getreauthenticationSupport()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                ConnectorComponentMBeanImpl connectorComponentMBeanImpl = (ConnectorComponentMBeanImpl)abstractDescriptorBean;
                this.computeDiff("AuthenticationMechanisms", this.bean.getAuthenticationMechanisms(), connectorComponentMBeanImpl.getAuthenticationMechanisms(), false);
                this.computeDiff("ConnectionProfilingEnabled", this.bean.getConnectionProfilingEnabled(), connectorComponentMBeanImpl.getConnectionProfilingEnabled(), false);
                this.computeDiff("Name", this.bean.getName(), connectorComponentMBeanImpl.getName(), false);
                this.computeDiff("Targets", this.bean.getTargets(), connectorComponentMBeanImpl.getTargets(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                ConnectorComponentMBeanImpl connectorComponentMBeanImpl = (ConnectorComponentMBeanImpl)beanUpdateEvent.getSourceBean();
                ConnectorComponentMBeanImpl connectorComponentMBeanImpl2 = (ConnectorComponentMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (!string.equals("ActivatedTargets") && !string.equals("Application")) {
                    if (string.equals("AuthenticationMechanisms")) {
                        connectorComponentMBeanImpl.setAuthenticationMechanisms(connectorComponentMBeanImpl2.getAuthenticationMechanisms() == null ? null : (HashSet)connectorComponentMBeanImpl2.getAuthenticationMechanisms().clone());
                        connectorComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 31);
                    } else if (!(string.equals("ClassLoader") || string.equals("ConfigProperties") || string.equals("ConnectionFactoryDescription") || string.equals("ConnectionFactoryImpl") || string.equals("ConnectionFactoryInterface") || string.equals("ConnectionFactoryName") || string.equals("ConnectionImpl") || string.equals("ConnectionInterface"))) {
                        if (string.equals("ConnectionProfilingEnabled")) {
                            connectorComponentMBeanImpl.setConnectionProfilingEnabled(connectorComponentMBeanImpl2.getConnectionProfilingEnabled());
                            connectorComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 26);
                        } else if (!(string.equals("Description") || string.equals("DisplayName") || string.equals("EisType") || string.equals("LargeIcon") || string.equals("LicenseDescription") || string.equals("LicenseRequired") || string.equals("ManagedConnectionFactoryClass") || string.equals("MaxCapacity"))) {
                            if (string.equals("Name")) {
                                connectorComponentMBeanImpl.setName(connectorComponentMBeanImpl2.getName());
                                connectorComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                            } else if (!(string.equals("SecurityPermissions") || string.equals("SmallIcon") || string.equals("SpecVersion"))) {
                                if (string.equals("Targets")) {
                                    connectorComponentMBeanImpl.setTargetsAsString(connectorComponentMBeanImpl2.getTargetsAsString());
                                    connectorComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                                } else if (!(string.equals("TransactionSupport") || string.equals("VendorName") || string.equals("Version") || string.equals("reauthenticationSupport"))) {
                                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                                }
                            }
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                ConnectorComponentMBeanImpl connectorComponentMBeanImpl = (ConnectorComponentMBeanImpl)abstractDescriptorBean;
                super.finishCopy(connectorComponentMBeanImpl, bl, list);
                if ((list == null || !list.contains("AuthenticationMechanisms")) && this.bean.isAuthenticationMechanismsSet()) {
                    connectorComponentMBeanImpl.setAuthenticationMechanisms(this.bean.getAuthenticationMechanisms());
                }
                if ((list == null || !list.contains("ConnectionProfilingEnabled")) && this.bean.isConnectionProfilingEnabledSet()) {
                    connectorComponentMBeanImpl.setConnectionProfilingEnabled(this.bean.getConnectionProfilingEnabled());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    connectorComponentMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("Targets")) && this.bean.isTargetsSet()) {
                    connectorComponentMBeanImpl._unSet(connectorComponentMBeanImpl, 7);
                    connectorComponentMBeanImpl.setTargetsAsString(this.bean.getTargetsAsString());
                }
                return connectorComponentMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getActivatedTargets(), clazz, object);
            this.inferSubTree(this.bean.getApplication(), clazz, object);
            this.inferSubTree(this.bean.getTargets(), clazz, object);
        }
    }
}

