/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanAlreadyExistsException;
import weblogic.descriptor.DescriptorBean;
import weblogic.management.DistributedManagementException;
import weblogic.management.configuration.BasicRealmMBeanBinder;
import weblogic.management.configuration.CustomRealmMBeanImpl;
import weblogic.management.internal.mbean.SecurityReadOnlyMBeanBinder;
import weblogic.utils.codegen.AttributeBinder;

public class CustomRealmMBeanBinder
extends BasicRealmMBeanBinder
implements AttributeBinder {
    private CustomRealmMBeanImpl bean;

    protected CustomRealmMBeanBinder(DescriptorBean descriptorBean) {
        super(descriptorBean);
        this.bean = (CustomRealmMBeanImpl)descriptorBean;
    }

    public CustomRealmMBeanBinder() {
        super(new CustomRealmMBeanImpl());
        this.bean = (CustomRealmMBeanImpl)this.getBean();
    }

    public AttributeBinder bindAttribute(String string, Object object) throws IllegalArgumentException {
        try {
            CustomRealmMBeanBinder customRealmMBeanBinder = this;
            if (!(customRealmMBeanBinder instanceof SecurityReadOnlyMBeanBinder) && object != null && object.toString().trim().length() == 0) {
                return customRealmMBeanBinder;
            }
            if (string != null) {
                if (string.equals("ConfigurationData")) {
                    this.bean.setConfigurationDataAsString((String)object);
                } else if (string.equals("Password")) {
                    try {
                        if (this.bean.isPasswordEncryptedSet()) {
                            throw new IllegalArgumentException("Encrypted attribute corresponding to Password [ CustomRealmMBean ] is also present in the config file. For encrypted properties either encrypted or unencrypted attribute can be present in 8.x config.");
                        }
                        this.bean.setPassword((String)object);
                    }
                    catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                        System.out.println("Warning: multiple definitions with same name: " + beanAlreadyExistsException.getMessage());
                    }
                } else if (string.equals("PasswordEncrypted")) {
                    if (this.bean.isPasswordEncryptedSet()) {
                        throw new IllegalArgumentException("Unencrypted attribute corresponding to PasswordEncrypted [ CustomRealmMBean ] is also present in the config file. For encrypted properties either encrypted or unencrypted attribute can be present in 8.x config.");
                    }
                    this.bean.setPasswordEncryptedAsString((String)object);
                } else if (string.equals("RealmClassName")) {
                    try {
                        this.bean.setRealmClassName((String)object);
                    }
                    catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                        System.out.println("Warning: multiple definitions with same name: " + beanAlreadyExistsException.getMessage());
                    }
                } else {
                    customRealmMBeanBinder = super.bindAttribute(string, object);
                }
            }
            return customRealmMBeanBinder;
        }
        catch (ClassCastException classCastException) {
            System.out.println(classCastException + " name: " + string + " class: " + object.getClass().getName());
            throw classCastException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            if (exception instanceof DistributedManagementException) {
                throw new AssertionError((Object)("impossible exception: " + exception));
            }
            if (exception instanceof InvalidAttributeValueException) {
                throw new IllegalArgumentException(exception.getMessage());
            }
            throw new AssertionError((Object)("unexpected exception: " + exception));
        }
    }
}

