/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.StringHelper;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.configuration.BasicRealmMBeanImpl;
import weblogic.management.configuration.CustomRealmMBean;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class CustomRealmMBeanImpl
extends BasicRealmMBeanImpl
implements CustomRealmMBean,
Serializable {
    private Properties _ConfigurationData;
    private String _Password;
    private byte[] _PasswordEncrypted;
    private String _RealmClassName;
    private static SchemaHelper2 _schemaHelper;

    public CustomRealmMBeanImpl() {
        this._initializeProperty(-1);
    }

    public CustomRealmMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public String getRealmClassName() {
        return this._RealmClassName;
    }

    public boolean isRealmClassNameSet() {
        return this._isSet(7);
    }

    public void setRealmClassName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._RealmClassName;
        this._RealmClassName = string;
        this._postSet(7, string2, string);
    }

    public Properties getConfigurationData() {
        return this._ConfigurationData;
    }

    public String getConfigurationDataAsString() {
        return StringHelper.objectToString((Object)this.getConfigurationData());
    }

    public boolean isConfigurationDataSet() {
        return this._isSet(8);
    }

    public void setConfigurationDataAsString(String string) {
        try {
            this.setConfigurationData(StringHelper.stringToProperties((String)string));
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public void setConfigurationData(Properties properties) throws InvalidAttributeValueException {
        Properties properties2 = this._ConfigurationData;
        this._ConfigurationData = properties;
        this._postSet(8, properties2, properties);
    }

    public String getPassword() {
        byte[] byArray = this.getPasswordEncrypted();
        return byArray == null ? null : this._decrypt("Password", byArray);
    }

    public boolean isPasswordSet() {
        return this.isPasswordEncryptedSet();
    }

    public void setPassword(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setPasswordEncrypted(string == null ? null : this._encrypt("Password", string));
    }

    public byte[] getPasswordEncrypted() {
        return this._getHelper()._cloneArray(this._PasswordEncrypted);
    }

    public String getPasswordEncryptedAsString() {
        byte[] byArray = this.getPasswordEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isPasswordEncryptedSet() {
        return this._isSet(10);
    }

    public void setPasswordEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setPasswordEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public void setPasswordEncrypted(byte[] byArray) {
        byte[] byArray2 = this._PasswordEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: PasswordEncrypted of CustomRealmMBean");
        }
        this._getHelper()._clearArray(this._PasswordEncrypted);
        this._PasswordEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(10, byArray2, byArray);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
            if (n == 9) {
                this._markSet(10, false);
            }
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 8;
        }
        try {
            switch (n) {
                case 8: {
                    this._ConfigurationData = null;
                    if (bl) break;
                }
                case 9: {
                    this._PasswordEncrypted = null;
                    if (bl) break;
                }
                case 10: {
                    this._PasswordEncrypted = null;
                    if (bl) break;
                }
                case 7: {
                    this._RealmClassName = null;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "CustomRealm";
    }

    public void putValue(String string, Object object) {
        if (string.equals("ConfigurationData")) {
            Properties properties = this._ConfigurationData;
            this._ConfigurationData = (Properties)object;
            this._postSet(8, properties, this._ConfigurationData);
            return;
        }
        if (string.equals("Password")) {
            String string2 = this._Password;
            this._Password = (String)object;
            this._postSet(9, string2, this._Password);
            return;
        }
        if (string.equals("PasswordEncrypted")) {
            byte[] byArray = this._PasswordEncrypted;
            this._PasswordEncrypted = (byte[])object;
            this._postSet(10, byArray, this._PasswordEncrypted);
            return;
        }
        if (string.equals("RealmClassName")) {
            String string3 = this._RealmClassName;
            this._RealmClassName = (String)object;
            this._postSet(7, string3, this._RealmClassName);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("ConfigurationData")) {
            return this._ConfigurationData;
        }
        if (string.equals("Password")) {
            return this._Password;
        }
        if (string.equals("PasswordEncrypted")) {
            return this._PasswordEncrypted;
        }
        if (string.equals("RealmClassName")) {
            return this._RealmClassName;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends BasicRealmMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 18: {
                    if (string.equals("configuration-data")) {
                        return 8;
                    }
                    if (!string.equals("password-encrypted")) break;
                    return 10;
                }
                case 8: {
                    if (!string.equals("password")) break;
                    return 9;
                }
                case 16: {
                    if (!string.equals("realm-class-name")) break;
                    return 7;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 8: {
                    return "configuration-data";
                }
                case 9: {
                    return "password";
                }
                case 10: {
                    return "password-encrypted";
                }
                case 7: {
                    return "realm-class-name";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                default: 
            }
            return super.isArray(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends BasicRealmMBeanImpl.Helper {
        private CustomRealmMBeanImpl bean;

        protected Helper(CustomRealmMBeanImpl customRealmMBeanImpl) {
            super(customRealmMBeanImpl);
            this.bean = customRealmMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 8: {
                    return "ConfigurationData";
                }
                case 9: {
                    return "Password";
                }
                case 10: {
                    return "PasswordEncrypted";
                }
                case 7: {
                    return "RealmClassName";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("ConfigurationData")) {
                return 8;
            }
            if (string.equals("Password")) {
                return 9;
            }
            if (string.equals("PasswordEncrypted")) {
                return 10;
            }
            if (string.equals("RealmClassName")) {
                return 7;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isConfigurationDataSet()) {
                    stringBuffer.append("ConfigurationData");
                    stringBuffer.append(String.valueOf(this.bean.getConfigurationData()));
                }
                if (this.bean.isPasswordSet()) {
                    stringBuffer.append("Password");
                    stringBuffer.append(String.valueOf(this.bean.getPassword()));
                }
                if (this.bean.isPasswordEncryptedSet()) {
                    stringBuffer.append("PasswordEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getPasswordEncrypted())));
                }
                if (this.bean.isRealmClassNameSet()) {
                    stringBuffer.append("RealmClassName");
                    stringBuffer.append(String.valueOf(this.bean.getRealmClassName()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                CustomRealmMBeanImpl customRealmMBeanImpl = (CustomRealmMBeanImpl)abstractDescriptorBean;
                this.computeDiff("ConfigurationData", this.bean.getConfigurationData(), customRealmMBeanImpl.getConfigurationData(), false);
                this.computeDiff("PasswordEncrypted", this.bean.getPasswordEncrypted(), customRealmMBeanImpl.getPasswordEncrypted(), false);
                this.computeDiff("RealmClassName", this.bean.getRealmClassName(), customRealmMBeanImpl.getRealmClassName(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                CustomRealmMBeanImpl customRealmMBeanImpl = (CustomRealmMBeanImpl)beanUpdateEvent.getSourceBean();
                CustomRealmMBeanImpl customRealmMBeanImpl2 = (CustomRealmMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("ConfigurationData")) {
                    customRealmMBeanImpl.setConfigurationData(customRealmMBeanImpl2.getConfigurationData() == null ? null : (Properties)customRealmMBeanImpl2.getConfigurationData().clone());
                    customRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (!string.equals("Password")) {
                    if (string.equals("PasswordEncrypted")) {
                        customRealmMBeanImpl.setPasswordEncrypted(customRealmMBeanImpl2.getPasswordEncrypted());
                        customRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                    } else if (string.equals("RealmClassName")) {
                        customRealmMBeanImpl.setRealmClassName(customRealmMBeanImpl2.getRealmClassName());
                        customRealmMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                    } else {
                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                CustomRealmMBeanImpl customRealmMBeanImpl = (CustomRealmMBeanImpl)abstractDescriptorBean;
                super.finishCopy(customRealmMBeanImpl, bl, list);
                if ((list == null || !list.contains("ConfigurationData")) && this.bean.isConfigurationDataSet()) {
                    customRealmMBeanImpl.setConfigurationData(this.bean.getConfigurationData());
                }
                if ((list == null || !list.contains("PasswordEncrypted")) && this.bean.isPasswordEncryptedSet()) {
                    byte[] byArray = this.bean.getPasswordEncrypted();
                    customRealmMBeanImpl.setPasswordEncrypted(byArray == null ? null : (byte[])byArray.clone());
                }
                if ((list == null || !list.contains("RealmClassName")) && this.bean.isRealmClassNameSet()) {
                    customRealmMBeanImpl.setRealmClassName(this.bean.getRealmClassName());
                }
                return customRealmMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

