/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BootstrapProperties;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.DomainLogFilterMBean;
import weblogic.management.configuration.LogFilterMBean;
import weblogic.management.mbeans.custom.DomainLogFilter;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class DomainLogFilterMBeanImpl
extends ConfigurationMBeanImpl
implements DomainLogFilterMBean,
Serializable {
    private LogFilterMBean _Delegate;
    private String _Name;
    private int _SeverityLevel;
    private String[] _SubsystemNames;
    private String[] _UserIds;
    private DomainLogFilter _customizer;
    private static SchemaHelper2 _schemaHelper;

    public DomainLogFilterMBeanImpl() {
        try {
            this._customizer = new DomainLogFilter(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public DomainLogFilterMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new DomainLogFilter(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public int getSeverityLevel() {
        return this._customizer.getSeverityLevel();
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isSeverityLevelSet() {
        return this._isSet(7);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setSeverityLevel(int n) throws InvalidAttributeValueException, DistributedManagementException {
        int[] nArray = new int[]{64, 16, 8, 32, 4, 2, 1};
        n = LegalChecks.checkInEnum((String)"SeverityLevel", (int)n, (int[])nArray);
        int n2 = this.getSeverityLevel();
        this._customizer.setSeverityLevel(n);
        this._postSet(7, n2, n);
    }

    public String[] getSubsystemNames() {
        return this._customizer.getSubsystemNames();
    }

    public boolean isSubsystemNamesSet() {
        return this._isSet(8);
    }

    public void setSubsystemNames(String[] stringArray) throws InvalidAttributeValueException, DistributedManagementException {
        stringArray = stringArray == null ? new String[]{} : stringArray;
        stringArray = this._getHelper()._trimElements(stringArray);
        String[] stringArray2 = this.getSubsystemNames();
        this._customizer.setSubsystemNames(stringArray);
        this._postSet(8, stringArray2, stringArray);
    }

    public String[] getUserIds() {
        return this._customizer.getUserIds();
    }

    public boolean isUserIdsSet() {
        return this._isSet(9);
    }

    public void setUserIds(String[] stringArray) throws InvalidAttributeValueException, DistributedManagementException {
        stringArray = stringArray == null ? new String[]{} : stringArray;
        stringArray = this._getHelper()._trimElements(stringArray);
        String[] stringArray2 = this.getUserIds();
        this._customizer.setUserIds(stringArray);
        this._postSet(9, stringArray2, stringArray);
    }

    public LogFilterMBean getDelegate() {
        return this._customizer.getDelegate();
    }

    public boolean isDelegateSet() {
        return this._isSet(10);
    }

    public void setDelegate(LogFilterMBean logFilterMBean) {
        this._customizer.setDelegate(logFilterMBean);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 10;
        }
        try {
            switch (n) {
                case 10: {
                    this._customizer.setDelegate(null);
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 7: {
                    this._customizer.setSeverityLevel(16);
                    if (bl) break;
                }
                case 8: {
                    this._customizer.setSubsystemNames(new String[0]);
                    if (bl) break;
                }
                case 9: {
                    this._customizer.setUserIds(new String[0]);
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "DomainLogFilter";
    }

    public void putValue(String string, Object object) {
        if (string.equals("Delegate")) {
            LogFilterMBean logFilterMBean = this._Delegate;
            this._Delegate = (LogFilterMBean)object;
            this._postSet(10, logFilterMBean, this._Delegate);
            return;
        }
        if (string.equals("Name")) {
            String string2 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string2, this._Name);
            return;
        }
        if (string.equals("SeverityLevel")) {
            int n = this._SeverityLevel;
            this._SeverityLevel = (Integer)object;
            this._postSet(7, n, this._SeverityLevel);
            return;
        }
        if (string.equals("SubsystemNames")) {
            String[] stringArray = this._SubsystemNames;
            this._SubsystemNames = (String[])object;
            this._postSet(8, stringArray, this._SubsystemNames);
            return;
        }
        if (string.equals("UserIds")) {
            String[] stringArray = this._UserIds;
            this._UserIds = (String[])object;
            this._postSet(9, stringArray, this._UserIds);
            return;
        }
        if (string.equals("customizer")) {
            DomainLogFilter domainLogFilter = this._customizer;
            this._customizer = (DomainLogFilter)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("Delegate")) {
            return this._Delegate;
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("SeverityLevel")) {
            return new Integer(this._SeverityLevel);
        }
        if (string.equals("SubsystemNames")) {
            return this._SubsystemNames;
        }
        if (string.equals("UserIds")) {
            return this._UserIds;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 8: {
                    if (!string.equals("delegate")) break;
                    return 10;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 14: {
                    if (string.equals("severity-level")) {
                        return 7;
                    }
                    if (!string.equals("subsystem-name")) break;
                    return 8;
                }
                case 7: {
                    if (!string.equals("user-id")) break;
                    return 9;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 10: {
                    return "delegate";
                }
                case 2: {
                    return "name";
                }
                case 7: {
                    return "severity-level";
                }
                case 8: {
                    return "subsystem-name";
                }
                case 9: {
                    return "user-id";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 8: {
                    return true;
                }
                case 9: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private DomainLogFilterMBeanImpl bean;

        protected Helper(DomainLogFilterMBeanImpl domainLogFilterMBeanImpl) {
            super(domainLogFilterMBeanImpl);
            this.bean = domainLogFilterMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 10: {
                    return "Delegate";
                }
                case 2: {
                    return "Name";
                }
                case 7: {
                    return "SeverityLevel";
                }
                case 8: {
                    return "SubsystemNames";
                }
                case 9: {
                    return "UserIds";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("Delegate")) {
                return 10;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("SeverityLevel")) {
                return 7;
            }
            if (string.equals("SubsystemNames")) {
                return 8;
            }
            if (string.equals("UserIds")) {
                return 9;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isDelegateSet()) {
                    stringBuffer.append("Delegate");
                    stringBuffer.append(String.valueOf(this.bean.getDelegate()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isSeverityLevelSet()) {
                    stringBuffer.append("SeverityLevel");
                    stringBuffer.append(String.valueOf(this.bean.getSeverityLevel()));
                }
                if (this.bean.isSubsystemNamesSet()) {
                    stringBuffer.append("SubsystemNames");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getSubsystemNames())));
                }
                if (this.bean.isUserIdsSet()) {
                    stringBuffer.append("UserIds");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getUserIds())));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                DomainLogFilterMBeanImpl domainLogFilterMBeanImpl = (DomainLogFilterMBeanImpl)abstractDescriptorBean;
                this.computeDiff("Name", this.bean.getName(), domainLogFilterMBeanImpl.getName(), false);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("SeverityLevel", this.bean.getSeverityLevel(), domainLogFilterMBeanImpl.getSeverityLevel(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("SubsystemNames", this.bean.getSubsystemNames(), domainLogFilterMBeanImpl.getSubsystemNames(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("UserIds", this.bean.getUserIds(), domainLogFilterMBeanImpl.getUserIds(), true);
                }
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                DomainLogFilterMBeanImpl domainLogFilterMBeanImpl = (DomainLogFilterMBeanImpl)beanUpdateEvent.getSourceBean();
                DomainLogFilterMBeanImpl domainLogFilterMBeanImpl2 = (DomainLogFilterMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (!string.equals("Delegate")) {
                    if (string.equals("Name")) {
                        domainLogFilterMBeanImpl.setName(domainLogFilterMBeanImpl2.getName());
                        domainLogFilterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                    } else if (string.equals("SeverityLevel")) {
                        domainLogFilterMBeanImpl.setSeverityLevel(domainLogFilterMBeanImpl2.getSeverityLevel());
                        domainLogFilterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                    } else if (string.equals("SubsystemNames")) {
                        domainLogFilterMBeanImpl.setSubsystemNames(domainLogFilterMBeanImpl2.getSubsystemNames());
                        domainLogFilterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                    } else if (string.equals("UserIds")) {
                        domainLogFilterMBeanImpl.setUserIds(domainLogFilterMBeanImpl2.getUserIds());
                        domainLogFilterMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                    } else {
                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                String[] stringArray;
                DomainLogFilterMBeanImpl domainLogFilterMBeanImpl = (DomainLogFilterMBeanImpl)abstractDescriptorBean;
                super.finishCopy(domainLogFilterMBeanImpl, bl, list);
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    domainLogFilterMBeanImpl.setName(this.bean.getName());
                }
                if (bl && (list == null || !list.contains("SeverityLevel")) && this.bean.isSeverityLevelSet()) {
                    domainLogFilterMBeanImpl.setSeverityLevel(this.bean.getSeverityLevel());
                }
                if (bl && (list == null || !list.contains("SubsystemNames")) && this.bean.isSubsystemNamesSet()) {
                    stringArray = this.bean.getSubsystemNames();
                    domainLogFilterMBeanImpl.setSubsystemNames(stringArray == null ? null : (String[])stringArray.clone());
                }
                if (bl && (list == null || !list.contains("UserIds")) && this.bean.isUserIdsSet()) {
                    stringArray = this.bean.getUserIds();
                    domainLogFilterMBeanImpl.setUserIds(stringArray == null ? null : (String[])stringArray.clone());
                }
                return domainLogFilterMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getDelegate(), clazz, object);
        }
    }
}

