/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.security.AccessController;
import java.util.Arrays;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.DomainTargetedMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetInfoMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.internal.ManagementTextTextFormatter;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class DomainTargetHelper {
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static TargetMBean[] getDefaultTargets(TargetInfoMBean targetInfoMBean, Object object) {
        ServerMBean serverMBean;
        if (targetInfoMBean instanceof DomainTargetedMBean && (serverMBean = DomainTargetHelper.getLocalServer(targetInfoMBean)) != null) {
            return new TargetMBean[]{serverMBean};
        }
        return (TargetMBean[])object;
    }

    private static ServerMBean getLocalServer(TargetInfoMBean targetInfoMBean) {
        DomainMBean domainMBean = DomainTargetHelper.getDomain(targetInfoMBean);
        if (domainMBean == null) {
            return null;
        }
        String string = ManagementService.getRuntimeAccess(kernelId).getServer().getName();
        return domainMBean.lookupServer(string);
    }

    private static DomainMBean getDomain(TargetInfoMBean targetInfoMBean) {
        TargetInfoMBean targetInfoMBean2;
        for (targetInfoMBean2 = targetInfoMBean; targetInfoMBean2 != null && !(targetInfoMBean2 instanceof DomainMBean); targetInfoMBean2 = targetInfoMBean2.getParent()) {
        }
        return (DomainMBean)((Object)targetInfoMBean2);
    }

    public static void validateTargets(TargetInfoMBean targetInfoMBean) throws IllegalArgumentException {
        if (targetInfoMBean instanceof DomainTargetedMBean) {
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getCannotModifyDomainTarget(targetInfoMBean.getName()));
        }
    }

    public static void validateTargets(TargetInfoMBean targetInfoMBean, TargetMBean[] targetMBeanArray) throws IllegalArgumentException {
        if (targetInfoMBean instanceof DomainTargetedMBean) {
            int n;
            Object[] objectArray = targetInfoMBean.getTargets();
            int n2 = objectArray == null ? 0 : objectArray.length;
            int n3 = n = targetMBeanArray == null ? 0 : targetMBeanArray.length;
            if (n2 != n || !Arrays.equals(objectArray, targetMBeanArray)) {
                throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getCannotModifyDomainTarget(targetInfoMBean.getName()));
            }
        }
    }
}

