/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.util.Arrays;
import weblogic.common.internal.VersionInfo;
import weblogic.common.internal.VersioningError;
import weblogic.jms.module.validators.JMSModuleValidator;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSLegalHelper;
import weblogic.management.configuration.SNMPValidator;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.management.configuration.WLDFValidator;

public class DomainValidator {
    public static void validateDomain(DomainMBean domainMBean) throws IllegalArgumentException {
        WLDFValidator.validateWLDFSystemResources(domainMBean);
        WLDFValidator.validateWLDFServerDiagnosticConfiguration(domainMBean);
        JMSModuleValidator.validateJMSDomain(domainMBean);
        JMSLegalHelper.validateStoreTargets(domainMBean);
        JMSLegalHelper.validateStoreParams(domainMBean);
        SNMPValidator.validateSNMPAgentDeployments(domainMBean);
        DomainValidator.validateName(domainMBean.getName());
        DomainValidator.validateSystemResources(domainMBean.getSystemResources());
    }

    public static void validateName(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Name may not be null or empty string");
        }
    }

    private static void validateSystemResources(SystemResourceMBean[] systemResourceMBeanArray) throws IllegalArgumentException {
        int n;
        Object[] objectArray = new String[systemResourceMBeanArray.length];
        for (n = 0; n < systemResourceMBeanArray.length; ++n) {
            objectArray[n] = systemResourceMBeanArray[n].getName();
        }
        Arrays.sort(objectArray);
        for (n = 0; n < objectArray.length - 1; ++n) {
            if (!((String)objectArray[n]).equals(objectArray[n + 1])) continue;
            String string = "Multiple system resources with same name: " + (String)objectArray[n];
            throw new IllegalArgumentException(string);
        }
    }

    public static void validateVersionString(String string) throws IllegalArgumentException {
        try {
            new VersionInfo(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid version string: " + string, exception);
        }
        catch (VersioningError versioningError) {
            throw new IllegalArgumentException("Invalid version string: " + string, versioningError);
        }
    }
}

