/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ComponentMBeanImpl;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.EJBComponentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.TargetMBeanImpl;
import weblogic.management.mbeans.custom.EJBComponent;
import weblogic.management.runtime.EJBComponentRuntimeMBean;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class EJBComponentMBeanImpl
extends ComponentMBeanImpl
implements EJBComponentMBean,
Serializable {
    private TargetMBean[] _ActivatedTargets;
    private ApplicationMBean _Application;
    private EJBComponentRuntimeMBean _EJBComponentRuntime;
    private String _ExtraEjbcOptions;
    private String _ExtraRmicOptions;
    private boolean _ForceGeneration;
    private String _JavaCompiler;
    private String _JavaCompilerPostClassPath;
    private String _JavaCompilerPreClassPath;
    private boolean _KeepGenerated;
    private String _Name;
    private TargetMBean[] _Targets;
    private String _TmpPath;
    private String _VerboseEJBDeploymentEnabled;
    private EJBComponent _customizer;
    private static SchemaHelper2 _schemaHelper;

    public EJBComponentMBeanImpl() {
        try {
            this._customizer = new EJBComponent(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public EJBComponentMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new EJBComponent(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public ApplicationMBean getApplication() {
        return this._customizer.getApplication();
    }

    public EJBComponentRuntimeMBean getEJBComponentRuntime() {
        return this._customizer.getEJBComponentRuntime();
    }

    public String getJavaCompiler() {
        return this._JavaCompiler;
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public TargetMBean[] getTargets() {
        return this._customizer.getTargets();
    }

    public String getTargetsAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getTargets());
    }

    public boolean isApplicationSet() {
        return this._isSet(9);
    }

    public boolean isEJBComponentRuntimeSet() {
        return this._isSet(21);
    }

    public boolean isJavaCompilerSet() {
        return this._isSet(12);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isTargetsSet() {
        return this._isSet(7);
    }

    public void setTargetsAsString(String string) {
        if (string == null || string.length() == 0) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._initializeProperty(7);
            this._postSet(7, targetMBeanArray, this._Targets);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._Targets);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, TargetMBean.class, new ReferenceManager.Resolver(this, 7){

                    public void resolveReference(Object object) {
                        try {
                            EJBComponentMBeanImpl.this.addTarget((TargetMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (TargetMBean targetMBean : this._Targets) {
                    if (!string2.equals(targetMBean.getName())) continue;
                    try {
                        this.removeTarget(targetMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void setApplication(ApplicationMBean applicationMBean) throws InvalidAttributeValueException {
        this._customizer.setApplication(applicationMBean);
    }

    public void setEJBComponentRuntime(EJBComponentRuntimeMBean eJBComponentRuntimeMBean) {
        this._customizer.setEJBComponentRuntime(eJBComponentRuntimeMBean);
    }

    public void setJavaCompiler(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._JavaCompiler;
        this._JavaCompiler = string;
        this._postSet(12, string2, string);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setTargets(TargetMBean[] targetMBeanArray) throws InvalidAttributeValueException, DistributedManagementException {
        targetMBeanArray = targetMBeanArray == null ? new TargetMBeanImpl[]{} : targetMBeanArray;
        targetMBeanArray = (TargetMBean[])this._getHelper()._cleanAndValidateArray((Object)targetMBeanArray, TargetMBean.class);
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            if (targetMBeanArray[i] == null) continue;
            ResolvedReference resolvedReference = new ResolvedReference(this, 7, (AbstractDescriptorBean)targetMBeanArray[i]){

                protected Object getPropertyValue() {
                    return EJBComponentMBeanImpl.this.getTargets();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)targetMBeanArray[i], resolvedReference);
        }
        TargetMBean[] targetMBeanArray2 = this.getTargets();
        this._customizer.setTargets(targetMBeanArray);
        this._postSet(7, targetMBeanArray2, targetMBeanArray);
    }

    public boolean addTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        this._getHelper()._ensureNonNull((Object)targetMBean);
        if (!((AbstractDescriptorBean)targetMBean).isChildProperty((DescriptorBean)this, 7)) {
            TargetMBean[] targetMBeanArray = (TargetMBean[])this._getHelper()._extendArray((Object)this.getTargets(), TargetMBean.class, (Object)targetMBean);
            try {
                this.setTargets(targetMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public String getJavaCompilerPreClassPath() {
        return this._JavaCompilerPreClassPath;
    }

    public boolean isJavaCompilerPreClassPathSet() {
        return this._isSet(13);
    }

    public boolean removeTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        TargetMBean[] targetMBeanArray = this.getTargets();
        TargetMBean[] targetMBeanArray2 = (TargetMBean[])this._getHelper()._removeElement((Object)targetMBeanArray, TargetMBean.class, (Object)targetMBean);
        if (targetMBeanArray2.length != targetMBeanArray.length) {
            try {
                this.setTargets(targetMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public void setJavaCompilerPreClassPath(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._JavaCompilerPreClassPath;
        this._JavaCompilerPreClassPath = string;
        this._postSet(13, string2, string);
    }

    public TargetMBean[] getActivatedTargets() {
        return this._customizer.getActivatedTargets();
    }

    public String getJavaCompilerPostClassPath() {
        return this._JavaCompilerPostClassPath;
    }

    public boolean isActivatedTargetsSet() {
        return this._isSet(11);
    }

    public boolean isJavaCompilerPostClassPathSet() {
        return this._isSet(14);
    }

    public void addActivatedTarget(TargetMBean targetMBean) {
        this._getHelper()._ensureNonNull((Object)targetMBean);
        if (!((AbstractDescriptorBean)targetMBean).isChildProperty((DescriptorBean)this, 11)) {
            TargetMBean[] targetMBeanArray = (TargetMBean[])this._getHelper()._extendArray((Object)this.getActivatedTargets(), TargetMBean.class, (Object)targetMBean);
            try {
                this.setActivatedTargets(targetMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void setJavaCompilerPostClassPath(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._JavaCompilerPostClassPath;
        this._JavaCompilerPostClassPath = string;
        this._postSet(14, string2, string);
    }

    public String getExtraRmicOptions() {
        return this._ExtraRmicOptions;
    }

    public boolean isExtraRmicOptionsSet() {
        return this._isSet(15);
    }

    public void removeActivatedTarget(TargetMBean targetMBean) {
        TargetMBean[] targetMBeanArray = this.getActivatedTargets();
        TargetMBean[] targetMBeanArray2 = (TargetMBean[])this._getHelper()._removeElement((Object)targetMBeanArray, TargetMBean.class, (Object)targetMBean);
        if (targetMBeanArray2.length != targetMBeanArray.length) {
            try {
                this.setActivatedTargets(targetMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void setActivatedTargets(TargetMBean[] targetMBeanArray) {
        targetMBeanArray = targetMBeanArray == null ? new TargetMBeanImpl[]{} : targetMBeanArray;
        this._ActivatedTargets = targetMBeanArray;
    }

    public void setExtraRmicOptions(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ExtraRmicOptions;
        this._ExtraRmicOptions = string;
        this._postSet(15, string2, string);
    }

    public boolean activated(TargetMBean targetMBean) {
        return this._customizer.activated(targetMBean);
    }

    public boolean getKeepGenerated() {
        return this._KeepGenerated;
    }

    public boolean isKeepGeneratedSet() {
        return this._isSet(16);
    }

    public void refreshDDsIfNeeded(String[] stringArray) {
        this._customizer.refreshDDsIfNeeded(stringArray);
    }

    public void setKeepGenerated(boolean bl) {
        boolean bl2 = this._KeepGenerated;
        this._KeepGenerated = bl;
        this._postSet(16, bl2, bl);
    }

    public boolean getForceGeneration() {
        return this._ForceGeneration;
    }

    public boolean isForceGenerationSet() {
        return this._isSet(17);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void setForceGeneration(boolean bl) {
        boolean bl2 = this._ForceGeneration;
        this._ForceGeneration = bl;
        this._postSet(17, bl2, bl);
    }

    public String getTmpPath() {
        return this._TmpPath;
    }

    public boolean isTmpPathSet() {
        return this._isSet(18);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setTmpPath(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._TmpPath;
        this._TmpPath = string;
        this._postSet(18, string2, string);
    }

    public String getVerboseEJBDeploymentEnabled() {
        return this._VerboseEJBDeploymentEnabled;
    }

    public boolean isVerboseEJBDeploymentEnabledSet() {
        return this._isSet(19);
    }

    public void setVerboseEJBDeploymentEnabled(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._VerboseEJBDeploymentEnabled;
        this._VerboseEJBDeploymentEnabled = string;
        this._postSet(19, string2, string);
    }

    public String getExtraEjbcOptions() {
        return this._ExtraEjbcOptions;
    }

    public boolean isExtraEjbcOptionsSet() {
        return this._isSet(20);
    }

    public void setExtraEjbcOptions(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ExtraEjbcOptions;
        this._ExtraEjbcOptions = string;
        this._postSet(20, string2, string);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 11;
        }
        try {
            switch (n) {
                case 11: {
                    this._ActivatedTargets = new TargetMBean[0];
                    if (bl) break;
                }
                case 9: {
                    this._customizer.setApplication(null);
                    if (bl) break;
                }
                case 21: {
                    this._customizer.setEJBComponentRuntime(null);
                    if (bl) break;
                }
                case 20: {
                    this._ExtraEjbcOptions = null;
                    if (bl) break;
                }
                case 15: {
                    this._ExtraRmicOptions = null;
                    if (bl) break;
                }
                case 17: {
                    this._ForceGeneration = false;
                    if (bl) break;
                }
                case 12: {
                    this._JavaCompiler = null;
                    if (bl) break;
                }
                case 14: {
                    this._JavaCompilerPostClassPath = null;
                    if (bl) break;
                }
                case 13: {
                    this._JavaCompilerPreClassPath = null;
                    if (bl) break;
                }
                case 16: {
                    this._KeepGenerated = true;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 7: {
                    this._customizer.setTargets(new TargetMBean[0]);
                    if (bl) break;
                }
                case 18: {
                    this._TmpPath = "tmp_ejb";
                    if (bl) break;
                }
                case 19: {
                    this._VerboseEJBDeploymentEnabled = "false";
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "EJBComponent";
    }

    public void putValue(String string, Object object) {
        if (string.equals("ActivatedTargets")) {
            TargetMBean[] targetMBeanArray = this._ActivatedTargets;
            this._ActivatedTargets = (TargetMBean[])object;
            this._postSet(11, targetMBeanArray, this._ActivatedTargets);
            return;
        }
        if (string.equals("Application")) {
            ApplicationMBean applicationMBean = this._Application;
            this._Application = (ApplicationMBean)object;
            this._postSet(9, applicationMBean, this._Application);
            return;
        }
        if (string.equals("EJBComponentRuntime")) {
            EJBComponentRuntimeMBean eJBComponentRuntimeMBean = this._EJBComponentRuntime;
            this._EJBComponentRuntime = (EJBComponentRuntimeMBean)object;
            this._postSet(21, eJBComponentRuntimeMBean, this._EJBComponentRuntime);
            return;
        }
        if (string.equals("ExtraEjbcOptions")) {
            String string2 = this._ExtraEjbcOptions;
            this._ExtraEjbcOptions = (String)object;
            this._postSet(20, string2, this._ExtraEjbcOptions);
            return;
        }
        if (string.equals("ExtraRmicOptions")) {
            String string3 = this._ExtraRmicOptions;
            this._ExtraRmicOptions = (String)object;
            this._postSet(15, string3, this._ExtraRmicOptions);
            return;
        }
        if (string.equals("ForceGeneration")) {
            boolean bl = this._ForceGeneration;
            this._ForceGeneration = (Boolean)object;
            this._postSet(17, bl, this._ForceGeneration);
            return;
        }
        if (string.equals("JavaCompiler")) {
            String string4 = this._JavaCompiler;
            this._JavaCompiler = (String)object;
            this._postSet(12, string4, this._JavaCompiler);
            return;
        }
        if (string.equals("JavaCompilerPostClassPath")) {
            String string5 = this._JavaCompilerPostClassPath;
            this._JavaCompilerPostClassPath = (String)object;
            this._postSet(14, string5, this._JavaCompilerPostClassPath);
            return;
        }
        if (string.equals("JavaCompilerPreClassPath")) {
            String string6 = this._JavaCompilerPreClassPath;
            this._JavaCompilerPreClassPath = (String)object;
            this._postSet(13, string6, this._JavaCompilerPreClassPath);
            return;
        }
        if (string.equals("KeepGenerated")) {
            boolean bl = this._KeepGenerated;
            this._KeepGenerated = (Boolean)object;
            this._postSet(16, bl, this._KeepGenerated);
            return;
        }
        if (string.equals("Name")) {
            String string7 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string7, this._Name);
            return;
        }
        if (string.equals("Targets")) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._Targets = (TargetMBean[])object;
            this._postSet(7, targetMBeanArray, this._Targets);
            return;
        }
        if (string.equals("TmpPath")) {
            String string8 = this._TmpPath;
            this._TmpPath = (String)object;
            this._postSet(18, string8, this._TmpPath);
            return;
        }
        if (string.equals("VerboseEJBDeploymentEnabled")) {
            String string9 = this._VerboseEJBDeploymentEnabled;
            this._VerboseEJBDeploymentEnabled = (String)object;
            this._postSet(19, string9, this._VerboseEJBDeploymentEnabled);
            return;
        }
        if (string.equals("customizer")) {
            EJBComponent eJBComponent = this._customizer;
            this._customizer = (EJBComponent)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("ActivatedTargets")) {
            return this._ActivatedTargets;
        }
        if (string.equals("Application")) {
            return this._Application;
        }
        if (string.equals("EJBComponentRuntime")) {
            return this._EJBComponentRuntime;
        }
        if (string.equals("ExtraEjbcOptions")) {
            return this._ExtraEjbcOptions;
        }
        if (string.equals("ExtraRmicOptions")) {
            return this._ExtraRmicOptions;
        }
        if (string.equals("ForceGeneration")) {
            return new Boolean(this._ForceGeneration);
        }
        if (string.equals("JavaCompiler")) {
            return this._JavaCompiler;
        }
        if (string.equals("JavaCompilerPostClassPath")) {
            return this._JavaCompilerPostClassPath;
        }
        if (string.equals("JavaCompilerPreClassPath")) {
            return this._JavaCompilerPreClassPath;
        }
        if (string.equals("KeepGenerated")) {
            return new Boolean(this._KeepGenerated);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("Targets")) {
            return this._Targets;
        }
        if (string.equals("TmpPath")) {
            return this._TmpPath;
        }
        if (string.equals("VerboseEJBDeploymentEnabled")) {
            return this._VerboseEJBDeploymentEnabled;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ComponentMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 16: {
                    if (string.equals("activated-target")) {
                        return 11;
                    }
                    if (!string.equals("force-generation")) break;
                    return 17;
                }
                case 11: {
                    if (!string.equals("application")) break;
                    return 9;
                }
                case 21: {
                    if (!string.equals("ejb-component-runtime")) break;
                    return 21;
                }
                case 18: {
                    if (string.equals("extra-ejbc-options")) {
                        return 20;
                    }
                    if (!string.equals("extra-rmic-options")) break;
                    return 15;
                }
                case 13: {
                    if (!string.equals("java-compiler")) break;
                    return 12;
                }
                case 29: {
                    if (string.equals("java-compiler-post-class-path")) {
                        return 14;
                    }
                    if (!string.equals("verboseejb-deployment-enabled")) break;
                    return 19;
                }
                case 28: {
                    if (!string.equals("java-compiler-pre-class-path")) break;
                    return 13;
                }
                case 14: {
                    if (!string.equals("keep-generated")) break;
                    return 16;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 6: {
                    if (!string.equals("target")) break;
                    return 7;
                }
                case 8: {
                    if (!string.equals("tmp-path")) break;
                    return 18;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 11: {
                    return "activated-target";
                }
                case 9: {
                    return "application";
                }
                case 21: {
                    return "ejb-component-runtime";
                }
                case 20: {
                    return "extra-ejbc-options";
                }
                case 15: {
                    return "extra-rmic-options";
                }
                case 17: {
                    return "force-generation";
                }
                case 12: {
                    return "java-compiler";
                }
                case 14: {
                    return "java-compiler-post-class-path";
                }
                case 13: {
                    return "java-compiler-pre-class-path";
                }
                case 16: {
                    return "keep-generated";
                }
                case 2: {
                    return "name";
                }
                case 7: {
                    return "target";
                }
                case 18: {
                    return "tmp-path";
                }
                case 19: {
                    return "verboseejb-deployment-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 11: {
                    return true;
                }
                case 7: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ComponentMBeanImpl.Helper {
        private EJBComponentMBeanImpl bean;

        protected Helper(EJBComponentMBeanImpl eJBComponentMBeanImpl) {
            super(eJBComponentMBeanImpl);
            this.bean = eJBComponentMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 11: {
                    return "ActivatedTargets";
                }
                case 9: {
                    return "Application";
                }
                case 21: {
                    return "EJBComponentRuntime";
                }
                case 20: {
                    return "ExtraEjbcOptions";
                }
                case 15: {
                    return "ExtraRmicOptions";
                }
                case 17: {
                    return "ForceGeneration";
                }
                case 12: {
                    return "JavaCompiler";
                }
                case 14: {
                    return "JavaCompilerPostClassPath";
                }
                case 13: {
                    return "JavaCompilerPreClassPath";
                }
                case 16: {
                    return "KeepGenerated";
                }
                case 2: {
                    return "Name";
                }
                case 7: {
                    return "Targets";
                }
                case 18: {
                    return "TmpPath";
                }
                case 19: {
                    return "VerboseEJBDeploymentEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("ActivatedTargets")) {
                return 11;
            }
            if (string.equals("Application")) {
                return 9;
            }
            if (string.equals("EJBComponentRuntime")) {
                return 21;
            }
            if (string.equals("ExtraEjbcOptions")) {
                return 20;
            }
            if (string.equals("ExtraRmicOptions")) {
                return 15;
            }
            if (string.equals("ForceGeneration")) {
                return 17;
            }
            if (string.equals("JavaCompiler")) {
                return 12;
            }
            if (string.equals("JavaCompilerPostClassPath")) {
                return 14;
            }
            if (string.equals("JavaCompilerPreClassPath")) {
                return 13;
            }
            if (string.equals("KeepGenerated")) {
                return 16;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("Targets")) {
                return 7;
            }
            if (string.equals("TmpPath")) {
                return 18;
            }
            if (string.equals("VerboseEJBDeploymentEnabled")) {
                return 19;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isActivatedTargetsSet()) {
                    stringBuffer.append("ActivatedTargets");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getActivatedTargets())));
                }
                if (this.bean.isApplicationSet()) {
                    stringBuffer.append("Application");
                    stringBuffer.append(String.valueOf(this.bean.getApplication()));
                }
                if (this.bean.isEJBComponentRuntimeSet()) {
                    stringBuffer.append("EJBComponentRuntime");
                    stringBuffer.append(String.valueOf(this.bean.getEJBComponentRuntime()));
                }
                if (this.bean.isExtraEjbcOptionsSet()) {
                    stringBuffer.append("ExtraEjbcOptions");
                    stringBuffer.append(String.valueOf(this.bean.getExtraEjbcOptions()));
                }
                if (this.bean.isExtraRmicOptionsSet()) {
                    stringBuffer.append("ExtraRmicOptions");
                    stringBuffer.append(String.valueOf(this.bean.getExtraRmicOptions()));
                }
                if (this.bean.isForceGenerationSet()) {
                    stringBuffer.append("ForceGeneration");
                    stringBuffer.append(String.valueOf(this.bean.getForceGeneration()));
                }
                if (this.bean.isJavaCompilerSet()) {
                    stringBuffer.append("JavaCompiler");
                    stringBuffer.append(String.valueOf(this.bean.getJavaCompiler()));
                }
                if (this.bean.isJavaCompilerPostClassPathSet()) {
                    stringBuffer.append("JavaCompilerPostClassPath");
                    stringBuffer.append(String.valueOf(this.bean.getJavaCompilerPostClassPath()));
                }
                if (this.bean.isJavaCompilerPreClassPathSet()) {
                    stringBuffer.append("JavaCompilerPreClassPath");
                    stringBuffer.append(String.valueOf(this.bean.getJavaCompilerPreClassPath()));
                }
                if (this.bean.isKeepGeneratedSet()) {
                    stringBuffer.append("KeepGenerated");
                    stringBuffer.append(String.valueOf(this.bean.getKeepGenerated()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isTargetsSet()) {
                    stringBuffer.append("Targets");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getTargets())));
                }
                if (this.bean.isTmpPathSet()) {
                    stringBuffer.append("TmpPath");
                    stringBuffer.append(String.valueOf(this.bean.getTmpPath()));
                }
                if (this.bean.isVerboseEJBDeploymentEnabledSet()) {
                    stringBuffer.append("VerboseEJBDeploymentEnabled");
                    stringBuffer.append(String.valueOf(this.bean.getVerboseEJBDeploymentEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                EJBComponentMBeanImpl eJBComponentMBeanImpl = (EJBComponentMBeanImpl)abstractDescriptorBean;
                this.computeDiff("ExtraEjbcOptions", this.bean.getExtraEjbcOptions(), eJBComponentMBeanImpl.getExtraEjbcOptions(), false);
                this.computeDiff("ExtraRmicOptions", this.bean.getExtraRmicOptions(), eJBComponentMBeanImpl.getExtraRmicOptions(), false);
                this.computeDiff("ForceGeneration", this.bean.getForceGeneration(), eJBComponentMBeanImpl.getForceGeneration(), false);
                this.computeDiff("JavaCompiler", this.bean.getJavaCompiler(), eJBComponentMBeanImpl.getJavaCompiler(), true);
                this.computeDiff("JavaCompilerPostClassPath", this.bean.getJavaCompilerPostClassPath(), eJBComponentMBeanImpl.getJavaCompilerPostClassPath(), false);
                this.computeDiff("JavaCompilerPreClassPath", this.bean.getJavaCompilerPreClassPath(), eJBComponentMBeanImpl.getJavaCompilerPreClassPath(), false);
                this.computeDiff("KeepGenerated", this.bean.getKeepGenerated(), eJBComponentMBeanImpl.getKeepGenerated(), false);
                this.computeDiff("Name", this.bean.getName(), eJBComponentMBeanImpl.getName(), false);
                this.computeDiff("Targets", this.bean.getTargets(), eJBComponentMBeanImpl.getTargets(), true);
                this.computeDiff("TmpPath", this.bean.getTmpPath(), eJBComponentMBeanImpl.getTmpPath(), false);
                this.computeDiff("VerboseEJBDeploymentEnabled", this.bean.getVerboseEJBDeploymentEnabled(), eJBComponentMBeanImpl.getVerboseEJBDeploymentEnabled(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                EJBComponentMBeanImpl eJBComponentMBeanImpl = (EJBComponentMBeanImpl)beanUpdateEvent.getSourceBean();
                EJBComponentMBeanImpl eJBComponentMBeanImpl2 = (EJBComponentMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (!(string.equals("ActivatedTargets") || string.equals("Application") || string.equals("EJBComponentRuntime"))) {
                    if (string.equals("ExtraEjbcOptions")) {
                        eJBComponentMBeanImpl.setExtraEjbcOptions(eJBComponentMBeanImpl2.getExtraEjbcOptions());
                        eJBComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                    } else if (string.equals("ExtraRmicOptions")) {
                        eJBComponentMBeanImpl.setExtraRmicOptions(eJBComponentMBeanImpl2.getExtraRmicOptions());
                        eJBComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                    } else if (string.equals("ForceGeneration")) {
                        eJBComponentMBeanImpl.setForceGeneration(eJBComponentMBeanImpl2.getForceGeneration());
                        eJBComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                    } else if (string.equals("JavaCompiler")) {
                        eJBComponentMBeanImpl.setJavaCompiler(eJBComponentMBeanImpl2.getJavaCompiler());
                        eJBComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                    } else if (string.equals("JavaCompilerPostClassPath")) {
                        eJBComponentMBeanImpl.setJavaCompilerPostClassPath(eJBComponentMBeanImpl2.getJavaCompilerPostClassPath());
                        eJBComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                    } else if (string.equals("JavaCompilerPreClassPath")) {
                        eJBComponentMBeanImpl.setJavaCompilerPreClassPath(eJBComponentMBeanImpl2.getJavaCompilerPreClassPath());
                        eJBComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                    } else if (string.equals("KeepGenerated")) {
                        eJBComponentMBeanImpl.setKeepGenerated(eJBComponentMBeanImpl2.getKeepGenerated());
                        eJBComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                    } else if (string.equals("Name")) {
                        eJBComponentMBeanImpl.setName(eJBComponentMBeanImpl2.getName());
                        eJBComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                    } else if (string.equals("Targets")) {
                        eJBComponentMBeanImpl.setTargetsAsString(eJBComponentMBeanImpl2.getTargetsAsString());
                        eJBComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                    } else if (string.equals("TmpPath")) {
                        eJBComponentMBeanImpl.setTmpPath(eJBComponentMBeanImpl2.getTmpPath());
                        eJBComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                    } else if (string.equals("VerboseEJBDeploymentEnabled")) {
                        eJBComponentMBeanImpl.setVerboseEJBDeploymentEnabled(eJBComponentMBeanImpl2.getVerboseEJBDeploymentEnabled());
                        eJBComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                    } else {
                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                EJBComponentMBeanImpl eJBComponentMBeanImpl = (EJBComponentMBeanImpl)abstractDescriptorBean;
                super.finishCopy(eJBComponentMBeanImpl, bl, list);
                if ((list == null || !list.contains("ExtraEjbcOptions")) && this.bean.isExtraEjbcOptionsSet()) {
                    eJBComponentMBeanImpl.setExtraEjbcOptions(this.bean.getExtraEjbcOptions());
                }
                if ((list == null || !list.contains("ExtraRmicOptions")) && this.bean.isExtraRmicOptionsSet()) {
                    eJBComponentMBeanImpl.setExtraRmicOptions(this.bean.getExtraRmicOptions());
                }
                if ((list == null || !list.contains("ForceGeneration")) && this.bean.isForceGenerationSet()) {
                    eJBComponentMBeanImpl.setForceGeneration(this.bean.getForceGeneration());
                }
                if ((list == null || !list.contains("JavaCompiler")) && this.bean.isJavaCompilerSet()) {
                    eJBComponentMBeanImpl.setJavaCompiler(this.bean.getJavaCompiler());
                }
                if ((list == null || !list.contains("JavaCompilerPostClassPath")) && this.bean.isJavaCompilerPostClassPathSet()) {
                    eJBComponentMBeanImpl.setJavaCompilerPostClassPath(this.bean.getJavaCompilerPostClassPath());
                }
                if ((list == null || !list.contains("JavaCompilerPreClassPath")) && this.bean.isJavaCompilerPreClassPathSet()) {
                    eJBComponentMBeanImpl.setJavaCompilerPreClassPath(this.bean.getJavaCompilerPreClassPath());
                }
                if ((list == null || !list.contains("KeepGenerated")) && this.bean.isKeepGeneratedSet()) {
                    eJBComponentMBeanImpl.setKeepGenerated(this.bean.getKeepGenerated());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    eJBComponentMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("Targets")) && this.bean.isTargetsSet()) {
                    eJBComponentMBeanImpl._unSet(eJBComponentMBeanImpl, 7);
                    eJBComponentMBeanImpl.setTargetsAsString(this.bean.getTargetsAsString());
                }
                if ((list == null || !list.contains("TmpPath")) && this.bean.isTmpPathSet()) {
                    eJBComponentMBeanImpl.setTmpPath(this.bean.getTmpPath());
                }
                if ((list == null || !list.contains("VerboseEJBDeploymentEnabled")) && this.bean.isVerboseEJBDeploymentEnabledSet()) {
                    eJBComponentMBeanImpl.setVerboseEJBDeploymentEnabled(this.bean.getVerboseEJBDeploymentEnabled());
                }
                return eJBComponentMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getActivatedTargets(), clazz, object);
            this.inferSubTree(this.bean.getApplication(), clazz, object);
            this.inferSubTree(this.bean.getTargets(), clazz, object);
        }
    }
}

