/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.EmbeddedLDAPMBean;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class EmbeddedLDAPMBeanImpl
extends ConfigurationMBeanImpl
implements EmbeddedLDAPMBean,
Serializable {
    private boolean _AnonymousBindAllowed;
    private int _BackupCopies;
    private int _BackupHour;
    private int _BackupMinute;
    private boolean _CacheEnabled;
    private int _CacheSize;
    private int _CacheTTL;
    private String _Credential;
    private byte[] _CredentialEncrypted;
    private boolean _MasterFirst;
    private boolean _RefreshReplicaAtStartup;
    private int _Timeout;
    private static SchemaHelper2 _schemaHelper;

    public EmbeddedLDAPMBeanImpl() {
        this._initializeProperty(-1);
    }

    public EmbeddedLDAPMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public String getCredential() {
        byte[] byArray = this.getCredentialEncrypted();
        return byArray == null ? null : this._decrypt("Credential", byArray);
    }

    public boolean isCredentialSet() {
        return this.isCredentialEncryptedSet();
    }

    public void setCredential(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setCredentialEncrypted(string == null ? null : this._encrypt("Credential", string));
    }

    public byte[] getCredentialEncrypted() {
        return this._getHelper()._cloneArray(this._CredentialEncrypted);
    }

    public String getCredentialEncryptedAsString() {
        byte[] byArray = this.getCredentialEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isCredentialEncryptedSet() {
        return this._isSet(8);
    }

    public void setCredentialEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setCredentialEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public int getBackupHour() {
        return this._BackupHour;
    }

    public boolean isBackupHourSet() {
        return this._isSet(9);
    }

    public void setBackupHour(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"BackupHour", (long)n, (long)0L, (long)23L);
        int n2 = this._BackupHour;
        this._BackupHour = n;
        this._postSet(9, n2, n);
    }

    public int getBackupMinute() {
        return this._BackupMinute;
    }

    public boolean isBackupMinuteSet() {
        return this._isSet(10);
    }

    public void setBackupMinute(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"BackupMinute", (long)n, (long)0L, (long)59L);
        int n2 = this._BackupMinute;
        this._BackupMinute = n;
        this._postSet(10, n2, n);
    }

    public int getBackupCopies() {
        return this._BackupCopies;
    }

    public boolean isBackupCopiesSet() {
        return this._isSet(11);
    }

    public void setBackupCopies(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"BackupCopies", (long)n, (long)0L, (long)65534L);
        int n2 = this._BackupCopies;
        this._BackupCopies = n;
        this._postSet(11, n2, n);
    }

    public boolean isCacheEnabled() {
        return this._CacheEnabled;
    }

    public boolean isCacheEnabledSet() {
        return this._isSet(12);
    }

    public void setCacheEnabled(boolean bl) {
        boolean bl2 = this._CacheEnabled;
        this._CacheEnabled = bl;
        this._postSet(12, bl2, bl);
    }

    public int getCacheSize() {
        return this._CacheSize;
    }

    public boolean isCacheSizeSet() {
        return this._isSet(13);
    }

    public void setCacheSize(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"CacheSize", (int)n, (int)0);
        int n2 = this._CacheSize;
        this._CacheSize = n;
        this._postSet(13, n2, n);
    }

    public int getCacheTTL() {
        return this._CacheTTL;
    }

    public boolean isCacheTTLSet() {
        return this._isSet(14);
    }

    public void setCacheTTL(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"CacheTTL", (int)n, (int)0);
        int n2 = this._CacheTTL;
        this._CacheTTL = n;
        this._postSet(14, n2, n);
    }

    public boolean isRefreshReplicaAtStartup() {
        return this._RefreshReplicaAtStartup;
    }

    public boolean isRefreshReplicaAtStartupSet() {
        return this._isSet(15);
    }

    public void setRefreshReplicaAtStartup(boolean bl) {
        boolean bl2 = this._RefreshReplicaAtStartup;
        this._RefreshReplicaAtStartup = bl;
        this._postSet(15, bl2, bl);
    }

    public boolean isMasterFirst() {
        return this._MasterFirst;
    }

    public boolean isMasterFirstSet() {
        return this._isSet(16);
    }

    public void setMasterFirst(boolean bl) {
        boolean bl2 = this._MasterFirst;
        this._MasterFirst = bl;
        this._postSet(16, bl2, bl);
    }

    public int getTimeout() {
        return this._Timeout;
    }

    public boolean isTimeoutSet() {
        return this._isSet(17);
    }

    public void setTimeout(int n) {
        LegalChecks.checkMin((String)"Timeout", (int)n, (int)0);
        int n2 = this._Timeout;
        this._Timeout = n;
        this._postSet(17, n2, n);
    }

    public boolean isAnonymousBindAllowed() {
        return this._AnonymousBindAllowed;
    }

    public boolean isAnonymousBindAllowedSet() {
        return this._isSet(18);
    }

    public void setAnonymousBindAllowed(boolean bl) {
        boolean bl2 = this._AnonymousBindAllowed;
        this._AnonymousBindAllowed = bl;
        this._postSet(18, bl2, bl);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public void setCredentialEncrypted(byte[] byArray) {
        byte[] byArray2 = this._CredentialEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: CredentialEncrypted of EmbeddedLDAPMBean");
        }
        this._getHelper()._clearArray(this._CredentialEncrypted);
        this._CredentialEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(8, byArray2, byArray);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
            if (n == 7) {
                this._markSet(8, false);
            }
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 11;
        }
        try {
            switch (n) {
                case 11: {
                    this._BackupCopies = 7;
                    if (bl) break;
                }
                case 9: {
                    this._BackupHour = 23;
                    if (bl) break;
                }
                case 10: {
                    this._BackupMinute = 5;
                    if (bl) break;
                }
                case 13: {
                    this._CacheSize = 32;
                    if (bl) break;
                }
                case 14: {
                    this._CacheTTL = 60;
                    if (bl) break;
                }
                case 7: {
                    this._CredentialEncrypted = null;
                    if (bl) break;
                }
                case 8: {
                    this._CredentialEncrypted = null;
                    if (bl) break;
                }
                case 17: {
                    this._Timeout = 0;
                    if (bl) break;
                }
                case 18: {
                    this._AnonymousBindAllowed = false;
                    if (bl) break;
                }
                case 12: {
                    this._CacheEnabled = true;
                    if (bl) break;
                }
                case 16: {
                    this._MasterFirst = false;
                    if (bl) break;
                }
                case 15: {
                    this._RefreshReplicaAtStartup = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "EmbeddedLDAP";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AnonymousBindAllowed")) {
            boolean bl = this._AnonymousBindAllowed;
            this._AnonymousBindAllowed = (Boolean)object;
            this._postSet(18, bl, this._AnonymousBindAllowed);
            return;
        }
        if (string.equals("BackupCopies")) {
            int n = this._BackupCopies;
            this._BackupCopies = (Integer)object;
            this._postSet(11, n, this._BackupCopies);
            return;
        }
        if (string.equals("BackupHour")) {
            int n = this._BackupHour;
            this._BackupHour = (Integer)object;
            this._postSet(9, n, this._BackupHour);
            return;
        }
        if (string.equals("BackupMinute")) {
            int n = this._BackupMinute;
            this._BackupMinute = (Integer)object;
            this._postSet(10, n, this._BackupMinute);
            return;
        }
        if (string.equals("CacheEnabled")) {
            boolean bl = this._CacheEnabled;
            this._CacheEnabled = (Boolean)object;
            this._postSet(12, bl, this._CacheEnabled);
            return;
        }
        if (string.equals("CacheSize")) {
            int n = this._CacheSize;
            this._CacheSize = (Integer)object;
            this._postSet(13, n, this._CacheSize);
            return;
        }
        if (string.equals("CacheTTL")) {
            int n = this._CacheTTL;
            this._CacheTTL = (Integer)object;
            this._postSet(14, n, this._CacheTTL);
            return;
        }
        if (string.equals("Credential")) {
            String string2 = this._Credential;
            this._Credential = (String)object;
            this._postSet(7, string2, this._Credential);
            return;
        }
        if (string.equals("CredentialEncrypted")) {
            byte[] byArray = this._CredentialEncrypted;
            this._CredentialEncrypted = (byte[])object;
            this._postSet(8, byArray, this._CredentialEncrypted);
            return;
        }
        if (string.equals("MasterFirst")) {
            boolean bl = this._MasterFirst;
            this._MasterFirst = (Boolean)object;
            this._postSet(16, bl, this._MasterFirst);
            return;
        }
        if (string.equals("RefreshReplicaAtStartup")) {
            boolean bl = this._RefreshReplicaAtStartup;
            this._RefreshReplicaAtStartup = (Boolean)object;
            this._postSet(15, bl, this._RefreshReplicaAtStartup);
            return;
        }
        if (string.equals("Timeout")) {
            int n = this._Timeout;
            this._Timeout = (Integer)object;
            this._postSet(17, n, this._Timeout);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AnonymousBindAllowed")) {
            return new Boolean(this._AnonymousBindAllowed);
        }
        if (string.equals("BackupCopies")) {
            return new Integer(this._BackupCopies);
        }
        if (string.equals("BackupHour")) {
            return new Integer(this._BackupHour);
        }
        if (string.equals("BackupMinute")) {
            return new Integer(this._BackupMinute);
        }
        if (string.equals("CacheEnabled")) {
            return new Boolean(this._CacheEnabled);
        }
        if (string.equals("CacheSize")) {
            return new Integer(this._CacheSize);
        }
        if (string.equals("CacheTTL")) {
            return new Integer(this._CacheTTL);
        }
        if (string.equals("Credential")) {
            return this._Credential;
        }
        if (string.equals("CredentialEncrypted")) {
            return this._CredentialEncrypted;
        }
        if (string.equals("MasterFirst")) {
            return new Boolean(this._MasterFirst);
        }
        if (string.equals("RefreshReplicaAtStartup")) {
            return new Boolean(this._RefreshReplicaAtStartup);
        }
        if (string.equals("Timeout")) {
            return new Integer(this._Timeout);
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 13: {
                    if (string.equals("backup-copies")) {
                        return 11;
                    }
                    if (string.equals("backup-minute")) {
                        return 10;
                    }
                    if (!string.equals("cache-enabled")) break;
                    return 12;
                }
                case 11: {
                    if (!string.equals("backup-hour")) break;
                    return 9;
                }
                case 10: {
                    if (string.equals("cache-size")) {
                        return 13;
                    }
                    if (!string.equals("credential")) break;
                    return 7;
                }
                case 8: {
                    if (!string.equals("cachettl")) break;
                    return 14;
                }
                case 20: {
                    if (!string.equals("credential-encrypted")) break;
                    return 8;
                }
                case 7: {
                    if (!string.equals("timeout")) break;
                    return 17;
                }
                case 22: {
                    if (!string.equals("anonymous-bind-allowed")) break;
                    return 18;
                }
                case 12: {
                    if (!string.equals("master-first")) break;
                    return 16;
                }
                case 26: {
                    if (!string.equals("refresh-replica-at-startup")) break;
                    return 15;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 11: {
                    return "backup-copies";
                }
                case 9: {
                    return "backup-hour";
                }
                case 10: {
                    return "backup-minute";
                }
                case 13: {
                    return "cache-size";
                }
                case 14: {
                    return "cachettl";
                }
                case 7: {
                    return "credential";
                }
                case 8: {
                    return "credential-encrypted";
                }
                case 17: {
                    return "timeout";
                }
                case 18: {
                    return "anonymous-bind-allowed";
                }
                case 12: {
                    return "cache-enabled";
                }
                case 16: {
                    return "master-first";
                }
                case 15: {
                    return "refresh-replica-at-startup";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                default: 
            }
            return super.isArray(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private EmbeddedLDAPMBeanImpl bean;

        protected Helper(EmbeddedLDAPMBeanImpl embeddedLDAPMBeanImpl) {
            super(embeddedLDAPMBeanImpl);
            this.bean = embeddedLDAPMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 11: {
                    return "BackupCopies";
                }
                case 9: {
                    return "BackupHour";
                }
                case 10: {
                    return "BackupMinute";
                }
                case 13: {
                    return "CacheSize";
                }
                case 14: {
                    return "CacheTTL";
                }
                case 7: {
                    return "Credential";
                }
                case 8: {
                    return "CredentialEncrypted";
                }
                case 17: {
                    return "Timeout";
                }
                case 18: {
                    return "AnonymousBindAllowed";
                }
                case 12: {
                    return "CacheEnabled";
                }
                case 16: {
                    return "MasterFirst";
                }
                case 15: {
                    return "RefreshReplicaAtStartup";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("BackupCopies")) {
                return 11;
            }
            if (string.equals("BackupHour")) {
                return 9;
            }
            if (string.equals("BackupMinute")) {
                return 10;
            }
            if (string.equals("CacheSize")) {
                return 13;
            }
            if (string.equals("CacheTTL")) {
                return 14;
            }
            if (string.equals("Credential")) {
                return 7;
            }
            if (string.equals("CredentialEncrypted")) {
                return 8;
            }
            if (string.equals("Timeout")) {
                return 17;
            }
            if (string.equals("AnonymousBindAllowed")) {
                return 18;
            }
            if (string.equals("CacheEnabled")) {
                return 12;
            }
            if (string.equals("MasterFirst")) {
                return 16;
            }
            if (string.equals("RefreshReplicaAtStartup")) {
                return 15;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isBackupCopiesSet()) {
                    stringBuffer.append("BackupCopies");
                    stringBuffer.append(String.valueOf(this.bean.getBackupCopies()));
                }
                if (this.bean.isBackupHourSet()) {
                    stringBuffer.append("BackupHour");
                    stringBuffer.append(String.valueOf(this.bean.getBackupHour()));
                }
                if (this.bean.isBackupMinuteSet()) {
                    stringBuffer.append("BackupMinute");
                    stringBuffer.append(String.valueOf(this.bean.getBackupMinute()));
                }
                if (this.bean.isCacheSizeSet()) {
                    stringBuffer.append("CacheSize");
                    stringBuffer.append(String.valueOf(this.bean.getCacheSize()));
                }
                if (this.bean.isCacheTTLSet()) {
                    stringBuffer.append("CacheTTL");
                    stringBuffer.append(String.valueOf(this.bean.getCacheTTL()));
                }
                if (this.bean.isCredentialSet()) {
                    stringBuffer.append("Credential");
                    stringBuffer.append(String.valueOf(this.bean.getCredential()));
                }
                if (this.bean.isCredentialEncryptedSet()) {
                    stringBuffer.append("CredentialEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getCredentialEncrypted())));
                }
                if (this.bean.isTimeoutSet()) {
                    stringBuffer.append("Timeout");
                    stringBuffer.append(String.valueOf(this.bean.getTimeout()));
                }
                if (this.bean.isAnonymousBindAllowedSet()) {
                    stringBuffer.append("AnonymousBindAllowed");
                    stringBuffer.append(String.valueOf(this.bean.isAnonymousBindAllowed()));
                }
                if (this.bean.isCacheEnabledSet()) {
                    stringBuffer.append("CacheEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isCacheEnabled()));
                }
                if (this.bean.isMasterFirstSet()) {
                    stringBuffer.append("MasterFirst");
                    stringBuffer.append(String.valueOf(this.bean.isMasterFirst()));
                }
                if (this.bean.isRefreshReplicaAtStartupSet()) {
                    stringBuffer.append("RefreshReplicaAtStartup");
                    stringBuffer.append(String.valueOf(this.bean.isRefreshReplicaAtStartup()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                EmbeddedLDAPMBeanImpl embeddedLDAPMBeanImpl = (EmbeddedLDAPMBeanImpl)abstractDescriptorBean;
                this.computeDiff("BackupCopies", this.bean.getBackupCopies(), embeddedLDAPMBeanImpl.getBackupCopies(), false);
                this.computeDiff("BackupHour", this.bean.getBackupHour(), embeddedLDAPMBeanImpl.getBackupHour(), false);
                this.computeDiff("BackupMinute", this.bean.getBackupMinute(), embeddedLDAPMBeanImpl.getBackupMinute(), false);
                this.computeDiff("CacheSize", this.bean.getCacheSize(), embeddedLDAPMBeanImpl.getCacheSize(), false);
                this.computeDiff("CacheTTL", this.bean.getCacheTTL(), embeddedLDAPMBeanImpl.getCacheTTL(), false);
                this.computeDiff("CredentialEncrypted", this.bean.getCredentialEncrypted(), embeddedLDAPMBeanImpl.getCredentialEncrypted(), false);
                this.computeDiff("Timeout", this.bean.getTimeout(), embeddedLDAPMBeanImpl.getTimeout(), false);
                this.computeDiff("AnonymousBindAllowed", this.bean.isAnonymousBindAllowed(), embeddedLDAPMBeanImpl.isAnonymousBindAllowed(), false);
                this.computeDiff("CacheEnabled", this.bean.isCacheEnabled(), embeddedLDAPMBeanImpl.isCacheEnabled(), false);
                this.computeDiff("MasterFirst", this.bean.isMasterFirst(), embeddedLDAPMBeanImpl.isMasterFirst(), false);
                this.computeDiff("RefreshReplicaAtStartup", this.bean.isRefreshReplicaAtStartup(), embeddedLDAPMBeanImpl.isRefreshReplicaAtStartup(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                EmbeddedLDAPMBeanImpl embeddedLDAPMBeanImpl = (EmbeddedLDAPMBeanImpl)beanUpdateEvent.getSourceBean();
                EmbeddedLDAPMBeanImpl embeddedLDAPMBeanImpl2 = (EmbeddedLDAPMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("BackupCopies")) {
                    embeddedLDAPMBeanImpl.setBackupCopies(embeddedLDAPMBeanImpl2.getBackupCopies());
                    embeddedLDAPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("BackupHour")) {
                    embeddedLDAPMBeanImpl.setBackupHour(embeddedLDAPMBeanImpl2.getBackupHour());
                    embeddedLDAPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("BackupMinute")) {
                    embeddedLDAPMBeanImpl.setBackupMinute(embeddedLDAPMBeanImpl2.getBackupMinute());
                    embeddedLDAPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("CacheSize")) {
                    embeddedLDAPMBeanImpl.setCacheSize(embeddedLDAPMBeanImpl2.getCacheSize());
                    embeddedLDAPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("CacheTTL")) {
                    embeddedLDAPMBeanImpl.setCacheTTL(embeddedLDAPMBeanImpl2.getCacheTTL());
                    embeddedLDAPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (!string.equals("Credential")) {
                    if (string.equals("CredentialEncrypted")) {
                        embeddedLDAPMBeanImpl.setCredentialEncrypted(embeddedLDAPMBeanImpl2.getCredentialEncrypted());
                        embeddedLDAPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                    } else if (string.equals("Timeout")) {
                        embeddedLDAPMBeanImpl.setTimeout(embeddedLDAPMBeanImpl2.getTimeout());
                        embeddedLDAPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                    } else if (string.equals("AnonymousBindAllowed")) {
                        embeddedLDAPMBeanImpl.setAnonymousBindAllowed(embeddedLDAPMBeanImpl2.isAnonymousBindAllowed());
                        embeddedLDAPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                    } else if (string.equals("CacheEnabled")) {
                        embeddedLDAPMBeanImpl.setCacheEnabled(embeddedLDAPMBeanImpl2.isCacheEnabled());
                        embeddedLDAPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                    } else if (string.equals("MasterFirst")) {
                        embeddedLDAPMBeanImpl.setMasterFirst(embeddedLDAPMBeanImpl2.isMasterFirst());
                        embeddedLDAPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                    } else if (string.equals("RefreshReplicaAtStartup")) {
                        embeddedLDAPMBeanImpl.setRefreshReplicaAtStartup(embeddedLDAPMBeanImpl2.isRefreshReplicaAtStartup());
                        embeddedLDAPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                    } else {
                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                EmbeddedLDAPMBeanImpl embeddedLDAPMBeanImpl = (EmbeddedLDAPMBeanImpl)abstractDescriptorBean;
                super.finishCopy(embeddedLDAPMBeanImpl, bl, list);
                if ((list == null || !list.contains("BackupCopies")) && this.bean.isBackupCopiesSet()) {
                    embeddedLDAPMBeanImpl.setBackupCopies(this.bean.getBackupCopies());
                }
                if ((list == null || !list.contains("BackupHour")) && this.bean.isBackupHourSet()) {
                    embeddedLDAPMBeanImpl.setBackupHour(this.bean.getBackupHour());
                }
                if ((list == null || !list.contains("BackupMinute")) && this.bean.isBackupMinuteSet()) {
                    embeddedLDAPMBeanImpl.setBackupMinute(this.bean.getBackupMinute());
                }
                if ((list == null || !list.contains("CacheSize")) && this.bean.isCacheSizeSet()) {
                    embeddedLDAPMBeanImpl.setCacheSize(this.bean.getCacheSize());
                }
                if ((list == null || !list.contains("CacheTTL")) && this.bean.isCacheTTLSet()) {
                    embeddedLDAPMBeanImpl.setCacheTTL(this.bean.getCacheTTL());
                }
                if ((list == null || !list.contains("CredentialEncrypted")) && this.bean.isCredentialEncryptedSet()) {
                    byte[] byArray = this.bean.getCredentialEncrypted();
                    embeddedLDAPMBeanImpl.setCredentialEncrypted(byArray == null ? null : (byte[])byArray.clone());
                }
                if ((list == null || !list.contains("Timeout")) && this.bean.isTimeoutSet()) {
                    embeddedLDAPMBeanImpl.setTimeout(this.bean.getTimeout());
                }
                if ((list == null || !list.contains("AnonymousBindAllowed")) && this.bean.isAnonymousBindAllowedSet()) {
                    embeddedLDAPMBeanImpl.setAnonymousBindAllowed(this.bean.isAnonymousBindAllowed());
                }
                if ((list == null || !list.contains("CacheEnabled")) && this.bean.isCacheEnabledSet()) {
                    embeddedLDAPMBeanImpl.setCacheEnabled(this.bean.isCacheEnabled());
                }
                if ((list == null || !list.contains("MasterFirst")) && this.bean.isMasterFirstSet()) {
                    embeddedLDAPMBeanImpl.setMasterFirst(this.bean.isMasterFirst());
                }
                if ((list == null || !list.contains("RefreshReplicaAtStartup")) && this.bean.isRefreshReplicaAtStartupSet()) {
                    embeddedLDAPMBeanImpl.setRefreshReplicaAtStartup(this.bean.isRefreshReplicaAtStartup());
                }
                return embeddedLDAPMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

