/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.ExecuteQueueMBean;
import weblogic.utils.collections.CombinedIterator;

public class ExecuteQueueMBeanImpl
extends ConfigurationMBeanImpl
implements ExecuteQueueMBean,
Serializable {
    private int _QueueLength;
    private int _QueueLengthThresholdPercent;
    private int _ThreadCount;
    private int _ThreadPriority;
    private int _ThreadsIncrease;
    private int _ThreadsMaximum;
    private int _ThreadsMinimum;
    private static SchemaHelper2 _schemaHelper;

    public ExecuteQueueMBeanImpl() {
        this._initializeProperty(-1);
    }

    public ExecuteQueueMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public int getQueueLength() {
        return this._QueueLength;
    }

    public boolean isQueueLengthSet() {
        return this._isSet(7);
    }

    public void setQueueLength(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"QueueLength", (long)n, (long)256L, (long)0x40000000L);
        int n2 = this._QueueLength;
        this._QueueLength = n;
        this._postSet(7, n2, n);
    }

    public int getThreadPriority() {
        return this._ThreadPriority;
    }

    public boolean isThreadPrioritySet() {
        return this._isSet(8);
    }

    public void setThreadPriority(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ThreadPriority", (long)n, (long)1L, (long)10L);
        int n2 = this._ThreadPriority;
        this._ThreadPriority = n;
        this._postSet(8, n2, n);
    }

    public int getThreadCount() {
        if (!this._isSet(9)) {
            return this._isProductionModeEnabled() ? 25 : 15;
        }
        return this._ThreadCount;
    }

    public boolean isThreadCountSet() {
        return this._isSet(9);
    }

    public void setThreadCount(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ThreadCount", (long)n, (long)0L, (long)65536L);
        int n2 = this._ThreadCount;
        this._ThreadCount = n;
        this._postSet(9, n2, n);
    }

    public int getQueueLengthThresholdPercent() {
        return this._QueueLengthThresholdPercent;
    }

    public boolean isQueueLengthThresholdPercentSet() {
        return this._isSet(10);
    }

    public void setQueueLengthThresholdPercent(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"QueueLengthThresholdPercent", (long)n, (long)1L, (long)99L);
        int n2 = this._QueueLengthThresholdPercent;
        this._QueueLengthThresholdPercent = n;
        this._postSet(10, n2, n);
    }

    public int getThreadsIncrease() {
        return this._ThreadsIncrease;
    }

    public boolean isThreadsIncreaseSet() {
        return this._isSet(11);
    }

    public void setThreadsIncrease(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ThreadsIncrease", (long)n, (long)0L, (long)65536L);
        int n2 = this._ThreadsIncrease;
        this._ThreadsIncrease = n;
        this._postSet(11, n2, n);
    }

    public int getThreadsMaximum() {
        return this._ThreadsMaximum;
    }

    public boolean isThreadsMaximumSet() {
        return this._isSet(12);
    }

    public void setThreadsMaximum(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ThreadsMaximum", (long)n, (long)1L, (long)65536L);
        int n2 = this._ThreadsMaximum;
        this._ThreadsMaximum = n;
        this._postSet(12, n2, n);
    }

    public int getThreadsMinimum() {
        return this._ThreadsMinimum;
    }

    public boolean isThreadsMinimumSet() {
        return this._isSet(13);
    }

    public void setThreadsMinimum(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ThreadsMinimum", (long)n, (long)0L, (long)65536L);
        int n2 = this._ThreadsMinimum;
        this._ThreadsMinimum = n;
        this._postSet(13, n2, n);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 7;
        }
        try {
            switch (n) {
                case 7: {
                    this._QueueLength = 65536;
                    if (bl) break;
                }
                case 10: {
                    this._QueueLengthThresholdPercent = 90;
                    if (bl) break;
                }
                case 9: {
                    this._ThreadCount = 15;
                    if (bl) break;
                }
                case 8: {
                    this._ThreadPriority = 5;
                    if (bl) break;
                }
                case 11: {
                    this._ThreadsIncrease = 0;
                    if (bl) break;
                }
                case 12: {
                    this._ThreadsMaximum = 400;
                    if (bl) break;
                }
                case 13: {
                    this._ThreadsMinimum = 5;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "ExecuteQueue";
    }

    public void putValue(String string, Object object) {
        if (string.equals("QueueLength")) {
            int n = this._QueueLength;
            this._QueueLength = (Integer)object;
            this._postSet(7, n, this._QueueLength);
            return;
        }
        if (string.equals("QueueLengthThresholdPercent")) {
            int n = this._QueueLengthThresholdPercent;
            this._QueueLengthThresholdPercent = (Integer)object;
            this._postSet(10, n, this._QueueLengthThresholdPercent);
            return;
        }
        if (string.equals("ThreadCount")) {
            int n = this._ThreadCount;
            this._ThreadCount = (Integer)object;
            this._postSet(9, n, this._ThreadCount);
            return;
        }
        if (string.equals("ThreadPriority")) {
            int n = this._ThreadPriority;
            this._ThreadPriority = (Integer)object;
            this._postSet(8, n, this._ThreadPriority);
            return;
        }
        if (string.equals("ThreadsIncrease")) {
            int n = this._ThreadsIncrease;
            this._ThreadsIncrease = (Integer)object;
            this._postSet(11, n, this._ThreadsIncrease);
            return;
        }
        if (string.equals("ThreadsMaximum")) {
            int n = this._ThreadsMaximum;
            this._ThreadsMaximum = (Integer)object;
            this._postSet(12, n, this._ThreadsMaximum);
            return;
        }
        if (string.equals("ThreadsMinimum")) {
            int n = this._ThreadsMinimum;
            this._ThreadsMinimum = (Integer)object;
            this._postSet(13, n, this._ThreadsMinimum);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("QueueLength")) {
            return new Integer(this._QueueLength);
        }
        if (string.equals("QueueLengthThresholdPercent")) {
            return new Integer(this._QueueLengthThresholdPercent);
        }
        if (string.equals("ThreadCount")) {
            return new Integer(this._ThreadCount);
        }
        if (string.equals("ThreadPriority")) {
            return new Integer(this._ThreadPriority);
        }
        if (string.equals("ThreadsIncrease")) {
            return new Integer(this._ThreadsIncrease);
        }
        if (string.equals("ThreadsMaximum")) {
            return new Integer(this._ThreadsMaximum);
        }
        if (string.equals("ThreadsMinimum")) {
            return new Integer(this._ThreadsMinimum);
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 12: {
                    if (string.equals("queue-length")) {
                        return 7;
                    }
                    if (!string.equals("thread-count")) break;
                    return 9;
                }
                case 30: {
                    if (!string.equals("queue-length-threshold-percent")) break;
                    return 10;
                }
                case 15: {
                    if (string.equals("thread-priority")) {
                        return 8;
                    }
                    if (string.equals("threads-maximum")) {
                        return 12;
                    }
                    if (!string.equals("threads-minimum")) break;
                    return 13;
                }
                case 16: {
                    if (!string.equals("threads-increase")) break;
                    return 11;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 7: {
                    return "queue-length";
                }
                case 10: {
                    return "queue-length-threshold-percent";
                }
                case 9: {
                    return "thread-count";
                }
                case 8: {
                    return "thread-priority";
                }
                case 11: {
                    return "threads-increase";
                }
                case 12: {
                    return "threads-maximum";
                }
                case 13: {
                    return "threads-minimum";
                }
            }
            return super.getElementName(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private ExecuteQueueMBeanImpl bean;

        protected Helper(ExecuteQueueMBeanImpl executeQueueMBeanImpl) {
            super(executeQueueMBeanImpl);
            this.bean = executeQueueMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 7: {
                    return "QueueLength";
                }
                case 10: {
                    return "QueueLengthThresholdPercent";
                }
                case 9: {
                    return "ThreadCount";
                }
                case 8: {
                    return "ThreadPriority";
                }
                case 11: {
                    return "ThreadsIncrease";
                }
                case 12: {
                    return "ThreadsMaximum";
                }
                case 13: {
                    return "ThreadsMinimum";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("QueueLength")) {
                return 7;
            }
            if (string.equals("QueueLengthThresholdPercent")) {
                return 10;
            }
            if (string.equals("ThreadCount")) {
                return 9;
            }
            if (string.equals("ThreadPriority")) {
                return 8;
            }
            if (string.equals("ThreadsIncrease")) {
                return 11;
            }
            if (string.equals("ThreadsMaximum")) {
                return 12;
            }
            if (string.equals("ThreadsMinimum")) {
                return 13;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isQueueLengthSet()) {
                    stringBuffer.append("QueueLength");
                    stringBuffer.append(String.valueOf(this.bean.getQueueLength()));
                }
                if (this.bean.isQueueLengthThresholdPercentSet()) {
                    stringBuffer.append("QueueLengthThresholdPercent");
                    stringBuffer.append(String.valueOf(this.bean.getQueueLengthThresholdPercent()));
                }
                if (this.bean.isThreadCountSet()) {
                    stringBuffer.append("ThreadCount");
                    stringBuffer.append(String.valueOf(this.bean.getThreadCount()));
                }
                if (this.bean.isThreadPrioritySet()) {
                    stringBuffer.append("ThreadPriority");
                    stringBuffer.append(String.valueOf(this.bean.getThreadPriority()));
                }
                if (this.bean.isThreadsIncreaseSet()) {
                    stringBuffer.append("ThreadsIncrease");
                    stringBuffer.append(String.valueOf(this.bean.getThreadsIncrease()));
                }
                if (this.bean.isThreadsMaximumSet()) {
                    stringBuffer.append("ThreadsMaximum");
                    stringBuffer.append(String.valueOf(this.bean.getThreadsMaximum()));
                }
                if (this.bean.isThreadsMinimumSet()) {
                    stringBuffer.append("ThreadsMinimum");
                    stringBuffer.append(String.valueOf(this.bean.getThreadsMinimum()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                ExecuteQueueMBeanImpl executeQueueMBeanImpl = (ExecuteQueueMBeanImpl)abstractDescriptorBean;
                this.computeDiff("QueueLength", this.bean.getQueueLength(), executeQueueMBeanImpl.getQueueLength(), false);
                this.computeDiff("QueueLengthThresholdPercent", this.bean.getQueueLengthThresholdPercent(), executeQueueMBeanImpl.getQueueLengthThresholdPercent(), true);
                this.computeDiff("ThreadCount", this.bean.getThreadCount(), executeQueueMBeanImpl.getThreadCount(), false);
                this.computeDiff("ThreadPriority", this.bean.getThreadPriority(), executeQueueMBeanImpl.getThreadPriority(), false);
                this.computeDiff("ThreadsIncrease", this.bean.getThreadsIncrease(), executeQueueMBeanImpl.getThreadsIncrease(), true);
                this.computeDiff("ThreadsMaximum", this.bean.getThreadsMaximum(), executeQueueMBeanImpl.getThreadsMaximum(), true);
                this.computeDiff("ThreadsMinimum", this.bean.getThreadsMinimum(), executeQueueMBeanImpl.getThreadsMinimum(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                ExecuteQueueMBeanImpl executeQueueMBeanImpl = (ExecuteQueueMBeanImpl)beanUpdateEvent.getSourceBean();
                ExecuteQueueMBeanImpl executeQueueMBeanImpl2 = (ExecuteQueueMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("QueueLength")) {
                    executeQueueMBeanImpl.setQueueLength(executeQueueMBeanImpl2.getQueueLength());
                    executeQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("QueueLengthThresholdPercent")) {
                    executeQueueMBeanImpl.setQueueLengthThresholdPercent(executeQueueMBeanImpl2.getQueueLengthThresholdPercent());
                    executeQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("ThreadCount")) {
                    executeQueueMBeanImpl.setThreadCount(executeQueueMBeanImpl2.getThreadCount());
                    executeQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("ThreadPriority")) {
                    executeQueueMBeanImpl.setThreadPriority(executeQueueMBeanImpl2.getThreadPriority());
                    executeQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("ThreadsIncrease")) {
                    executeQueueMBeanImpl.setThreadsIncrease(executeQueueMBeanImpl2.getThreadsIncrease());
                    executeQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("ThreadsMaximum")) {
                    executeQueueMBeanImpl.setThreadsMaximum(executeQueueMBeanImpl2.getThreadsMaximum());
                    executeQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("ThreadsMinimum")) {
                    executeQueueMBeanImpl.setThreadsMinimum(executeQueueMBeanImpl2.getThreadsMinimum());
                    executeQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                ExecuteQueueMBeanImpl executeQueueMBeanImpl = (ExecuteQueueMBeanImpl)abstractDescriptorBean;
                super.finishCopy(executeQueueMBeanImpl, bl, list);
                if ((list == null || !list.contains("QueueLength")) && this.bean.isQueueLengthSet()) {
                    executeQueueMBeanImpl.setQueueLength(this.bean.getQueueLength());
                }
                if ((list == null || !list.contains("QueueLengthThresholdPercent")) && this.bean.isQueueLengthThresholdPercentSet()) {
                    executeQueueMBeanImpl.setQueueLengthThresholdPercent(this.bean.getQueueLengthThresholdPercent());
                }
                if ((list == null || !list.contains("ThreadCount")) && this.bean.isThreadCountSet()) {
                    executeQueueMBeanImpl.setThreadCount(this.bean.getThreadCount());
                }
                if ((list == null || !list.contains("ThreadPriority")) && this.bean.isThreadPrioritySet()) {
                    executeQueueMBeanImpl.setThreadPriority(this.bean.getThreadPriority());
                }
                if ((list == null || !list.contains("ThreadsIncrease")) && this.bean.isThreadsIncreaseSet()) {
                    executeQueueMBeanImpl.setThreadsIncrease(this.bean.getThreadsIncrease());
                }
                if ((list == null || !list.contains("ThreadsMaximum")) && this.bean.isThreadsMaximumSet()) {
                    executeQueueMBeanImpl.setThreadsMaximum(this.bean.getThreadsMaximum());
                }
                if ((list == null || !list.contains("ThreadsMinimum")) && this.bean.isThreadsMinimumSet()) {
                    executeQueueMBeanImpl.setThreadsMinimum(this.bean.getThreadsMinimum());
                }
                return executeQueueMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

