/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.beangen.StringHelper;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.FederationServicesMBean;
import weblogic.management.configuration.ServerLegalHelper;
import weblogic.management.mbeans.custom.FederationServices;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class FederationServicesMBeanImpl
extends ConfigurationMBeanImpl
implements FederationServicesMBean,
Serializable {
    private boolean _ACSRequiresSSL;
    private boolean _ARSRequiresSSL;
    private boolean _ARSRequiresTwoWaySSL;
    private String[] _AssertionConsumerURIs;
    private String[] _AssertionRetrievalURIs;
    private String _AssertionStoreClassName;
    private Properties _AssertionStoreProperties;
    private boolean _DestinationSiteEnabled;
    private boolean _ITSRequiresSSL;
    private String[] _IntersiteTransferURIs;
    private String _Name;
    private boolean _POSTOneUseCheckEnabled;
    private boolean _POSTRecipientCheckEnabled;
    private String _SSLClientIdentityAlias;
    private String _SSLClientIdentityPassPhrase;
    private byte[] _SSLClientIdentityPassPhraseEncrypted;
    private String _SigningKeyAlias;
    private String _SigningKeyPassPhrase;
    private byte[] _SigningKeyPassPhraseEncrypted;
    private String _SourceIdBase64;
    private String _SourceIdHex;
    private boolean _SourceSiteEnabled;
    private String _SourceSiteURL;
    private String _UsedAssertionCacheClassName;
    private Properties _UsedAssertionCacheProperties;
    private FederationServices _customizer;
    private static SchemaHelper2 _schemaHelper;

    public FederationServicesMBeanImpl() {
        try {
            this._customizer = new FederationServices(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public FederationServicesMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new FederationServices(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isSourceSiteEnabled() {
        return this._SourceSiteEnabled;
    }

    public boolean isSourceSiteEnabledSet() {
        return this._isSet(7);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setSourceSiteEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._SourceSiteEnabled;
        this._SourceSiteEnabled = bl;
        this._postSet(7, bl2, bl);
    }

    public String getSourceSiteURL() {
        return this._SourceSiteURL;
    }

    public boolean isSourceSiteURLSet() {
        return this._isSet(8);
    }

    public void setSourceSiteURL(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._SourceSiteURL;
        this._SourceSiteURL = string;
        this._postSet(8, string2, string);
    }

    public String getSourceIdHex() {
        return this._customizer.getSourceIdHex();
    }

    public boolean isSourceIdHexSet() {
        return this._isSet(9);
    }

    public void setSourceIdHex(String string) throws InvalidAttributeValueException {
        this._SourceIdHex = string = string == null ? null : string.trim();
    }

    public String getSourceIdBase64() {
        return this._customizer.getSourceIdBase64();
    }

    public boolean isSourceIdBase64Set() {
        return this._isSet(10);
    }

    public void setSourceIdBase64(String string) throws InvalidAttributeValueException {
        this._SourceIdBase64 = string = string == null ? null : string.trim();
    }

    public String[] getIntersiteTransferURIs() {
        return this._IntersiteTransferURIs;
    }

    public boolean isIntersiteTransferURIsSet() {
        return this._isSet(11);
    }

    public void setIntersiteTransferURIs(String[] stringArray) throws InvalidAttributeValueException {
        stringArray = stringArray == null ? new String[]{} : stringArray;
        stringArray = this._getHelper()._trimElements(stringArray);
        String[] stringArray2 = this._IntersiteTransferURIs;
        this._IntersiteTransferURIs = stringArray;
        this._postSet(11, stringArray2, stringArray);
    }

    public boolean isITSRequiresSSL() {
        return this._ITSRequiresSSL;
    }

    public boolean isITSRequiresSSLSet() {
        return this._isSet(12);
    }

    public void setITSRequiresSSL(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._ITSRequiresSSL;
        this._ITSRequiresSSL = bl;
        this._postSet(12, bl2, bl);
    }

    public String[] getAssertionRetrievalURIs() {
        return this._AssertionRetrievalURIs;
    }

    public boolean isAssertionRetrievalURIsSet() {
        return this._isSet(13);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void setAssertionRetrievalURIs(String[] stringArray) throws InvalidAttributeValueException {
        stringArray = stringArray == null ? new String[]{} : stringArray;
        stringArray = this._getHelper()._trimElements(stringArray);
        String[] stringArray2 = this._AssertionRetrievalURIs;
        this._AssertionRetrievalURIs = stringArray;
        this._postSet(13, stringArray2, stringArray);
    }

    public boolean isARSRequiresSSL() {
        return this._ARSRequiresSSL;
    }

    public boolean isARSRequiresSSLSet() {
        return this._isSet(14);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setARSRequiresSSL(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._ARSRequiresSSL;
        this._ARSRequiresSSL = bl;
        this._postSet(14, bl2, bl);
    }

    public boolean isARSRequiresTwoWaySSL() {
        return this._ARSRequiresTwoWaySSL;
    }

    public boolean isARSRequiresTwoWaySSLSet() {
        return this._isSet(15);
    }

    public void setARSRequiresTwoWaySSL(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._ARSRequiresTwoWaySSL;
        this._ARSRequiresTwoWaySSL = bl;
        this._postSet(15, bl2, bl);
    }

    public String getAssertionStoreClassName() {
        return this._AssertionStoreClassName;
    }

    public boolean isAssertionStoreClassNameSet() {
        return this._isSet(16);
    }

    public void setAssertionStoreClassName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._AssertionStoreClassName;
        this._AssertionStoreClassName = string;
        this._postSet(16, string2, string);
    }

    public Properties getAssertionStoreProperties() {
        return this._AssertionStoreProperties;
    }

    public String getAssertionStorePropertiesAsString() {
        return StringHelper.objectToString((Object)this.getAssertionStoreProperties());
    }

    public boolean isAssertionStorePropertiesSet() {
        return this._isSet(17);
    }

    public void setAssertionStorePropertiesAsString(String string) {
        try {
            this.setAssertionStoreProperties(StringHelper.stringToProperties((String)string));
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public void setAssertionStoreProperties(Properties properties) throws InvalidAttributeValueException {
        Properties properties2 = this._AssertionStoreProperties;
        this._AssertionStoreProperties = properties;
        this._postSet(17, properties2, properties);
    }

    public String getSigningKeyAlias() {
        return this._SigningKeyAlias;
    }

    public boolean isSigningKeyAliasSet() {
        return this._isSet(18);
    }

    public void setSigningKeyAlias(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._SigningKeyAlias;
        this._SigningKeyAlias = string;
        this._postSet(18, string2, string);
    }

    public String getSigningKeyPassPhrase() {
        byte[] byArray = this.getSigningKeyPassPhraseEncrypted();
        return byArray == null ? null : this._decrypt("SigningKeyPassPhrase", byArray);
    }

    public boolean isSigningKeyPassPhraseSet() {
        return this.isSigningKeyPassPhraseEncryptedSet();
    }

    public void setSigningKeyPassPhrase(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setSigningKeyPassPhraseEncrypted(string == null ? null : this._encrypt("SigningKeyPassPhrase", string));
    }

    public byte[] getSigningKeyPassPhraseEncrypted() {
        return this._getHelper()._cloneArray(this._SigningKeyPassPhraseEncrypted);
    }

    public String getSigningKeyPassPhraseEncryptedAsString() {
        byte[] byArray = this.getSigningKeyPassPhraseEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isSigningKeyPassPhraseEncryptedSet() {
        return this._isSet(20);
    }

    public void setSigningKeyPassPhraseEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setSigningKeyPassPhraseEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public boolean isDestinationSiteEnabled() {
        return this._DestinationSiteEnabled;
    }

    public boolean isDestinationSiteEnabledSet() {
        return this._isSet(21);
    }

    public void setDestinationSiteEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._DestinationSiteEnabled;
        this._DestinationSiteEnabled = bl;
        this._postSet(21, bl2, bl);
    }

    public String[] getAssertionConsumerURIs() {
        return this._AssertionConsumerURIs;
    }

    public boolean isAssertionConsumerURIsSet() {
        return this._isSet(22);
    }

    public void setAssertionConsumerURIs(String[] stringArray) throws InvalidAttributeValueException {
        stringArray = stringArray == null ? new String[]{} : stringArray;
        stringArray = this._getHelper()._trimElements(stringArray);
        String[] stringArray2 = this._AssertionConsumerURIs;
        this._AssertionConsumerURIs = stringArray;
        this._postSet(22, stringArray2, stringArray);
    }

    public boolean isACSRequiresSSL() {
        return this._ACSRequiresSSL;
    }

    public boolean isACSRequiresSSLSet() {
        return this._isSet(23);
    }

    public void setACSRequiresSSL(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._ACSRequiresSSL;
        this._ACSRequiresSSL = bl;
        this._postSet(23, bl2, bl);
    }

    public boolean isPOSTRecipientCheckEnabled() {
        return this._POSTRecipientCheckEnabled;
    }

    public boolean isPOSTRecipientCheckEnabledSet() {
        return this._isSet(24);
    }

    public void setPOSTRecipientCheckEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._POSTRecipientCheckEnabled;
        this._POSTRecipientCheckEnabled = bl;
        this._postSet(24, bl2, bl);
    }

    public boolean isPOSTOneUseCheckEnabled() {
        return this._POSTOneUseCheckEnabled;
    }

    public boolean isPOSTOneUseCheckEnabledSet() {
        return this._isSet(25);
    }

    public void setPOSTOneUseCheckEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._POSTOneUseCheckEnabled;
        this._POSTOneUseCheckEnabled = bl;
        this._postSet(25, bl2, bl);
    }

    public String getUsedAssertionCacheClassName() {
        return this._UsedAssertionCacheClassName;
    }

    public boolean isUsedAssertionCacheClassNameSet() {
        return this._isSet(26);
    }

    public void setUsedAssertionCacheClassName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._UsedAssertionCacheClassName;
        this._UsedAssertionCacheClassName = string;
        this._postSet(26, string2, string);
    }

    public Properties getUsedAssertionCacheProperties() {
        return this._UsedAssertionCacheProperties;
    }

    public String getUsedAssertionCachePropertiesAsString() {
        return StringHelper.objectToString((Object)this.getUsedAssertionCacheProperties());
    }

    public boolean isUsedAssertionCachePropertiesSet() {
        return this._isSet(27);
    }

    public void setUsedAssertionCachePropertiesAsString(String string) {
        try {
            this.setUsedAssertionCacheProperties(StringHelper.stringToProperties((String)string));
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public void setUsedAssertionCacheProperties(Properties properties) throws InvalidAttributeValueException {
        Properties properties2 = this._UsedAssertionCacheProperties;
        this._UsedAssertionCacheProperties = properties;
        this._postSet(27, properties2, properties);
    }

    public String getSSLClientIdentityAlias() {
        return this._SSLClientIdentityAlias;
    }

    public boolean isSSLClientIdentityAliasSet() {
        return this._isSet(28);
    }

    public void setSSLClientIdentityAlias(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._SSLClientIdentityAlias;
        this._SSLClientIdentityAlias = string;
        this._postSet(28, string2, string);
    }

    public String getSSLClientIdentityPassPhrase() {
        byte[] byArray = this.getSSLClientIdentityPassPhraseEncrypted();
        return byArray == null ? null : this._decrypt("SSLClientIdentityPassPhrase", byArray);
    }

    public boolean isSSLClientIdentityPassPhraseSet() {
        return this.isSSLClientIdentityPassPhraseEncryptedSet();
    }

    public void setSSLClientIdentityPassPhrase(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setSSLClientIdentityPassPhraseEncrypted(string == null ? null : this._encrypt("SSLClientIdentityPassPhrase", string));
    }

    public byte[] getSSLClientIdentityPassPhraseEncrypted() {
        return this._getHelper()._cloneArray(this._SSLClientIdentityPassPhraseEncrypted);
    }

    public String getSSLClientIdentityPassPhraseEncryptedAsString() {
        byte[] byArray = this.getSSLClientIdentityPassPhraseEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isSSLClientIdentityPassPhraseEncryptedSet() {
        return this._isSet(30);
    }

    public void setSSLClientIdentityPassPhraseEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setSSLClientIdentityPassPhraseEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
        ServerLegalHelper.validateFederationServices(this);
    }

    public void setSSLClientIdentityPassPhraseEncrypted(byte[] byArray) {
        byte[] byArray2 = this._SSLClientIdentityPassPhraseEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: SSLClientIdentityPassPhraseEncrypted of FederationServicesMBean");
        }
        this._getHelper()._clearArray(this._SSLClientIdentityPassPhraseEncrypted);
        this._SSLClientIdentityPassPhraseEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(30, byArray2, byArray);
    }

    public void setSigningKeyPassPhraseEncrypted(byte[] byArray) {
        byte[] byArray2 = this._SigningKeyPassPhraseEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: SigningKeyPassPhraseEncrypted of FederationServicesMBean");
        }
        this._getHelper()._clearArray(this._SigningKeyPassPhraseEncrypted);
        this._SigningKeyPassPhraseEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(20, byArray2, byArray);
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
            if (n == 29) {
                this._markSet(30, false);
            }
            if (n == 19) {
                this._markSet(20, false);
            }
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 22;
        }
        try {
            switch (n) {
                case 22: {
                    this._AssertionConsumerURIs = StringHelper.split((String)"/samlacs/acs");
                    if (bl) break;
                }
                case 13: {
                    this._AssertionRetrievalURIs = StringHelper.split((String)"/samlars/ars");
                    if (bl) break;
                }
                case 16: {
                    this._AssertionStoreClassName = null;
                    if (bl) break;
                }
                case 17: {
                    this._AssertionStoreProperties = null;
                    if (bl) break;
                }
                case 11: {
                    this._IntersiteTransferURIs = new String[]{"/samlits_ba/its", "/samlits_ba/its/post", "/samlits_ba/its/artifact", "/samlits_cc/its", "/samlits_cc/its/post", "/samlits_cc/its/artifact"};
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 28: {
                    this._SSLClientIdentityAlias = null;
                    if (bl) break;
                }
                case 29: {
                    this._SSLClientIdentityPassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 30: {
                    this._SSLClientIdentityPassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 18: {
                    this._SigningKeyAlias = null;
                    if (bl) break;
                }
                case 19: {
                    this._SigningKeyPassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 20: {
                    this._SigningKeyPassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 10: {
                    this._SourceIdBase64 = null;
                    if (bl) break;
                }
                case 9: {
                    this._SourceIdHex = null;
                    if (bl) break;
                }
                case 8: {
                    this._SourceSiteURL = null;
                    if (bl) break;
                }
                case 26: {
                    this._UsedAssertionCacheClassName = null;
                    if (bl) break;
                }
                case 27: {
                    this._UsedAssertionCacheProperties = null;
                    if (bl) break;
                }
                case 23: {
                    this._ACSRequiresSSL = true;
                    if (bl) break;
                }
                case 14: {
                    this._ARSRequiresSSL = true;
                    if (bl) break;
                }
                case 15: {
                    this._ARSRequiresTwoWaySSL = false;
                    if (bl) break;
                }
                case 21: {
                    this._DestinationSiteEnabled = false;
                    if (bl) break;
                }
                case 12: {
                    this._ITSRequiresSSL = true;
                    if (bl) break;
                }
                case 25: {
                    this._POSTOneUseCheckEnabled = true;
                    if (bl) break;
                }
                case 24: {
                    this._POSTRecipientCheckEnabled = true;
                    if (bl) break;
                }
                case 7: {
                    this._SourceSiteEnabled = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "FederationServices";
    }

    public void putValue(String string, Object object) {
        if (string.equals("ACSRequiresSSL")) {
            boolean bl = this._ACSRequiresSSL;
            this._ACSRequiresSSL = (Boolean)object;
            this._postSet(23, bl, this._ACSRequiresSSL);
            return;
        }
        if (string.equals("ARSRequiresSSL")) {
            boolean bl = this._ARSRequiresSSL;
            this._ARSRequiresSSL = (Boolean)object;
            this._postSet(14, bl, this._ARSRequiresSSL);
            return;
        }
        if (string.equals("ARSRequiresTwoWaySSL")) {
            boolean bl = this._ARSRequiresTwoWaySSL;
            this._ARSRequiresTwoWaySSL = (Boolean)object;
            this._postSet(15, bl, this._ARSRequiresTwoWaySSL);
            return;
        }
        if (string.equals("AssertionConsumerURIs")) {
            String[] stringArray = this._AssertionConsumerURIs;
            this._AssertionConsumerURIs = (String[])object;
            this._postSet(22, stringArray, this._AssertionConsumerURIs);
            return;
        }
        if (string.equals("AssertionRetrievalURIs")) {
            String[] stringArray = this._AssertionRetrievalURIs;
            this._AssertionRetrievalURIs = (String[])object;
            this._postSet(13, stringArray, this._AssertionRetrievalURIs);
            return;
        }
        if (string.equals("AssertionStoreClassName")) {
            String string2 = this._AssertionStoreClassName;
            this._AssertionStoreClassName = (String)object;
            this._postSet(16, string2, this._AssertionStoreClassName);
            return;
        }
        if (string.equals("AssertionStoreProperties")) {
            Properties properties = this._AssertionStoreProperties;
            this._AssertionStoreProperties = (Properties)object;
            this._postSet(17, properties, this._AssertionStoreProperties);
            return;
        }
        if (string.equals("DestinationSiteEnabled")) {
            boolean bl = this._DestinationSiteEnabled;
            this._DestinationSiteEnabled = (Boolean)object;
            this._postSet(21, bl, this._DestinationSiteEnabled);
            return;
        }
        if (string.equals("ITSRequiresSSL")) {
            boolean bl = this._ITSRequiresSSL;
            this._ITSRequiresSSL = (Boolean)object;
            this._postSet(12, bl, this._ITSRequiresSSL);
            return;
        }
        if (string.equals("IntersiteTransferURIs")) {
            String[] stringArray = this._IntersiteTransferURIs;
            this._IntersiteTransferURIs = (String[])object;
            this._postSet(11, stringArray, this._IntersiteTransferURIs);
            return;
        }
        if (string.equals("Name")) {
            String string3 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string3, this._Name);
            return;
        }
        if (string.equals("POSTOneUseCheckEnabled")) {
            boolean bl = this._POSTOneUseCheckEnabled;
            this._POSTOneUseCheckEnabled = (Boolean)object;
            this._postSet(25, bl, this._POSTOneUseCheckEnabled);
            return;
        }
        if (string.equals("POSTRecipientCheckEnabled")) {
            boolean bl = this._POSTRecipientCheckEnabled;
            this._POSTRecipientCheckEnabled = (Boolean)object;
            this._postSet(24, bl, this._POSTRecipientCheckEnabled);
            return;
        }
        if (string.equals("SSLClientIdentityAlias")) {
            String string4 = this._SSLClientIdentityAlias;
            this._SSLClientIdentityAlias = (String)object;
            this._postSet(28, string4, this._SSLClientIdentityAlias);
            return;
        }
        if (string.equals("SSLClientIdentityPassPhrase")) {
            String string5 = this._SSLClientIdentityPassPhrase;
            this._SSLClientIdentityPassPhrase = (String)object;
            this._postSet(29, string5, this._SSLClientIdentityPassPhrase);
            return;
        }
        if (string.equals("SSLClientIdentityPassPhraseEncrypted")) {
            byte[] byArray = this._SSLClientIdentityPassPhraseEncrypted;
            this._SSLClientIdentityPassPhraseEncrypted = (byte[])object;
            this._postSet(30, byArray, this._SSLClientIdentityPassPhraseEncrypted);
            return;
        }
        if (string.equals("SigningKeyAlias")) {
            String string6 = this._SigningKeyAlias;
            this._SigningKeyAlias = (String)object;
            this._postSet(18, string6, this._SigningKeyAlias);
            return;
        }
        if (string.equals("SigningKeyPassPhrase")) {
            String string7 = this._SigningKeyPassPhrase;
            this._SigningKeyPassPhrase = (String)object;
            this._postSet(19, string7, this._SigningKeyPassPhrase);
            return;
        }
        if (string.equals("SigningKeyPassPhraseEncrypted")) {
            byte[] byArray = this._SigningKeyPassPhraseEncrypted;
            this._SigningKeyPassPhraseEncrypted = (byte[])object;
            this._postSet(20, byArray, this._SigningKeyPassPhraseEncrypted);
            return;
        }
        if (string.equals("SourceIdBase64")) {
            String string8 = this._SourceIdBase64;
            this._SourceIdBase64 = (String)object;
            this._postSet(10, string8, this._SourceIdBase64);
            return;
        }
        if (string.equals("SourceIdHex")) {
            String string9 = this._SourceIdHex;
            this._SourceIdHex = (String)object;
            this._postSet(9, string9, this._SourceIdHex);
            return;
        }
        if (string.equals("SourceSiteEnabled")) {
            boolean bl = this._SourceSiteEnabled;
            this._SourceSiteEnabled = (Boolean)object;
            this._postSet(7, bl, this._SourceSiteEnabled);
            return;
        }
        if (string.equals("SourceSiteURL")) {
            String string10 = this._SourceSiteURL;
            this._SourceSiteURL = (String)object;
            this._postSet(8, string10, this._SourceSiteURL);
            return;
        }
        if (string.equals("UsedAssertionCacheClassName")) {
            String string11 = this._UsedAssertionCacheClassName;
            this._UsedAssertionCacheClassName = (String)object;
            this._postSet(26, string11, this._UsedAssertionCacheClassName);
            return;
        }
        if (string.equals("UsedAssertionCacheProperties")) {
            Properties properties = this._UsedAssertionCacheProperties;
            this._UsedAssertionCacheProperties = (Properties)object;
            this._postSet(27, properties, this._UsedAssertionCacheProperties);
            return;
        }
        if (string.equals("customizer")) {
            FederationServices federationServices = this._customizer;
            this._customizer = (FederationServices)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("ACSRequiresSSL")) {
            return new Boolean(this._ACSRequiresSSL);
        }
        if (string.equals("ARSRequiresSSL")) {
            return new Boolean(this._ARSRequiresSSL);
        }
        if (string.equals("ARSRequiresTwoWaySSL")) {
            return new Boolean(this._ARSRequiresTwoWaySSL);
        }
        if (string.equals("AssertionConsumerURIs")) {
            return this._AssertionConsumerURIs;
        }
        if (string.equals("AssertionRetrievalURIs")) {
            return this._AssertionRetrievalURIs;
        }
        if (string.equals("AssertionStoreClassName")) {
            return this._AssertionStoreClassName;
        }
        if (string.equals("AssertionStoreProperties")) {
            return this._AssertionStoreProperties;
        }
        if (string.equals("DestinationSiteEnabled")) {
            return new Boolean(this._DestinationSiteEnabled);
        }
        if (string.equals("ITSRequiresSSL")) {
            return new Boolean(this._ITSRequiresSSL);
        }
        if (string.equals("IntersiteTransferURIs")) {
            return this._IntersiteTransferURIs;
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("POSTOneUseCheckEnabled")) {
            return new Boolean(this._POSTOneUseCheckEnabled);
        }
        if (string.equals("POSTRecipientCheckEnabled")) {
            return new Boolean(this._POSTRecipientCheckEnabled);
        }
        if (string.equals("SSLClientIdentityAlias")) {
            return this._SSLClientIdentityAlias;
        }
        if (string.equals("SSLClientIdentityPassPhrase")) {
            return this._SSLClientIdentityPassPhrase;
        }
        if (string.equals("SSLClientIdentityPassPhraseEncrypted")) {
            return this._SSLClientIdentityPassPhraseEncrypted;
        }
        if (string.equals("SigningKeyAlias")) {
            return this._SigningKeyAlias;
        }
        if (string.equals("SigningKeyPassPhrase")) {
            return this._SigningKeyPassPhrase;
        }
        if (string.equals("SigningKeyPassPhraseEncrypted")) {
            return this._SigningKeyPassPhraseEncrypted;
        }
        if (string.equals("SourceIdBase64")) {
            return this._SourceIdBase64;
        }
        if (string.equals("SourceIdHex")) {
            return this._SourceIdHex;
        }
        if (string.equals("SourceSiteEnabled")) {
            return new Boolean(this._SourceSiteEnabled);
        }
        if (string.equals("SourceSiteURL")) {
            return this._SourceSiteURL;
        }
        if (string.equals("UsedAssertionCacheClassName")) {
            return this._UsedAssertionCacheClassName;
        }
        if (string.equals("UsedAssertionCacheProperties")) {
            return this._UsedAssertionCacheProperties;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 22: {
                    if (string.equals("assertion-consumer-uri")) {
                        return 22;
                    }
                    if (!string.equals("intersite-transfer-uri")) break;
                    return 11;
                }
                case 23: {
                    if (string.equals("assertion-retrieval-uri")) {
                        return 13;
                    }
                    if (string.equals("signing-key-pass-phrase")) {
                        return 19;
                    }
                    if (!string.equals("ars-requires-two-wayssl")) break;
                    return 15;
                }
                case 26: {
                    if (string.equals("assertion-store-class-name")) {
                        return 16;
                    }
                    if (string.equals("assertion-store-properties")) {
                        return 17;
                    }
                    if (!string.equals("post-one-use-check-enabled")) break;
                    return 25;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 25: {
                    if (!string.equals("ssl-client-identity-alias")) break;
                    return 28;
                }
                case 31: {
                    if (string.equals("ssl-client-identity-pass-phrase")) {
                        return 29;
                    }
                    if (string.equals("used-assertion-cache-class-name")) {
                        return 26;
                    }
                    if (!string.equals("used-assertion-cache-properties")) break;
                    return 27;
                }
                case 41: {
                    if (!string.equals("ssl-client-identity-pass-phrase-encrypted")) break;
                    return 30;
                }
                case 17: {
                    if (!string.equals("signing-key-alias")) break;
                    return 18;
                }
                case 33: {
                    if (!string.equals("signing-key-pass-phrase-encrypted")) break;
                    return 20;
                }
                case 16: {
                    if (!string.equals("source-id-base64")) break;
                    return 10;
                }
                case 13: {
                    if (!string.equals("source-id-hex")) break;
                    return 9;
                }
                case 15: {
                    if (string.equals("source-site-url")) {
                        return 8;
                    }
                    if (string.equals("acs-requiresssl")) {
                        return 23;
                    }
                    if (string.equals("ars-requiresssl")) {
                        return 14;
                    }
                    if (!string.equals("its-requiresssl")) break;
                    return 12;
                }
                case 24: {
                    if (!string.equals("destination-site-enabled")) break;
                    return 21;
                }
                case 28: {
                    if (!string.equals("post-recipient-check-enabled")) break;
                    return 24;
                }
                case 19: {
                    if (!string.equals("source-site-enabled")) break;
                    return 7;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 22: {
                    return "assertion-consumer-uri";
                }
                case 13: {
                    return "assertion-retrieval-uri";
                }
                case 16: {
                    return "assertion-store-class-name";
                }
                case 17: {
                    return "assertion-store-properties";
                }
                case 11: {
                    return "intersite-transfer-uri";
                }
                case 2: {
                    return "name";
                }
                case 28: {
                    return "ssl-client-identity-alias";
                }
                case 29: {
                    return "ssl-client-identity-pass-phrase";
                }
                case 30: {
                    return "ssl-client-identity-pass-phrase-encrypted";
                }
                case 18: {
                    return "signing-key-alias";
                }
                case 19: {
                    return "signing-key-pass-phrase";
                }
                case 20: {
                    return "signing-key-pass-phrase-encrypted";
                }
                case 10: {
                    return "source-id-base64";
                }
                case 9: {
                    return "source-id-hex";
                }
                case 8: {
                    return "source-site-url";
                }
                case 26: {
                    return "used-assertion-cache-class-name";
                }
                case 27: {
                    return "used-assertion-cache-properties";
                }
                case 23: {
                    return "acs-requiresssl";
                }
                case 14: {
                    return "ars-requiresssl";
                }
                case 15: {
                    return "ars-requires-two-wayssl";
                }
                case 21: {
                    return "destination-site-enabled";
                }
                case 12: {
                    return "its-requiresssl";
                }
                case 25: {
                    return "post-one-use-check-enabled";
                }
                case 24: {
                    return "post-recipient-check-enabled";
                }
                case 7: {
                    return "source-site-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 22: {
                    return true;
                }
                case 13: {
                    return true;
                }
                case 11: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private FederationServicesMBeanImpl bean;

        protected Helper(FederationServicesMBeanImpl federationServicesMBeanImpl) {
            super(federationServicesMBeanImpl);
            this.bean = federationServicesMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 22: {
                    return "AssertionConsumerURIs";
                }
                case 13: {
                    return "AssertionRetrievalURIs";
                }
                case 16: {
                    return "AssertionStoreClassName";
                }
                case 17: {
                    return "AssertionStoreProperties";
                }
                case 11: {
                    return "IntersiteTransferURIs";
                }
                case 2: {
                    return "Name";
                }
                case 28: {
                    return "SSLClientIdentityAlias";
                }
                case 29: {
                    return "SSLClientIdentityPassPhrase";
                }
                case 30: {
                    return "SSLClientIdentityPassPhraseEncrypted";
                }
                case 18: {
                    return "SigningKeyAlias";
                }
                case 19: {
                    return "SigningKeyPassPhrase";
                }
                case 20: {
                    return "SigningKeyPassPhraseEncrypted";
                }
                case 10: {
                    return "SourceIdBase64";
                }
                case 9: {
                    return "SourceIdHex";
                }
                case 8: {
                    return "SourceSiteURL";
                }
                case 26: {
                    return "UsedAssertionCacheClassName";
                }
                case 27: {
                    return "UsedAssertionCacheProperties";
                }
                case 23: {
                    return "ACSRequiresSSL";
                }
                case 14: {
                    return "ARSRequiresSSL";
                }
                case 15: {
                    return "ARSRequiresTwoWaySSL";
                }
                case 21: {
                    return "DestinationSiteEnabled";
                }
                case 12: {
                    return "ITSRequiresSSL";
                }
                case 25: {
                    return "POSTOneUseCheckEnabled";
                }
                case 24: {
                    return "POSTRecipientCheckEnabled";
                }
                case 7: {
                    return "SourceSiteEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("AssertionConsumerURIs")) {
                return 22;
            }
            if (string.equals("AssertionRetrievalURIs")) {
                return 13;
            }
            if (string.equals("AssertionStoreClassName")) {
                return 16;
            }
            if (string.equals("AssertionStoreProperties")) {
                return 17;
            }
            if (string.equals("IntersiteTransferURIs")) {
                return 11;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("SSLClientIdentityAlias")) {
                return 28;
            }
            if (string.equals("SSLClientIdentityPassPhrase")) {
                return 29;
            }
            if (string.equals("SSLClientIdentityPassPhraseEncrypted")) {
                return 30;
            }
            if (string.equals("SigningKeyAlias")) {
                return 18;
            }
            if (string.equals("SigningKeyPassPhrase")) {
                return 19;
            }
            if (string.equals("SigningKeyPassPhraseEncrypted")) {
                return 20;
            }
            if (string.equals("SourceIdBase64")) {
                return 10;
            }
            if (string.equals("SourceIdHex")) {
                return 9;
            }
            if (string.equals("SourceSiteURL")) {
                return 8;
            }
            if (string.equals("UsedAssertionCacheClassName")) {
                return 26;
            }
            if (string.equals("UsedAssertionCacheProperties")) {
                return 27;
            }
            if (string.equals("ACSRequiresSSL")) {
                return 23;
            }
            if (string.equals("ARSRequiresSSL")) {
                return 14;
            }
            if (string.equals("ARSRequiresTwoWaySSL")) {
                return 15;
            }
            if (string.equals("DestinationSiteEnabled")) {
                return 21;
            }
            if (string.equals("ITSRequiresSSL")) {
                return 12;
            }
            if (string.equals("POSTOneUseCheckEnabled")) {
                return 25;
            }
            if (string.equals("POSTRecipientCheckEnabled")) {
                return 24;
            }
            if (string.equals("SourceSiteEnabled")) {
                return 7;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isAssertionConsumerURIsSet()) {
                    stringBuffer.append("AssertionConsumerURIs");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getAssertionConsumerURIs())));
                }
                if (this.bean.isAssertionRetrievalURIsSet()) {
                    stringBuffer.append("AssertionRetrievalURIs");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getAssertionRetrievalURIs())));
                }
                if (this.bean.isAssertionStoreClassNameSet()) {
                    stringBuffer.append("AssertionStoreClassName");
                    stringBuffer.append(String.valueOf(this.bean.getAssertionStoreClassName()));
                }
                if (this.bean.isAssertionStorePropertiesSet()) {
                    stringBuffer.append("AssertionStoreProperties");
                    stringBuffer.append(String.valueOf(this.bean.getAssertionStoreProperties()));
                }
                if (this.bean.isIntersiteTransferURIsSet()) {
                    stringBuffer.append("IntersiteTransferURIs");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getIntersiteTransferURIs())));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isSSLClientIdentityAliasSet()) {
                    stringBuffer.append("SSLClientIdentityAlias");
                    stringBuffer.append(String.valueOf(this.bean.getSSLClientIdentityAlias()));
                }
                if (this.bean.isSSLClientIdentityPassPhraseSet()) {
                    stringBuffer.append("SSLClientIdentityPassPhrase");
                    stringBuffer.append(String.valueOf(this.bean.getSSLClientIdentityPassPhrase()));
                }
                if (this.bean.isSSLClientIdentityPassPhraseEncryptedSet()) {
                    stringBuffer.append("SSLClientIdentityPassPhraseEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getSSLClientIdentityPassPhraseEncrypted())));
                }
                if (this.bean.isSigningKeyAliasSet()) {
                    stringBuffer.append("SigningKeyAlias");
                    stringBuffer.append(String.valueOf(this.bean.getSigningKeyAlias()));
                }
                if (this.bean.isSigningKeyPassPhraseSet()) {
                    stringBuffer.append("SigningKeyPassPhrase");
                    stringBuffer.append(String.valueOf(this.bean.getSigningKeyPassPhrase()));
                }
                if (this.bean.isSigningKeyPassPhraseEncryptedSet()) {
                    stringBuffer.append("SigningKeyPassPhraseEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getSigningKeyPassPhraseEncrypted())));
                }
                if (this.bean.isSourceIdBase64Set()) {
                    stringBuffer.append("SourceIdBase64");
                    stringBuffer.append(String.valueOf(this.bean.getSourceIdBase64()));
                }
                if (this.bean.isSourceIdHexSet()) {
                    stringBuffer.append("SourceIdHex");
                    stringBuffer.append(String.valueOf(this.bean.getSourceIdHex()));
                }
                if (this.bean.isSourceSiteURLSet()) {
                    stringBuffer.append("SourceSiteURL");
                    stringBuffer.append(String.valueOf(this.bean.getSourceSiteURL()));
                }
                if (this.bean.isUsedAssertionCacheClassNameSet()) {
                    stringBuffer.append("UsedAssertionCacheClassName");
                    stringBuffer.append(String.valueOf(this.bean.getUsedAssertionCacheClassName()));
                }
                if (this.bean.isUsedAssertionCachePropertiesSet()) {
                    stringBuffer.append("UsedAssertionCacheProperties");
                    stringBuffer.append(String.valueOf(this.bean.getUsedAssertionCacheProperties()));
                }
                if (this.bean.isACSRequiresSSLSet()) {
                    stringBuffer.append("ACSRequiresSSL");
                    stringBuffer.append(String.valueOf(this.bean.isACSRequiresSSL()));
                }
                if (this.bean.isARSRequiresSSLSet()) {
                    stringBuffer.append("ARSRequiresSSL");
                    stringBuffer.append(String.valueOf(this.bean.isARSRequiresSSL()));
                }
                if (this.bean.isARSRequiresTwoWaySSLSet()) {
                    stringBuffer.append("ARSRequiresTwoWaySSL");
                    stringBuffer.append(String.valueOf(this.bean.isARSRequiresTwoWaySSL()));
                }
                if (this.bean.isDestinationSiteEnabledSet()) {
                    stringBuffer.append("DestinationSiteEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isDestinationSiteEnabled()));
                }
                if (this.bean.isITSRequiresSSLSet()) {
                    stringBuffer.append("ITSRequiresSSL");
                    stringBuffer.append(String.valueOf(this.bean.isITSRequiresSSL()));
                }
                if (this.bean.isPOSTOneUseCheckEnabledSet()) {
                    stringBuffer.append("POSTOneUseCheckEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isPOSTOneUseCheckEnabled()));
                }
                if (this.bean.isPOSTRecipientCheckEnabledSet()) {
                    stringBuffer.append("POSTRecipientCheckEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isPOSTRecipientCheckEnabled()));
                }
                if (this.bean.isSourceSiteEnabledSet()) {
                    stringBuffer.append("SourceSiteEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isSourceSiteEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                FederationServicesMBeanImpl federationServicesMBeanImpl = (FederationServicesMBeanImpl)abstractDescriptorBean;
                this.computeDiff("AssertionConsumerURIs", this.bean.getAssertionConsumerURIs(), federationServicesMBeanImpl.getAssertionConsumerURIs(), false);
                this.computeDiff("AssertionRetrievalURIs", this.bean.getAssertionRetrievalURIs(), federationServicesMBeanImpl.getAssertionRetrievalURIs(), false);
                this.computeDiff("AssertionStoreClassName", this.bean.getAssertionStoreClassName(), federationServicesMBeanImpl.getAssertionStoreClassName(), false);
                this.computeDiff("AssertionStoreProperties", this.bean.getAssertionStoreProperties(), federationServicesMBeanImpl.getAssertionStoreProperties(), false);
                this.computeDiff("IntersiteTransferURIs", this.bean.getIntersiteTransferURIs(), federationServicesMBeanImpl.getIntersiteTransferURIs(), false);
                this.computeDiff("Name", this.bean.getName(), federationServicesMBeanImpl.getName(), false);
                this.computeDiff("SSLClientIdentityAlias", this.bean.getSSLClientIdentityAlias(), federationServicesMBeanImpl.getSSLClientIdentityAlias(), true);
                this.computeDiff("SSLClientIdentityPassPhraseEncrypted", this.bean.getSSLClientIdentityPassPhraseEncrypted(), federationServicesMBeanImpl.getSSLClientIdentityPassPhraseEncrypted(), true);
                this.computeDiff("SigningKeyAlias", this.bean.getSigningKeyAlias(), federationServicesMBeanImpl.getSigningKeyAlias(), true);
                this.computeDiff("SigningKeyPassPhraseEncrypted", this.bean.getSigningKeyPassPhraseEncrypted(), federationServicesMBeanImpl.getSigningKeyPassPhraseEncrypted(), true);
                this.computeDiff("SourceSiteURL", this.bean.getSourceSiteURL(), federationServicesMBeanImpl.getSourceSiteURL(), false);
                this.computeDiff("UsedAssertionCacheClassName", this.bean.getUsedAssertionCacheClassName(), federationServicesMBeanImpl.getUsedAssertionCacheClassName(), false);
                this.computeDiff("UsedAssertionCacheProperties", this.bean.getUsedAssertionCacheProperties(), federationServicesMBeanImpl.getUsedAssertionCacheProperties(), false);
                this.computeDiff("ACSRequiresSSL", this.bean.isACSRequiresSSL(), federationServicesMBeanImpl.isACSRequiresSSL(), true);
                this.computeDiff("ARSRequiresSSL", this.bean.isARSRequiresSSL(), federationServicesMBeanImpl.isARSRequiresSSL(), true);
                this.computeDiff("ARSRequiresTwoWaySSL", this.bean.isARSRequiresTwoWaySSL(), federationServicesMBeanImpl.isARSRequiresTwoWaySSL(), true);
                this.computeDiff("DestinationSiteEnabled", this.bean.isDestinationSiteEnabled(), federationServicesMBeanImpl.isDestinationSiteEnabled(), false);
                this.computeDiff("ITSRequiresSSL", this.bean.isITSRequiresSSL(), federationServicesMBeanImpl.isITSRequiresSSL(), true);
                this.computeDiff("POSTOneUseCheckEnabled", this.bean.isPOSTOneUseCheckEnabled(), federationServicesMBeanImpl.isPOSTOneUseCheckEnabled(), false);
                this.computeDiff("POSTRecipientCheckEnabled", this.bean.isPOSTRecipientCheckEnabled(), federationServicesMBeanImpl.isPOSTRecipientCheckEnabled(), false);
                this.computeDiff("SourceSiteEnabled", this.bean.isSourceSiteEnabled(), federationServicesMBeanImpl.isSourceSiteEnabled(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                FederationServicesMBeanImpl federationServicesMBeanImpl = (FederationServicesMBeanImpl)beanUpdateEvent.getSourceBean();
                FederationServicesMBeanImpl federationServicesMBeanImpl2 = (FederationServicesMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("AssertionConsumerURIs")) {
                    federationServicesMBeanImpl.setAssertionConsumerURIs(federationServicesMBeanImpl2.getAssertionConsumerURIs());
                    federationServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                } else if (string.equals("AssertionRetrievalURIs")) {
                    federationServicesMBeanImpl.setAssertionRetrievalURIs(federationServicesMBeanImpl2.getAssertionRetrievalURIs());
                    federationServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("AssertionStoreClassName")) {
                    federationServicesMBeanImpl.setAssertionStoreClassName(federationServicesMBeanImpl2.getAssertionStoreClassName());
                    federationServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else if (string.equals("AssertionStoreProperties")) {
                    federationServicesMBeanImpl.setAssertionStoreProperties(federationServicesMBeanImpl2.getAssertionStoreProperties() == null ? null : (Properties)federationServicesMBeanImpl2.getAssertionStoreProperties().clone());
                    federationServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else if (string.equals("IntersiteTransferURIs")) {
                    federationServicesMBeanImpl.setIntersiteTransferURIs(federationServicesMBeanImpl2.getIntersiteTransferURIs());
                    federationServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("Name")) {
                    federationServicesMBeanImpl.setName(federationServicesMBeanImpl2.getName());
                    federationServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (string.equals("SSLClientIdentityAlias")) {
                    federationServicesMBeanImpl.setSSLClientIdentityAlias(federationServicesMBeanImpl2.getSSLClientIdentityAlias());
                    federationServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 28);
                } else if (!string.equals("SSLClientIdentityPassPhrase")) {
                    if (string.equals("SSLClientIdentityPassPhraseEncrypted")) {
                        federationServicesMBeanImpl.setSSLClientIdentityPassPhraseEncrypted(federationServicesMBeanImpl2.getSSLClientIdentityPassPhraseEncrypted());
                        federationServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 30);
                    } else if (string.equals("SigningKeyAlias")) {
                        federationServicesMBeanImpl.setSigningKeyAlias(federationServicesMBeanImpl2.getSigningKeyAlias());
                        federationServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                    } else if (!string.equals("SigningKeyPassPhrase")) {
                        if (string.equals("SigningKeyPassPhraseEncrypted")) {
                            federationServicesMBeanImpl.setSigningKeyPassPhraseEncrypted(federationServicesMBeanImpl2.getSigningKeyPassPhraseEncrypted());
                            federationServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                        } else if (!string.equals("SourceIdBase64") && !string.equals("SourceIdHex")) {
                            if (string.equals("SourceSiteURL")) {
                                federationServicesMBeanImpl.setSourceSiteURL(federationServicesMBeanImpl2.getSourceSiteURL());
                                federationServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                            } else if (string.equals("UsedAssertionCacheClassName")) {
                                federationServicesMBeanImpl.setUsedAssertionCacheClassName(federationServicesMBeanImpl2.getUsedAssertionCacheClassName());
                                federationServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 26);
                            } else if (string.equals("UsedAssertionCacheProperties")) {
                                federationServicesMBeanImpl.setUsedAssertionCacheProperties(federationServicesMBeanImpl2.getUsedAssertionCacheProperties() == null ? null : (Properties)federationServicesMBeanImpl2.getUsedAssertionCacheProperties().clone());
                                federationServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 27);
                            } else if (string.equals("ACSRequiresSSL")) {
                                federationServicesMBeanImpl.setACSRequiresSSL(federationServicesMBeanImpl2.isACSRequiresSSL());
                                federationServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                            } else if (string.equals("ARSRequiresSSL")) {
                                federationServicesMBeanImpl.setARSRequiresSSL(federationServicesMBeanImpl2.isARSRequiresSSL());
                                federationServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                            } else if (string.equals("ARSRequiresTwoWaySSL")) {
                                federationServicesMBeanImpl.setARSRequiresTwoWaySSL(federationServicesMBeanImpl2.isARSRequiresTwoWaySSL());
                                federationServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                            } else if (string.equals("DestinationSiteEnabled")) {
                                federationServicesMBeanImpl.setDestinationSiteEnabled(federationServicesMBeanImpl2.isDestinationSiteEnabled());
                                federationServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                            } else if (string.equals("ITSRequiresSSL")) {
                                federationServicesMBeanImpl.setITSRequiresSSL(federationServicesMBeanImpl2.isITSRequiresSSL());
                                federationServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                            } else if (string.equals("POSTOneUseCheckEnabled")) {
                                federationServicesMBeanImpl.setPOSTOneUseCheckEnabled(federationServicesMBeanImpl2.isPOSTOneUseCheckEnabled());
                                federationServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                            } else if (string.equals("POSTRecipientCheckEnabled")) {
                                federationServicesMBeanImpl.setPOSTRecipientCheckEnabled(federationServicesMBeanImpl2.isPOSTRecipientCheckEnabled());
                                federationServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                            } else if (string.equals("SourceSiteEnabled")) {
                                federationServicesMBeanImpl.setSourceSiteEnabled(federationServicesMBeanImpl2.isSourceSiteEnabled());
                                federationServicesMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                            } else {
                                super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                            }
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                Object[] objectArray;
                FederationServicesMBeanImpl federationServicesMBeanImpl = (FederationServicesMBeanImpl)abstractDescriptorBean;
                super.finishCopy(federationServicesMBeanImpl, bl, list);
                if ((list == null || !list.contains("AssertionConsumerURIs")) && this.bean.isAssertionConsumerURIsSet()) {
                    objectArray = this.bean.getAssertionConsumerURIs();
                    federationServicesMBeanImpl.setAssertionConsumerURIs(objectArray == null ? null : (String[])objectArray.clone());
                }
                if ((list == null || !list.contains("AssertionRetrievalURIs")) && this.bean.isAssertionRetrievalURIsSet()) {
                    objectArray = this.bean.getAssertionRetrievalURIs();
                    federationServicesMBeanImpl.setAssertionRetrievalURIs(objectArray == null ? null : (String[])objectArray.clone());
                }
                if ((list == null || !list.contains("AssertionStoreClassName")) && this.bean.isAssertionStoreClassNameSet()) {
                    federationServicesMBeanImpl.setAssertionStoreClassName(this.bean.getAssertionStoreClassName());
                }
                if ((list == null || !list.contains("AssertionStoreProperties")) && this.bean.isAssertionStorePropertiesSet()) {
                    federationServicesMBeanImpl.setAssertionStoreProperties(this.bean.getAssertionStoreProperties());
                }
                if ((list == null || !list.contains("IntersiteTransferURIs")) && this.bean.isIntersiteTransferURIsSet()) {
                    objectArray = this.bean.getIntersiteTransferURIs();
                    federationServicesMBeanImpl.setIntersiteTransferURIs(objectArray == null ? null : (String[])objectArray.clone());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    federationServicesMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("SSLClientIdentityAlias")) && this.bean.isSSLClientIdentityAliasSet()) {
                    federationServicesMBeanImpl.setSSLClientIdentityAlias(this.bean.getSSLClientIdentityAlias());
                }
                if ((list == null || !list.contains("SSLClientIdentityPassPhraseEncrypted")) && this.bean.isSSLClientIdentityPassPhraseEncryptedSet()) {
                    objectArray = this.bean.getSSLClientIdentityPassPhraseEncrypted();
                    federationServicesMBeanImpl.setSSLClientIdentityPassPhraseEncrypted(objectArray == null ? null : (byte[])((byte[])objectArray).clone());
                }
                if ((list == null || !list.contains("SigningKeyAlias")) && this.bean.isSigningKeyAliasSet()) {
                    federationServicesMBeanImpl.setSigningKeyAlias(this.bean.getSigningKeyAlias());
                }
                if ((list == null || !list.contains("SigningKeyPassPhraseEncrypted")) && this.bean.isSigningKeyPassPhraseEncryptedSet()) {
                    objectArray = this.bean.getSigningKeyPassPhraseEncrypted();
                    federationServicesMBeanImpl.setSigningKeyPassPhraseEncrypted(objectArray == null ? null : (byte[])((byte[])objectArray).clone());
                }
                if ((list == null || !list.contains("SourceSiteURL")) && this.bean.isSourceSiteURLSet()) {
                    federationServicesMBeanImpl.setSourceSiteURL(this.bean.getSourceSiteURL());
                }
                if ((list == null || !list.contains("UsedAssertionCacheClassName")) && this.bean.isUsedAssertionCacheClassNameSet()) {
                    federationServicesMBeanImpl.setUsedAssertionCacheClassName(this.bean.getUsedAssertionCacheClassName());
                }
                if ((list == null || !list.contains("UsedAssertionCacheProperties")) && this.bean.isUsedAssertionCachePropertiesSet()) {
                    federationServicesMBeanImpl.setUsedAssertionCacheProperties(this.bean.getUsedAssertionCacheProperties());
                }
                if ((list == null || !list.contains("ACSRequiresSSL")) && this.bean.isACSRequiresSSLSet()) {
                    federationServicesMBeanImpl.setACSRequiresSSL(this.bean.isACSRequiresSSL());
                }
                if ((list == null || !list.contains("ARSRequiresSSL")) && this.bean.isARSRequiresSSLSet()) {
                    federationServicesMBeanImpl.setARSRequiresSSL(this.bean.isARSRequiresSSL());
                }
                if ((list == null || !list.contains("ARSRequiresTwoWaySSL")) && this.bean.isARSRequiresTwoWaySSLSet()) {
                    federationServicesMBeanImpl.setARSRequiresTwoWaySSL(this.bean.isARSRequiresTwoWaySSL());
                }
                if ((list == null || !list.contains("DestinationSiteEnabled")) && this.bean.isDestinationSiteEnabledSet()) {
                    federationServicesMBeanImpl.setDestinationSiteEnabled(this.bean.isDestinationSiteEnabled());
                }
                if ((list == null || !list.contains("ITSRequiresSSL")) && this.bean.isITSRequiresSSLSet()) {
                    federationServicesMBeanImpl.setITSRequiresSSL(this.bean.isITSRequiresSSL());
                }
                if ((list == null || !list.contains("POSTOneUseCheckEnabled")) && this.bean.isPOSTOneUseCheckEnabledSet()) {
                    federationServicesMBeanImpl.setPOSTOneUseCheckEnabled(this.bean.isPOSTOneUseCheckEnabled());
                }
                if ((list == null || !list.contains("POSTRecipientCheckEnabled")) && this.bean.isPOSTRecipientCheckEnabledSet()) {
                    federationServicesMBeanImpl.setPOSTRecipientCheckEnabled(this.bean.isPOSTRecipientCheckEnabled());
                }
                if ((list == null || !list.contains("SourceSiteEnabled")) && this.bean.isSourceSiteEnabledSet()) {
                    federationServicesMBeanImpl.setSourceSiteEnabled(this.bean.isSourceSiteEnabled());
                }
                return federationServicesMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

