/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BootstrapProperties;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.j2ee.descriptor.wl.ForeignConnectionFactoryBean;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.ForeignJMSConnectionFactoryMBean;
import weblogic.management.configuration.ForeignJNDIObjectMBeanImpl;
import weblogic.management.mbeans.custom.ForeignJMSConnectionFactory;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class ForeignJMSConnectionFactoryMBeanImpl
extends ForeignJNDIObjectMBeanImpl
implements ForeignJMSConnectionFactoryMBean,
Serializable {
    private String _ConnectionHealthChecking;
    private String _LocalJNDIName;
    private String _Name;
    private String _Password;
    private byte[] _PasswordEncrypted;
    private String _RemoteJNDIName;
    private String _Username;
    private ForeignJMSConnectionFactory _customizer;
    private static SchemaHelper2 _schemaHelper;

    public ForeignJMSConnectionFactoryMBeanImpl() {
        try {
            this._customizer = new ForeignJMSConnectionFactory(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public ForeignJMSConnectionFactoryMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new ForeignJMSConnectionFactory(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public void setLocalJNDIName(String string) {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonNull((String)"LocalJNDIName", (Object)string);
        String string2 = this.getLocalJNDIName();
        try {
            this._customizer.setLocalJNDIName(string);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new UndeclaredThrowableException(invalidAttributeValueException);
        }
        this._postSet(7, string2, string);
    }

    public String getLocalJNDIName() {
        return this._customizer.getLocalJNDIName();
    }

    public boolean isLocalJNDINameSet() {
        return this._isSet(7);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setRemoteJNDIName(String string) {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonNull((String)"RemoteJNDIName", (Object)string);
        String string2 = this.getRemoteJNDIName();
        try {
            this._customizer.setRemoteJNDIName(string);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new UndeclaredThrowableException(invalidAttributeValueException);
        }
        this._postSet(8, string2, string);
    }

    public String getRemoteJNDIName() {
        return this._customizer.getRemoteJNDIName();
    }

    public boolean isRemoteJNDINameSet() {
        return this._isSet(8);
    }

    public void setUsername(String string) {
        string = string == null ? null : string.trim();
        String string2 = this.getUsername();
        try {
            this._customizer.setUsername(string);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new UndeclaredThrowableException(invalidAttributeValueException);
        }
        this._postSet(9, string2, string);
    }

    public String getUsername() {
        return this._customizer.getUsername();
    }

    public boolean isUsernameSet() {
        return this._isSet(9);
    }

    public void setPassword(String string) {
        string = string == null ? null : string.trim();
        String string2 = this.getPassword();
        try {
            this._customizer.setPassword(string);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new UndeclaredThrowableException(invalidAttributeValueException);
        }
        this._postSet(10, string2, string);
    }

    public String getPassword() {
        return this._customizer.getPassword();
    }

    public boolean isPasswordSet() {
        return this._isSet(10);
    }

    public void setConnectionHealthChecking(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._ConnectionHealthChecking;
        this._ConnectionHealthChecking = string;
        this._postSet(11, string2, string);
    }

    public String getConnectionHealthChecking() {
        return this._ConnectionHealthChecking;
    }

    public boolean isConnectionHealthCheckingSet() {
        return this._isSet(11);
    }

    public byte[] getPasswordEncrypted() {
        return this._PasswordEncrypted;
    }

    public boolean isPasswordEncryptedSet() {
        return this._isSet(12);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void setPasswordEncrypted(byte[] byArray) {
        byte[] byArray2 = this._PasswordEncrypted;
        this._PasswordEncrypted = byArray;
        this._postSet(12, byArray2, byArray);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void useDelegates(ForeignConnectionFactoryBean foreignConnectionFactoryBean) {
        this._customizer.useDelegates(foreignConnectionFactoryBean);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
        LegalChecks.checkIsSet((String)"LocalJNDIName", (boolean)this.isLocalJNDINameSet());
        LegalChecks.checkIsSet((String)"RemoteJNDIName", (boolean)this.isRemoteJNDINameSet());
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 11;
        }
        try {
            switch (n) {
                case 11: {
                    this._ConnectionHealthChecking = null;
                    if (bl) break;
                }
                case 7: {
                    this._customizer.setLocalJNDIName(null);
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 10: {
                    this._customizer.setPassword(null);
                    if (bl) break;
                }
                case 12: {
                    this._PasswordEncrypted = new byte[0];
                    if (bl) break;
                }
                case 8: {
                    this._customizer.setRemoteJNDIName(null);
                    if (bl) break;
                }
                case 9: {
                    this._customizer.setUsername(null);
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "ForeignJMSConnectionFactory";
    }

    public void putValue(String string, Object object) {
        if (string.equals("ConnectionHealthChecking")) {
            String string2 = this._ConnectionHealthChecking;
            this._ConnectionHealthChecking = (String)object;
            this._postSet(11, string2, this._ConnectionHealthChecking);
            return;
        }
        if (string.equals("LocalJNDIName")) {
            String string3 = this._LocalJNDIName;
            this._LocalJNDIName = (String)object;
            this._postSet(7, string3, this._LocalJNDIName);
            return;
        }
        if (string.equals("Name")) {
            String string4 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string4, this._Name);
            return;
        }
        if (string.equals("Password")) {
            String string5 = this._Password;
            this._Password = (String)object;
            this._postSet(10, string5, this._Password);
            return;
        }
        if (string.equals("PasswordEncrypted")) {
            byte[] byArray = this._PasswordEncrypted;
            this._PasswordEncrypted = (byte[])object;
            this._postSet(12, byArray, this._PasswordEncrypted);
            return;
        }
        if (string.equals("RemoteJNDIName")) {
            String string6 = this._RemoteJNDIName;
            this._RemoteJNDIName = (String)object;
            this._postSet(8, string6, this._RemoteJNDIName);
            return;
        }
        if (string.equals("Username")) {
            String string7 = this._Username;
            this._Username = (String)object;
            this._postSet(9, string7, this._Username);
            return;
        }
        if (string.equals("customizer")) {
            ForeignJMSConnectionFactory foreignJMSConnectionFactory = this._customizer;
            this._customizer = (ForeignJMSConnectionFactory)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("ConnectionHealthChecking")) {
            return this._ConnectionHealthChecking;
        }
        if (string.equals("LocalJNDIName")) {
            return this._LocalJNDIName;
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("Password")) {
            return this._Password;
        }
        if (string.equals("PasswordEncrypted")) {
            return this._PasswordEncrypted;
        }
        if (string.equals("RemoteJNDIName")) {
            return this._RemoteJNDIName;
        }
        if (string.equals("Username")) {
            return this._Username;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ForeignJNDIObjectMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 26: {
                    if (!string.equals("connection-health-checking")) break;
                    return 11;
                }
                case 15: {
                    if (!string.equals("local-jndi-name")) break;
                    return 7;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 8: {
                    if (string.equals("password")) {
                        return 10;
                    }
                    if (!string.equals("username")) break;
                    return 9;
                }
                case 18: {
                    if (!string.equals("password-encrypted")) break;
                    return 12;
                }
                case 16: {
                    if (!string.equals("remote-jndi-name")) break;
                    return 8;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 11: {
                    return "connection-health-checking";
                }
                case 7: {
                    return "local-jndi-name";
                }
                case 2: {
                    return "name";
                }
                case 10: {
                    return "password";
                }
                case 12: {
                    return "password-encrypted";
                }
                case 8: {
                    return "remote-jndi-name";
                }
                case 9: {
                    return "username";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 12: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ForeignJNDIObjectMBeanImpl.Helper {
        private ForeignJMSConnectionFactoryMBeanImpl bean;

        protected Helper(ForeignJMSConnectionFactoryMBeanImpl foreignJMSConnectionFactoryMBeanImpl) {
            super(foreignJMSConnectionFactoryMBeanImpl);
            this.bean = foreignJMSConnectionFactoryMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 11: {
                    return "ConnectionHealthChecking";
                }
                case 7: {
                    return "LocalJNDIName";
                }
                case 2: {
                    return "Name";
                }
                case 10: {
                    return "Password";
                }
                case 12: {
                    return "PasswordEncrypted";
                }
                case 8: {
                    return "RemoteJNDIName";
                }
                case 9: {
                    return "Username";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("ConnectionHealthChecking")) {
                return 11;
            }
            if (string.equals("LocalJNDIName")) {
                return 7;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("Password")) {
                return 10;
            }
            if (string.equals("PasswordEncrypted")) {
                return 12;
            }
            if (string.equals("RemoteJNDIName")) {
                return 8;
            }
            if (string.equals("Username")) {
                return 9;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isConnectionHealthCheckingSet()) {
                    stringBuffer.append("ConnectionHealthChecking");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionHealthChecking()));
                }
                if (this.bean.isLocalJNDINameSet()) {
                    stringBuffer.append("LocalJNDIName");
                    stringBuffer.append(String.valueOf(this.bean.getLocalJNDIName()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isPasswordSet()) {
                    stringBuffer.append("Password");
                    stringBuffer.append(String.valueOf(this.bean.getPassword()));
                }
                if (this.bean.isPasswordEncryptedSet()) {
                    stringBuffer.append("PasswordEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getPasswordEncrypted())));
                }
                if (this.bean.isRemoteJNDINameSet()) {
                    stringBuffer.append("RemoteJNDIName");
                    stringBuffer.append(String.valueOf(this.bean.getRemoteJNDIName()));
                }
                if (this.bean.isUsernameSet()) {
                    stringBuffer.append("Username");
                    stringBuffer.append(String.valueOf(this.bean.getUsername()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                ForeignJMSConnectionFactoryMBeanImpl foreignJMSConnectionFactoryMBeanImpl = (ForeignJMSConnectionFactoryMBeanImpl)abstractDescriptorBean;
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ConnectionHealthChecking", this.bean.getConnectionHealthChecking(), foreignJMSConnectionFactoryMBeanImpl.getConnectionHealthChecking(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LocalJNDIName", this.bean.getLocalJNDIName(), foreignJMSConnectionFactoryMBeanImpl.getLocalJNDIName(), true);
                }
                this.computeDiff("Name", this.bean.getName(), foreignJMSConnectionFactoryMBeanImpl.getName(), false);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("Password", this.bean.getPassword(), foreignJMSConnectionFactoryMBeanImpl.getPassword(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("PasswordEncrypted", this.bean.getPasswordEncrypted(), foreignJMSConnectionFactoryMBeanImpl.getPasswordEncrypted(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("RemoteJNDIName", this.bean.getRemoteJNDIName(), foreignJMSConnectionFactoryMBeanImpl.getRemoteJNDIName(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("Username", this.bean.getUsername(), foreignJMSConnectionFactoryMBeanImpl.getUsername(), true);
                }
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                ForeignJMSConnectionFactoryMBeanImpl foreignJMSConnectionFactoryMBeanImpl = (ForeignJMSConnectionFactoryMBeanImpl)beanUpdateEvent.getSourceBean();
                ForeignJMSConnectionFactoryMBeanImpl foreignJMSConnectionFactoryMBeanImpl2 = (ForeignJMSConnectionFactoryMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("ConnectionHealthChecking")) {
                    foreignJMSConnectionFactoryMBeanImpl.setConnectionHealthChecking(foreignJMSConnectionFactoryMBeanImpl2.getConnectionHealthChecking());
                    foreignJMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("LocalJNDIName")) {
                    foreignJMSConnectionFactoryMBeanImpl.setLocalJNDIName(foreignJMSConnectionFactoryMBeanImpl2.getLocalJNDIName());
                    foreignJMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("Name")) {
                    foreignJMSConnectionFactoryMBeanImpl.setName(foreignJMSConnectionFactoryMBeanImpl2.getName());
                    foreignJMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (string.equals("Password")) {
                    foreignJMSConnectionFactoryMBeanImpl.setPassword(foreignJMSConnectionFactoryMBeanImpl2.getPassword());
                    foreignJMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("PasswordEncrypted")) {
                    foreignJMSConnectionFactoryMBeanImpl.setPasswordEncrypted(foreignJMSConnectionFactoryMBeanImpl2.getPasswordEncrypted());
                    foreignJMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("RemoteJNDIName")) {
                    foreignJMSConnectionFactoryMBeanImpl.setRemoteJNDIName(foreignJMSConnectionFactoryMBeanImpl2.getRemoteJNDIName());
                    foreignJMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("Username")) {
                    foreignJMSConnectionFactoryMBeanImpl.setUsername(foreignJMSConnectionFactoryMBeanImpl2.getUsername());
                    foreignJMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                ForeignJMSConnectionFactoryMBeanImpl foreignJMSConnectionFactoryMBeanImpl = (ForeignJMSConnectionFactoryMBeanImpl)abstractDescriptorBean;
                super.finishCopy(foreignJMSConnectionFactoryMBeanImpl, bl, list);
                if (bl && (list == null || !list.contains("ConnectionHealthChecking")) && this.bean.isConnectionHealthCheckingSet()) {
                    foreignJMSConnectionFactoryMBeanImpl.setConnectionHealthChecking(this.bean.getConnectionHealthChecking());
                }
                if (bl && (list == null || !list.contains("LocalJNDIName")) && this.bean.isLocalJNDINameSet()) {
                    foreignJMSConnectionFactoryMBeanImpl.setLocalJNDIName(this.bean.getLocalJNDIName());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    foreignJMSConnectionFactoryMBeanImpl.setName(this.bean.getName());
                }
                if (bl && (list == null || !list.contains("Password")) && this.bean.isPasswordSet()) {
                    foreignJMSConnectionFactoryMBeanImpl.setPassword(this.bean.getPassword());
                }
                if (bl && (list == null || !list.contains("PasswordEncrypted")) && this.bean.isPasswordEncryptedSet()) {
                    byte[] byArray = this.bean.getPasswordEncrypted();
                    foreignJMSConnectionFactoryMBeanImpl.setPasswordEncrypted(byArray == null ? null : (byte[])byArray.clone());
                }
                if (bl && (list == null || !list.contains("RemoteJNDIName")) && this.bean.isRemoteJNDINameSet()) {
                    foreignJMSConnectionFactoryMBeanImpl.setRemoteJNDIName(this.bean.getRemoteJNDIName());
                }
                if (bl && (list == null || !list.contains("Username")) && this.bean.isUsernameSet()) {
                    foreignJMSConnectionFactoryMBeanImpl.setUsername(this.bean.getUsername());
                }
                return foreignJMSConnectionFactoryMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

