/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanRemoveRejectedException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BootstrapProperties;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorValidateException;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.beangen.StringHelper;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.j2ee.descriptor.wl.ForeignServerBean;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.DeploymentMBeanImpl;
import weblogic.management.configuration.ForeignJMSConnectionFactoryMBean;
import weblogic.management.configuration.ForeignJMSConnectionFactoryMBeanImpl;
import weblogic.management.configuration.ForeignJMSDestinationMBean;
import weblogic.management.configuration.ForeignJMSDestinationMBeanImpl;
import weblogic.management.configuration.ForeignJMSServerMBean;
import weblogic.management.configuration.ForeignJNDIObjectMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.TargetMBeanImpl;
import weblogic.management.mbeans.custom.ForeignJMSServer;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;

public class ForeignJMSServerMBeanImpl
extends DeploymentMBeanImpl
implements ForeignJMSServerMBean,
Serializable {
    private ForeignJMSConnectionFactoryMBean[] _ConnectionFactories;
    private String _ConnectionURL;
    private ForeignJMSDestinationMBean[] _Destinations;
    private ForeignJMSConnectionFactoryMBean[] _ForeignJMSConnectionFactories;
    private ForeignJMSDestinationMBean[] _ForeignJMSDestinations;
    private String _InitialContextFactory;
    private Properties _JNDIProperties;
    private String _JNDIPropertiesCredential;
    private byte[] _JNDIPropertiesCredentialEncrypted;
    private String _Name;
    private TargetMBean[] _Targets;
    private ForeignJMSServer _customizer;
    private static SchemaHelper2 _schemaHelper;

    public ForeignJMSServerMBeanImpl() {
        try {
            this._customizer = new ForeignJMSServer(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public ForeignJMSServerMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new ForeignJMSServer(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public ForeignJMSDestinationMBean[] getDestinations() {
        return this._customizer.getDestinations();
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public TargetMBean[] getTargets() {
        return this._customizer.getTargets();
    }

    public String getTargetsAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getTargets());
    }

    public boolean isDestinationsSet() {
        return this._isSet(9);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isTargetsSet() {
        return this._isSet(7);
    }

    public void setTargetsAsString(String string) {
        if (string == null || string.length() == 0) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._initializeProperty(7);
            this._postSet(7, targetMBeanArray, this._Targets);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._Targets);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, TargetMBean.class, new ReferenceManager.Resolver(this, 7){

                    public void resolveReference(Object object) {
                        try {
                            ForeignJMSServerMBeanImpl.this.addTarget((TargetMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (TargetMBean targetMBean : this._Targets) {
                    if (!string2.equals(targetMBean.getName())) continue;
                    try {
                        this.removeTarget(targetMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void setDestinations(ForeignJMSDestinationMBean[] foreignJMSDestinationMBeanArray) {
        foreignJMSDestinationMBeanArray = foreignJMSDestinationMBeanArray == null ? new ForeignJMSDestinationMBeanImpl[]{} : foreignJMSDestinationMBeanArray;
        this._Destinations = foreignJMSDestinationMBeanArray;
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setTargets(TargetMBean[] targetMBeanArray) throws InvalidAttributeValueException, DistributedManagementException {
        targetMBeanArray = targetMBeanArray == null ? new TargetMBeanImpl[]{} : targetMBeanArray;
        targetMBeanArray = (TargetMBean[])this._getHelper()._cleanAndValidateArray((Object)targetMBeanArray, TargetMBean.class);
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            if (targetMBeanArray[i] == null) continue;
            ResolvedReference resolvedReference = new ResolvedReference(this, 7, (AbstractDescriptorBean)targetMBeanArray[i]){

                protected Object getPropertyValue() {
                    return ForeignJMSServerMBeanImpl.this.getTargets();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)targetMBeanArray[i], resolvedReference);
        }
        TargetMBean[] targetMBeanArray2 = this.getTargets();
        this._customizer.setTargets(targetMBeanArray);
        this._postSet(7, targetMBeanArray2, targetMBeanArray);
    }

    public boolean addDestination(ForeignJMSDestinationMBean foreignJMSDestinationMBean) {
        return this._customizer.addDestination(foreignJMSDestinationMBean);
    }

    public boolean addTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        this._getHelper()._ensureNonNull((Object)targetMBean);
        if (!((AbstractDescriptorBean)targetMBean).isChildProperty((DescriptorBean)this, 7)) {
            TargetMBean[] targetMBeanArray = (TargetMBean[])this._getHelper()._extendArray((Object)this.getTargets(), TargetMBean.class, (Object)targetMBean);
            try {
                this.setTargets(targetMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public boolean removeDestination(ForeignJMSDestinationMBean foreignJMSDestinationMBean) {
        ForeignJMSDestinationMBean[] foreignJMSDestinationMBeanArray = this.getDestinations();
        ForeignJMSDestinationMBean[] foreignJMSDestinationMBeanArray2 = (ForeignJMSDestinationMBean[])this._getHelper()._removeElement((Object)foreignJMSDestinationMBeanArray, ForeignJMSDestinationMBean.class, (Object)foreignJMSDestinationMBean);
        if (foreignJMSDestinationMBeanArray2.length != foreignJMSDestinationMBeanArray.length) {
            try {
                this.setDestinations(foreignJMSDestinationMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public boolean removeTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        TargetMBean[] targetMBeanArray = this.getTargets();
        TargetMBean[] targetMBeanArray2 = (TargetMBean[])this._getHelper()._removeElement((Object)targetMBeanArray, TargetMBean.class, (Object)targetMBean);
        if (targetMBeanArray2.length != targetMBeanArray.length) {
            try {
                this.setTargets(targetMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public ForeignJMSConnectionFactoryMBean[] getConnectionFactories() {
        return this._ConnectionFactories;
    }

    public boolean isConnectionFactoriesSet() {
        return this._isSet(10);
    }

    public void setConnectionFactories(ForeignJMSConnectionFactoryMBean[] foreignJMSConnectionFactoryMBeanArray) {
        foreignJMSConnectionFactoryMBeanArray = foreignJMSConnectionFactoryMBeanArray == null ? new ForeignJMSConnectionFactoryMBeanImpl[]{} : foreignJMSConnectionFactoryMBeanArray;
        this._ConnectionFactories = foreignJMSConnectionFactoryMBeanArray;
    }

    public boolean addConnectionFactory(ForeignJMSConnectionFactoryMBean foreignJMSConnectionFactoryMBean) {
        return this._customizer.addConnectionFactory(foreignJMSConnectionFactoryMBean);
    }

    public boolean removeConnectionFactory(ForeignJMSConnectionFactoryMBean foreignJMSConnectionFactoryMBean) {
        ForeignJMSConnectionFactoryMBean[] foreignJMSConnectionFactoryMBeanArray = this.getConnectionFactories();
        ForeignJMSConnectionFactoryMBean[] foreignJMSConnectionFactoryMBeanArray2 = (ForeignJMSConnectionFactoryMBean[])this._getHelper()._removeElement((Object)foreignJMSConnectionFactoryMBeanArray, ForeignJMSConnectionFactoryMBean.class, (Object)foreignJMSConnectionFactoryMBean);
        if (foreignJMSConnectionFactoryMBeanArray2.length != foreignJMSConnectionFactoryMBeanArray.length) {
            try {
                this.setConnectionFactories(foreignJMSConnectionFactoryMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public void setInitialContextFactory(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonNull((String)"InitialContextFactory", (Object)string);
        String string2 = this.getInitialContextFactory();
        this._customizer.setInitialContextFactory(string);
        this._postSet(11, string2, string);
    }

    public String getInitialContextFactory() {
        return this._customizer.getInitialContextFactory();
    }

    public boolean isInitialContextFactorySet() {
        return this._isSet(11);
    }

    public void setConnectionURL(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this.getConnectionURL();
        this._customizer.setConnectionURL(string);
        this._postSet(12, string2, string);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public String getConnectionURL() {
        return this._customizer.getConnectionURL();
    }

    public boolean isConnectionURLSet() {
        return this._isSet(12);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setJNDIProperties(Properties properties) throws InvalidAttributeValueException {
        Properties properties2 = this.getJNDIProperties();
        this._customizer.setJNDIProperties(properties);
        this._postSet(13, properties2, properties);
    }

    public Properties getJNDIProperties() {
        return this._customizer.getJNDIProperties();
    }

    public String getJNDIPropertiesAsString() {
        return StringHelper.objectToString((Object)this.getJNDIProperties());
    }

    public boolean isJNDIPropertiesSet() {
        return this._isSet(13);
    }

    public void setJNDIPropertiesAsString(String string) {
        try {
            this.setJNDIProperties(StringHelper.stringToProperties((String)string));
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public byte[] getJNDIPropertiesCredentialEncrypted() {
        return this._getHelper()._cloneArray(this._JNDIPropertiesCredentialEncrypted);
    }

    public String getJNDIPropertiesCredentialEncryptedAsString() {
        byte[] byArray = this.getJNDIPropertiesCredentialEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isJNDIPropertiesCredentialEncryptedSet() {
        return this._isSet(14);
    }

    public void setJNDIPropertiesCredentialEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setJNDIPropertiesCredentialEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public String getJNDIPropertiesCredential() {
        byte[] byArray = this.getJNDIPropertiesCredentialEncrypted();
        return byArray == null ? null : this._decrypt("JNDIPropertiesCredential", byArray);
    }

    public boolean isJNDIPropertiesCredentialSet() {
        return this.isJNDIPropertiesCredentialEncryptedSet();
    }

    public void setJNDIPropertiesCredential(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setJNDIPropertiesCredentialEncrypted(string == null ? null : this._encrypt("JNDIPropertiesCredential", string));
    }

    public void addForeignJMSConnectionFactory(ForeignJMSConnectionFactoryMBean foreignJMSConnectionFactoryMBean) {
        this._getHelper()._ensureNonNull((Object)foreignJMSConnectionFactoryMBean);
        if (!((AbstractDescriptorBean)foreignJMSConnectionFactoryMBean).isChildProperty((DescriptorBean)this, 16)) {
            ForeignJMSConnectionFactoryMBean[] foreignJMSConnectionFactoryMBeanArray = this._isSet(16) ? (ForeignJMSConnectionFactoryMBean[])this._getHelper()._extendArray((Object)this.getForeignJMSConnectionFactories(), ForeignJMSConnectionFactoryMBean.class, (Object)foreignJMSConnectionFactoryMBean) : new ForeignJMSConnectionFactoryMBean[]{foreignJMSConnectionFactoryMBean};
            try {
                this.setForeignJMSConnectionFactories(foreignJMSConnectionFactoryMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public ForeignJMSConnectionFactoryMBean[] getForeignJMSConnectionFactories() {
        return this._ForeignJMSConnectionFactories;
    }

    public boolean isForeignJMSConnectionFactoriesSet() {
        return this._isSet(16);
    }

    public void removeForeignJMSConnectionFactory(ForeignJMSConnectionFactoryMBean foreignJMSConnectionFactoryMBean) {
        this.destroyForeignJMSConnectionFactory(foreignJMSConnectionFactoryMBean);
    }

    public void setForeignJMSConnectionFactories(ForeignJMSConnectionFactoryMBean[] foreignJMSConnectionFactoryMBeanArray) throws InvalidAttributeValueException {
        foreignJMSConnectionFactoryMBeanArray = foreignJMSConnectionFactoryMBeanArray == null ? new ForeignJMSConnectionFactoryMBeanImpl[]{} : foreignJMSConnectionFactoryMBeanArray;
        for (int i = 0; i < foreignJMSConnectionFactoryMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)foreignJMSConnectionFactoryMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 16)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, false);
            this._postCreate(abstractDescriptorBean);
        }
        ForeignJMSConnectionFactoryMBean[] foreignJMSConnectionFactoryMBeanArray2 = this._ForeignJMSConnectionFactories;
        this._ForeignJMSConnectionFactories = foreignJMSConnectionFactoryMBeanArray;
        this._postSet(16, foreignJMSConnectionFactoryMBeanArray2, foreignJMSConnectionFactoryMBeanArray);
    }

    public ForeignJMSConnectionFactoryMBean createForeignJMSConnectionFactory(String string) {
        ForeignJMSConnectionFactoryMBeanImpl foreignJMSConnectionFactoryMBeanImpl = new ForeignJMSConnectionFactoryMBeanImpl(this, -1);
        try {
            foreignJMSConnectionFactoryMBeanImpl.setName(string);
            this.addForeignJMSConnectionFactory(foreignJMSConnectionFactoryMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return foreignJMSConnectionFactoryMBeanImpl;
    }

    public ForeignJMSConnectionFactoryMBean lookupForeignJMSConnectionFactory(String string) {
        for (ForeignJMSConnectionFactoryMBeanImpl foreignJMSConnectionFactoryMBeanImpl : Arrays.asList((Object[])this._ForeignJMSConnectionFactories)) {
            String string2 = string;
            if (!foreignJMSConnectionFactoryMBeanImpl.getName().equals(string2)) continue;
            return foreignJMSConnectionFactoryMBeanImpl;
        }
        return null;
    }

    public void destroyForeignJMSConnectionFactory(ForeignJMSConnectionFactoryMBean foreignJMSConnectionFactoryMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(foreignJMSConnectionFactoryMBean, 16);
                ForeignJMSConnectionFactoryMBean[] foreignJMSConnectionFactoryMBeanArray = this.getForeignJMSConnectionFactories();
                ForeignJMSConnectionFactoryMBean[] foreignJMSConnectionFactoryMBeanArray2 = (ForeignJMSConnectionFactoryMBean[])this._getHelper()._removeElement((Object)foreignJMSConnectionFactoryMBeanArray, ForeignJMSConnectionFactoryMBean.class, (Object)foreignJMSConnectionFactoryMBean);
                if (foreignJMSConnectionFactoryMBeanArray.length == foreignJMSConnectionFactoryMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)foreignJMSConnectionFactoryMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)foreignJMSConnectionFactoryMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setForeignJMSConnectionFactories(foreignJMSConnectionFactoryMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public ForeignJMSConnectionFactoryMBean createForeignJMSConnectionFactory(String string, ForeignJMSConnectionFactoryMBean foreignJMSConnectionFactoryMBean) {
        return this._customizer.createForeignJMSConnectionFactory(string, foreignJMSConnectionFactoryMBean);
    }

    public void addForeignJMSDestination(ForeignJMSDestinationMBean foreignJMSDestinationMBean) {
        this._getHelper()._ensureNonNull((Object)foreignJMSDestinationMBean);
        if (!((AbstractDescriptorBean)foreignJMSDestinationMBean).isChildProperty((DescriptorBean)this, 17)) {
            ForeignJMSDestinationMBean[] foreignJMSDestinationMBeanArray = this._isSet(17) ? (ForeignJMSDestinationMBean[])this._getHelper()._extendArray((Object)this.getForeignJMSDestinations(), ForeignJMSDestinationMBean.class, (Object)foreignJMSDestinationMBean) : new ForeignJMSDestinationMBean[]{foreignJMSDestinationMBean};
            try {
                this.setForeignJMSDestinations(foreignJMSDestinationMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public ForeignJMSDestinationMBean[] getForeignJMSDestinations() {
        return this._ForeignJMSDestinations;
    }

    public boolean isForeignJMSDestinationsSet() {
        return this._isSet(17);
    }

    public void removeForeignJMSDestination(ForeignJMSDestinationMBean foreignJMSDestinationMBean) {
        this.destroyForeignJMSDestination(foreignJMSDestinationMBean);
    }

    public void setForeignJMSDestinations(ForeignJMSDestinationMBean[] foreignJMSDestinationMBeanArray) throws InvalidAttributeValueException {
        foreignJMSDestinationMBeanArray = foreignJMSDestinationMBeanArray == null ? new ForeignJMSDestinationMBeanImpl[]{} : foreignJMSDestinationMBeanArray;
        for (int i = 0; i < foreignJMSDestinationMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)foreignJMSDestinationMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 17)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, false);
            this._postCreate(abstractDescriptorBean);
        }
        ForeignJMSDestinationMBean[] foreignJMSDestinationMBeanArray2 = this._ForeignJMSDestinations;
        this._ForeignJMSDestinations = foreignJMSDestinationMBeanArray;
        this._postSet(17, foreignJMSDestinationMBeanArray2, foreignJMSDestinationMBeanArray);
    }

    public ForeignJMSDestinationMBean createForeignJMSDestination(String string) {
        ForeignJMSDestinationMBeanImpl foreignJMSDestinationMBeanImpl = new ForeignJMSDestinationMBeanImpl(this, -1);
        try {
            foreignJMSDestinationMBeanImpl.setName(string);
            this.addForeignJMSDestination(foreignJMSDestinationMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return foreignJMSDestinationMBeanImpl;
    }

    public ForeignJMSDestinationMBean lookupForeignJMSDestination(String string) {
        for (ForeignJMSDestinationMBeanImpl foreignJMSDestinationMBeanImpl : Arrays.asList((Object[])this._ForeignJMSDestinations)) {
            String string2 = string;
            if (!foreignJMSDestinationMBeanImpl.getName().equals(string2)) continue;
            return foreignJMSDestinationMBeanImpl;
        }
        return null;
    }

    public ForeignJMSDestinationMBean createForeignJMSDestination(String string, ForeignJMSDestinationMBean foreignJMSDestinationMBean) {
        return this._customizer.createForeignJMSDestination(string, foreignJMSDestinationMBean);
    }

    public void destroyForeignJMSDestination(ForeignJMSDestinationMBean foreignJMSDestinationMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(foreignJMSDestinationMBean, 17);
                ForeignJMSDestinationMBean[] foreignJMSDestinationMBeanArray = this.getForeignJMSDestinations();
                ForeignJMSDestinationMBean[] foreignJMSDestinationMBeanArray2 = (ForeignJMSDestinationMBean[])this._getHelper()._removeElement((Object)foreignJMSDestinationMBeanArray, ForeignJMSDestinationMBean.class, (Object)foreignJMSDestinationMBean);
                if (foreignJMSDestinationMBeanArray.length == foreignJMSDestinationMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)foreignJMSDestinationMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)foreignJMSDestinationMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setForeignJMSDestinations(foreignJMSDestinationMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void useDelegates(ForeignServerBean foreignServerBean, SubDeploymentMBean subDeploymentMBean) {
        this._customizer.useDelegates(foreignServerBean, subDeploymentMBean);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public void setJNDIPropertiesCredentialEncrypted(byte[] byArray) {
        byte[] byArray2 = this._JNDIPropertiesCredentialEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: JNDIPropertiesCredentialEncrypted of ForeignJMSServerMBean");
        }
        this._getHelper()._clearArray(this._JNDIPropertiesCredentialEncrypted);
        this._JNDIPropertiesCredentialEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(14, byArray2, byArray);
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
            if (n == 15) {
                this._markSet(14, false);
            }
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 10;
        }
        try {
            switch (n) {
                case 10: {
                    this._ConnectionFactories = new ForeignJMSConnectionFactoryMBean[0];
                    if (bl) break;
                }
                case 12: {
                    this._customizer.setConnectionURL(null);
                    if (bl) break;
                }
                case 9: {
                    this._Destinations = new ForeignJMSDestinationMBean[0];
                    if (bl) break;
                }
                case 16: {
                    this._ForeignJMSConnectionFactories = new ForeignJMSConnectionFactoryMBean[0];
                    if (bl) break;
                }
                case 17: {
                    this._ForeignJMSDestinations = new ForeignJMSDestinationMBean[0];
                    if (bl) break;
                }
                case 11: {
                    this._customizer.setInitialContextFactory("weblogic.jndi.WLInitialContextFactory");
                    if (bl) break;
                }
                case 13: {
                    this._customizer.setJNDIProperties(null);
                    if (bl) break;
                }
                case 15: {
                    this._JNDIPropertiesCredentialEncrypted = null;
                    if (bl) break;
                }
                case 14: {
                    this._JNDIPropertiesCredentialEncrypted = null;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 7: {
                    this._customizer.setTargets(new TargetMBean[0]);
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "ForeignJMSServer";
    }

    public void putValue(String string, Object object) {
        if (string.equals("ConnectionFactories")) {
            ForeignJMSConnectionFactoryMBean[] foreignJMSConnectionFactoryMBeanArray = this._ConnectionFactories;
            this._ConnectionFactories = (ForeignJMSConnectionFactoryMBean[])object;
            this._postSet(10, foreignJMSConnectionFactoryMBeanArray, this._ConnectionFactories);
            return;
        }
        if (string.equals("ConnectionURL")) {
            String string2 = this._ConnectionURL;
            this._ConnectionURL = (String)object;
            this._postSet(12, string2, this._ConnectionURL);
            return;
        }
        if (string.equals("Destinations")) {
            ForeignJMSDestinationMBean[] foreignJMSDestinationMBeanArray = this._Destinations;
            this._Destinations = (ForeignJMSDestinationMBean[])object;
            this._postSet(9, foreignJMSDestinationMBeanArray, this._Destinations);
            return;
        }
        if (string.equals("ForeignJMSConnectionFactories")) {
            ForeignJMSConnectionFactoryMBean[] foreignJMSConnectionFactoryMBeanArray = this._ForeignJMSConnectionFactories;
            this._ForeignJMSConnectionFactories = (ForeignJMSConnectionFactoryMBean[])object;
            this._postSet(16, foreignJMSConnectionFactoryMBeanArray, this._ForeignJMSConnectionFactories);
            return;
        }
        if (string.equals("ForeignJMSDestinations")) {
            ForeignJMSDestinationMBean[] foreignJMSDestinationMBeanArray = this._ForeignJMSDestinations;
            this._ForeignJMSDestinations = (ForeignJMSDestinationMBean[])object;
            this._postSet(17, foreignJMSDestinationMBeanArray, this._ForeignJMSDestinations);
            return;
        }
        if (string.equals("InitialContextFactory")) {
            String string3 = this._InitialContextFactory;
            this._InitialContextFactory = (String)object;
            this._postSet(11, string3, this._InitialContextFactory);
            return;
        }
        if (string.equals("JNDIProperties")) {
            Properties properties = this._JNDIProperties;
            this._JNDIProperties = (Properties)object;
            this._postSet(13, properties, this._JNDIProperties);
            return;
        }
        if (string.equals("JNDIPropertiesCredential")) {
            String string4 = this._JNDIPropertiesCredential;
            this._JNDIPropertiesCredential = (String)object;
            this._postSet(15, string4, this._JNDIPropertiesCredential);
            return;
        }
        if (string.equals("JNDIPropertiesCredentialEncrypted")) {
            byte[] byArray = this._JNDIPropertiesCredentialEncrypted;
            this._JNDIPropertiesCredentialEncrypted = (byte[])object;
            this._postSet(14, byArray, this._JNDIPropertiesCredentialEncrypted);
            return;
        }
        if (string.equals("Name")) {
            String string5 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string5, this._Name);
            return;
        }
        if (string.equals("Targets")) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._Targets = (TargetMBean[])object;
            this._postSet(7, targetMBeanArray, this._Targets);
            return;
        }
        if (string.equals("customizer")) {
            ForeignJMSServer foreignJMSServer = this._customizer;
            this._customizer = (ForeignJMSServer)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("ConnectionFactories")) {
            return this._ConnectionFactories;
        }
        if (string.equals("ConnectionURL")) {
            return this._ConnectionURL;
        }
        if (string.equals("Destinations")) {
            return this._Destinations;
        }
        if (string.equals("ForeignJMSConnectionFactories")) {
            return this._ForeignJMSConnectionFactories;
        }
        if (string.equals("ForeignJMSDestinations")) {
            return this._ForeignJMSDestinations;
        }
        if (string.equals("InitialContextFactory")) {
            return this._InitialContextFactory;
        }
        if (string.equals("JNDIProperties")) {
            return this._JNDIProperties;
        }
        if (string.equals("JNDIPropertiesCredential")) {
            return this._JNDIPropertiesCredential;
        }
        if (string.equals("JNDIPropertiesCredentialEncrypted")) {
            return this._JNDIPropertiesCredentialEncrypted;
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("Targets")) {
            return this._Targets;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static void validateGeneration() {
        try {
            LegalChecks.checkNonNull((String)"InitialContextFactory", (Object)"weblogic.jndi.WLInitialContextFactory");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("The default value for the property  is null. Properties annotated with false value on @legalZeroLength or @legalNull  should either have @required/@derivedDefault annotations or have a non-null value on @default annotation. Refer annotation legalNull on property InitialContextFactory in ForeignJMSServerMBean" + illegalArgumentException.getMessage());
        }
    }

    public static class SchemaHelper2
    extends DeploymentMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 18: {
                    if (!string.equals("connection-factory")) break;
                    return 10;
                }
                case 14: {
                    if (!string.equals("connection-url")) break;
                    return 12;
                }
                case 11: {
                    if (!string.equals("destination")) break;
                    return 9;
                }
                case 30: {
                    if (!string.equals("foreign-jms-connection-factory")) break;
                    return 16;
                }
                case 23: {
                    if (string.equals("foreign-jms-destination")) {
                        return 17;
                    }
                    if (!string.equals("initial-context-factory")) break;
                    return 11;
                }
                case 15: {
                    if (!string.equals("jndi-properties")) break;
                    return 13;
                }
                case 26: {
                    if (!string.equals("jndi-properties-credential")) break;
                    return 15;
                }
                case 36: {
                    if (!string.equals("jndi-properties-credential-encrypted")) break;
                    return 14;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 6: {
                    if (!string.equals("target")) break;
                    return 7;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                case 16: {
                    return new ForeignJMSConnectionFactoryMBeanImpl.SchemaHelper2();
                }
                case 17: {
                    return new ForeignJMSDestinationMBeanImpl.SchemaHelper2();
                }
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 10: {
                    return "connection-factory";
                }
                case 12: {
                    return "connection-url";
                }
                case 9: {
                    return "destination";
                }
                case 16: {
                    return "foreign-jms-connection-factory";
                }
                case 17: {
                    return "foreign-jms-destination";
                }
                case 11: {
                    return "initial-context-factory";
                }
                case 13: {
                    return "jndi-properties";
                }
                case 15: {
                    return "jndi-properties-credential";
                }
                case 14: {
                    return "jndi-properties-credential-encrypted";
                }
                case 2: {
                    return "name";
                }
                case 7: {
                    return "target";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 10: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 16: {
                    return true;
                }
                case 17: {
                    return true;
                }
                case 7: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                case 16: {
                    return true;
                }
                case 17: {
                    return true;
                }
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends DeploymentMBeanImpl.Helper {
        private ForeignJMSServerMBeanImpl bean;

        protected Helper(ForeignJMSServerMBeanImpl foreignJMSServerMBeanImpl) {
            super(foreignJMSServerMBeanImpl);
            this.bean = foreignJMSServerMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 10: {
                    return "ConnectionFactories";
                }
                case 12: {
                    return "ConnectionURL";
                }
                case 9: {
                    return "Destinations";
                }
                case 16: {
                    return "ForeignJMSConnectionFactories";
                }
                case 17: {
                    return "ForeignJMSDestinations";
                }
                case 11: {
                    return "InitialContextFactory";
                }
                case 13: {
                    return "JNDIProperties";
                }
                case 15: {
                    return "JNDIPropertiesCredential";
                }
                case 14: {
                    return "JNDIPropertiesCredentialEncrypted";
                }
                case 2: {
                    return "Name";
                }
                case 7: {
                    return "Targets";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("ConnectionFactories")) {
                return 10;
            }
            if (string.equals("ConnectionURL")) {
                return 12;
            }
            if (string.equals("Destinations")) {
                return 9;
            }
            if (string.equals("ForeignJMSConnectionFactories")) {
                return 16;
            }
            if (string.equals("ForeignJMSDestinations")) {
                return 17;
            }
            if (string.equals("InitialContextFactory")) {
                return 11;
            }
            if (string.equals("JNDIProperties")) {
                return 13;
            }
            if (string.equals("JNDIPropertiesCredential")) {
                return 15;
            }
            if (string.equals("JNDIPropertiesCredentialEncrypted")) {
                return 14;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("Targets")) {
                return 7;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList<ArrayIterator> arrayList = new ArrayList<ArrayIterator>();
            arrayList.add(new ArrayIterator((Object[])this.bean.getForeignJMSConnectionFactories()));
            arrayList.add(new ArrayIterator((Object[])this.bean.getForeignJMSDestinations()));
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                int n;
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isConnectionFactoriesSet()) {
                    stringBuffer.append("ConnectionFactories");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getConnectionFactories())));
                }
                if (this.bean.isConnectionURLSet()) {
                    stringBuffer.append("ConnectionURL");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionURL()));
                }
                if (this.bean.isDestinationsSet()) {
                    stringBuffer.append("Destinations");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getDestinations())));
                }
                l2 = 0L;
                for (n = 0; n < this.bean.getForeignJMSConnectionFactories().length; ++n) {
                    l2 ^= this.computeChildHashValue(this.bean.getForeignJMSConnectionFactories()[n]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                l2 = 0L;
                for (n = 0; n < this.bean.getForeignJMSDestinations().length; ++n) {
                    l2 ^= this.computeChildHashValue(this.bean.getForeignJMSDestinations()[n]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isInitialContextFactorySet()) {
                    stringBuffer.append("InitialContextFactory");
                    stringBuffer.append(String.valueOf(this.bean.getInitialContextFactory()));
                }
                if (this.bean.isJNDIPropertiesSet()) {
                    stringBuffer.append("JNDIProperties");
                    stringBuffer.append(String.valueOf(this.bean.getJNDIProperties()));
                }
                if (this.bean.isJNDIPropertiesCredentialSet()) {
                    stringBuffer.append("JNDIPropertiesCredential");
                    stringBuffer.append(String.valueOf(this.bean.getJNDIPropertiesCredential()));
                }
                if (this.bean.isJNDIPropertiesCredentialEncryptedSet()) {
                    stringBuffer.append("JNDIPropertiesCredentialEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getJNDIPropertiesCredentialEncrypted())));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isTargetsSet()) {
                    stringBuffer.append("Targets");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getTargets())));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                ForeignJMSServerMBeanImpl foreignJMSServerMBeanImpl = (ForeignJMSServerMBeanImpl)abstractDescriptorBean;
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ConnectionURL", this.bean.getConnectionURL(), foreignJMSServerMBeanImpl.getConnectionURL(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeChildDiff("ForeignJMSConnectionFactories", this.bean.getForeignJMSConnectionFactories(), foreignJMSServerMBeanImpl.getForeignJMSConnectionFactories(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeChildDiff("ForeignJMSDestinations", this.bean.getForeignJMSDestinations(), foreignJMSServerMBeanImpl.getForeignJMSDestinations(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("InitialContextFactory", this.bean.getInitialContextFactory(), foreignJMSServerMBeanImpl.getInitialContextFactory(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("JNDIProperties", this.bean.getJNDIProperties(), foreignJMSServerMBeanImpl.getJNDIProperties(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("JNDIPropertiesCredentialEncrypted", this.bean.getJNDIPropertiesCredentialEncrypted(), foreignJMSServerMBeanImpl.getJNDIPropertiesCredentialEncrypted(), false);
                }
                this.computeDiff("Name", this.bean.getName(), foreignJMSServerMBeanImpl.getName(), false);
                this.computeDiff("Targets", this.bean.getTargets(), foreignJMSServerMBeanImpl.getTargets(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                ForeignJMSServerMBeanImpl foreignJMSServerMBeanImpl = (ForeignJMSServerMBeanImpl)beanUpdateEvent.getSourceBean();
                ForeignJMSServerMBeanImpl foreignJMSServerMBeanImpl2 = (ForeignJMSServerMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (!string.equals("ConnectionFactories")) {
                    if (string.equals("ConnectionURL")) {
                        foreignJMSServerMBeanImpl.setConnectionURL(foreignJMSServerMBeanImpl2.getConnectionURL());
                        foreignJMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                    } else if (!string.equals("Destinations")) {
                        if (string.equals("ForeignJMSConnectionFactories")) {
                            if (n == 2) {
                                propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                                foreignJMSServerMBeanImpl.addForeignJMSConnectionFactory((ForeignJMSConnectionFactoryMBean)propertyUpdate.getAddedObject());
                            } else if (n == 3) {
                                foreignJMSServerMBeanImpl.removeForeignJMSConnectionFactory((ForeignJMSConnectionFactoryMBean)propertyUpdate.getRemovedObject());
                            } else {
                                throw new AssertionError((Object)("Invalid type: " + n));
                            }
                            if (foreignJMSServerMBeanImpl.getForeignJMSConnectionFactories() == null || foreignJMSServerMBeanImpl.getForeignJMSConnectionFactories().length == 0) {
                                foreignJMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                            }
                        } else if (string.equals("ForeignJMSDestinations")) {
                            if (n == 2) {
                                propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                                foreignJMSServerMBeanImpl.addForeignJMSDestination((ForeignJMSDestinationMBean)propertyUpdate.getAddedObject());
                            } else if (n == 3) {
                                foreignJMSServerMBeanImpl.removeForeignJMSDestination((ForeignJMSDestinationMBean)propertyUpdate.getRemovedObject());
                            } else {
                                throw new AssertionError((Object)("Invalid type: " + n));
                            }
                            if (foreignJMSServerMBeanImpl.getForeignJMSDestinations() == null || foreignJMSServerMBeanImpl.getForeignJMSDestinations().length == 0) {
                                foreignJMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                            }
                        } else if (string.equals("InitialContextFactory")) {
                            foreignJMSServerMBeanImpl.setInitialContextFactory(foreignJMSServerMBeanImpl2.getInitialContextFactory());
                            foreignJMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                        } else if (string.equals("JNDIProperties")) {
                            foreignJMSServerMBeanImpl.setJNDIProperties(foreignJMSServerMBeanImpl2.getJNDIProperties() == null ? null : (Properties)foreignJMSServerMBeanImpl2.getJNDIProperties().clone());
                            foreignJMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                        } else if (!string.equals("JNDIPropertiesCredential")) {
                            if (string.equals("JNDIPropertiesCredentialEncrypted")) {
                                foreignJMSServerMBeanImpl.setJNDIPropertiesCredentialEncrypted(foreignJMSServerMBeanImpl2.getJNDIPropertiesCredentialEncrypted());
                                foreignJMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                            } else if (string.equals("Name")) {
                                foreignJMSServerMBeanImpl.setName(foreignJMSServerMBeanImpl2.getName());
                                foreignJMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                            } else if (string.equals("Targets")) {
                                foreignJMSServerMBeanImpl.setTargetsAsString(foreignJMSServerMBeanImpl2.getTargetsAsString());
                                foreignJMSServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                            } else {
                                super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                            }
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                int n;
                ForeignJNDIObjectMBean[] foreignJNDIObjectMBeanArray;
                ForeignJNDIObjectMBean[] foreignJNDIObjectMBeanArray2;
                ForeignJMSServerMBeanImpl foreignJMSServerMBeanImpl = (ForeignJMSServerMBeanImpl)abstractDescriptorBean;
                super.finishCopy(foreignJMSServerMBeanImpl, bl, list);
                if (bl && (list == null || !list.contains("ConnectionURL")) && this.bean.isConnectionURLSet()) {
                    foreignJMSServerMBeanImpl.setConnectionURL(this.bean.getConnectionURL());
                }
                if (bl && (list == null || !list.contains("ForeignJMSConnectionFactories")) && this.bean.isForeignJMSConnectionFactoriesSet() && !foreignJMSServerMBeanImpl._isSet(16)) {
                    foreignJNDIObjectMBeanArray2 = this.bean.getForeignJMSConnectionFactories();
                    foreignJNDIObjectMBeanArray = new ForeignJMSConnectionFactoryMBean[foreignJNDIObjectMBeanArray2.length];
                    for (n = 0; n < foreignJNDIObjectMBeanArray.length; ++n) {
                        foreignJNDIObjectMBeanArray[n] = (ForeignJMSConnectionFactoryMBean)this.createCopy((AbstractDescriptorBean)foreignJNDIObjectMBeanArray2[n], bl);
                    }
                    foreignJMSServerMBeanImpl.setForeignJMSConnectionFactories((ForeignJMSConnectionFactoryMBean[])foreignJNDIObjectMBeanArray);
                }
                if (bl && (list == null || !list.contains("ForeignJMSDestinations")) && this.bean.isForeignJMSDestinationsSet() && !foreignJMSServerMBeanImpl._isSet(17)) {
                    foreignJNDIObjectMBeanArray2 = this.bean.getForeignJMSDestinations();
                    foreignJNDIObjectMBeanArray = new ForeignJMSDestinationMBean[foreignJNDIObjectMBeanArray2.length];
                    for (n = 0; n < foreignJNDIObjectMBeanArray.length; ++n) {
                        foreignJNDIObjectMBeanArray[n] = (ForeignJMSDestinationMBean)this.createCopy((AbstractDescriptorBean)foreignJNDIObjectMBeanArray2[n], bl);
                    }
                    foreignJMSServerMBeanImpl.setForeignJMSDestinations((ForeignJMSDestinationMBean[])foreignJNDIObjectMBeanArray);
                }
                if (bl && (list == null || !list.contains("InitialContextFactory")) && this.bean.isInitialContextFactorySet()) {
                    foreignJMSServerMBeanImpl.setInitialContextFactory(this.bean.getInitialContextFactory());
                }
                if (bl && (list == null || !list.contains("JNDIProperties")) && this.bean.isJNDIPropertiesSet()) {
                    foreignJMSServerMBeanImpl.setJNDIProperties(this.bean.getJNDIProperties());
                }
                if (bl && (list == null || !list.contains("JNDIPropertiesCredentialEncrypted")) && this.bean.isJNDIPropertiesCredentialEncryptedSet()) {
                    byte[] byArray = this.bean.getJNDIPropertiesCredentialEncrypted();
                    foreignJMSServerMBeanImpl.setJNDIPropertiesCredentialEncrypted(byArray == null ? null : (byte[])byArray.clone());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    foreignJMSServerMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("Targets")) && this.bean.isTargetsSet()) {
                    foreignJMSServerMBeanImpl._unSet(foreignJMSServerMBeanImpl, 7);
                    foreignJMSServerMBeanImpl.setTargetsAsString(this.bean.getTargetsAsString());
                }
                return foreignJMSServerMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getConnectionFactories(), clazz, object);
            this.inferSubTree(this.bean.getDestinations(), clazz, object);
            this.inferSubTree(this.bean.getForeignJMSConnectionFactories(), clazz, object);
            this.inferSubTree(this.bean.getForeignJMSDestinations(), clazz, object);
            this.inferSubTree(this.bean.getTargets(), clazz, object);
        }
    }
}

