/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.GenericFileStoreMBean;
import weblogic.utils.collections.CombinedIterator;

public class GenericFileStoreMBeanImpl
extends ConfigurationMBeanImpl
implements GenericFileStoreMBean,
Serializable {
    private int _BlockSize;
    private String _CacheDirectory;
    private String _Directory;
    private boolean _FileLockingEnabled;
    private long _InitialSize;
    private int _IoBufferSize;
    private long _MaxFileSize;
    private int _MaxWindowBufferSize;
    private int _MinWindowBufferSize;
    private String _SynchronousWritePolicy;
    private static SchemaHelper2 _schemaHelper;

    public GenericFileStoreMBeanImpl() {
        this._initializeProperty(-1);
    }

    public GenericFileStoreMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public String getDirectory() {
        return this._Directory;
    }

    public boolean isDirectorySet() {
        return this._isSet(7);
    }

    public void setDirectory(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._Directory;
        this._Directory = string;
        this._postSet(7, string2, string);
    }

    public String getSynchronousWritePolicy() {
        return this._SynchronousWritePolicy;
    }

    public boolean isSynchronousWritePolicySet() {
        return this._isSet(8);
    }

    public void setSynchronousWritePolicy(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Disabled", "Cache-Flush", "Direct-Write", "Direct-Write-With-Cache"};
        string = LegalChecks.checkInEnum((String)"SynchronousWritePolicy", (String)string, (String[])stringArray);
        String string2 = this._SynchronousWritePolicy;
        this._SynchronousWritePolicy = string;
        this._postSet(8, string2, string);
    }

    public String getCacheDirectory() {
        return this._CacheDirectory;
    }

    public boolean isCacheDirectorySet() {
        return this._isSet(9);
    }

    public void setCacheDirectory(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._CacheDirectory;
        this._CacheDirectory = string;
        this._postSet(9, string2, string);
    }

    public int getMinWindowBufferSize() {
        return this._MinWindowBufferSize;
    }

    public boolean isMinWindowBufferSizeSet() {
        return this._isSet(10);
    }

    public void setMinWindowBufferSize(int n) {
        LegalChecks.checkInRange((String)"MinWindowBufferSize", (long)n, (long)-1L, (long)0x40000000L);
        int n2 = this._MinWindowBufferSize;
        this._MinWindowBufferSize = n;
        this._postSet(10, n2, n);
    }

    public int getMaxWindowBufferSize() {
        return this._MaxWindowBufferSize;
    }

    public boolean isMaxWindowBufferSizeSet() {
        return this._isSet(11);
    }

    public void setMaxWindowBufferSize(int n) {
        LegalChecks.checkInRange((String)"MaxWindowBufferSize", (long)n, (long)-1L, (long)0x40000000L);
        int n2 = this._MaxWindowBufferSize;
        this._MaxWindowBufferSize = n;
        this._postSet(11, n2, n);
    }

    public int getIoBufferSize() {
        return this._IoBufferSize;
    }

    public boolean isIoBufferSizeSet() {
        return this._isSet(12);
    }

    public void setIoBufferSize(int n) {
        LegalChecks.checkInRange((String)"IoBufferSize", (long)n, (long)-1L, (long)0x4000000L);
        int n2 = this._IoBufferSize;
        this._IoBufferSize = n;
        this._postSet(12, n2, n);
    }

    public long getMaxFileSize() {
        return this._MaxFileSize;
    }

    public boolean isMaxFileSizeSet() {
        return this._isSet(13);
    }

    public void setMaxFileSize(long l) {
        LegalChecks.checkMin((String)"MaxFileSize", (long)l, (long)0x100000L);
        long l2 = this._MaxFileSize;
        this._MaxFileSize = l;
        this._postSet(13, l2, l);
    }

    public int getBlockSize() {
        return this._BlockSize;
    }

    public boolean isBlockSizeSet() {
        return this._isSet(14);
    }

    public void setBlockSize(int n) {
        LegalChecks.checkInRange((String)"BlockSize", (long)n, (long)-1L, (long)8192L);
        int n2 = this._BlockSize;
        this._BlockSize = n;
        this._postSet(14, n2, n);
    }

    public long getInitialSize() {
        return this._InitialSize;
    }

    public boolean isInitialSizeSet() {
        return this._isSet(15);
    }

    public void setInitialSize(long l) {
        LegalChecks.checkMin((String)"InitialSize", (long)l, (long)0L);
        long l2 = this._InitialSize;
        this._InitialSize = l;
        this._postSet(15, l2, l);
    }

    public boolean isFileLockingEnabled() {
        return this._FileLockingEnabled;
    }

    public boolean isFileLockingEnabledSet() {
        return this._isSet(16);
    }

    public void setFileLockingEnabled(boolean bl) {
        boolean bl2 = this._FileLockingEnabled;
        this._FileLockingEnabled = bl;
        this._postSet(16, bl2, bl);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 14;
        }
        try {
            switch (n) {
                case 14: {
                    this._BlockSize = -1;
                    if (bl) break;
                }
                case 9: {
                    this._CacheDirectory = null;
                    if (bl) break;
                }
                case 7: {
                    this._Directory = null;
                    if (bl) break;
                }
                case 15: {
                    this._InitialSize = 0L;
                    if (bl) break;
                }
                case 12: {
                    this._IoBufferSize = -1;
                    if (bl) break;
                }
                case 13: {
                    this._MaxFileSize = 0x50000000L;
                    if (bl) break;
                }
                case 11: {
                    this._MaxWindowBufferSize = -1;
                    if (bl) break;
                }
                case 10: {
                    this._MinWindowBufferSize = -1;
                    if (bl) break;
                }
                case 8: {
                    this._SynchronousWritePolicy = "Direct-Write";
                    if (bl) break;
                }
                case 16: {
                    this._FileLockingEnabled = true;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "GenericFileStore";
    }

    public void putValue(String string, Object object) {
        if (string.equals("BlockSize")) {
            int n = this._BlockSize;
            this._BlockSize = (Integer)object;
            this._postSet(14, n, this._BlockSize);
            return;
        }
        if (string.equals("CacheDirectory")) {
            String string2 = this._CacheDirectory;
            this._CacheDirectory = (String)object;
            this._postSet(9, string2, this._CacheDirectory);
            return;
        }
        if (string.equals("Directory")) {
            String string3 = this._Directory;
            this._Directory = (String)object;
            this._postSet(7, string3, this._Directory);
            return;
        }
        if (string.equals("FileLockingEnabled")) {
            boolean bl = this._FileLockingEnabled;
            this._FileLockingEnabled = (Boolean)object;
            this._postSet(16, bl, this._FileLockingEnabled);
            return;
        }
        if (string.equals("InitialSize")) {
            long l = this._InitialSize;
            this._InitialSize = (Long)object;
            this._postSet(15, l, this._InitialSize);
            return;
        }
        if (string.equals("IoBufferSize")) {
            int n = this._IoBufferSize;
            this._IoBufferSize = (Integer)object;
            this._postSet(12, n, this._IoBufferSize);
            return;
        }
        if (string.equals("MaxFileSize")) {
            long l = this._MaxFileSize;
            this._MaxFileSize = (Long)object;
            this._postSet(13, l, this._MaxFileSize);
            return;
        }
        if (string.equals("MaxWindowBufferSize")) {
            int n = this._MaxWindowBufferSize;
            this._MaxWindowBufferSize = (Integer)object;
            this._postSet(11, n, this._MaxWindowBufferSize);
            return;
        }
        if (string.equals("MinWindowBufferSize")) {
            int n = this._MinWindowBufferSize;
            this._MinWindowBufferSize = (Integer)object;
            this._postSet(10, n, this._MinWindowBufferSize);
            return;
        }
        if (string.equals("SynchronousWritePolicy")) {
            String string4 = this._SynchronousWritePolicy;
            this._SynchronousWritePolicy = (String)object;
            this._postSet(8, string4, this._SynchronousWritePolicy);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("BlockSize")) {
            return new Integer(this._BlockSize);
        }
        if (string.equals("CacheDirectory")) {
            return this._CacheDirectory;
        }
        if (string.equals("Directory")) {
            return this._Directory;
        }
        if (string.equals("FileLockingEnabled")) {
            return new Boolean(this._FileLockingEnabled);
        }
        if (string.equals("InitialSize")) {
            return new Long(this._InitialSize);
        }
        if (string.equals("IoBufferSize")) {
            return new Integer(this._IoBufferSize);
        }
        if (string.equals("MaxFileSize")) {
            return new Long(this._MaxFileSize);
        }
        if (string.equals("MaxWindowBufferSize")) {
            return new Integer(this._MaxWindowBufferSize);
        }
        if (string.equals("MinWindowBufferSize")) {
            return new Integer(this._MinWindowBufferSize);
        }
        if (string.equals("SynchronousWritePolicy")) {
            return this._SynchronousWritePolicy;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 10: {
                    if (!string.equals("block-size")) break;
                    return 14;
                }
                case 15: {
                    if (!string.equals("cache-directory")) break;
                    return 9;
                }
                case 9: {
                    if (!string.equals("directory")) break;
                    return 7;
                }
                case 12: {
                    if (!string.equals("initial-size")) break;
                    return 15;
                }
                case 14: {
                    if (!string.equals("io-buffer-size")) break;
                    return 12;
                }
                case 13: {
                    if (!string.equals("max-file-size")) break;
                    return 13;
                }
                case 22: {
                    if (string.equals("max-window-buffer-size")) {
                        return 11;
                    }
                    if (!string.equals("min-window-buffer-size")) break;
                    return 10;
                }
                case 24: {
                    if (!string.equals("synchronous-write-policy")) break;
                    return 8;
                }
                case 20: {
                    if (!string.equals("file-locking-enabled")) break;
                    return 16;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 14: {
                    return "block-size";
                }
                case 9: {
                    return "cache-directory";
                }
                case 7: {
                    return "directory";
                }
                case 15: {
                    return "initial-size";
                }
                case 12: {
                    return "io-buffer-size";
                }
                case 13: {
                    return "max-file-size";
                }
                case 11: {
                    return "max-window-buffer-size";
                }
                case 10: {
                    return "min-window-buffer-size";
                }
                case 8: {
                    return "synchronous-write-policy";
                }
                case 16: {
                    return "file-locking-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private GenericFileStoreMBeanImpl bean;

        protected Helper(GenericFileStoreMBeanImpl genericFileStoreMBeanImpl) {
            super(genericFileStoreMBeanImpl);
            this.bean = genericFileStoreMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 14: {
                    return "BlockSize";
                }
                case 9: {
                    return "CacheDirectory";
                }
                case 7: {
                    return "Directory";
                }
                case 15: {
                    return "InitialSize";
                }
                case 12: {
                    return "IoBufferSize";
                }
                case 13: {
                    return "MaxFileSize";
                }
                case 11: {
                    return "MaxWindowBufferSize";
                }
                case 10: {
                    return "MinWindowBufferSize";
                }
                case 8: {
                    return "SynchronousWritePolicy";
                }
                case 16: {
                    return "FileLockingEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("BlockSize")) {
                return 14;
            }
            if (string.equals("CacheDirectory")) {
                return 9;
            }
            if (string.equals("Directory")) {
                return 7;
            }
            if (string.equals("InitialSize")) {
                return 15;
            }
            if (string.equals("IoBufferSize")) {
                return 12;
            }
            if (string.equals("MaxFileSize")) {
                return 13;
            }
            if (string.equals("MaxWindowBufferSize")) {
                return 11;
            }
            if (string.equals("MinWindowBufferSize")) {
                return 10;
            }
            if (string.equals("SynchronousWritePolicy")) {
                return 8;
            }
            if (string.equals("FileLockingEnabled")) {
                return 16;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isBlockSizeSet()) {
                    stringBuffer.append("BlockSize");
                    stringBuffer.append(String.valueOf(this.bean.getBlockSize()));
                }
                if (this.bean.isCacheDirectorySet()) {
                    stringBuffer.append("CacheDirectory");
                    stringBuffer.append(String.valueOf(this.bean.getCacheDirectory()));
                }
                if (this.bean.isDirectorySet()) {
                    stringBuffer.append("Directory");
                    stringBuffer.append(String.valueOf(this.bean.getDirectory()));
                }
                if (this.bean.isInitialSizeSet()) {
                    stringBuffer.append("InitialSize");
                    stringBuffer.append(String.valueOf(this.bean.getInitialSize()));
                }
                if (this.bean.isIoBufferSizeSet()) {
                    stringBuffer.append("IoBufferSize");
                    stringBuffer.append(String.valueOf(this.bean.getIoBufferSize()));
                }
                if (this.bean.isMaxFileSizeSet()) {
                    stringBuffer.append("MaxFileSize");
                    stringBuffer.append(String.valueOf(this.bean.getMaxFileSize()));
                }
                if (this.bean.isMaxWindowBufferSizeSet()) {
                    stringBuffer.append("MaxWindowBufferSize");
                    stringBuffer.append(String.valueOf(this.bean.getMaxWindowBufferSize()));
                }
                if (this.bean.isMinWindowBufferSizeSet()) {
                    stringBuffer.append("MinWindowBufferSize");
                    stringBuffer.append(String.valueOf(this.bean.getMinWindowBufferSize()));
                }
                if (this.bean.isSynchronousWritePolicySet()) {
                    stringBuffer.append("SynchronousWritePolicy");
                    stringBuffer.append(String.valueOf(this.bean.getSynchronousWritePolicy()));
                }
                if (this.bean.isFileLockingEnabledSet()) {
                    stringBuffer.append("FileLockingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isFileLockingEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                GenericFileStoreMBeanImpl genericFileStoreMBeanImpl = (GenericFileStoreMBeanImpl)abstractDescriptorBean;
                this.computeDiff("BlockSize", this.bean.getBlockSize(), genericFileStoreMBeanImpl.getBlockSize(), true);
                this.computeDiff("CacheDirectory", this.bean.getCacheDirectory(), genericFileStoreMBeanImpl.getCacheDirectory(), true);
                this.computeDiff("Directory", this.bean.getDirectory(), genericFileStoreMBeanImpl.getDirectory(), false);
                this.computeDiff("InitialSize", this.bean.getInitialSize(), genericFileStoreMBeanImpl.getInitialSize(), true);
                this.computeDiff("IoBufferSize", this.bean.getIoBufferSize(), genericFileStoreMBeanImpl.getIoBufferSize(), true);
                this.computeDiff("MaxFileSize", this.bean.getMaxFileSize(), genericFileStoreMBeanImpl.getMaxFileSize(), true);
                this.computeDiff("MaxWindowBufferSize", this.bean.getMaxWindowBufferSize(), genericFileStoreMBeanImpl.getMaxWindowBufferSize(), true);
                this.computeDiff("MinWindowBufferSize", this.bean.getMinWindowBufferSize(), genericFileStoreMBeanImpl.getMinWindowBufferSize(), true);
                this.computeDiff("SynchronousWritePolicy", this.bean.getSynchronousWritePolicy(), genericFileStoreMBeanImpl.getSynchronousWritePolicy(), true);
                this.computeDiff("FileLockingEnabled", this.bean.isFileLockingEnabled(), genericFileStoreMBeanImpl.isFileLockingEnabled(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                GenericFileStoreMBeanImpl genericFileStoreMBeanImpl = (GenericFileStoreMBeanImpl)beanUpdateEvent.getSourceBean();
                GenericFileStoreMBeanImpl genericFileStoreMBeanImpl2 = (GenericFileStoreMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("BlockSize")) {
                    genericFileStoreMBeanImpl.setBlockSize(genericFileStoreMBeanImpl2.getBlockSize());
                    genericFileStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("CacheDirectory")) {
                    genericFileStoreMBeanImpl.setCacheDirectory(genericFileStoreMBeanImpl2.getCacheDirectory());
                    genericFileStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("Directory")) {
                    genericFileStoreMBeanImpl.setDirectory(genericFileStoreMBeanImpl2.getDirectory());
                    genericFileStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("InitialSize")) {
                    genericFileStoreMBeanImpl.setInitialSize(genericFileStoreMBeanImpl2.getInitialSize());
                    genericFileStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("IoBufferSize")) {
                    genericFileStoreMBeanImpl.setIoBufferSize(genericFileStoreMBeanImpl2.getIoBufferSize());
                    genericFileStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("MaxFileSize")) {
                    genericFileStoreMBeanImpl.setMaxFileSize(genericFileStoreMBeanImpl2.getMaxFileSize());
                    genericFileStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("MaxWindowBufferSize")) {
                    genericFileStoreMBeanImpl.setMaxWindowBufferSize(genericFileStoreMBeanImpl2.getMaxWindowBufferSize());
                    genericFileStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("MinWindowBufferSize")) {
                    genericFileStoreMBeanImpl.setMinWindowBufferSize(genericFileStoreMBeanImpl2.getMinWindowBufferSize());
                    genericFileStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("SynchronousWritePolicy")) {
                    genericFileStoreMBeanImpl.setSynchronousWritePolicy(genericFileStoreMBeanImpl2.getSynchronousWritePolicy());
                    genericFileStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("FileLockingEnabled")) {
                    genericFileStoreMBeanImpl.setFileLockingEnabled(genericFileStoreMBeanImpl2.isFileLockingEnabled());
                    genericFileStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                GenericFileStoreMBeanImpl genericFileStoreMBeanImpl = (GenericFileStoreMBeanImpl)abstractDescriptorBean;
                super.finishCopy(genericFileStoreMBeanImpl, bl, list);
                if ((list == null || !list.contains("BlockSize")) && this.bean.isBlockSizeSet()) {
                    genericFileStoreMBeanImpl.setBlockSize(this.bean.getBlockSize());
                }
                if ((list == null || !list.contains("CacheDirectory")) && this.bean.isCacheDirectorySet()) {
                    genericFileStoreMBeanImpl.setCacheDirectory(this.bean.getCacheDirectory());
                }
                if ((list == null || !list.contains("Directory")) && this.bean.isDirectorySet()) {
                    genericFileStoreMBeanImpl.setDirectory(this.bean.getDirectory());
                }
                if ((list == null || !list.contains("InitialSize")) && this.bean.isInitialSizeSet()) {
                    genericFileStoreMBeanImpl.setInitialSize(this.bean.getInitialSize());
                }
                if ((list == null || !list.contains("IoBufferSize")) && this.bean.isIoBufferSizeSet()) {
                    genericFileStoreMBeanImpl.setIoBufferSize(this.bean.getIoBufferSize());
                }
                if ((list == null || !list.contains("MaxFileSize")) && this.bean.isMaxFileSizeSet()) {
                    genericFileStoreMBeanImpl.setMaxFileSize(this.bean.getMaxFileSize());
                }
                if ((list == null || !list.contains("MaxWindowBufferSize")) && this.bean.isMaxWindowBufferSizeSet()) {
                    genericFileStoreMBeanImpl.setMaxWindowBufferSize(this.bean.getMaxWindowBufferSize());
                }
                if ((list == null || !list.contains("MinWindowBufferSize")) && this.bean.isMinWindowBufferSizeSet()) {
                    genericFileStoreMBeanImpl.setMinWindowBufferSize(this.bean.getMinWindowBufferSize());
                }
                if ((list == null || !list.contains("SynchronousWritePolicy")) && this.bean.isSynchronousWritePolicySet()) {
                    genericFileStoreMBeanImpl.setSynchronousWritePolicy(this.bean.getSynchronousWritePolicy());
                }
                if ((list == null || !list.contains("FileLockingEnabled")) && this.bean.isFileLockingEnabledSet()) {
                    genericFileStoreMBeanImpl.setFileLockingEnabled(this.bean.isFileLockingEnabled());
                }
                return genericFileStoreMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

