/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import weblogic.management.PrincipalInfo;
import weblogic.management.configuration.Principal;
import weblogic.management.configuration.RealmException;
import weblogic.management.configuration.RealmIterator;
import weblogic.management.configuration.User;
import weblogic.management.internal.RemoteRealmManager;

public class Group
extends Principal {
    private static final long serialVersionUID = 2891615425511196993L;
    private static boolean debug = false;
    private RemoteRealmManager helper;

    Group(String string, RemoteRealmManager remoteRealmManager) {
        super(string);
        this.helper = remoteRealmManager;
        if (debug) {
            this.trace("constructor");
        }
    }

    public RealmIterator getMembers() throws RealmException {
        if (debug) {
            this.trace("getMembers");
        }
        try {
            return new RealmIterator(this.helper.getMembers(this.getName()), new RealmIterator.ElementHandler(){

                public Object handle(Object object) {
                    PrincipalInfo principalInfo = (PrincipalInfo)object;
                    if (principalInfo.isGroup()) {
                        return new Group(principalInfo.getName(), Group.this.helper);
                    }
                    return new User(principalInfo.getName(), Group.this.helper);
                }
            });
        }
        catch (Throwable throwable) {
            throw new RealmException("Group.getMembers", throwable);
        }
    }

    public void addMember(Principal principal) throws RealmException {
        if (debug) {
            this.trace("addMember(" + principal.getName() + ")");
        }
        try {
            this.helper.addMember(this.getName(), principal.getName());
        }
        catch (Throwable throwable) {
            throw new RealmException("Group.addMember", throwable);
        }
    }

    public void removeMember(Principal principal) throws RealmException {
        if (debug) {
            this.trace("removeMember(" + principal.getName() + ")");
        }
        try {
            this.helper.removeMember(this.getName(), principal.getName());
        }
        catch (Throwable throwable) {
            throw new RealmException("Group.removeMember", throwable);
        }
    }

    private void trace(String string) {
        System.out.println("Group " + this.getName() + " " + string);
    }
}

