/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.IIOPMBean;
import weblogic.management.configuration.IIOPValidator;
import weblogic.utils.collections.CombinedIterator;

public class IIOPMBeanImpl
extends ConfigurationMBeanImpl
implements IIOPMBean,
Serializable {
    private int _CompleteMessageTimeout;
    private String _DefaultCharCodeset;
    private int _DefaultMinorVersion;
    private String _DefaultWideCharCodeset;
    private boolean _EnableIORServlet;
    private int _IdleConnectionTimeout;
    private String _LocationForwardPolicy;
    private int _MaxMessageSize;
    private String _SystemSecurity;
    private String _TxMechanism;
    private boolean _UseFullRepositoryIdList;
    private boolean _UseJavaSerialization;
    private boolean _UseLocateRequest;
    private boolean _UseSerialFormatVersion2;
    private boolean _UseStatefulAuthentication;
    private static SchemaHelper2 _schemaHelper;

    public IIOPMBeanImpl() {
        this._initializeProperty(-1);
    }

    public IIOPMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public int getIdleConnectionTimeout() {
        return this._IdleConnectionTimeout;
    }

    public boolean isIdleConnectionTimeoutSet() {
        return this._isSet(7);
    }

    public void setIdleConnectionTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkMin((String)"IdleConnectionTimeout", (int)n, (int)-1);
        int n2 = this._IdleConnectionTimeout;
        this._IdleConnectionTimeout = n;
        this._postSet(7, n2, n);
    }

    public int getCompleteMessageTimeout() {
        return this._CompleteMessageTimeout;
    }

    public boolean isCompleteMessageTimeoutSet() {
        return this._isSet(8);
    }

    public void setCompleteMessageTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"CompleteMessageTimeout", (long)n, (long)-1L, (long)480L);
        int n2 = this._CompleteMessageTimeout;
        this._CompleteMessageTimeout = n;
        this._postSet(8, n2, n);
    }

    public int getMaxMessageSize() {
        return this._MaxMessageSize;
    }

    public boolean isMaxMessageSizeSet() {
        return this._isSet(9);
    }

    public void setMaxMessageSize(int n) throws InvalidAttributeValueException, DistributedManagementException {
        IIOPValidator.validateMaxMessageSize(n);
        int n2 = this._MaxMessageSize;
        this._MaxMessageSize = n;
        this._postSet(9, n2, n);
    }

    public int getDefaultMinorVersion() {
        return this._DefaultMinorVersion;
    }

    public boolean isDefaultMinorVersionSet() {
        return this._isSet(10);
    }

    public void setDefaultMinorVersion(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"DefaultMinorVersion", (long)n, (long)0L, (long)2L);
        int n2 = this._DefaultMinorVersion;
        this._DefaultMinorVersion = n;
        this._postSet(10, n2, n);
    }

    public boolean getUseLocateRequest() {
        return this._UseLocateRequest;
    }

    public boolean isUseLocateRequestSet() {
        return this._isSet(11);
    }

    public void setUseLocateRequest(boolean bl) throws InvalidAttributeValueException, DistributedManagementException {
        boolean bl2 = this._UseLocateRequest;
        this._UseLocateRequest = bl;
        this._postSet(11, bl2, bl);
    }

    public String getTxMechanism() {
        return this._TxMechanism;
    }

    public boolean isTxMechanismSet() {
        return this._isSet(12);
    }

    public void setTxMechanism(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"OTS", "JTA", "OTSv11", "none"};
        string = LegalChecks.checkInEnum((String)"TxMechanism", (String)string, (String[])stringArray);
        String string2 = this._TxMechanism;
        this._TxMechanism = string;
        this._postSet(12, string2, string);
    }

    public String getLocationForwardPolicy() {
        return this._LocationForwardPolicy;
    }

    public boolean isLocationForwardPolicySet() {
        return this._isSet(13);
    }

    public void setLocationForwardPolicy(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"off", "failover", "round-robin", "random"};
        string = LegalChecks.checkInEnum((String)"LocationForwardPolicy", (String)string, (String[])stringArray);
        String string2 = this._LocationForwardPolicy;
        this._LocationForwardPolicy = string;
        this._postSet(13, string2, string);
    }

    public String getDefaultWideCharCodeset() {
        return this._DefaultWideCharCodeset;
    }

    public boolean isDefaultWideCharCodesetSet() {
        return this._isSet(14);
    }

    public void setDefaultWideCharCodeset(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"UCS-2", "UTF-16", "UTF-8", "UTF-16BE", "UTF-16LE"};
        string = LegalChecks.checkInEnum((String)"DefaultWideCharCodeset", (String)string, (String[])stringArray);
        String string2 = this._DefaultWideCharCodeset;
        this._DefaultWideCharCodeset = string;
        this._postSet(14, string2, string);
    }

    public String getDefaultCharCodeset() {
        return this._DefaultCharCodeset;
    }

    public boolean isDefaultCharCodesetSet() {
        return this._isSet(15);
    }

    public void setDefaultCharCodeset(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"US-ASCII", "UTF-8", "ISO-8859-1"};
        string = LegalChecks.checkInEnum((String)"DefaultCharCodeset", (String)string, (String[])stringArray);
        String string2 = this._DefaultCharCodeset;
        this._DefaultCharCodeset = string;
        this._postSet(15, string2, string);
    }

    public boolean getUseFullRepositoryIdList() {
        return this._UseFullRepositoryIdList;
    }

    public boolean isUseFullRepositoryIdListSet() {
        return this._isSet(16);
    }

    public void setUseFullRepositoryIdList(boolean bl) throws InvalidAttributeValueException, DistributedManagementException {
        boolean bl2 = this._UseFullRepositoryIdList;
        this._UseFullRepositoryIdList = bl;
        this._postSet(16, bl2, bl);
    }

    public boolean getUseStatefulAuthentication() {
        return this._UseStatefulAuthentication;
    }

    public boolean isUseStatefulAuthenticationSet() {
        return this._isSet(17);
    }

    public void setUseStatefulAuthentication(boolean bl) throws InvalidAttributeValueException, DistributedManagementException {
        boolean bl2 = this._UseStatefulAuthentication;
        this._UseStatefulAuthentication = bl;
        this._postSet(17, bl2, bl);
    }

    public boolean getUseSerialFormatVersion2() {
        return this._UseSerialFormatVersion2;
    }

    public boolean isUseSerialFormatVersion2Set() {
        return this._isSet(18);
    }

    public void setUseSerialFormatVersion2(boolean bl) throws InvalidAttributeValueException, DistributedManagementException {
        boolean bl2 = this._UseSerialFormatVersion2;
        this._UseSerialFormatVersion2 = bl;
        this._postSet(18, bl2, bl);
    }

    public boolean getEnableIORServlet() {
        return this._EnableIORServlet;
    }

    public boolean isEnableIORServletSet() {
        return this._isSet(19);
    }

    public void setEnableIORServlet(boolean bl) {
        boolean bl2 = this._EnableIORServlet;
        this._EnableIORServlet = bl;
        this._postSet(19, bl2, bl);
    }

    public boolean getUseJavaSerialization() {
        return this._UseJavaSerialization;
    }

    public boolean isUseJavaSerializationSet() {
        return this._isSet(20);
    }

    public void setUseJavaSerialization(boolean bl) throws InvalidAttributeValueException, DistributedManagementException {
        boolean bl2 = this._UseJavaSerialization;
        this._UseJavaSerialization = bl;
        this._postSet(20, bl2, bl);
    }

    public String getSystemSecurity() {
        return this._SystemSecurity;
    }

    public boolean isSystemSecuritySet() {
        return this._isSet(21);
    }

    public void setSystemSecurity(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"none", "supported", "required"};
        string = LegalChecks.checkInEnum((String)"SystemSecurity", (String)string, (String[])stringArray);
        String string2 = this._SystemSecurity;
        this._SystemSecurity = string;
        this._postSet(21, string2, string);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 8;
        }
        try {
            switch (n) {
                case 8: {
                    this._CompleteMessageTimeout = -1;
                    if (bl) break;
                }
                case 15: {
                    this._DefaultCharCodeset = "US-ASCII";
                    if (bl) break;
                }
                case 10: {
                    this._DefaultMinorVersion = 2;
                    if (bl) break;
                }
                case 14: {
                    this._DefaultWideCharCodeset = "UCS-2";
                    if (bl) break;
                }
                case 19: {
                    this._EnableIORServlet = false;
                    if (bl) break;
                }
                case 7: {
                    this._IdleConnectionTimeout = -1;
                    if (bl) break;
                }
                case 13: {
                    this._LocationForwardPolicy = "off";
                    if (bl) break;
                }
                case 9: {
                    this._MaxMessageSize = -1;
                    if (bl) break;
                }
                case 21: {
                    this._SystemSecurity = "supported";
                    if (bl) break;
                }
                case 12: {
                    this._TxMechanism = "OTS";
                    if (bl) break;
                }
                case 16: {
                    this._UseFullRepositoryIdList = false;
                    if (bl) break;
                }
                case 20: {
                    this._UseJavaSerialization = false;
                    if (bl) break;
                }
                case 11: {
                    this._UseLocateRequest = false;
                    if (bl) break;
                }
                case 18: {
                    this._UseSerialFormatVersion2 = false;
                    if (bl) break;
                }
                case 17: {
                    this._UseStatefulAuthentication = true;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "IIOP";
    }

    public void putValue(String string, Object object) {
        if (string.equals("CompleteMessageTimeout")) {
            int n = this._CompleteMessageTimeout;
            this._CompleteMessageTimeout = (Integer)object;
            this._postSet(8, n, this._CompleteMessageTimeout);
            return;
        }
        if (string.equals("DefaultCharCodeset")) {
            String string2 = this._DefaultCharCodeset;
            this._DefaultCharCodeset = (String)object;
            this._postSet(15, string2, this._DefaultCharCodeset);
            return;
        }
        if (string.equals("DefaultMinorVersion")) {
            int n = this._DefaultMinorVersion;
            this._DefaultMinorVersion = (Integer)object;
            this._postSet(10, n, this._DefaultMinorVersion);
            return;
        }
        if (string.equals("DefaultWideCharCodeset")) {
            String string3 = this._DefaultWideCharCodeset;
            this._DefaultWideCharCodeset = (String)object;
            this._postSet(14, string3, this._DefaultWideCharCodeset);
            return;
        }
        if (string.equals("EnableIORServlet")) {
            boolean bl = this._EnableIORServlet;
            this._EnableIORServlet = (Boolean)object;
            this._postSet(19, bl, this._EnableIORServlet);
            return;
        }
        if (string.equals("IdleConnectionTimeout")) {
            int n = this._IdleConnectionTimeout;
            this._IdleConnectionTimeout = (Integer)object;
            this._postSet(7, n, this._IdleConnectionTimeout);
            return;
        }
        if (string.equals("LocationForwardPolicy")) {
            String string4 = this._LocationForwardPolicy;
            this._LocationForwardPolicy = (String)object;
            this._postSet(13, string4, this._LocationForwardPolicy);
            return;
        }
        if (string.equals("MaxMessageSize")) {
            int n = this._MaxMessageSize;
            this._MaxMessageSize = (Integer)object;
            this._postSet(9, n, this._MaxMessageSize);
            return;
        }
        if (string.equals("SystemSecurity")) {
            String string5 = this._SystemSecurity;
            this._SystemSecurity = (String)object;
            this._postSet(21, string5, this._SystemSecurity);
            return;
        }
        if (string.equals("TxMechanism")) {
            String string6 = this._TxMechanism;
            this._TxMechanism = (String)object;
            this._postSet(12, string6, this._TxMechanism);
            return;
        }
        if (string.equals("UseFullRepositoryIdList")) {
            boolean bl = this._UseFullRepositoryIdList;
            this._UseFullRepositoryIdList = (Boolean)object;
            this._postSet(16, bl, this._UseFullRepositoryIdList);
            return;
        }
        if (string.equals("UseJavaSerialization")) {
            boolean bl = this._UseJavaSerialization;
            this._UseJavaSerialization = (Boolean)object;
            this._postSet(20, bl, this._UseJavaSerialization);
            return;
        }
        if (string.equals("UseLocateRequest")) {
            boolean bl = this._UseLocateRequest;
            this._UseLocateRequest = (Boolean)object;
            this._postSet(11, bl, this._UseLocateRequest);
            return;
        }
        if (string.equals("UseSerialFormatVersion2")) {
            boolean bl = this._UseSerialFormatVersion2;
            this._UseSerialFormatVersion2 = (Boolean)object;
            this._postSet(18, bl, this._UseSerialFormatVersion2);
            return;
        }
        if (string.equals("UseStatefulAuthentication")) {
            boolean bl = this._UseStatefulAuthentication;
            this._UseStatefulAuthentication = (Boolean)object;
            this._postSet(17, bl, this._UseStatefulAuthentication);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("CompleteMessageTimeout")) {
            return new Integer(this._CompleteMessageTimeout);
        }
        if (string.equals("DefaultCharCodeset")) {
            return this._DefaultCharCodeset;
        }
        if (string.equals("DefaultMinorVersion")) {
            return new Integer(this._DefaultMinorVersion);
        }
        if (string.equals("DefaultWideCharCodeset")) {
            return this._DefaultWideCharCodeset;
        }
        if (string.equals("EnableIORServlet")) {
            return new Boolean(this._EnableIORServlet);
        }
        if (string.equals("IdleConnectionTimeout")) {
            return new Integer(this._IdleConnectionTimeout);
        }
        if (string.equals("LocationForwardPolicy")) {
            return this._LocationForwardPolicy;
        }
        if (string.equals("MaxMessageSize")) {
            return new Integer(this._MaxMessageSize);
        }
        if (string.equals("SystemSecurity")) {
            return this._SystemSecurity;
        }
        if (string.equals("TxMechanism")) {
            return this._TxMechanism;
        }
        if (string.equals("UseFullRepositoryIdList")) {
            return new Boolean(this._UseFullRepositoryIdList);
        }
        if (string.equals("UseJavaSerialization")) {
            return new Boolean(this._UseJavaSerialization);
        }
        if (string.equals("UseLocateRequest")) {
            return new Boolean(this._UseLocateRequest);
        }
        if (string.equals("UseSerialFormatVersion2")) {
            return new Boolean(this._UseSerialFormatVersion2);
        }
        if (string.equals("UseStatefulAuthentication")) {
            return new Boolean(this._UseStatefulAuthentication);
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 24: {
                    if (!string.equals("complete-message-timeout")) break;
                    return 8;
                }
                case 20: {
                    if (!string.equals("default-char-codeset")) break;
                    return 15;
                }
                case 21: {
                    if (!string.equals("default-minor-version")) break;
                    return 10;
                }
                case 25: {
                    if (!string.equals("default-wide-char-codeset")) break;
                    return 14;
                }
                case 17: {
                    if (!string.equals("enableior-servlet")) break;
                    return 19;
                }
                case 23: {
                    if (string.equals("idle-connection-timeout")) {
                        return 7;
                    }
                    if (!string.equals("location-forward-policy")) break;
                    return 13;
                }
                case 16: {
                    if (!string.equals("max-message-size")) break;
                    return 9;
                }
                case 15: {
                    if (!string.equals("system-security")) break;
                    return 21;
                }
                case 12: {
                    if (!string.equals("tx-mechanism")) break;
                    return 12;
                }
                case 27: {
                    if (string.equals("use-full-repository-id-list")) {
                        return 16;
                    }
                    if (!string.equals("use-stateful-authentication")) break;
                    return 17;
                }
                case 22: {
                    if (!string.equals("use-java-serialization")) break;
                    return 20;
                }
                case 18: {
                    if (!string.equals("use-locate-request")) break;
                    return 11;
                }
                case 26: {
                    if (!string.equals("use-serial-format-version2")) break;
                    return 18;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 8: {
                    return "complete-message-timeout";
                }
                case 15: {
                    return "default-char-codeset";
                }
                case 10: {
                    return "default-minor-version";
                }
                case 14: {
                    return "default-wide-char-codeset";
                }
                case 19: {
                    return "enableior-servlet";
                }
                case 7: {
                    return "idle-connection-timeout";
                }
                case 13: {
                    return "location-forward-policy";
                }
                case 9: {
                    return "max-message-size";
                }
                case 21: {
                    return "system-security";
                }
                case 12: {
                    return "tx-mechanism";
                }
                case 16: {
                    return "use-full-repository-id-list";
                }
                case 20: {
                    return "use-java-serialization";
                }
                case 11: {
                    return "use-locate-request";
                }
                case 18: {
                    return "use-serial-format-version2";
                }
                case 17: {
                    return "use-stateful-authentication";
                }
            }
            return super.getElementName(n);
        }

        public boolean isConfigurable(int n) {
            switch (n) {
                case 8: {
                    return true;
                }
                case 15: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 19: {
                    return true;
                }
                case 7: {
                    return true;
                }
                case 13: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 21: {
                    return true;
                }
                case 12: {
                    return true;
                }
                case 16: {
                    return true;
                }
                case 20: {
                    return true;
                }
                case 11: {
                    return true;
                }
                case 18: {
                    return true;
                }
                case 17: {
                    return true;
                }
            }
            return super.isConfigurable(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private IIOPMBeanImpl bean;

        protected Helper(IIOPMBeanImpl iIOPMBeanImpl) {
            super(iIOPMBeanImpl);
            this.bean = iIOPMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 8: {
                    return "CompleteMessageTimeout";
                }
                case 15: {
                    return "DefaultCharCodeset";
                }
                case 10: {
                    return "DefaultMinorVersion";
                }
                case 14: {
                    return "DefaultWideCharCodeset";
                }
                case 19: {
                    return "EnableIORServlet";
                }
                case 7: {
                    return "IdleConnectionTimeout";
                }
                case 13: {
                    return "LocationForwardPolicy";
                }
                case 9: {
                    return "MaxMessageSize";
                }
                case 21: {
                    return "SystemSecurity";
                }
                case 12: {
                    return "TxMechanism";
                }
                case 16: {
                    return "UseFullRepositoryIdList";
                }
                case 20: {
                    return "UseJavaSerialization";
                }
                case 11: {
                    return "UseLocateRequest";
                }
                case 18: {
                    return "UseSerialFormatVersion2";
                }
                case 17: {
                    return "UseStatefulAuthentication";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("CompleteMessageTimeout")) {
                return 8;
            }
            if (string.equals("DefaultCharCodeset")) {
                return 15;
            }
            if (string.equals("DefaultMinorVersion")) {
                return 10;
            }
            if (string.equals("DefaultWideCharCodeset")) {
                return 14;
            }
            if (string.equals("EnableIORServlet")) {
                return 19;
            }
            if (string.equals("IdleConnectionTimeout")) {
                return 7;
            }
            if (string.equals("LocationForwardPolicy")) {
                return 13;
            }
            if (string.equals("MaxMessageSize")) {
                return 9;
            }
            if (string.equals("SystemSecurity")) {
                return 21;
            }
            if (string.equals("TxMechanism")) {
                return 12;
            }
            if (string.equals("UseFullRepositoryIdList")) {
                return 16;
            }
            if (string.equals("UseJavaSerialization")) {
                return 20;
            }
            if (string.equals("UseLocateRequest")) {
                return 11;
            }
            if (string.equals("UseSerialFormatVersion2")) {
                return 18;
            }
            if (string.equals("UseStatefulAuthentication")) {
                return 17;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isCompleteMessageTimeoutSet()) {
                    stringBuffer.append("CompleteMessageTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getCompleteMessageTimeout()));
                }
                if (this.bean.isDefaultCharCodesetSet()) {
                    stringBuffer.append("DefaultCharCodeset");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultCharCodeset()));
                }
                if (this.bean.isDefaultMinorVersionSet()) {
                    stringBuffer.append("DefaultMinorVersion");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultMinorVersion()));
                }
                if (this.bean.isDefaultWideCharCodesetSet()) {
                    stringBuffer.append("DefaultWideCharCodeset");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultWideCharCodeset()));
                }
                if (this.bean.isEnableIORServletSet()) {
                    stringBuffer.append("EnableIORServlet");
                    stringBuffer.append(String.valueOf(this.bean.getEnableIORServlet()));
                }
                if (this.bean.isIdleConnectionTimeoutSet()) {
                    stringBuffer.append("IdleConnectionTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getIdleConnectionTimeout()));
                }
                if (this.bean.isLocationForwardPolicySet()) {
                    stringBuffer.append("LocationForwardPolicy");
                    stringBuffer.append(String.valueOf(this.bean.getLocationForwardPolicy()));
                }
                if (this.bean.isMaxMessageSizeSet()) {
                    stringBuffer.append("MaxMessageSize");
                    stringBuffer.append(String.valueOf(this.bean.getMaxMessageSize()));
                }
                if (this.bean.isSystemSecuritySet()) {
                    stringBuffer.append("SystemSecurity");
                    stringBuffer.append(String.valueOf(this.bean.getSystemSecurity()));
                }
                if (this.bean.isTxMechanismSet()) {
                    stringBuffer.append("TxMechanism");
                    stringBuffer.append(String.valueOf(this.bean.getTxMechanism()));
                }
                if (this.bean.isUseFullRepositoryIdListSet()) {
                    stringBuffer.append("UseFullRepositoryIdList");
                    stringBuffer.append(String.valueOf(this.bean.getUseFullRepositoryIdList()));
                }
                if (this.bean.isUseJavaSerializationSet()) {
                    stringBuffer.append("UseJavaSerialization");
                    stringBuffer.append(String.valueOf(this.bean.getUseJavaSerialization()));
                }
                if (this.bean.isUseLocateRequestSet()) {
                    stringBuffer.append("UseLocateRequest");
                    stringBuffer.append(String.valueOf(this.bean.getUseLocateRequest()));
                }
                if (this.bean.isUseSerialFormatVersion2Set()) {
                    stringBuffer.append("UseSerialFormatVersion2");
                    stringBuffer.append(String.valueOf(this.bean.getUseSerialFormatVersion2()));
                }
                if (this.bean.isUseStatefulAuthenticationSet()) {
                    stringBuffer.append("UseStatefulAuthentication");
                    stringBuffer.append(String.valueOf(this.bean.getUseStatefulAuthentication()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                IIOPMBeanImpl iIOPMBeanImpl = (IIOPMBeanImpl)abstractDescriptorBean;
                this.computeDiff("CompleteMessageTimeout", this.bean.getCompleteMessageTimeout(), iIOPMBeanImpl.getCompleteMessageTimeout(), true);
                this.computeDiff("DefaultCharCodeset", this.bean.getDefaultCharCodeset(), iIOPMBeanImpl.getDefaultCharCodeset(), false);
                this.computeDiff("DefaultMinorVersion", this.bean.getDefaultMinorVersion(), iIOPMBeanImpl.getDefaultMinorVersion(), false);
                this.computeDiff("DefaultWideCharCodeset", this.bean.getDefaultWideCharCodeset(), iIOPMBeanImpl.getDefaultWideCharCodeset(), false);
                this.computeDiff("EnableIORServlet", this.bean.getEnableIORServlet(), iIOPMBeanImpl.getEnableIORServlet(), false);
                this.computeDiff("IdleConnectionTimeout", this.bean.getIdleConnectionTimeout(), iIOPMBeanImpl.getIdleConnectionTimeout(), true);
                this.computeDiff("LocationForwardPolicy", this.bean.getLocationForwardPolicy(), iIOPMBeanImpl.getLocationForwardPolicy(), false);
                this.computeDiff("MaxMessageSize", this.bean.getMaxMessageSize(), iIOPMBeanImpl.getMaxMessageSize(), false);
                this.computeDiff("SystemSecurity", this.bean.getSystemSecurity(), iIOPMBeanImpl.getSystemSecurity(), false);
                this.computeDiff("TxMechanism", this.bean.getTxMechanism(), iIOPMBeanImpl.getTxMechanism(), false);
                this.computeDiff("UseFullRepositoryIdList", this.bean.getUseFullRepositoryIdList(), iIOPMBeanImpl.getUseFullRepositoryIdList(), false);
                this.computeDiff("UseJavaSerialization", this.bean.getUseJavaSerialization(), iIOPMBeanImpl.getUseJavaSerialization(), true);
                this.computeDiff("UseLocateRequest", this.bean.getUseLocateRequest(), iIOPMBeanImpl.getUseLocateRequest(), false);
                this.computeDiff("UseSerialFormatVersion2", this.bean.getUseSerialFormatVersion2(), iIOPMBeanImpl.getUseSerialFormatVersion2(), false);
                this.computeDiff("UseStatefulAuthentication", this.bean.getUseStatefulAuthentication(), iIOPMBeanImpl.getUseStatefulAuthentication(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                IIOPMBeanImpl iIOPMBeanImpl = (IIOPMBeanImpl)beanUpdateEvent.getSourceBean();
                IIOPMBeanImpl iIOPMBeanImpl2 = (IIOPMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("CompleteMessageTimeout")) {
                    iIOPMBeanImpl.setCompleteMessageTimeout(iIOPMBeanImpl2.getCompleteMessageTimeout());
                    iIOPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("DefaultCharCodeset")) {
                    iIOPMBeanImpl.setDefaultCharCodeset(iIOPMBeanImpl2.getDefaultCharCodeset());
                    iIOPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("DefaultMinorVersion")) {
                    iIOPMBeanImpl.setDefaultMinorVersion(iIOPMBeanImpl2.getDefaultMinorVersion());
                    iIOPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("DefaultWideCharCodeset")) {
                    iIOPMBeanImpl.setDefaultWideCharCodeset(iIOPMBeanImpl2.getDefaultWideCharCodeset());
                    iIOPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("EnableIORServlet")) {
                    iIOPMBeanImpl.setEnableIORServlet(iIOPMBeanImpl2.getEnableIORServlet());
                    iIOPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                } else if (string.equals("IdleConnectionTimeout")) {
                    iIOPMBeanImpl.setIdleConnectionTimeout(iIOPMBeanImpl2.getIdleConnectionTimeout());
                    iIOPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("LocationForwardPolicy")) {
                    iIOPMBeanImpl.setLocationForwardPolicy(iIOPMBeanImpl2.getLocationForwardPolicy());
                    iIOPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("MaxMessageSize")) {
                    iIOPMBeanImpl.setMaxMessageSize(iIOPMBeanImpl2.getMaxMessageSize());
                    iIOPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("SystemSecurity")) {
                    iIOPMBeanImpl.setSystemSecurity(iIOPMBeanImpl2.getSystemSecurity());
                    iIOPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                } else if (string.equals("TxMechanism")) {
                    iIOPMBeanImpl.setTxMechanism(iIOPMBeanImpl2.getTxMechanism());
                    iIOPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("UseFullRepositoryIdList")) {
                    iIOPMBeanImpl.setUseFullRepositoryIdList(iIOPMBeanImpl2.getUseFullRepositoryIdList());
                    iIOPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else if (string.equals("UseJavaSerialization")) {
                    iIOPMBeanImpl.setUseJavaSerialization(iIOPMBeanImpl2.getUseJavaSerialization());
                    iIOPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                } else if (string.equals("UseLocateRequest")) {
                    iIOPMBeanImpl.setUseLocateRequest(iIOPMBeanImpl2.getUseLocateRequest());
                    iIOPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("UseSerialFormatVersion2")) {
                    iIOPMBeanImpl.setUseSerialFormatVersion2(iIOPMBeanImpl2.getUseSerialFormatVersion2());
                    iIOPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                } else if (string.equals("UseStatefulAuthentication")) {
                    iIOPMBeanImpl.setUseStatefulAuthentication(iIOPMBeanImpl2.getUseStatefulAuthentication());
                    iIOPMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                IIOPMBeanImpl iIOPMBeanImpl = (IIOPMBeanImpl)abstractDescriptorBean;
                super.finishCopy(iIOPMBeanImpl, bl, list);
                if ((list == null || !list.contains("CompleteMessageTimeout")) && this.bean.isCompleteMessageTimeoutSet()) {
                    iIOPMBeanImpl.setCompleteMessageTimeout(this.bean.getCompleteMessageTimeout());
                }
                if ((list == null || !list.contains("DefaultCharCodeset")) && this.bean.isDefaultCharCodesetSet()) {
                    iIOPMBeanImpl.setDefaultCharCodeset(this.bean.getDefaultCharCodeset());
                }
                if ((list == null || !list.contains("DefaultMinorVersion")) && this.bean.isDefaultMinorVersionSet()) {
                    iIOPMBeanImpl.setDefaultMinorVersion(this.bean.getDefaultMinorVersion());
                }
                if ((list == null || !list.contains("DefaultWideCharCodeset")) && this.bean.isDefaultWideCharCodesetSet()) {
                    iIOPMBeanImpl.setDefaultWideCharCodeset(this.bean.getDefaultWideCharCodeset());
                }
                if ((list == null || !list.contains("EnableIORServlet")) && this.bean.isEnableIORServletSet()) {
                    iIOPMBeanImpl.setEnableIORServlet(this.bean.getEnableIORServlet());
                }
                if ((list == null || !list.contains("IdleConnectionTimeout")) && this.bean.isIdleConnectionTimeoutSet()) {
                    iIOPMBeanImpl.setIdleConnectionTimeout(this.bean.getIdleConnectionTimeout());
                }
                if ((list == null || !list.contains("LocationForwardPolicy")) && this.bean.isLocationForwardPolicySet()) {
                    iIOPMBeanImpl.setLocationForwardPolicy(this.bean.getLocationForwardPolicy());
                }
                if ((list == null || !list.contains("MaxMessageSize")) && this.bean.isMaxMessageSizeSet()) {
                    iIOPMBeanImpl.setMaxMessageSize(this.bean.getMaxMessageSize());
                }
                if ((list == null || !list.contains("SystemSecurity")) && this.bean.isSystemSecuritySet()) {
                    iIOPMBeanImpl.setSystemSecurity(this.bean.getSystemSecurity());
                }
                if ((list == null || !list.contains("TxMechanism")) && this.bean.isTxMechanismSet()) {
                    iIOPMBeanImpl.setTxMechanism(this.bean.getTxMechanism());
                }
                if ((list == null || !list.contains("UseFullRepositoryIdList")) && this.bean.isUseFullRepositoryIdListSet()) {
                    iIOPMBeanImpl.setUseFullRepositoryIdList(this.bean.getUseFullRepositoryIdList());
                }
                if ((list == null || !list.contains("UseJavaSerialization")) && this.bean.isUseJavaSerializationSet()) {
                    iIOPMBeanImpl.setUseJavaSerialization(this.bean.getUseJavaSerialization());
                }
                if ((list == null || !list.contains("UseLocateRequest")) && this.bean.isUseLocateRequestSet()) {
                    iIOPMBeanImpl.setUseLocateRequest(this.bean.getUseLocateRequest());
                }
                if ((list == null || !list.contains("UseSerialFormatVersion2")) && this.bean.isUseSerialFormatVersion2Set()) {
                    iIOPMBeanImpl.setUseSerialFormatVersion2(this.bean.getUseSerialFormatVersion2());
                }
                if ((list == null || !list.contains("UseStatefulAuthentication")) && this.bean.isUseStatefulAuthenticationSet()) {
                    iIOPMBeanImpl.setUseStatefulAuthentication(this.bean.getUseStatefulAuthentication());
                }
                return iIOPMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

