/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BootstrapProperties;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorValidateException;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.beangen.StringHelper;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.DeploymentMBeanImpl;
import weblogic.management.configuration.JDBCConnectionPoolMBean;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.TargetMBeanImpl;
import weblogic.management.mbeans.custom.JDBCConnectionPool;
import weblogic.management.runtime.JDBCConnectionPoolRuntimeMBean;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class JDBCConnectionPoolMBeanImpl
extends DeploymentMBeanImpl
implements JDBCConnectionPoolMBean,
Serializable {
    private String _ACLName;
    private int _CapacityIncrement;
    private boolean _ConnLeakProfilingEnabled;
    private boolean _ConnProfilingEnabled;
    private int _ConnectionCreationRetryFrequencySeconds;
    private int _ConnectionReserveTimeoutSeconds;
    private int _CountOfRefreshFailuresTillDisable;
    private int _CountOfTestFailuresTillFlush;
    private boolean _CredentialMappingEnabled;
    private String _DriverName;
    private boolean _EnableResourceHealthMonitoring;
    private int _HighestNumUnavailable;
    private int _HighestNumWaiters;
    private boolean _IgnoreInUseConnectionsEnabled;
    private int _InactiveConnectionTimeoutSeconds;
    private String _InitSQL;
    private int _InitialCapacity;
    private JDBCConnectionPoolRuntimeMBean _JDBCConnectionPoolRuntime;
    private JDBCSystemResourceMBean _JDBCSystemResource;
    private int _JDBCXADebugLevel;
    private boolean _KeepLogicalConnOpenOnRelease;
    private boolean _KeepXAConnTillTxComplete;
    private int _LoginDelaySeconds;
    private int _MaxCapacity;
    private String _Name;
    private boolean _NeedTxCtxOnClose;
    private boolean _NewXAConnForCommit;
    private String _Password;
    private byte[] _PasswordEncrypted;
    private boolean _PrepStmtCacheProfilingEnabled;
    private int _PrepStmtCacheProfilingThreshold;
    private int _PreparedStatementCacheSize;
    private Properties _Properties;
    private boolean _RecoverOnlyOnce;
    private int _RefreshMinutes;
    private boolean _RemoveInfectedConnectionsEnabled;
    private boolean _RollbackLocalTxUponConnClose;
    private int _SecondsToTrustAnIdlePoolConnection;
    private int _ShrinkFrequencySeconds;
    private int _ShrinkPeriodMinutes;
    private boolean _ShrinkingEnabled;
    private int _SqlStmtMaxParamLength;
    private boolean _SqlStmtParamLoggingEnabled;
    private boolean _SqlStmtProfilingEnabled;
    private int _StatementCacheSize;
    private String _StatementCacheType;
    private int _StatementTimeout;
    private boolean _SupportsLocalTransaction;
    private TargetMBean[] _Targets;
    private boolean _TestConnectionsOnCreate;
    private boolean _TestConnectionsOnRelease;
    private boolean _TestConnectionsOnReserve;
    private int _TestFrequencySeconds;
    private int _TestStatementTimeout;
    private String _TestTableName;
    private String _URL;
    private boolean _XAEndOnlyOnce;
    private String _XAPassword;
    private byte[] _XAPasswordEncrypted;
    private int _XAPreparedStatementCacheSize;
    private int _XARetryDurationSeconds;
    private int _XARetryIntervalSeconds;
    private boolean _XASetTransactionTimeout;
    private int _XATransactionTimeout;
    private JDBCConnectionPool _customizer;
    private static SchemaHelper2 _schemaHelper;

    public JDBCConnectionPoolMBeanImpl() {
        try {
            this._customizer = new JDBCConnectionPool(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public JDBCConnectionPoolMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new JDBCConnectionPool(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public TargetMBean[] getTargets() {
        return this._customizer.getTargets();
    }

    public String getTargetsAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getTargets());
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isTargetsSet() {
        return this._isSet(7);
    }

    public void setJDBCSystemResource(JDBCSystemResourceMBean jDBCSystemResourceMBean) {
        JDBCSystemResourceMBean jDBCSystemResourceMBean2 = this.getJDBCSystemResource();
        this._customizer.setJDBCSystemResource(jDBCSystemResourceMBean);
        this._postSet(9, jDBCSystemResourceMBean2, jDBCSystemResourceMBean);
    }

    public void setTargetsAsString(String string) {
        if (string == null || string.length() == 0) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._initializeProperty(7);
            this._postSet(7, targetMBeanArray, this._Targets);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._Targets);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, TargetMBean.class, new ReferenceManager.Resolver(this, 7){

                    public void resolveReference(Object object) {
                        try {
                            JDBCConnectionPoolMBeanImpl.this.addTarget((TargetMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (TargetMBean targetMBean : this._Targets) {
                    if (!string2.equals(targetMBean.getName())) continue;
                    try {
                        this.removeTarget(targetMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public JDBCSystemResourceMBean getJDBCSystemResource() {
        return this._customizer.getJDBCSystemResource();
    }

    public String getJDBCSystemResourceAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getJDBCSystemResource();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isJDBCSystemResourceSet() {
        return this._isSet(9);
    }

    public void setJDBCSystemResourceAsString(String string) {
        if (string == null || string.length() == 0) {
            JDBCSystemResourceMBean jDBCSystemResourceMBean = this._JDBCSystemResource;
            this._initializeProperty(9);
            this._postSet(9, jDBCSystemResourceMBean, this._JDBCSystemResource);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, JDBCSystemResourceMBean.class, new ReferenceManager.Resolver(this, 9){

                public void resolveReference(Object object) {
                    try {
                        JDBCConnectionPoolMBeanImpl.this.setJDBCSystemResource((JDBCSystemResourceMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setTargets(TargetMBean[] targetMBeanArray) throws InvalidAttributeValueException, DistributedManagementException {
        targetMBeanArray = targetMBeanArray == null ? new TargetMBeanImpl[]{} : targetMBeanArray;
        targetMBeanArray = (TargetMBean[])this._getHelper()._cleanAndValidateArray((Object)targetMBeanArray, TargetMBean.class);
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            if (targetMBeanArray[i] == null) continue;
            ResolvedReference resolvedReference = new ResolvedReference(this, 7, (AbstractDescriptorBean)targetMBeanArray[i]){

                protected Object getPropertyValue() {
                    return JDBCConnectionPoolMBeanImpl.this.getTargets();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)targetMBeanArray[i], resolvedReference);
        }
        TargetMBean[] targetMBeanArray2 = this.getTargets();
        this._customizer.setTargets(targetMBeanArray);
        this._postSet(7, targetMBeanArray2, targetMBeanArray);
    }

    public boolean addTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        this._getHelper()._ensureNonNull((Object)targetMBean);
        if (!((AbstractDescriptorBean)targetMBean).isChildProperty((DescriptorBean)this, 7)) {
            TargetMBean[] targetMBeanArray = (TargetMBean[])this._getHelper()._extendArray((Object)this.getTargets(), TargetMBean.class, (Object)targetMBean);
            try {
                this.setTargets(targetMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public boolean isPrepStmtCacheProfilingEnabled() {
        return this._customizer.isPrepStmtCacheProfilingEnabled();
    }

    public boolean isPrepStmtCacheProfilingEnabledSet() {
        return this._isSet(10);
    }

    public boolean removeTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        TargetMBean[] targetMBeanArray = this.getTargets();
        TargetMBean[] targetMBeanArray2 = (TargetMBean[])this._getHelper()._removeElement((Object)targetMBeanArray, TargetMBean.class, (Object)targetMBean);
        if (targetMBeanArray2.length != targetMBeanArray.length) {
            try {
                this.setTargets(targetMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public void setPrepStmtCacheProfilingEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.isPrepStmtCacheProfilingEnabled();
        this._customizer.setPrepStmtCacheProfilingEnabled(bl);
        this._postSet(10, bl2, bl);
    }

    public int getPrepStmtCacheProfilingThreshold() {
        return this._customizer.getPrepStmtCacheProfilingThreshold();
    }

    public boolean isPrepStmtCacheProfilingThresholdSet() {
        return this._isSet(11);
    }

    public void setPrepStmtCacheProfilingThreshold(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"PrepStmtCacheProfilingThreshold", (int)n, (int)10);
        int n2 = this.getPrepStmtCacheProfilingThreshold();
        this._customizer.setPrepStmtCacheProfilingThreshold(n);
        this._postSet(11, n2, n);
    }

    public void setConnLeakProfilingEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.isConnLeakProfilingEnabled();
        this._customizer.setConnLeakProfilingEnabled(bl);
        this._postSet(12, bl2, bl);
    }

    public boolean isConnLeakProfilingEnabled() {
        return this._customizer.isConnLeakProfilingEnabled();
    }

    public boolean isConnLeakProfilingEnabledSet() {
        return this._isSet(12);
    }

    public void setConnProfilingEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.isConnProfilingEnabled();
        this._customizer.setConnProfilingEnabled(bl);
        this._postSet(13, bl2, bl);
    }

    public boolean isConnProfilingEnabled() {
        return this._customizer.isConnProfilingEnabled();
    }

    public boolean isConnProfilingEnabledSet() {
        return this._isSet(13);
    }

    public boolean isSqlStmtProfilingEnabled() {
        return this._customizer.isSqlStmtProfilingEnabled();
    }

    public boolean isSqlStmtProfilingEnabledSet() {
        return this._isSet(14);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void setSqlStmtProfilingEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.isSqlStmtProfilingEnabled();
        this._customizer.setSqlStmtProfilingEnabled(bl);
        this._postSet(14, bl2, bl);
    }

    public boolean isSqlStmtParamLoggingEnabled() {
        return this._customizer.isSqlStmtParamLoggingEnabled();
    }

    public boolean isSqlStmtParamLoggingEnabledSet() {
        return this._isSet(15);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setSqlStmtParamLoggingEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.isSqlStmtParamLoggingEnabled();
        this._customizer.setSqlStmtParamLoggingEnabled(bl);
        this._postSet(15, bl2, bl);
    }

    public int getSqlStmtMaxParamLength() {
        return this._customizer.getSqlStmtMaxParamLength();
    }

    public boolean isSqlStmtMaxParamLengthSet() {
        return this._isSet(16);
    }

    public void setSqlStmtMaxParamLength(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"SqlStmtMaxParamLength", (int)n, (int)1);
        int n2 = this.getSqlStmtMaxParamLength();
        this._customizer.setSqlStmtMaxParamLength(n);
        this._postSet(16, n2, n);
    }

    public String getACLName() {
        return this._ACLName;
    }

    public boolean isACLNameSet() {
        return this._isSet(17);
    }

    public void setACLName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ACLName;
        this._ACLName = string;
        this._postSet(17, string2, string);
    }

    public String getURL() {
        return this._customizer.getURL();
    }

    public boolean isURLSet() {
        return this._isSet(18);
    }

    public void setURL(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this.getURL();
        this._customizer.setURL(string);
        this._postSet(18, string2, string);
    }

    public String getDriverName() {
        return this._customizer.getDriverName();
    }

    public boolean isDriverNameSet() {
        return this._isSet(19);
    }

    public void setDriverName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this.getDriverName();
        this._customizer.setDriverName(string);
        this._postSet(19, string2, string);
    }

    public Properties getProperties() {
        return this._customizer.getProperties();
    }

    public String getPropertiesAsString() {
        return StringHelper.objectToString((Object)this.getProperties());
    }

    public boolean isPropertiesSet() {
        return this._isSet(20);
    }

    public void setPropertiesAsString(String string) {
        try {
            this.setProperties(StringHelper.stringToProperties((String)string));
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public void setProperties(Properties properties) throws InvalidAttributeValueException {
        Properties properties2 = this.getProperties();
        this._customizer.setProperties(properties);
        this._postSet(20, properties2, properties);
    }

    public int getLoginDelaySeconds() {
        return this._customizer.getLoginDelaySeconds();
    }

    public boolean isLoginDelaySecondsSet() {
        return this._isSet(21);
    }

    public void setLoginDelaySeconds(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"LoginDelaySeconds", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this.getLoginDelaySeconds();
        this._customizer.setLoginDelaySeconds(n);
        this._postSet(21, n2, n);
    }

    public int getSecondsToTrustAnIdlePoolConnection() {
        return this._customizer.getSecondsToTrustAnIdlePoolConnection();
    }

    public boolean isSecondsToTrustAnIdlePoolConnectionSet() {
        return this._isSet(22);
    }

    public void setSecondsToTrustAnIdlePoolConnection(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"SecondsToTrustAnIdlePoolConnection", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this.getSecondsToTrustAnIdlePoolConnection();
        this._customizer.setSecondsToTrustAnIdlePoolConnection(n);
        this._postSet(22, n2, n);
    }

    public int getInitialCapacity() {
        return this._customizer.getInitialCapacity();
    }

    public boolean isInitialCapacitySet() {
        return this._isSet(23);
    }

    public void setInitialCapacity(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"InitialCapacity", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this.getInitialCapacity();
        this._customizer.setInitialCapacity(n);
        this._postSet(23, n2, n);
    }

    public int getMaxCapacity() {
        return this._customizer.getMaxCapacity();
    }

    public boolean isMaxCapacitySet() {
        return this._isSet(24);
    }

    public void setMaxCapacity(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"MaxCapacity", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this.getMaxCapacity();
        this._customizer.setMaxCapacity(n);
        this._postSet(24, n2, n);
    }

    public int getCapacityIncrement() {
        return this._customizer.getCapacityIncrement();
    }

    public boolean isCapacityIncrementSet() {
        return this._isSet(25);
    }

    public void setCapacityIncrement(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"CapacityIncrement", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this.getCapacityIncrement();
        this._customizer.setCapacityIncrement(n);
        this._postSet(25, n2, n);
    }

    public boolean isShrinkingEnabled() {
        return this._customizer.isShrinkingEnabled();
    }

    public boolean isShrinkingEnabledSet() {
        return this._isSet(26);
    }

    public void setShrinkingEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.isShrinkingEnabled();
        this._customizer.setShrinkingEnabled(bl);
        this._postSet(26, bl2, bl);
    }

    public int getShrinkPeriodMinutes() {
        return this._customizer.getShrinkPeriodMinutes();
    }

    public boolean isShrinkPeriodMinutesSet() {
        return this._isSet(27);
    }

    public void setShrinkPeriodMinutes(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ShrinkPeriodMinutes", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this.getShrinkPeriodMinutes();
        this._customizer.setShrinkPeriodMinutes(n);
        this._postSet(27, n2, n);
    }

    public int getShrinkFrequencySeconds() {
        return this._customizer.getShrinkFrequencySeconds();
    }

    public boolean isShrinkFrequencySecondsSet() {
        return this._isSet(28);
    }

    public void setShrinkFrequencySeconds(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ShrinkFrequencySeconds", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this.getShrinkFrequencySeconds();
        this._customizer.setShrinkFrequencySeconds(n);
        this._postSet(28, n2, n);
    }

    public int getRefreshMinutes() {
        return this._RefreshMinutes;
    }

    public boolean isRefreshMinutesSet() {
        return this._isSet(29);
    }

    public void setRefreshMinutes(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"RefreshMinutes", (long)n, (long)0L, (long)0x2222222L);
        int n2 = this._RefreshMinutes;
        this._RefreshMinutes = n;
        this._postSet(29, n2, n);
    }

    public int getTestFrequencySeconds() {
        return this._customizer.getTestFrequencySeconds();
    }

    public boolean isTestFrequencySecondsSet() {
        return this._isSet(30);
    }

    public void setTestFrequencySeconds(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"TestFrequencySeconds", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this.getTestFrequencySeconds();
        this._customizer.setTestFrequencySeconds(n);
        this._postSet(30, n2, n);
    }

    public String getTestTableName() {
        return this._customizer.getTestTableName();
    }

    public boolean isTestTableNameSet() {
        return this._isSet(31);
    }

    public void setTestTableName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this.getTestTableName();
        this._customizer.setTestTableName(string);
        this._postSet(31, string2, string);
    }

    public void setTestConnectionsOnReserve(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.getTestConnectionsOnReserve();
        this._customizer.setTestConnectionsOnReserve(bl);
        this._postSet(32, bl2, bl);
    }

    public boolean getTestConnectionsOnReserve() {
        return this._customizer.getTestConnectionsOnReserve();
    }

    public boolean isTestConnectionsOnReserveSet() {
        return this._isSet(32);
    }

    public void setTestConnectionsOnRelease(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.getTestConnectionsOnRelease();
        this._customizer.setTestConnectionsOnRelease(bl);
        this._postSet(33, bl2, bl);
    }

    public boolean getTestConnectionsOnRelease() {
        return this._customizer.getTestConnectionsOnRelease();
    }

    public boolean isTestConnectionsOnReleaseSet() {
        return this._isSet(33);
    }

    public void setTestConnectionsOnCreate(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.getTestConnectionsOnCreate();
        this._customizer.setTestConnectionsOnCreate(bl);
        this._postSet(34, bl2, bl);
    }

    public boolean getTestConnectionsOnCreate() {
        return this._customizer.getTestConnectionsOnCreate();
    }

    public boolean isTestConnectionsOnCreateSet() {
        return this._isSet(34);
    }

    public JDBCConnectionPoolRuntimeMBean getJDBCConnectionPoolRuntime() {
        return this._JDBCConnectionPoolRuntime;
    }

    public boolean isJDBCConnectionPoolRuntimeSet() {
        return this._isSet(35);
    }

    public void setJDBCConnectionPoolRuntime(JDBCConnectionPoolRuntimeMBean jDBCConnectionPoolRuntimeMBean) throws InvalidAttributeValueException {
        this._JDBCConnectionPoolRuntime = jDBCConnectionPoolRuntimeMBean;
    }

    public String getPassword() {
        byte[] byArray = this.getPasswordEncrypted();
        return byArray == null ? null : this._decrypt("Password", byArray);
    }

    public boolean isPasswordSet() {
        return this.isPasswordEncryptedSet();
    }

    public void setPassword(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setPasswordEncrypted(string == null ? null : this._encrypt("Password", string));
    }

    public byte[] getPasswordEncrypted() {
        return this._customizer.getPasswordEncrypted();
    }

    public String getPasswordEncryptedAsString() {
        byte[] byArray = this.getPasswordEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isPasswordEncryptedSet() {
        return this._isSet(37);
    }

    public void setPasswordEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setPasswordEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public String getXAPassword() {
        byte[] byArray = this.getXAPasswordEncrypted();
        return byArray == null ? null : this._decrypt("XAPassword", byArray);
    }

    public boolean isXAPasswordSet() {
        return this.isXAPasswordEncryptedSet();
    }

    public void setXAPassword(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setXAPasswordEncrypted(string == null ? null : this._encrypt("XAPassword", string));
    }

    public byte[] getXAPasswordEncrypted() {
        return this._getHelper()._cloneArray(this._XAPasswordEncrypted);
    }

    public String getXAPasswordEncryptedAsString() {
        byte[] byArray = this.getXAPasswordEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isXAPasswordEncryptedSet() {
        return this._isSet(39);
    }

    public void setXAPasswordEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setXAPasswordEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public int getJDBCXADebugLevel() {
        return this._customizer.getJDBCXADebugLevel();
    }

    public boolean isJDBCXADebugLevelSet() {
        return this._isSet(40);
    }

    public void setJDBCXADebugLevel(int n) throws InvalidAttributeValueException {
        int n2 = this.getJDBCXADebugLevel();
        this._customizer.setJDBCXADebugLevel(n);
        this._postSet(40, n2, n);
    }

    public boolean getSupportsLocalTransaction() {
        return this._customizer.getSupportsLocalTransaction();
    }

    public boolean isSupportsLocalTransactionSet() {
        return this._isSet(41);
    }

    public void setSupportsLocalTransaction(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.getSupportsLocalTransaction();
        this._customizer.setSupportsLocalTransaction(bl);
        this._postSet(41, bl2, bl);
    }

    public boolean getKeepXAConnTillTxComplete() {
        return this._customizer.getKeepXAConnTillTxComplete();
    }

    public boolean isKeepXAConnTillTxCompleteSet() {
        return this._isSet(42);
    }

    public void setKeepXAConnTillTxComplete(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.getKeepXAConnTillTxComplete();
        this._customizer.setKeepXAConnTillTxComplete(bl);
        this._postSet(42, bl2, bl);
    }

    public boolean getNeedTxCtxOnClose() {
        return this._customizer.getNeedTxCtxOnClose();
    }

    public boolean isNeedTxCtxOnCloseSet() {
        return this._isSet(43);
    }

    public void setNeedTxCtxOnClose(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.getNeedTxCtxOnClose();
        this._customizer.setNeedTxCtxOnClose(bl);
        this._postSet(43, bl2, bl);
    }

    public boolean getXAEndOnlyOnce() {
        return this._customizer.getXAEndOnlyOnce();
    }

    public boolean isXAEndOnlyOnceSet() {
        return this._isSet(44);
    }

    public void setXAEndOnlyOnce(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.getXAEndOnlyOnce();
        this._customizer.setXAEndOnlyOnce(bl);
        this._postSet(44, bl2, bl);
    }

    public boolean getNewXAConnForCommit() {
        return this._customizer.getNewXAConnForCommit();
    }

    public boolean isNewXAConnForCommitSet() {
        return this._isSet(45);
    }

    public void setNewXAConnForCommit(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.getNewXAConnForCommit();
        this._customizer.setNewXAConnForCommit(bl);
        this._postSet(45, bl2, bl);
    }

    public boolean getKeepLogicalConnOpenOnRelease() {
        return this._customizer.getKeepLogicalConnOpenOnRelease();
    }

    public boolean isKeepLogicalConnOpenOnReleaseSet() {
        return this._isSet(46);
    }

    public void setKeepLogicalConnOpenOnRelease(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.getKeepLogicalConnOpenOnRelease();
        this._customizer.setKeepLogicalConnOpenOnRelease(bl);
        this._postSet(46, bl2, bl);
    }

    public int getXAPreparedStatementCacheSize() {
        return this._customizer.getXAPreparedStatementCacheSize();
    }

    public boolean isXAPreparedStatementCacheSizeSet() {
        return this._isSet(47);
    }

    public void setXAPreparedStatementCacheSize(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"XAPreparedStatementCacheSize", (long)n, (long)-1L, (long)1024L);
        int n2 = this.getXAPreparedStatementCacheSize();
        this._customizer.setXAPreparedStatementCacheSize(n);
        this._postSet(47, n2, n);
    }

    public boolean getEnableResourceHealthMonitoring() {
        return this._customizer.getEnableResourceHealthMonitoring();
    }

    public boolean isEnableResourceHealthMonitoringSet() {
        return this._isSet(48);
    }

    public void setEnableResourceHealthMonitoring(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.getEnableResourceHealthMonitoring();
        this._customizer.setEnableResourceHealthMonitoring(bl);
        this._postSet(48, bl2, bl);
    }

    public boolean getRecoverOnlyOnce() {
        return this._customizer.getRecoverOnlyOnce();
    }

    public boolean isRecoverOnlyOnceSet() {
        return this._isSet(49);
    }

    public void setRecoverOnlyOnce(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.getRecoverOnlyOnce();
        this._customizer.setRecoverOnlyOnce(bl);
        this._postSet(49, bl2, bl);
    }

    public boolean getXASetTransactionTimeout() {
        return this._customizer.getXASetTransactionTimeout();
    }

    public boolean isXASetTransactionTimeoutSet() {
        return this._isSet(50);
    }

    public void setXASetTransactionTimeout(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.getXASetTransactionTimeout();
        this._customizer.setXASetTransactionTimeout(bl);
        this._postSet(50, bl2, bl);
    }

    public int getXATransactionTimeout() {
        return this._XATransactionTimeout;
    }

    public boolean isXATransactionTimeoutSet() {
        return this._isSet(51);
    }

    public void setXATransactionTimeout(int n) throws InvalidAttributeValueException {
        int n2 = this._XATransactionTimeout;
        this._XATransactionTimeout = n;
        this._postSet(51, n2, n);
    }

    public int getXARetryDurationSeconds() {
        return this._XARetryDurationSeconds;
    }

    public boolean isXARetryDurationSecondsSet() {
        return this._isSet(52);
    }

    public void setXARetryDurationSeconds(int n) throws InvalidAttributeValueException {
        int n2 = this._XARetryDurationSeconds;
        this._XARetryDurationSeconds = n;
        this._postSet(52, n2, n);
    }

    public int getXARetryIntervalSeconds() {
        return this._XARetryIntervalSeconds;
    }

    public boolean isXARetryIntervalSecondsSet() {
        return this._isSet(53);
    }

    public void setXARetryIntervalSeconds(int n) throws InvalidAttributeValueException {
        int n2 = this._XARetryIntervalSeconds;
        this._XARetryIntervalSeconds = n;
        this._postSet(53, n2, n);
    }

    public void setPreparedStatementCacheSize(int n) {
        LegalChecks.checkInRange((String)"PreparedStatementCacheSize", (long)n, (long)-1L, (long)1024L);
        int n2 = this.getPreparedStatementCacheSize();
        try {
            this._customizer.setPreparedStatementCacheSize(n);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new UndeclaredThrowableException(invalidAttributeValueException);
        }
        this._postSet(54, n2, n);
    }

    public int getPreparedStatementCacheSize() {
        return this._customizer.getPreparedStatementCacheSize();
    }

    public boolean isPreparedStatementCacheSizeSet() {
        return this._isSet(54);
    }

    public void setConnectionReserveTimeoutSeconds(int n) {
        LegalChecks.checkInRange((String)"ConnectionReserveTimeoutSeconds", (long)n, (long)-1L, (long)Integer.MAX_VALUE);
        int n2 = this.getConnectionReserveTimeoutSeconds();
        try {
            this._customizer.setConnectionReserveTimeoutSeconds(n);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new UndeclaredThrowableException(invalidAttributeValueException);
        }
        this._postSet(55, n2, n);
    }

    public int getConnectionReserveTimeoutSeconds() {
        return this._customizer.getConnectionReserveTimeoutSeconds();
    }

    public boolean isConnectionReserveTimeoutSecondsSet() {
        return this._isSet(55);
    }

    public void setConnectionCreationRetryFrequencySeconds(int n) {
        LegalChecks.checkInRange((String)"ConnectionCreationRetryFrequencySeconds", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this.getConnectionCreationRetryFrequencySeconds();
        try {
            this._customizer.setConnectionCreationRetryFrequencySeconds(n);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new UndeclaredThrowableException(invalidAttributeValueException);
        }
        this._postSet(56, n2, n);
    }

    public int getConnectionCreationRetryFrequencySeconds() {
        return this._customizer.getConnectionCreationRetryFrequencySeconds();
    }

    public boolean isConnectionCreationRetryFrequencySecondsSet() {
        return this._isSet(56);
    }

    public void setInactiveConnectionTimeoutSeconds(int n) {
        LegalChecks.checkInRange((String)"InactiveConnectionTimeoutSeconds", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this.getInactiveConnectionTimeoutSeconds();
        try {
            this._customizer.setInactiveConnectionTimeoutSeconds(n);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new UndeclaredThrowableException(invalidAttributeValueException);
        }
        this._postSet(57, n2, n);
    }

    public int getInactiveConnectionTimeoutSeconds() {
        return this._customizer.getInactiveConnectionTimeoutSeconds();
    }

    public boolean isInactiveConnectionTimeoutSecondsSet() {
        return this._isSet(57);
    }

    public void setHighestNumWaiters(int n) {
        LegalChecks.checkInRange((String)"HighestNumWaiters", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this.getHighestNumWaiters();
        try {
            this._customizer.setHighestNumWaiters(n);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new UndeclaredThrowableException(invalidAttributeValueException);
        }
        this._postSet(58, n2, n);
    }

    public int getHighestNumWaiters() {
        return this._customizer.getHighestNumWaiters();
    }

    public boolean isHighestNumWaitersSet() {
        return this._isSet(58);
    }

    public void setHighestNumUnavailable(int n) {
        LegalChecks.checkInRange((String)"HighestNumUnavailable", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this.getHighestNumUnavailable();
        try {
            this._customizer.setHighestNumUnavailable(n);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new UndeclaredThrowableException(invalidAttributeValueException);
        }
        this._postSet(59, n2, n);
    }

    public int getHighestNumUnavailable() {
        return this._customizer.getHighestNumUnavailable();
    }

    public boolean isHighestNumUnavailableSet() {
        return this._isSet(59);
    }

    public void setInitSQL(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this.getInitSQL();
        this._customizer.setInitSQL(string);
        this._postSet(60, string2, string);
    }

    public String getInitSQL() {
        return this._customizer.getInitSQL();
    }

    public boolean isInitSQLSet() {
        return this._isSet(60);
    }

    public void setStatementCacheSize(int n) {
        LegalChecks.checkInRange((String)"StatementCacheSize", (long)n, (long)0L, (long)1024L);
        int n2 = this.getStatementCacheSize();
        this._customizer.setStatementCacheSize(n);
        this._postSet(61, n2, n);
    }

    public int getStatementCacheSize() {
        return this._customizer.getStatementCacheSize();
    }

    public boolean isStatementCacheSizeSet() {
        return this._isSet(61);
    }

    public void setStatementCacheType(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"LRU", "FIXED"};
        string = LegalChecks.checkInEnum((String)"StatementCacheType", (String)string, (String[])stringArray);
        String string2 = this.getStatementCacheType();
        this._customizer.setStatementCacheType(string);
        this._postSet(62, string2, string);
    }

    public String getStatementCacheType() {
        return this._customizer.getStatementCacheType();
    }

    public boolean isStatementCacheTypeSet() {
        return this._isSet(62);
    }

    public void setRemoveInfectedConnectionsEnabled(boolean bl) {
        boolean bl2 = this.isRemoveInfectedConnectionsEnabled();
        this._customizer.setRemoveInfectedConnectionsEnabled(bl);
        this._postSet(63, bl2, bl);
    }

    public boolean isRemoveInfectedConnectionsEnabled() {
        return this._customizer.isRemoveInfectedConnectionsEnabled();
    }

    public boolean isRemoveInfectedConnectionsEnabledSet() {
        return this._isSet(63);
    }

    public void setRollbackLocalTxUponConnClose(boolean bl) {
        boolean bl2 = this.getRollbackLocalTxUponConnClose();
        this._customizer.setRollbackLocalTxUponConnClose(bl);
        this._postSet(64, bl2, bl);
    }

    public boolean getRollbackLocalTxUponConnClose() {
        return this._customizer.getRollbackLocalTxUponConnClose();
    }

    public boolean isRollbackLocalTxUponConnCloseSet() {
        return this._isSet(64);
    }

    public void setTestStatementTimeout(int n) {
        LegalChecks.checkInRange((String)"TestStatementTimeout", (long)n, (long)-1L, (long)Integer.MAX_VALUE);
        int n2 = this.getTestStatementTimeout();
        this._customizer.setTestStatementTimeout(n);
        this._postSet(65, n2, n);
    }

    public int getTestStatementTimeout() {
        return this._customizer.getTestStatementTimeout();
    }

    public boolean isTestStatementTimeoutSet() {
        return this._isSet(65);
    }

    public void setStatementTimeout(int n) {
        LegalChecks.checkInRange((String)"StatementTimeout", (long)n, (long)-1L, (long)Integer.MAX_VALUE);
        int n2 = this.getStatementTimeout();
        this._customizer.setStatementTimeout(n);
        this._postSet(66, n2, n);
    }

    public int getStatementTimeout() {
        return this._customizer.getStatementTimeout();
    }

    public boolean isStatementTimeoutSet() {
        return this._isSet(66);
    }

    public void setIgnoreInUseConnectionsEnabled(boolean bl) {
        boolean bl2 = this.isIgnoreInUseConnectionsEnabled();
        this._customizer.setIgnoreInUseConnectionsEnabled(bl);
        this._postSet(67, bl2, bl);
    }

    public boolean isIgnoreInUseConnectionsEnabled() {
        return this._customizer.isIgnoreInUseConnectionsEnabled();
    }

    public boolean isIgnoreInUseConnectionsEnabledSet() {
        return this._isSet(67);
    }

    public void setCredentialMappingEnabled(boolean bl) {
        boolean bl2 = this.isCredentialMappingEnabled();
        this._customizer.setCredentialMappingEnabled(bl);
        this._postSet(68, bl2, bl);
    }

    public boolean isCredentialMappingEnabled() {
        return this._customizer.isCredentialMappingEnabled();
    }

    public boolean isCredentialMappingEnabledSet() {
        return this._isSet(68);
    }

    public void setCountOfTestFailuresTillFlush(int n) {
        LegalChecks.checkMin((String)"CountOfTestFailuresTillFlush", (int)n, (int)0);
        int n2 = this.getCountOfTestFailuresTillFlush();
        try {
            this._customizer.setCountOfTestFailuresTillFlush(n);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new UndeclaredThrowableException(invalidAttributeValueException);
        }
        this._postSet(69, n2, n);
    }

    public int getCountOfTestFailuresTillFlush() {
        return this._customizer.getCountOfTestFailuresTillFlush();
    }

    public boolean isCountOfTestFailuresTillFlushSet() {
        return this._isSet(69);
    }

    public void setCountOfRefreshFailuresTillDisable(int n) {
        LegalChecks.checkMin((String)"CountOfRefreshFailuresTillDisable", (int)n, (int)0);
        int n2 = this.getCountOfRefreshFailuresTillDisable();
        try {
            this._customizer.setCountOfRefreshFailuresTillDisable(n);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new UndeclaredThrowableException(invalidAttributeValueException);
        }
        this._postSet(70, n2, n);
    }

    public int getCountOfRefreshFailuresTillDisable() {
        return this._customizer.getCountOfRefreshFailuresTillDisable();
    }

    public boolean isCountOfRefreshFailuresTillDisableSet() {
        return this._isSet(70);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public void setPasswordEncrypted(byte[] byArray) {
        byte[] byArray2 = this.getPasswordEncrypted();
        try {
            this._customizer.setPasswordEncrypted(byArray);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new UndeclaredThrowableException(invalidAttributeValueException);
        }
        this._postSet(37, byArray2, byArray);
    }

    public void setXAPasswordEncrypted(byte[] byArray) {
        byte[] byArray2 = this._XAPasswordEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: XAPasswordEncrypted of JDBCConnectionPoolMBean");
        }
        this._getHelper()._clearArray(this._XAPasswordEncrypted);
        this._XAPasswordEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(39, byArray2, byArray);
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
            if (n == 36) {
                this._markSet(37, false);
            }
            if (n == 38) {
                this._markSet(39, false);
            }
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 17;
        }
        try {
            switch (n) {
                case 17: {
                    this._ACLName = null;
                    if (bl) break;
                }
                case 25: {
                    this._customizer.setCapacityIncrement(1);
                    if (bl) break;
                }
                case 56: {
                    this._customizer.setConnectionCreationRetryFrequencySeconds(0);
                    if (bl) break;
                }
                case 55: {
                    this._customizer.setConnectionReserveTimeoutSeconds(10);
                    if (bl) break;
                }
                case 70: {
                    this._customizer.setCountOfRefreshFailuresTillDisable(2);
                    if (bl) break;
                }
                case 69: {
                    this._customizer.setCountOfTestFailuresTillFlush(2);
                    if (bl) break;
                }
                case 19: {
                    this._customizer.setDriverName(null);
                    if (bl) break;
                }
                case 48: {
                    this._customizer.setEnableResourceHealthMonitoring(true);
                    if (bl) break;
                }
                case 59: {
                    this._customizer.setHighestNumUnavailable(0);
                    if (bl) break;
                }
                case 58: {
                    this._customizer.setHighestNumWaiters(Integer.MAX_VALUE);
                    if (bl) break;
                }
                case 57: {
                    this._customizer.setInactiveConnectionTimeoutSeconds(0);
                    if (bl) break;
                }
                case 60: {
                    this._customizer.setInitSQL(null);
                    if (bl) break;
                }
                case 23: {
                    this._customizer.setInitialCapacity(1);
                    if (bl) break;
                }
                case 35: {
                    this._JDBCConnectionPoolRuntime = null;
                    if (bl) break;
                }
                case 9: {
                    this._customizer.setJDBCSystemResource(null);
                    if (bl) break;
                }
                case 40: {
                    this._customizer.setJDBCXADebugLevel(10);
                    if (bl) break;
                }
                case 46: {
                    this._customizer.setKeepLogicalConnOpenOnRelease(false);
                    if (bl) break;
                }
                case 42: {
                    this._customizer.setKeepXAConnTillTxComplete(false);
                    if (bl) break;
                }
                case 21: {
                    this._customizer.setLoginDelaySeconds(0);
                    if (bl) break;
                }
                case 24: {
                    this._customizer.setMaxCapacity(15);
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 43: {
                    this._customizer.setNeedTxCtxOnClose(false);
                    if (bl) break;
                }
                case 45: {
                    this._customizer.setNewXAConnForCommit(false);
                    if (bl) break;
                }
                case 36: {
                    this._customizer.setPasswordEncrypted(null);
                    if (bl) break;
                }
                case 37: {
                    this._customizer.setPasswordEncrypted(null);
                    if (bl) break;
                }
                case 11: {
                    this._customizer.setPrepStmtCacheProfilingThreshold(10);
                    if (bl) break;
                }
                case 54: {
                    this._customizer.setPreparedStatementCacheSize(-1);
                    if (bl) break;
                }
                case 20: {
                    this._customizer.setProperties(null);
                    if (bl) break;
                }
                case 49: {
                    this._customizer.setRecoverOnlyOnce(false);
                    if (bl) break;
                }
                case 29: {
                    this._RefreshMinutes = 0;
                    if (bl) break;
                }
                case 64: {
                    this._customizer.setRollbackLocalTxUponConnClose(false);
                    if (bl) break;
                }
                case 22: {
                    this._customizer.setSecondsToTrustAnIdlePoolConnection(10);
                    if (bl) break;
                }
                case 28: {
                    this._customizer.setShrinkFrequencySeconds(900);
                    if (bl) break;
                }
                case 27: {
                    this._customizer.setShrinkPeriodMinutes(15);
                    if (bl) break;
                }
                case 16: {
                    this._customizer.setSqlStmtMaxParamLength(10);
                    if (bl) break;
                }
                case 61: {
                    this._customizer.setStatementCacheSize(10);
                    if (bl) break;
                }
                case 62: {
                    this._customizer.setStatementCacheType("LRU");
                    if (bl) break;
                }
                case 66: {
                    this._customizer.setStatementTimeout(-1);
                    if (bl) break;
                }
                case 41: {
                    this._customizer.setSupportsLocalTransaction(true);
                    if (bl) break;
                }
                case 7: {
                    this._customizer.setTargets(new TargetMBean[0]);
                    if (bl) break;
                }
                case 34: {
                    this._customizer.setTestConnectionsOnCreate(true);
                    if (bl) break;
                }
                case 33: {
                    this._customizer.setTestConnectionsOnRelease(false);
                    if (bl) break;
                }
                case 32: {
                    this._customizer.setTestConnectionsOnReserve(false);
                    if (bl) break;
                }
                case 30: {
                    this._customizer.setTestFrequencySeconds(120);
                    if (bl) break;
                }
                case 65: {
                    this._customizer.setTestStatementTimeout(-1);
                    if (bl) break;
                }
                case 31: {
                    this._customizer.setTestTableName(null);
                    if (bl) break;
                }
                case 18: {
                    this._customizer.setURL(null);
                    if (bl) break;
                }
                case 44: {
                    this._customizer.setXAEndOnlyOnce(false);
                    if (bl) break;
                }
                case 38: {
                    this._XAPasswordEncrypted = null;
                    if (bl) break;
                }
                case 39: {
                    this._XAPasswordEncrypted = null;
                    if (bl) break;
                }
                case 47: {
                    this._customizer.setXAPreparedStatementCacheSize(-1);
                    if (bl) break;
                }
                case 52: {
                    this._XARetryDurationSeconds = 0;
                    if (bl) break;
                }
                case 53: {
                    this._XARetryIntervalSeconds = 60;
                    if (bl) break;
                }
                case 50: {
                    this._customizer.setXASetTransactionTimeout(false);
                    if (bl) break;
                }
                case 51: {
                    this._XATransactionTimeout = 0;
                    if (bl) break;
                }
                case 12: {
                    this._customizer.setConnLeakProfilingEnabled(false);
                    if (bl) break;
                }
                case 13: {
                    this._customizer.setConnProfilingEnabled(false);
                    if (bl) break;
                }
                case 68: {
                    this._customizer.setCredentialMappingEnabled(false);
                    if (bl) break;
                }
                case 67: {
                    this._customizer.setIgnoreInUseConnectionsEnabled(true);
                    if (bl) break;
                }
                case 10: {
                    this._customizer.setPrepStmtCacheProfilingEnabled(false);
                    if (bl) break;
                }
                case 63: {
                    this._customizer.setRemoveInfectedConnectionsEnabled(true);
                    if (bl) break;
                }
                case 26: {
                    this._customizer.setShrinkingEnabled(true);
                    if (bl) break;
                }
                case 15: {
                    this._customizer.setSqlStmtParamLoggingEnabled(false);
                    if (bl) break;
                }
                case 14: {
                    this._customizer.setSqlStmtProfilingEnabled(false);
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "JDBCConnectionPool";
    }

    public void putValue(String string, Object object) {
        if (string.equals("ACLName")) {
            String string2 = this._ACLName;
            this._ACLName = (String)object;
            this._postSet(17, string2, this._ACLName);
            return;
        }
        if (string.equals("CapacityIncrement")) {
            int n = this._CapacityIncrement;
            this._CapacityIncrement = (Integer)object;
            this._postSet(25, n, this._CapacityIncrement);
            return;
        }
        if (string.equals("ConnLeakProfilingEnabled")) {
            boolean bl = this._ConnLeakProfilingEnabled;
            this._ConnLeakProfilingEnabled = (Boolean)object;
            this._postSet(12, bl, this._ConnLeakProfilingEnabled);
            return;
        }
        if (string.equals("ConnProfilingEnabled")) {
            boolean bl = this._ConnProfilingEnabled;
            this._ConnProfilingEnabled = (Boolean)object;
            this._postSet(13, bl, this._ConnProfilingEnabled);
            return;
        }
        if (string.equals("ConnectionCreationRetryFrequencySeconds")) {
            int n = this._ConnectionCreationRetryFrequencySeconds;
            this._ConnectionCreationRetryFrequencySeconds = (Integer)object;
            this._postSet(56, n, this._ConnectionCreationRetryFrequencySeconds);
            return;
        }
        if (string.equals("ConnectionReserveTimeoutSeconds")) {
            int n = this._ConnectionReserveTimeoutSeconds;
            this._ConnectionReserveTimeoutSeconds = (Integer)object;
            this._postSet(55, n, this._ConnectionReserveTimeoutSeconds);
            return;
        }
        if (string.equals("CountOfRefreshFailuresTillDisable")) {
            int n = this._CountOfRefreshFailuresTillDisable;
            this._CountOfRefreshFailuresTillDisable = (Integer)object;
            this._postSet(70, n, this._CountOfRefreshFailuresTillDisable);
            return;
        }
        if (string.equals("CountOfTestFailuresTillFlush")) {
            int n = this._CountOfTestFailuresTillFlush;
            this._CountOfTestFailuresTillFlush = (Integer)object;
            this._postSet(69, n, this._CountOfTestFailuresTillFlush);
            return;
        }
        if (string.equals("CredentialMappingEnabled")) {
            boolean bl = this._CredentialMappingEnabled;
            this._CredentialMappingEnabled = (Boolean)object;
            this._postSet(68, bl, this._CredentialMappingEnabled);
            return;
        }
        if (string.equals("DriverName")) {
            String string3 = this._DriverName;
            this._DriverName = (String)object;
            this._postSet(19, string3, this._DriverName);
            return;
        }
        if (string.equals("EnableResourceHealthMonitoring")) {
            boolean bl = this._EnableResourceHealthMonitoring;
            this._EnableResourceHealthMonitoring = (Boolean)object;
            this._postSet(48, bl, this._EnableResourceHealthMonitoring);
            return;
        }
        if (string.equals("HighestNumUnavailable")) {
            int n = this._HighestNumUnavailable;
            this._HighestNumUnavailable = (Integer)object;
            this._postSet(59, n, this._HighestNumUnavailable);
            return;
        }
        if (string.equals("HighestNumWaiters")) {
            int n = this._HighestNumWaiters;
            this._HighestNumWaiters = (Integer)object;
            this._postSet(58, n, this._HighestNumWaiters);
            return;
        }
        if (string.equals("IgnoreInUseConnectionsEnabled")) {
            boolean bl = this._IgnoreInUseConnectionsEnabled;
            this._IgnoreInUseConnectionsEnabled = (Boolean)object;
            this._postSet(67, bl, this._IgnoreInUseConnectionsEnabled);
            return;
        }
        if (string.equals("InactiveConnectionTimeoutSeconds")) {
            int n = this._InactiveConnectionTimeoutSeconds;
            this._InactiveConnectionTimeoutSeconds = (Integer)object;
            this._postSet(57, n, this._InactiveConnectionTimeoutSeconds);
            return;
        }
        if (string.equals("InitSQL")) {
            String string4 = this._InitSQL;
            this._InitSQL = (String)object;
            this._postSet(60, string4, this._InitSQL);
            return;
        }
        if (string.equals("InitialCapacity")) {
            int n = this._InitialCapacity;
            this._InitialCapacity = (Integer)object;
            this._postSet(23, n, this._InitialCapacity);
            return;
        }
        if (string.equals("JDBCConnectionPoolRuntime")) {
            JDBCConnectionPoolRuntimeMBean jDBCConnectionPoolRuntimeMBean = this._JDBCConnectionPoolRuntime;
            this._JDBCConnectionPoolRuntime = (JDBCConnectionPoolRuntimeMBean)object;
            this._postSet(35, jDBCConnectionPoolRuntimeMBean, this._JDBCConnectionPoolRuntime);
            return;
        }
        if (string.equals("JDBCSystemResource")) {
            JDBCSystemResourceMBean jDBCSystemResourceMBean = this._JDBCSystemResource;
            this._JDBCSystemResource = (JDBCSystemResourceMBean)object;
            this._postSet(9, jDBCSystemResourceMBean, this._JDBCSystemResource);
            return;
        }
        if (string.equals("JDBCXADebugLevel")) {
            int n = this._JDBCXADebugLevel;
            this._JDBCXADebugLevel = (Integer)object;
            this._postSet(40, n, this._JDBCXADebugLevel);
            return;
        }
        if (string.equals("KeepLogicalConnOpenOnRelease")) {
            boolean bl = this._KeepLogicalConnOpenOnRelease;
            this._KeepLogicalConnOpenOnRelease = (Boolean)object;
            this._postSet(46, bl, this._KeepLogicalConnOpenOnRelease);
            return;
        }
        if (string.equals("KeepXAConnTillTxComplete")) {
            boolean bl = this._KeepXAConnTillTxComplete;
            this._KeepXAConnTillTxComplete = (Boolean)object;
            this._postSet(42, bl, this._KeepXAConnTillTxComplete);
            return;
        }
        if (string.equals("LoginDelaySeconds")) {
            int n = this._LoginDelaySeconds;
            this._LoginDelaySeconds = (Integer)object;
            this._postSet(21, n, this._LoginDelaySeconds);
            return;
        }
        if (string.equals("MaxCapacity")) {
            int n = this._MaxCapacity;
            this._MaxCapacity = (Integer)object;
            this._postSet(24, n, this._MaxCapacity);
            return;
        }
        if (string.equals("Name")) {
            String string5 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string5, this._Name);
            return;
        }
        if (string.equals("NeedTxCtxOnClose")) {
            boolean bl = this._NeedTxCtxOnClose;
            this._NeedTxCtxOnClose = (Boolean)object;
            this._postSet(43, bl, this._NeedTxCtxOnClose);
            return;
        }
        if (string.equals("NewXAConnForCommit")) {
            boolean bl = this._NewXAConnForCommit;
            this._NewXAConnForCommit = (Boolean)object;
            this._postSet(45, bl, this._NewXAConnForCommit);
            return;
        }
        if (string.equals("Password")) {
            String string6 = this._Password;
            this._Password = (String)object;
            this._postSet(36, string6, this._Password);
            return;
        }
        if (string.equals("PasswordEncrypted")) {
            byte[] byArray = this._PasswordEncrypted;
            this._PasswordEncrypted = (byte[])object;
            this._postSet(37, byArray, this._PasswordEncrypted);
            return;
        }
        if (string.equals("PrepStmtCacheProfilingEnabled")) {
            boolean bl = this._PrepStmtCacheProfilingEnabled;
            this._PrepStmtCacheProfilingEnabled = (Boolean)object;
            this._postSet(10, bl, this._PrepStmtCacheProfilingEnabled);
            return;
        }
        if (string.equals("PrepStmtCacheProfilingThreshold")) {
            int n = this._PrepStmtCacheProfilingThreshold;
            this._PrepStmtCacheProfilingThreshold = (Integer)object;
            this._postSet(11, n, this._PrepStmtCacheProfilingThreshold);
            return;
        }
        if (string.equals("PreparedStatementCacheSize")) {
            int n = this._PreparedStatementCacheSize;
            this._PreparedStatementCacheSize = (Integer)object;
            this._postSet(54, n, this._PreparedStatementCacheSize);
            return;
        }
        if (string.equals("Properties")) {
            Properties properties = this._Properties;
            this._Properties = (Properties)object;
            this._postSet(20, properties, this._Properties);
            return;
        }
        if (string.equals("RecoverOnlyOnce")) {
            boolean bl = this._RecoverOnlyOnce;
            this._RecoverOnlyOnce = (Boolean)object;
            this._postSet(49, bl, this._RecoverOnlyOnce);
            return;
        }
        if (string.equals("RefreshMinutes")) {
            int n = this._RefreshMinutes;
            this._RefreshMinutes = (Integer)object;
            this._postSet(29, n, this._RefreshMinutes);
            return;
        }
        if (string.equals("RemoveInfectedConnectionsEnabled")) {
            boolean bl = this._RemoveInfectedConnectionsEnabled;
            this._RemoveInfectedConnectionsEnabled = (Boolean)object;
            this._postSet(63, bl, this._RemoveInfectedConnectionsEnabled);
            return;
        }
        if (string.equals("RollbackLocalTxUponConnClose")) {
            boolean bl = this._RollbackLocalTxUponConnClose;
            this._RollbackLocalTxUponConnClose = (Boolean)object;
            this._postSet(64, bl, this._RollbackLocalTxUponConnClose);
            return;
        }
        if (string.equals("SecondsToTrustAnIdlePoolConnection")) {
            int n = this._SecondsToTrustAnIdlePoolConnection;
            this._SecondsToTrustAnIdlePoolConnection = (Integer)object;
            this._postSet(22, n, this._SecondsToTrustAnIdlePoolConnection);
            return;
        }
        if (string.equals("ShrinkFrequencySeconds")) {
            int n = this._ShrinkFrequencySeconds;
            this._ShrinkFrequencySeconds = (Integer)object;
            this._postSet(28, n, this._ShrinkFrequencySeconds);
            return;
        }
        if (string.equals("ShrinkPeriodMinutes")) {
            int n = this._ShrinkPeriodMinutes;
            this._ShrinkPeriodMinutes = (Integer)object;
            this._postSet(27, n, this._ShrinkPeriodMinutes);
            return;
        }
        if (string.equals("ShrinkingEnabled")) {
            boolean bl = this._ShrinkingEnabled;
            this._ShrinkingEnabled = (Boolean)object;
            this._postSet(26, bl, this._ShrinkingEnabled);
            return;
        }
        if (string.equals("SqlStmtMaxParamLength")) {
            int n = this._SqlStmtMaxParamLength;
            this._SqlStmtMaxParamLength = (Integer)object;
            this._postSet(16, n, this._SqlStmtMaxParamLength);
            return;
        }
        if (string.equals("SqlStmtParamLoggingEnabled")) {
            boolean bl = this._SqlStmtParamLoggingEnabled;
            this._SqlStmtParamLoggingEnabled = (Boolean)object;
            this._postSet(15, bl, this._SqlStmtParamLoggingEnabled);
            return;
        }
        if (string.equals("SqlStmtProfilingEnabled")) {
            boolean bl = this._SqlStmtProfilingEnabled;
            this._SqlStmtProfilingEnabled = (Boolean)object;
            this._postSet(14, bl, this._SqlStmtProfilingEnabled);
            return;
        }
        if (string.equals("StatementCacheSize")) {
            int n = this._StatementCacheSize;
            this._StatementCacheSize = (Integer)object;
            this._postSet(61, n, this._StatementCacheSize);
            return;
        }
        if (string.equals("StatementCacheType")) {
            String string7 = this._StatementCacheType;
            this._StatementCacheType = (String)object;
            this._postSet(62, string7, this._StatementCacheType);
            return;
        }
        if (string.equals("StatementTimeout")) {
            int n = this._StatementTimeout;
            this._StatementTimeout = (Integer)object;
            this._postSet(66, n, this._StatementTimeout);
            return;
        }
        if (string.equals("SupportsLocalTransaction")) {
            boolean bl = this._SupportsLocalTransaction;
            this._SupportsLocalTransaction = (Boolean)object;
            this._postSet(41, bl, this._SupportsLocalTransaction);
            return;
        }
        if (string.equals("Targets")) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._Targets = (TargetMBean[])object;
            this._postSet(7, targetMBeanArray, this._Targets);
            return;
        }
        if (string.equals("TestConnectionsOnCreate")) {
            boolean bl = this._TestConnectionsOnCreate;
            this._TestConnectionsOnCreate = (Boolean)object;
            this._postSet(34, bl, this._TestConnectionsOnCreate);
            return;
        }
        if (string.equals("TestConnectionsOnRelease")) {
            boolean bl = this._TestConnectionsOnRelease;
            this._TestConnectionsOnRelease = (Boolean)object;
            this._postSet(33, bl, this._TestConnectionsOnRelease);
            return;
        }
        if (string.equals("TestConnectionsOnReserve")) {
            boolean bl = this._TestConnectionsOnReserve;
            this._TestConnectionsOnReserve = (Boolean)object;
            this._postSet(32, bl, this._TestConnectionsOnReserve);
            return;
        }
        if (string.equals("TestFrequencySeconds")) {
            int n = this._TestFrequencySeconds;
            this._TestFrequencySeconds = (Integer)object;
            this._postSet(30, n, this._TestFrequencySeconds);
            return;
        }
        if (string.equals("TestStatementTimeout")) {
            int n = this._TestStatementTimeout;
            this._TestStatementTimeout = (Integer)object;
            this._postSet(65, n, this._TestStatementTimeout);
            return;
        }
        if (string.equals("TestTableName")) {
            String string8 = this._TestTableName;
            this._TestTableName = (String)object;
            this._postSet(31, string8, this._TestTableName);
            return;
        }
        if (string.equals("URL")) {
            String string9 = this._URL;
            this._URL = (String)object;
            this._postSet(18, string9, this._URL);
            return;
        }
        if (string.equals("XAEndOnlyOnce")) {
            boolean bl = this._XAEndOnlyOnce;
            this._XAEndOnlyOnce = (Boolean)object;
            this._postSet(44, bl, this._XAEndOnlyOnce);
            return;
        }
        if (string.equals("XAPassword")) {
            String string10 = this._XAPassword;
            this._XAPassword = (String)object;
            this._postSet(38, string10, this._XAPassword);
            return;
        }
        if (string.equals("XAPasswordEncrypted")) {
            byte[] byArray = this._XAPasswordEncrypted;
            this._XAPasswordEncrypted = (byte[])object;
            this._postSet(39, byArray, this._XAPasswordEncrypted);
            return;
        }
        if (string.equals("XAPreparedStatementCacheSize")) {
            int n = this._XAPreparedStatementCacheSize;
            this._XAPreparedStatementCacheSize = (Integer)object;
            this._postSet(47, n, this._XAPreparedStatementCacheSize);
            return;
        }
        if (string.equals("XARetryDurationSeconds")) {
            int n = this._XARetryDurationSeconds;
            this._XARetryDurationSeconds = (Integer)object;
            this._postSet(52, n, this._XARetryDurationSeconds);
            return;
        }
        if (string.equals("XARetryIntervalSeconds")) {
            int n = this._XARetryIntervalSeconds;
            this._XARetryIntervalSeconds = (Integer)object;
            this._postSet(53, n, this._XARetryIntervalSeconds);
            return;
        }
        if (string.equals("XASetTransactionTimeout")) {
            boolean bl = this._XASetTransactionTimeout;
            this._XASetTransactionTimeout = (Boolean)object;
            this._postSet(50, bl, this._XASetTransactionTimeout);
            return;
        }
        if (string.equals("XATransactionTimeout")) {
            int n = this._XATransactionTimeout;
            this._XATransactionTimeout = (Integer)object;
            this._postSet(51, n, this._XATransactionTimeout);
            return;
        }
        if (string.equals("customizer")) {
            JDBCConnectionPool jDBCConnectionPool = this._customizer;
            this._customizer = (JDBCConnectionPool)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("ACLName")) {
            return this._ACLName;
        }
        if (string.equals("CapacityIncrement")) {
            return new Integer(this._CapacityIncrement);
        }
        if (string.equals("ConnLeakProfilingEnabled")) {
            return new Boolean(this._ConnLeakProfilingEnabled);
        }
        if (string.equals("ConnProfilingEnabled")) {
            return new Boolean(this._ConnProfilingEnabled);
        }
        if (string.equals("ConnectionCreationRetryFrequencySeconds")) {
            return new Integer(this._ConnectionCreationRetryFrequencySeconds);
        }
        if (string.equals("ConnectionReserveTimeoutSeconds")) {
            return new Integer(this._ConnectionReserveTimeoutSeconds);
        }
        if (string.equals("CountOfRefreshFailuresTillDisable")) {
            return new Integer(this._CountOfRefreshFailuresTillDisable);
        }
        if (string.equals("CountOfTestFailuresTillFlush")) {
            return new Integer(this._CountOfTestFailuresTillFlush);
        }
        if (string.equals("CredentialMappingEnabled")) {
            return new Boolean(this._CredentialMappingEnabled);
        }
        if (string.equals("DriverName")) {
            return this._DriverName;
        }
        if (string.equals("EnableResourceHealthMonitoring")) {
            return new Boolean(this._EnableResourceHealthMonitoring);
        }
        if (string.equals("HighestNumUnavailable")) {
            return new Integer(this._HighestNumUnavailable);
        }
        if (string.equals("HighestNumWaiters")) {
            return new Integer(this._HighestNumWaiters);
        }
        if (string.equals("IgnoreInUseConnectionsEnabled")) {
            return new Boolean(this._IgnoreInUseConnectionsEnabled);
        }
        if (string.equals("InactiveConnectionTimeoutSeconds")) {
            return new Integer(this._InactiveConnectionTimeoutSeconds);
        }
        if (string.equals("InitSQL")) {
            return this._InitSQL;
        }
        if (string.equals("InitialCapacity")) {
            return new Integer(this._InitialCapacity);
        }
        if (string.equals("JDBCConnectionPoolRuntime")) {
            return this._JDBCConnectionPoolRuntime;
        }
        if (string.equals("JDBCSystemResource")) {
            return this._JDBCSystemResource;
        }
        if (string.equals("JDBCXADebugLevel")) {
            return new Integer(this._JDBCXADebugLevel);
        }
        if (string.equals("KeepLogicalConnOpenOnRelease")) {
            return new Boolean(this._KeepLogicalConnOpenOnRelease);
        }
        if (string.equals("KeepXAConnTillTxComplete")) {
            return new Boolean(this._KeepXAConnTillTxComplete);
        }
        if (string.equals("LoginDelaySeconds")) {
            return new Integer(this._LoginDelaySeconds);
        }
        if (string.equals("MaxCapacity")) {
            return new Integer(this._MaxCapacity);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("NeedTxCtxOnClose")) {
            return new Boolean(this._NeedTxCtxOnClose);
        }
        if (string.equals("NewXAConnForCommit")) {
            return new Boolean(this._NewXAConnForCommit);
        }
        if (string.equals("Password")) {
            return this._Password;
        }
        if (string.equals("PasswordEncrypted")) {
            return this._PasswordEncrypted;
        }
        if (string.equals("PrepStmtCacheProfilingEnabled")) {
            return new Boolean(this._PrepStmtCacheProfilingEnabled);
        }
        if (string.equals("PrepStmtCacheProfilingThreshold")) {
            return new Integer(this._PrepStmtCacheProfilingThreshold);
        }
        if (string.equals("PreparedStatementCacheSize")) {
            return new Integer(this._PreparedStatementCacheSize);
        }
        if (string.equals("Properties")) {
            return this._Properties;
        }
        if (string.equals("RecoverOnlyOnce")) {
            return new Boolean(this._RecoverOnlyOnce);
        }
        if (string.equals("RefreshMinutes")) {
            return new Integer(this._RefreshMinutes);
        }
        if (string.equals("RemoveInfectedConnectionsEnabled")) {
            return new Boolean(this._RemoveInfectedConnectionsEnabled);
        }
        if (string.equals("RollbackLocalTxUponConnClose")) {
            return new Boolean(this._RollbackLocalTxUponConnClose);
        }
        if (string.equals("SecondsToTrustAnIdlePoolConnection")) {
            return new Integer(this._SecondsToTrustAnIdlePoolConnection);
        }
        if (string.equals("ShrinkFrequencySeconds")) {
            return new Integer(this._ShrinkFrequencySeconds);
        }
        if (string.equals("ShrinkPeriodMinutes")) {
            return new Integer(this._ShrinkPeriodMinutes);
        }
        if (string.equals("ShrinkingEnabled")) {
            return new Boolean(this._ShrinkingEnabled);
        }
        if (string.equals("SqlStmtMaxParamLength")) {
            return new Integer(this._SqlStmtMaxParamLength);
        }
        if (string.equals("SqlStmtParamLoggingEnabled")) {
            return new Boolean(this._SqlStmtParamLoggingEnabled);
        }
        if (string.equals("SqlStmtProfilingEnabled")) {
            return new Boolean(this._SqlStmtProfilingEnabled);
        }
        if (string.equals("StatementCacheSize")) {
            return new Integer(this._StatementCacheSize);
        }
        if (string.equals("StatementCacheType")) {
            return this._StatementCacheType;
        }
        if (string.equals("StatementTimeout")) {
            return new Integer(this._StatementTimeout);
        }
        if (string.equals("SupportsLocalTransaction")) {
            return new Boolean(this._SupportsLocalTransaction);
        }
        if (string.equals("Targets")) {
            return this._Targets;
        }
        if (string.equals("TestConnectionsOnCreate")) {
            return new Boolean(this._TestConnectionsOnCreate);
        }
        if (string.equals("TestConnectionsOnRelease")) {
            return new Boolean(this._TestConnectionsOnRelease);
        }
        if (string.equals("TestConnectionsOnReserve")) {
            return new Boolean(this._TestConnectionsOnReserve);
        }
        if (string.equals("TestFrequencySeconds")) {
            return new Integer(this._TestFrequencySeconds);
        }
        if (string.equals("TestStatementTimeout")) {
            return new Integer(this._TestStatementTimeout);
        }
        if (string.equals("TestTableName")) {
            return this._TestTableName;
        }
        if (string.equals("URL")) {
            return this._URL;
        }
        if (string.equals("XAEndOnlyOnce")) {
            return new Boolean(this._XAEndOnlyOnce);
        }
        if (string.equals("XAPassword")) {
            return this._XAPassword;
        }
        if (string.equals("XAPasswordEncrypted")) {
            return this._XAPasswordEncrypted;
        }
        if (string.equals("XAPreparedStatementCacheSize")) {
            return new Integer(this._XAPreparedStatementCacheSize);
        }
        if (string.equals("XARetryDurationSeconds")) {
            return new Integer(this._XARetryDurationSeconds);
        }
        if (string.equals("XARetryIntervalSeconds")) {
            return new Integer(this._XARetryIntervalSeconds);
        }
        if (string.equals("XASetTransactionTimeout")) {
            return new Boolean(this._XASetTransactionTimeout);
        }
        if (string.equals("XATransactionTimeout")) {
            return new Integer(this._XATransactionTimeout);
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static void validateGeneration() {
        try {
            String[] stringArray = new String[]{"LRU", "FIXED"};
            LegalChecks.checkInEnum((String)"StatementCacheType", (String)"LRU", (String[])stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("Default value for a property  should be one of the legal values. Refer annotation legalValues on property StatementCacheType in JDBCConnectionPoolMBean" + illegalArgumentException.getMessage());
        }
    }

    public static class SchemaHelper2
    extends DeploymentMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 8: {
                    if (string.equals("acl-name")) {
                        return 17;
                    }
                    if (string.equals("init-sql")) {
                        return 60;
                    }
                    if (!string.equals("password")) break;
                    return 36;
                }
                case 18: {
                    if (string.equals("capacity-increment")) {
                        return 25;
                    }
                    if (!string.equals("password-encrypted")) break;
                    return 37;
                }
                case 43: {
                    if (!string.equals("connection-creation-retry-frequency-seconds")) break;
                    return 56;
                }
                case 34: {
                    if (!string.equals("connection-reserve-timeout-seconds")) break;
                    return 55;
                }
                case 38: {
                    if (!string.equals("count-of-refresh-failures-till-disable")) break;
                    return 70;
                }
                case 33: {
                    if (string.equals("count-of-test-failures-till-flush")) {
                        return 69;
                    }
                    if (string.equals("enable-resource-health-monitoring")) {
                        return 48;
                    }
                    if (string.equals("keep-logical-conn-open-on-release")) {
                        return 46;
                    }
                    if (string.equals("rollback-local-tx-upon-conn-close")) {
                        return 64;
                    }
                    if (string.equals("ignore-in-use-connections-enabled")) {
                        return 67;
                    }
                    if (!string.equals("prep-stmt-cache-profiling-enabled")) break;
                    return 10;
                }
                case 11: {
                    if (string.equals("driver-name")) {
                        return 19;
                    }
                    if (!string.equals("xa-password")) break;
                    return 38;
                }
                case 23: {
                    if (!string.equals("highest-num-unavailable")) break;
                    return 59;
                }
                case 19: {
                    if (string.equals("highest-num-waiters")) {
                        return 58;
                    }
                    if (string.equals("jdbc-xa-debug-level")) {
                        return 40;
                    }
                    if (!string.equals("login-delay-seconds")) break;
                    return 21;
                }
                case 35: {
                    if (string.equals("inactive-connection-timeout-seconds")) {
                        return 57;
                    }
                    if (string.equals("prep-stmt-cache-profiling-threshold")) {
                        return 11;
                    }
                    if (!string.equals("remove-infected-connections-enabled")) break;
                    return 63;
                }
                case 16: {
                    if (string.equals("initial-capacity")) {
                        return 23;
                    }
                    if (!string.equals("xa-end-only-once")) break;
                    return 44;
                }
                case 28: {
                    if (!string.equals("jdbc-connection-pool-runtime")) break;
                    return 35;
                }
                case 20: {
                    if (string.equals("jdbc-system-resource")) {
                        return 9;
                    }
                    if (string.equals("need-tx-ctx-on-close")) {
                        return 43;
                    }
                    if (string.equals("statement-cache-size")) {
                        return 61;
                    }
                    if (!string.equals("statement-cache-type")) break;
                    return 62;
                }
                case 29: {
                    if (string.equals("keep-xa-conn-till-tx-complete")) {
                        return 42;
                    }
                    if (!string.equals("prepared-statement-cache-size")) break;
                    return 54;
                }
                case 12: {
                    if (!string.equals("max-capacity")) break;
                    return 24;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 22: {
                    if (string.equals("new-xa-conn-for-commit")) {
                        return 45;
                    }
                    if (string.equals("test-frequency-seconds")) {
                        return 30;
                    }
                    if (string.equals("test-statement-timeout")) {
                        return 65;
                    }
                    if (string.equals("xa-transaction-timeout")) {
                        return 51;
                    }
                    if (!string.equals("conn-profiling-enabled")) break;
                    return 13;
                }
                case 10: {
                    if (!string.equals("properties")) break;
                    return 20;
                }
                case 17: {
                    if (string.equals("recover-only-once")) {
                        return 49;
                    }
                    if (string.equals("statement-timeout")) {
                        return 66;
                    }
                    if (!string.equals("shrinking-enabled")) break;
                    return 26;
                }
                case 15: {
                    if (string.equals("refresh-minutes")) {
                        return 29;
                    }
                    if (!string.equals("test-table-name")) break;
                    return 31;
                }
                case 40: {
                    if (!string.equals("seconds-to-trust-an-idle-pool-connection")) break;
                    return 22;
                }
                case 24: {
                    if (!string.equals("shrink-frequency-seconds")) break;
                    return 28;
                }
                case 21: {
                    if (string.equals("shrink-period-minutes")) {
                        return 27;
                    }
                    if (!string.equals("xa-password-encrypted")) break;
                    return 39;
                }
                case 25: {
                    if (string.equals("sql-stmt-max-param-length")) {
                        return 16;
                    }
                    if (string.equals("xa-retry-duration-seconds")) {
                        return 52;
                    }
                    if (!string.equals("xa-retry-interval-seconds")) break;
                    return 53;
                }
                case 26: {
                    if (string.equals("supports-local-transaction")) {
                        return 41;
                    }
                    if (string.equals("test-connections-on-create")) {
                        return 34;
                    }
                    if (string.equals("xa-set-transaction-timeout")) {
                        return 50;
                    }
                    if (string.equals("credential-mapping-enabled")) {
                        return 68;
                    }
                    if (!string.equals("sql-stmt-profiling-enabled")) break;
                    return 14;
                }
                case 6: {
                    if (!string.equals("target")) break;
                    return 7;
                }
                case 27: {
                    if (string.equals("test-connections-on-release")) {
                        return 33;
                    }
                    if (string.equals("test-connections-on-reserve")) {
                        return 32;
                    }
                    if (!string.equals("conn-leak-profiling-enabled")) break;
                    return 12;
                }
                case 3: {
                    if (!string.equals("url")) break;
                    return 18;
                }
                case 32: {
                    if (!string.equals("xa-prepared-statement-cache-size")) break;
                    return 47;
                }
                case 30: {
                    if (!string.equals("sql-stmt-param-logging-enabled")) break;
                    return 15;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 17: {
                    return "acl-name";
                }
                case 25: {
                    return "capacity-increment";
                }
                case 56: {
                    return "connection-creation-retry-frequency-seconds";
                }
                case 55: {
                    return "connection-reserve-timeout-seconds";
                }
                case 70: {
                    return "count-of-refresh-failures-till-disable";
                }
                case 69: {
                    return "count-of-test-failures-till-flush";
                }
                case 19: {
                    return "driver-name";
                }
                case 48: {
                    return "enable-resource-health-monitoring";
                }
                case 59: {
                    return "highest-num-unavailable";
                }
                case 58: {
                    return "highest-num-waiters";
                }
                case 57: {
                    return "inactive-connection-timeout-seconds";
                }
                case 60: {
                    return "init-sql";
                }
                case 23: {
                    return "initial-capacity";
                }
                case 35: {
                    return "jdbc-connection-pool-runtime";
                }
                case 9: {
                    return "jdbc-system-resource";
                }
                case 40: {
                    return "jdbc-xa-debug-level";
                }
                case 46: {
                    return "keep-logical-conn-open-on-release";
                }
                case 42: {
                    return "keep-xa-conn-till-tx-complete";
                }
                case 21: {
                    return "login-delay-seconds";
                }
                case 24: {
                    return "max-capacity";
                }
                case 2: {
                    return "name";
                }
                case 43: {
                    return "need-tx-ctx-on-close";
                }
                case 45: {
                    return "new-xa-conn-for-commit";
                }
                case 36: {
                    return "password";
                }
                case 37: {
                    return "password-encrypted";
                }
                case 11: {
                    return "prep-stmt-cache-profiling-threshold";
                }
                case 54: {
                    return "prepared-statement-cache-size";
                }
                case 20: {
                    return "properties";
                }
                case 49: {
                    return "recover-only-once";
                }
                case 29: {
                    return "refresh-minutes";
                }
                case 64: {
                    return "rollback-local-tx-upon-conn-close";
                }
                case 22: {
                    return "seconds-to-trust-an-idle-pool-connection";
                }
                case 28: {
                    return "shrink-frequency-seconds";
                }
                case 27: {
                    return "shrink-period-minutes";
                }
                case 16: {
                    return "sql-stmt-max-param-length";
                }
                case 61: {
                    return "statement-cache-size";
                }
                case 62: {
                    return "statement-cache-type";
                }
                case 66: {
                    return "statement-timeout";
                }
                case 41: {
                    return "supports-local-transaction";
                }
                case 7: {
                    return "target";
                }
                case 34: {
                    return "test-connections-on-create";
                }
                case 33: {
                    return "test-connections-on-release";
                }
                case 32: {
                    return "test-connections-on-reserve";
                }
                case 30: {
                    return "test-frequency-seconds";
                }
                case 65: {
                    return "test-statement-timeout";
                }
                case 31: {
                    return "test-table-name";
                }
                case 18: {
                    return "url";
                }
                case 44: {
                    return "xa-end-only-once";
                }
                case 38: {
                    return "xa-password";
                }
                case 39: {
                    return "xa-password-encrypted";
                }
                case 47: {
                    return "xa-prepared-statement-cache-size";
                }
                case 52: {
                    return "xa-retry-duration-seconds";
                }
                case 53: {
                    return "xa-retry-interval-seconds";
                }
                case 50: {
                    return "xa-set-transaction-timeout";
                }
                case 51: {
                    return "xa-transaction-timeout";
                }
                case 12: {
                    return "conn-leak-profiling-enabled";
                }
                case 13: {
                    return "conn-profiling-enabled";
                }
                case 68: {
                    return "credential-mapping-enabled";
                }
                case 67: {
                    return "ignore-in-use-connections-enabled";
                }
                case 10: {
                    return "prep-stmt-cache-profiling-enabled";
                }
                case 63: {
                    return "remove-infected-connections-enabled";
                }
                case 26: {
                    return "shrinking-enabled";
                }
                case 15: {
                    return "sql-stmt-param-logging-enabled";
                }
                case 14: {
                    return "sql-stmt-profiling-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 7: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends DeploymentMBeanImpl.Helper {
        private JDBCConnectionPoolMBeanImpl bean;

        protected Helper(JDBCConnectionPoolMBeanImpl jDBCConnectionPoolMBeanImpl) {
            super(jDBCConnectionPoolMBeanImpl);
            this.bean = jDBCConnectionPoolMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 17: {
                    return "ACLName";
                }
                case 25: {
                    return "CapacityIncrement";
                }
                case 56: {
                    return "ConnectionCreationRetryFrequencySeconds";
                }
                case 55: {
                    return "ConnectionReserveTimeoutSeconds";
                }
                case 70: {
                    return "CountOfRefreshFailuresTillDisable";
                }
                case 69: {
                    return "CountOfTestFailuresTillFlush";
                }
                case 19: {
                    return "DriverName";
                }
                case 48: {
                    return "EnableResourceHealthMonitoring";
                }
                case 59: {
                    return "HighestNumUnavailable";
                }
                case 58: {
                    return "HighestNumWaiters";
                }
                case 57: {
                    return "InactiveConnectionTimeoutSeconds";
                }
                case 60: {
                    return "InitSQL";
                }
                case 23: {
                    return "InitialCapacity";
                }
                case 35: {
                    return "JDBCConnectionPoolRuntime";
                }
                case 9: {
                    return "JDBCSystemResource";
                }
                case 40: {
                    return "JDBCXADebugLevel";
                }
                case 46: {
                    return "KeepLogicalConnOpenOnRelease";
                }
                case 42: {
                    return "KeepXAConnTillTxComplete";
                }
                case 21: {
                    return "LoginDelaySeconds";
                }
                case 24: {
                    return "MaxCapacity";
                }
                case 2: {
                    return "Name";
                }
                case 43: {
                    return "NeedTxCtxOnClose";
                }
                case 45: {
                    return "NewXAConnForCommit";
                }
                case 36: {
                    return "Password";
                }
                case 37: {
                    return "PasswordEncrypted";
                }
                case 11: {
                    return "PrepStmtCacheProfilingThreshold";
                }
                case 54: {
                    return "PreparedStatementCacheSize";
                }
                case 20: {
                    return "Properties";
                }
                case 49: {
                    return "RecoverOnlyOnce";
                }
                case 29: {
                    return "RefreshMinutes";
                }
                case 64: {
                    return "RollbackLocalTxUponConnClose";
                }
                case 22: {
                    return "SecondsToTrustAnIdlePoolConnection";
                }
                case 28: {
                    return "ShrinkFrequencySeconds";
                }
                case 27: {
                    return "ShrinkPeriodMinutes";
                }
                case 16: {
                    return "SqlStmtMaxParamLength";
                }
                case 61: {
                    return "StatementCacheSize";
                }
                case 62: {
                    return "StatementCacheType";
                }
                case 66: {
                    return "StatementTimeout";
                }
                case 41: {
                    return "SupportsLocalTransaction";
                }
                case 7: {
                    return "Targets";
                }
                case 34: {
                    return "TestConnectionsOnCreate";
                }
                case 33: {
                    return "TestConnectionsOnRelease";
                }
                case 32: {
                    return "TestConnectionsOnReserve";
                }
                case 30: {
                    return "TestFrequencySeconds";
                }
                case 65: {
                    return "TestStatementTimeout";
                }
                case 31: {
                    return "TestTableName";
                }
                case 18: {
                    return "URL";
                }
                case 44: {
                    return "XAEndOnlyOnce";
                }
                case 38: {
                    return "XAPassword";
                }
                case 39: {
                    return "XAPasswordEncrypted";
                }
                case 47: {
                    return "XAPreparedStatementCacheSize";
                }
                case 52: {
                    return "XARetryDurationSeconds";
                }
                case 53: {
                    return "XARetryIntervalSeconds";
                }
                case 50: {
                    return "XASetTransactionTimeout";
                }
                case 51: {
                    return "XATransactionTimeout";
                }
                case 12: {
                    return "ConnLeakProfilingEnabled";
                }
                case 13: {
                    return "ConnProfilingEnabled";
                }
                case 68: {
                    return "CredentialMappingEnabled";
                }
                case 67: {
                    return "IgnoreInUseConnectionsEnabled";
                }
                case 10: {
                    return "PrepStmtCacheProfilingEnabled";
                }
                case 63: {
                    return "RemoveInfectedConnectionsEnabled";
                }
                case 26: {
                    return "ShrinkingEnabled";
                }
                case 15: {
                    return "SqlStmtParamLoggingEnabled";
                }
                case 14: {
                    return "SqlStmtProfilingEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("ACLName")) {
                return 17;
            }
            if (string.equals("CapacityIncrement")) {
                return 25;
            }
            if (string.equals("ConnectionCreationRetryFrequencySeconds")) {
                return 56;
            }
            if (string.equals("ConnectionReserveTimeoutSeconds")) {
                return 55;
            }
            if (string.equals("CountOfRefreshFailuresTillDisable")) {
                return 70;
            }
            if (string.equals("CountOfTestFailuresTillFlush")) {
                return 69;
            }
            if (string.equals("DriverName")) {
                return 19;
            }
            if (string.equals("EnableResourceHealthMonitoring")) {
                return 48;
            }
            if (string.equals("HighestNumUnavailable")) {
                return 59;
            }
            if (string.equals("HighestNumWaiters")) {
                return 58;
            }
            if (string.equals("InactiveConnectionTimeoutSeconds")) {
                return 57;
            }
            if (string.equals("InitSQL")) {
                return 60;
            }
            if (string.equals("InitialCapacity")) {
                return 23;
            }
            if (string.equals("JDBCConnectionPoolRuntime")) {
                return 35;
            }
            if (string.equals("JDBCSystemResource")) {
                return 9;
            }
            if (string.equals("JDBCXADebugLevel")) {
                return 40;
            }
            if (string.equals("KeepLogicalConnOpenOnRelease")) {
                return 46;
            }
            if (string.equals("KeepXAConnTillTxComplete")) {
                return 42;
            }
            if (string.equals("LoginDelaySeconds")) {
                return 21;
            }
            if (string.equals("MaxCapacity")) {
                return 24;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("NeedTxCtxOnClose")) {
                return 43;
            }
            if (string.equals("NewXAConnForCommit")) {
                return 45;
            }
            if (string.equals("Password")) {
                return 36;
            }
            if (string.equals("PasswordEncrypted")) {
                return 37;
            }
            if (string.equals("PrepStmtCacheProfilingThreshold")) {
                return 11;
            }
            if (string.equals("PreparedStatementCacheSize")) {
                return 54;
            }
            if (string.equals("Properties")) {
                return 20;
            }
            if (string.equals("RecoverOnlyOnce")) {
                return 49;
            }
            if (string.equals("RefreshMinutes")) {
                return 29;
            }
            if (string.equals("RollbackLocalTxUponConnClose")) {
                return 64;
            }
            if (string.equals("SecondsToTrustAnIdlePoolConnection")) {
                return 22;
            }
            if (string.equals("ShrinkFrequencySeconds")) {
                return 28;
            }
            if (string.equals("ShrinkPeriodMinutes")) {
                return 27;
            }
            if (string.equals("SqlStmtMaxParamLength")) {
                return 16;
            }
            if (string.equals("StatementCacheSize")) {
                return 61;
            }
            if (string.equals("StatementCacheType")) {
                return 62;
            }
            if (string.equals("StatementTimeout")) {
                return 66;
            }
            if (string.equals("SupportsLocalTransaction")) {
                return 41;
            }
            if (string.equals("Targets")) {
                return 7;
            }
            if (string.equals("TestConnectionsOnCreate")) {
                return 34;
            }
            if (string.equals("TestConnectionsOnRelease")) {
                return 33;
            }
            if (string.equals("TestConnectionsOnReserve")) {
                return 32;
            }
            if (string.equals("TestFrequencySeconds")) {
                return 30;
            }
            if (string.equals("TestStatementTimeout")) {
                return 65;
            }
            if (string.equals("TestTableName")) {
                return 31;
            }
            if (string.equals("URL")) {
                return 18;
            }
            if (string.equals("XAEndOnlyOnce")) {
                return 44;
            }
            if (string.equals("XAPassword")) {
                return 38;
            }
            if (string.equals("XAPasswordEncrypted")) {
                return 39;
            }
            if (string.equals("XAPreparedStatementCacheSize")) {
                return 47;
            }
            if (string.equals("XARetryDurationSeconds")) {
                return 52;
            }
            if (string.equals("XARetryIntervalSeconds")) {
                return 53;
            }
            if (string.equals("XASetTransactionTimeout")) {
                return 50;
            }
            if (string.equals("XATransactionTimeout")) {
                return 51;
            }
            if (string.equals("ConnLeakProfilingEnabled")) {
                return 12;
            }
            if (string.equals("ConnProfilingEnabled")) {
                return 13;
            }
            if (string.equals("CredentialMappingEnabled")) {
                return 68;
            }
            if (string.equals("IgnoreInUseConnectionsEnabled")) {
                return 67;
            }
            if (string.equals("PrepStmtCacheProfilingEnabled")) {
                return 10;
            }
            if (string.equals("RemoveInfectedConnectionsEnabled")) {
                return 63;
            }
            if (string.equals("ShrinkingEnabled")) {
                return 26;
            }
            if (string.equals("SqlStmtParamLoggingEnabled")) {
                return 15;
            }
            if (string.equals("SqlStmtProfilingEnabled")) {
                return 14;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isACLNameSet()) {
                    stringBuffer.append("ACLName");
                    stringBuffer.append(String.valueOf(this.bean.getACLName()));
                }
                if (this.bean.isCapacityIncrementSet()) {
                    stringBuffer.append("CapacityIncrement");
                    stringBuffer.append(String.valueOf(this.bean.getCapacityIncrement()));
                }
                if (this.bean.isConnectionCreationRetryFrequencySecondsSet()) {
                    stringBuffer.append("ConnectionCreationRetryFrequencySeconds");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionCreationRetryFrequencySeconds()));
                }
                if (this.bean.isConnectionReserveTimeoutSecondsSet()) {
                    stringBuffer.append("ConnectionReserveTimeoutSeconds");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionReserveTimeoutSeconds()));
                }
                if (this.bean.isCountOfRefreshFailuresTillDisableSet()) {
                    stringBuffer.append("CountOfRefreshFailuresTillDisable");
                    stringBuffer.append(String.valueOf(this.bean.getCountOfRefreshFailuresTillDisable()));
                }
                if (this.bean.isCountOfTestFailuresTillFlushSet()) {
                    stringBuffer.append("CountOfTestFailuresTillFlush");
                    stringBuffer.append(String.valueOf(this.bean.getCountOfTestFailuresTillFlush()));
                }
                if (this.bean.isDriverNameSet()) {
                    stringBuffer.append("DriverName");
                    stringBuffer.append(String.valueOf(this.bean.getDriverName()));
                }
                if (this.bean.isEnableResourceHealthMonitoringSet()) {
                    stringBuffer.append("EnableResourceHealthMonitoring");
                    stringBuffer.append(String.valueOf(this.bean.getEnableResourceHealthMonitoring()));
                }
                if (this.bean.isHighestNumUnavailableSet()) {
                    stringBuffer.append("HighestNumUnavailable");
                    stringBuffer.append(String.valueOf(this.bean.getHighestNumUnavailable()));
                }
                if (this.bean.isHighestNumWaitersSet()) {
                    stringBuffer.append("HighestNumWaiters");
                    stringBuffer.append(String.valueOf(this.bean.getHighestNumWaiters()));
                }
                if (this.bean.isInactiveConnectionTimeoutSecondsSet()) {
                    stringBuffer.append("InactiveConnectionTimeoutSeconds");
                    stringBuffer.append(String.valueOf(this.bean.getInactiveConnectionTimeoutSeconds()));
                }
                if (this.bean.isInitSQLSet()) {
                    stringBuffer.append("InitSQL");
                    stringBuffer.append(String.valueOf(this.bean.getInitSQL()));
                }
                if (this.bean.isInitialCapacitySet()) {
                    stringBuffer.append("InitialCapacity");
                    stringBuffer.append(String.valueOf(this.bean.getInitialCapacity()));
                }
                if (this.bean.isJDBCConnectionPoolRuntimeSet()) {
                    stringBuffer.append("JDBCConnectionPoolRuntime");
                    stringBuffer.append(String.valueOf(this.bean.getJDBCConnectionPoolRuntime()));
                }
                if (this.bean.isJDBCSystemResourceSet()) {
                    stringBuffer.append("JDBCSystemResource");
                    stringBuffer.append(String.valueOf(this.bean.getJDBCSystemResource()));
                }
                if (this.bean.isJDBCXADebugLevelSet()) {
                    stringBuffer.append("JDBCXADebugLevel");
                    stringBuffer.append(String.valueOf(this.bean.getJDBCXADebugLevel()));
                }
                if (this.bean.isKeepLogicalConnOpenOnReleaseSet()) {
                    stringBuffer.append("KeepLogicalConnOpenOnRelease");
                    stringBuffer.append(String.valueOf(this.bean.getKeepLogicalConnOpenOnRelease()));
                }
                if (this.bean.isKeepXAConnTillTxCompleteSet()) {
                    stringBuffer.append("KeepXAConnTillTxComplete");
                    stringBuffer.append(String.valueOf(this.bean.getKeepXAConnTillTxComplete()));
                }
                if (this.bean.isLoginDelaySecondsSet()) {
                    stringBuffer.append("LoginDelaySeconds");
                    stringBuffer.append(String.valueOf(this.bean.getLoginDelaySeconds()));
                }
                if (this.bean.isMaxCapacitySet()) {
                    stringBuffer.append("MaxCapacity");
                    stringBuffer.append(String.valueOf(this.bean.getMaxCapacity()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isNeedTxCtxOnCloseSet()) {
                    stringBuffer.append("NeedTxCtxOnClose");
                    stringBuffer.append(String.valueOf(this.bean.getNeedTxCtxOnClose()));
                }
                if (this.bean.isNewXAConnForCommitSet()) {
                    stringBuffer.append("NewXAConnForCommit");
                    stringBuffer.append(String.valueOf(this.bean.getNewXAConnForCommit()));
                }
                if (this.bean.isPasswordSet()) {
                    stringBuffer.append("Password");
                    stringBuffer.append(String.valueOf(this.bean.getPassword()));
                }
                if (this.bean.isPasswordEncryptedSet()) {
                    stringBuffer.append("PasswordEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getPasswordEncrypted())));
                }
                if (this.bean.isPrepStmtCacheProfilingThresholdSet()) {
                    stringBuffer.append("PrepStmtCacheProfilingThreshold");
                    stringBuffer.append(String.valueOf(this.bean.getPrepStmtCacheProfilingThreshold()));
                }
                if (this.bean.isPreparedStatementCacheSizeSet()) {
                    stringBuffer.append("PreparedStatementCacheSize");
                    stringBuffer.append(String.valueOf(this.bean.getPreparedStatementCacheSize()));
                }
                if (this.bean.isPropertiesSet()) {
                    stringBuffer.append("Properties");
                    stringBuffer.append(String.valueOf(this.bean.getProperties()));
                }
                if (this.bean.isRecoverOnlyOnceSet()) {
                    stringBuffer.append("RecoverOnlyOnce");
                    stringBuffer.append(String.valueOf(this.bean.getRecoverOnlyOnce()));
                }
                if (this.bean.isRefreshMinutesSet()) {
                    stringBuffer.append("RefreshMinutes");
                    stringBuffer.append(String.valueOf(this.bean.getRefreshMinutes()));
                }
                if (this.bean.isRollbackLocalTxUponConnCloseSet()) {
                    stringBuffer.append("RollbackLocalTxUponConnClose");
                    stringBuffer.append(String.valueOf(this.bean.getRollbackLocalTxUponConnClose()));
                }
                if (this.bean.isSecondsToTrustAnIdlePoolConnectionSet()) {
                    stringBuffer.append("SecondsToTrustAnIdlePoolConnection");
                    stringBuffer.append(String.valueOf(this.bean.getSecondsToTrustAnIdlePoolConnection()));
                }
                if (this.bean.isShrinkFrequencySecondsSet()) {
                    stringBuffer.append("ShrinkFrequencySeconds");
                    stringBuffer.append(String.valueOf(this.bean.getShrinkFrequencySeconds()));
                }
                if (this.bean.isShrinkPeriodMinutesSet()) {
                    stringBuffer.append("ShrinkPeriodMinutes");
                    stringBuffer.append(String.valueOf(this.bean.getShrinkPeriodMinutes()));
                }
                if (this.bean.isSqlStmtMaxParamLengthSet()) {
                    stringBuffer.append("SqlStmtMaxParamLength");
                    stringBuffer.append(String.valueOf(this.bean.getSqlStmtMaxParamLength()));
                }
                if (this.bean.isStatementCacheSizeSet()) {
                    stringBuffer.append("StatementCacheSize");
                    stringBuffer.append(String.valueOf(this.bean.getStatementCacheSize()));
                }
                if (this.bean.isStatementCacheTypeSet()) {
                    stringBuffer.append("StatementCacheType");
                    stringBuffer.append(String.valueOf(this.bean.getStatementCacheType()));
                }
                if (this.bean.isStatementTimeoutSet()) {
                    stringBuffer.append("StatementTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getStatementTimeout()));
                }
                if (this.bean.isSupportsLocalTransactionSet()) {
                    stringBuffer.append("SupportsLocalTransaction");
                    stringBuffer.append(String.valueOf(this.bean.getSupportsLocalTransaction()));
                }
                if (this.bean.isTargetsSet()) {
                    stringBuffer.append("Targets");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getTargets())));
                }
                if (this.bean.isTestConnectionsOnCreateSet()) {
                    stringBuffer.append("TestConnectionsOnCreate");
                    stringBuffer.append(String.valueOf(this.bean.getTestConnectionsOnCreate()));
                }
                if (this.bean.isTestConnectionsOnReleaseSet()) {
                    stringBuffer.append("TestConnectionsOnRelease");
                    stringBuffer.append(String.valueOf(this.bean.getTestConnectionsOnRelease()));
                }
                if (this.bean.isTestConnectionsOnReserveSet()) {
                    stringBuffer.append("TestConnectionsOnReserve");
                    stringBuffer.append(String.valueOf(this.bean.getTestConnectionsOnReserve()));
                }
                if (this.bean.isTestFrequencySecondsSet()) {
                    stringBuffer.append("TestFrequencySeconds");
                    stringBuffer.append(String.valueOf(this.bean.getTestFrequencySeconds()));
                }
                if (this.bean.isTestStatementTimeoutSet()) {
                    stringBuffer.append("TestStatementTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getTestStatementTimeout()));
                }
                if (this.bean.isTestTableNameSet()) {
                    stringBuffer.append("TestTableName");
                    stringBuffer.append(String.valueOf(this.bean.getTestTableName()));
                }
                if (this.bean.isURLSet()) {
                    stringBuffer.append("URL");
                    stringBuffer.append(String.valueOf(this.bean.getURL()));
                }
                if (this.bean.isXAEndOnlyOnceSet()) {
                    stringBuffer.append("XAEndOnlyOnce");
                    stringBuffer.append(String.valueOf(this.bean.getXAEndOnlyOnce()));
                }
                if (this.bean.isXAPasswordSet()) {
                    stringBuffer.append("XAPassword");
                    stringBuffer.append(String.valueOf(this.bean.getXAPassword()));
                }
                if (this.bean.isXAPasswordEncryptedSet()) {
                    stringBuffer.append("XAPasswordEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getXAPasswordEncrypted())));
                }
                if (this.bean.isXAPreparedStatementCacheSizeSet()) {
                    stringBuffer.append("XAPreparedStatementCacheSize");
                    stringBuffer.append(String.valueOf(this.bean.getXAPreparedStatementCacheSize()));
                }
                if (this.bean.isXARetryDurationSecondsSet()) {
                    stringBuffer.append("XARetryDurationSeconds");
                    stringBuffer.append(String.valueOf(this.bean.getXARetryDurationSeconds()));
                }
                if (this.bean.isXARetryIntervalSecondsSet()) {
                    stringBuffer.append("XARetryIntervalSeconds");
                    stringBuffer.append(String.valueOf(this.bean.getXARetryIntervalSeconds()));
                }
                if (this.bean.isXASetTransactionTimeoutSet()) {
                    stringBuffer.append("XASetTransactionTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getXASetTransactionTimeout()));
                }
                if (this.bean.isXATransactionTimeoutSet()) {
                    stringBuffer.append("XATransactionTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getXATransactionTimeout()));
                }
                if (this.bean.isConnLeakProfilingEnabledSet()) {
                    stringBuffer.append("ConnLeakProfilingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isConnLeakProfilingEnabled()));
                }
                if (this.bean.isConnProfilingEnabledSet()) {
                    stringBuffer.append("ConnProfilingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isConnProfilingEnabled()));
                }
                if (this.bean.isCredentialMappingEnabledSet()) {
                    stringBuffer.append("CredentialMappingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isCredentialMappingEnabled()));
                }
                if (this.bean.isIgnoreInUseConnectionsEnabledSet()) {
                    stringBuffer.append("IgnoreInUseConnectionsEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isIgnoreInUseConnectionsEnabled()));
                }
                if (this.bean.isPrepStmtCacheProfilingEnabledSet()) {
                    stringBuffer.append("PrepStmtCacheProfilingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isPrepStmtCacheProfilingEnabled()));
                }
                if (this.bean.isRemoveInfectedConnectionsEnabledSet()) {
                    stringBuffer.append("RemoveInfectedConnectionsEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isRemoveInfectedConnectionsEnabled()));
                }
                if (this.bean.isShrinkingEnabledSet()) {
                    stringBuffer.append("ShrinkingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isShrinkingEnabled()));
                }
                if (this.bean.isSqlStmtParamLoggingEnabledSet()) {
                    stringBuffer.append("SqlStmtParamLoggingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isSqlStmtParamLoggingEnabled()));
                }
                if (this.bean.isSqlStmtProfilingEnabledSet()) {
                    stringBuffer.append("SqlStmtProfilingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isSqlStmtProfilingEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                JDBCConnectionPoolMBeanImpl jDBCConnectionPoolMBeanImpl = (JDBCConnectionPoolMBeanImpl)abstractDescriptorBean;
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ACLName", this.bean.getACLName(), jDBCConnectionPoolMBeanImpl.getACLName(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("CapacityIncrement", this.bean.getCapacityIncrement(), jDBCConnectionPoolMBeanImpl.getCapacityIncrement(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ConnectionCreationRetryFrequencySeconds", this.bean.getConnectionCreationRetryFrequencySeconds(), jDBCConnectionPoolMBeanImpl.getConnectionCreationRetryFrequencySeconds(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ConnectionReserveTimeoutSeconds", this.bean.getConnectionReserveTimeoutSeconds(), jDBCConnectionPoolMBeanImpl.getConnectionReserveTimeoutSeconds(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("CountOfRefreshFailuresTillDisable", this.bean.getCountOfRefreshFailuresTillDisable(), jDBCConnectionPoolMBeanImpl.getCountOfRefreshFailuresTillDisable(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("CountOfTestFailuresTillFlush", this.bean.getCountOfTestFailuresTillFlush(), jDBCConnectionPoolMBeanImpl.getCountOfTestFailuresTillFlush(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("DriverName", this.bean.getDriverName(), jDBCConnectionPoolMBeanImpl.getDriverName(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("EnableResourceHealthMonitoring", this.bean.getEnableResourceHealthMonitoring(), jDBCConnectionPoolMBeanImpl.getEnableResourceHealthMonitoring(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("HighestNumUnavailable", this.bean.getHighestNumUnavailable(), jDBCConnectionPoolMBeanImpl.getHighestNumUnavailable(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("HighestNumWaiters", this.bean.getHighestNumWaiters(), jDBCConnectionPoolMBeanImpl.getHighestNumWaiters(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("InactiveConnectionTimeoutSeconds", this.bean.getInactiveConnectionTimeoutSeconds(), jDBCConnectionPoolMBeanImpl.getInactiveConnectionTimeoutSeconds(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("InitSQL", this.bean.getInitSQL(), jDBCConnectionPoolMBeanImpl.getInitSQL(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("InitialCapacity", this.bean.getInitialCapacity(), jDBCConnectionPoolMBeanImpl.getInitialCapacity(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("JDBCSystemResource", this.bean.getJDBCSystemResource(), jDBCConnectionPoolMBeanImpl.getJDBCSystemResource(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("JDBCXADebugLevel", this.bean.getJDBCXADebugLevel(), jDBCConnectionPoolMBeanImpl.getJDBCXADebugLevel(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("KeepLogicalConnOpenOnRelease", this.bean.getKeepLogicalConnOpenOnRelease(), jDBCConnectionPoolMBeanImpl.getKeepLogicalConnOpenOnRelease(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("KeepXAConnTillTxComplete", this.bean.getKeepXAConnTillTxComplete(), jDBCConnectionPoolMBeanImpl.getKeepXAConnTillTxComplete(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LoginDelaySeconds", this.bean.getLoginDelaySeconds(), jDBCConnectionPoolMBeanImpl.getLoginDelaySeconds(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("MaxCapacity", this.bean.getMaxCapacity(), jDBCConnectionPoolMBeanImpl.getMaxCapacity(), true);
                }
                this.computeDiff("Name", this.bean.getName(), jDBCConnectionPoolMBeanImpl.getName(), false);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("NeedTxCtxOnClose", this.bean.getNeedTxCtxOnClose(), jDBCConnectionPoolMBeanImpl.getNeedTxCtxOnClose(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("NewXAConnForCommit", this.bean.getNewXAConnForCommit(), jDBCConnectionPoolMBeanImpl.getNewXAConnForCommit(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("PasswordEncrypted", this.bean.getPasswordEncrypted(), jDBCConnectionPoolMBeanImpl.getPasswordEncrypted(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("PrepStmtCacheProfilingThreshold", this.bean.getPrepStmtCacheProfilingThreshold(), jDBCConnectionPoolMBeanImpl.getPrepStmtCacheProfilingThreshold(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("PreparedStatementCacheSize", this.bean.getPreparedStatementCacheSize(), jDBCConnectionPoolMBeanImpl.getPreparedStatementCacheSize(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("Properties", this.bean.getProperties(), jDBCConnectionPoolMBeanImpl.getProperties(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("RecoverOnlyOnce", this.bean.getRecoverOnlyOnce(), jDBCConnectionPoolMBeanImpl.getRecoverOnlyOnce(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("RefreshMinutes", this.bean.getRefreshMinutes(), jDBCConnectionPoolMBeanImpl.getRefreshMinutes(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("RollbackLocalTxUponConnClose", this.bean.getRollbackLocalTxUponConnClose(), jDBCConnectionPoolMBeanImpl.getRollbackLocalTxUponConnClose(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("SecondsToTrustAnIdlePoolConnection", this.bean.getSecondsToTrustAnIdlePoolConnection(), jDBCConnectionPoolMBeanImpl.getSecondsToTrustAnIdlePoolConnection(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ShrinkFrequencySeconds", this.bean.getShrinkFrequencySeconds(), jDBCConnectionPoolMBeanImpl.getShrinkFrequencySeconds(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ShrinkPeriodMinutes", this.bean.getShrinkPeriodMinutes(), jDBCConnectionPoolMBeanImpl.getShrinkPeriodMinutes(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("SqlStmtMaxParamLength", this.bean.getSqlStmtMaxParamLength(), jDBCConnectionPoolMBeanImpl.getSqlStmtMaxParamLength(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("StatementCacheSize", this.bean.getStatementCacheSize(), jDBCConnectionPoolMBeanImpl.getStatementCacheSize(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("StatementCacheType", this.bean.getStatementCacheType(), jDBCConnectionPoolMBeanImpl.getStatementCacheType(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("StatementTimeout", this.bean.getStatementTimeout(), jDBCConnectionPoolMBeanImpl.getStatementTimeout(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("SupportsLocalTransaction", this.bean.getSupportsLocalTransaction(), jDBCConnectionPoolMBeanImpl.getSupportsLocalTransaction(), false);
                }
                this.computeDiff("Targets", this.bean.getTargets(), jDBCConnectionPoolMBeanImpl.getTargets(), true);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("TestConnectionsOnCreate", this.bean.getTestConnectionsOnCreate(), jDBCConnectionPoolMBeanImpl.getTestConnectionsOnCreate(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("TestConnectionsOnRelease", this.bean.getTestConnectionsOnRelease(), jDBCConnectionPoolMBeanImpl.getTestConnectionsOnRelease(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("TestConnectionsOnReserve", this.bean.getTestConnectionsOnReserve(), jDBCConnectionPoolMBeanImpl.getTestConnectionsOnReserve(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("TestFrequencySeconds", this.bean.getTestFrequencySeconds(), jDBCConnectionPoolMBeanImpl.getTestFrequencySeconds(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("TestStatementTimeout", this.bean.getTestStatementTimeout(), jDBCConnectionPoolMBeanImpl.getTestStatementTimeout(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("TestTableName", this.bean.getTestTableName(), jDBCConnectionPoolMBeanImpl.getTestTableName(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("URL", this.bean.getURL(), jDBCConnectionPoolMBeanImpl.getURL(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("XAEndOnlyOnce", this.bean.getXAEndOnlyOnce(), jDBCConnectionPoolMBeanImpl.getXAEndOnlyOnce(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("XAPasswordEncrypted", this.bean.getXAPasswordEncrypted(), jDBCConnectionPoolMBeanImpl.getXAPasswordEncrypted(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("XAPreparedStatementCacheSize", this.bean.getXAPreparedStatementCacheSize(), jDBCConnectionPoolMBeanImpl.getXAPreparedStatementCacheSize(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("XARetryDurationSeconds", this.bean.getXARetryDurationSeconds(), jDBCConnectionPoolMBeanImpl.getXARetryDurationSeconds(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("XARetryIntervalSeconds", this.bean.getXARetryIntervalSeconds(), jDBCConnectionPoolMBeanImpl.getXARetryIntervalSeconds(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("XASetTransactionTimeout", this.bean.getXASetTransactionTimeout(), jDBCConnectionPoolMBeanImpl.getXASetTransactionTimeout(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("XATransactionTimeout", this.bean.getXATransactionTimeout(), jDBCConnectionPoolMBeanImpl.getXATransactionTimeout(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ConnLeakProfilingEnabled", this.bean.isConnLeakProfilingEnabled(), jDBCConnectionPoolMBeanImpl.isConnLeakProfilingEnabled(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ConnProfilingEnabled", this.bean.isConnProfilingEnabled(), jDBCConnectionPoolMBeanImpl.isConnProfilingEnabled(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("CredentialMappingEnabled", this.bean.isCredentialMappingEnabled(), jDBCConnectionPoolMBeanImpl.isCredentialMappingEnabled(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("IgnoreInUseConnectionsEnabled", this.bean.isIgnoreInUseConnectionsEnabled(), jDBCConnectionPoolMBeanImpl.isIgnoreInUseConnectionsEnabled(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("PrepStmtCacheProfilingEnabled", this.bean.isPrepStmtCacheProfilingEnabled(), jDBCConnectionPoolMBeanImpl.isPrepStmtCacheProfilingEnabled(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("RemoveInfectedConnectionsEnabled", this.bean.isRemoveInfectedConnectionsEnabled(), jDBCConnectionPoolMBeanImpl.isRemoveInfectedConnectionsEnabled(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ShrinkingEnabled", this.bean.isShrinkingEnabled(), jDBCConnectionPoolMBeanImpl.isShrinkingEnabled(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("SqlStmtParamLoggingEnabled", this.bean.isSqlStmtParamLoggingEnabled(), jDBCConnectionPoolMBeanImpl.isSqlStmtParamLoggingEnabled(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("SqlStmtProfilingEnabled", this.bean.isSqlStmtProfilingEnabled(), jDBCConnectionPoolMBeanImpl.isSqlStmtProfilingEnabled(), true);
                }
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                JDBCConnectionPoolMBeanImpl jDBCConnectionPoolMBeanImpl = (JDBCConnectionPoolMBeanImpl)beanUpdateEvent.getSourceBean();
                JDBCConnectionPoolMBeanImpl jDBCConnectionPoolMBeanImpl2 = (JDBCConnectionPoolMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("ACLName")) {
                    jDBCConnectionPoolMBeanImpl.setACLName(jDBCConnectionPoolMBeanImpl2.getACLName());
                    jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else if (string.equals("CapacityIncrement")) {
                    jDBCConnectionPoolMBeanImpl.setCapacityIncrement(jDBCConnectionPoolMBeanImpl2.getCapacityIncrement());
                    jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                } else if (string.equals("ConnectionCreationRetryFrequencySeconds")) {
                    jDBCConnectionPoolMBeanImpl.setConnectionCreationRetryFrequencySeconds(jDBCConnectionPoolMBeanImpl2.getConnectionCreationRetryFrequencySeconds());
                    jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 56);
                } else if (string.equals("ConnectionReserveTimeoutSeconds")) {
                    jDBCConnectionPoolMBeanImpl.setConnectionReserveTimeoutSeconds(jDBCConnectionPoolMBeanImpl2.getConnectionReserveTimeoutSeconds());
                    jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 55);
                } else if (string.equals("CountOfRefreshFailuresTillDisable")) {
                    jDBCConnectionPoolMBeanImpl.setCountOfRefreshFailuresTillDisable(jDBCConnectionPoolMBeanImpl2.getCountOfRefreshFailuresTillDisable());
                    jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 70);
                } else if (string.equals("CountOfTestFailuresTillFlush")) {
                    jDBCConnectionPoolMBeanImpl.setCountOfTestFailuresTillFlush(jDBCConnectionPoolMBeanImpl2.getCountOfTestFailuresTillFlush());
                    jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 69);
                } else if (string.equals("DriverName")) {
                    jDBCConnectionPoolMBeanImpl.setDriverName(jDBCConnectionPoolMBeanImpl2.getDriverName());
                    jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                } else if (string.equals("EnableResourceHealthMonitoring")) {
                    jDBCConnectionPoolMBeanImpl.setEnableResourceHealthMonitoring(jDBCConnectionPoolMBeanImpl2.getEnableResourceHealthMonitoring());
                    jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 48);
                } else if (string.equals("HighestNumUnavailable")) {
                    jDBCConnectionPoolMBeanImpl.setHighestNumUnavailable(jDBCConnectionPoolMBeanImpl2.getHighestNumUnavailable());
                    jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 59);
                } else if (string.equals("HighestNumWaiters")) {
                    jDBCConnectionPoolMBeanImpl.setHighestNumWaiters(jDBCConnectionPoolMBeanImpl2.getHighestNumWaiters());
                    jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 58);
                } else if (string.equals("InactiveConnectionTimeoutSeconds")) {
                    jDBCConnectionPoolMBeanImpl.setInactiveConnectionTimeoutSeconds(jDBCConnectionPoolMBeanImpl2.getInactiveConnectionTimeoutSeconds());
                    jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 57);
                } else if (string.equals("InitSQL")) {
                    jDBCConnectionPoolMBeanImpl.setInitSQL(jDBCConnectionPoolMBeanImpl2.getInitSQL());
                    jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 60);
                } else if (string.equals("InitialCapacity")) {
                    jDBCConnectionPoolMBeanImpl.setInitialCapacity(jDBCConnectionPoolMBeanImpl2.getInitialCapacity());
                    jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                } else if (!string.equals("JDBCConnectionPoolRuntime")) {
                    if (string.equals("JDBCSystemResource")) {
                        jDBCConnectionPoolMBeanImpl.setJDBCSystemResourceAsString(jDBCConnectionPoolMBeanImpl2.getJDBCSystemResourceAsString());
                        jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                    } else if (string.equals("JDBCXADebugLevel")) {
                        jDBCConnectionPoolMBeanImpl.setJDBCXADebugLevel(jDBCConnectionPoolMBeanImpl2.getJDBCXADebugLevel());
                        jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 40);
                    } else if (string.equals("KeepLogicalConnOpenOnRelease")) {
                        jDBCConnectionPoolMBeanImpl.setKeepLogicalConnOpenOnRelease(jDBCConnectionPoolMBeanImpl2.getKeepLogicalConnOpenOnRelease());
                        jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 46);
                    } else if (string.equals("KeepXAConnTillTxComplete")) {
                        jDBCConnectionPoolMBeanImpl.setKeepXAConnTillTxComplete(jDBCConnectionPoolMBeanImpl2.getKeepXAConnTillTxComplete());
                        jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 42);
                    } else if (string.equals("LoginDelaySeconds")) {
                        jDBCConnectionPoolMBeanImpl.setLoginDelaySeconds(jDBCConnectionPoolMBeanImpl2.getLoginDelaySeconds());
                        jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                    } else if (string.equals("MaxCapacity")) {
                        jDBCConnectionPoolMBeanImpl.setMaxCapacity(jDBCConnectionPoolMBeanImpl2.getMaxCapacity());
                        jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                    } else if (string.equals("Name")) {
                        jDBCConnectionPoolMBeanImpl.setName(jDBCConnectionPoolMBeanImpl2.getName());
                        jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                    } else if (string.equals("NeedTxCtxOnClose")) {
                        jDBCConnectionPoolMBeanImpl.setNeedTxCtxOnClose(jDBCConnectionPoolMBeanImpl2.getNeedTxCtxOnClose());
                        jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 43);
                    } else if (string.equals("NewXAConnForCommit")) {
                        jDBCConnectionPoolMBeanImpl.setNewXAConnForCommit(jDBCConnectionPoolMBeanImpl2.getNewXAConnForCommit());
                        jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 45);
                    } else if (!string.equals("Password")) {
                        if (string.equals("PasswordEncrypted")) {
                            jDBCConnectionPoolMBeanImpl.setPasswordEncrypted(jDBCConnectionPoolMBeanImpl2.getPasswordEncrypted());
                            jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 37);
                        } else if (string.equals("PrepStmtCacheProfilingThreshold")) {
                            jDBCConnectionPoolMBeanImpl.setPrepStmtCacheProfilingThreshold(jDBCConnectionPoolMBeanImpl2.getPrepStmtCacheProfilingThreshold());
                            jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                        } else if (string.equals("PreparedStatementCacheSize")) {
                            jDBCConnectionPoolMBeanImpl.setPreparedStatementCacheSize(jDBCConnectionPoolMBeanImpl2.getPreparedStatementCacheSize());
                            jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 54);
                        } else if (string.equals("Properties")) {
                            jDBCConnectionPoolMBeanImpl.setProperties(jDBCConnectionPoolMBeanImpl2.getProperties() == null ? null : (Properties)jDBCConnectionPoolMBeanImpl2.getProperties().clone());
                            jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                        } else if (string.equals("RecoverOnlyOnce")) {
                            jDBCConnectionPoolMBeanImpl.setRecoverOnlyOnce(jDBCConnectionPoolMBeanImpl2.getRecoverOnlyOnce());
                            jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 49);
                        } else if (string.equals("RefreshMinutes")) {
                            jDBCConnectionPoolMBeanImpl.setRefreshMinutes(jDBCConnectionPoolMBeanImpl2.getRefreshMinutes());
                            jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 29);
                        } else if (string.equals("RollbackLocalTxUponConnClose")) {
                            jDBCConnectionPoolMBeanImpl.setRollbackLocalTxUponConnClose(jDBCConnectionPoolMBeanImpl2.getRollbackLocalTxUponConnClose());
                            jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 64);
                        } else if (string.equals("SecondsToTrustAnIdlePoolConnection")) {
                            jDBCConnectionPoolMBeanImpl.setSecondsToTrustAnIdlePoolConnection(jDBCConnectionPoolMBeanImpl2.getSecondsToTrustAnIdlePoolConnection());
                            jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                        } else if (string.equals("ShrinkFrequencySeconds")) {
                            jDBCConnectionPoolMBeanImpl.setShrinkFrequencySeconds(jDBCConnectionPoolMBeanImpl2.getShrinkFrequencySeconds());
                            jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 28);
                        } else if (string.equals("ShrinkPeriodMinutes")) {
                            jDBCConnectionPoolMBeanImpl.setShrinkPeriodMinutes(jDBCConnectionPoolMBeanImpl2.getShrinkPeriodMinutes());
                            jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 27);
                        } else if (string.equals("SqlStmtMaxParamLength")) {
                            jDBCConnectionPoolMBeanImpl.setSqlStmtMaxParamLength(jDBCConnectionPoolMBeanImpl2.getSqlStmtMaxParamLength());
                            jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                        } else if (string.equals("StatementCacheSize")) {
                            jDBCConnectionPoolMBeanImpl.setStatementCacheSize(jDBCConnectionPoolMBeanImpl2.getStatementCacheSize());
                            jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 61);
                        } else if (string.equals("StatementCacheType")) {
                            jDBCConnectionPoolMBeanImpl.setStatementCacheType(jDBCConnectionPoolMBeanImpl2.getStatementCacheType());
                            jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 62);
                        } else if (string.equals("StatementTimeout")) {
                            jDBCConnectionPoolMBeanImpl.setStatementTimeout(jDBCConnectionPoolMBeanImpl2.getStatementTimeout());
                            jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 66);
                        } else if (string.equals("SupportsLocalTransaction")) {
                            jDBCConnectionPoolMBeanImpl.setSupportsLocalTransaction(jDBCConnectionPoolMBeanImpl2.getSupportsLocalTransaction());
                            jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 41);
                        } else if (string.equals("Targets")) {
                            jDBCConnectionPoolMBeanImpl.setTargetsAsString(jDBCConnectionPoolMBeanImpl2.getTargetsAsString());
                            jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                        } else if (string.equals("TestConnectionsOnCreate")) {
                            jDBCConnectionPoolMBeanImpl.setTestConnectionsOnCreate(jDBCConnectionPoolMBeanImpl2.getTestConnectionsOnCreate());
                            jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 34);
                        } else if (string.equals("TestConnectionsOnRelease")) {
                            jDBCConnectionPoolMBeanImpl.setTestConnectionsOnRelease(jDBCConnectionPoolMBeanImpl2.getTestConnectionsOnRelease());
                            jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 33);
                        } else if (string.equals("TestConnectionsOnReserve")) {
                            jDBCConnectionPoolMBeanImpl.setTestConnectionsOnReserve(jDBCConnectionPoolMBeanImpl2.getTestConnectionsOnReserve());
                            jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 32);
                        } else if (string.equals("TestFrequencySeconds")) {
                            jDBCConnectionPoolMBeanImpl.setTestFrequencySeconds(jDBCConnectionPoolMBeanImpl2.getTestFrequencySeconds());
                            jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 30);
                        } else if (string.equals("TestStatementTimeout")) {
                            jDBCConnectionPoolMBeanImpl.setTestStatementTimeout(jDBCConnectionPoolMBeanImpl2.getTestStatementTimeout());
                            jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 65);
                        } else if (string.equals("TestTableName")) {
                            jDBCConnectionPoolMBeanImpl.setTestTableName(jDBCConnectionPoolMBeanImpl2.getTestTableName());
                            jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 31);
                        } else if (string.equals("URL")) {
                            jDBCConnectionPoolMBeanImpl.setURL(jDBCConnectionPoolMBeanImpl2.getURL());
                            jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                        } else if (string.equals("XAEndOnlyOnce")) {
                            jDBCConnectionPoolMBeanImpl.setXAEndOnlyOnce(jDBCConnectionPoolMBeanImpl2.getXAEndOnlyOnce());
                            jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 44);
                        } else if (!string.equals("XAPassword")) {
                            if (string.equals("XAPasswordEncrypted")) {
                                jDBCConnectionPoolMBeanImpl.setXAPasswordEncrypted(jDBCConnectionPoolMBeanImpl2.getXAPasswordEncrypted());
                                jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 39);
                            } else if (string.equals("XAPreparedStatementCacheSize")) {
                                jDBCConnectionPoolMBeanImpl.setXAPreparedStatementCacheSize(jDBCConnectionPoolMBeanImpl2.getXAPreparedStatementCacheSize());
                                jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 47);
                            } else if (string.equals("XARetryDurationSeconds")) {
                                jDBCConnectionPoolMBeanImpl.setXARetryDurationSeconds(jDBCConnectionPoolMBeanImpl2.getXARetryDurationSeconds());
                                jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 52);
                            } else if (string.equals("XARetryIntervalSeconds")) {
                                jDBCConnectionPoolMBeanImpl.setXARetryIntervalSeconds(jDBCConnectionPoolMBeanImpl2.getXARetryIntervalSeconds());
                                jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 53);
                            } else if (string.equals("XASetTransactionTimeout")) {
                                jDBCConnectionPoolMBeanImpl.setXASetTransactionTimeout(jDBCConnectionPoolMBeanImpl2.getXASetTransactionTimeout());
                                jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 50);
                            } else if (string.equals("XATransactionTimeout")) {
                                jDBCConnectionPoolMBeanImpl.setXATransactionTimeout(jDBCConnectionPoolMBeanImpl2.getXATransactionTimeout());
                                jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 51);
                            } else if (string.equals("ConnLeakProfilingEnabled")) {
                                jDBCConnectionPoolMBeanImpl.setConnLeakProfilingEnabled(jDBCConnectionPoolMBeanImpl2.isConnLeakProfilingEnabled());
                                jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                            } else if (string.equals("ConnProfilingEnabled")) {
                                jDBCConnectionPoolMBeanImpl.setConnProfilingEnabled(jDBCConnectionPoolMBeanImpl2.isConnProfilingEnabled());
                                jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                            } else if (string.equals("CredentialMappingEnabled")) {
                                jDBCConnectionPoolMBeanImpl.setCredentialMappingEnabled(jDBCConnectionPoolMBeanImpl2.isCredentialMappingEnabled());
                                jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 68);
                            } else if (string.equals("IgnoreInUseConnectionsEnabled")) {
                                jDBCConnectionPoolMBeanImpl.setIgnoreInUseConnectionsEnabled(jDBCConnectionPoolMBeanImpl2.isIgnoreInUseConnectionsEnabled());
                                jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 67);
                            } else if (string.equals("PrepStmtCacheProfilingEnabled")) {
                                jDBCConnectionPoolMBeanImpl.setPrepStmtCacheProfilingEnabled(jDBCConnectionPoolMBeanImpl2.isPrepStmtCacheProfilingEnabled());
                                jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                            } else if (string.equals("RemoveInfectedConnectionsEnabled")) {
                                jDBCConnectionPoolMBeanImpl.setRemoveInfectedConnectionsEnabled(jDBCConnectionPoolMBeanImpl2.isRemoveInfectedConnectionsEnabled());
                                jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 63);
                            } else if (string.equals("ShrinkingEnabled")) {
                                jDBCConnectionPoolMBeanImpl.setShrinkingEnabled(jDBCConnectionPoolMBeanImpl2.isShrinkingEnabled());
                                jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 26);
                            } else if (string.equals("SqlStmtParamLoggingEnabled")) {
                                jDBCConnectionPoolMBeanImpl.setSqlStmtParamLoggingEnabled(jDBCConnectionPoolMBeanImpl2.isSqlStmtParamLoggingEnabled());
                                jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                            } else if (string.equals("SqlStmtProfilingEnabled")) {
                                jDBCConnectionPoolMBeanImpl.setSqlStmtProfilingEnabled(jDBCConnectionPoolMBeanImpl2.isSqlStmtProfilingEnabled());
                                jDBCConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                            } else {
                                super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                            }
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                byte[] byArray;
                JDBCConnectionPoolMBeanImpl jDBCConnectionPoolMBeanImpl = (JDBCConnectionPoolMBeanImpl)abstractDescriptorBean;
                super.finishCopy(jDBCConnectionPoolMBeanImpl, bl, list);
                if (bl && (list == null || !list.contains("ACLName")) && this.bean.isACLNameSet()) {
                    jDBCConnectionPoolMBeanImpl.setACLName(this.bean.getACLName());
                }
                if (bl && (list == null || !list.contains("CapacityIncrement")) && this.bean.isCapacityIncrementSet()) {
                    jDBCConnectionPoolMBeanImpl.setCapacityIncrement(this.bean.getCapacityIncrement());
                }
                if (bl && (list == null || !list.contains("ConnectionCreationRetryFrequencySeconds")) && this.bean.isConnectionCreationRetryFrequencySecondsSet()) {
                    jDBCConnectionPoolMBeanImpl.setConnectionCreationRetryFrequencySeconds(this.bean.getConnectionCreationRetryFrequencySeconds());
                }
                if (bl && (list == null || !list.contains("ConnectionReserveTimeoutSeconds")) && this.bean.isConnectionReserveTimeoutSecondsSet()) {
                    jDBCConnectionPoolMBeanImpl.setConnectionReserveTimeoutSeconds(this.bean.getConnectionReserveTimeoutSeconds());
                }
                if (bl && (list == null || !list.contains("CountOfRefreshFailuresTillDisable")) && this.bean.isCountOfRefreshFailuresTillDisableSet()) {
                    jDBCConnectionPoolMBeanImpl.setCountOfRefreshFailuresTillDisable(this.bean.getCountOfRefreshFailuresTillDisable());
                }
                if (bl && (list == null || !list.contains("CountOfTestFailuresTillFlush")) && this.bean.isCountOfTestFailuresTillFlushSet()) {
                    jDBCConnectionPoolMBeanImpl.setCountOfTestFailuresTillFlush(this.bean.getCountOfTestFailuresTillFlush());
                }
                if (bl && (list == null || !list.contains("DriverName")) && this.bean.isDriverNameSet()) {
                    jDBCConnectionPoolMBeanImpl.setDriverName(this.bean.getDriverName());
                }
                if (bl && (list == null || !list.contains("EnableResourceHealthMonitoring")) && this.bean.isEnableResourceHealthMonitoringSet()) {
                    jDBCConnectionPoolMBeanImpl.setEnableResourceHealthMonitoring(this.bean.getEnableResourceHealthMonitoring());
                }
                if (bl && (list == null || !list.contains("HighestNumUnavailable")) && this.bean.isHighestNumUnavailableSet()) {
                    jDBCConnectionPoolMBeanImpl.setHighestNumUnavailable(this.bean.getHighestNumUnavailable());
                }
                if (bl && (list == null || !list.contains("HighestNumWaiters")) && this.bean.isHighestNumWaitersSet()) {
                    jDBCConnectionPoolMBeanImpl.setHighestNumWaiters(this.bean.getHighestNumWaiters());
                }
                if (bl && (list == null || !list.contains("InactiveConnectionTimeoutSeconds")) && this.bean.isInactiveConnectionTimeoutSecondsSet()) {
                    jDBCConnectionPoolMBeanImpl.setInactiveConnectionTimeoutSeconds(this.bean.getInactiveConnectionTimeoutSeconds());
                }
                if (bl && (list == null || !list.contains("InitSQL")) && this.bean.isInitSQLSet()) {
                    jDBCConnectionPoolMBeanImpl.setInitSQL(this.bean.getInitSQL());
                }
                if (bl && (list == null || !list.contains("InitialCapacity")) && this.bean.isInitialCapacitySet()) {
                    jDBCConnectionPoolMBeanImpl.setInitialCapacity(this.bean.getInitialCapacity());
                }
                if (bl && (list == null || !list.contains("JDBCSystemResource")) && this.bean.isJDBCSystemResourceSet()) {
                    jDBCConnectionPoolMBeanImpl._unSet(jDBCConnectionPoolMBeanImpl, 9);
                    jDBCConnectionPoolMBeanImpl.setJDBCSystemResourceAsString(this.bean.getJDBCSystemResourceAsString());
                }
                if (bl && (list == null || !list.contains("JDBCXADebugLevel")) && this.bean.isJDBCXADebugLevelSet()) {
                    jDBCConnectionPoolMBeanImpl.setJDBCXADebugLevel(this.bean.getJDBCXADebugLevel());
                }
                if (bl && (list == null || !list.contains("KeepLogicalConnOpenOnRelease")) && this.bean.isKeepLogicalConnOpenOnReleaseSet()) {
                    jDBCConnectionPoolMBeanImpl.setKeepLogicalConnOpenOnRelease(this.bean.getKeepLogicalConnOpenOnRelease());
                }
                if (bl && (list == null || !list.contains("KeepXAConnTillTxComplete")) && this.bean.isKeepXAConnTillTxCompleteSet()) {
                    jDBCConnectionPoolMBeanImpl.setKeepXAConnTillTxComplete(this.bean.getKeepXAConnTillTxComplete());
                }
                if (bl && (list == null || !list.contains("LoginDelaySeconds")) && this.bean.isLoginDelaySecondsSet()) {
                    jDBCConnectionPoolMBeanImpl.setLoginDelaySeconds(this.bean.getLoginDelaySeconds());
                }
                if (bl && (list == null || !list.contains("MaxCapacity")) && this.bean.isMaxCapacitySet()) {
                    jDBCConnectionPoolMBeanImpl.setMaxCapacity(this.bean.getMaxCapacity());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    jDBCConnectionPoolMBeanImpl.setName(this.bean.getName());
                }
                if (bl && (list == null || !list.contains("NeedTxCtxOnClose")) && this.bean.isNeedTxCtxOnCloseSet()) {
                    jDBCConnectionPoolMBeanImpl.setNeedTxCtxOnClose(this.bean.getNeedTxCtxOnClose());
                }
                if (bl && (list == null || !list.contains("NewXAConnForCommit")) && this.bean.isNewXAConnForCommitSet()) {
                    jDBCConnectionPoolMBeanImpl.setNewXAConnForCommit(this.bean.getNewXAConnForCommit());
                }
                if (bl && (list == null || !list.contains("PasswordEncrypted")) && this.bean.isPasswordEncryptedSet()) {
                    byArray = this.bean.getPasswordEncrypted();
                    jDBCConnectionPoolMBeanImpl.setPasswordEncrypted(byArray == null ? null : (byte[])byArray.clone());
                }
                if (bl && (list == null || !list.contains("PrepStmtCacheProfilingThreshold")) && this.bean.isPrepStmtCacheProfilingThresholdSet()) {
                    jDBCConnectionPoolMBeanImpl.setPrepStmtCacheProfilingThreshold(this.bean.getPrepStmtCacheProfilingThreshold());
                }
                if (bl && (list == null || !list.contains("PreparedStatementCacheSize")) && this.bean.isPreparedStatementCacheSizeSet()) {
                    jDBCConnectionPoolMBeanImpl.setPreparedStatementCacheSize(this.bean.getPreparedStatementCacheSize());
                }
                if (bl && (list == null || !list.contains("Properties")) && this.bean.isPropertiesSet()) {
                    jDBCConnectionPoolMBeanImpl.setProperties(this.bean.getProperties());
                }
                if (bl && (list == null || !list.contains("RecoverOnlyOnce")) && this.bean.isRecoverOnlyOnceSet()) {
                    jDBCConnectionPoolMBeanImpl.setRecoverOnlyOnce(this.bean.getRecoverOnlyOnce());
                }
                if (bl && (list == null || !list.contains("RefreshMinutes")) && this.bean.isRefreshMinutesSet()) {
                    jDBCConnectionPoolMBeanImpl.setRefreshMinutes(this.bean.getRefreshMinutes());
                }
                if (bl && (list == null || !list.contains("RollbackLocalTxUponConnClose")) && this.bean.isRollbackLocalTxUponConnCloseSet()) {
                    jDBCConnectionPoolMBeanImpl.setRollbackLocalTxUponConnClose(this.bean.getRollbackLocalTxUponConnClose());
                }
                if (bl && (list == null || !list.contains("SecondsToTrustAnIdlePoolConnection")) && this.bean.isSecondsToTrustAnIdlePoolConnectionSet()) {
                    jDBCConnectionPoolMBeanImpl.setSecondsToTrustAnIdlePoolConnection(this.bean.getSecondsToTrustAnIdlePoolConnection());
                }
                if (bl && (list == null || !list.contains("ShrinkFrequencySeconds")) && this.bean.isShrinkFrequencySecondsSet()) {
                    jDBCConnectionPoolMBeanImpl.setShrinkFrequencySeconds(this.bean.getShrinkFrequencySeconds());
                }
                if (bl && (list == null || !list.contains("ShrinkPeriodMinutes")) && this.bean.isShrinkPeriodMinutesSet()) {
                    jDBCConnectionPoolMBeanImpl.setShrinkPeriodMinutes(this.bean.getShrinkPeriodMinutes());
                }
                if (bl && (list == null || !list.contains("SqlStmtMaxParamLength")) && this.bean.isSqlStmtMaxParamLengthSet()) {
                    jDBCConnectionPoolMBeanImpl.setSqlStmtMaxParamLength(this.bean.getSqlStmtMaxParamLength());
                }
                if (bl && (list == null || !list.contains("StatementCacheSize")) && this.bean.isStatementCacheSizeSet()) {
                    jDBCConnectionPoolMBeanImpl.setStatementCacheSize(this.bean.getStatementCacheSize());
                }
                if (bl && (list == null || !list.contains("StatementCacheType")) && this.bean.isStatementCacheTypeSet()) {
                    jDBCConnectionPoolMBeanImpl.setStatementCacheType(this.bean.getStatementCacheType());
                }
                if (bl && (list == null || !list.contains("StatementTimeout")) && this.bean.isStatementTimeoutSet()) {
                    jDBCConnectionPoolMBeanImpl.setStatementTimeout(this.bean.getStatementTimeout());
                }
                if (bl && (list == null || !list.contains("SupportsLocalTransaction")) && this.bean.isSupportsLocalTransactionSet()) {
                    jDBCConnectionPoolMBeanImpl.setSupportsLocalTransaction(this.bean.getSupportsLocalTransaction());
                }
                if ((list == null || !list.contains("Targets")) && this.bean.isTargetsSet()) {
                    jDBCConnectionPoolMBeanImpl._unSet(jDBCConnectionPoolMBeanImpl, 7);
                    jDBCConnectionPoolMBeanImpl.setTargetsAsString(this.bean.getTargetsAsString());
                }
                if (bl && (list == null || !list.contains("TestConnectionsOnCreate")) && this.bean.isTestConnectionsOnCreateSet()) {
                    jDBCConnectionPoolMBeanImpl.setTestConnectionsOnCreate(this.bean.getTestConnectionsOnCreate());
                }
                if (bl && (list == null || !list.contains("TestConnectionsOnRelease")) && this.bean.isTestConnectionsOnReleaseSet()) {
                    jDBCConnectionPoolMBeanImpl.setTestConnectionsOnRelease(this.bean.getTestConnectionsOnRelease());
                }
                if (bl && (list == null || !list.contains("TestConnectionsOnReserve")) && this.bean.isTestConnectionsOnReserveSet()) {
                    jDBCConnectionPoolMBeanImpl.setTestConnectionsOnReserve(this.bean.getTestConnectionsOnReserve());
                }
                if (bl && (list == null || !list.contains("TestFrequencySeconds")) && this.bean.isTestFrequencySecondsSet()) {
                    jDBCConnectionPoolMBeanImpl.setTestFrequencySeconds(this.bean.getTestFrequencySeconds());
                }
                if (bl && (list == null || !list.contains("TestStatementTimeout")) && this.bean.isTestStatementTimeoutSet()) {
                    jDBCConnectionPoolMBeanImpl.setTestStatementTimeout(this.bean.getTestStatementTimeout());
                }
                if (bl && (list == null || !list.contains("TestTableName")) && this.bean.isTestTableNameSet()) {
                    jDBCConnectionPoolMBeanImpl.setTestTableName(this.bean.getTestTableName());
                }
                if (bl && (list == null || !list.contains("URL")) && this.bean.isURLSet()) {
                    jDBCConnectionPoolMBeanImpl.setURL(this.bean.getURL());
                }
                if (bl && (list == null || !list.contains("XAEndOnlyOnce")) && this.bean.isXAEndOnlyOnceSet()) {
                    jDBCConnectionPoolMBeanImpl.setXAEndOnlyOnce(this.bean.getXAEndOnlyOnce());
                }
                if (bl && (list == null || !list.contains("XAPasswordEncrypted")) && this.bean.isXAPasswordEncryptedSet()) {
                    byArray = this.bean.getXAPasswordEncrypted();
                    jDBCConnectionPoolMBeanImpl.setXAPasswordEncrypted(byArray == null ? null : (byte[])byArray.clone());
                }
                if (bl && (list == null || !list.contains("XAPreparedStatementCacheSize")) && this.bean.isXAPreparedStatementCacheSizeSet()) {
                    jDBCConnectionPoolMBeanImpl.setXAPreparedStatementCacheSize(this.bean.getXAPreparedStatementCacheSize());
                }
                if (bl && (list == null || !list.contains("XARetryDurationSeconds")) && this.bean.isXARetryDurationSecondsSet()) {
                    jDBCConnectionPoolMBeanImpl.setXARetryDurationSeconds(this.bean.getXARetryDurationSeconds());
                }
                if (bl && (list == null || !list.contains("XARetryIntervalSeconds")) && this.bean.isXARetryIntervalSecondsSet()) {
                    jDBCConnectionPoolMBeanImpl.setXARetryIntervalSeconds(this.bean.getXARetryIntervalSeconds());
                }
                if (bl && (list == null || !list.contains("XASetTransactionTimeout")) && this.bean.isXASetTransactionTimeoutSet()) {
                    jDBCConnectionPoolMBeanImpl.setXASetTransactionTimeout(this.bean.getXASetTransactionTimeout());
                }
                if (bl && (list == null || !list.contains("XATransactionTimeout")) && this.bean.isXATransactionTimeoutSet()) {
                    jDBCConnectionPoolMBeanImpl.setXATransactionTimeout(this.bean.getXATransactionTimeout());
                }
                if (bl && (list == null || !list.contains("ConnLeakProfilingEnabled")) && this.bean.isConnLeakProfilingEnabledSet()) {
                    jDBCConnectionPoolMBeanImpl.setConnLeakProfilingEnabled(this.bean.isConnLeakProfilingEnabled());
                }
                if (bl && (list == null || !list.contains("ConnProfilingEnabled")) && this.bean.isConnProfilingEnabledSet()) {
                    jDBCConnectionPoolMBeanImpl.setConnProfilingEnabled(this.bean.isConnProfilingEnabled());
                }
                if (bl && (list == null || !list.contains("CredentialMappingEnabled")) && this.bean.isCredentialMappingEnabledSet()) {
                    jDBCConnectionPoolMBeanImpl.setCredentialMappingEnabled(this.bean.isCredentialMappingEnabled());
                }
                if (bl && (list == null || !list.contains("IgnoreInUseConnectionsEnabled")) && this.bean.isIgnoreInUseConnectionsEnabledSet()) {
                    jDBCConnectionPoolMBeanImpl.setIgnoreInUseConnectionsEnabled(this.bean.isIgnoreInUseConnectionsEnabled());
                }
                if (bl && (list == null || !list.contains("PrepStmtCacheProfilingEnabled")) && this.bean.isPrepStmtCacheProfilingEnabledSet()) {
                    jDBCConnectionPoolMBeanImpl.setPrepStmtCacheProfilingEnabled(this.bean.isPrepStmtCacheProfilingEnabled());
                }
                if (bl && (list == null || !list.contains("RemoveInfectedConnectionsEnabled")) && this.bean.isRemoveInfectedConnectionsEnabledSet()) {
                    jDBCConnectionPoolMBeanImpl.setRemoveInfectedConnectionsEnabled(this.bean.isRemoveInfectedConnectionsEnabled());
                }
                if (bl && (list == null || !list.contains("ShrinkingEnabled")) && this.bean.isShrinkingEnabledSet()) {
                    jDBCConnectionPoolMBeanImpl.setShrinkingEnabled(this.bean.isShrinkingEnabled());
                }
                if (bl && (list == null || !list.contains("SqlStmtParamLoggingEnabled")) && this.bean.isSqlStmtParamLoggingEnabledSet()) {
                    jDBCConnectionPoolMBeanImpl.setSqlStmtParamLoggingEnabled(this.bean.isSqlStmtParamLoggingEnabled());
                }
                if (bl && (list == null || !list.contains("SqlStmtProfilingEnabled")) && this.bean.isSqlStmtProfilingEnabledSet()) {
                    jDBCConnectionPoolMBeanImpl.setSqlStmtProfilingEnabled(this.bean.isSqlStmtProfilingEnabled());
                }
                return jDBCConnectionPoolMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getJDBCSystemResource(), clazz, object);
            this.inferSubTree(this.bean.getTargets(), clazz, object);
        }
    }
}

