/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import weblogic.management.configuration.DeploymentMBeanImplBeanInfo;
import weblogic.management.configuration.JDBCConnectionPoolMBean;
import weblogic.management.configuration.JDBCConnectionPoolMBeanImpl;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.internal.mbean.BeanInfoHelper;

public class JDBCConnectionPoolMBeanImplBeanInfo
extends DeploymentMBeanImplBeanInfo {
    public static Class INTERFACE_CLASS = JDBCConnectionPoolMBean.class;

    public JDBCConnectionPoolMBeanImplBeanInfo(boolean bl, String string) throws IntrospectionException {
        super(bl, string);
    }

    public JDBCConnectionPoolMBeanImplBeanInfo() throws IntrospectionException {
    }

    protected BeanDescriptor buildBeanDescriptor() {
        Class clazz = null;
        try {
            clazz = JDBCConnectionPoolMBeanImpl.class;
        }
        catch (Throwable throwable) {
            clazz = INTERFACE_CLASS;
        }
        BeanDescriptor beanDescriptor = new BeanDescriptor(clazz, null);
        beanDescriptor.setValue("obsolete", "9.0.0.0");
        beanDescriptor.setValue("deprecated", "9.0.0.0 Replaced by {@link weblogic.management.configuration.JDBCSystemResourceMBean} ");
        beanDescriptor.setValue("package", "weblogic.management.configuration");
        String string = new String("This bean defines a JDBC connection pool.  <h3 class=\"TypeSafeDeprecation\">Deprecation of MBeanHome and Type-Safe Interfaces</h3>  <p class=\"TypeSafeDeprecation\">This is a type-safe interface for a WebLogic Server MBean, which you can import into your client classes and access through <code>weblogic.management.MBeanHome</code>. As of 9.0, the <code>MBeanHome</code> interface and all type-safe interfaces for WebLogic Server MBeans are deprecated. Instead, client classes that interact with WebLogic Server MBeans should use standard JMX design patterns in which clients use the <code>javax.management.MBeanServerConnection</code> interface to discover MBeans, attributes, and attribute types at runtime.</p> ").intern();
        beanDescriptor.setShortDescription(string);
        beanDescriptor.setValue("description", string);
        String[] stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"Deployer")};
        beanDescriptor.setValue("rolesAllowed", stringArray);
        beanDescriptor.setValue("interfaceclassname", "weblogic.management.configuration.JDBCConnectionPoolMBean");
        beanDescriptor.setValue("generatedByWLSInfoBinder", Boolean.TRUE);
        return beanDescriptor;
    }

    protected void buildPropertyDescriptors(Map map) throws IntrospectionException {
        String[] stringArray;
        String[] stringArray2;
        String string;
        String string2;
        PropertyDescriptor propertyDescriptor = null;
        if (!map.containsKey("ACLName")) {
            string2 = "getACLName";
            string = null;
            if (!this.readOnly) {
                string = "setACLName";
            }
            propertyDescriptor = new PropertyDescriptor("ACLName", JDBCConnectionPoolMBean.class, string2, string);
            map.put("ACLName", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The access control list (ACL) used to control access to this connection pool.</p>  <p>Permissions available to this ACL are:</p>  <ul> <li><code>Reserve</code>  <p>Allows users to get logical connections from this connection pool.</p> </li>  <li><code>Admin</code>  <p>Allows all other operations on this connection pool, including: reset, shrink, shutdown, disable, and enable.</p> </li> </ul>  <p>Lack of an ACL allows any user open access (provided that the user passes other WLS security controls).</p> ");
            propertyDescriptor.setValue("secureValueNull", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("CapacityIncrement")) {
            string2 = "getCapacityIncrement";
            string = null;
            if (!this.readOnly) {
                string = "setCapacityIncrement";
            }
            propertyDescriptor = new PropertyDescriptor("CapacityIncrement", JDBCConnectionPoolMBean.class, string2, string);
            map.put("CapacityIncrement", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The increment by which this JDBC connection pool's capacity is expanded. In WebLogic Server 10.3.1 and higher releases, the <code>capacityIncrement</code> is no longer configurable and is set to a value of 1.</p>  <p>When there are no more available physical connections to service requests, the connection pool will create this number of additional physical database connections and add them to the connection pool. The connection pool will ensure that it does not exceed the maximum number of physical connections.</p> ");
            stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"#getMaxCapacity")};
            propertyDescriptor.setValue("see", stringArray2);
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(1));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(1));
            propertyDescriptor.setValue("deprecated", "10.3.6.0 ");
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("ConnectionCreationRetryFrequencySeconds")) {
            string2 = "getConnectionCreationRetryFrequencySeconds";
            string = null;
            if (!this.readOnly) {
                string = "setConnectionCreationRetryFrequencySeconds";
            }
            propertyDescriptor = new PropertyDescriptor("ConnectionCreationRetryFrequencySeconds", JDBCConnectionPoolMBean.class, string2, string);
            map.put("ConnectionCreationRetryFrequencySeconds", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of seconds between when the connection pool retries to establish connections to the database. Do not enable connection retries for connection pools included in a High Availability MultiPool.</p>  <p>If you do not set this value, connection pool creation fails if the database is unavailable. If set and if the database is unavailable when the connection pool is created, WebLogic Server will attempt to create connections in the pool again after the number of seconds you specify, and will continue to attempt to create the connections until it succeeds.</p>  <p><b>Note</b>: Do not enable connection creation retries for connection pools included in a High Availability MultiPool. Connection requests to the MultiPool will fail (not fail-over) when a connection pool in the list is dead and the number of connection requests equals the number of connections in the first connection pool, even if connections are available in subsequent connection pools in the MultiPool.</p>  <p>When set to <code>0</code>, connection retry is disabled.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(0));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("ConnectionReserveTimeoutSeconds")) {
            string2 = "getConnectionReserveTimeoutSeconds";
            string = null;
            if (!this.readOnly) {
                string = "setConnectionReserveTimeoutSeconds";
            }
            propertyDescriptor = new PropertyDescriptor("ConnectionReserveTimeoutSeconds", JDBCConnectionPoolMBean.class, string2, string);
            map.put("ConnectionReserveTimeoutSeconds", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of seconds after which a call to reserve a connection from the connection pool will timeout. </p> <p>When set to <tt>0</tt>, a call will never timeout.</p> <p>When set to <tt>-1</tt>, a call will timeout immediately.</p> ");
            stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"#getHighestNumWaiters")};
            propertyDescriptor.setValue("see", stringArray2);
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(10));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(-1));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("CountOfRefreshFailuresTillDisable")) {
            string2 = "getCountOfRefreshFailuresTillDisable";
            string = null;
            if (!this.readOnly) {
                string = "setCountOfRefreshFailuresTillDisable";
            }
            propertyDescriptor = new PropertyDescriptor("CountOfRefreshFailuresTillDisable", JDBCConnectionPoolMBean.class, string2, string);
            map.put("CountOfRefreshFailuresTillDisable", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of consecutive pool con refresh failures till we disable the pool.</p>  <p>If a pool loses DBMS connectivity, all the connections are dead and we won't be able to replace them till the DBMS is back. Applications that continue to ask the pool for connections will suffer slowness while the pool tries in vain to test dead connections and tries in vain to make a new one. Sometiimes this can take minutes. This setting tells the pool to disable itself so the applications will at least get a quick failure response, and if a multipool is involved, it can fail over to the next pool quickly. The self-disabled pool will periodically try to reconnect, and will re-enable itself asap.  <p>Setting the count to zero means we will not disable.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(2));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("CountOfTestFailuresTillFlush")) {
            string2 = "getCountOfTestFailuresTillFlush";
            string = null;
            if (!this.readOnly) {
                string = "setCountOfTestFailuresTillFlush";
            }
            propertyDescriptor = new PropertyDescriptor("CountOfTestFailuresTillFlush", JDBCConnectionPoolMBean.class, string2, string);
            map.put("CountOfTestFailuresTillFlush", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of consecutive pool con test failures till we flush the pool.</p>  <p>If a pool temporarily loses DBMS connectivity, all the connections are probably dead. It is much faster to close them all, rather than have the pool test each one during a reserve, and then replace it. This setting tells the pool to flush all the connections in the pool after N consecutive times finding that a connection being tested is dead.</p>  <p>Setting the count to zero means we will not flush.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(2));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("DriverName")) {
            string2 = "getDriverName";
            string = null;
            if (!this.readOnly) {
                string = "setDriverName";
            }
            propertyDescriptor = new PropertyDescriptor("DriverName", JDBCConnectionPoolMBean.class, string2, string);
            map.put("DriverName", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The full package name of JDBC driver class used to create the physical database connections in the connection pool. (Note that this driver class must be in the classpath of any server to which it is deployed.)</p>  <p>For example: <code>oracle.jdbc.OracleDriver</code></p>  <p>It must be the name of a class that implements the <code>java.sql.Driver</code> interface. Check the documentation for the JDBC driver to find the full pathname.</p> ");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("EnableResourceHealthMonitoring")) {
            string2 = "getEnableResourceHealthMonitoring";
            string = null;
            if (!this.readOnly) {
                string = "setEnableResourceHealthMonitoring";
            }
            propertyDescriptor = new PropertyDescriptor("EnableResourceHealthMonitoring", JDBCConnectionPoolMBean.class, string2, string);
            map.put("EnableResourceHealthMonitoring", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns whether JTA resource health monitoring is enabled for this XA connection pool. <p> This property applies to XA connection pools only, and is ignored for connection pools that use a non-XA driver. ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("HighestNumUnavailable")) {
            string2 = "getHighestNumUnavailable";
            string = null;
            if (!this.readOnly) {
                string = "setHighestNumUnavailable";
            }
            propertyDescriptor = new PropertyDescriptor("HighestNumUnavailable", JDBCConnectionPoolMBean.class, string2, string);
            map.put("HighestNumUnavailable", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum number of connections in the connection pool that can be made unavailable for use by an application. Connections become unavailable while being tested or refreshed.</p>  <p>Note that in cases likes the back end system being unavailable, this specified value could be exceeded due to factors outside the pool's control.</p>  <p>When set to <code>0</code>, this feature is disabled.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(0));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("HighestNumWaiters")) {
            string2 = "getHighestNumWaiters";
            string = null;
            if (!this.readOnly) {
                string = "setHighestNumWaiters";
            }
            propertyDescriptor = new PropertyDescriptor("HighestNumWaiters", JDBCConnectionPoolMBean.class, string2, string);
            map.put("HighestNumWaiters", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum number of connection requests that can concurrently block threads while waiting to reserve a connection from the connection pool.</p> ");
            stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"#getConnectionReserveTimeoutSeconds")};
            propertyDescriptor.setValue("see", stringArray2);
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("InactiveConnectionTimeoutSeconds")) {
            string2 = "getInactiveConnectionTimeoutSeconds";
            string = null;
            if (!this.readOnly) {
                string = "setInactiveConnectionTimeoutSeconds";
            }
            propertyDescriptor = new PropertyDescriptor("InactiveConnectionTimeoutSeconds", JDBCConnectionPoolMBean.class, string2, string);
            map.put("InactiveConnectionTimeoutSeconds", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of inactive seconds on a reserved connection before WebLogic Server reclaims the connection and releases it back into the connection pool.</p>  <p>When set to <code>0</code>, the feature is disabled.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(0));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("InitSQL")) {
            string2 = "getInitSQL";
            string = null;
            if (!this.readOnly) {
                string = "setInitSQL";
            }
            propertyDescriptor = new PropertyDescriptor("InitSQL", JDBCConnectionPoolMBean.class, string2, string);
            map.put("InitSQL", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>SQL statement to execute that will initialize a newly created physical connection. Start the statement with SQL followed by a space.</p>  <p>If the statement begins with <code>\"SQL \"</code>, then the rest of the string following that leading token will be taken as a literal SQL statement that will be used to initialize a connection. Else, the statement will be treated as the name of a table and the following SQL statement will be used to initialize a connection: <code><br clear=\"none\" /> \"select count(*) from InitSQL\"</code></p>  <p>The table <code>InitSQL</code> must exist and be accessible to the database user for the connection. Most database servers optimize this SQL to avoid a table scan, but it is still a good idea to set <code>InitSQL</code> to the name of a table that is known to have few rows, or even no rows.</p> ");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("InitialCapacity")) {
            string2 = "getInitialCapacity";
            string = null;
            if (!this.readOnly) {
                string = "setInitialCapacity";
            }
            propertyDescriptor = new PropertyDescriptor("InitialCapacity", JDBCConnectionPoolMBean.class, string2, string);
            map.put("InitialCapacity", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of physical database connections to create when creating this JDBC connection pool. If unable to create this number of connections, creation of this connection pool will fail.</p>  <p>This is also the minimum number of physical connections the connection pool will keep available.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(1));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("JDBCXADebugLevel")) {
            string2 = "getJDBCXADebugLevel";
            string = null;
            if (!this.readOnly) {
                string = "setJDBCXADebugLevel";
            }
            propertyDescriptor = new PropertyDescriptor("JDBCXADebugLevel", JDBCConnectionPoolMBean.class, string2, string);
            map.put("JDBCXADebugLevel", propertyDescriptor);
            propertyDescriptor.setValue("description", " ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(10));
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("KeepLogicalConnOpenOnRelease")) {
            string2 = "getKeepLogicalConnOpenOnRelease";
            string = null;
            if (!this.readOnly) {
                string = "setKeepLogicalConnOpenOnRelease";
            }
            propertyDescriptor = new PropertyDescriptor("KeepLogicalConnOpenOnRelease", JDBCConnectionPoolMBean.class, string2, string);
            map.put("KeepLogicalConnOpenOnRelease", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether the logical JDBC connection is kept open when the physical XA connection is returned to the XA connection pool. Only applies to connection pools that use an XA driver.</p>  <p>Select this option if the XA driver used to create database connections or the DBMS requires that a logical JDBC connection be kept open while transaction processing continues (although the physical XA connection can returned to the XA connection pool).</p>  <p>Use this setting to work around specific problems with third party vendor's XA driver.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("KeepXAConnTillTxComplete")) {
            string2 = "getKeepXAConnTillTxComplete";
            string = null;
            if (!this.readOnly) {
                string = "setKeepXAConnTillTxComplete";
            }
            propertyDescriptor = new PropertyDescriptor("KeepXAConnTillTxComplete", JDBCConnectionPoolMBean.class, string2, string);
            map.put("KeepXAConnTillTxComplete", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether the XA connection pool associates the same XA connection with the distributed transaction until the transaction completes. Only applies to connection pools that use an XA driver.</p>  <p>Use this setting to work around specific problems with third party vendor's XA driver.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("LoginDelaySeconds")) {
            string2 = "getLoginDelaySeconds";
            string = null;
            if (!this.readOnly) {
                string = "setLoginDelaySeconds";
            }
            propertyDescriptor = new PropertyDescriptor("LoginDelaySeconds", JDBCConnectionPoolMBean.class, string2, string);
            map.put("LoginDelaySeconds", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of seconds to delay before creating each physical database connection.</p>  <p>This delay supports database servers that cannot handle multiple requests for connections in rapid succession</p>  <p>The delay takes place both during initial pool creation and during the lifetime of the pool whenever a physical database connection is created.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(0));
            propertyDescriptor.setValue("secureValue", new Integer(0));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("MaxCapacity")) {
            string2 = "getMaxCapacity";
            string = null;
            if (!this.readOnly) {
                string = "setMaxCapacity";
            }
            propertyDescriptor = new PropertyDescriptor("MaxCapacity", JDBCConnectionPoolMBean.class, string2, string);
            map.put("MaxCapacity", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum number of physical database connections that this JDBC connection pool can contain.</p>  <p>Different JDBC Drivers and database servers may limit the number of possible physical connections.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(15));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(1));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("Name")) {
            string2 = "getName";
            string = null;
            if (!this.readOnly) {
                string = "setName";
            }
            propertyDescriptor = new PropertyDescriptor("Name", JDBCConnectionPoolMBean.class, string2, string);
            map.put("Name", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The user-specified name of this MBean instance.</p>  <p>This name is included as one of the key properties in the MBean's <code>javax.management.ObjectName</code>:<br clear=\"none\" /> <code>Name=<i>user-specified-name</i></code></p> ");
            propertyDescriptor.setValue("legalNull", Boolean.TRUE);
            propertyDescriptor.setValue("key", Boolean.TRUE);
        }
        if (!map.containsKey("NeedTxCtxOnClose")) {
            string2 = "getNeedTxCtxOnClose";
            string = null;
            if (!this.readOnly) {
                string = "setNeedTxCtxOnClose";
            }
            propertyDescriptor = new PropertyDescriptor("NeedTxCtxOnClose", JDBCConnectionPoolMBean.class, string2, string);
            map.put("NeedTxCtxOnClose", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether the XA driver requires a distributed transaction context when closing various JDBC objects (result sets, statements, connections, and so on). Only applies to connection pools that use an XA driver.</p>  <p>When enabled, SQL exceptions that are thrown while closing the JDBC objects in no transaction context will be swallowed.</p>  <p>Use this setting to work around specific problems with third party vendor's XA driver.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("NewXAConnForCommit")) {
            string2 = "getNewXAConnForCommit";
            string = null;
            if (!this.readOnly) {
                string = "setNewXAConnForCommit";
            }
            propertyDescriptor = new PropertyDescriptor("NewXAConnForCommit", JDBCConnectionPoolMBean.class, string2, string);
            map.put("NewXAConnForCommit", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether a dedicated XA connection is used for commit/rollback processing of a particular distributed transaction. Only applies to connection pools that use an XA driver.</p>  <p>Use this setting to work around specific problems with third party vendor's XA driver.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("Password")) {
            string2 = "getPassword";
            string = null;
            if (!this.readOnly) {
                string = "setPassword";
            }
            propertyDescriptor = new PropertyDescriptor("Password", JDBCConnectionPoolMBean.class, string2, string);
            map.put("Password", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The database password.</p> <p>The value of this attribute can be set indirectly by passing it as a key=value pair by passing it to the MBean server's <code>setAttribute</code> method for the <code>Properties</code> attribute. However, Oracle recommends that you set the value directly by passing it to the MBean server's <code>setAttribute</code> method for this (<code>PasswordEncrypted</code>) attribute. <p>When you set the value of this attribute, WebLogic Server does the following:</p> <ol><li>Encrypts the value.</li> <li>Sets the value of the <code>PasswordEncrypted</code> attribute to the encrypted value.</li> </ol> <p>Using this <code>Password</code> attribute is a potential security risk because the String object (which contains the unencrypted password) remains in the JVM's memory until garbage collection removes it and the memory is reallocated. Depending on how memory is allocated in the JVM, a significant amount of time could pass before this unencrypted data is removed from memory.</p>  <p>Instead of using this attribute, use <code>PasswordEncrypted</code>.</p> ");
            stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"#getProperties"), BeanInfoHelper.encodeEntities((String)"#getPasswordEncrypted")};
            propertyDescriptor.setValue("see", stringArray2);
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"Deployer")};
            propertyDescriptor.setValue("rolesAllowedGet", stringArray);
        }
        if (!map.containsKey("PasswordEncrypted")) {
            string2 = "getPasswordEncrypted";
            string = null;
            if (!this.readOnly) {
                string = "setPasswordEncrypted";
            }
            propertyDescriptor = new PropertyDescriptor("PasswordEncrypted", JDBCConnectionPoolMBean.class, string2, string);
            map.put("PasswordEncrypted", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The encrypted database password.</p> <p>The value of this attribute can be set indirectly by passing it as a key=value pair by passing it to the MBean server's <code>setAttribute</code> method for the <code>Properties</code> attribute. However, Oracle recommends that you set the value directly by using <code>weblogic.management.EncryptionHelper.encrypt()</code> to encrypt the value. Then set this attribute to the output of the encrypt() method. Doing so overrides the corresponding key=value pair in <code>Properties</code> if you set one.</p>  <p>To compare a password that a user enters with the encrypted value of this attribute, go to the same WebLogic Server instance that you used to set and encrypt this attribute and use <code>weblogic.management.EncryptionHelper.encrypt()</code> to encrypt the user-supplied password. Then compare the encrypted values.</p> ");
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
            stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"Deployer")};
            propertyDescriptor.setValue("rolesAllowedGet", stringArray2);
        }
        if (!map.containsKey("PrepStmtCacheProfilingThreshold")) {
            string2 = "getPrepStmtCacheProfilingThreshold";
            string = null;
            if (!this.readOnly) {
                string = "setPrepStmtCacheProfilingThreshold";
            }
            propertyDescriptor = new PropertyDescriptor("PrepStmtCacheProfilingThreshold", JDBCConnectionPoolMBean.class, string2, string);
            map.put("PrepStmtCacheProfilingThreshold", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of statement requests after which a connection pool logs the state of the prepared statement cache.</p>  <p>It is done to minimize output volume. This is a resource-consuming feature, so it's recommended that it's turned off on a production server.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(10));
            propertyDescriptor.setValue("legalMin", new Integer(10));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("PreparedStatementCacheSize")) {
            string2 = "getPreparedStatementCacheSize";
            string = null;
            if (!this.readOnly) {
                string = "setPreparedStatementCacheSize";
            }
            propertyDescriptor = new PropertyDescriptor("PreparedStatementCacheSize", JDBCConnectionPoolMBean.class, string2, string);
            map.put("PreparedStatementCacheSize", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of prepared statements stored in the cache. (This might increase server performance.)</p>  <p>WebLogic Server can reuse prepared statements in the cache without reloading them, which can increase server performance. Setting the size of the prepared statement cache to 0 turns it off.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(-1));
            propertyDescriptor.setValue("legalMax", new Integer(1024));
            propertyDescriptor.setValue("legalMin", new Integer(-1));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("Properties")) {
            string2 = "getProperties";
            string = null;
            if (!this.readOnly) {
                string = "setProperties";
            }
            propertyDescriptor = new PropertyDescriptor("Properties", JDBCConnectionPoolMBean.class, string2, string);
            map.put("Properties", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The list of properties passed to the JDBC driver that are used to create physical database connections. List each property=value pair on a separate line.</p>  <p>For example: <tt>server=dbserver1</tt>.</p>  <p>The list consists of attribute=value tags, separated by semi-colons. For example <code>user=scott;server=myDB</code>.</p>  <p><strong>Note:</strong> Oracle recommends that you do not store passwords in this properties list. Instead, store them in <code>PasswordEncrypted</code> so that the value is encrypted in <code>config.xml</code> and in the Administration Console display.</p> ");
            stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"#getPasswordEncrypted")};
            propertyDescriptor.setValue("see", stringArray2);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("RecoverOnlyOnce")) {
            string2 = "getRecoverOnlyOnce";
            string = null;
            if (!this.readOnly) {
                string = "setRecoverOnlyOnce";
            }
            propertyDescriptor = new PropertyDescriptor("RecoverOnlyOnce", JDBCConnectionPoolMBean.class, string2, string);
            map.put("RecoverOnlyOnce", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether JTA TM should call recover on the resource only once. Only applies to connection pools that use an XA driver.</p>  <p>Use this setting to work around specific problems with third party vendor's XA driver.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("RefreshMinutes")) {
            string2 = "getRefreshMinutes";
            string = null;
            if (!this.readOnly) {
                string = "setRefreshMinutes";
            }
            propertyDescriptor = new PropertyDescriptor("RefreshMinutes", JDBCConnectionPoolMBean.class, string2, string);
            map.put("RefreshMinutes", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of minutes between database connection tests. (Requires that you specify a Test Table Name.)</p>  <p>At the specified interval, unused database connections are tested. Connections that do not pass the test will be closed and reopened to re-establish a valid physical database connection.</p> ");
            stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"#getTestTableName")};
            propertyDescriptor.setValue("see", stringArray2);
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(0));
            propertyDescriptor.setValue("legalMax", new Integer(0x2222222));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("RollbackLocalTxUponConnClose")) {
            string2 = "getRollbackLocalTxUponConnClose";
            string = null;
            if (!this.readOnly) {
                string = "setRollbackLocalTxUponConnClose";
            }
            propertyDescriptor = new PropertyDescriptor("RollbackLocalTxUponConnClose", JDBCConnectionPoolMBean.class, string2, string);
            map.put("RollbackLocalTxUponConnClose", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether the WLS connection pool will call <code>rollback()</code> on the connection before putting it back in the pool.</p>  <p>Enabling this attribute will have a performance impact as the rollback call requires communication with the database server.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("SecondsToTrustAnIdlePoolConnection")) {
            string2 = "getSecondsToTrustAnIdlePoolConnection";
            string = null;
            if (!this.readOnly) {
                string = "setSecondsToTrustAnIdlePoolConnection";
            }
            propertyDescriptor = new PropertyDescriptor("SecondsToTrustAnIdlePoolConnection", JDBCConnectionPoolMBean.class, string2, string);
            map.put("SecondsToTrustAnIdlePoolConnection", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of seconds within the use of a pooled connection that WebLogic Server trusts that the connection is still viable and will skip connection testing. </p>  <p>If an application requests a connection within the time specified since the connection was tested or successfully used and returned to the connection pool, WebLogic Server skips the connection test before delivering it to an application (if TestConnectionsOnReserve is enabled). </p>  <p>WebLogic Server also skips the automatic refresh connection test if the connection was successfully used and returned to the connection pool within the time specified (if TestFrequencySeconds is specified).</p>  <p>SecondsToTrustAnIdlePoolConnection is a tuning feature that can improve application performance by minimizing the delay caused by database connection testing, especially during heavy traffic. However, it can reduce the effectiveness of connection testing, especially if the value is set too high. The appropriate value depends on your environment and the likelihood that a connection will become defunct.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(10));
            propertyDescriptor.setValue("secureValue", new Integer(0));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("ShrinkFrequencySeconds")) {
            string2 = "getShrinkFrequencySeconds";
            string = null;
            if (!this.readOnly) {
                string = "setShrinkFrequencySeconds";
            }
            propertyDescriptor = new PropertyDescriptor("ShrinkFrequencySeconds", JDBCConnectionPoolMBean.class, string2, string);
            map.put("ShrinkFrequencySeconds", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of seconds before WebLogic Server shrinks the connection pool to the original number of connections or number of connections currently in use. (Requires that you enable connection pool shrinking.)</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(900));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("ShrinkPeriodMinutes")) {
            string2 = "getShrinkPeriodMinutes";
            string = null;
            if (!this.readOnly) {
                string = "setShrinkPeriodMinutes";
            }
            propertyDescriptor = new PropertyDescriptor("ShrinkPeriodMinutes", JDBCConnectionPoolMBean.class, string2, string);
            map.put("ShrinkPeriodMinutes", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of minutes to wait before shrinking a connection pool that has incrementally increased to meet demand. (Requires that you enable connection pool shrinking.)</p> ");
            stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"#isShrinkingEnabled")};
            propertyDescriptor.setValue("see", stringArray2);
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(15));
            propertyDescriptor.setValue("secureValue", new Integer(15));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(1));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("SqlStmtMaxParamLength")) {
            string2 = "getSqlStmtMaxParamLength";
            string = null;
            if (!this.readOnly) {
                string = "setSqlStmtMaxParamLength";
            }
            propertyDescriptor = new PropertyDescriptor("SqlStmtMaxParamLength", JDBCConnectionPoolMBean.class, string2, string);
            map.put("SqlStmtMaxParamLength", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum length of the string passed as a parameter for JDBC SQL round trip profiling. (Requires that you enable the logging of prepared statement parameters.)</p>  <p>As it is a resource-consuming feature, limiting length of data for a parameter allows to reduce output volume.</p> ");
            stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"#isSqlStmtParamLoggingEnabled")};
            propertyDescriptor.setValue("see", stringArray2);
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(10));
            propertyDescriptor.setValue("legalMin", new Integer(1));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("StatementCacheSize")) {
            string2 = "getStatementCacheSize";
            string = null;
            if (!this.readOnly) {
                string = "setStatementCacheSize";
            }
            propertyDescriptor = new PropertyDescriptor("StatementCacheSize", JDBCConnectionPoolMBean.class, string2, string);
            map.put("StatementCacheSize", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of prepared and callable statements stored in the cache. (This might increase server performance.)</p>  <p>WebLogic Server can reuse statements in the cache without reloading them, which can increase server performance. Each connection in the pool has its own cache of statements.</p>  <p>Setting the size of the statement cache to 0 turns it off.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(10));
            propertyDescriptor.setValue("legalMax", new Integer(1024));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("StatementCacheType")) {
            string2 = "getStatementCacheType";
            string = null;
            if (!this.readOnly) {
                string = "setStatementCacheType";
            }
            propertyDescriptor = new PropertyDescriptor("StatementCacheType", JDBCConnectionPoolMBean.class, string2, string);
            map.put("StatementCacheType", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The algorithm used for maintaining the prepared statements stored in the cache.</p>  <p>Connection pools support the following cache types:</p>  <ul> <li><tt>LRU</tt> <p>replaces the least recently used statements when new statements are used.</p> </li>  <li><tt>FIXED</tt> <p>keeps the first fixed number of statements in the cache.</p> </li> </ul> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)"LRU");
            propertyDescriptor.setValue("legalValues", new Object[]{"LRU", "FIXED"});
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("StatementTimeout")) {
            string2 = "getStatementTimeout";
            string = null;
            if (!this.readOnly) {
                string = "setStatementTimeout";
            }
            propertyDescriptor = new PropertyDescriptor("StatementTimeout", JDBCConnectionPoolMBean.class, string2, string);
            map.put("StatementTimeout", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The time after which a statement currently being executed will be timed-out.</p>  <p>Efficacy of this feature relies on underlying JDBC driver support. WebLogic Server passes the time specified to the JDBC driver using the <code>java.sql.Statement.setQueryTimeout()</code> method. If your JDBC driver does not support this method, it may throw an exception and the timeout value is ignored.</p>  <p>A value of <code>-1</code> disables this feature.</p> <p>A value of <code>0</code> means that statements will not time out.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(-1));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(-1));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("SupportsLocalTransaction")) {
            string2 = "getSupportsLocalTransaction";
            string = null;
            if (!this.readOnly) {
                string = "setSupportsLocalTransaction";
            }
            propertyDescriptor = new PropertyDescriptor("SupportsLocalTransaction", JDBCConnectionPoolMBean.class, string2, string);
            map.put("SupportsLocalTransaction", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether the XA driver used to create physical database connections supports SQL without global transactions. Only applies to connection pools that use an XA driver.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("Targets")) {
            string2 = "getTargets";
            string = null;
            if (!this.readOnly) {
                string = "setTargets";
            }
            propertyDescriptor = new PropertyDescriptor("Targets", JDBCConnectionPoolMBean.class, string2, string);
            map.put("Targets", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>You must select a target on which an MBean will be deployed from this list of the targets in the current domain on which this item can be deployed. Targets must be either servers or clusters. The deployment will only occur once if deployments overlap.</p> ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("adder", "addTarget");
            propertyDescriptor.setValue("remover", "removeTarget");
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("TestConnectionsOnCreate")) {
            string2 = "getTestConnectionsOnCreate";
            string = null;
            if (!this.readOnly) {
                string = "setTestConnectionsOnCreate";
            }
            propertyDescriptor = new PropertyDescriptor("TestConnectionsOnCreate", JDBCConnectionPoolMBean.class, string2, string);
            map.put("TestConnectionsOnCreate", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether WebLogic Server tests a connection after creating it but before adding it to the list of connections available in the pool. (Requires that you specify a Test Table Name.)</p>  <p>The test adds a small delay in creating the connection, but ensures that the client receives a working connection (assuming that the DBMS is available and accessible).</p> ");
            stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"#getTestTableName")};
            propertyDescriptor.setValue("see", stringArray2);
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("TestConnectionsOnRelease")) {
            string2 = "getTestConnectionsOnRelease";
            string = null;
            if (!this.readOnly) {
                string = "setTestConnectionsOnRelease";
            }
            propertyDescriptor = new PropertyDescriptor("TestConnectionsOnRelease", JDBCConnectionPoolMBean.class, string2, string);
            map.put("TestConnectionsOnRelease", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether WebLogic Server tests a connection before returning it to this JDBC connection pool. (Requires that you specify a Test Table Name.)</p>  <p>If all connections in the pool are already in use and a client is waiting for a connection, the client's wait will be slightly longer while the connection is tested.</p> ");
            stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"#getTestTableName")};
            propertyDescriptor.setValue("see", stringArray2);
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("secureValue", new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("TestConnectionsOnReserve")) {
            string2 = "getTestConnectionsOnReserve";
            string = null;
            if (!this.readOnly) {
                string = "setTestConnectionsOnReserve";
            }
            propertyDescriptor = new PropertyDescriptor("TestConnectionsOnReserve", JDBCConnectionPoolMBean.class, string2, string);
            map.put("TestConnectionsOnReserve", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether WebLogic Server tests a connection before giving it to the client. This test is required for connection pools used within a MultiPool that use the High Availability algorithm. (Requires that you specify a Test Table Name.)</p>  <p>The test adds a small delay in serving the client's request for a connection from the pool, but ensures that the client receives a working connection (assuming that the DBMS is available and accessible).</p> ");
            stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"#getTestTableName")};
            propertyDescriptor.setValue("see", stringArray2);
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("secureValue", new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("TestFrequencySeconds")) {
            string2 = "getTestFrequencySeconds";
            string = null;
            if (!this.readOnly) {
                string = "setTestFrequencySeconds";
            }
            propertyDescriptor = new PropertyDescriptor("TestFrequencySeconds", JDBCConnectionPoolMBean.class, string2, string);
            map.put("TestFrequencySeconds", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of seconds between when WebLogic Server tests unused database connections. (Requires that you specify a Test Table Name.)</p>  <p>Connections that fail the test are closed and reopened to re-establish a valid physical database connection. If the test fails again, the connection is closed.</p>  <p>When set to <code>0</code>, periodic testing is disabled.</p> ");
            stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"#getTestTableName"), BeanInfoHelper.encodeEntities((String)"weblogic.management.configuration.JDBCConnectionPoolMBean#setHighestNumUnavailable(int)")};
            propertyDescriptor.setValue("see", stringArray2);
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(120));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(0));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("TestStatementTimeout")) {
            string2 = "getTestStatementTimeout";
            string = null;
            if (!this.readOnly) {
                string = "setTestStatementTimeout";
            }
            propertyDescriptor = new PropertyDescriptor("TestStatementTimeout", JDBCConnectionPoolMBean.class, string2, string);
            map.put("TestStatementTimeout", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The time after which the test statement (configured by applications using the pool attribute Test Table Name) or initialization statement (configured by applications using the pool attribute InitSQL) currently being executed will be timed out.</p>  <p>Efficacy of this feature relies on underlying JDBC driver support. WebLogic Server passes the time specified to the JDBC driver using the <code>java.sql.Statement.setQueryTimeout()</code> method. If your JDBC driver does not support this method, it may throw an exception and the timeout value is ignored.</p>  <p>A value of <code>-1</code> disables this feature.</p> <p>A value of <code>0</code> means that statements will not time out.</p> ");
            stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"#getTestTableName"), BeanInfoHelper.encodeEntities((String)"#getInitSQL")};
            propertyDescriptor.setValue("see", stringArray2);
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(-1));
            propertyDescriptor.setValue("legalMax", new Integer(Integer.MAX_VALUE));
            propertyDescriptor.setValue("legalMin", new Integer(-1));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("TestTableName")) {
            string2 = "getTestTableName";
            string = null;
            if (!this.readOnly) {
                string = "setTestTableName";
            }
            propertyDescriptor = new PropertyDescriptor("TestTableName", JDBCConnectionPoolMBean.class, string2, string);
            map.put("TestTableName", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The name of the database table to use when testing physical database connections. This name is required when you specify a Test Frequency and enable Test Reserved Connections, Test Created Connections, and Test Released Connections.</p>  <p>The default SQL code used to test a connection is<br clear=\"none\" /> </p>  <code>\"select count(*) from TestTableName\"</code> <p>Most database servers optimize this SQL to avoid a table scan, but it is still a good idea to set the Test Table Name to the name of a table that is known to have few rows, or even no rows.</p>  <p>If the name begins with <code>\"SQL \"</code>, then the rest of the string following that leading token will be taken as a literal SQL statement that will be used to test a connection.</p> ");
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("URL")) {
            string2 = "getURL";
            string = null;
            if (!this.readOnly) {
                string = "setURL";
            }
            propertyDescriptor = new PropertyDescriptor("URL", JDBCConnectionPoolMBean.class, string2, string);
            map.put("URL", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The URL of the database to connect to. The format of the URL varies by JDBC driver.</p>  <p>The URL is passed to the JDBC driver to create the physical database connections.</p> ");
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("XAEndOnlyOnce")) {
            string2 = "getXAEndOnlyOnce";
            string = null;
            if (!this.readOnly) {
                string = "setXAEndOnlyOnce";
            }
            propertyDescriptor = new PropertyDescriptor("XAEndOnlyOnce", JDBCConnectionPoolMBean.class, string2, string);
            map.put("XAEndOnlyOnce", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies that <tt>XAResource.end()</tt> is called only once for each pending <tt>XAResource.start()</tt>. The XA driver will not call <tt>XAResource.end(TMSUSPEND)</tt>, <tt>XAResource.end(TMSUCCESS)</tt> successively. Only applies to connection pools that use an XA driver.</p>  <p>Use this setting to work around specific problems with third party vendor's XA driver.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("XAPassword")) {
            string2 = "getXAPassword";
            string = null;
            if (!this.readOnly) {
                string = "setXAPassword";
            }
            propertyDescriptor = new PropertyDescriptor("XAPassword", JDBCConnectionPoolMBean.class, string2, string);
            map.put("XAPassword", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The password that is used to create physical XA database connections.</p>  <p>The value of this attribute can be set indirectly by passing it as a key=value pair by passing it to the MBean server's <code>setAttribute</code> method for the <code>Properties</code> attribute. However, Oracle recommends that you set the value directly by passing it to the MBean server's <code>setAttribute</code> method for this (<code>XAPassword</code>) attribute.  <p>When you set the value of this attribute, WebLogic Server does the following:</p> <ol><li>Encrypts the value.</li> <li>Sets the value of the <code>XAPasswordEncrypted</code> attribute to the encrypted value.</li> </ol> <p>Using this <code>XAPassword</code> attribute is a potential security risk because the String object (which contains the unencrypted password) remains in the JVM's memory until garbage collection removes it and the memory is reallocated. Depending on how memory is allocated in the JVM, a significant amount of time could pass before this unencrypted data is removed from memory.</p>  <p>Instead of using this attribute, use <code>XAPasswordEncrypted</code>.</p> ");
            stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"#getProperties"), BeanInfoHelper.encodeEntities((String)"#getXAPasswordEncrypted")};
            propertyDescriptor.setValue("see", stringArray2);
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"Deployer")};
            propertyDescriptor.setValue("rolesAllowedGet", stringArray);
        }
        if (!map.containsKey("XAPasswordEncrypted")) {
            string2 = "getXAPasswordEncrypted";
            string = null;
            if (!this.readOnly) {
                string = "setXAPasswordEncrypted";
            }
            propertyDescriptor = new PropertyDescriptor("XAPasswordEncrypted", JDBCConnectionPoolMBean.class, string2, string);
            map.put("XAPasswordEncrypted", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The password that is used to create physical XA database connections.</p>  <p>The value of this attribute can be set indirectly by passing it as a key=value pair by passing it to the MBean server's <code>setAttribute</code> method for the <code>Properties</code> attribute. However, Oracle recommends that you set the value directly by using <code>weblogic.management.EncryptionHelper.encrypt()</code> to encrypt the value. Then set this attribute to the output of the encrypt() method. Doing so overrides the corresponding key=value pair in <code>Properties</code> if you set one. It also causes WebLogic Server to encrypt the value and set the attribute to the encrypted value.</p>  <p>To compare a password that a user enters with the encrypted value of this attribute, go to the same WebLogic Server instance that you used to set and encrypt this attribute and use <code>weblogic.management.EncryptionHelper.encrypt()</code> to encrypt the user-supplied password. Then compare the encrypted values.</p> ");
            propertyDescriptor.setValue("encrypted", Boolean.TRUE);
            stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"Deployer")};
            propertyDescriptor.setValue("rolesAllowedGet", stringArray2);
        }
        if (!map.containsKey("XAPreparedStatementCacheSize")) {
            string2 = "getXAPreparedStatementCacheSize";
            string = null;
            if (!this.readOnly) {
                string = "setXAPreparedStatementCacheSize";
            }
            propertyDescriptor = new PropertyDescriptor("XAPreparedStatementCacheSize", JDBCConnectionPoolMBean.class, string2, string);
            map.put("XAPreparedStatementCacheSize", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum number of prepared statements cached by this particular XA connection pool. Only applies to connection pools that use an XA driver.</p>  <p>If set to <code>0</code>, caching is turned off.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(-1));
            propertyDescriptor.setValue("legalMax", new Integer(1024));
            propertyDescriptor.setValue("legalMin", new Integer(-1));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("XARetryDurationSeconds")) {
            string2 = "getXARetryDurationSeconds";
            string = null;
            if (!this.readOnly) {
                string = "setXARetryDurationSeconds";
            }
            propertyDescriptor = new PropertyDescriptor("XARetryDurationSeconds", JDBCConnectionPoolMBean.class, string2, string);
            map.put("XARetryDurationSeconds", propertyDescriptor);
            propertyDescriptor.setValue("description", "Determines the duration in seconds for which the transaction manager will perform recover operations on the resource.  A value of zero indicates that no retries will be performed. ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(0));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("XARetryIntervalSeconds")) {
            string2 = "getXARetryIntervalSeconds";
            string = null;
            if (!this.readOnly) {
                string = "setXARetryIntervalSeconds";
            }
            propertyDescriptor = new PropertyDescriptor("XARetryIntervalSeconds", JDBCConnectionPoolMBean.class, string2, string);
            map.put("XARetryIntervalSeconds", propertyDescriptor);
            propertyDescriptor.setValue("description", "Determines the time in seconds between XA retry operations if the XARetryDurationSeconds attribute is set to a positive value. ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(60));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("XASetTransactionTimeout")) {
            string2 = "getXASetTransactionTimeout";
            string = null;
            if (!this.readOnly) {
                string = "setXASetTransactionTimeout";
            }
            propertyDescriptor = new PropertyDescriptor("XASetTransactionTimeout", JDBCConnectionPoolMBean.class, string2, string);
            map.put("XASetTransactionTimeout", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>When set to true, the WebLogic Server Transaction Manager calls XAResource.setTransactionTimeout() before calling XAResource.start, and passes either the XATransactionTimeout or the global transaction timeout in seconds. </p> <p>When set to false, the Transaction Manager does not call setTransactionTimeout().</p> <p>This property applies to XA connection pools only, and is ignored for connection pools that use a non-XA driver. </p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("XATransactionTimeout")) {
            string2 = "getXATransactionTimeout";
            string = null;
            if (!this.readOnly) {
                string = "setXATransactionTimeout";
            }
            propertyDescriptor = new PropertyDescriptor("XATransactionTimeout", JDBCConnectionPoolMBean.class, string2, string);
            map.put("XATransactionTimeout", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Determines the number of seconds to pass as the transaction timeout value in the XAResource.setTransactionTimeout() method. When this property is set to 0, the WebLogic Server Transaction Manager passes the global WebLogic Server transaction timeout in seconds in the method.</p> <p>If set, this value should be greater than or equal to the global WebLogic Server transaction timeout.</p> <p>XASetTransactionTimeout must be set to \"true\" or this property is ignored. </p> <p>This property applies to XA connection pools only, and is ignored for connection pools that use a non-XA driver.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Integer(0));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("ConnLeakProfilingEnabled")) {
            string2 = "isConnLeakProfilingEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setConnLeakProfilingEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("ConnLeakProfilingEnabled", JDBCConnectionPoolMBean.class, string2, string);
            map.put("ConnLeakProfilingEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies that JDBC connection leak information is gathered. This option is required to view leaked connections from the connection pool.</p>  <p>A Connection leak occurs when a connection from the pool is not closed explicitly by calling <code>close()</code> on that connection.</p>  <p>When connection leak profiling is active, the connection pool will store the stack trace at the time the Connection object is allocated from the connection pool and given to the client. When a connection leak is detected (when the Connection object is garbage collected), this stack trace is reported.</p>  <p>This feature uses extra resources and will likely slow down connection pool operations, so it is not recommended for production use.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("secureValue", new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("ConnProfilingEnabled")) {
            string2 = "isConnProfilingEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setConnProfilingEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("ConnProfilingEnabled", JDBCConnectionPoolMBean.class, string2, string);
            map.put("ConnProfilingEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether the connection pool detects local transaction work left incomplete by application code, which can interfere with subsequent operations related to global (XA) transactions.</p>  <p>When connection profiling is active, the pool will store the stack trace at the time the connection object is released back into the pool by the client. If an exception is thrown during a subsequent operation related to global (XA) transactions, this stack trace is reported.</p>  <p>This feature uses extra resources and will likely slowdown Connection Pool operations, so it is not recommended for production use.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("secureValue", new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("CredentialMappingEnabled")) {
            string2 = "isCredentialMappingEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setCredentialMappingEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("CredentialMappingEnabled", JDBCConnectionPoolMBean.class, string2, string);
            map.put("CredentialMappingEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the configured ignoreInUseConnectionsEnabled value. ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("IgnoreInUseConnectionsEnabled")) {
            string2 = "isIgnoreInUseConnectionsEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setIgnoreInUseConnectionsEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("IgnoreInUseConnectionsEnabled", JDBCConnectionPoolMBean.class, string2, string);
            map.put("IgnoreInUseConnectionsEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "Returns the configured ignoreInUseConnectionsEnabled value. ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("PrepStmtCacheProfilingEnabled")) {
            string2 = "isPrepStmtCacheProfilingEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setPrepStmtCacheProfilingEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("PrepStmtCacheProfilingEnabled", JDBCConnectionPoolMBean.class, string2, string);
            map.put("PrepStmtCacheProfilingEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether the connection pool stores prepared statement cache profiles in external storage for further analysis.</p>  <p>This is a resource-consuming feature, so it's recommended that it's turned off on a production server.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("RemoveInfectedConnectionsEnabled")) {
            string2 = "isRemoveInfectedConnectionsEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setRemoveInfectedConnectionsEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("RemoveInfectedConnectionsEnabled", JDBCConnectionPoolMBean.class, string2, string);
            map.put("RemoveInfectedConnectionsEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether a connection will be removed from the connection pool when the application asks for the underlying vendor connection object.</p>  <p>If you use this setting, you must make sure that the database connection is suitable for reuse by other applications.</p>  <p>When enabled, the physical connection is not returned to the connection pool after the application closes the logical connection. Instead, the physical connection is closed and recreated.</p>  <p>When not enabled, when you close the logical connection, the physical connection is returned to the connection pool.</p> ");
            stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.jdbc.extensions.WLConnection#getVendorConnection")};
            propertyDescriptor.setValue("see", stringArray2);
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
            propertyDescriptor.setValue("dynamic", Boolean.FALSE);
        }
        if (!map.containsKey("ShrinkingEnabled")) {
            string2 = "isShrinkingEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setShrinkingEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("ShrinkingEnabled", JDBCConnectionPoolMBean.class, string2, string);
            map.put("ShrinkingEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether the JDBC connection pool can shrink back to its initial capacity or to the current number of connections in use if it detects that connections created during increased traffic are not being used.</p>  <p>When shrinking, the number of connections is reduced to the greater of either the initial capacity or the current number of connections in use.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(true));
            propertyDescriptor.setValue("secureValue", new Boolean(true));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        if (!map.containsKey("SqlStmtParamLoggingEnabled")) {
            string2 = "isSqlStmtParamLoggingEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setSqlStmtParamLoggingEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("SqlStmtParamLoggingEnabled", JDBCConnectionPoolMBean.class, string2, string);
            map.put("SqlStmtParamLoggingEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether the connection pool stores the values of prepared statement parameters. (Requires that you enable SQL statement profiling.)</p>  <p>This is a resource-consuming feature, so it's recommended that it's turned off on a production server.</p> ");
            stringArray2 = new String[]{BeanInfoHelper.encodeEntities((String)"#isSqlStmtProfilingEnabled")};
            propertyDescriptor.setValue("see", stringArray2);
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("SqlStmtProfilingEnabled")) {
            string2 = "isSqlStmtProfilingEnabled";
            string = null;
            if (!this.readOnly) {
                string = "setSqlStmtProfilingEnabled";
            }
            propertyDescriptor = new PropertyDescriptor("SqlStmtProfilingEnabled", JDBCConnectionPoolMBean.class, string2, string);
            map.put("SqlStmtProfilingEnabled", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Specifies whether the connection pool stores SQL statement text, execution time and other metrics.</p>  <p>This is a resource-consuming feature, so it's recommended that it's turned off on a production server.</p> ");
            JDBCConnectionPoolMBeanImplBeanInfo.setPropertyDescriptorDefault((PropertyDescriptor)propertyDescriptor, (Object)new Boolean(false));
            propertyDescriptor.setValue("dynamic", Boolean.TRUE);
        }
        super.buildPropertyDescriptors(map);
    }

    private void fillinFactoryMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinCollectionMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        MethodDescriptor methodDescriptor;
        Method method = JDBCConnectionPoolMBean.class.getMethod("addTarget", TargetMBean.class);
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{JDBCConnectionPoolMBeanImplBeanInfo.createParameterDescriptor((String)"target", (String)"The feature to be added to the Target attribute ")};
        String string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>You can add a target to specify additional servers on which the deployment can be deployed. The targets must be either clusters or servers.</p> ");
            methodDescriptor.setValue("role", "collection");
            methodDescriptor.setValue("property", "Targets");
        }
        method = JDBCConnectionPoolMBean.class.getMethod("removeTarget", TargetMBean.class);
        parameterDescriptorArray = new ParameterDescriptor[]{JDBCConnectionPoolMBeanImplBeanInfo.createParameterDescriptor((String)"target", null)};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Removes the value of the addTarget attribute.</p> ");
            String[] stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#addTarget")};
            methodDescriptor.setValue("see", stringArray);
            methodDescriptor.setValue("role", "collection");
            methodDescriptor.setValue("property", "Targets");
        }
    }

    private void fillinFinderMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinOperationMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        MethodDescriptor methodDescriptor;
        Method method = JDBCConnectionPoolMBean.class.getMethod("freezeCurrentValue", String.class);
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{JDBCConnectionPoolMBeanImplBeanInfo.createParameterDescriptor((String)"attributeName", null)};
        String string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            methodDescriptor.setValue("deprecated", "9.0.0.0 ");
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>If the specified attribute has not been set explicitly, and if the attribute has a default value, this operation forces the MBean to persist the default value.</p>  <p>Unless you use this operation, the default value is not saved and is subject to change if you update to a newer release of WebLogic Server. Invoking this operation isolates this MBean from the effects of such changes.</p>  <dl> <dt>Note:</dt>  <dd> <p>To insure that you are freezing the default value, invoke the <code>restoreDefaultValue</code> operation before you invoke this.</p> </dd> </dl>  <p>This operation has no effect if you invoke it on an attribute that does not provide a default value or on an attribute for which some other value has been set.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = JDBCConnectionPoolMBean.class.getMethod("restoreDefaultValue", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{JDBCConnectionPoolMBeanImplBeanInfo.createParameterDescriptor((String)"attributeName", null)};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string) && !this.readOnly) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            methodDescriptor.setValue("deprecated", "9.0.0.0 ");
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>If the specified attribute has a default value, this operation removes any value that has been set explicitly and causes the attribute to use the default value.</p>  <p>Default values are subject to change if you update to a newer release of WebLogic Server. To prevent the value from changing if you update to a newer release, invoke the <code>freezeCurrentValue</code> operation.</p>  <p>This operation has no effect if you invoke it on an attribute that does not provide a default value or on an attribute that is already using the default.</p> ");
            methodDescriptor.setValue("role", "operation");
            methodDescriptor.setValue("impact", "action");
        }
    }

    protected void buildMethodDescriptors(Map map) throws IntrospectionException, NoSuchMethodException {
        this.fillinFinderMethodInfos(map);
        if (!this.readOnly) {
            this.fillinCollectionMethodInfos(map);
            this.fillinFactoryMethodInfos(map);
        }
        this.fillinOperationMethodInfos(map);
        super.buildMethodDescriptors(map);
    }

    protected void buildEventSetDescriptors(Map map) throws IntrospectionException {
    }
}

