/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanAlreadyExistsException;
import weblogic.descriptor.DescriptorBean;
import weblogic.management.DistributedManagementException;
import weblogic.management.configuration.ConfigurationMBeanBinder;
import weblogic.management.configuration.JDBCDataSourceFactoryMBeanImpl;
import weblogic.management.internal.mbean.SecurityReadOnlyMBeanBinder;
import weblogic.utils.codegen.AttributeBinder;

public class JDBCDataSourceFactoryMBeanBinder
extends ConfigurationMBeanBinder
implements AttributeBinder {
    private JDBCDataSourceFactoryMBeanImpl bean;

    protected JDBCDataSourceFactoryMBeanBinder(DescriptorBean descriptorBean) {
        super(descriptorBean);
        this.bean = (JDBCDataSourceFactoryMBeanImpl)descriptorBean;
    }

    public JDBCDataSourceFactoryMBeanBinder() {
        super(new JDBCDataSourceFactoryMBeanImpl());
        this.bean = (JDBCDataSourceFactoryMBeanImpl)this.getBean();
    }

    public AttributeBinder bindAttribute(String string, Object object) throws IllegalArgumentException {
        try {
            JDBCDataSourceFactoryMBeanBinder jDBCDataSourceFactoryMBeanBinder = this;
            if (!(jDBCDataSourceFactoryMBeanBinder instanceof SecurityReadOnlyMBeanBinder) && object != null && object.toString().trim().length() == 0) {
                return jDBCDataSourceFactoryMBeanBinder;
            }
            if (string != null) {
                if (string.equals("DriverClassName")) {
                    try {
                        this.bean.setDriverClassName((String)object);
                    }
                    catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                        System.out.println("Warning: multiple definitions with same name: " + beanAlreadyExistsException.getMessage());
                    }
                } else if (string.equals("FactoryName")) {
                    try {
                        this.bean.setFactoryName((String)object);
                    }
                    catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                        System.out.println("Warning: multiple definitions with same name: " + beanAlreadyExistsException.getMessage());
                    }
                } else if (string.equals("Name")) {
                    try {
                        this.bean.setName((String)object);
                    }
                    catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                        System.out.println("Warning: multiple definitions with same name: " + beanAlreadyExistsException.getMessage());
                    }
                } else if (string.equals("Password")) {
                    try {
                        if (this.bean.isPasswordEncryptedSet()) {
                            throw new IllegalArgumentException("Encrypted attribute corresponding to Password [ JDBCDataSourceFactoryMBean ] is also present in the config file. For encrypted properties either encrypted or unencrypted attribute can be present in 8.x config.");
                        }
                        this.bean.setPassword((String)object);
                    }
                    catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                        System.out.println("Warning: multiple definitions with same name: " + beanAlreadyExistsException.getMessage());
                    }
                } else if (string.equals("PasswordEncrypted")) {
                    if (this.bean.isPasswordEncryptedSet()) {
                        throw new IllegalArgumentException("Unencrypted attribute corresponding to PasswordEncrypted [ JDBCDataSourceFactoryMBean ] is also present in the config file. For encrypted properties either encrypted or unencrypted attribute can be present in 8.x config.");
                    }
                    this.bean.setPasswordEncryptedAsString((String)object);
                } else if (string.equals("Properties")) {
                    this.bean.setPropertiesAsString((String)object);
                } else if (string.equals("URL")) {
                    try {
                        this.bean.setURL((String)object);
                    }
                    catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                        System.out.println("Warning: multiple definitions with same name: " + beanAlreadyExistsException.getMessage());
                    }
                } else if (string.equals("UserName")) {
                    try {
                        this.bean.setUserName((String)object);
                    }
                    catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                        System.out.println("Warning: multiple definitions with same name: " + beanAlreadyExistsException.getMessage());
                    }
                } else {
                    jDBCDataSourceFactoryMBeanBinder = super.bindAttribute(string, object);
                }
            }
            return jDBCDataSourceFactoryMBeanBinder;
        }
        catch (ClassCastException classCastException) {
            System.out.println(classCastException + " name: " + string + " class: " + object.getClass().getName());
            throw classCastException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            if (exception instanceof DistributedManagementException) {
                throw new AssertionError((Object)("impossible exception: " + exception));
            }
            if (exception instanceof InvalidAttributeValueException) {
                throw new IllegalArgumentException(exception.getMessage());
            }
            throw new AssertionError((Object)("unexpected exception: " + exception));
        }
    }
}

