/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.beangen.StringHelper;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.JDBCDataSourceFactoryMBean;
import weblogic.management.mbeans.custom.JDBCDataSourceFactory;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class JDBCDataSourceFactoryMBeanImpl
extends ConfigurationMBeanImpl
implements JDBCDataSourceFactoryMBean,
Serializable {
    private String _DriverClassName;
    private String _FactoryName;
    private String _Name;
    private String _Password;
    private byte[] _PasswordEncrypted;
    private Map _Properties;
    private String _URL;
    private String _UserName;
    private JDBCDataSourceFactory _customizer;
    private static SchemaHelper2 _schemaHelper;

    public JDBCDataSourceFactoryMBeanImpl() {
        try {
            this._customizer = new JDBCDataSourceFactory(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public JDBCDataSourceFactoryMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new JDBCDataSourceFactory(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public void setUserName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._UserName;
        this._UserName = string;
        this._postSet(7, string2, string);
    }

    public String getUserName() {
        return this._UserName;
    }

    public boolean isUserNameSet() {
        return this._isSet(7);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setPassword(String string) {
        string = string == null ? null : string.trim();
        this.setPasswordEncrypted(string == null ? null : this._encrypt("Password", string));
    }

    public String getPassword() {
        byte[] byArray = this.getPasswordEncrypted();
        return byArray == null ? null : this._decrypt("Password", byArray);
    }

    public boolean isPasswordSet() {
        return this.isPasswordEncryptedSet();
    }

    public byte[] getPasswordEncrypted() {
        return this._getHelper()._cloneArray(this._PasswordEncrypted);
    }

    public String getPasswordEncryptedAsString() {
        byte[] byArray = this.getPasswordEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isPasswordEncryptedSet() {
        return this._isSet(9);
    }

    public void setPasswordEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setPasswordEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public void setURL(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._URL;
        this._URL = string;
        this._postSet(10, string2, string);
    }

    public String getURL() {
        return this._URL;
    }

    public boolean isURLSet() {
        return this._isSet(10);
    }

    public void setDriverClassName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._DriverClassName;
        this._DriverClassName = string;
        this._postSet(11, string2, string);
    }

    public String getDriverClassName() {
        return this._DriverClassName;
    }

    public boolean isDriverClassNameSet() {
        return this._isSet(11);
    }

    public Map getProperties() {
        return this._Properties;
    }

    public String getPropertiesAsString() {
        return StringHelper.objectToString((Object)this.getProperties());
    }

    public boolean isPropertiesSet() {
        return this._isSet(12);
    }

    public void setPropertiesAsString(String string) {
        try {
            this.setProperties(StringHelper.stringToMap((String)string));
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void setProperties(Map map) {
        Map map2 = this.getProperties();
        try {
            this._customizer.setProperties(map);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new UndeclaredThrowableException(invalidAttributeValueException);
        }
        this._postSet(12, map2, map);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setFactoryName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._FactoryName;
        this._FactoryName = string;
        this._postSet(13, string2, string);
    }

    public String getFactoryName() {
        return this._FactoryName;
    }

    public boolean isFactoryNameSet() {
        return this._isSet(13);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public void setPasswordEncrypted(byte[] byArray) {
        byte[] byArray2 = this._PasswordEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: PasswordEncrypted of JDBCDataSourceFactoryMBean");
        }
        this._getHelper()._clearArray(this._PasswordEncrypted);
        this._PasswordEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(9, byArray2, byArray);
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
            if (n == 8) {
                this._markSet(9, false);
            }
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 11;
        }
        try {
            switch (n) {
                case 11: {
                    this._DriverClassName = null;
                    if (bl) break;
                }
                case 13: {
                    this._FactoryName = null;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 8: {
                    this._PasswordEncrypted = null;
                    if (bl) break;
                }
                case 9: {
                    this._PasswordEncrypted = null;
                    if (bl) break;
                }
                case 12: {
                    this._customizer.setProperties(null);
                    if (bl) break;
                }
                case 10: {
                    this._URL = null;
                    if (bl) break;
                }
                case 7: {
                    this._UserName = null;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "JDBCDataSourceFactory";
    }

    public void putValue(String string, Object object) {
        if (string.equals("DriverClassName")) {
            String string2 = this._DriverClassName;
            this._DriverClassName = (String)object;
            this._postSet(11, string2, this._DriverClassName);
            return;
        }
        if (string.equals("FactoryName")) {
            String string3 = this._FactoryName;
            this._FactoryName = (String)object;
            this._postSet(13, string3, this._FactoryName);
            return;
        }
        if (string.equals("Name")) {
            String string4 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string4, this._Name);
            return;
        }
        if (string.equals("Password")) {
            String string5 = this._Password;
            this._Password = (String)object;
            this._postSet(8, string5, this._Password);
            return;
        }
        if (string.equals("PasswordEncrypted")) {
            byte[] byArray = this._PasswordEncrypted;
            this._PasswordEncrypted = (byte[])object;
            this._postSet(9, byArray, this._PasswordEncrypted);
            return;
        }
        if (string.equals("Properties")) {
            Map map = this._Properties;
            this._Properties = (Map)object;
            this._postSet(12, map, this._Properties);
            return;
        }
        if (string.equals("URL")) {
            String string6 = this._URL;
            this._URL = (String)object;
            this._postSet(10, string6, this._URL);
            return;
        }
        if (string.equals("UserName")) {
            String string7 = this._UserName;
            this._UserName = (String)object;
            this._postSet(7, string7, this._UserName);
            return;
        }
        if (string.equals("customizer")) {
            JDBCDataSourceFactory jDBCDataSourceFactory = this._customizer;
            this._customizer = (JDBCDataSourceFactory)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("DriverClassName")) {
            return this._DriverClassName;
        }
        if (string.equals("FactoryName")) {
            return this._FactoryName;
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("Password")) {
            return this._Password;
        }
        if (string.equals("PasswordEncrypted")) {
            return this._PasswordEncrypted;
        }
        if (string.equals("Properties")) {
            return this._Properties;
        }
        if (string.equals("URL")) {
            return this._URL;
        }
        if (string.equals("UserName")) {
            return this._UserName;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 17: {
                    if (!string.equals("driver-class-name")) break;
                    return 11;
                }
                case 12: {
                    if (!string.equals("factory-name")) break;
                    return 13;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 8: {
                    if (!string.equals("password")) break;
                    return 8;
                }
                case 18: {
                    if (!string.equals("password-encrypted")) break;
                    return 9;
                }
                case 10: {
                    if (!string.equals("properties")) break;
                    return 12;
                }
                case 3: {
                    if (!string.equals("url")) break;
                    return 10;
                }
                case 9: {
                    if (!string.equals("user-name")) break;
                    return 7;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 11: {
                    return "driver-class-name";
                }
                case 13: {
                    return "factory-name";
                }
                case 2: {
                    return "name";
                }
                case 8: {
                    return "password";
                }
                case 9: {
                    return "password-encrypted";
                }
                case 12: {
                    return "properties";
                }
                case 10: {
                    return "url";
                }
                case 7: {
                    return "user-name";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                default: 
            }
            return super.isArray(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private JDBCDataSourceFactoryMBeanImpl bean;

        protected Helper(JDBCDataSourceFactoryMBeanImpl jDBCDataSourceFactoryMBeanImpl) {
            super(jDBCDataSourceFactoryMBeanImpl);
            this.bean = jDBCDataSourceFactoryMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 11: {
                    return "DriverClassName";
                }
                case 13: {
                    return "FactoryName";
                }
                case 2: {
                    return "Name";
                }
                case 8: {
                    return "Password";
                }
                case 9: {
                    return "PasswordEncrypted";
                }
                case 12: {
                    return "Properties";
                }
                case 10: {
                    return "URL";
                }
                case 7: {
                    return "UserName";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("DriverClassName")) {
                return 11;
            }
            if (string.equals("FactoryName")) {
                return 13;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("Password")) {
                return 8;
            }
            if (string.equals("PasswordEncrypted")) {
                return 9;
            }
            if (string.equals("Properties")) {
                return 12;
            }
            if (string.equals("URL")) {
                return 10;
            }
            if (string.equals("UserName")) {
                return 7;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isDriverClassNameSet()) {
                    stringBuffer.append("DriverClassName");
                    stringBuffer.append(String.valueOf(this.bean.getDriverClassName()));
                }
                if (this.bean.isFactoryNameSet()) {
                    stringBuffer.append("FactoryName");
                    stringBuffer.append(String.valueOf(this.bean.getFactoryName()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isPasswordSet()) {
                    stringBuffer.append("Password");
                    stringBuffer.append(String.valueOf(this.bean.getPassword()));
                }
                if (this.bean.isPasswordEncryptedSet()) {
                    stringBuffer.append("PasswordEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getPasswordEncrypted())));
                }
                if (this.bean.isPropertiesSet()) {
                    stringBuffer.append("Properties");
                    stringBuffer.append(String.valueOf(this.bean.getProperties()));
                }
                if (this.bean.isURLSet()) {
                    stringBuffer.append("URL");
                    stringBuffer.append(String.valueOf(this.bean.getURL()));
                }
                if (this.bean.isUserNameSet()) {
                    stringBuffer.append("UserName");
                    stringBuffer.append(String.valueOf(this.bean.getUserName()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                JDBCDataSourceFactoryMBeanImpl jDBCDataSourceFactoryMBeanImpl = (JDBCDataSourceFactoryMBeanImpl)abstractDescriptorBean;
                this.computeDiff("DriverClassName", this.bean.getDriverClassName(), jDBCDataSourceFactoryMBeanImpl.getDriverClassName(), false);
                this.computeDiff("FactoryName", this.bean.getFactoryName(), jDBCDataSourceFactoryMBeanImpl.getFactoryName(), false);
                this.computeDiff("Name", this.bean.getName(), jDBCDataSourceFactoryMBeanImpl.getName(), false);
                this.computeDiff("PasswordEncrypted", this.bean.getPasswordEncrypted(), jDBCDataSourceFactoryMBeanImpl.getPasswordEncrypted(), false);
                this.computeDiff("Properties", this.bean.getProperties(), jDBCDataSourceFactoryMBeanImpl.getProperties(), false);
                this.computeDiff("URL", this.bean.getURL(), jDBCDataSourceFactoryMBeanImpl.getURL(), false);
                this.computeDiff("UserName", this.bean.getUserName(), jDBCDataSourceFactoryMBeanImpl.getUserName(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                JDBCDataSourceFactoryMBeanImpl jDBCDataSourceFactoryMBeanImpl = (JDBCDataSourceFactoryMBeanImpl)beanUpdateEvent.getSourceBean();
                JDBCDataSourceFactoryMBeanImpl jDBCDataSourceFactoryMBeanImpl2 = (JDBCDataSourceFactoryMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("DriverClassName")) {
                    jDBCDataSourceFactoryMBeanImpl.setDriverClassName(jDBCDataSourceFactoryMBeanImpl2.getDriverClassName());
                    jDBCDataSourceFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("FactoryName")) {
                    jDBCDataSourceFactoryMBeanImpl.setFactoryName(jDBCDataSourceFactoryMBeanImpl2.getFactoryName());
                    jDBCDataSourceFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("Name")) {
                    jDBCDataSourceFactoryMBeanImpl.setName(jDBCDataSourceFactoryMBeanImpl2.getName());
                    jDBCDataSourceFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (!string.equals("Password")) {
                    if (string.equals("PasswordEncrypted")) {
                        jDBCDataSourceFactoryMBeanImpl.setPasswordEncrypted(jDBCDataSourceFactoryMBeanImpl2.getPasswordEncrypted());
                        jDBCDataSourceFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                    } else if (string.equals("Properties")) {
                        jDBCDataSourceFactoryMBeanImpl.setProperties(jDBCDataSourceFactoryMBeanImpl2.getProperties());
                        jDBCDataSourceFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                    } else if (string.equals("URL")) {
                        jDBCDataSourceFactoryMBeanImpl.setURL(jDBCDataSourceFactoryMBeanImpl2.getURL());
                        jDBCDataSourceFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                    } else if (string.equals("UserName")) {
                        jDBCDataSourceFactoryMBeanImpl.setUserName(jDBCDataSourceFactoryMBeanImpl2.getUserName());
                        jDBCDataSourceFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                    } else {
                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                JDBCDataSourceFactoryMBeanImpl jDBCDataSourceFactoryMBeanImpl = (JDBCDataSourceFactoryMBeanImpl)abstractDescriptorBean;
                super.finishCopy(jDBCDataSourceFactoryMBeanImpl, bl, list);
                if ((list == null || !list.contains("DriverClassName")) && this.bean.isDriverClassNameSet()) {
                    jDBCDataSourceFactoryMBeanImpl.setDriverClassName(this.bean.getDriverClassName());
                }
                if ((list == null || !list.contains("FactoryName")) && this.bean.isFactoryNameSet()) {
                    jDBCDataSourceFactoryMBeanImpl.setFactoryName(this.bean.getFactoryName());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    jDBCDataSourceFactoryMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("PasswordEncrypted")) && this.bean.isPasswordEncryptedSet()) {
                    byte[] byArray = this.bean.getPasswordEncrypted();
                    jDBCDataSourceFactoryMBeanImpl.setPasswordEncrypted(byArray == null ? null : (byte[])byArray.clone());
                }
                if ((list == null || !list.contains("Properties")) && this.bean.isPropertiesSet()) {
                    jDBCDataSourceFactoryMBeanImpl.setProperties(this.bean.getProperties());
                }
                if ((list == null || !list.contains("URL")) && this.bean.isURLSet()) {
                    jDBCDataSourceFactoryMBeanImpl.setURL(this.bean.getURL());
                }
                if ((list == null || !list.contains("UserName")) && this.bean.isUserNameSet()) {
                    jDBCDataSourceFactoryMBeanImpl.setUserName(this.bean.getUserName());
                }
                return jDBCDataSourceFactoryMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

