/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BootstrapProperties;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorValidateException;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.DeploymentMBeanImpl;
import weblogic.management.configuration.JDBCDataSourceMBean;
import weblogic.management.configuration.JDBCLegalHelper;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.TargetMBeanImpl;
import weblogic.management.mbeans.custom.JDBCDataSource;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class JDBCDataSourceMBeanImpl
extends DeploymentMBeanImpl
implements JDBCDataSourceMBean,
Serializable {
    private int _ConnectionWaitPeriod;
    private JDBCSystemResourceMBean _JDBCSystemResource;
    private String _JNDIName;
    private String _JNDINameSeparator;
    private String _Name;
    private String _PoolName;
    private boolean _RowPrefetchEnabled;
    private int _RowPrefetchSize;
    private int _StreamChunkSize;
    private TargetMBean[] _Targets;
    private boolean _WaitForConnectionEnabled;
    private JDBCDataSource _customizer;
    private static SchemaHelper2 _schemaHelper;

    public JDBCDataSourceMBeanImpl() {
        try {
            this._customizer = new JDBCDataSource(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public JDBCDataSourceMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new JDBCDataSource(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public TargetMBean[] getTargets() {
        return this._customizer.getTargets();
    }

    public String getTargetsAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getTargets());
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isTargetsSet() {
        return this._isSet(7);
    }

    public void setJDBCSystemResource(JDBCSystemResourceMBean jDBCSystemResourceMBean) {
        JDBCSystemResourceMBean jDBCSystemResourceMBean2 = this.getJDBCSystemResource();
        this._customizer.setJDBCSystemResource(jDBCSystemResourceMBean);
        this._postSet(9, jDBCSystemResourceMBean2, jDBCSystemResourceMBean);
    }

    public void setTargetsAsString(String string) {
        if (string == null || string.length() == 0) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._initializeProperty(7);
            this._postSet(7, targetMBeanArray, this._Targets);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._Targets);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, TargetMBean.class, new ReferenceManager.Resolver(this, 7){

                    public void resolveReference(Object object) {
                        try {
                            JDBCDataSourceMBeanImpl.this.addTarget((TargetMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (TargetMBean targetMBean : this._Targets) {
                    if (!string2.equals(targetMBean.getName())) continue;
                    try {
                        this.removeTarget(targetMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public JDBCSystemResourceMBean getJDBCSystemResource() {
        return this._customizer.getJDBCSystemResource();
    }

    public String getJDBCSystemResourceAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getJDBCSystemResource();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isJDBCSystemResourceSet() {
        return this._isSet(9);
    }

    public void setJDBCSystemResourceAsString(String string) {
        if (string == null || string.length() == 0) {
            JDBCSystemResourceMBean jDBCSystemResourceMBean = this._JDBCSystemResource;
            this._initializeProperty(9);
            this._postSet(9, jDBCSystemResourceMBean, this._JDBCSystemResource);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, JDBCSystemResourceMBean.class, new ReferenceManager.Resolver(this, 9){

                public void resolveReference(Object object) {
                    try {
                        JDBCDataSourceMBeanImpl.this.setJDBCSystemResource((JDBCSystemResourceMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setTargets(TargetMBean[] targetMBeanArray) throws InvalidAttributeValueException, DistributedManagementException {
        targetMBeanArray = targetMBeanArray == null ? new TargetMBeanImpl[]{} : targetMBeanArray;
        targetMBeanArray = (TargetMBean[])this._getHelper()._cleanAndValidateArray((Object)targetMBeanArray, TargetMBean.class);
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            if (targetMBeanArray[i] == null) continue;
            ResolvedReference resolvedReference = new ResolvedReference(this, 7, (AbstractDescriptorBean)targetMBeanArray[i]){

                protected Object getPropertyValue() {
                    return JDBCDataSourceMBeanImpl.this.getTargets();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)targetMBeanArray[i], resolvedReference);
        }
        TargetMBean[] targetMBeanArray2 = this.getTargets();
        this._customizer.setTargets(targetMBeanArray);
        this._postSet(7, targetMBeanArray2, targetMBeanArray);
    }

    public boolean addTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        this._getHelper()._ensureNonNull((Object)targetMBean);
        if (!((AbstractDescriptorBean)targetMBean).isChildProperty((DescriptorBean)this, 7)) {
            TargetMBean[] targetMBeanArray = (TargetMBean[])this._getHelper()._extendArray((Object)this.getTargets(), TargetMBean.class, (Object)targetMBean);
            try {
                this.setTargets(targetMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public String getJNDIName() {
        return this._customizer.getJNDIName();
    }

    public boolean isJNDINameSet() {
        return this._isSet(10);
    }

    public boolean removeTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        TargetMBean[] targetMBeanArray = this.getTargets();
        TargetMBean[] targetMBeanArray2 = (TargetMBean[])this._getHelper()._removeElement((Object)targetMBeanArray, TargetMBean.class, (Object)targetMBean);
        if (targetMBeanArray2.length != targetMBeanArray.length) {
            try {
                this.setTargets(targetMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public void setJNDIName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this.getJNDIName();
        this._customizer.setJNDIName(string);
        this._postSet(10, string2, string);
    }

    public String getJNDINameSeparator() {
        return this._customizer.getJNDINameSeparator();
    }

    public boolean isJNDINameSeparatorSet() {
        return this._isSet(11);
    }

    public void setJNDINameSeparator(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"JNDINameSeparator", (String)string);
        LegalChecks.checkNonNull((String)"JNDINameSeparator", (Object)string);
        String string2 = this.getJNDINameSeparator();
        this._customizer.setJNDINameSeparator(string);
        this._postSet(11, string2, string);
    }

    public String getPoolName() {
        return this._customizer.getPoolName();
    }

    public boolean isPoolNameSet() {
        return this._isSet(12);
    }

    public void setPoolName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this.getPoolName();
        this._customizer.setPoolName(string);
        this._postSet(12, string2, string);
    }

    public boolean isRowPrefetchEnabled() {
        return this._customizer.isRowPrefetchEnabled();
    }

    public boolean isRowPrefetchEnabledSet() {
        return this._isSet(13);
    }

    public void setRowPrefetchEnabled(boolean bl) {
        boolean bl2 = this.isRowPrefetchEnabled();
        try {
            this._customizer.setRowPrefetchEnabled(bl);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new UndeclaredThrowableException(invalidAttributeValueException);
        }
        this._postSet(13, bl2, bl);
    }

    public int getRowPrefetchSize() {
        return this._customizer.getRowPrefetchSize();
    }

    public boolean isRowPrefetchSizeSet() {
        return this._isSet(14);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void setRowPrefetchSize(int n) {
        LegalChecks.checkInRange((String)"RowPrefetchSize", (long)n, (long)2L, (long)65536L);
        int n2 = this.getRowPrefetchSize();
        try {
            this._customizer.setRowPrefetchSize(n);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new UndeclaredThrowableException(invalidAttributeValueException);
        }
        this._postSet(14, n2, n);
    }

    public int getStreamChunkSize() {
        return this._customizer.getStreamChunkSize();
    }

    public boolean isStreamChunkSizeSet() {
        return this._isSet(15);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setStreamChunkSize(int n) {
        LegalChecks.checkInRange((String)"StreamChunkSize", (long)n, (long)1L, (long)65536L);
        int n2 = this.getStreamChunkSize();
        try {
            this._customizer.setStreamChunkSize(n);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new UndeclaredThrowableException(invalidAttributeValueException);
        }
        this._postSet(15, n2, n);
    }

    public boolean isWaitForConnectionEnabled() {
        return this._WaitForConnectionEnabled;
    }

    public boolean isWaitForConnectionEnabledSet() {
        return this._isSet(16);
    }

    public void setWaitForConnectionEnabled(boolean bl) {
        boolean bl2 = this._WaitForConnectionEnabled;
        this._WaitForConnectionEnabled = bl;
        this._postSet(16, bl2, bl);
    }

    public int getConnectionWaitPeriod() {
        return this._ConnectionWaitPeriod;
    }

    public boolean isConnectionWaitPeriodSet() {
        return this._isSet(17);
    }

    public void setConnectionWaitPeriod(int n) {
        LegalChecks.checkInRange((String)"ConnectionWaitPeriod", (long)n, (long)1L, (long)60L);
        int n2 = this._ConnectionWaitPeriod;
        this._ConnectionWaitPeriod = n;
        this._postSet(17, n2, n);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
        JDBCLegalHelper.validateDataSourceJNDIName(this);
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 17;
        }
        try {
            switch (n) {
                case 17: {
                    this._ConnectionWaitPeriod = 1;
                    if (bl) break;
                }
                case 9: {
                    this._customizer.setJDBCSystemResource(null);
                    if (bl) break;
                }
                case 10: {
                    this._customizer.setJNDIName(null);
                    if (bl) break;
                }
                case 11: {
                    this._customizer.setJNDINameSeparator("JNDINameSeparator");
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 12: {
                    this._customizer.setPoolName(null);
                    if (bl) break;
                }
                case 14: {
                    this._customizer.setRowPrefetchSize(48);
                    if (bl) break;
                }
                case 15: {
                    this._customizer.setStreamChunkSize(256);
                    if (bl) break;
                }
                case 7: {
                    this._customizer.setTargets(new TargetMBean[0]);
                    if (bl) break;
                }
                case 13: {
                    this._customizer.setRowPrefetchEnabled(false);
                    if (bl) break;
                }
                case 16: {
                    this._WaitForConnectionEnabled = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "JDBCDataSource";
    }

    public void putValue(String string, Object object) {
        if (string.equals("ConnectionWaitPeriod")) {
            int n = this._ConnectionWaitPeriod;
            this._ConnectionWaitPeriod = (Integer)object;
            this._postSet(17, n, this._ConnectionWaitPeriod);
            return;
        }
        if (string.equals("JDBCSystemResource")) {
            JDBCSystemResourceMBean jDBCSystemResourceMBean = this._JDBCSystemResource;
            this._JDBCSystemResource = (JDBCSystemResourceMBean)object;
            this._postSet(9, jDBCSystemResourceMBean, this._JDBCSystemResource);
            return;
        }
        if (string.equals("JNDIName")) {
            String string2 = this._JNDIName;
            this._JNDIName = (String)object;
            this._postSet(10, string2, this._JNDIName);
            return;
        }
        if (string.equals("JNDINameSeparator")) {
            String string3 = this._JNDINameSeparator;
            this._JNDINameSeparator = (String)object;
            this._postSet(11, string3, this._JNDINameSeparator);
            return;
        }
        if (string.equals("Name")) {
            String string4 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string4, this._Name);
            return;
        }
        if (string.equals("PoolName")) {
            String string5 = this._PoolName;
            this._PoolName = (String)object;
            this._postSet(12, string5, this._PoolName);
            return;
        }
        if (string.equals("RowPrefetchEnabled")) {
            boolean bl = this._RowPrefetchEnabled;
            this._RowPrefetchEnabled = (Boolean)object;
            this._postSet(13, bl, this._RowPrefetchEnabled);
            return;
        }
        if (string.equals("RowPrefetchSize")) {
            int n = this._RowPrefetchSize;
            this._RowPrefetchSize = (Integer)object;
            this._postSet(14, n, this._RowPrefetchSize);
            return;
        }
        if (string.equals("StreamChunkSize")) {
            int n = this._StreamChunkSize;
            this._StreamChunkSize = (Integer)object;
            this._postSet(15, n, this._StreamChunkSize);
            return;
        }
        if (string.equals("Targets")) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._Targets = (TargetMBean[])object;
            this._postSet(7, targetMBeanArray, this._Targets);
            return;
        }
        if (string.equals("WaitForConnectionEnabled")) {
            boolean bl = this._WaitForConnectionEnabled;
            this._WaitForConnectionEnabled = (Boolean)object;
            this._postSet(16, bl, this._WaitForConnectionEnabled);
            return;
        }
        if (string.equals("customizer")) {
            JDBCDataSource jDBCDataSource = this._customizer;
            this._customizer = (JDBCDataSource)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("ConnectionWaitPeriod")) {
            return new Integer(this._ConnectionWaitPeriod);
        }
        if (string.equals("JDBCSystemResource")) {
            return this._JDBCSystemResource;
        }
        if (string.equals("JNDIName")) {
            return this._JNDIName;
        }
        if (string.equals("JNDINameSeparator")) {
            return this._JNDINameSeparator;
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("PoolName")) {
            return this._PoolName;
        }
        if (string.equals("RowPrefetchEnabled")) {
            return new Boolean(this._RowPrefetchEnabled);
        }
        if (string.equals("RowPrefetchSize")) {
            return new Integer(this._RowPrefetchSize);
        }
        if (string.equals("StreamChunkSize")) {
            return new Integer(this._StreamChunkSize);
        }
        if (string.equals("Targets")) {
            return this._Targets;
        }
        if (string.equals("WaitForConnectionEnabled")) {
            return new Boolean(this._WaitForConnectionEnabled);
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static void validateGeneration() {
        try {
            LegalChecks.checkNonEmptyString((String)"JNDINameSeparator", (String)"JNDINameSeparator");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("The default value for the property  is zero-length. Properties annotated with false value on @legalZeroLength or @legalNull  should either have @required/@derivedDefault annotations or have a non-zero-length value on @default annotation. Refer annotation legalZeroLength on property JNDINameSeparator in JDBCDataSourceMBean" + illegalArgumentException.getMessage());
        }
        try {
            LegalChecks.checkNonNull((String)"JNDINameSeparator", (Object)"JNDINameSeparator");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("The default value for the property  is null. Properties annotated with false value on @legalZeroLength or @legalNull  should either have @required/@derivedDefault annotations or have a non-null value on @default annotation. Refer annotation legalNull on property JNDINameSeparator in JDBCDataSourceMBean" + illegalArgumentException.getMessage());
        }
    }

    public static class SchemaHelper2
    extends DeploymentMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 22: {
                    if (!string.equals("connection-wait-period")) break;
                    return 17;
                }
                case 20: {
                    if (string.equals("jdbc-system-resource")) {
                        return 9;
                    }
                    if (!string.equals("row-prefetch-enabled")) break;
                    return 13;
                }
                case 9: {
                    if (string.equals("jndi-name")) {
                        return 10;
                    }
                    if (!string.equals("pool-name")) break;
                    return 12;
                }
                case 19: {
                    if (!string.equals("jndi-name-separator")) break;
                    return 11;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 17: {
                    if (string.equals("row-prefetch-size")) {
                        return 14;
                    }
                    if (!string.equals("stream-chunk-size")) break;
                    return 15;
                }
                case 6: {
                    if (!string.equals("target")) break;
                    return 7;
                }
                case 27: {
                    if (!string.equals("wait-for-connection-enabled")) break;
                    return 16;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 17: {
                    return "connection-wait-period";
                }
                case 9: {
                    return "jdbc-system-resource";
                }
                case 10: {
                    return "jndi-name";
                }
                case 11: {
                    return "jndi-name-separator";
                }
                case 2: {
                    return "name";
                }
                case 12: {
                    return "pool-name";
                }
                case 14: {
                    return "row-prefetch-size";
                }
                case 15: {
                    return "stream-chunk-size";
                }
                case 7: {
                    return "target";
                }
                case 13: {
                    return "row-prefetch-enabled";
                }
                case 16: {
                    return "wait-for-connection-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 7: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends DeploymentMBeanImpl.Helper {
        private JDBCDataSourceMBeanImpl bean;

        protected Helper(JDBCDataSourceMBeanImpl jDBCDataSourceMBeanImpl) {
            super(jDBCDataSourceMBeanImpl);
            this.bean = jDBCDataSourceMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 17: {
                    return "ConnectionWaitPeriod";
                }
                case 9: {
                    return "JDBCSystemResource";
                }
                case 10: {
                    return "JNDIName";
                }
                case 11: {
                    return "JNDINameSeparator";
                }
                case 2: {
                    return "Name";
                }
                case 12: {
                    return "PoolName";
                }
                case 14: {
                    return "RowPrefetchSize";
                }
                case 15: {
                    return "StreamChunkSize";
                }
                case 7: {
                    return "Targets";
                }
                case 13: {
                    return "RowPrefetchEnabled";
                }
                case 16: {
                    return "WaitForConnectionEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("ConnectionWaitPeriod")) {
                return 17;
            }
            if (string.equals("JDBCSystemResource")) {
                return 9;
            }
            if (string.equals("JNDIName")) {
                return 10;
            }
            if (string.equals("JNDINameSeparator")) {
                return 11;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("PoolName")) {
                return 12;
            }
            if (string.equals("RowPrefetchSize")) {
                return 14;
            }
            if (string.equals("StreamChunkSize")) {
                return 15;
            }
            if (string.equals("Targets")) {
                return 7;
            }
            if (string.equals("RowPrefetchEnabled")) {
                return 13;
            }
            if (string.equals("WaitForConnectionEnabled")) {
                return 16;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isConnectionWaitPeriodSet()) {
                    stringBuffer.append("ConnectionWaitPeriod");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionWaitPeriod()));
                }
                if (this.bean.isJDBCSystemResourceSet()) {
                    stringBuffer.append("JDBCSystemResource");
                    stringBuffer.append(String.valueOf(this.bean.getJDBCSystemResource()));
                }
                if (this.bean.isJNDINameSet()) {
                    stringBuffer.append("JNDIName");
                    stringBuffer.append(String.valueOf(this.bean.getJNDIName()));
                }
                if (this.bean.isJNDINameSeparatorSet()) {
                    stringBuffer.append("JNDINameSeparator");
                    stringBuffer.append(String.valueOf(this.bean.getJNDINameSeparator()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isPoolNameSet()) {
                    stringBuffer.append("PoolName");
                    stringBuffer.append(String.valueOf(this.bean.getPoolName()));
                }
                if (this.bean.isRowPrefetchSizeSet()) {
                    stringBuffer.append("RowPrefetchSize");
                    stringBuffer.append(String.valueOf(this.bean.getRowPrefetchSize()));
                }
                if (this.bean.isStreamChunkSizeSet()) {
                    stringBuffer.append("StreamChunkSize");
                    stringBuffer.append(String.valueOf(this.bean.getStreamChunkSize()));
                }
                if (this.bean.isTargetsSet()) {
                    stringBuffer.append("Targets");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getTargets())));
                }
                if (this.bean.isRowPrefetchEnabledSet()) {
                    stringBuffer.append("RowPrefetchEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isRowPrefetchEnabled()));
                }
                if (this.bean.isWaitForConnectionEnabledSet()) {
                    stringBuffer.append("WaitForConnectionEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isWaitForConnectionEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                JDBCDataSourceMBeanImpl jDBCDataSourceMBeanImpl = (JDBCDataSourceMBeanImpl)abstractDescriptorBean;
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ConnectionWaitPeriod", this.bean.getConnectionWaitPeriod(), jDBCDataSourceMBeanImpl.getConnectionWaitPeriod(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("JDBCSystemResource", this.bean.getJDBCSystemResource(), jDBCDataSourceMBeanImpl.getJDBCSystemResource(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("JNDIName", this.bean.getJNDIName(), jDBCDataSourceMBeanImpl.getJNDIName(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("JNDINameSeparator", this.bean.getJNDINameSeparator(), jDBCDataSourceMBeanImpl.getJNDINameSeparator(), false);
                }
                this.computeDiff("Name", this.bean.getName(), jDBCDataSourceMBeanImpl.getName(), false);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("PoolName", this.bean.getPoolName(), jDBCDataSourceMBeanImpl.getPoolName(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("RowPrefetchSize", this.bean.getRowPrefetchSize(), jDBCDataSourceMBeanImpl.getRowPrefetchSize(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("StreamChunkSize", this.bean.getStreamChunkSize(), jDBCDataSourceMBeanImpl.getStreamChunkSize(), false);
                }
                this.computeDiff("Targets", this.bean.getTargets(), jDBCDataSourceMBeanImpl.getTargets(), true);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("RowPrefetchEnabled", this.bean.isRowPrefetchEnabled(), jDBCDataSourceMBeanImpl.isRowPrefetchEnabled(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("WaitForConnectionEnabled", this.bean.isWaitForConnectionEnabled(), jDBCDataSourceMBeanImpl.isWaitForConnectionEnabled(), false);
                }
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                JDBCDataSourceMBeanImpl jDBCDataSourceMBeanImpl = (JDBCDataSourceMBeanImpl)beanUpdateEvent.getSourceBean();
                JDBCDataSourceMBeanImpl jDBCDataSourceMBeanImpl2 = (JDBCDataSourceMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("ConnectionWaitPeriod")) {
                    jDBCDataSourceMBeanImpl.setConnectionWaitPeriod(jDBCDataSourceMBeanImpl2.getConnectionWaitPeriod());
                    jDBCDataSourceMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else if (string.equals("JDBCSystemResource")) {
                    jDBCDataSourceMBeanImpl.setJDBCSystemResourceAsString(jDBCDataSourceMBeanImpl2.getJDBCSystemResourceAsString());
                    jDBCDataSourceMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("JNDIName")) {
                    jDBCDataSourceMBeanImpl.setJNDIName(jDBCDataSourceMBeanImpl2.getJNDIName());
                    jDBCDataSourceMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("JNDINameSeparator")) {
                    jDBCDataSourceMBeanImpl.setJNDINameSeparator(jDBCDataSourceMBeanImpl2.getJNDINameSeparator());
                    jDBCDataSourceMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("Name")) {
                    jDBCDataSourceMBeanImpl.setName(jDBCDataSourceMBeanImpl2.getName());
                    jDBCDataSourceMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (string.equals("PoolName")) {
                    jDBCDataSourceMBeanImpl.setPoolName(jDBCDataSourceMBeanImpl2.getPoolName());
                    jDBCDataSourceMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("RowPrefetchSize")) {
                    jDBCDataSourceMBeanImpl.setRowPrefetchSize(jDBCDataSourceMBeanImpl2.getRowPrefetchSize());
                    jDBCDataSourceMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("StreamChunkSize")) {
                    jDBCDataSourceMBeanImpl.setStreamChunkSize(jDBCDataSourceMBeanImpl2.getStreamChunkSize());
                    jDBCDataSourceMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("Targets")) {
                    jDBCDataSourceMBeanImpl.setTargetsAsString(jDBCDataSourceMBeanImpl2.getTargetsAsString());
                    jDBCDataSourceMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("RowPrefetchEnabled")) {
                    jDBCDataSourceMBeanImpl.setRowPrefetchEnabled(jDBCDataSourceMBeanImpl2.isRowPrefetchEnabled());
                    jDBCDataSourceMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("WaitForConnectionEnabled")) {
                    jDBCDataSourceMBeanImpl.setWaitForConnectionEnabled(jDBCDataSourceMBeanImpl2.isWaitForConnectionEnabled());
                    jDBCDataSourceMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                JDBCDataSourceMBeanImpl jDBCDataSourceMBeanImpl = (JDBCDataSourceMBeanImpl)abstractDescriptorBean;
                super.finishCopy(jDBCDataSourceMBeanImpl, bl, list);
                if (bl && (list == null || !list.contains("ConnectionWaitPeriod")) && this.bean.isConnectionWaitPeriodSet()) {
                    jDBCDataSourceMBeanImpl.setConnectionWaitPeriod(this.bean.getConnectionWaitPeriod());
                }
                if (bl && (list == null || !list.contains("JDBCSystemResource")) && this.bean.isJDBCSystemResourceSet()) {
                    jDBCDataSourceMBeanImpl._unSet(jDBCDataSourceMBeanImpl, 9);
                    jDBCDataSourceMBeanImpl.setJDBCSystemResourceAsString(this.bean.getJDBCSystemResourceAsString());
                }
                if (bl && (list == null || !list.contains("JNDIName")) && this.bean.isJNDINameSet()) {
                    jDBCDataSourceMBeanImpl.setJNDIName(this.bean.getJNDIName());
                }
                if (bl && (list == null || !list.contains("JNDINameSeparator")) && this.bean.isJNDINameSeparatorSet()) {
                    jDBCDataSourceMBeanImpl.setJNDINameSeparator(this.bean.getJNDINameSeparator());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    jDBCDataSourceMBeanImpl.setName(this.bean.getName());
                }
                if (bl && (list == null || !list.contains("PoolName")) && this.bean.isPoolNameSet()) {
                    jDBCDataSourceMBeanImpl.setPoolName(this.bean.getPoolName());
                }
                if (bl && (list == null || !list.contains("RowPrefetchSize")) && this.bean.isRowPrefetchSizeSet()) {
                    jDBCDataSourceMBeanImpl.setRowPrefetchSize(this.bean.getRowPrefetchSize());
                }
                if (bl && (list == null || !list.contains("StreamChunkSize")) && this.bean.isStreamChunkSizeSet()) {
                    jDBCDataSourceMBeanImpl.setStreamChunkSize(this.bean.getStreamChunkSize());
                }
                if ((list == null || !list.contains("Targets")) && this.bean.isTargetsSet()) {
                    jDBCDataSourceMBeanImpl._unSet(jDBCDataSourceMBeanImpl, 7);
                    jDBCDataSourceMBeanImpl.setTargetsAsString(this.bean.getTargetsAsString());
                }
                if (bl && (list == null || !list.contains("RowPrefetchEnabled")) && this.bean.isRowPrefetchEnabledSet()) {
                    jDBCDataSourceMBeanImpl.setRowPrefetchEnabled(this.bean.isRowPrefetchEnabled());
                }
                if (bl && (list == null || !list.contains("WaitForConnectionEnabled")) && this.bean.isWaitForConnectionEnabledSet()) {
                    jDBCDataSourceMBeanImpl.setWaitForConnectionEnabled(this.bean.isWaitForConnectionEnabled());
                }
                return jDBCDataSourceMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getJDBCSystemResource(), clazz, object);
            this.inferSubTree(this.bean.getTargets(), clazz, object);
        }
    }
}

