/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BootstrapProperties;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.DeploymentMBeanImpl;
import weblogic.management.configuration.JDBCConnectionPoolMBean;
import weblogic.management.configuration.JDBCConnectionPoolMBeanImpl;
import weblogic.management.configuration.JDBCMultiPoolMBean;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.TargetMBeanImpl;
import weblogic.management.mbeans.custom.JDBCMultiPool;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class JDBCMultiPoolMBeanImpl
extends DeploymentMBeanImpl
implements JDBCMultiPoolMBean,
Serializable {
    private String _ACLName;
    private String _AlgorithmType;
    private String _ConnectionPoolFailoverCallbackHandler;
    private boolean _FailoverRequestIfBusy;
    private int _HealthCheckFrequencySeconds;
    private boolean _HighAvail;
    private JDBCSystemResourceMBean _JDBCSystemResource;
    private boolean _LoadBalance;
    private String _Name;
    private JDBCConnectionPoolMBean[] _PoolList;
    private TargetMBean[] _Targets;
    private JDBCMultiPool _customizer;
    private static SchemaHelper2 _schemaHelper;

    public JDBCMultiPoolMBeanImpl() {
        try {
            this._customizer = new JDBCMultiPool(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public JDBCMultiPoolMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new JDBCMultiPool(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public TargetMBean[] getTargets() {
        return this._customizer.getTargets();
    }

    public String getTargetsAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getTargets());
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isTargetsSet() {
        return this._isSet(7);
    }

    public void setJDBCSystemResource(JDBCSystemResourceMBean jDBCSystemResourceMBean) {
        JDBCSystemResourceMBean jDBCSystemResourceMBean2 = this.getJDBCSystemResource();
        this._customizer.setJDBCSystemResource(jDBCSystemResourceMBean);
        this._postSet(9, jDBCSystemResourceMBean2, jDBCSystemResourceMBean);
    }

    public void setTargetsAsString(String string) {
        if (string == null || string.length() == 0) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._initializeProperty(7);
            this._postSet(7, targetMBeanArray, this._Targets);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._Targets);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, TargetMBean.class, new ReferenceManager.Resolver(this, 7){

                    public void resolveReference(Object object) {
                        try {
                            JDBCMultiPoolMBeanImpl.this.addTarget((TargetMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (TargetMBean targetMBean : this._Targets) {
                    if (!string2.equals(targetMBean.getName())) continue;
                    try {
                        this.removeTarget(targetMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public JDBCSystemResourceMBean getJDBCSystemResource() {
        return this._customizer.getJDBCSystemResource();
    }

    public String getJDBCSystemResourceAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getJDBCSystemResource();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isJDBCSystemResourceSet() {
        return this._isSet(9);
    }

    public void setJDBCSystemResourceAsString(String string) {
        if (string == null || string.length() == 0) {
            JDBCSystemResourceMBean jDBCSystemResourceMBean = this._JDBCSystemResource;
            this._initializeProperty(9);
            this._postSet(9, jDBCSystemResourceMBean, this._JDBCSystemResource);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, JDBCSystemResourceMBean.class, new ReferenceManager.Resolver(this, 9){

                public void resolveReference(Object object) {
                    try {
                        JDBCMultiPoolMBeanImpl.this.setJDBCSystemResource((JDBCSystemResourceMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setTargets(TargetMBean[] targetMBeanArray) throws InvalidAttributeValueException, DistributedManagementException {
        targetMBeanArray = targetMBeanArray == null ? new TargetMBeanImpl[]{} : targetMBeanArray;
        targetMBeanArray = (TargetMBean[])this._getHelper()._cleanAndValidateArray((Object)targetMBeanArray, TargetMBean.class);
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            if (targetMBeanArray[i] == null) continue;
            ResolvedReference resolvedReference = new ResolvedReference(this, 7, (AbstractDescriptorBean)targetMBeanArray[i]){

                protected Object getPropertyValue() {
                    return JDBCMultiPoolMBeanImpl.this.getTargets();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)targetMBeanArray[i], resolvedReference);
        }
        TargetMBean[] targetMBeanArray2 = this.getTargets();
        this._customizer.setTargets(targetMBeanArray);
        this._postSet(7, targetMBeanArray2, targetMBeanArray);
    }

    public boolean addTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        this._getHelper()._ensureNonNull((Object)targetMBean);
        if (!((AbstractDescriptorBean)targetMBean).isChildProperty((DescriptorBean)this, 7)) {
            TargetMBean[] targetMBeanArray = (TargetMBean[])this._getHelper()._extendArray((Object)this.getTargets(), TargetMBean.class, (Object)targetMBean);
            try {
                this.setTargets(targetMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public String getACLName() {
        return this._ACLName;
    }

    public boolean isACLNameSet() {
        return this._isSet(10);
    }

    public boolean removeTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        TargetMBean[] targetMBeanArray = this.getTargets();
        TargetMBean[] targetMBeanArray2 = (TargetMBean[])this._getHelper()._removeElement((Object)targetMBeanArray, TargetMBean.class, (Object)targetMBean);
        if (targetMBeanArray2.length != targetMBeanArray.length) {
            try {
                this.setTargets(targetMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public void setACLName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ACLName;
        this._ACLName = string;
        this._postSet(10, string2, string);
    }

    public void addPool(JDBCConnectionPoolMBean jDBCConnectionPoolMBean) {
        this._getHelper()._ensureNonNull((Object)jDBCConnectionPoolMBean);
        if (!((AbstractDescriptorBean)jDBCConnectionPoolMBean).isChildProperty((DescriptorBean)this, 11)) {
            JDBCConnectionPoolMBean[] jDBCConnectionPoolMBeanArray = (JDBCConnectionPoolMBean[])this._getHelper()._extendArray((Object)this.getPoolList(), JDBCConnectionPoolMBean.class, (Object)jDBCConnectionPoolMBean);
            try {
                this.setPoolList(jDBCConnectionPoolMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public JDBCConnectionPoolMBean[] getPoolList() {
        return this._customizer.getPoolList();
    }

    public String getPoolListAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getPoolList());
    }

    public boolean isPoolListSet() {
        return this._isSet(11);
    }

    public void removePool(JDBCConnectionPoolMBean jDBCConnectionPoolMBean) {
        JDBCConnectionPoolMBean[] jDBCConnectionPoolMBeanArray = this.getPoolList();
        JDBCConnectionPoolMBean[] jDBCConnectionPoolMBeanArray2 = (JDBCConnectionPoolMBean[])this._getHelper()._removeElement((Object)jDBCConnectionPoolMBeanArray, JDBCConnectionPoolMBean.class, (Object)jDBCConnectionPoolMBean);
        if (jDBCConnectionPoolMBeanArray2.length != jDBCConnectionPoolMBeanArray.length) {
            try {
                this.setPoolList(jDBCConnectionPoolMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void setPoolListAsString(String string) {
        if (string == null || string.length() == 0) {
            JDBCConnectionPoolMBean[] jDBCConnectionPoolMBeanArray = this._PoolList;
            this._initializeProperty(11);
            this._postSet(11, jDBCConnectionPoolMBeanArray, this._PoolList);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._PoolList);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, JDBCConnectionPoolMBean.class, new ReferenceManager.Resolver(this, 11){

                    public void resolveReference(Object object) {
                        try {
                            JDBCMultiPoolMBeanImpl.this.addPool((JDBCConnectionPoolMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (JDBCConnectionPoolMBean jDBCConnectionPoolMBean : this._PoolList) {
                    if (!string2.equals(jDBCConnectionPoolMBean.getName())) continue;
                    try {
                        this.removePool(jDBCConnectionPoolMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void setPoolList(JDBCConnectionPoolMBean[] jDBCConnectionPoolMBeanArray) throws InvalidAttributeValueException {
        jDBCConnectionPoolMBeanArray = jDBCConnectionPoolMBeanArray == null ? new JDBCConnectionPoolMBeanImpl[]{} : jDBCConnectionPoolMBeanArray;
        JDBCConnectionPoolMBean[] jDBCConnectionPoolMBeanArray2 = this.getPoolList();
        this._customizer.setPoolList(jDBCConnectionPoolMBeanArray);
        this._postSet(11, jDBCConnectionPoolMBeanArray2, jDBCConnectionPoolMBeanArray);
    }

    public void setLoadBalance(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._LoadBalance;
        this._LoadBalance = bl;
        this._postSet(12, bl2, bl);
    }

    public boolean isLoadBalance() {
        return this._LoadBalance;
    }

    public boolean isLoadBalanceSet() {
        return this._isSet(12);
    }

    public void setHighAvail(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._HighAvail;
        this._HighAvail = bl;
        this._postSet(13, bl2, bl);
    }

    public boolean isHighAvail() {
        return this._HighAvail;
    }

    public boolean isHighAvailSet() {
        return this._isSet(13);
    }

    public void setAlgorithmType(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"High-Availability", "Load-Balancing", "Failover"};
        string = LegalChecks.checkInEnum((String)"AlgorithmType", (String)string, (String[])stringArray);
        String string2 = this.getAlgorithmType();
        try {
            this._customizer.setAlgorithmType(string);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new UndeclaredThrowableException(invalidAttributeValueException);
        }
        this._postSet(14, string2, string);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public String getAlgorithmType() {
        return this._customizer.getAlgorithmType();
    }

    public boolean isAlgorithmTypeSet() {
        return this._isSet(14);
    }

    public String getConnectionPoolFailoverCallbackHandler() {
        return this._customizer.getConnectionPoolFailoverCallbackHandler();
    }

    public boolean isConnectionPoolFailoverCallbackHandlerSet() {
        return this._isSet(15);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setConnectionPoolFailoverCallbackHandler(String string) {
        string = string == null ? null : string.trim();
        String string2 = this.getConnectionPoolFailoverCallbackHandler();
        this._customizer.setConnectionPoolFailoverCallbackHandler(string);
        this._postSet(15, string2, string);
    }

    public void setFailoverRequestIfBusy(boolean bl) {
        boolean bl2 = this.getFailoverRequestIfBusy();
        this._customizer.setFailoverRequestIfBusy(bl);
        this._postSet(16, bl2, bl);
    }

    public boolean getFailoverRequestIfBusy() {
        return this._customizer.getFailoverRequestIfBusy();
    }

    public boolean isFailoverRequestIfBusySet() {
        return this._isSet(16);
    }

    public void setHealthCheckFrequencySeconds(int n) {
        int n2 = this.getHealthCheckFrequencySeconds();
        this._customizer.setHealthCheckFrequencySeconds(n);
        this._postSet(17, n2, n);
    }

    public int getHealthCheckFrequencySeconds() {
        return this._customizer.getHealthCheckFrequencySeconds();
    }

    public boolean isHealthCheckFrequencySecondsSet() {
        return this._isSet(17);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 10;
        }
        try {
            switch (n) {
                case 10: {
                    this._ACLName = null;
                    if (bl) break;
                }
                case 14: {
                    this._customizer.setAlgorithmType("High-Availability");
                    if (bl) break;
                }
                case 15: {
                    this._customizer.setConnectionPoolFailoverCallbackHandler(null);
                    if (bl) break;
                }
                case 16: {
                    this._customizer.setFailoverRequestIfBusy(false);
                    if (bl) break;
                }
                case 17: {
                    this._customizer.setHealthCheckFrequencySeconds(300);
                    if (bl) break;
                }
                case 9: {
                    this._customizer.setJDBCSystemResource(null);
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 11: {
                    this._customizer.setPoolList(new JDBCConnectionPoolMBean[0]);
                    if (bl) break;
                }
                case 7: {
                    this._customizer.setTargets(new TargetMBean[0]);
                    if (bl) break;
                }
                case 13: {
                    this._HighAvail = false;
                    if (bl) break;
                }
                case 12: {
                    this._LoadBalance = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "JDBCMultiPool";
    }

    public void putValue(String string, Object object) {
        if (string.equals("ACLName")) {
            String string2 = this._ACLName;
            this._ACLName = (String)object;
            this._postSet(10, string2, this._ACLName);
            return;
        }
        if (string.equals("AlgorithmType")) {
            String string3 = this._AlgorithmType;
            this._AlgorithmType = (String)object;
            this._postSet(14, string3, this._AlgorithmType);
            return;
        }
        if (string.equals("ConnectionPoolFailoverCallbackHandler")) {
            String string4 = this._ConnectionPoolFailoverCallbackHandler;
            this._ConnectionPoolFailoverCallbackHandler = (String)object;
            this._postSet(15, string4, this._ConnectionPoolFailoverCallbackHandler);
            return;
        }
        if (string.equals("FailoverRequestIfBusy")) {
            boolean bl = this._FailoverRequestIfBusy;
            this._FailoverRequestIfBusy = (Boolean)object;
            this._postSet(16, bl, this._FailoverRequestIfBusy);
            return;
        }
        if (string.equals("HealthCheckFrequencySeconds")) {
            int n = this._HealthCheckFrequencySeconds;
            this._HealthCheckFrequencySeconds = (Integer)object;
            this._postSet(17, n, this._HealthCheckFrequencySeconds);
            return;
        }
        if (string.equals("HighAvail")) {
            boolean bl = this._HighAvail;
            this._HighAvail = (Boolean)object;
            this._postSet(13, bl, this._HighAvail);
            return;
        }
        if (string.equals("JDBCSystemResource")) {
            JDBCSystemResourceMBean jDBCSystemResourceMBean = this._JDBCSystemResource;
            this._JDBCSystemResource = (JDBCSystemResourceMBean)object;
            this._postSet(9, jDBCSystemResourceMBean, this._JDBCSystemResource);
            return;
        }
        if (string.equals("LoadBalance")) {
            boolean bl = this._LoadBalance;
            this._LoadBalance = (Boolean)object;
            this._postSet(12, bl, this._LoadBalance);
            return;
        }
        if (string.equals("Name")) {
            String string5 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string5, this._Name);
            return;
        }
        if (string.equals("PoolList")) {
            JDBCConnectionPoolMBean[] jDBCConnectionPoolMBeanArray = this._PoolList;
            this._PoolList = (JDBCConnectionPoolMBean[])object;
            this._postSet(11, jDBCConnectionPoolMBeanArray, this._PoolList);
            return;
        }
        if (string.equals("Targets")) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._Targets = (TargetMBean[])object;
            this._postSet(7, targetMBeanArray, this._Targets);
            return;
        }
        if (string.equals("customizer")) {
            JDBCMultiPool jDBCMultiPool = this._customizer;
            this._customizer = (JDBCMultiPool)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("ACLName")) {
            return this._ACLName;
        }
        if (string.equals("AlgorithmType")) {
            return this._AlgorithmType;
        }
        if (string.equals("ConnectionPoolFailoverCallbackHandler")) {
            return this._ConnectionPoolFailoverCallbackHandler;
        }
        if (string.equals("FailoverRequestIfBusy")) {
            return new Boolean(this._FailoverRequestIfBusy);
        }
        if (string.equals("HealthCheckFrequencySeconds")) {
            return new Integer(this._HealthCheckFrequencySeconds);
        }
        if (string.equals("HighAvail")) {
            return new Boolean(this._HighAvail);
        }
        if (string.equals("JDBCSystemResource")) {
            return this._JDBCSystemResource;
        }
        if (string.equals("LoadBalance")) {
            return new Boolean(this._LoadBalance);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("PoolList")) {
            return this._PoolList;
        }
        if (string.equals("Targets")) {
            return this._Targets;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends DeploymentMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 8: {
                    if (!string.equals("acl-name")) break;
                    return 10;
                }
                case 14: {
                    if (!string.equals("algorithm-type")) break;
                    return 14;
                }
                case 41: {
                    if (!string.equals("connection-pool-failover-callback-handler")) break;
                    return 15;
                }
                case 24: {
                    if (!string.equals("failover-request-if-busy")) break;
                    return 16;
                }
                case 30: {
                    if (!string.equals("health-check-frequency-seconds")) break;
                    return 17;
                }
                case 20: {
                    if (!string.equals("jdbc-system-resource")) break;
                    return 9;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 9: {
                    if (!string.equals("pool-list")) break;
                    return 11;
                }
                case 6: {
                    if (!string.equals("target")) break;
                    return 7;
                }
                case 10: {
                    if (!string.equals("high-avail")) break;
                    return 13;
                }
                case 12: {
                    if (!string.equals("load-balance")) break;
                    return 12;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 10: {
                    return "acl-name";
                }
                case 14: {
                    return "algorithm-type";
                }
                case 15: {
                    return "connection-pool-failover-callback-handler";
                }
                case 16: {
                    return "failover-request-if-busy";
                }
                case 17: {
                    return "health-check-frequency-seconds";
                }
                case 9: {
                    return "jdbc-system-resource";
                }
                case 2: {
                    return "name";
                }
                case 11: {
                    return "pool-list";
                }
                case 7: {
                    return "target";
                }
                case 13: {
                    return "high-avail";
                }
                case 12: {
                    return "load-balance";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 11: {
                    return true;
                }
                case 7: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends DeploymentMBeanImpl.Helper {
        private JDBCMultiPoolMBeanImpl bean;

        protected Helper(JDBCMultiPoolMBeanImpl jDBCMultiPoolMBeanImpl) {
            super(jDBCMultiPoolMBeanImpl);
            this.bean = jDBCMultiPoolMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 10: {
                    return "ACLName";
                }
                case 14: {
                    return "AlgorithmType";
                }
                case 15: {
                    return "ConnectionPoolFailoverCallbackHandler";
                }
                case 16: {
                    return "FailoverRequestIfBusy";
                }
                case 17: {
                    return "HealthCheckFrequencySeconds";
                }
                case 9: {
                    return "JDBCSystemResource";
                }
                case 2: {
                    return "Name";
                }
                case 11: {
                    return "PoolList";
                }
                case 7: {
                    return "Targets";
                }
                case 13: {
                    return "HighAvail";
                }
                case 12: {
                    return "LoadBalance";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("ACLName")) {
                return 10;
            }
            if (string.equals("AlgorithmType")) {
                return 14;
            }
            if (string.equals("ConnectionPoolFailoverCallbackHandler")) {
                return 15;
            }
            if (string.equals("FailoverRequestIfBusy")) {
                return 16;
            }
            if (string.equals("HealthCheckFrequencySeconds")) {
                return 17;
            }
            if (string.equals("JDBCSystemResource")) {
                return 9;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("PoolList")) {
                return 11;
            }
            if (string.equals("Targets")) {
                return 7;
            }
            if (string.equals("HighAvail")) {
                return 13;
            }
            if (string.equals("LoadBalance")) {
                return 12;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isACLNameSet()) {
                    stringBuffer.append("ACLName");
                    stringBuffer.append(String.valueOf(this.bean.getACLName()));
                }
                if (this.bean.isAlgorithmTypeSet()) {
                    stringBuffer.append("AlgorithmType");
                    stringBuffer.append(String.valueOf(this.bean.getAlgorithmType()));
                }
                if (this.bean.isConnectionPoolFailoverCallbackHandlerSet()) {
                    stringBuffer.append("ConnectionPoolFailoverCallbackHandler");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionPoolFailoverCallbackHandler()));
                }
                if (this.bean.isFailoverRequestIfBusySet()) {
                    stringBuffer.append("FailoverRequestIfBusy");
                    stringBuffer.append(String.valueOf(this.bean.getFailoverRequestIfBusy()));
                }
                if (this.bean.isHealthCheckFrequencySecondsSet()) {
                    stringBuffer.append("HealthCheckFrequencySeconds");
                    stringBuffer.append(String.valueOf(this.bean.getHealthCheckFrequencySeconds()));
                }
                if (this.bean.isJDBCSystemResourceSet()) {
                    stringBuffer.append("JDBCSystemResource");
                    stringBuffer.append(String.valueOf(this.bean.getJDBCSystemResource()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isPoolListSet()) {
                    stringBuffer.append("PoolList");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getPoolList())));
                }
                if (this.bean.isTargetsSet()) {
                    stringBuffer.append("Targets");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getTargets())));
                }
                if (this.bean.isHighAvailSet()) {
                    stringBuffer.append("HighAvail");
                    stringBuffer.append(String.valueOf(this.bean.isHighAvail()));
                }
                if (this.bean.isLoadBalanceSet()) {
                    stringBuffer.append("LoadBalance");
                    stringBuffer.append(String.valueOf(this.bean.isLoadBalance()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                JDBCMultiPoolMBeanImpl jDBCMultiPoolMBeanImpl = (JDBCMultiPoolMBeanImpl)abstractDescriptorBean;
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ACLName", this.bean.getACLName(), jDBCMultiPoolMBeanImpl.getACLName(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("AlgorithmType", this.bean.getAlgorithmType(), jDBCMultiPoolMBeanImpl.getAlgorithmType(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ConnectionPoolFailoverCallbackHandler", this.bean.getConnectionPoolFailoverCallbackHandler(), jDBCMultiPoolMBeanImpl.getConnectionPoolFailoverCallbackHandler(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("FailoverRequestIfBusy", this.bean.getFailoverRequestIfBusy(), jDBCMultiPoolMBeanImpl.getFailoverRequestIfBusy(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("HealthCheckFrequencySeconds", this.bean.getHealthCheckFrequencySeconds(), jDBCMultiPoolMBeanImpl.getHealthCheckFrequencySeconds(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("JDBCSystemResource", this.bean.getJDBCSystemResource(), jDBCMultiPoolMBeanImpl.getJDBCSystemResource(), false);
                }
                this.computeDiff("Name", this.bean.getName(), jDBCMultiPoolMBeanImpl.getName(), false);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("PoolList", this.bean.getPoolList(), jDBCMultiPoolMBeanImpl.getPoolList(), false);
                }
                this.computeDiff("Targets", this.bean.getTargets(), jDBCMultiPoolMBeanImpl.getTargets(), true);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("HighAvail", this.bean.isHighAvail(), jDBCMultiPoolMBeanImpl.isHighAvail(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LoadBalance", this.bean.isLoadBalance(), jDBCMultiPoolMBeanImpl.isLoadBalance(), false);
                }
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                JDBCMultiPoolMBeanImpl jDBCMultiPoolMBeanImpl = (JDBCMultiPoolMBeanImpl)beanUpdateEvent.getSourceBean();
                JDBCMultiPoolMBeanImpl jDBCMultiPoolMBeanImpl2 = (JDBCMultiPoolMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("ACLName")) {
                    jDBCMultiPoolMBeanImpl.setACLName(jDBCMultiPoolMBeanImpl2.getACLName());
                    jDBCMultiPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("AlgorithmType")) {
                    jDBCMultiPoolMBeanImpl.setAlgorithmType(jDBCMultiPoolMBeanImpl2.getAlgorithmType());
                    jDBCMultiPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("ConnectionPoolFailoverCallbackHandler")) {
                    jDBCMultiPoolMBeanImpl.setConnectionPoolFailoverCallbackHandler(jDBCMultiPoolMBeanImpl2.getConnectionPoolFailoverCallbackHandler());
                    jDBCMultiPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("FailoverRequestIfBusy")) {
                    jDBCMultiPoolMBeanImpl.setFailoverRequestIfBusy(jDBCMultiPoolMBeanImpl2.getFailoverRequestIfBusy());
                    jDBCMultiPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else if (string.equals("HealthCheckFrequencySeconds")) {
                    jDBCMultiPoolMBeanImpl.setHealthCheckFrequencySeconds(jDBCMultiPoolMBeanImpl2.getHealthCheckFrequencySeconds());
                    jDBCMultiPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else if (string.equals("JDBCSystemResource")) {
                    jDBCMultiPoolMBeanImpl.setJDBCSystemResourceAsString(jDBCMultiPoolMBeanImpl2.getJDBCSystemResourceAsString());
                    jDBCMultiPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("Name")) {
                    jDBCMultiPoolMBeanImpl.setName(jDBCMultiPoolMBeanImpl2.getName());
                    jDBCMultiPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (string.equals("PoolList")) {
                    jDBCMultiPoolMBeanImpl.setPoolListAsString(jDBCMultiPoolMBeanImpl2.getPoolListAsString());
                    jDBCMultiPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("Targets")) {
                    jDBCMultiPoolMBeanImpl.setTargetsAsString(jDBCMultiPoolMBeanImpl2.getTargetsAsString());
                    jDBCMultiPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("HighAvail")) {
                    jDBCMultiPoolMBeanImpl.setHighAvail(jDBCMultiPoolMBeanImpl2.isHighAvail());
                    jDBCMultiPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("LoadBalance")) {
                    jDBCMultiPoolMBeanImpl.setLoadBalance(jDBCMultiPoolMBeanImpl2.isLoadBalance());
                    jDBCMultiPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                JDBCMultiPoolMBeanImpl jDBCMultiPoolMBeanImpl = (JDBCMultiPoolMBeanImpl)abstractDescriptorBean;
                super.finishCopy(jDBCMultiPoolMBeanImpl, bl, list);
                if (bl && (list == null || !list.contains("ACLName")) && this.bean.isACLNameSet()) {
                    jDBCMultiPoolMBeanImpl.setACLName(this.bean.getACLName());
                }
                if (bl && (list == null || !list.contains("AlgorithmType")) && this.bean.isAlgorithmTypeSet()) {
                    jDBCMultiPoolMBeanImpl.setAlgorithmType(this.bean.getAlgorithmType());
                }
                if (bl && (list == null || !list.contains("ConnectionPoolFailoverCallbackHandler")) && this.bean.isConnectionPoolFailoverCallbackHandlerSet()) {
                    jDBCMultiPoolMBeanImpl.setConnectionPoolFailoverCallbackHandler(this.bean.getConnectionPoolFailoverCallbackHandler());
                }
                if (bl && (list == null || !list.contains("FailoverRequestIfBusy")) && this.bean.isFailoverRequestIfBusySet()) {
                    jDBCMultiPoolMBeanImpl.setFailoverRequestIfBusy(this.bean.getFailoverRequestIfBusy());
                }
                if (bl && (list == null || !list.contains("HealthCheckFrequencySeconds")) && this.bean.isHealthCheckFrequencySecondsSet()) {
                    jDBCMultiPoolMBeanImpl.setHealthCheckFrequencySeconds(this.bean.getHealthCheckFrequencySeconds());
                }
                if (bl && (list == null || !list.contains("JDBCSystemResource")) && this.bean.isJDBCSystemResourceSet()) {
                    jDBCMultiPoolMBeanImpl._unSet(jDBCMultiPoolMBeanImpl, 9);
                    jDBCMultiPoolMBeanImpl.setJDBCSystemResourceAsString(this.bean.getJDBCSystemResourceAsString());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    jDBCMultiPoolMBeanImpl.setName(this.bean.getName());
                }
                if (bl && (list == null || !list.contains("PoolList")) && this.bean.isPoolListSet()) {
                    jDBCMultiPoolMBeanImpl._unSet(jDBCMultiPoolMBeanImpl, 11);
                    jDBCMultiPoolMBeanImpl.setPoolListAsString(this.bean.getPoolListAsString());
                }
                if ((list == null || !list.contains("Targets")) && this.bean.isTargetsSet()) {
                    jDBCMultiPoolMBeanImpl._unSet(jDBCMultiPoolMBeanImpl, 7);
                    jDBCMultiPoolMBeanImpl.setTargetsAsString(this.bean.getTargetsAsString());
                }
                if (bl && (list == null || !list.contains("HighAvail")) && this.bean.isHighAvailSet()) {
                    jDBCMultiPoolMBeanImpl.setHighAvail(this.bean.isHighAvail());
                }
                if (bl && (list == null || !list.contains("LoadBalance")) && this.bean.isLoadBalanceSet()) {
                    jDBCMultiPoolMBeanImpl.setLoadBalance(this.bean.isLoadBalance());
                }
                return jDBCMultiPoolMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getJDBCSystemResource(), clazz, object);
            this.inferSubTree(this.bean.getPoolList(), clazz, object);
            this.inferSubTree(this.bean.getTargets(), clazz, object);
        }
    }
}

