/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ComponentMBeanImpl;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.JDBCPoolComponentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.TargetMBeanImpl;
import weblogic.management.mbeans.custom.JDBCPoolComponent;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class JDBCPoolComponentMBeanImpl
extends ComponentMBeanImpl
implements JDBCPoolComponentMBean,
Serializable {
    private TargetMBean[] _ActivatedTargets;
    private ApplicationMBean _Application;
    private int _CacheSize;
    private int _CapacityIncrement;
    private boolean _CheckOnCreateEnabled;
    private boolean _CheckOnReleaseEnabled;
    private boolean _CheckOnReserveEnabled;
    private int _ConnectionCreationRetryFrequencySeconds;
    private int _ConnectionReserveTimeoutSeconds;
    private int _HighestNumUnavailable;
    private int _HighestNumWaiters;
    private int _InactiveConnectionTimeoutSeconds;
    private int _InitialCapacity;
    private boolean _LoggingEnabled;
    private int _MaxCapacity;
    private int _MaxIdleTime;
    private String _Name;
    private boolean _ProfilingEnabled;
    private int _ShrinkFrequencySeconds;
    private boolean _ShrinkingEnabled;
    private TargetMBean[] _Targets;
    private int _TestFrequencySeconds;
    private JDBCPoolComponent _customizer;
    private static SchemaHelper2 _schemaHelper;

    public JDBCPoolComponentMBeanImpl() {
        try {
            this._customizer = new JDBCPoolComponent(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public JDBCPoolComponentMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new JDBCPoolComponent(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public ApplicationMBean getApplication() {
        return this._customizer.getApplication();
    }

    public int getInitialCapacity() throws ManagementException {
        return this._InitialCapacity;
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public TargetMBean[] getTargets() {
        return this._customizer.getTargets();
    }

    public String getTargetsAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getTargets());
    }

    public boolean isApplicationSet() {
        return this._isSet(9);
    }

    public boolean isInitialCapacitySet() {
        return this._isSet(12);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isTargetsSet() {
        return this._isSet(7);
    }

    public void setTargetsAsString(String string) {
        if (string == null || string.length() == 0) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._initializeProperty(7);
            this._postSet(7, targetMBeanArray, this._Targets);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._Targets);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, TargetMBean.class, new ReferenceManager.Resolver(this, 7){

                    public void resolveReference(Object object) {
                        try {
                            JDBCPoolComponentMBeanImpl.this.addTarget((TargetMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (TargetMBean targetMBean : this._Targets) {
                    if (!string2.equals(targetMBean.getName())) continue;
                    try {
                        this.removeTarget(targetMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void setApplication(ApplicationMBean applicationMBean) throws InvalidAttributeValueException {
        this._customizer.setApplication(applicationMBean);
    }

    public void setInitialCapacity(int n) throws ManagementException {
        LegalChecks.checkInRange((String)"InitialCapacity", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        this._InitialCapacity = n;
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setTargets(TargetMBean[] targetMBeanArray) throws InvalidAttributeValueException, DistributedManagementException {
        targetMBeanArray = targetMBeanArray == null ? new TargetMBeanImpl[]{} : targetMBeanArray;
        targetMBeanArray = (TargetMBean[])this._getHelper()._cleanAndValidateArray((Object)targetMBeanArray, TargetMBean.class);
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            if (targetMBeanArray[i] == null) continue;
            ResolvedReference resolvedReference = new ResolvedReference(this, 7, (AbstractDescriptorBean)targetMBeanArray[i]){

                protected Object getPropertyValue() {
                    return JDBCPoolComponentMBeanImpl.this.getTargets();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)targetMBeanArray[i], resolvedReference);
        }
        TargetMBean[] targetMBeanArray2 = this.getTargets();
        this._customizer.setTargets(targetMBeanArray);
        this._postSet(7, targetMBeanArray2, targetMBeanArray);
    }

    public boolean addTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        this._getHelper()._ensureNonNull((Object)targetMBean);
        if (!((AbstractDescriptorBean)targetMBean).isChildProperty((DescriptorBean)this, 7)) {
            TargetMBean[] targetMBeanArray = (TargetMBean[])this._getHelper()._extendArray((Object)this.getTargets(), TargetMBean.class, (Object)targetMBean);
            try {
                this.setTargets(targetMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public int getMaxCapacity() throws ManagementException {
        return this._MaxCapacity;
    }

    public boolean isMaxCapacitySet() {
        return this._isSet(13);
    }

    public boolean removeTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        TargetMBean[] targetMBeanArray = this.getTargets();
        TargetMBean[] targetMBeanArray2 = (TargetMBean[])this._getHelper()._removeElement((Object)targetMBeanArray, TargetMBean.class, (Object)targetMBean);
        if (targetMBeanArray2.length != targetMBeanArray.length) {
            try {
                this.setTargets(targetMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public void setMaxCapacity(int n) throws ManagementException {
        LegalChecks.checkInRange((String)"MaxCapacity", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        this._MaxCapacity = n;
    }

    public TargetMBean[] getActivatedTargets() {
        return this._customizer.getActivatedTargets();
    }

    public int getCapacityIncrement() throws ManagementException {
        return this._CapacityIncrement;
    }

    public boolean isActivatedTargetsSet() {
        return this._isSet(11);
    }

    public boolean isCapacityIncrementSet() {
        return this._isSet(14);
    }

    public void addActivatedTarget(TargetMBean targetMBean) {
        this._getHelper()._ensureNonNull((Object)targetMBean);
        if (!((AbstractDescriptorBean)targetMBean).isChildProperty((DescriptorBean)this, 11)) {
            TargetMBean[] targetMBeanArray = (TargetMBean[])this._getHelper()._extendArray((Object)this.getActivatedTargets(), TargetMBean.class, (Object)targetMBean);
            try {
                this.setActivatedTargets(targetMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void setCapacityIncrement(int n) throws ManagementException {
        LegalChecks.checkInRange((String)"CapacityIncrement", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        this._CapacityIncrement = n;
    }

    public int getHighestNumWaiters() throws ManagementException {
        return this._HighestNumWaiters;
    }

    public boolean isHighestNumWaitersSet() {
        return this._isSet(15);
    }

    public void removeActivatedTarget(TargetMBean targetMBean) {
        TargetMBean[] targetMBeanArray = this.getActivatedTargets();
        TargetMBean[] targetMBeanArray2 = (TargetMBean[])this._getHelper()._removeElement((Object)targetMBeanArray, TargetMBean.class, (Object)targetMBean);
        if (targetMBeanArray2.length != targetMBeanArray.length) {
            try {
                this.setActivatedTargets(targetMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void setActivatedTargets(TargetMBean[] targetMBeanArray) {
        targetMBeanArray = targetMBeanArray == null ? new TargetMBeanImpl[]{} : targetMBeanArray;
        this._ActivatedTargets = targetMBeanArray;
    }

    public void setHighestNumWaiters(int n) throws ManagementException {
        LegalChecks.checkInRange((String)"HighestNumWaiters", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        this._HighestNumWaiters = n;
    }

    public boolean activated(TargetMBean targetMBean) {
        return this._customizer.activated(targetMBean);
    }

    public int getHighestNumUnavailable() throws ManagementException {
        return this._HighestNumUnavailable;
    }

    public boolean isHighestNumUnavailableSet() {
        return this._isSet(16);
    }

    public void refreshDDsIfNeeded(String[] stringArray) {
        this._customizer.refreshDDsIfNeeded(stringArray);
    }

    public void setHighestNumUnavailable(int n) throws ManagementException {
        LegalChecks.checkInRange((String)"HighestNumUnavailable", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        this._HighestNumUnavailable = n;
    }

    public int getInactiveConnectionTimeoutSeconds() throws ManagementException {
        return this._InactiveConnectionTimeoutSeconds;
    }

    public boolean isInactiveConnectionTimeoutSecondsSet() {
        return this._isSet(17);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void setInactiveConnectionTimeoutSeconds(int n) throws ManagementException {
        LegalChecks.checkInRange((String)"InactiveConnectionTimeoutSeconds", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        this._InactiveConnectionTimeoutSeconds = n;
    }

    public int getConnectionCreationRetryFrequencySeconds() throws ManagementException {
        return this._ConnectionCreationRetryFrequencySeconds;
    }

    public boolean isConnectionCreationRetryFrequencySecondsSet() {
        return this._isSet(18);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setConnectionCreationRetryFrequencySeconds(int n) throws ManagementException {
        LegalChecks.checkInRange((String)"ConnectionCreationRetryFrequencySeconds", (long)n, (long)600L, (long)Integer.MAX_VALUE);
        this._ConnectionCreationRetryFrequencySeconds = n;
    }

    public int getConnectionReserveTimeoutSeconds() throws ManagementException {
        return this._ConnectionReserveTimeoutSeconds;
    }

    public boolean isConnectionReserveTimeoutSecondsSet() {
        return this._isSet(19);
    }

    public void setConnectionReserveTimeoutSeconds(int n) throws ManagementException {
        LegalChecks.checkInRange((String)"ConnectionReserveTimeoutSeconds", (long)n, (long)-1L, (long)Integer.MAX_VALUE);
        this._ConnectionReserveTimeoutSeconds = n;
    }

    public int getShrinkFrequencySeconds() throws ManagementException {
        return this._ShrinkFrequencySeconds;
    }

    public boolean isShrinkFrequencySecondsSet() {
        return this._isSet(20);
    }

    public void setShrinkFrequencySeconds(int n) throws ManagementException {
        LegalChecks.checkInRange((String)"ShrinkFrequencySeconds", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        this._ShrinkFrequencySeconds = n;
    }

    public int getTestFrequencySeconds() throws ManagementException {
        return this._TestFrequencySeconds;
    }

    public boolean isTestFrequencySecondsSet() {
        return this._isSet(21);
    }

    public void setTestFrequencySeconds(int n) throws ManagementException {
        LegalChecks.checkInRange((String)"TestFrequencySeconds", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        this._TestFrequencySeconds = n;
    }

    public int getCacheSize() throws ManagementException {
        return this._CacheSize;
    }

    public boolean isCacheSizeSet() {
        return this._isSet(22);
    }

    public void setCacheSize(int n) throws ManagementException {
        LegalChecks.checkInRange((String)"CacheSize", (long)n, (long)0L, (long)1024L);
        this._CacheSize = n;
    }

    public boolean isShrinkingEnabled() throws ManagementException {
        return this._ShrinkingEnabled;
    }

    public boolean isShrinkingEnabledSet() {
        return this._isSet(23);
    }

    public void setShrinkingEnabled(boolean bl) throws ManagementException {
        this._ShrinkingEnabled = bl;
    }

    public boolean isCheckOnReserveEnabled() throws ManagementException {
        return this._CheckOnReserveEnabled;
    }

    public boolean isCheckOnReserveEnabledSet() {
        return this._isSet(24);
    }

    public void setCheckOnReserveEnabled(boolean bl) throws ManagementException {
        this._CheckOnReserveEnabled = bl;
    }

    public boolean isCheckOnReleaseEnabled() throws ManagementException {
        return this._CheckOnReleaseEnabled;
    }

    public boolean isCheckOnReleaseEnabledSet() {
        return this._isSet(25);
    }

    public void setCheckOnReleaseEnabled(boolean bl) throws ManagementException {
        this._CheckOnReleaseEnabled = bl;
    }

    public boolean isCheckOnCreateEnabled() throws ManagementException {
        return this._CheckOnCreateEnabled;
    }

    public boolean isCheckOnCreateEnabledSet() {
        return this._isSet(26);
    }

    public void setCheckOnCreateEnabled(boolean bl) throws ManagementException {
        this._CheckOnCreateEnabled = bl;
    }

    public int getMaxIdleTime() throws ManagementException {
        return this._MaxIdleTime;
    }

    public boolean isMaxIdleTimeSet() {
        return this._isSet(27);
    }

    public void setMaxIdleTime(int n) throws ManagementException {
        this._MaxIdleTime = n;
    }

    public boolean isProfilingEnabled() throws ManagementException {
        return this._ProfilingEnabled;
    }

    public boolean isProfilingEnabledSet() {
        return this._isSet(28);
    }

    public void setProfilingEnabled(boolean bl) throws ManagementException {
        this._ProfilingEnabled = bl;
    }

    public boolean isLoggingEnabled() throws ManagementException {
        return this._LoggingEnabled;
    }

    public boolean isLoggingEnabledSet() {
        return this._isSet(29);
    }

    public void setLoggingEnabled(boolean bl) throws ManagementException {
        this._LoggingEnabled = bl;
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 11;
        }
        try {
            switch (n) {
                case 11: {
                    this._ActivatedTargets = new TargetMBean[0];
                    if (bl) break;
                }
                case 9: {
                    this._customizer.setApplication(null);
                    if (bl) break;
                }
                case 22: {
                    this._CacheSize = 10;
                    if (bl) break;
                }
                case 14: {
                    this._CapacityIncrement = 1;
                    if (bl) break;
                }
                case 18: {
                    this._ConnectionCreationRetryFrequencySeconds = 3600;
                    if (bl) break;
                }
                case 19: {
                    this._ConnectionReserveTimeoutSeconds = 10;
                    if (bl) break;
                }
                case 16: {
                    this._HighestNumUnavailable = 0;
                    if (bl) break;
                }
                case 15: {
                    this._HighestNumWaiters = Integer.MAX_VALUE;
                    if (bl) break;
                }
                case 17: {
                    this._InactiveConnectionTimeoutSeconds = 0;
                    if (bl) break;
                }
                case 12: {
                    this._InitialCapacity = 1;
                    if (bl) break;
                }
                case 13: {
                    this._MaxCapacity = 15;
                    if (bl) break;
                }
                case 27: {
                    this._MaxIdleTime = -1;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 20: {
                    this._ShrinkFrequencySeconds = 900;
                    if (bl) break;
                }
                case 7: {
                    this._customizer.setTargets(new TargetMBean[0]);
                    if (bl) break;
                }
                case 21: {
                    this._TestFrequencySeconds = 0;
                    if (bl) break;
                }
                case 26: {
                    this._CheckOnCreateEnabled = false;
                    if (bl) break;
                }
                case 25: {
                    this._CheckOnReleaseEnabled = false;
                    if (bl) break;
                }
                case 24: {
                    this._CheckOnReserveEnabled = false;
                    if (bl) break;
                }
                case 29: {
                    this._LoggingEnabled = false;
                    if (bl) break;
                }
                case 28: {
                    this._ProfilingEnabled = false;
                    if (bl) break;
                }
                case 23: {
                    this._ShrinkingEnabled = true;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "JDBCPoolComponent";
    }

    public void putValue(String string, Object object) {
        if (string.equals("ActivatedTargets")) {
            TargetMBean[] targetMBeanArray = this._ActivatedTargets;
            this._ActivatedTargets = (TargetMBean[])object;
            this._postSet(11, targetMBeanArray, this._ActivatedTargets);
            return;
        }
        if (string.equals("Application")) {
            ApplicationMBean applicationMBean = this._Application;
            this._Application = (ApplicationMBean)object;
            this._postSet(9, applicationMBean, this._Application);
            return;
        }
        if (string.equals("CacheSize")) {
            int n = this._CacheSize;
            this._CacheSize = (Integer)object;
            this._postSet(22, n, this._CacheSize);
            return;
        }
        if (string.equals("CapacityIncrement")) {
            int n = this._CapacityIncrement;
            this._CapacityIncrement = (Integer)object;
            this._postSet(14, n, this._CapacityIncrement);
            return;
        }
        if (string.equals("CheckOnCreateEnabled")) {
            boolean bl = this._CheckOnCreateEnabled;
            this._CheckOnCreateEnabled = (Boolean)object;
            this._postSet(26, bl, this._CheckOnCreateEnabled);
            return;
        }
        if (string.equals("CheckOnReleaseEnabled")) {
            boolean bl = this._CheckOnReleaseEnabled;
            this._CheckOnReleaseEnabled = (Boolean)object;
            this._postSet(25, bl, this._CheckOnReleaseEnabled);
            return;
        }
        if (string.equals("CheckOnReserveEnabled")) {
            boolean bl = this._CheckOnReserveEnabled;
            this._CheckOnReserveEnabled = (Boolean)object;
            this._postSet(24, bl, this._CheckOnReserveEnabled);
            return;
        }
        if (string.equals("ConnectionCreationRetryFrequencySeconds")) {
            int n = this._ConnectionCreationRetryFrequencySeconds;
            this._ConnectionCreationRetryFrequencySeconds = (Integer)object;
            this._postSet(18, n, this._ConnectionCreationRetryFrequencySeconds);
            return;
        }
        if (string.equals("ConnectionReserveTimeoutSeconds")) {
            int n = this._ConnectionReserveTimeoutSeconds;
            this._ConnectionReserveTimeoutSeconds = (Integer)object;
            this._postSet(19, n, this._ConnectionReserveTimeoutSeconds);
            return;
        }
        if (string.equals("HighestNumUnavailable")) {
            int n = this._HighestNumUnavailable;
            this._HighestNumUnavailable = (Integer)object;
            this._postSet(16, n, this._HighestNumUnavailable);
            return;
        }
        if (string.equals("HighestNumWaiters")) {
            int n = this._HighestNumWaiters;
            this._HighestNumWaiters = (Integer)object;
            this._postSet(15, n, this._HighestNumWaiters);
            return;
        }
        if (string.equals("InactiveConnectionTimeoutSeconds")) {
            int n = this._InactiveConnectionTimeoutSeconds;
            this._InactiveConnectionTimeoutSeconds = (Integer)object;
            this._postSet(17, n, this._InactiveConnectionTimeoutSeconds);
            return;
        }
        if (string.equals("InitialCapacity")) {
            int n = this._InitialCapacity;
            this._InitialCapacity = (Integer)object;
            this._postSet(12, n, this._InitialCapacity);
            return;
        }
        if (string.equals("LoggingEnabled")) {
            boolean bl = this._LoggingEnabled;
            this._LoggingEnabled = (Boolean)object;
            this._postSet(29, bl, this._LoggingEnabled);
            return;
        }
        if (string.equals("MaxCapacity")) {
            int n = this._MaxCapacity;
            this._MaxCapacity = (Integer)object;
            this._postSet(13, n, this._MaxCapacity);
            return;
        }
        if (string.equals("MaxIdleTime")) {
            int n = this._MaxIdleTime;
            this._MaxIdleTime = (Integer)object;
            this._postSet(27, n, this._MaxIdleTime);
            return;
        }
        if (string.equals("Name")) {
            String string2 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string2, this._Name);
            return;
        }
        if (string.equals("ProfilingEnabled")) {
            boolean bl = this._ProfilingEnabled;
            this._ProfilingEnabled = (Boolean)object;
            this._postSet(28, bl, this._ProfilingEnabled);
            return;
        }
        if (string.equals("ShrinkFrequencySeconds")) {
            int n = this._ShrinkFrequencySeconds;
            this._ShrinkFrequencySeconds = (Integer)object;
            this._postSet(20, n, this._ShrinkFrequencySeconds);
            return;
        }
        if (string.equals("ShrinkingEnabled")) {
            boolean bl = this._ShrinkingEnabled;
            this._ShrinkingEnabled = (Boolean)object;
            this._postSet(23, bl, this._ShrinkingEnabled);
            return;
        }
        if (string.equals("Targets")) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._Targets = (TargetMBean[])object;
            this._postSet(7, targetMBeanArray, this._Targets);
            return;
        }
        if (string.equals("TestFrequencySeconds")) {
            int n = this._TestFrequencySeconds;
            this._TestFrequencySeconds = (Integer)object;
            this._postSet(21, n, this._TestFrequencySeconds);
            return;
        }
        if (string.equals("customizer")) {
            JDBCPoolComponent jDBCPoolComponent = this._customizer;
            this._customizer = (JDBCPoolComponent)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("ActivatedTargets")) {
            return this._ActivatedTargets;
        }
        if (string.equals("Application")) {
            return this._Application;
        }
        if (string.equals("CacheSize")) {
            return new Integer(this._CacheSize);
        }
        if (string.equals("CapacityIncrement")) {
            return new Integer(this._CapacityIncrement);
        }
        if (string.equals("CheckOnCreateEnabled")) {
            return new Boolean(this._CheckOnCreateEnabled);
        }
        if (string.equals("CheckOnReleaseEnabled")) {
            return new Boolean(this._CheckOnReleaseEnabled);
        }
        if (string.equals("CheckOnReserveEnabled")) {
            return new Boolean(this._CheckOnReserveEnabled);
        }
        if (string.equals("ConnectionCreationRetryFrequencySeconds")) {
            return new Integer(this._ConnectionCreationRetryFrequencySeconds);
        }
        if (string.equals("ConnectionReserveTimeoutSeconds")) {
            return new Integer(this._ConnectionReserveTimeoutSeconds);
        }
        if (string.equals("HighestNumUnavailable")) {
            return new Integer(this._HighestNumUnavailable);
        }
        if (string.equals("HighestNumWaiters")) {
            return new Integer(this._HighestNumWaiters);
        }
        if (string.equals("InactiveConnectionTimeoutSeconds")) {
            return new Integer(this._InactiveConnectionTimeoutSeconds);
        }
        if (string.equals("InitialCapacity")) {
            return new Integer(this._InitialCapacity);
        }
        if (string.equals("LoggingEnabled")) {
            return new Boolean(this._LoggingEnabled);
        }
        if (string.equals("MaxCapacity")) {
            return new Integer(this._MaxCapacity);
        }
        if (string.equals("MaxIdleTime")) {
            return new Integer(this._MaxIdleTime);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("ProfilingEnabled")) {
            return new Boolean(this._ProfilingEnabled);
        }
        if (string.equals("ShrinkFrequencySeconds")) {
            return new Integer(this._ShrinkFrequencySeconds);
        }
        if (string.equals("ShrinkingEnabled")) {
            return new Boolean(this._ShrinkingEnabled);
        }
        if (string.equals("Targets")) {
            return this._Targets;
        }
        if (string.equals("TestFrequencySeconds")) {
            return new Integer(this._TestFrequencySeconds);
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ComponentMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 16: {
                    if (string.equals("activated-target")) {
                        return 11;
                    }
                    if (!string.equals("initial-capacity")) break;
                    return 12;
                }
                case 11: {
                    if (!string.equals("application")) break;
                    return 9;
                }
                case 10: {
                    if (!string.equals("cache-size")) break;
                    return 22;
                }
                case 18: {
                    if (!string.equals("capacity-increment")) break;
                    return 14;
                }
                case 43: {
                    if (!string.equals("connection-creation-retry-frequency-seconds")) break;
                    return 18;
                }
                case 34: {
                    if (!string.equals("connection-reserve-timeout-seconds")) break;
                    return 19;
                }
                case 23: {
                    if (string.equals("highest-num-unavailable")) {
                        return 16;
                    }
                    if (!string.equals("check-on-create-enabled")) break;
                    return 26;
                }
                case 19: {
                    if (!string.equals("highest-num-waiters")) break;
                    return 15;
                }
                case 35: {
                    if (!string.equals("inactive-connection-timeout-seconds")) break;
                    return 17;
                }
                case 12: {
                    if (!string.equals("max-capacity")) break;
                    return 13;
                }
                case 13: {
                    if (!string.equals("max-idle-time")) break;
                    return 27;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 24: {
                    if (string.equals("shrink-frequency-seconds")) {
                        return 20;
                    }
                    if (string.equals("check-on-release-enabled")) {
                        return 25;
                    }
                    if (!string.equals("check-on-reserve-enabled")) break;
                    return 24;
                }
                case 6: {
                    if (!string.equals("target")) break;
                    return 7;
                }
                case 22: {
                    if (!string.equals("test-frequency-seconds")) break;
                    return 21;
                }
                case 15: {
                    if (!string.equals("logging-enabled")) break;
                    return 29;
                }
                case 17: {
                    if (string.equals("profiling-enabled")) {
                        return 28;
                    }
                    if (!string.equals("shrinking-enabled")) break;
                    return 23;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 11: {
                    return "activated-target";
                }
                case 9: {
                    return "application";
                }
                case 22: {
                    return "cache-size";
                }
                case 14: {
                    return "capacity-increment";
                }
                case 18: {
                    return "connection-creation-retry-frequency-seconds";
                }
                case 19: {
                    return "connection-reserve-timeout-seconds";
                }
                case 16: {
                    return "highest-num-unavailable";
                }
                case 15: {
                    return "highest-num-waiters";
                }
                case 17: {
                    return "inactive-connection-timeout-seconds";
                }
                case 12: {
                    return "initial-capacity";
                }
                case 13: {
                    return "max-capacity";
                }
                case 27: {
                    return "max-idle-time";
                }
                case 2: {
                    return "name";
                }
                case 20: {
                    return "shrink-frequency-seconds";
                }
                case 7: {
                    return "target";
                }
                case 21: {
                    return "test-frequency-seconds";
                }
                case 26: {
                    return "check-on-create-enabled";
                }
                case 25: {
                    return "check-on-release-enabled";
                }
                case 24: {
                    return "check-on-reserve-enabled";
                }
                case 29: {
                    return "logging-enabled";
                }
                case 28: {
                    return "profiling-enabled";
                }
                case 23: {
                    return "shrinking-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 11: {
                    return true;
                }
                case 7: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ComponentMBeanImpl.Helper {
        private JDBCPoolComponentMBeanImpl bean;

        protected Helper(JDBCPoolComponentMBeanImpl jDBCPoolComponentMBeanImpl) {
            super(jDBCPoolComponentMBeanImpl);
            this.bean = jDBCPoolComponentMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 11: {
                    return "ActivatedTargets";
                }
                case 9: {
                    return "Application";
                }
                case 22: {
                    return "CacheSize";
                }
                case 14: {
                    return "CapacityIncrement";
                }
                case 18: {
                    return "ConnectionCreationRetryFrequencySeconds";
                }
                case 19: {
                    return "ConnectionReserveTimeoutSeconds";
                }
                case 16: {
                    return "HighestNumUnavailable";
                }
                case 15: {
                    return "HighestNumWaiters";
                }
                case 17: {
                    return "InactiveConnectionTimeoutSeconds";
                }
                case 12: {
                    return "InitialCapacity";
                }
                case 13: {
                    return "MaxCapacity";
                }
                case 27: {
                    return "MaxIdleTime";
                }
                case 2: {
                    return "Name";
                }
                case 20: {
                    return "ShrinkFrequencySeconds";
                }
                case 7: {
                    return "Targets";
                }
                case 21: {
                    return "TestFrequencySeconds";
                }
                case 26: {
                    return "CheckOnCreateEnabled";
                }
                case 25: {
                    return "CheckOnReleaseEnabled";
                }
                case 24: {
                    return "CheckOnReserveEnabled";
                }
                case 29: {
                    return "LoggingEnabled";
                }
                case 28: {
                    return "ProfilingEnabled";
                }
                case 23: {
                    return "ShrinkingEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("ActivatedTargets")) {
                return 11;
            }
            if (string.equals("Application")) {
                return 9;
            }
            if (string.equals("CacheSize")) {
                return 22;
            }
            if (string.equals("CapacityIncrement")) {
                return 14;
            }
            if (string.equals("ConnectionCreationRetryFrequencySeconds")) {
                return 18;
            }
            if (string.equals("ConnectionReserveTimeoutSeconds")) {
                return 19;
            }
            if (string.equals("HighestNumUnavailable")) {
                return 16;
            }
            if (string.equals("HighestNumWaiters")) {
                return 15;
            }
            if (string.equals("InactiveConnectionTimeoutSeconds")) {
                return 17;
            }
            if (string.equals("InitialCapacity")) {
                return 12;
            }
            if (string.equals("MaxCapacity")) {
                return 13;
            }
            if (string.equals("MaxIdleTime")) {
                return 27;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("ShrinkFrequencySeconds")) {
                return 20;
            }
            if (string.equals("Targets")) {
                return 7;
            }
            if (string.equals("TestFrequencySeconds")) {
                return 21;
            }
            if (string.equals("CheckOnCreateEnabled")) {
                return 26;
            }
            if (string.equals("CheckOnReleaseEnabled")) {
                return 25;
            }
            if (string.equals("CheckOnReserveEnabled")) {
                return 24;
            }
            if (string.equals("LoggingEnabled")) {
                return 29;
            }
            if (string.equals("ProfilingEnabled")) {
                return 28;
            }
            if (string.equals("ShrinkingEnabled")) {
                return 23;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isActivatedTargetsSet()) {
                    stringBuffer.append("ActivatedTargets");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getActivatedTargets())));
                }
                if (this.bean.isApplicationSet()) {
                    stringBuffer.append("Application");
                    stringBuffer.append(String.valueOf(this.bean.getApplication()));
                }
                if (this.bean.isCacheSizeSet()) {
                    stringBuffer.append("CacheSize");
                    stringBuffer.append(String.valueOf(this.bean.getCacheSize()));
                }
                if (this.bean.isCapacityIncrementSet()) {
                    stringBuffer.append("CapacityIncrement");
                    stringBuffer.append(String.valueOf(this.bean.getCapacityIncrement()));
                }
                if (this.bean.isConnectionCreationRetryFrequencySecondsSet()) {
                    stringBuffer.append("ConnectionCreationRetryFrequencySeconds");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionCreationRetryFrequencySeconds()));
                }
                if (this.bean.isConnectionReserveTimeoutSecondsSet()) {
                    stringBuffer.append("ConnectionReserveTimeoutSeconds");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionReserveTimeoutSeconds()));
                }
                if (this.bean.isHighestNumUnavailableSet()) {
                    stringBuffer.append("HighestNumUnavailable");
                    stringBuffer.append(String.valueOf(this.bean.getHighestNumUnavailable()));
                }
                if (this.bean.isHighestNumWaitersSet()) {
                    stringBuffer.append("HighestNumWaiters");
                    stringBuffer.append(String.valueOf(this.bean.getHighestNumWaiters()));
                }
                if (this.bean.isInactiveConnectionTimeoutSecondsSet()) {
                    stringBuffer.append("InactiveConnectionTimeoutSeconds");
                    stringBuffer.append(String.valueOf(this.bean.getInactiveConnectionTimeoutSeconds()));
                }
                if (this.bean.isInitialCapacitySet()) {
                    stringBuffer.append("InitialCapacity");
                    stringBuffer.append(String.valueOf(this.bean.getInitialCapacity()));
                }
                if (this.bean.isMaxCapacitySet()) {
                    stringBuffer.append("MaxCapacity");
                    stringBuffer.append(String.valueOf(this.bean.getMaxCapacity()));
                }
                if (this.bean.isMaxIdleTimeSet()) {
                    stringBuffer.append("MaxIdleTime");
                    stringBuffer.append(String.valueOf(this.bean.getMaxIdleTime()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isShrinkFrequencySecondsSet()) {
                    stringBuffer.append("ShrinkFrequencySeconds");
                    stringBuffer.append(String.valueOf(this.bean.getShrinkFrequencySeconds()));
                }
                if (this.bean.isTargetsSet()) {
                    stringBuffer.append("Targets");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getTargets())));
                }
                if (this.bean.isTestFrequencySecondsSet()) {
                    stringBuffer.append("TestFrequencySeconds");
                    stringBuffer.append(String.valueOf(this.bean.getTestFrequencySeconds()));
                }
                if (this.bean.isCheckOnCreateEnabledSet()) {
                    stringBuffer.append("CheckOnCreateEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isCheckOnCreateEnabled()));
                }
                if (this.bean.isCheckOnReleaseEnabledSet()) {
                    stringBuffer.append("CheckOnReleaseEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isCheckOnReleaseEnabled()));
                }
                if (this.bean.isCheckOnReserveEnabledSet()) {
                    stringBuffer.append("CheckOnReserveEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isCheckOnReserveEnabled()));
                }
                if (this.bean.isLoggingEnabledSet()) {
                    stringBuffer.append("LoggingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isLoggingEnabled()));
                }
                if (this.bean.isProfilingEnabledSet()) {
                    stringBuffer.append("ProfilingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isProfilingEnabled()));
                }
                if (this.bean.isShrinkingEnabledSet()) {
                    stringBuffer.append("ShrinkingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isShrinkingEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                JDBCPoolComponentMBeanImpl jDBCPoolComponentMBeanImpl = (JDBCPoolComponentMBeanImpl)abstractDescriptorBean;
                this.computeDiff("Name", this.bean.getName(), jDBCPoolComponentMBeanImpl.getName(), false);
                this.computeDiff("Targets", this.bean.getTargets(), jDBCPoolComponentMBeanImpl.getTargets(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                JDBCPoolComponentMBeanImpl jDBCPoolComponentMBeanImpl = (JDBCPoolComponentMBeanImpl)beanUpdateEvent.getSourceBean();
                JDBCPoolComponentMBeanImpl jDBCPoolComponentMBeanImpl2 = (JDBCPoolComponentMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (!(string.equals("ActivatedTargets") || string.equals("Application") || string.equals("CacheSize") || string.equals("CapacityIncrement") || string.equals("ConnectionCreationRetryFrequencySeconds") || string.equals("ConnectionReserveTimeoutSeconds") || string.equals("HighestNumUnavailable") || string.equals("HighestNumWaiters") || string.equals("InactiveConnectionTimeoutSeconds") || string.equals("InitialCapacity") || string.equals("MaxCapacity") || string.equals("MaxIdleTime"))) {
                    if (string.equals("Name")) {
                        jDBCPoolComponentMBeanImpl.setName(jDBCPoolComponentMBeanImpl2.getName());
                        jDBCPoolComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                    } else if (!string.equals("ShrinkFrequencySeconds")) {
                        if (string.equals("Targets")) {
                            jDBCPoolComponentMBeanImpl.setTargetsAsString(jDBCPoolComponentMBeanImpl2.getTargetsAsString());
                            jDBCPoolComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                        } else if (!(string.equals("TestFrequencySeconds") || string.equals("CheckOnCreateEnabled") || string.equals("CheckOnReleaseEnabled") || string.equals("CheckOnReserveEnabled") || string.equals("LoggingEnabled") || string.equals("ProfilingEnabled") || string.equals("ShrinkingEnabled"))) {
                            super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                JDBCPoolComponentMBeanImpl jDBCPoolComponentMBeanImpl = (JDBCPoolComponentMBeanImpl)abstractDescriptorBean;
                super.finishCopy(jDBCPoolComponentMBeanImpl, bl, list);
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    jDBCPoolComponentMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("Targets")) && this.bean.isTargetsSet()) {
                    jDBCPoolComponentMBeanImpl._unSet((AbstractDescriptorBean)jDBCPoolComponentMBeanImpl, 7);
                    jDBCPoolComponentMBeanImpl.setTargetsAsString(this.bean.getTargetsAsString());
                }
                return jDBCPoolComponentMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getActivatedTargets(), clazz, object);
            this.inferSubTree(this.bean.getApplication(), clazz, object);
            this.inferSubTree(this.bean.getTargets(), clazz, object);
        }
    }
}

