/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.configuration.GenericJDBCStoreMBeanImpl;
import weblogic.management.configuration.JDBCConnectionPoolMBean;
import weblogic.management.configuration.JDBCStoreMBean;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.JMSLegalHelper;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.TargetMBeanImpl;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class JDBCStoreMBeanImpl
extends GenericJDBCStoreMBeanImpl
implements JDBCStoreMBean,
Serializable {
    private JDBCConnectionPoolMBean _ConnectionPool;
    private JDBCSystemResourceMBean _DataSource;
    private int _DeletesPerBatchMaximum;
    private int _DeletesPerStatementMaximum;
    private int _DeploymentOrder;
    private int _InsertsPerBatchMaximum;
    private String _LogicalName;
    private TargetMBean[] _Targets;
    private int _ThreeStepThreshold;
    private int _WorkerCount;
    private int _WorkerPreferredBatchSize;
    private String _XAResourceName;
    private static SchemaHelper2 _schemaHelper;

    public JDBCStoreMBeanImpl() {
        this._initializeProperty(-1);
    }

    public JDBCStoreMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public JDBCSystemResourceMBean getDataSource() {
        return this._DataSource;
    }

    public String getDataSourceAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getDataSource();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public TargetMBean[] getTargets() {
        return this._Targets;
    }

    public String getTargetsAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getTargets());
    }

    public boolean isDataSourceSet() {
        return this._isSet(13);
    }

    public boolean isTargetsSet() {
        return this._isSet(9);
    }

    public void setDataSourceAsString(String string) {
        if (string == null || string.length() == 0) {
            JDBCSystemResourceMBean jDBCSystemResourceMBean = this._DataSource;
            this._initializeProperty(13);
            this._postSet(13, jDBCSystemResourceMBean, this._DataSource);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, JDBCSystemResourceMBean.class, new ReferenceManager.Resolver(this, 13){

                public void resolveReference(Object object) {
                    try {
                        JDBCStoreMBeanImpl.this.setDataSource((JDBCSystemResourceMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setTargetsAsString(String string) {
        if (string == null || string.length() == 0) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._initializeProperty(9);
            this._postSet(9, targetMBeanArray, this._Targets);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._Targets);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, TargetMBean.class, new ReferenceManager.Resolver(this, 9){

                    public void resolveReference(Object object) {
                        try {
                            JDBCStoreMBeanImpl.this.addTarget((TargetMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (TargetMBean targetMBean : this._Targets) {
                    if (!string2.equals(targetMBean.getName())) continue;
                    try {
                        this.removeTarget(targetMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void setDataSource(JDBCSystemResourceMBean jDBCSystemResourceMBean) throws InvalidAttributeValueException {
        JDBCSystemResourceMBean jDBCSystemResourceMBean2;
        if (jDBCSystemResourceMBean != null) {
            jDBCSystemResourceMBean2 = new ResolvedReference(this, 13, (AbstractDescriptorBean)jDBCSystemResourceMBean){

                protected Object getPropertyValue() {
                    return JDBCStoreMBeanImpl.this.getDataSource();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)jDBCSystemResourceMBean, (ResolvedReference)jDBCSystemResourceMBean2);
        }
        jDBCSystemResourceMBean2 = this._DataSource;
        this._DataSource = jDBCSystemResourceMBean;
        this._postSet(13, jDBCSystemResourceMBean2, jDBCSystemResourceMBean);
    }

    public void setTargets(TargetMBean[] targetMBeanArray) throws InvalidAttributeValueException, DistributedManagementException {
        targetMBeanArray = targetMBeanArray == null ? new TargetMBeanImpl[]{} : targetMBeanArray;
        targetMBeanArray = (TargetMBean[])this._getHelper()._cleanAndValidateArray((Object)targetMBeanArray, TargetMBean.class);
        JMSLegalHelper.validateSingleServerTargets(targetMBeanArray);
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            if (targetMBeanArray[i] == null) continue;
            ResolvedReference resolvedReference = new ResolvedReference(this, 9, (AbstractDescriptorBean)targetMBeanArray[i]){

                protected Object getPropertyValue() {
                    return JDBCStoreMBeanImpl.this.getTargets();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)targetMBeanArray[i], resolvedReference);
        }
        TargetMBean[] targetMBeanArray2 = this._Targets;
        this._Targets = targetMBeanArray;
        this._postSet(9, targetMBeanArray2, targetMBeanArray);
    }

    public boolean addTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        this._getHelper()._ensureNonNull((Object)targetMBean);
        if (!((AbstractDescriptorBean)targetMBean).isChildProperty((DescriptorBean)this, 9)) {
            TargetMBean[] targetMBeanArray = this._isSet(9) ? (TargetMBean[])this._getHelper()._extendArray((Object)this.getTargets(), TargetMBean.class, (Object)targetMBean) : new TargetMBean[]{targetMBean};
            try {
                this.setTargets(targetMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public JDBCConnectionPoolMBean getConnectionPool() {
        return this._ConnectionPool;
    }

    public String getConnectionPoolAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getConnectionPool();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isConnectionPoolSet() {
        return this._isSet(14);
    }

    public void setConnectionPoolAsString(String string) {
        if (string == null || string.length() == 0) {
            JDBCConnectionPoolMBean jDBCConnectionPoolMBean = this._ConnectionPool;
            this._initializeProperty(14);
            this._postSet(14, jDBCConnectionPoolMBean, this._ConnectionPool);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, JDBCConnectionPoolMBean.class, new ReferenceManager.Resolver(this, 14){

                public void resolveReference(Object object) {
                    try {
                        JDBCStoreMBeanImpl.this.setConnectionPool((JDBCConnectionPoolMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public boolean removeTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        TargetMBean[] targetMBeanArray = this.getTargets();
        TargetMBean[] targetMBeanArray2 = (TargetMBean[])this._getHelper()._removeElement((Object)targetMBeanArray, TargetMBean.class, (Object)targetMBean);
        if (targetMBeanArray2.length != targetMBeanArray.length) {
            try {
                this.setTargets(targetMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public void setConnectionPool(JDBCConnectionPoolMBean jDBCConnectionPoolMBean) throws InvalidAttributeValueException {
        JDBCConnectionPoolMBean jDBCConnectionPoolMBean2;
        if (jDBCConnectionPoolMBean != null) {
            jDBCConnectionPoolMBean2 = new ResolvedReference(this, 14, (AbstractDescriptorBean)jDBCConnectionPoolMBean){

                protected Object getPropertyValue() {
                    return JDBCStoreMBeanImpl.this.getConnectionPool();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)jDBCConnectionPoolMBean, (ResolvedReference)jDBCConnectionPoolMBean2);
        }
        jDBCConnectionPoolMBean2 = this._ConnectionPool;
        this._ConnectionPool = jDBCConnectionPoolMBean;
        this._postSet(14, jDBCConnectionPoolMBean2, jDBCConnectionPoolMBean);
    }

    public int getDeletesPerBatchMaximum() {
        return this._DeletesPerBatchMaximum;
    }

    public int getDeploymentOrder() {
        return this._DeploymentOrder;
    }

    public String getLogicalName() {
        return this._LogicalName;
    }

    public boolean isDeletesPerBatchMaximumSet() {
        return this._isSet(15);
    }

    public boolean isDeploymentOrderSet() {
        return this._isSet(10);
    }

    public boolean isLogicalNameSet() {
        return this._isSet(11);
    }

    public void setDeletesPerBatchMaximum(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"DeletesPerBatchMaximum", (long)n, (long)1L, (long)100L);
        int n2 = this._DeletesPerBatchMaximum;
        this._DeletesPerBatchMaximum = n;
        this._postSet(15, n2, n);
    }

    public void setDeploymentOrder(int n) {
        LegalChecks.checkInRange((String)"DeploymentOrder", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._DeploymentOrder;
        this._DeploymentOrder = n;
        this._postSet(10, n2, n);
    }

    public void setLogicalName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._LogicalName;
        this._LogicalName = string;
        this._postSet(11, string2, string);
    }

    public int getInsertsPerBatchMaximum() {
        return this._InsertsPerBatchMaximum;
    }

    public String getXAResourceName() {
        return this._XAResourceName;
    }

    public boolean isInsertsPerBatchMaximumSet() {
        return this._isSet(16);
    }

    public boolean isXAResourceNameSet() {
        return this._isSet(12);
    }

    public void setInsertsPerBatchMaximum(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"InsertsPerBatchMaximum", (long)n, (long)1L, (long)100L);
        int n2 = this._InsertsPerBatchMaximum;
        this._InsertsPerBatchMaximum = n;
        this._postSet(16, n2, n);
    }

    public void setXAResourceName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._XAResourceName;
        this._XAResourceName = string;
        this._postSet(12, string2, string);
    }

    public int getDeletesPerStatementMaximum() {
        return this._DeletesPerStatementMaximum;
    }

    public boolean isDeletesPerStatementMaximumSet() {
        return this._isSet(17);
    }

    public void setDeletesPerStatementMaximum(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"DeletesPerStatementMaximum", (long)n, (long)1L, (long)100L);
        int n2 = this._DeletesPerStatementMaximum;
        this._DeletesPerStatementMaximum = n;
        this._postSet(17, n2, n);
    }

    public int getWorkerCount() {
        return this._WorkerCount;
    }

    public boolean isWorkerCountSet() {
        return this._isSet(18);
    }

    public void setWorkerCount(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"WorkerCount", (long)n, (long)1L, (long)1000L);
        int n2 = this._WorkerCount;
        this._WorkerCount = n;
        this._postSet(18, n2, n);
    }

    public int getWorkerPreferredBatchSize() {
        return this._WorkerPreferredBatchSize;
    }

    public boolean isWorkerPreferredBatchSizeSet() {
        return this._isSet(19);
    }

    public void setWorkerPreferredBatchSize(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"WorkerPreferredBatchSize", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this._WorkerPreferredBatchSize;
        this._WorkerPreferredBatchSize = n;
        this._postSet(19, n2, n);
    }

    public int getThreeStepThreshold() {
        return this._ThreeStepThreshold;
    }

    public boolean isThreeStepThresholdSet() {
        return this._isSet(20);
    }

    public void setThreeStepThreshold(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"ThreeStepThreshold", (long)n, (long)4000L, (long)Integer.MAX_VALUE);
        int n2 = this._ThreeStepThreshold;
        this._ThreeStepThreshold = n;
        this._postSet(20, n2, n);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 14;
        }
        try {
            switch (n) {
                case 14: {
                    this._ConnectionPool = null;
                    if (bl) break;
                }
                case 13: {
                    this._DataSource = null;
                    if (bl) break;
                }
                case 15: {
                    this._DeletesPerBatchMaximum = 20;
                    if (bl) break;
                }
                case 17: {
                    this._DeletesPerStatementMaximum = 20;
                    if (bl) break;
                }
                case 10: {
                    this._DeploymentOrder = 1000;
                    if (bl) break;
                }
                case 16: {
                    this._InsertsPerBatchMaximum = 20;
                    if (bl) break;
                }
                case 11: {
                    this._LogicalName = null;
                    if (bl) break;
                }
                case 9: {
                    this._Targets = new TargetMBean[0];
                    if (bl) break;
                }
                case 20: {
                    this._ThreeStepThreshold = 200000;
                    if (bl) break;
                }
                case 18: {
                    this._WorkerCount = 1;
                    if (bl) break;
                }
                case 19: {
                    this._WorkerPreferredBatchSize = 10;
                    if (bl) break;
                }
                case 12: {
                    this._XAResourceName = null;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "JDBCStore";
    }

    public void putValue(String string, Object object) {
        if (string.equals("ConnectionPool")) {
            JDBCConnectionPoolMBean jDBCConnectionPoolMBean = this._ConnectionPool;
            this._ConnectionPool = (JDBCConnectionPoolMBean)object;
            this._postSet(14, jDBCConnectionPoolMBean, this._ConnectionPool);
            return;
        }
        if (string.equals("DataSource")) {
            JDBCSystemResourceMBean jDBCSystemResourceMBean = this._DataSource;
            this._DataSource = (JDBCSystemResourceMBean)object;
            this._postSet(13, jDBCSystemResourceMBean, this._DataSource);
            return;
        }
        if (string.equals("DeletesPerBatchMaximum")) {
            int n = this._DeletesPerBatchMaximum;
            this._DeletesPerBatchMaximum = (Integer)object;
            this._postSet(15, n, this._DeletesPerBatchMaximum);
            return;
        }
        if (string.equals("DeletesPerStatementMaximum")) {
            int n = this._DeletesPerStatementMaximum;
            this._DeletesPerStatementMaximum = (Integer)object;
            this._postSet(17, n, this._DeletesPerStatementMaximum);
            return;
        }
        if (string.equals("DeploymentOrder")) {
            int n = this._DeploymentOrder;
            this._DeploymentOrder = (Integer)object;
            this._postSet(10, n, this._DeploymentOrder);
            return;
        }
        if (string.equals("InsertsPerBatchMaximum")) {
            int n = this._InsertsPerBatchMaximum;
            this._InsertsPerBatchMaximum = (Integer)object;
            this._postSet(16, n, this._InsertsPerBatchMaximum);
            return;
        }
        if (string.equals("LogicalName")) {
            String string2 = this._LogicalName;
            this._LogicalName = (String)object;
            this._postSet(11, string2, this._LogicalName);
            return;
        }
        if (string.equals("Targets")) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._Targets = (TargetMBean[])object;
            this._postSet(9, targetMBeanArray, this._Targets);
            return;
        }
        if (string.equals("ThreeStepThreshold")) {
            int n = this._ThreeStepThreshold;
            this._ThreeStepThreshold = (Integer)object;
            this._postSet(20, n, this._ThreeStepThreshold);
            return;
        }
        if (string.equals("WorkerCount")) {
            int n = this._WorkerCount;
            this._WorkerCount = (Integer)object;
            this._postSet(18, n, this._WorkerCount);
            return;
        }
        if (string.equals("WorkerPreferredBatchSize")) {
            int n = this._WorkerPreferredBatchSize;
            this._WorkerPreferredBatchSize = (Integer)object;
            this._postSet(19, n, this._WorkerPreferredBatchSize);
            return;
        }
        if (string.equals("XAResourceName")) {
            String string3 = this._XAResourceName;
            this._XAResourceName = (String)object;
            this._postSet(12, string3, this._XAResourceName);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("ConnectionPool")) {
            return this._ConnectionPool;
        }
        if (string.equals("DataSource")) {
            return this._DataSource;
        }
        if (string.equals("DeletesPerBatchMaximum")) {
            return new Integer(this._DeletesPerBatchMaximum);
        }
        if (string.equals("DeletesPerStatementMaximum")) {
            return new Integer(this._DeletesPerStatementMaximum);
        }
        if (string.equals("DeploymentOrder")) {
            return new Integer(this._DeploymentOrder);
        }
        if (string.equals("InsertsPerBatchMaximum")) {
            return new Integer(this._InsertsPerBatchMaximum);
        }
        if (string.equals("LogicalName")) {
            return this._LogicalName;
        }
        if (string.equals("Targets")) {
            return this._Targets;
        }
        if (string.equals("ThreeStepThreshold")) {
            return new Integer(this._ThreeStepThreshold);
        }
        if (string.equals("WorkerCount")) {
            return new Integer(this._WorkerCount);
        }
        if (string.equals("WorkerPreferredBatchSize")) {
            return new Integer(this._WorkerPreferredBatchSize);
        }
        if (string.equals("XAResourceName")) {
            return this._XAResourceName;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends GenericJDBCStoreMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 15: {
                    if (!string.equals("connection-pool")) break;
                    return 14;
                }
                case 11: {
                    if (!string.equals("data-source")) break;
                    return 13;
                }
                case 25: {
                    if (string.equals("deletes-per-batch-maximum")) {
                        return 15;
                    }
                    if (!string.equals("inserts-per-batch-maximum")) break;
                    return 16;
                }
                case 29: {
                    if (!string.equals("deletes-per-statement-maximum")) break;
                    return 17;
                }
                case 16: {
                    if (string.equals("deployment-order")) {
                        return 10;
                    }
                    if (!string.equals("xa-resource-name")) break;
                    return 12;
                }
                case 12: {
                    if (string.equals("logical-name")) {
                        return 11;
                    }
                    if (!string.equals("worker-count")) break;
                    return 18;
                }
                case 6: {
                    if (!string.equals("target")) break;
                    return 9;
                }
                case 20: {
                    if (!string.equals("three-step-threshold")) break;
                    return 20;
                }
                case 27: {
                    if (!string.equals("worker-preferred-batch-size")) break;
                    return 19;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 14: {
                    return "connection-pool";
                }
                case 13: {
                    return "data-source";
                }
                case 15: {
                    return "deletes-per-batch-maximum";
                }
                case 17: {
                    return "deletes-per-statement-maximum";
                }
                case 10: {
                    return "deployment-order";
                }
                case 16: {
                    return "inserts-per-batch-maximum";
                }
                case 11: {
                    return "logical-name";
                }
                case 9: {
                    return "target";
                }
                case 20: {
                    return "three-step-threshold";
                }
                case 18: {
                    return "worker-count";
                }
                case 19: {
                    return "worker-preferred-batch-size";
                }
                case 12: {
                    return "xa-resource-name";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 9: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends GenericJDBCStoreMBeanImpl.Helper {
        private JDBCStoreMBeanImpl bean;

        protected Helper(JDBCStoreMBeanImpl jDBCStoreMBeanImpl) {
            super(jDBCStoreMBeanImpl);
            this.bean = jDBCStoreMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 14: {
                    return "ConnectionPool";
                }
                case 13: {
                    return "DataSource";
                }
                case 15: {
                    return "DeletesPerBatchMaximum";
                }
                case 17: {
                    return "DeletesPerStatementMaximum";
                }
                case 10: {
                    return "DeploymentOrder";
                }
                case 16: {
                    return "InsertsPerBatchMaximum";
                }
                case 11: {
                    return "LogicalName";
                }
                case 9: {
                    return "Targets";
                }
                case 20: {
                    return "ThreeStepThreshold";
                }
                case 18: {
                    return "WorkerCount";
                }
                case 19: {
                    return "WorkerPreferredBatchSize";
                }
                case 12: {
                    return "XAResourceName";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("ConnectionPool")) {
                return 14;
            }
            if (string.equals("DataSource")) {
                return 13;
            }
            if (string.equals("DeletesPerBatchMaximum")) {
                return 15;
            }
            if (string.equals("DeletesPerStatementMaximum")) {
                return 17;
            }
            if (string.equals("DeploymentOrder")) {
                return 10;
            }
            if (string.equals("InsertsPerBatchMaximum")) {
                return 16;
            }
            if (string.equals("LogicalName")) {
                return 11;
            }
            if (string.equals("Targets")) {
                return 9;
            }
            if (string.equals("ThreeStepThreshold")) {
                return 20;
            }
            if (string.equals("WorkerCount")) {
                return 18;
            }
            if (string.equals("WorkerPreferredBatchSize")) {
                return 19;
            }
            if (string.equals("XAResourceName")) {
                return 12;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isConnectionPoolSet()) {
                    stringBuffer.append("ConnectionPool");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionPool()));
                }
                if (this.bean.isDataSourceSet()) {
                    stringBuffer.append("DataSource");
                    stringBuffer.append(String.valueOf(this.bean.getDataSource()));
                }
                if (this.bean.isDeletesPerBatchMaximumSet()) {
                    stringBuffer.append("DeletesPerBatchMaximum");
                    stringBuffer.append(String.valueOf(this.bean.getDeletesPerBatchMaximum()));
                }
                if (this.bean.isDeletesPerStatementMaximumSet()) {
                    stringBuffer.append("DeletesPerStatementMaximum");
                    stringBuffer.append(String.valueOf(this.bean.getDeletesPerStatementMaximum()));
                }
                if (this.bean.isDeploymentOrderSet()) {
                    stringBuffer.append("DeploymentOrder");
                    stringBuffer.append(String.valueOf(this.bean.getDeploymentOrder()));
                }
                if (this.bean.isInsertsPerBatchMaximumSet()) {
                    stringBuffer.append("InsertsPerBatchMaximum");
                    stringBuffer.append(String.valueOf(this.bean.getInsertsPerBatchMaximum()));
                }
                if (this.bean.isLogicalNameSet()) {
                    stringBuffer.append("LogicalName");
                    stringBuffer.append(String.valueOf(this.bean.getLogicalName()));
                }
                if (this.bean.isTargetsSet()) {
                    stringBuffer.append("Targets");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getTargets())));
                }
                if (this.bean.isThreeStepThresholdSet()) {
                    stringBuffer.append("ThreeStepThreshold");
                    stringBuffer.append(String.valueOf(this.bean.getThreeStepThreshold()));
                }
                if (this.bean.isWorkerCountSet()) {
                    stringBuffer.append("WorkerCount");
                    stringBuffer.append(String.valueOf(this.bean.getWorkerCount()));
                }
                if (this.bean.isWorkerPreferredBatchSizeSet()) {
                    stringBuffer.append("WorkerPreferredBatchSize");
                    stringBuffer.append(String.valueOf(this.bean.getWorkerPreferredBatchSize()));
                }
                if (this.bean.isXAResourceNameSet()) {
                    stringBuffer.append("XAResourceName");
                    stringBuffer.append(String.valueOf(this.bean.getXAResourceName()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                JDBCStoreMBeanImpl jDBCStoreMBeanImpl = (JDBCStoreMBeanImpl)abstractDescriptorBean;
                this.computeDiff("ConnectionPool", this.bean.getConnectionPool(), jDBCStoreMBeanImpl.getConnectionPool(), false);
                this.computeDiff("DataSource", this.bean.getDataSource(), jDBCStoreMBeanImpl.getDataSource(), false);
                this.computeDiff("DeletesPerBatchMaximum", this.bean.getDeletesPerBatchMaximum(), jDBCStoreMBeanImpl.getDeletesPerBatchMaximum(), false);
                this.computeDiff("DeletesPerStatementMaximum", this.bean.getDeletesPerStatementMaximum(), jDBCStoreMBeanImpl.getDeletesPerStatementMaximum(), false);
                this.computeDiff("DeploymentOrder", this.bean.getDeploymentOrder(), jDBCStoreMBeanImpl.getDeploymentOrder(), true);
                this.computeDiff("InsertsPerBatchMaximum", this.bean.getInsertsPerBatchMaximum(), jDBCStoreMBeanImpl.getInsertsPerBatchMaximum(), false);
                this.computeDiff("LogicalName", this.bean.getLogicalName(), jDBCStoreMBeanImpl.getLogicalName(), true);
                this.computeDiff("Targets", this.bean.getTargets(), jDBCStoreMBeanImpl.getTargets(), true);
                this.computeDiff("ThreeStepThreshold", this.bean.getThreeStepThreshold(), jDBCStoreMBeanImpl.getThreeStepThreshold(), false);
                this.computeDiff("WorkerCount", this.bean.getWorkerCount(), jDBCStoreMBeanImpl.getWorkerCount(), false);
                this.computeDiff("WorkerPreferredBatchSize", this.bean.getWorkerPreferredBatchSize(), jDBCStoreMBeanImpl.getWorkerPreferredBatchSize(), false);
                this.computeDiff("XAResourceName", this.bean.getXAResourceName(), jDBCStoreMBeanImpl.getXAResourceName(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                JDBCStoreMBeanImpl jDBCStoreMBeanImpl = (JDBCStoreMBeanImpl)beanUpdateEvent.getSourceBean();
                JDBCStoreMBeanImpl jDBCStoreMBeanImpl2 = (JDBCStoreMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("ConnectionPool")) {
                    jDBCStoreMBeanImpl.setConnectionPoolAsString(jDBCStoreMBeanImpl2.getConnectionPoolAsString());
                    jDBCStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("DataSource")) {
                    jDBCStoreMBeanImpl.setDataSourceAsString(jDBCStoreMBeanImpl2.getDataSourceAsString());
                    jDBCStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("DeletesPerBatchMaximum")) {
                    jDBCStoreMBeanImpl.setDeletesPerBatchMaximum(jDBCStoreMBeanImpl2.getDeletesPerBatchMaximum());
                    jDBCStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("DeletesPerStatementMaximum")) {
                    jDBCStoreMBeanImpl.setDeletesPerStatementMaximum(jDBCStoreMBeanImpl2.getDeletesPerStatementMaximum());
                    jDBCStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else if (string.equals("DeploymentOrder")) {
                    jDBCStoreMBeanImpl.setDeploymentOrder(jDBCStoreMBeanImpl2.getDeploymentOrder());
                    jDBCStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("InsertsPerBatchMaximum")) {
                    jDBCStoreMBeanImpl.setInsertsPerBatchMaximum(jDBCStoreMBeanImpl2.getInsertsPerBatchMaximum());
                    jDBCStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else if (string.equals("LogicalName")) {
                    jDBCStoreMBeanImpl.setLogicalName(jDBCStoreMBeanImpl2.getLogicalName());
                    jDBCStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("Targets")) {
                    jDBCStoreMBeanImpl.setTargetsAsString(jDBCStoreMBeanImpl2.getTargetsAsString());
                    jDBCStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("ThreeStepThreshold")) {
                    jDBCStoreMBeanImpl.setThreeStepThreshold(jDBCStoreMBeanImpl2.getThreeStepThreshold());
                    jDBCStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                } else if (string.equals("WorkerCount")) {
                    jDBCStoreMBeanImpl.setWorkerCount(jDBCStoreMBeanImpl2.getWorkerCount());
                    jDBCStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                } else if (string.equals("WorkerPreferredBatchSize")) {
                    jDBCStoreMBeanImpl.setWorkerPreferredBatchSize(jDBCStoreMBeanImpl2.getWorkerPreferredBatchSize());
                    jDBCStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                } else if (string.equals("XAResourceName")) {
                    jDBCStoreMBeanImpl.setXAResourceName(jDBCStoreMBeanImpl2.getXAResourceName());
                    jDBCStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                JDBCStoreMBeanImpl jDBCStoreMBeanImpl = (JDBCStoreMBeanImpl)abstractDescriptorBean;
                super.finishCopy(jDBCStoreMBeanImpl, bl, list);
                if ((list == null || !list.contains("ConnectionPool")) && this.bean.isConnectionPoolSet()) {
                    jDBCStoreMBeanImpl._unSet(jDBCStoreMBeanImpl, 14);
                    jDBCStoreMBeanImpl.setConnectionPoolAsString(this.bean.getConnectionPoolAsString());
                }
                if ((list == null || !list.contains("DataSource")) && this.bean.isDataSourceSet()) {
                    jDBCStoreMBeanImpl._unSet(jDBCStoreMBeanImpl, 13);
                    jDBCStoreMBeanImpl.setDataSourceAsString(this.bean.getDataSourceAsString());
                }
                if ((list == null || !list.contains("DeletesPerBatchMaximum")) && this.bean.isDeletesPerBatchMaximumSet()) {
                    jDBCStoreMBeanImpl.setDeletesPerBatchMaximum(this.bean.getDeletesPerBatchMaximum());
                }
                if ((list == null || !list.contains("DeletesPerStatementMaximum")) && this.bean.isDeletesPerStatementMaximumSet()) {
                    jDBCStoreMBeanImpl.setDeletesPerStatementMaximum(this.bean.getDeletesPerStatementMaximum());
                }
                if ((list == null || !list.contains("DeploymentOrder")) && this.bean.isDeploymentOrderSet()) {
                    jDBCStoreMBeanImpl.setDeploymentOrder(this.bean.getDeploymentOrder());
                }
                if ((list == null || !list.contains("InsertsPerBatchMaximum")) && this.bean.isInsertsPerBatchMaximumSet()) {
                    jDBCStoreMBeanImpl.setInsertsPerBatchMaximum(this.bean.getInsertsPerBatchMaximum());
                }
                if ((list == null || !list.contains("LogicalName")) && this.bean.isLogicalNameSet()) {
                    jDBCStoreMBeanImpl.setLogicalName(this.bean.getLogicalName());
                }
                if ((list == null || !list.contains("Targets")) && this.bean.isTargetsSet()) {
                    jDBCStoreMBeanImpl._unSet(jDBCStoreMBeanImpl, 9);
                    jDBCStoreMBeanImpl.setTargetsAsString(this.bean.getTargetsAsString());
                }
                if ((list == null || !list.contains("ThreeStepThreshold")) && this.bean.isThreeStepThresholdSet()) {
                    jDBCStoreMBeanImpl.setThreeStepThreshold(this.bean.getThreeStepThreshold());
                }
                if ((list == null || !list.contains("WorkerCount")) && this.bean.isWorkerCountSet()) {
                    jDBCStoreMBeanImpl.setWorkerCount(this.bean.getWorkerCount());
                }
                if ((list == null || !list.contains("WorkerPreferredBatchSize")) && this.bean.isWorkerPreferredBatchSizeSet()) {
                    jDBCStoreMBeanImpl.setWorkerPreferredBatchSize(this.bean.getWorkerPreferredBatchSize());
                }
                if ((list == null || !list.contains("XAResourceName")) && this.bean.isXAResourceNameSet()) {
                    jDBCStoreMBeanImpl.setXAResourceName(this.bean.getXAResourceName());
                }
                return jDBCStoreMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getConnectionPool(), clazz, object);
            this.inferSubTree(this.bean.getDataSource(), clazz, object);
            this.inferSubTree(this.bean.getTargets(), clazz, object);
        }
    }
}

