/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BootstrapProperties;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.j2ee.descriptor.wl.JMSConnectionFactoryBean;
import weblogic.jms.module.validators.JMSModuleValidator;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.DeploymentMBeanImpl;
import weblogic.management.configuration.JMSConnectionFactoryMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.TargetMBeanImpl;
import weblogic.management.mbeans.custom.JMSConnectionFactory;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class JMSConnectionFactoryMBeanImpl
extends DeploymentMBeanImpl
implements JMSConnectionFactoryMBean,
Serializable {
    private String _AcknowledgePolicy;
    private boolean _AllowCloseInOnMessage;
    private String _ClientId;
    private String _DefaultDeliveryMode;
    private int _DefaultPriority;
    private long _DefaultRedeliveryDelay;
    private long _DefaultTimeToDeliver;
    private long _DefaultTimeToLive;
    private boolean _FlowControlEnabled;
    private int _FlowInterval;
    private int _FlowMaximum;
    private int _FlowMinimum;
    private int _FlowSteps;
    private String _JNDIName;
    private boolean _LoadBalancingEnabled;
    private int _MessagesMaximum;
    private String _Name;
    private String _Notes;
    private String _OverrunPolicy;
    private long _SendTimeout;
    private boolean _ServerAffinityEnabled;
    private TargetMBean[] _Targets;
    private long _TransactionTimeout;
    private boolean _UserTransactionsEnabled;
    private boolean _XAConnectionFactoryEnabled;
    private boolean _XAServerEnabled;
    private JMSConnectionFactory _customizer;
    private static SchemaHelper2 _schemaHelper;

    public JMSConnectionFactoryMBeanImpl() {
        try {
            this._customizer = new JMSConnectionFactory(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public JMSConnectionFactoryMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new JMSConnectionFactory(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getJNDIName() {
        return this._customizer.getJNDIName();
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public TargetMBean[] getTargets() {
        return this._customizer.getTargets();
    }

    public String getTargetsAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getTargets());
    }

    public boolean isJNDINameSet() {
        return this._isSet(9);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isTargetsSet() {
        return this._isSet(7);
    }

    public void setTargetsAsString(String string) {
        if (string == null || string.length() == 0) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._initializeProperty(7);
            this._postSet(7, targetMBeanArray, this._Targets);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._Targets);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, TargetMBean.class, new ReferenceManager.Resolver(this, 7){

                    public void resolveReference(Object object) {
                        try {
                            JMSConnectionFactoryMBeanImpl.this.addTarget((TargetMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (TargetMBean targetMBean : this._Targets) {
                    if (!string2.equals(targetMBean.getName())) continue;
                    try {
                        this.removeTarget(targetMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void setJNDIName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        JMSModuleValidator.validateCFJNDIName(string);
        String string2 = this.getJNDIName();
        this._customizer.setJNDIName(string);
        this._postSet(9, string2, string);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setTargets(TargetMBean[] targetMBeanArray) throws InvalidAttributeValueException, DistributedManagementException {
        targetMBeanArray = targetMBeanArray == null ? new TargetMBeanImpl[]{} : targetMBeanArray;
        targetMBeanArray = (TargetMBean[])this._getHelper()._cleanAndValidateArray((Object)targetMBeanArray, TargetMBean.class);
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            if (targetMBeanArray[i] == null) continue;
            ResolvedReference resolvedReference = new ResolvedReference(this, 7, (AbstractDescriptorBean)targetMBeanArray[i]){

                protected Object getPropertyValue() {
                    return JMSConnectionFactoryMBeanImpl.this.getTargets();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)targetMBeanArray[i], resolvedReference);
        }
        TargetMBean[] targetMBeanArray2 = this.getTargets();
        this._customizer.setTargets(targetMBeanArray);
        this._postSet(7, targetMBeanArray2, targetMBeanArray);
    }

    public boolean addTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        this._getHelper()._ensureNonNull((Object)targetMBean);
        if (!((AbstractDescriptorBean)targetMBean).isChildProperty((DescriptorBean)this, 7)) {
            TargetMBean[] targetMBeanArray = (TargetMBean[])this._getHelper()._extendArray((Object)this.getTargets(), TargetMBean.class, (Object)targetMBean);
            try {
                this.setTargets(targetMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public String getClientId() {
        return this._customizer.getClientId();
    }

    public String getNotes() {
        return this._customizer.getNotes();
    }

    public boolean isClientIdSet() {
        return this._isSet(10);
    }

    public boolean isNotesSet() {
        return this._isSet(3);
    }

    public boolean removeTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        TargetMBean[] targetMBeanArray = this.getTargets();
        TargetMBean[] targetMBeanArray2 = (TargetMBean[])this._getHelper()._removeElement((Object)targetMBeanArray, TargetMBean.class, (Object)targetMBean);
        if (targetMBeanArray2.length != targetMBeanArray.length) {
            try {
                this.setTargets(targetMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public void setClientId(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this.getClientId();
        this._customizer.setClientId(string);
        this._postSet(10, string2, string);
    }

    public void setNotes(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String string2 = this.getNotes();
        this._customizer.setNotes(string);
        this._postSet(3, string2, string);
    }

    public int getDefaultPriority() {
        return this._customizer.getDefaultPriority();
    }

    public boolean isDefaultPrioritySet() {
        return this._isSet(11);
    }

    public void setDefaultPriority(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"DefaultPriority", (long)n, (long)0L, (long)9L);
        int n2 = this.getDefaultPriority();
        this._customizer.setDefaultPriority(n);
        this._postSet(11, n2, n);
    }

    public long getDefaultTimeToDeliver() {
        return this._customizer.getDefaultTimeToDeliver();
    }

    public boolean isDefaultTimeToDeliverSet() {
        return this._isSet(12);
    }

    public void setDefaultTimeToDeliver(long l) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"DefaultTimeToDeliver", (long)l, (long)0L, (long)Long.MAX_VALUE);
        long l2 = this.getDefaultTimeToDeliver();
        this._customizer.setDefaultTimeToDeliver(l);
        this._postSet(12, l2, l);
    }

    public long getDefaultTimeToLive() {
        return this._customizer.getDefaultTimeToLive();
    }

    public boolean isDefaultTimeToLiveSet() {
        return this._isSet(13);
    }

    public void setDefaultTimeToLive(long l) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"DefaultTimeToLive", (long)l, (long)0L, (long)Long.MAX_VALUE);
        long l2 = this.getDefaultTimeToLive();
        this._customizer.setDefaultTimeToLive(l);
        this._postSet(13, l2, l);
    }

    public long getSendTimeout() {
        return this._customizer.getSendTimeout();
    }

    public boolean isSendTimeoutSet() {
        return this._isSet(14);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void setSendTimeout(long l) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"SendTimeout", (long)l, (long)0L, (long)Long.MAX_VALUE);
        long l2 = this.getSendTimeout();
        this._customizer.setSendTimeout(l);
        this._postSet(14, l2, l);
    }

    public String getDefaultDeliveryMode() {
        return this._customizer.getDefaultDeliveryMode();
    }

    public boolean isDefaultDeliveryModeSet() {
        return this._isSet(15);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setDefaultDeliveryMode(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Persistent", "Non-Persistent"};
        string = LegalChecks.checkInEnum((String)"DefaultDeliveryMode", (String)string, (String[])stringArray);
        String string2 = this.getDefaultDeliveryMode();
        this._customizer.setDefaultDeliveryMode(string);
        this._postSet(15, string2, string);
    }

    public long getDefaultRedeliveryDelay() {
        return this._customizer.getDefaultRedeliveryDelay();
    }

    public boolean isDefaultRedeliveryDelaySet() {
        return this._isSet(16);
    }

    public void setDefaultRedeliveryDelay(long l) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"DefaultRedeliveryDelay", (long)l, (long)0L, (long)Long.MAX_VALUE);
        long l2 = this.getDefaultRedeliveryDelay();
        this._customizer.setDefaultRedeliveryDelay(l);
        this._postSet(16, l2, l);
    }

    public long getTransactionTimeout() {
        return this._customizer.getTransactionTimeout();
    }

    public boolean isTransactionTimeoutSet() {
        return this._isSet(17);
    }

    public void setTransactionTimeout(long l) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"TransactionTimeout", (long)l, (long)0L, (long)Integer.MAX_VALUE);
        long l2 = this.getTransactionTimeout();
        this._customizer.setTransactionTimeout(l);
        this._postSet(17, l2, l);
    }

    public boolean isUserTransactionsEnabled() {
        return this._customizer.isUserTransactionsEnabled();
    }

    public boolean isUserTransactionsEnabledSet() {
        return this._isSet(18);
    }

    public void setUserTransactionsEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.isUserTransactionsEnabled();
        this._customizer.setUserTransactionsEnabled(bl);
        this._postSet(18, bl2, bl);
    }

    public boolean getAllowCloseInOnMessage() {
        return this._customizer.getAllowCloseInOnMessage();
    }

    public boolean isAllowCloseInOnMessageSet() {
        return this._isSet(19);
    }

    public void setAllowCloseInOnMessage(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.getAllowCloseInOnMessage();
        this._customizer.setAllowCloseInOnMessage(bl);
        this._postSet(19, bl2, bl);
    }

    public int getMessagesMaximum() {
        return this._customizer.getMessagesMaximum();
    }

    public boolean isMessagesMaximumSet() {
        return this._isSet(20);
    }

    public void setMessagesMaximum(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"MessagesMaximum", (long)n, (long)-1L, (long)Integer.MAX_VALUE);
        int n2 = this.getMessagesMaximum();
        this._customizer.setMessagesMaximum(n);
        this._postSet(20, n2, n);
    }

    public String getOverrunPolicy() {
        return this._customizer.getOverrunPolicy();
    }

    public boolean isOverrunPolicySet() {
        return this._isSet(21);
    }

    public void setOverrunPolicy(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"KeepOld", "KeepNew"};
        string = LegalChecks.checkInEnum((String)"OverrunPolicy", (String)string, (String[])stringArray);
        String string2 = this.getOverrunPolicy();
        this._customizer.setOverrunPolicy(string);
        this._postSet(21, string2, string);
    }

    public boolean isXAConnectionFactoryEnabled() {
        return this._customizer.isXAConnectionFactoryEnabled();
    }

    public boolean isXAConnectionFactoryEnabledSet() {
        return this._isSet(22);
    }

    public void setXAConnectionFactoryEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.isXAConnectionFactoryEnabled();
        this._customizer.setXAConnectionFactoryEnabled(bl);
        this._postSet(22, bl2, bl);
    }

    public String getAcknowledgePolicy() {
        return this._customizer.getAcknowledgePolicy();
    }

    public boolean isAcknowledgePolicySet() {
        return this._isSet(23);
    }

    public void setAcknowledgePolicy(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"All", "Previous"};
        string = LegalChecks.checkInEnum((String)"AcknowledgePolicy", (String)string, (String[])stringArray);
        String string2 = this.getAcknowledgePolicy();
        this._customizer.setAcknowledgePolicy(string);
        this._postSet(23, string2, string);
    }

    public int getFlowMinimum() {
        return this._customizer.getFlowMinimum();
    }

    public boolean isFlowMinimumSet() {
        return this._isSet(24);
    }

    public void setFlowMinimum(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"FlowMinimum", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this.getFlowMinimum();
        this._customizer.setFlowMinimum(n);
        this._postSet(24, n2, n);
    }

    public int getFlowMaximum() {
        return this._customizer.getFlowMaximum();
    }

    public boolean isFlowMaximumSet() {
        return this._isSet(25);
    }

    public void setFlowMaximum(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"FlowMaximum", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this.getFlowMaximum();
        this._customizer.setFlowMaximum(n);
        this._postSet(25, n2, n);
    }

    public int getFlowInterval() {
        return this._customizer.getFlowInterval();
    }

    public boolean isFlowIntervalSet() {
        return this._isSet(26);
    }

    public void setFlowInterval(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"FlowInterval", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this.getFlowInterval();
        this._customizer.setFlowInterval(n);
        this._postSet(26, n2, n);
    }

    public int getFlowSteps() {
        return this._customizer.getFlowSteps();
    }

    public boolean isFlowStepsSet() {
        return this._isSet(27);
    }

    public void setFlowSteps(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"FlowSteps", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this.getFlowSteps();
        this._customizer.setFlowSteps(n);
        this._postSet(27, n2, n);
    }

    public boolean isFlowControlEnabled() {
        return this._FlowControlEnabled;
    }

    public boolean isFlowControlEnabledSet() {
        return this._isSet(28);
    }

    public void setFlowControlEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.isFlowControlEnabled();
        this._customizer.setFlowControlEnabled(bl);
        this._postSet(28, bl2, bl);
    }

    public boolean isLoadBalancingEnabled() {
        return this._LoadBalancingEnabled;
    }

    public boolean isLoadBalancingEnabledSet() {
        return this._isSet(29);
    }

    public void setLoadBalancingEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.isLoadBalancingEnabled();
        this._customizer.setLoadBalancingEnabled(bl);
        this._postSet(29, bl2, bl);
    }

    public boolean isServerAffinityEnabled() {
        return this._ServerAffinityEnabled;
    }

    public boolean isServerAffinityEnabledSet() {
        return this._isSet(30);
    }

    public void setServerAffinityEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.isServerAffinityEnabled();
        this._customizer.setServerAffinityEnabled(bl);
        this._postSet(30, bl2, bl);
    }

    public boolean isXAServerEnabled() {
        return this._customizer.isXAServerEnabled();
    }

    public boolean isXAServerEnabledSet() {
        return this._isSet(31);
    }

    public void setXAServerEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.isXAServerEnabled();
        this._customizer.setXAServerEnabled(bl);
        this._postSet(31, bl2, bl);
    }

    public void useDelegates(JMSConnectionFactoryBean jMSConnectionFactoryBean, SubDeploymentMBean subDeploymentMBean) {
        this._customizer.useDelegates(jMSConnectionFactoryBean, subDeploymentMBean);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 23;
        }
        try {
            switch (n) {
                case 23: {
                    this._customizer.setAcknowledgePolicy("All");
                    if (bl) break;
                }
                case 19: {
                    this._customizer.setAllowCloseInOnMessage(false);
                    if (bl) break;
                }
                case 10: {
                    this._customizer.setClientId(null);
                    if (bl) break;
                }
                case 15: {
                    this._customizer.setDefaultDeliveryMode("Persistent");
                    if (bl) break;
                }
                case 11: {
                    this._customizer.setDefaultPriority(4);
                    if (bl) break;
                }
                case 16: {
                    this._customizer.setDefaultRedeliveryDelay(0L);
                    if (bl) break;
                }
                case 12: {
                    this._customizer.setDefaultTimeToDeliver(0L);
                    if (bl) break;
                }
                case 13: {
                    this._customizer.setDefaultTimeToLive(0L);
                    if (bl) break;
                }
                case 26: {
                    this._customizer.setFlowInterval(60);
                    if (bl) break;
                }
                case 25: {
                    this._customizer.setFlowMaximum(500);
                    if (bl) break;
                }
                case 24: {
                    this._customizer.setFlowMinimum(50);
                    if (bl) break;
                }
                case 27: {
                    this._customizer.setFlowSteps(10);
                    if (bl) break;
                }
                case 9: {
                    this._customizer.setJNDIName(null);
                    if (bl) break;
                }
                case 20: {
                    this._customizer.setMessagesMaximum(10);
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 3: {
                    this._customizer.setNotes(null);
                    if (bl) break;
                }
                case 21: {
                    this._customizer.setOverrunPolicy("KeepOld");
                    if (bl) break;
                }
                case 14: {
                    this._customizer.setSendTimeout(10L);
                    if (bl) break;
                }
                case 7: {
                    this._customizer.setTargets(new TargetMBean[0]);
                    if (bl) break;
                }
                case 17: {
                    this._customizer.setTransactionTimeout(3600L);
                    if (bl) break;
                }
                case 28: {
                    this._customizer.setFlowControlEnabled(true);
                    if (bl) break;
                }
                case 29: {
                    this._customizer.setLoadBalancingEnabled(true);
                    if (bl) break;
                }
                case 30: {
                    this._customizer.setServerAffinityEnabled(true);
                    if (bl) break;
                }
                case 18: {
                    this._customizer.setUserTransactionsEnabled(false);
                    if (bl) break;
                }
                case 22: {
                    this._customizer.setXAConnectionFactoryEnabled(false);
                    if (bl) break;
                }
                case 31: {
                    this._customizer.setXAServerEnabled(false);
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "JMSConnectionFactory";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AcknowledgePolicy")) {
            String string2 = this._AcknowledgePolicy;
            this._AcknowledgePolicy = (String)object;
            this._postSet(23, string2, this._AcknowledgePolicy);
            return;
        }
        if (string.equals("AllowCloseInOnMessage")) {
            boolean bl = this._AllowCloseInOnMessage;
            this._AllowCloseInOnMessage = (Boolean)object;
            this._postSet(19, bl, this._AllowCloseInOnMessage);
            return;
        }
        if (string.equals("ClientId")) {
            String string3 = this._ClientId;
            this._ClientId = (String)object;
            this._postSet(10, string3, this._ClientId);
            return;
        }
        if (string.equals("DefaultDeliveryMode")) {
            String string4 = this._DefaultDeliveryMode;
            this._DefaultDeliveryMode = (String)object;
            this._postSet(15, string4, this._DefaultDeliveryMode);
            return;
        }
        if (string.equals("DefaultPriority")) {
            int n = this._DefaultPriority;
            this._DefaultPriority = (Integer)object;
            this._postSet(11, n, this._DefaultPriority);
            return;
        }
        if (string.equals("DefaultRedeliveryDelay")) {
            long l = this._DefaultRedeliveryDelay;
            this._DefaultRedeliveryDelay = (Long)object;
            this._postSet(16, l, this._DefaultRedeliveryDelay);
            return;
        }
        if (string.equals("DefaultTimeToDeliver")) {
            long l = this._DefaultTimeToDeliver;
            this._DefaultTimeToDeliver = (Long)object;
            this._postSet(12, l, this._DefaultTimeToDeliver);
            return;
        }
        if (string.equals("DefaultTimeToLive")) {
            long l = this._DefaultTimeToLive;
            this._DefaultTimeToLive = (Long)object;
            this._postSet(13, l, this._DefaultTimeToLive);
            return;
        }
        if (string.equals("FlowControlEnabled")) {
            boolean bl = this._FlowControlEnabled;
            this._FlowControlEnabled = (Boolean)object;
            this._postSet(28, bl, this._FlowControlEnabled);
            return;
        }
        if (string.equals("FlowInterval")) {
            int n = this._FlowInterval;
            this._FlowInterval = (Integer)object;
            this._postSet(26, n, this._FlowInterval);
            return;
        }
        if (string.equals("FlowMaximum")) {
            int n = this._FlowMaximum;
            this._FlowMaximum = (Integer)object;
            this._postSet(25, n, this._FlowMaximum);
            return;
        }
        if (string.equals("FlowMinimum")) {
            int n = this._FlowMinimum;
            this._FlowMinimum = (Integer)object;
            this._postSet(24, n, this._FlowMinimum);
            return;
        }
        if (string.equals("FlowSteps")) {
            int n = this._FlowSteps;
            this._FlowSteps = (Integer)object;
            this._postSet(27, n, this._FlowSteps);
            return;
        }
        if (string.equals("JNDIName")) {
            String string5 = this._JNDIName;
            this._JNDIName = (String)object;
            this._postSet(9, string5, this._JNDIName);
            return;
        }
        if (string.equals("LoadBalancingEnabled")) {
            boolean bl = this._LoadBalancingEnabled;
            this._LoadBalancingEnabled = (Boolean)object;
            this._postSet(29, bl, this._LoadBalancingEnabled);
            return;
        }
        if (string.equals("MessagesMaximum")) {
            int n = this._MessagesMaximum;
            this._MessagesMaximum = (Integer)object;
            this._postSet(20, n, this._MessagesMaximum);
            return;
        }
        if (string.equals("Name")) {
            String string6 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string6, this._Name);
            return;
        }
        if (string.equals("Notes")) {
            String string7 = this._Notes;
            this._Notes = (String)object;
            this._postSet(3, string7, this._Notes);
            return;
        }
        if (string.equals("OverrunPolicy")) {
            String string8 = this._OverrunPolicy;
            this._OverrunPolicy = (String)object;
            this._postSet(21, string8, this._OverrunPolicy);
            return;
        }
        if (string.equals("SendTimeout")) {
            long l = this._SendTimeout;
            this._SendTimeout = (Long)object;
            this._postSet(14, l, this._SendTimeout);
            return;
        }
        if (string.equals("ServerAffinityEnabled")) {
            boolean bl = this._ServerAffinityEnabled;
            this._ServerAffinityEnabled = (Boolean)object;
            this._postSet(30, bl, this._ServerAffinityEnabled);
            return;
        }
        if (string.equals("Targets")) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._Targets = (TargetMBean[])object;
            this._postSet(7, targetMBeanArray, this._Targets);
            return;
        }
        if (string.equals("TransactionTimeout")) {
            long l = this._TransactionTimeout;
            this._TransactionTimeout = (Long)object;
            this._postSet(17, l, this._TransactionTimeout);
            return;
        }
        if (string.equals("UserTransactionsEnabled")) {
            boolean bl = this._UserTransactionsEnabled;
            this._UserTransactionsEnabled = (Boolean)object;
            this._postSet(18, bl, this._UserTransactionsEnabled);
            return;
        }
        if (string.equals("XAConnectionFactoryEnabled")) {
            boolean bl = this._XAConnectionFactoryEnabled;
            this._XAConnectionFactoryEnabled = (Boolean)object;
            this._postSet(22, bl, this._XAConnectionFactoryEnabled);
            return;
        }
        if (string.equals("XAServerEnabled")) {
            boolean bl = this._XAServerEnabled;
            this._XAServerEnabled = (Boolean)object;
            this._postSet(31, bl, this._XAServerEnabled);
            return;
        }
        if (string.equals("customizer")) {
            JMSConnectionFactory jMSConnectionFactory = this._customizer;
            this._customizer = (JMSConnectionFactory)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AcknowledgePolicy")) {
            return this._AcknowledgePolicy;
        }
        if (string.equals("AllowCloseInOnMessage")) {
            return new Boolean(this._AllowCloseInOnMessage);
        }
        if (string.equals("ClientId")) {
            return this._ClientId;
        }
        if (string.equals("DefaultDeliveryMode")) {
            return this._DefaultDeliveryMode;
        }
        if (string.equals("DefaultPriority")) {
            return new Integer(this._DefaultPriority);
        }
        if (string.equals("DefaultRedeliveryDelay")) {
            return new Long(this._DefaultRedeliveryDelay);
        }
        if (string.equals("DefaultTimeToDeliver")) {
            return new Long(this._DefaultTimeToDeliver);
        }
        if (string.equals("DefaultTimeToLive")) {
            return new Long(this._DefaultTimeToLive);
        }
        if (string.equals("FlowControlEnabled")) {
            return new Boolean(this._FlowControlEnabled);
        }
        if (string.equals("FlowInterval")) {
            return new Integer(this._FlowInterval);
        }
        if (string.equals("FlowMaximum")) {
            return new Integer(this._FlowMaximum);
        }
        if (string.equals("FlowMinimum")) {
            return new Integer(this._FlowMinimum);
        }
        if (string.equals("FlowSteps")) {
            return new Integer(this._FlowSteps);
        }
        if (string.equals("JNDIName")) {
            return this._JNDIName;
        }
        if (string.equals("LoadBalancingEnabled")) {
            return new Boolean(this._LoadBalancingEnabled);
        }
        if (string.equals("MessagesMaximum")) {
            return new Integer(this._MessagesMaximum);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("Notes")) {
            return this._Notes;
        }
        if (string.equals("OverrunPolicy")) {
            return this._OverrunPolicy;
        }
        if (string.equals("SendTimeout")) {
            return new Long(this._SendTimeout);
        }
        if (string.equals("ServerAffinityEnabled")) {
            return new Boolean(this._ServerAffinityEnabled);
        }
        if (string.equals("Targets")) {
            return this._Targets;
        }
        if (string.equals("TransactionTimeout")) {
            return new Long(this._TransactionTimeout);
        }
        if (string.equals("UserTransactionsEnabled")) {
            return new Boolean(this._UserTransactionsEnabled);
        }
        if (string.equals("XAConnectionFactoryEnabled")) {
            return new Boolean(this._XAConnectionFactoryEnabled);
        }
        if (string.equals("XAServerEnabled")) {
            return new Boolean(this._XAServerEnabled);
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends DeploymentMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 18: {
                    if (!string.equals("acknowledge-policy")) break;
                    return 23;
                }
                case 25: {
                    if (string.equals("allow-close-in-on-message")) {
                        return 19;
                    }
                    if (!string.equals("user-transactions-enabled")) break;
                    return 18;
                }
                case 9: {
                    if (string.equals("client-id")) {
                        return 10;
                    }
                    if (!string.equals("jndi-name")) break;
                    return 9;
                }
                case 21: {
                    if (!string.equals("default-delivery-mode")) break;
                    return 15;
                }
                case 16: {
                    if (string.equals("default-priority")) {
                        return 11;
                    }
                    if (!string.equals("messages-maximum")) break;
                    return 20;
                }
                case 24: {
                    if (!string.equals("default-redelivery-delay")) break;
                    return 16;
                }
                case 23: {
                    if (string.equals("default-time-to-deliver")) {
                        return 12;
                    }
                    if (!string.equals("server-affinity-enabled")) break;
                    return 30;
                }
                case 20: {
                    if (string.equals("default-time-to-live")) {
                        return 13;
                    }
                    if (!string.equals("flow-control-enabled")) break;
                    return 28;
                }
                case 13: {
                    if (!string.equals("flow-interval")) break;
                    return 26;
                }
                case 12: {
                    if (string.equals("flow-maximum")) {
                        return 25;
                    }
                    if (string.equals("flow-minimum")) {
                        return 24;
                    }
                    if (!string.equals("send-timeout")) break;
                    return 14;
                }
                case 10: {
                    if (!string.equals("flow-steps")) break;
                    return 27;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 5: {
                    if (!string.equals("notes")) break;
                    return 3;
                }
                case 14: {
                    if (!string.equals("overrun-policy")) break;
                    return 21;
                }
                case 6: {
                    if (!string.equals("target")) break;
                    return 7;
                }
                case 19: {
                    if (!string.equals("transaction-timeout")) break;
                    return 17;
                }
                case 22: {
                    if (!string.equals("load-balancing-enabled")) break;
                    return 29;
                }
                case 29: {
                    if (!string.equals("xa-connection-factory-enabled")) break;
                    return 22;
                }
                case 17: {
                    if (!string.equals("xa-server-enabled")) break;
                    return 31;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 23: {
                    return "acknowledge-policy";
                }
                case 19: {
                    return "allow-close-in-on-message";
                }
                case 10: {
                    return "client-id";
                }
                case 15: {
                    return "default-delivery-mode";
                }
                case 11: {
                    return "default-priority";
                }
                case 16: {
                    return "default-redelivery-delay";
                }
                case 12: {
                    return "default-time-to-deliver";
                }
                case 13: {
                    return "default-time-to-live";
                }
                case 26: {
                    return "flow-interval";
                }
                case 25: {
                    return "flow-maximum";
                }
                case 24: {
                    return "flow-minimum";
                }
                case 27: {
                    return "flow-steps";
                }
                case 9: {
                    return "jndi-name";
                }
                case 20: {
                    return "messages-maximum";
                }
                case 2: {
                    return "name";
                }
                case 3: {
                    return "notes";
                }
                case 21: {
                    return "overrun-policy";
                }
                case 14: {
                    return "send-timeout";
                }
                case 7: {
                    return "target";
                }
                case 17: {
                    return "transaction-timeout";
                }
                case 28: {
                    return "flow-control-enabled";
                }
                case 29: {
                    return "load-balancing-enabled";
                }
                case 30: {
                    return "server-affinity-enabled";
                }
                case 18: {
                    return "user-transactions-enabled";
                }
                case 22: {
                    return "xa-connection-factory-enabled";
                }
                case 31: {
                    return "xa-server-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 7: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends DeploymentMBeanImpl.Helper {
        private JMSConnectionFactoryMBeanImpl bean;

        protected Helper(JMSConnectionFactoryMBeanImpl jMSConnectionFactoryMBeanImpl) {
            super(jMSConnectionFactoryMBeanImpl);
            this.bean = jMSConnectionFactoryMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 23: {
                    return "AcknowledgePolicy";
                }
                case 19: {
                    return "AllowCloseInOnMessage";
                }
                case 10: {
                    return "ClientId";
                }
                case 15: {
                    return "DefaultDeliveryMode";
                }
                case 11: {
                    return "DefaultPriority";
                }
                case 16: {
                    return "DefaultRedeliveryDelay";
                }
                case 12: {
                    return "DefaultTimeToDeliver";
                }
                case 13: {
                    return "DefaultTimeToLive";
                }
                case 26: {
                    return "FlowInterval";
                }
                case 25: {
                    return "FlowMaximum";
                }
                case 24: {
                    return "FlowMinimum";
                }
                case 27: {
                    return "FlowSteps";
                }
                case 9: {
                    return "JNDIName";
                }
                case 20: {
                    return "MessagesMaximum";
                }
                case 2: {
                    return "Name";
                }
                case 3: {
                    return "Notes";
                }
                case 21: {
                    return "OverrunPolicy";
                }
                case 14: {
                    return "SendTimeout";
                }
                case 7: {
                    return "Targets";
                }
                case 17: {
                    return "TransactionTimeout";
                }
                case 28: {
                    return "FlowControlEnabled";
                }
                case 29: {
                    return "LoadBalancingEnabled";
                }
                case 30: {
                    return "ServerAffinityEnabled";
                }
                case 18: {
                    return "UserTransactionsEnabled";
                }
                case 22: {
                    return "XAConnectionFactoryEnabled";
                }
                case 31: {
                    return "XAServerEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("AcknowledgePolicy")) {
                return 23;
            }
            if (string.equals("AllowCloseInOnMessage")) {
                return 19;
            }
            if (string.equals("ClientId")) {
                return 10;
            }
            if (string.equals("DefaultDeliveryMode")) {
                return 15;
            }
            if (string.equals("DefaultPriority")) {
                return 11;
            }
            if (string.equals("DefaultRedeliveryDelay")) {
                return 16;
            }
            if (string.equals("DefaultTimeToDeliver")) {
                return 12;
            }
            if (string.equals("DefaultTimeToLive")) {
                return 13;
            }
            if (string.equals("FlowInterval")) {
                return 26;
            }
            if (string.equals("FlowMaximum")) {
                return 25;
            }
            if (string.equals("FlowMinimum")) {
                return 24;
            }
            if (string.equals("FlowSteps")) {
                return 27;
            }
            if (string.equals("JNDIName")) {
                return 9;
            }
            if (string.equals("MessagesMaximum")) {
                return 20;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("Notes")) {
                return 3;
            }
            if (string.equals("OverrunPolicy")) {
                return 21;
            }
            if (string.equals("SendTimeout")) {
                return 14;
            }
            if (string.equals("Targets")) {
                return 7;
            }
            if (string.equals("TransactionTimeout")) {
                return 17;
            }
            if (string.equals("FlowControlEnabled")) {
                return 28;
            }
            if (string.equals("LoadBalancingEnabled")) {
                return 29;
            }
            if (string.equals("ServerAffinityEnabled")) {
                return 30;
            }
            if (string.equals("UserTransactionsEnabled")) {
                return 18;
            }
            if (string.equals("XAConnectionFactoryEnabled")) {
                return 22;
            }
            if (string.equals("XAServerEnabled")) {
                return 31;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isAcknowledgePolicySet()) {
                    stringBuffer.append("AcknowledgePolicy");
                    stringBuffer.append(String.valueOf(this.bean.getAcknowledgePolicy()));
                }
                if (this.bean.isAllowCloseInOnMessageSet()) {
                    stringBuffer.append("AllowCloseInOnMessage");
                    stringBuffer.append(String.valueOf(this.bean.getAllowCloseInOnMessage()));
                }
                if (this.bean.isClientIdSet()) {
                    stringBuffer.append("ClientId");
                    stringBuffer.append(String.valueOf(this.bean.getClientId()));
                }
                if (this.bean.isDefaultDeliveryModeSet()) {
                    stringBuffer.append("DefaultDeliveryMode");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultDeliveryMode()));
                }
                if (this.bean.isDefaultPrioritySet()) {
                    stringBuffer.append("DefaultPriority");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultPriority()));
                }
                if (this.bean.isDefaultRedeliveryDelaySet()) {
                    stringBuffer.append("DefaultRedeliveryDelay");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultRedeliveryDelay()));
                }
                if (this.bean.isDefaultTimeToDeliverSet()) {
                    stringBuffer.append("DefaultTimeToDeliver");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultTimeToDeliver()));
                }
                if (this.bean.isDefaultTimeToLiveSet()) {
                    stringBuffer.append("DefaultTimeToLive");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultTimeToLive()));
                }
                if (this.bean.isFlowIntervalSet()) {
                    stringBuffer.append("FlowInterval");
                    stringBuffer.append(String.valueOf(this.bean.getFlowInterval()));
                }
                if (this.bean.isFlowMaximumSet()) {
                    stringBuffer.append("FlowMaximum");
                    stringBuffer.append(String.valueOf(this.bean.getFlowMaximum()));
                }
                if (this.bean.isFlowMinimumSet()) {
                    stringBuffer.append("FlowMinimum");
                    stringBuffer.append(String.valueOf(this.bean.getFlowMinimum()));
                }
                if (this.bean.isFlowStepsSet()) {
                    stringBuffer.append("FlowSteps");
                    stringBuffer.append(String.valueOf(this.bean.getFlowSteps()));
                }
                if (this.bean.isJNDINameSet()) {
                    stringBuffer.append("JNDIName");
                    stringBuffer.append(String.valueOf(this.bean.getJNDIName()));
                }
                if (this.bean.isMessagesMaximumSet()) {
                    stringBuffer.append("MessagesMaximum");
                    stringBuffer.append(String.valueOf(this.bean.getMessagesMaximum()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isNotesSet()) {
                    stringBuffer.append("Notes");
                    stringBuffer.append(String.valueOf(this.bean.getNotes()));
                }
                if (this.bean.isOverrunPolicySet()) {
                    stringBuffer.append("OverrunPolicy");
                    stringBuffer.append(String.valueOf(this.bean.getOverrunPolicy()));
                }
                if (this.bean.isSendTimeoutSet()) {
                    stringBuffer.append("SendTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getSendTimeout()));
                }
                if (this.bean.isTargetsSet()) {
                    stringBuffer.append("Targets");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getTargets())));
                }
                if (this.bean.isTransactionTimeoutSet()) {
                    stringBuffer.append("TransactionTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getTransactionTimeout()));
                }
                if (this.bean.isFlowControlEnabledSet()) {
                    stringBuffer.append("FlowControlEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isFlowControlEnabled()));
                }
                if (this.bean.isLoadBalancingEnabledSet()) {
                    stringBuffer.append("LoadBalancingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isLoadBalancingEnabled()));
                }
                if (this.bean.isServerAffinityEnabledSet()) {
                    stringBuffer.append("ServerAffinityEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isServerAffinityEnabled()));
                }
                if (this.bean.isUserTransactionsEnabledSet()) {
                    stringBuffer.append("UserTransactionsEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isUserTransactionsEnabled()));
                }
                if (this.bean.isXAConnectionFactoryEnabledSet()) {
                    stringBuffer.append("XAConnectionFactoryEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isXAConnectionFactoryEnabled()));
                }
                if (this.bean.isXAServerEnabledSet()) {
                    stringBuffer.append("XAServerEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isXAServerEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                JMSConnectionFactoryMBeanImpl jMSConnectionFactoryMBeanImpl = (JMSConnectionFactoryMBeanImpl)abstractDescriptorBean;
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("AcknowledgePolicy", this.bean.getAcknowledgePolicy(), jMSConnectionFactoryMBeanImpl.getAcknowledgePolicy(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("AllowCloseInOnMessage", this.bean.getAllowCloseInOnMessage(), jMSConnectionFactoryMBeanImpl.getAllowCloseInOnMessage(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ClientId", this.bean.getClientId(), jMSConnectionFactoryMBeanImpl.getClientId(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("DefaultDeliveryMode", this.bean.getDefaultDeliveryMode(), jMSConnectionFactoryMBeanImpl.getDefaultDeliveryMode(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("DefaultPriority", this.bean.getDefaultPriority(), jMSConnectionFactoryMBeanImpl.getDefaultPriority(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("DefaultRedeliveryDelay", this.bean.getDefaultRedeliveryDelay(), jMSConnectionFactoryMBeanImpl.getDefaultRedeliveryDelay(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("DefaultTimeToDeliver", this.bean.getDefaultTimeToDeliver(), jMSConnectionFactoryMBeanImpl.getDefaultTimeToDeliver(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("DefaultTimeToLive", this.bean.getDefaultTimeToLive(), jMSConnectionFactoryMBeanImpl.getDefaultTimeToLive(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("FlowInterval", this.bean.getFlowInterval(), jMSConnectionFactoryMBeanImpl.getFlowInterval(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("FlowMaximum", this.bean.getFlowMaximum(), jMSConnectionFactoryMBeanImpl.getFlowMaximum(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("FlowMinimum", this.bean.getFlowMinimum(), jMSConnectionFactoryMBeanImpl.getFlowMinimum(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("FlowSteps", this.bean.getFlowSteps(), jMSConnectionFactoryMBeanImpl.getFlowSteps(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("JNDIName", this.bean.getJNDIName(), jMSConnectionFactoryMBeanImpl.getJNDIName(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("MessagesMaximum", this.bean.getMessagesMaximum(), jMSConnectionFactoryMBeanImpl.getMessagesMaximum(), true);
                }
                this.computeDiff("Name", this.bean.getName(), jMSConnectionFactoryMBeanImpl.getName(), false);
                this.computeDiff("Notes", this.bean.getNotes(), jMSConnectionFactoryMBeanImpl.getNotes(), true);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("OverrunPolicy", this.bean.getOverrunPolicy(), jMSConnectionFactoryMBeanImpl.getOverrunPolicy(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("SendTimeout", this.bean.getSendTimeout(), jMSConnectionFactoryMBeanImpl.getSendTimeout(), true);
                }
                this.computeDiff("Targets", this.bean.getTargets(), jMSConnectionFactoryMBeanImpl.getTargets(), true);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("TransactionTimeout", this.bean.getTransactionTimeout(), jMSConnectionFactoryMBeanImpl.getTransactionTimeout(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("FlowControlEnabled", this.bean.isFlowControlEnabled(), jMSConnectionFactoryMBeanImpl.isFlowControlEnabled(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LoadBalancingEnabled", this.bean.isLoadBalancingEnabled(), jMSConnectionFactoryMBeanImpl.isLoadBalancingEnabled(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ServerAffinityEnabled", this.bean.isServerAffinityEnabled(), jMSConnectionFactoryMBeanImpl.isServerAffinityEnabled(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("UserTransactionsEnabled", this.bean.isUserTransactionsEnabled(), jMSConnectionFactoryMBeanImpl.isUserTransactionsEnabled(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("XAConnectionFactoryEnabled", this.bean.isXAConnectionFactoryEnabled(), jMSConnectionFactoryMBeanImpl.isXAConnectionFactoryEnabled(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("XAServerEnabled", this.bean.isXAServerEnabled(), jMSConnectionFactoryMBeanImpl.isXAServerEnabled(), false);
                }
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                JMSConnectionFactoryMBeanImpl jMSConnectionFactoryMBeanImpl = (JMSConnectionFactoryMBeanImpl)beanUpdateEvent.getSourceBean();
                JMSConnectionFactoryMBeanImpl jMSConnectionFactoryMBeanImpl2 = (JMSConnectionFactoryMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("AcknowledgePolicy")) {
                    jMSConnectionFactoryMBeanImpl.setAcknowledgePolicy(jMSConnectionFactoryMBeanImpl2.getAcknowledgePolicy());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                } else if (string.equals("AllowCloseInOnMessage")) {
                    jMSConnectionFactoryMBeanImpl.setAllowCloseInOnMessage(jMSConnectionFactoryMBeanImpl2.getAllowCloseInOnMessage());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                } else if (string.equals("ClientId")) {
                    jMSConnectionFactoryMBeanImpl.setClientId(jMSConnectionFactoryMBeanImpl2.getClientId());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("DefaultDeliveryMode")) {
                    jMSConnectionFactoryMBeanImpl.setDefaultDeliveryMode(jMSConnectionFactoryMBeanImpl2.getDefaultDeliveryMode());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("DefaultPriority")) {
                    jMSConnectionFactoryMBeanImpl.setDefaultPriority(jMSConnectionFactoryMBeanImpl2.getDefaultPriority());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("DefaultRedeliveryDelay")) {
                    jMSConnectionFactoryMBeanImpl.setDefaultRedeliveryDelay(jMSConnectionFactoryMBeanImpl2.getDefaultRedeliveryDelay());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else if (string.equals("DefaultTimeToDeliver")) {
                    jMSConnectionFactoryMBeanImpl.setDefaultTimeToDeliver(jMSConnectionFactoryMBeanImpl2.getDefaultTimeToDeliver());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("DefaultTimeToLive")) {
                    jMSConnectionFactoryMBeanImpl.setDefaultTimeToLive(jMSConnectionFactoryMBeanImpl2.getDefaultTimeToLive());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("FlowInterval")) {
                    jMSConnectionFactoryMBeanImpl.setFlowInterval(jMSConnectionFactoryMBeanImpl2.getFlowInterval());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 26);
                } else if (string.equals("FlowMaximum")) {
                    jMSConnectionFactoryMBeanImpl.setFlowMaximum(jMSConnectionFactoryMBeanImpl2.getFlowMaximum());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                } else if (string.equals("FlowMinimum")) {
                    jMSConnectionFactoryMBeanImpl.setFlowMinimum(jMSConnectionFactoryMBeanImpl2.getFlowMinimum());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                } else if (string.equals("FlowSteps")) {
                    jMSConnectionFactoryMBeanImpl.setFlowSteps(jMSConnectionFactoryMBeanImpl2.getFlowSteps());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 27);
                } else if (string.equals("JNDIName")) {
                    jMSConnectionFactoryMBeanImpl.setJNDIName(jMSConnectionFactoryMBeanImpl2.getJNDIName());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("MessagesMaximum")) {
                    jMSConnectionFactoryMBeanImpl.setMessagesMaximum(jMSConnectionFactoryMBeanImpl2.getMessagesMaximum());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                } else if (string.equals("Name")) {
                    jMSConnectionFactoryMBeanImpl.setName(jMSConnectionFactoryMBeanImpl2.getName());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (string.equals("Notes")) {
                    jMSConnectionFactoryMBeanImpl.setNotes(jMSConnectionFactoryMBeanImpl2.getNotes());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 3);
                } else if (string.equals("OverrunPolicy")) {
                    jMSConnectionFactoryMBeanImpl.setOverrunPolicy(jMSConnectionFactoryMBeanImpl2.getOverrunPolicy());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                } else if (string.equals("SendTimeout")) {
                    jMSConnectionFactoryMBeanImpl.setSendTimeout(jMSConnectionFactoryMBeanImpl2.getSendTimeout());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("Targets")) {
                    jMSConnectionFactoryMBeanImpl.setTargetsAsString(jMSConnectionFactoryMBeanImpl2.getTargetsAsString());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("TransactionTimeout")) {
                    jMSConnectionFactoryMBeanImpl.setTransactionTimeout(jMSConnectionFactoryMBeanImpl2.getTransactionTimeout());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else if (string.equals("FlowControlEnabled")) {
                    jMSConnectionFactoryMBeanImpl.setFlowControlEnabled(jMSConnectionFactoryMBeanImpl2.isFlowControlEnabled());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 28);
                } else if (string.equals("LoadBalancingEnabled")) {
                    jMSConnectionFactoryMBeanImpl.setLoadBalancingEnabled(jMSConnectionFactoryMBeanImpl2.isLoadBalancingEnabled());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 29);
                } else if (string.equals("ServerAffinityEnabled")) {
                    jMSConnectionFactoryMBeanImpl.setServerAffinityEnabled(jMSConnectionFactoryMBeanImpl2.isServerAffinityEnabled());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 30);
                } else if (string.equals("UserTransactionsEnabled")) {
                    jMSConnectionFactoryMBeanImpl.setUserTransactionsEnabled(jMSConnectionFactoryMBeanImpl2.isUserTransactionsEnabled());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                } else if (string.equals("XAConnectionFactoryEnabled")) {
                    jMSConnectionFactoryMBeanImpl.setXAConnectionFactoryEnabled(jMSConnectionFactoryMBeanImpl2.isXAConnectionFactoryEnabled());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                } else if (string.equals("XAServerEnabled")) {
                    jMSConnectionFactoryMBeanImpl.setXAServerEnabled(jMSConnectionFactoryMBeanImpl2.isXAServerEnabled());
                    jMSConnectionFactoryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 31);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                JMSConnectionFactoryMBeanImpl jMSConnectionFactoryMBeanImpl = (JMSConnectionFactoryMBeanImpl)abstractDescriptorBean;
                super.finishCopy(jMSConnectionFactoryMBeanImpl, bl, list);
                if (bl && (list == null || !list.contains("AcknowledgePolicy")) && this.bean.isAcknowledgePolicySet()) {
                    jMSConnectionFactoryMBeanImpl.setAcknowledgePolicy(this.bean.getAcknowledgePolicy());
                }
                if (bl && (list == null || !list.contains("AllowCloseInOnMessage")) && this.bean.isAllowCloseInOnMessageSet()) {
                    jMSConnectionFactoryMBeanImpl.setAllowCloseInOnMessage(this.bean.getAllowCloseInOnMessage());
                }
                if (bl && (list == null || !list.contains("ClientId")) && this.bean.isClientIdSet()) {
                    jMSConnectionFactoryMBeanImpl.setClientId(this.bean.getClientId());
                }
                if (bl && (list == null || !list.contains("DefaultDeliveryMode")) && this.bean.isDefaultDeliveryModeSet()) {
                    jMSConnectionFactoryMBeanImpl.setDefaultDeliveryMode(this.bean.getDefaultDeliveryMode());
                }
                if (bl && (list == null || !list.contains("DefaultPriority")) && this.bean.isDefaultPrioritySet()) {
                    jMSConnectionFactoryMBeanImpl.setDefaultPriority(this.bean.getDefaultPriority());
                }
                if (bl && (list == null || !list.contains("DefaultRedeliveryDelay")) && this.bean.isDefaultRedeliveryDelaySet()) {
                    jMSConnectionFactoryMBeanImpl.setDefaultRedeliveryDelay(this.bean.getDefaultRedeliveryDelay());
                }
                if (bl && (list == null || !list.contains("DefaultTimeToDeliver")) && this.bean.isDefaultTimeToDeliverSet()) {
                    jMSConnectionFactoryMBeanImpl.setDefaultTimeToDeliver(this.bean.getDefaultTimeToDeliver());
                }
                if (bl && (list == null || !list.contains("DefaultTimeToLive")) && this.bean.isDefaultTimeToLiveSet()) {
                    jMSConnectionFactoryMBeanImpl.setDefaultTimeToLive(this.bean.getDefaultTimeToLive());
                }
                if (bl && (list == null || !list.contains("FlowInterval")) && this.bean.isFlowIntervalSet()) {
                    jMSConnectionFactoryMBeanImpl.setFlowInterval(this.bean.getFlowInterval());
                }
                if (bl && (list == null || !list.contains("FlowMaximum")) && this.bean.isFlowMaximumSet()) {
                    jMSConnectionFactoryMBeanImpl.setFlowMaximum(this.bean.getFlowMaximum());
                }
                if (bl && (list == null || !list.contains("FlowMinimum")) && this.bean.isFlowMinimumSet()) {
                    jMSConnectionFactoryMBeanImpl.setFlowMinimum(this.bean.getFlowMinimum());
                }
                if (bl && (list == null || !list.contains("FlowSteps")) && this.bean.isFlowStepsSet()) {
                    jMSConnectionFactoryMBeanImpl.setFlowSteps(this.bean.getFlowSteps());
                }
                if (bl && (list == null || !list.contains("JNDIName")) && this.bean.isJNDINameSet()) {
                    jMSConnectionFactoryMBeanImpl.setJNDIName(this.bean.getJNDIName());
                }
                if (bl && (list == null || !list.contains("MessagesMaximum")) && this.bean.isMessagesMaximumSet()) {
                    jMSConnectionFactoryMBeanImpl.setMessagesMaximum(this.bean.getMessagesMaximum());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    jMSConnectionFactoryMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("Notes")) && this.bean.isNotesSet()) {
                    jMSConnectionFactoryMBeanImpl.setNotes(this.bean.getNotes());
                }
                if (bl && (list == null || !list.contains("OverrunPolicy")) && this.bean.isOverrunPolicySet()) {
                    jMSConnectionFactoryMBeanImpl.setOverrunPolicy(this.bean.getOverrunPolicy());
                }
                if (bl && (list == null || !list.contains("SendTimeout")) && this.bean.isSendTimeoutSet()) {
                    jMSConnectionFactoryMBeanImpl.setSendTimeout(this.bean.getSendTimeout());
                }
                if ((list == null || !list.contains("Targets")) && this.bean.isTargetsSet()) {
                    jMSConnectionFactoryMBeanImpl._unSet(jMSConnectionFactoryMBeanImpl, 7);
                    jMSConnectionFactoryMBeanImpl.setTargetsAsString(this.bean.getTargetsAsString());
                }
                if (bl && (list == null || !list.contains("TransactionTimeout")) && this.bean.isTransactionTimeoutSet()) {
                    jMSConnectionFactoryMBeanImpl.setTransactionTimeout(this.bean.getTransactionTimeout());
                }
                if (bl && (list == null || !list.contains("FlowControlEnabled")) && this.bean.isFlowControlEnabledSet()) {
                    jMSConnectionFactoryMBeanImpl.setFlowControlEnabled(this.bean.isFlowControlEnabled());
                }
                if (bl && (list == null || !list.contains("LoadBalancingEnabled")) && this.bean.isLoadBalancingEnabledSet()) {
                    jMSConnectionFactoryMBeanImpl.setLoadBalancingEnabled(this.bean.isLoadBalancingEnabled());
                }
                if (bl && (list == null || !list.contains("ServerAffinityEnabled")) && this.bean.isServerAffinityEnabledSet()) {
                    jMSConnectionFactoryMBeanImpl.setServerAffinityEnabled(this.bean.isServerAffinityEnabled());
                }
                if (bl && (list == null || !list.contains("UserTransactionsEnabled")) && this.bean.isUserTransactionsEnabledSet()) {
                    jMSConnectionFactoryMBeanImpl.setUserTransactionsEnabled(this.bean.isUserTransactionsEnabled());
                }
                if (bl && (list == null || !list.contains("XAConnectionFactoryEnabled")) && this.bean.isXAConnectionFactoryEnabledSet()) {
                    jMSConnectionFactoryMBeanImpl.setXAConnectionFactoryEnabled(this.bean.isXAConnectionFactoryEnabled());
                }
                if (bl && (list == null || !list.contains("XAServerEnabled")) && this.bean.isXAServerEnabledSet()) {
                    jMSConnectionFactoryMBeanImpl.setXAServerEnabled(this.bean.isXAServerEnabled());
                }
                return jMSConnectionFactoryMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getTargets(), clazz, object);
        }
    }
}

