/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BootstrapProperties;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.jms.module.validators.JMSModuleValidator;
import weblogic.management.DistributedManagementException;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.JMSDestCommonMBean;
import weblogic.management.configuration.JMSDestinationKeyMBean;
import weblogic.management.configuration.JMSDestinationKeyMBeanImpl;
import weblogic.management.configuration.JMSDestinationMBean;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class JMSDestCommonMBeanImpl
extends ConfigurationMBeanImpl
implements JMSDestCommonMBean,
Serializable {
    private long _BytesMaximum;
    private long _BytesThresholdHigh;
    private long _BytesThresholdLow;
    private long _CreationTime;
    private String _DeliveryModeOverride;
    private JMSDestinationKeyMBean[] _DestinationKeys;
    private JMSDestinationMBean _ErrorDestination;
    private String _ExpirationLoggingPolicy;
    private String _ExpirationPolicy;
    private int _MaximumMessageSize;
    private long _MessagesMaximum;
    private long _MessagesThresholdHigh;
    private long _MessagesThresholdLow;
    private int _PriorityOverride;
    private long _RedeliveryDelayOverride;
    private int _RedeliveryLimit;
    private String _TimeToDeliverOverride;
    private long _TimeToLiveOverride;
    private static SchemaHelper2 _schemaHelper;

    public JMSDestCommonMBeanImpl() {
        this._initializeProperty(-1);
    }

    public JMSDestCommonMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public JMSDestinationKeyMBean[] getDestinationKeys() {
        return this._DestinationKeys;
    }

    public String getDestinationKeysAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getDestinationKeys());
    }

    public boolean isDestinationKeysSet() {
        return this._isSet(7);
    }

    public void setDestinationKeysAsString(String string) {
        if (string == null || string.length() == 0) {
            JMSDestinationKeyMBean[] jMSDestinationKeyMBeanArray = this._DestinationKeys;
            this._initializeProperty(7);
            this._postSet(7, jMSDestinationKeyMBeanArray, this._DestinationKeys);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._DestinationKeys);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, JMSDestinationKeyMBean.class, new ReferenceManager.Resolver(this, 7){

                    public void resolveReference(Object object) {
                        try {
                            JMSDestCommonMBeanImpl.this.addDestinationKey((JMSDestinationKeyMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (JMSDestinationKeyMBean jMSDestinationKeyMBean : this._DestinationKeys) {
                    if (!string2.equals(jMSDestinationKeyMBean.getName())) continue;
                    try {
                        this.removeDestinationKey(jMSDestinationKeyMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public boolean addDestinationKey(JMSDestinationKeyMBean jMSDestinationKeyMBean) {
        this._getHelper()._ensureNonNull((Object)jMSDestinationKeyMBean);
        if (!((AbstractDescriptorBean)jMSDestinationKeyMBean).isChildProperty((DescriptorBean)this, 7)) {
            JMSDestinationKeyMBean[] jMSDestinationKeyMBeanArray = this._isSet(7) ? (JMSDestinationKeyMBean[])this._getHelper()._extendArray((Object)this.getDestinationKeys(), JMSDestinationKeyMBean.class, (Object)jMSDestinationKeyMBean) : new JMSDestinationKeyMBean[]{jMSDestinationKeyMBean};
            try {
                this.setDestinationKeys(jMSDestinationKeyMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public void setDestinationKeys(JMSDestinationKeyMBean[] jMSDestinationKeyMBeanArray) throws InvalidAttributeValueException {
        jMSDestinationKeyMBeanArray = jMSDestinationKeyMBeanArray == null ? new JMSDestinationKeyMBeanImpl[]{} : jMSDestinationKeyMBeanArray;
        JMSDestinationKeyMBean[] jMSDestinationKeyMBeanArray2 = this._DestinationKeys;
        this._DestinationKeys = jMSDestinationKeyMBeanArray;
        this._postSet(7, jMSDestinationKeyMBeanArray2, jMSDestinationKeyMBeanArray);
    }

    public boolean removeDestinationKey(JMSDestinationKeyMBean jMSDestinationKeyMBean) {
        JMSDestinationKeyMBean[] jMSDestinationKeyMBeanArray = this.getDestinationKeys();
        JMSDestinationKeyMBean[] jMSDestinationKeyMBeanArray2 = (JMSDestinationKeyMBean[])this._getHelper()._removeElement((Object)jMSDestinationKeyMBeanArray, JMSDestinationKeyMBean.class, (Object)jMSDestinationKeyMBean);
        if (jMSDestinationKeyMBeanArray2.length != jMSDestinationKeyMBeanArray.length) {
            try {
                this.setDestinationKeys(jMSDestinationKeyMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public long getBytesMaximum() {
        return this._BytesMaximum;
    }

    public boolean isBytesMaximumSet() {
        return this._isSet(8);
    }

    public void setBytesMaximum(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"BytesMaximum", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this._BytesMaximum;
        this._BytesMaximum = l;
        this._postSet(8, l2, l);
    }

    public long getBytesThresholdHigh() {
        return this._BytesThresholdHigh;
    }

    public boolean isBytesThresholdHighSet() {
        return this._isSet(9);
    }

    public void setBytesThresholdHigh(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"BytesThresholdHigh", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this._BytesThresholdHigh;
        this._BytesThresholdHigh = l;
        this._postSet(9, l2, l);
    }

    public long getBytesThresholdLow() {
        return this._BytesThresholdLow;
    }

    public boolean isBytesThresholdLowSet() {
        return this._isSet(10);
    }

    public void setBytesThresholdLow(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"BytesThresholdLow", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this._BytesThresholdLow;
        this._BytesThresholdLow = l;
        this._postSet(10, l2, l);
    }

    public long getMessagesMaximum() {
        return this._MessagesMaximum;
    }

    public boolean isMessagesMaximumSet() {
        return this._isSet(11);
    }

    public void setMessagesMaximum(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MessagesMaximum", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this._MessagesMaximum;
        this._MessagesMaximum = l;
        this._postSet(11, l2, l);
    }

    public long getMessagesThresholdHigh() {
        return this._MessagesThresholdHigh;
    }

    public boolean isMessagesThresholdHighSet() {
        return this._isSet(12);
    }

    public void setMessagesThresholdHigh(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MessagesThresholdHigh", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this._MessagesThresholdHigh;
        this._MessagesThresholdHigh = l;
        this._postSet(12, l2, l);
    }

    public long getMessagesThresholdLow() {
        return this._MessagesThresholdLow;
    }

    public boolean isMessagesThresholdLowSet() {
        return this._isSet(13);
    }

    public void setMessagesThresholdLow(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MessagesThresholdLow", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this._MessagesThresholdLow;
        this._MessagesThresholdLow = l;
        this._postSet(13, l2, l);
    }

    public int getPriorityOverride() {
        return this._PriorityOverride;
    }

    public boolean isPriorityOverrideSet() {
        return this._isSet(14);
    }

    public void setPriorityOverride(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"PriorityOverride", (long)n, (long)-1L, (long)9L);
        int n2 = this._PriorityOverride;
        this._PriorityOverride = n;
        this._postSet(14, n2, n);
    }

    public String getTimeToDeliverOverride() {
        return this._TimeToDeliverOverride;
    }

    public boolean isTimeToDeliverOverrideSet() {
        return this._isSet(15);
    }

    public void setTimeToDeliverOverride(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        JMSModuleValidator.validateTimeToDeliverOverride(string);
        String string2 = this._TimeToDeliverOverride;
        this._TimeToDeliverOverride = string;
        this._postSet(15, string2, string);
    }

    public long getRedeliveryDelayOverride() {
        return this._RedeliveryDelayOverride;
    }

    public boolean isRedeliveryDelayOverrideSet() {
        return this._isSet(16);
    }

    public void setRedeliveryDelayOverride(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"RedeliveryDelayOverride", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this._RedeliveryDelayOverride;
        this._RedeliveryDelayOverride = l;
        this._postSet(16, l2, l);
    }

    public void setErrorDestination(JMSDestinationMBean jMSDestinationMBean) throws InvalidAttributeValueException, DistributedManagementException {
        JMSDestinationMBean jMSDestinationMBean2 = this._ErrorDestination;
        this._ErrorDestination = jMSDestinationMBean;
        this._postSet(17, jMSDestinationMBean2, jMSDestinationMBean);
    }

    public JMSDestinationMBean getErrorDestination() {
        return this._ErrorDestination;
    }

    public String getErrorDestinationAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getErrorDestination();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isErrorDestinationSet() {
        return this._isSet(17);
    }

    public void setErrorDestinationAsString(String string) {
        if (string == null || string.length() == 0) {
            JMSDestinationMBean jMSDestinationMBean = this._ErrorDestination;
            this._initializeProperty(17);
            this._postSet(17, jMSDestinationMBean, this._ErrorDestination);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, JMSDestinationMBean.class, new ReferenceManager.Resolver(this, 17){

                public void resolveReference(Object object) {
                    try {
                        JMSDestCommonMBeanImpl.this.setErrorDestination((JMSDestinationMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public int getRedeliveryLimit() {
        return this._RedeliveryLimit;
    }

    public boolean isRedeliveryLimitSet() {
        return this._isSet(18);
    }

    public void setRedeliveryLimit(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"RedeliveryLimit", (long)n, (long)-1L, (long)Integer.MAX_VALUE);
        int n2 = this._RedeliveryLimit;
        this._RedeliveryLimit = n;
        this._postSet(18, n2, n);
    }

    public long getTimeToLiveOverride() {
        return this._TimeToLiveOverride;
    }

    public boolean isTimeToLiveOverrideSet() {
        return this._isSet(19);
    }

    public void setTimeToLiveOverride(long l) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"TimeToLiveOverride", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this._TimeToLiveOverride;
        this._TimeToLiveOverride = l;
        this._postSet(19, l2, l);
    }

    public String getDeliveryModeOverride() {
        return this._DeliveryModeOverride;
    }

    public boolean isDeliveryModeOverrideSet() {
        return this._isSet(20);
    }

    public void setDeliveryModeOverride(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Persistent", "Non-Persistent", "No-Delivery"};
        string = LegalChecks.checkInEnum((String)"DeliveryModeOverride", (String)string, (String[])stringArray);
        String string2 = this._DeliveryModeOverride;
        this._DeliveryModeOverride = string;
        this._postSet(20, string2, string);
    }

    public void setExpirationPolicy(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Discard", "Log", "Redirect"};
        string = LegalChecks.checkInEnum((String)"ExpirationPolicy", (String)string, (String[])stringArray);
        String string2 = this._ExpirationPolicy;
        this._ExpirationPolicy = string;
        this._postSet(21, string2, string);
    }

    public String getExpirationPolicy() {
        return this._ExpirationPolicy;
    }

    public boolean isExpirationPolicySet() {
        return this._isSet(21);
    }

    public void setExpirationLoggingPolicy(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ExpirationLoggingPolicy;
        this._ExpirationLoggingPolicy = string;
        this._postSet(22, string2, string);
    }

    public String getExpirationLoggingPolicy() {
        return this._ExpirationLoggingPolicy;
    }

    public boolean isExpirationLoggingPolicySet() {
        return this._isSet(22);
    }

    public int getMaximumMessageSize() {
        return this._MaximumMessageSize;
    }

    public boolean isMaximumMessageSizeSet() {
        return this._isSet(23);
    }

    public void setMaximumMessageSize(int n) throws InvalidAttributeValueException, DistributedManagementException {
        LegalChecks.checkInRange((String)"MaximumMessageSize", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._MaximumMessageSize;
        this._MaximumMessageSize = n;
        this._postSet(23, n2, n);
    }

    public long getCreationTime() {
        return this._CreationTime;
    }

    public boolean isCreationTimeSet() {
        return this._isSet(24);
    }

    public void setCreationTime(long l) {
        long l2 = this._CreationTime;
        this._CreationTime = l;
        this._postSet(24, l2, l);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 8;
        }
        try {
            switch (n) {
                case 8: {
                    this._BytesMaximum = -1L;
                    if (bl) break;
                }
                case 9: {
                    this._BytesThresholdHigh = -1L;
                    if (bl) break;
                }
                case 10: {
                    this._BytesThresholdLow = -1L;
                    if (bl) break;
                }
                case 24: {
                    this._CreationTime = 1L;
                    if (bl) break;
                }
                case 20: {
                    this._DeliveryModeOverride = "No-Delivery";
                    if (bl) break;
                }
                case 7: {
                    this._DestinationKeys = new JMSDestinationKeyMBean[0];
                    if (bl) break;
                }
                case 17: {
                    this._ErrorDestination = null;
                    if (bl) break;
                }
                case 22: {
                    this._ExpirationLoggingPolicy = null;
                    if (bl) break;
                }
                case 21: {
                    this._ExpirationPolicy = "Discard";
                    if (bl) break;
                }
                case 23: {
                    this._MaximumMessageSize = Integer.MAX_VALUE;
                    if (bl) break;
                }
                case 11: {
                    this._MessagesMaximum = -1L;
                    if (bl) break;
                }
                case 12: {
                    this._MessagesThresholdHigh = -1L;
                    if (bl) break;
                }
                case 13: {
                    this._MessagesThresholdLow = -1L;
                    if (bl) break;
                }
                case 14: {
                    this._PriorityOverride = -1;
                    if (bl) break;
                }
                case 16: {
                    this._RedeliveryDelayOverride = -1L;
                    if (bl) break;
                }
                case 18: {
                    this._RedeliveryLimit = -1;
                    if (bl) break;
                }
                case 15: {
                    this._TimeToDeliverOverride = "-1";
                    if (bl) break;
                }
                case 19: {
                    this._TimeToLiveOverride = -1L;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "JMSDestCommon";
    }

    public void putValue(String string, Object object) {
        if (string.equals("BytesMaximum")) {
            long l = this._BytesMaximum;
            this._BytesMaximum = (Long)object;
            this._postSet(8, l, this._BytesMaximum);
            return;
        }
        if (string.equals("BytesThresholdHigh")) {
            long l = this._BytesThresholdHigh;
            this._BytesThresholdHigh = (Long)object;
            this._postSet(9, l, this._BytesThresholdHigh);
            return;
        }
        if (string.equals("BytesThresholdLow")) {
            long l = this._BytesThresholdLow;
            this._BytesThresholdLow = (Long)object;
            this._postSet(10, l, this._BytesThresholdLow);
            return;
        }
        if (string.equals("CreationTime")) {
            long l = this._CreationTime;
            this._CreationTime = (Long)object;
            this._postSet(24, l, this._CreationTime);
            return;
        }
        if (string.equals("DeliveryModeOverride")) {
            String string2 = this._DeliveryModeOverride;
            this._DeliveryModeOverride = (String)object;
            this._postSet(20, string2, this._DeliveryModeOverride);
            return;
        }
        if (string.equals("DestinationKeys")) {
            JMSDestinationKeyMBean[] jMSDestinationKeyMBeanArray = this._DestinationKeys;
            this._DestinationKeys = (JMSDestinationKeyMBean[])object;
            this._postSet(7, jMSDestinationKeyMBeanArray, this._DestinationKeys);
            return;
        }
        if (string.equals("ErrorDestination")) {
            JMSDestinationMBean jMSDestinationMBean = this._ErrorDestination;
            this._ErrorDestination = (JMSDestinationMBean)object;
            this._postSet(17, jMSDestinationMBean, this._ErrorDestination);
            return;
        }
        if (string.equals("ExpirationLoggingPolicy")) {
            String string3 = this._ExpirationLoggingPolicy;
            this._ExpirationLoggingPolicy = (String)object;
            this._postSet(22, string3, this._ExpirationLoggingPolicy);
            return;
        }
        if (string.equals("ExpirationPolicy")) {
            String string4 = this._ExpirationPolicy;
            this._ExpirationPolicy = (String)object;
            this._postSet(21, string4, this._ExpirationPolicy);
            return;
        }
        if (string.equals("MaximumMessageSize")) {
            int n = this._MaximumMessageSize;
            this._MaximumMessageSize = (Integer)object;
            this._postSet(23, n, this._MaximumMessageSize);
            return;
        }
        if (string.equals("MessagesMaximum")) {
            long l = this._MessagesMaximum;
            this._MessagesMaximum = (Long)object;
            this._postSet(11, l, this._MessagesMaximum);
            return;
        }
        if (string.equals("MessagesThresholdHigh")) {
            long l = this._MessagesThresholdHigh;
            this._MessagesThresholdHigh = (Long)object;
            this._postSet(12, l, this._MessagesThresholdHigh);
            return;
        }
        if (string.equals("MessagesThresholdLow")) {
            long l = this._MessagesThresholdLow;
            this._MessagesThresholdLow = (Long)object;
            this._postSet(13, l, this._MessagesThresholdLow);
            return;
        }
        if (string.equals("PriorityOverride")) {
            int n = this._PriorityOverride;
            this._PriorityOverride = (Integer)object;
            this._postSet(14, n, this._PriorityOverride);
            return;
        }
        if (string.equals("RedeliveryDelayOverride")) {
            long l = this._RedeliveryDelayOverride;
            this._RedeliveryDelayOverride = (Long)object;
            this._postSet(16, l, this._RedeliveryDelayOverride);
            return;
        }
        if (string.equals("RedeliveryLimit")) {
            int n = this._RedeliveryLimit;
            this._RedeliveryLimit = (Integer)object;
            this._postSet(18, n, this._RedeliveryLimit);
            return;
        }
        if (string.equals("TimeToDeliverOverride")) {
            String string5 = this._TimeToDeliverOverride;
            this._TimeToDeliverOverride = (String)object;
            this._postSet(15, string5, this._TimeToDeliverOverride);
            return;
        }
        if (string.equals("TimeToLiveOverride")) {
            long l = this._TimeToLiveOverride;
            this._TimeToLiveOverride = (Long)object;
            this._postSet(19, l, this._TimeToLiveOverride);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("BytesMaximum")) {
            return new Long(this._BytesMaximum);
        }
        if (string.equals("BytesThresholdHigh")) {
            return new Long(this._BytesThresholdHigh);
        }
        if (string.equals("BytesThresholdLow")) {
            return new Long(this._BytesThresholdLow);
        }
        if (string.equals("CreationTime")) {
            return new Long(this._CreationTime);
        }
        if (string.equals("DeliveryModeOverride")) {
            return this._DeliveryModeOverride;
        }
        if (string.equals("DestinationKeys")) {
            return this._DestinationKeys;
        }
        if (string.equals("ErrorDestination")) {
            return this._ErrorDestination;
        }
        if (string.equals("ExpirationLoggingPolicy")) {
            return this._ExpirationLoggingPolicy;
        }
        if (string.equals("ExpirationPolicy")) {
            return this._ExpirationPolicy;
        }
        if (string.equals("MaximumMessageSize")) {
            return new Integer(this._MaximumMessageSize);
        }
        if (string.equals("MessagesMaximum")) {
            return new Long(this._MessagesMaximum);
        }
        if (string.equals("MessagesThresholdHigh")) {
            return new Long(this._MessagesThresholdHigh);
        }
        if (string.equals("MessagesThresholdLow")) {
            return new Long(this._MessagesThresholdLow);
        }
        if (string.equals("PriorityOverride")) {
            return new Integer(this._PriorityOverride);
        }
        if (string.equals("RedeliveryDelayOverride")) {
            return new Long(this._RedeliveryDelayOverride);
        }
        if (string.equals("RedeliveryLimit")) {
            return new Integer(this._RedeliveryLimit);
        }
        if (string.equals("TimeToDeliverOverride")) {
            return this._TimeToDeliverOverride;
        }
        if (string.equals("TimeToLiveOverride")) {
            return new Long(this._TimeToLiveOverride);
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 13: {
                    if (string.equals("bytes-maximum")) {
                        return 8;
                    }
                    if (!string.equals("creation-time")) break;
                    return 24;
                }
                case 20: {
                    if (string.equals("bytes-threshold-high")) {
                        return 9;
                    }
                    if (!string.equals("maximum-message-size")) break;
                    return 23;
                }
                case 19: {
                    if (!string.equals("bytes-threshold-low")) break;
                    return 10;
                }
                case 22: {
                    if (string.equals("delivery-mode-override")) {
                        return 20;
                    }
                    if (!string.equals("messages-threshold-low")) break;
                    return 13;
                }
                case 15: {
                    if (!string.equals("destination-key")) break;
                    return 7;
                }
                case 17: {
                    if (string.equals("error-destination")) {
                        return 17;
                    }
                    if (string.equals("expiration-policy")) {
                        return 21;
                    }
                    if (!string.equals("priority-override")) break;
                    return 14;
                }
                case 25: {
                    if (string.equals("expiration-logging-policy")) {
                        return 22;
                    }
                    if (!string.equals("redelivery-delay-override")) break;
                    return 16;
                }
                case 16: {
                    if (string.equals("messages-maximum")) {
                        return 11;
                    }
                    if (!string.equals("redelivery-limit")) break;
                    return 18;
                }
                case 23: {
                    if (!string.equals("messages-threshold-high")) break;
                    return 12;
                }
                case 24: {
                    if (!string.equals("time-to-deliver-override")) break;
                    return 15;
                }
                case 21: {
                    if (!string.equals("time-to-live-override")) break;
                    return 19;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 8: {
                    return "bytes-maximum";
                }
                case 9: {
                    return "bytes-threshold-high";
                }
                case 10: {
                    return "bytes-threshold-low";
                }
                case 24: {
                    return "creation-time";
                }
                case 20: {
                    return "delivery-mode-override";
                }
                case 7: {
                    return "destination-key";
                }
                case 17: {
                    return "error-destination";
                }
                case 22: {
                    return "expiration-logging-policy";
                }
                case 21: {
                    return "expiration-policy";
                }
                case 23: {
                    return "maximum-message-size";
                }
                case 11: {
                    return "messages-maximum";
                }
                case 12: {
                    return "messages-threshold-high";
                }
                case 13: {
                    return "messages-threshold-low";
                }
                case 14: {
                    return "priority-override";
                }
                case 16: {
                    return "redelivery-delay-override";
                }
                case 18: {
                    return "redelivery-limit";
                }
                case 15: {
                    return "time-to-deliver-override";
                }
                case 19: {
                    return "time-to-live-override";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 7: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private JMSDestCommonMBeanImpl bean;

        protected Helper(JMSDestCommonMBeanImpl jMSDestCommonMBeanImpl) {
            super(jMSDestCommonMBeanImpl);
            this.bean = jMSDestCommonMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 8: {
                    return "BytesMaximum";
                }
                case 9: {
                    return "BytesThresholdHigh";
                }
                case 10: {
                    return "BytesThresholdLow";
                }
                case 24: {
                    return "CreationTime";
                }
                case 20: {
                    return "DeliveryModeOverride";
                }
                case 7: {
                    return "DestinationKeys";
                }
                case 17: {
                    return "ErrorDestination";
                }
                case 22: {
                    return "ExpirationLoggingPolicy";
                }
                case 21: {
                    return "ExpirationPolicy";
                }
                case 23: {
                    return "MaximumMessageSize";
                }
                case 11: {
                    return "MessagesMaximum";
                }
                case 12: {
                    return "MessagesThresholdHigh";
                }
                case 13: {
                    return "MessagesThresholdLow";
                }
                case 14: {
                    return "PriorityOverride";
                }
                case 16: {
                    return "RedeliveryDelayOverride";
                }
                case 18: {
                    return "RedeliveryLimit";
                }
                case 15: {
                    return "TimeToDeliverOverride";
                }
                case 19: {
                    return "TimeToLiveOverride";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("BytesMaximum")) {
                return 8;
            }
            if (string.equals("BytesThresholdHigh")) {
                return 9;
            }
            if (string.equals("BytesThresholdLow")) {
                return 10;
            }
            if (string.equals("CreationTime")) {
                return 24;
            }
            if (string.equals("DeliveryModeOverride")) {
                return 20;
            }
            if (string.equals("DestinationKeys")) {
                return 7;
            }
            if (string.equals("ErrorDestination")) {
                return 17;
            }
            if (string.equals("ExpirationLoggingPolicy")) {
                return 22;
            }
            if (string.equals("ExpirationPolicy")) {
                return 21;
            }
            if (string.equals("MaximumMessageSize")) {
                return 23;
            }
            if (string.equals("MessagesMaximum")) {
                return 11;
            }
            if (string.equals("MessagesThresholdHigh")) {
                return 12;
            }
            if (string.equals("MessagesThresholdLow")) {
                return 13;
            }
            if (string.equals("PriorityOverride")) {
                return 14;
            }
            if (string.equals("RedeliveryDelayOverride")) {
                return 16;
            }
            if (string.equals("RedeliveryLimit")) {
                return 18;
            }
            if (string.equals("TimeToDeliverOverride")) {
                return 15;
            }
            if (string.equals("TimeToLiveOverride")) {
                return 19;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isBytesMaximumSet()) {
                    stringBuffer.append("BytesMaximum");
                    stringBuffer.append(String.valueOf(this.bean.getBytesMaximum()));
                }
                if (this.bean.isBytesThresholdHighSet()) {
                    stringBuffer.append("BytesThresholdHigh");
                    stringBuffer.append(String.valueOf(this.bean.getBytesThresholdHigh()));
                }
                if (this.bean.isBytesThresholdLowSet()) {
                    stringBuffer.append("BytesThresholdLow");
                    stringBuffer.append(String.valueOf(this.bean.getBytesThresholdLow()));
                }
                if (this.bean.isCreationTimeSet()) {
                    stringBuffer.append("CreationTime");
                    stringBuffer.append(String.valueOf(this.bean.getCreationTime()));
                }
                if (this.bean.isDeliveryModeOverrideSet()) {
                    stringBuffer.append("DeliveryModeOverride");
                    stringBuffer.append(String.valueOf(this.bean.getDeliveryModeOverride()));
                }
                if (this.bean.isDestinationKeysSet()) {
                    stringBuffer.append("DestinationKeys");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getDestinationKeys())));
                }
                if (this.bean.isErrorDestinationSet()) {
                    stringBuffer.append("ErrorDestination");
                    stringBuffer.append(String.valueOf(this.bean.getErrorDestination()));
                }
                if (this.bean.isExpirationLoggingPolicySet()) {
                    stringBuffer.append("ExpirationLoggingPolicy");
                    stringBuffer.append(String.valueOf(this.bean.getExpirationLoggingPolicy()));
                }
                if (this.bean.isExpirationPolicySet()) {
                    stringBuffer.append("ExpirationPolicy");
                    stringBuffer.append(String.valueOf(this.bean.getExpirationPolicy()));
                }
                if (this.bean.isMaximumMessageSizeSet()) {
                    stringBuffer.append("MaximumMessageSize");
                    stringBuffer.append(String.valueOf(this.bean.getMaximumMessageSize()));
                }
                if (this.bean.isMessagesMaximumSet()) {
                    stringBuffer.append("MessagesMaximum");
                    stringBuffer.append(String.valueOf(this.bean.getMessagesMaximum()));
                }
                if (this.bean.isMessagesThresholdHighSet()) {
                    stringBuffer.append("MessagesThresholdHigh");
                    stringBuffer.append(String.valueOf(this.bean.getMessagesThresholdHigh()));
                }
                if (this.bean.isMessagesThresholdLowSet()) {
                    stringBuffer.append("MessagesThresholdLow");
                    stringBuffer.append(String.valueOf(this.bean.getMessagesThresholdLow()));
                }
                if (this.bean.isPriorityOverrideSet()) {
                    stringBuffer.append("PriorityOverride");
                    stringBuffer.append(String.valueOf(this.bean.getPriorityOverride()));
                }
                if (this.bean.isRedeliveryDelayOverrideSet()) {
                    stringBuffer.append("RedeliveryDelayOverride");
                    stringBuffer.append(String.valueOf(this.bean.getRedeliveryDelayOverride()));
                }
                if (this.bean.isRedeliveryLimitSet()) {
                    stringBuffer.append("RedeliveryLimit");
                    stringBuffer.append(String.valueOf(this.bean.getRedeliveryLimit()));
                }
                if (this.bean.isTimeToDeliverOverrideSet()) {
                    stringBuffer.append("TimeToDeliverOverride");
                    stringBuffer.append(String.valueOf(this.bean.getTimeToDeliverOverride()));
                }
                if (this.bean.isTimeToLiveOverrideSet()) {
                    stringBuffer.append("TimeToLiveOverride");
                    stringBuffer.append(String.valueOf(this.bean.getTimeToLiveOverride()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                JMSDestCommonMBeanImpl jMSDestCommonMBeanImpl = (JMSDestCommonMBeanImpl)abstractDescriptorBean;
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("BytesMaximum", this.bean.getBytesMaximum(), jMSDestCommonMBeanImpl.getBytesMaximum(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("BytesThresholdHigh", this.bean.getBytesThresholdHigh(), jMSDestCommonMBeanImpl.getBytesThresholdHigh(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("BytesThresholdLow", this.bean.getBytesThresholdLow(), jMSDestCommonMBeanImpl.getBytesThresholdLow(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("CreationTime", this.bean.getCreationTime(), jMSDestCommonMBeanImpl.getCreationTime(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("DeliveryModeOverride", this.bean.getDeliveryModeOverride(), jMSDestCommonMBeanImpl.getDeliveryModeOverride(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("DestinationKeys", this.bean.getDestinationKeys(), jMSDestCommonMBeanImpl.getDestinationKeys(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ErrorDestination", this.bean.getErrorDestination(), jMSDestCommonMBeanImpl.getErrorDestination(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ExpirationLoggingPolicy", this.bean.getExpirationLoggingPolicy(), jMSDestCommonMBeanImpl.getExpirationLoggingPolicy(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ExpirationPolicy", this.bean.getExpirationPolicy(), jMSDestCommonMBeanImpl.getExpirationPolicy(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("MaximumMessageSize", this.bean.getMaximumMessageSize(), jMSDestCommonMBeanImpl.getMaximumMessageSize(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("MessagesMaximum", this.bean.getMessagesMaximum(), jMSDestCommonMBeanImpl.getMessagesMaximum(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("MessagesThresholdHigh", this.bean.getMessagesThresholdHigh(), jMSDestCommonMBeanImpl.getMessagesThresholdHigh(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("MessagesThresholdLow", this.bean.getMessagesThresholdLow(), jMSDestCommonMBeanImpl.getMessagesThresholdLow(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("PriorityOverride", this.bean.getPriorityOverride(), jMSDestCommonMBeanImpl.getPriorityOverride(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("RedeliveryDelayOverride", this.bean.getRedeliveryDelayOverride(), jMSDestCommonMBeanImpl.getRedeliveryDelayOverride(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("RedeliveryLimit", this.bean.getRedeliveryLimit(), jMSDestCommonMBeanImpl.getRedeliveryLimit(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("TimeToDeliverOverride", this.bean.getTimeToDeliverOverride(), jMSDestCommonMBeanImpl.getTimeToDeliverOverride(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("TimeToLiveOverride", this.bean.getTimeToLiveOverride(), jMSDestCommonMBeanImpl.getTimeToLiveOverride(), true);
                }
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                JMSDestCommonMBeanImpl jMSDestCommonMBeanImpl = (JMSDestCommonMBeanImpl)beanUpdateEvent.getSourceBean();
                JMSDestCommonMBeanImpl jMSDestCommonMBeanImpl2 = (JMSDestCommonMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("BytesMaximum")) {
                    jMSDestCommonMBeanImpl.setBytesMaximum(jMSDestCommonMBeanImpl2.getBytesMaximum());
                    jMSDestCommonMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("BytesThresholdHigh")) {
                    jMSDestCommonMBeanImpl.setBytesThresholdHigh(jMSDestCommonMBeanImpl2.getBytesThresholdHigh());
                    jMSDestCommonMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("BytesThresholdLow")) {
                    jMSDestCommonMBeanImpl.setBytesThresholdLow(jMSDestCommonMBeanImpl2.getBytesThresholdLow());
                    jMSDestCommonMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("CreationTime")) {
                    jMSDestCommonMBeanImpl.setCreationTime(jMSDestCommonMBeanImpl2.getCreationTime());
                    jMSDestCommonMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                } else if (string.equals("DeliveryModeOverride")) {
                    jMSDestCommonMBeanImpl.setDeliveryModeOverride(jMSDestCommonMBeanImpl2.getDeliveryModeOverride());
                    jMSDestCommonMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                } else if (string.equals("DestinationKeys")) {
                    jMSDestCommonMBeanImpl.setDestinationKeysAsString(jMSDestCommonMBeanImpl2.getDestinationKeysAsString());
                    jMSDestCommonMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("ErrorDestination")) {
                    jMSDestCommonMBeanImpl.setErrorDestinationAsString(jMSDestCommonMBeanImpl2.getErrorDestinationAsString());
                    jMSDestCommonMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else if (string.equals("ExpirationLoggingPolicy")) {
                    jMSDestCommonMBeanImpl.setExpirationLoggingPolicy(jMSDestCommonMBeanImpl2.getExpirationLoggingPolicy());
                    jMSDestCommonMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                } else if (string.equals("ExpirationPolicy")) {
                    jMSDestCommonMBeanImpl.setExpirationPolicy(jMSDestCommonMBeanImpl2.getExpirationPolicy());
                    jMSDestCommonMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                } else if (string.equals("MaximumMessageSize")) {
                    jMSDestCommonMBeanImpl.setMaximumMessageSize(jMSDestCommonMBeanImpl2.getMaximumMessageSize());
                    jMSDestCommonMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                } else if (string.equals("MessagesMaximum")) {
                    jMSDestCommonMBeanImpl.setMessagesMaximum(jMSDestCommonMBeanImpl2.getMessagesMaximum());
                    jMSDestCommonMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("MessagesThresholdHigh")) {
                    jMSDestCommonMBeanImpl.setMessagesThresholdHigh(jMSDestCommonMBeanImpl2.getMessagesThresholdHigh());
                    jMSDestCommonMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("MessagesThresholdLow")) {
                    jMSDestCommonMBeanImpl.setMessagesThresholdLow(jMSDestCommonMBeanImpl2.getMessagesThresholdLow());
                    jMSDestCommonMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("PriorityOverride")) {
                    jMSDestCommonMBeanImpl.setPriorityOverride(jMSDestCommonMBeanImpl2.getPriorityOverride());
                    jMSDestCommonMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("RedeliveryDelayOverride")) {
                    jMSDestCommonMBeanImpl.setRedeliveryDelayOverride(jMSDestCommonMBeanImpl2.getRedeliveryDelayOverride());
                    jMSDestCommonMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else if (string.equals("RedeliveryLimit")) {
                    jMSDestCommonMBeanImpl.setRedeliveryLimit(jMSDestCommonMBeanImpl2.getRedeliveryLimit());
                    jMSDestCommonMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                } else if (string.equals("TimeToDeliverOverride")) {
                    jMSDestCommonMBeanImpl.setTimeToDeliverOverride(jMSDestCommonMBeanImpl2.getTimeToDeliverOverride());
                    jMSDestCommonMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("TimeToLiveOverride")) {
                    jMSDestCommonMBeanImpl.setTimeToLiveOverride(jMSDestCommonMBeanImpl2.getTimeToLiveOverride());
                    jMSDestCommonMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                JMSDestCommonMBeanImpl jMSDestCommonMBeanImpl = (JMSDestCommonMBeanImpl)abstractDescriptorBean;
                super.finishCopy(jMSDestCommonMBeanImpl, bl, list);
                if (bl && (list == null || !list.contains("BytesMaximum")) && this.bean.isBytesMaximumSet()) {
                    jMSDestCommonMBeanImpl.setBytesMaximum(this.bean.getBytesMaximum());
                }
                if (bl && (list == null || !list.contains("BytesThresholdHigh")) && this.bean.isBytesThresholdHighSet()) {
                    jMSDestCommonMBeanImpl.setBytesThresholdHigh(this.bean.getBytesThresholdHigh());
                }
                if (bl && (list == null || !list.contains("BytesThresholdLow")) && this.bean.isBytesThresholdLowSet()) {
                    jMSDestCommonMBeanImpl.setBytesThresholdLow(this.bean.getBytesThresholdLow());
                }
                if (bl && (list == null || !list.contains("CreationTime")) && this.bean.isCreationTimeSet()) {
                    jMSDestCommonMBeanImpl.setCreationTime(this.bean.getCreationTime());
                }
                if (bl && (list == null || !list.contains("DeliveryModeOverride")) && this.bean.isDeliveryModeOverrideSet()) {
                    jMSDestCommonMBeanImpl.setDeliveryModeOverride(this.bean.getDeliveryModeOverride());
                }
                if (bl && (list == null || !list.contains("DestinationKeys")) && this.bean.isDestinationKeysSet()) {
                    jMSDestCommonMBeanImpl._unSet(jMSDestCommonMBeanImpl, 7);
                    jMSDestCommonMBeanImpl.setDestinationKeysAsString(this.bean.getDestinationKeysAsString());
                }
                if (bl && (list == null || !list.contains("ErrorDestination")) && this.bean.isErrorDestinationSet()) {
                    jMSDestCommonMBeanImpl._unSet(jMSDestCommonMBeanImpl, 17);
                    jMSDestCommonMBeanImpl.setErrorDestinationAsString(this.bean.getErrorDestinationAsString());
                }
                if (bl && (list == null || !list.contains("ExpirationLoggingPolicy")) && this.bean.isExpirationLoggingPolicySet()) {
                    jMSDestCommonMBeanImpl.setExpirationLoggingPolicy(this.bean.getExpirationLoggingPolicy());
                }
                if (bl && (list == null || !list.contains("ExpirationPolicy")) && this.bean.isExpirationPolicySet()) {
                    jMSDestCommonMBeanImpl.setExpirationPolicy(this.bean.getExpirationPolicy());
                }
                if (bl && (list == null || !list.contains("MaximumMessageSize")) && this.bean.isMaximumMessageSizeSet()) {
                    jMSDestCommonMBeanImpl.setMaximumMessageSize(this.bean.getMaximumMessageSize());
                }
                if (bl && (list == null || !list.contains("MessagesMaximum")) && this.bean.isMessagesMaximumSet()) {
                    jMSDestCommonMBeanImpl.setMessagesMaximum(this.bean.getMessagesMaximum());
                }
                if (bl && (list == null || !list.contains("MessagesThresholdHigh")) && this.bean.isMessagesThresholdHighSet()) {
                    jMSDestCommonMBeanImpl.setMessagesThresholdHigh(this.bean.getMessagesThresholdHigh());
                }
                if (bl && (list == null || !list.contains("MessagesThresholdLow")) && this.bean.isMessagesThresholdLowSet()) {
                    jMSDestCommonMBeanImpl.setMessagesThresholdLow(this.bean.getMessagesThresholdLow());
                }
                if (bl && (list == null || !list.contains("PriorityOverride")) && this.bean.isPriorityOverrideSet()) {
                    jMSDestCommonMBeanImpl.setPriorityOverride(this.bean.getPriorityOverride());
                }
                if (bl && (list == null || !list.contains("RedeliveryDelayOverride")) && this.bean.isRedeliveryDelayOverrideSet()) {
                    jMSDestCommonMBeanImpl.setRedeliveryDelayOverride(this.bean.getRedeliveryDelayOverride());
                }
                if (bl && (list == null || !list.contains("RedeliveryLimit")) && this.bean.isRedeliveryLimitSet()) {
                    jMSDestCommonMBeanImpl.setRedeliveryLimit(this.bean.getRedeliveryLimit());
                }
                if (bl && (list == null || !list.contains("TimeToDeliverOverride")) && this.bean.isTimeToDeliverOverrideSet()) {
                    jMSDestCommonMBeanImpl.setTimeToDeliverOverride(this.bean.getTimeToDeliverOverride());
                }
                if (bl && (list == null || !list.contains("TimeToLiveOverride")) && this.bean.isTimeToLiveOverrideSet()) {
                    jMSDestCommonMBeanImpl.setTimeToLiveOverride(this.bean.getTimeToLiveOverride());
                }
                return jMSDestCommonMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getDestinationKeys(), clazz, object);
            this.inferSubTree(this.bean.getErrorDestination(), clazz, object);
        }
    }
}

