/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanAlreadyExistsException;
import weblogic.descriptor.BeanRemoveRejectedException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BootstrapProperties;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.j2ee.descriptor.wl.DistributedQueueBean;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.JMSDistributedDestinationMBeanImpl;
import weblogic.management.configuration.JMSDistributedQueueMBean;
import weblogic.management.configuration.JMSDistributedQueueMemberMBean;
import weblogic.management.configuration.JMSDistributedQueueMemberMBeanImpl;
import weblogic.management.configuration.JMSTemplateMBean;
import weblogic.management.configuration.JMSTemplateMBeanImpl;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.TargetMBeanImpl;
import weblogic.management.mbeans.custom.JMSDistributedQueue;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;

public class JMSDistributedQueueMBeanImpl
extends JMSDistributedDestinationMBeanImpl
implements JMSDistributedQueueMBean,
Serializable {
    private int _ForwardDelay;
    private JMSDistributedQueueMemberMBean[] _JMSDistributedQueueMembers;
    private JMSTemplateMBean _JMSTemplate;
    private String _JNDIName;
    private String _LoadBalancingPolicy;
    private JMSDistributedQueueMemberMBean[] _Members;
    private String _Name;
    private String _Notes;
    private boolean _ResetDeliveryCountOnForward;
    private TargetMBean[] _Targets;
    private JMSTemplateMBean _Template;
    private JMSDistributedQueue _customizer;
    private static SchemaHelper2 _schemaHelper;

    public JMSDistributedQueueMBeanImpl() {
        try {
            this._customizer = new JMSDistributedQueue(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public JMSDistributedQueueMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new JMSDistributedQueue(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public JMSTemplateMBean createJMSTemplate(String string) {
        JMSTemplateMBeanImpl jMSTemplateMBeanImpl = new JMSTemplateMBeanImpl(this, -1);
        try {
            jMSTemplateMBeanImpl.setName(string);
            this.setJMSTemplate(jMSTemplateMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return jMSTemplateMBeanImpl;
    }

    public String getJNDIName() {
        return this._customizer.getJNDIName();
    }

    public JMSDistributedQueueMemberMBean[] getMembers() {
        return this._customizer.getMembers();
    }

    public String getMembersAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getMembers());
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public TargetMBean[] getTargets() {
        return this._customizer.getTargets();
    }

    public String getTargetsAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getTargets());
    }

    public boolean isJNDINameSet() {
        return this._isSet(9);
    }

    public boolean isMembersSet() {
        return this._isSet(13);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isTargetsSet() {
        return this._isSet(7);
    }

    public void setMembersAsString(String string) {
        if (string == null || string.length() == 0) {
            JMSDistributedQueueMemberMBean[] jMSDistributedQueueMemberMBeanArray = this._Members;
            this._initializeProperty(13);
            this._postSet(13, jMSDistributedQueueMemberMBeanArray, this._Members);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._Members);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, JMSDistributedQueueMemberMBean.class, new ReferenceManager.Resolver(this, 13){

                    public void resolveReference(Object object) {
                        try {
                            JMSDistributedQueueMBeanImpl.this.addMember((JMSDistributedQueueMemberMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (JMSDistributedQueueMemberMBean jMSDistributedQueueMemberMBean : this._Members) {
                    if (!string2.equals(jMSDistributedQueueMemberMBean.getName())) continue;
                    try {
                        this.removeMember(jMSDistributedQueueMemberMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void setTargetsAsString(String string) {
        if (string == null || string.length() == 0) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._initializeProperty(7);
            this._postSet(7, targetMBeanArray, this._Targets);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._Targets);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, TargetMBean.class, new ReferenceManager.Resolver(this, 7){

                    public void resolveReference(Object object) {
                        try {
                            JMSDistributedQueueMBeanImpl.this.addTarget((TargetMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (TargetMBean targetMBean : this._Targets) {
                    if (!string2.equals(targetMBean.getName())) continue;
                    try {
                        this.removeTarget(targetMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void destroyJMSTemplate(JMSTemplateMBean jMSTemplateMBean) {
        try {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this._JMSTemplate;
            if (abstractDescriptorBean == null) {
                return;
            }
            List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
            if (list != null && list.size() > 0) {
                throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
            }
            this._getReferenceManager().unregisterBean(abstractDescriptorBean);
            this._markDestroyed(abstractDescriptorBean);
            this.setJMSTemplate(null);
            this._unSet(10);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public void setJNDIName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this.getJNDIName();
        this._customizer.setJNDIName(string);
        this._postSet(9, string2, string);
    }

    public void setMembers(JMSDistributedQueueMemberMBean[] jMSDistributedQueueMemberMBeanArray) throws InvalidAttributeValueException {
        jMSDistributedQueueMemberMBeanArray = jMSDistributedQueueMemberMBeanArray == null ? new JMSDistributedQueueMemberMBeanImpl[]{} : jMSDistributedQueueMemberMBeanArray;
        JMSDistributedQueueMemberMBean[] jMSDistributedQueueMemberMBeanArray2 = this.getMembers();
        this._customizer.setMembers(jMSDistributedQueueMemberMBeanArray);
        this._postSet(13, jMSDistributedQueueMemberMBeanArray2, jMSDistributedQueueMemberMBeanArray);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setTargets(TargetMBean[] targetMBeanArray) throws InvalidAttributeValueException, DistributedManagementException {
        targetMBeanArray = targetMBeanArray == null ? new TargetMBeanImpl[]{} : targetMBeanArray;
        targetMBeanArray = (TargetMBean[])this._getHelper()._cleanAndValidateArray((Object)targetMBeanArray, TargetMBean.class);
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            if (targetMBeanArray[i] == null) continue;
            ResolvedReference resolvedReference = new ResolvedReference(this, 7, (AbstractDescriptorBean)targetMBeanArray[i]){

                protected Object getPropertyValue() {
                    return JMSDistributedQueueMBeanImpl.this.getTargets();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)targetMBeanArray[i], resolvedReference);
        }
        TargetMBean[] targetMBeanArray2 = this.getTargets();
        this._customizer.setTargets(targetMBeanArray);
        this._postSet(7, targetMBeanArray2, targetMBeanArray);
    }

    public boolean addMember(JMSDistributedQueueMemberMBean jMSDistributedQueueMemberMBean) throws InvalidAttributeValueException, DistributedManagementException {
        return this._customizer.addMember(jMSDistributedQueueMemberMBean);
    }

    public boolean addTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        this._getHelper()._ensureNonNull((Object)targetMBean);
        if (!((AbstractDescriptorBean)targetMBean).isChildProperty((DescriptorBean)this, 7)) {
            TargetMBean[] targetMBeanArray = (TargetMBean[])this._getHelper()._extendArray((Object)this.getTargets(), TargetMBean.class, (Object)targetMBean);
            try {
                this.setTargets(targetMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public JMSTemplateMBean getJMSTemplate() {
        return this._customizer.getJMSTemplate();
    }

    public String getNotes() {
        return this._customizer.getNotes();
    }

    public boolean isJMSTemplateSet() {
        return this._isSet(10);
    }

    public boolean isNotesSet() {
        return this._isSet(3);
    }

    public boolean removeMember(JMSDistributedQueueMemberMBean jMSDistributedQueueMemberMBean) throws InvalidAttributeValueException, DistributedManagementException {
        return this._customizer.removeMember(jMSDistributedQueueMemberMBean);
    }

    public boolean removeTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        TargetMBean[] targetMBeanArray = this.getTargets();
        TargetMBean[] targetMBeanArray2 = (TargetMBean[])this._getHelper()._removeElement((Object)targetMBeanArray, TargetMBean.class, (Object)targetMBean);
        if (targetMBeanArray2.length != targetMBeanArray.length) {
            try {
                this.setTargets(targetMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public void setJMSTemplate(JMSTemplateMBean jMSTemplateMBean) {
        Object object;
        if (jMSTemplateMBean != null && this.getJMSTemplate() != null && jMSTemplateMBean != this.getJMSTemplate()) {
            throw new BeanAlreadyExistsException(this.getJMSTemplate() + " has already been created");
        }
        if (jMSTemplateMBean != null && this._setParent((DescriptorBean)(object = (AbstractDescriptorBean)jMSTemplateMBean), this, 10)) {
            this._getReferenceManager().registerBean(object, true);
            this._postCreate((AbstractDescriptorBean)object);
        }
        object = this.getJMSTemplate();
        try {
            this._customizer.setJMSTemplate(jMSTemplateMBean);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new UndeclaredThrowableException(invalidAttributeValueException);
        }
        this._postSet(10, object, jMSTemplateMBean);
    }

    public void setNotes(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String string2 = this.getNotes();
        this._customizer.setNotes(string);
        this._postSet(3, string2, string);
    }

    public JMSTemplateMBean getTemplate() {
        return this._customizer.getTemplate();
    }

    public String getTemplateAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getTemplate();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isTemplateSet() {
        return this._isSet(11);
    }

    public void setTemplateAsString(String string) {
        if (string == null || string.length() == 0) {
            JMSTemplateMBean jMSTemplateMBean = this._Template;
            this._initializeProperty(11);
            this._postSet(11, jMSTemplateMBean, this._Template);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, JMSTemplateMBean.class, new ReferenceManager.Resolver(this, 11){

                public void resolveReference(Object object) {
                    try {
                        JMSDistributedQueueMBeanImpl.this.setTemplate((JMSTemplateMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void useDelegates(DistributedQueueBean distributedQueueBean, SubDeploymentMBean subDeploymentMBean) {
        this._customizer.useDelegates(distributedQueueBean, subDeploymentMBean);
    }

    public void addJMSDistributedQueueMember(JMSDistributedQueueMemberMBean jMSDistributedQueueMemberMBean) {
        this._getHelper()._ensureNonNull((Object)jMSDistributedQueueMemberMBean);
        if (!((AbstractDescriptorBean)jMSDistributedQueueMemberMBean).isChildProperty((DescriptorBean)this, 14)) {
            JMSDistributedQueueMemberMBean[] jMSDistributedQueueMemberMBeanArray = this._isSet(14) ? (JMSDistributedQueueMemberMBean[])this._getHelper()._extendArray((Object)this.getJMSDistributedQueueMembers(), JMSDistributedQueueMemberMBean.class, (Object)jMSDistributedQueueMemberMBean) : new JMSDistributedQueueMemberMBean[]{jMSDistributedQueueMemberMBean};
            try {
                this.setJMSDistributedQueueMembers(jMSDistributedQueueMemberMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public JMSDistributedQueueMemberMBean[] getJMSDistributedQueueMembers() {
        return this._JMSDistributedQueueMembers;
    }

    public boolean isJMSDistributedQueueMembersSet() {
        return this._isSet(14);
    }

    public void removeJMSDistributedQueueMember(JMSDistributedQueueMemberMBean jMSDistributedQueueMemberMBean) {
        this.destroyJMSDistributedQueueMember(jMSDistributedQueueMemberMBean);
    }

    public void setJMSDistributedQueueMembers(JMSDistributedQueueMemberMBean[] jMSDistributedQueueMemberMBeanArray) throws InvalidAttributeValueException {
        jMSDistributedQueueMemberMBeanArray = jMSDistributedQueueMemberMBeanArray == null ? new JMSDistributedQueueMemberMBeanImpl[]{} : jMSDistributedQueueMemberMBeanArray;
        for (int i = 0; i < jMSDistributedQueueMemberMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)jMSDistributedQueueMemberMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 14)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, true);
            this._postCreate(abstractDescriptorBean);
        }
        JMSDistributedQueueMemberMBean[] jMSDistributedQueueMemberMBeanArray2 = this._JMSDistributedQueueMembers;
        this._JMSDistributedQueueMembers = jMSDistributedQueueMemberMBeanArray;
        this._postSet(14, jMSDistributedQueueMemberMBeanArray2, jMSDistributedQueueMemberMBeanArray);
    }

    public void setTemplate(JMSTemplateMBean jMSTemplateMBean) {
        JMSTemplateMBean jMSTemplateMBean2 = this.getTemplate();
        try {
            this._customizer.setTemplate(jMSTemplateMBean);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new UndeclaredThrowableException(invalidAttributeValueException);
        }
        this._postSet(11, jMSTemplateMBean2, jMSTemplateMBean);
    }

    public JMSDistributedQueueMemberMBean createJMSDistributedQueueMember(String string) {
        JMSDistributedQueueMemberMBeanImpl jMSDistributedQueueMemberMBeanImpl = new JMSDistributedQueueMemberMBeanImpl(this, -1);
        try {
            jMSDistributedQueueMemberMBeanImpl.setName(string);
            this.addJMSDistributedQueueMember(jMSDistributedQueueMemberMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return jMSDistributedQueueMemberMBeanImpl;
    }

    public String getLoadBalancingPolicy() {
        return this._customizer.getLoadBalancingPolicy();
    }

    public boolean isLoadBalancingPolicySet() {
        return this._isSet(12);
    }

    public JMSDistributedQueueMemberMBean createJMSDistributedQueueMember(String string, JMSDistributedQueueMemberMBean jMSDistributedQueueMemberMBean) {
        return this._customizer.createJMSDistributedQueueMember(string, jMSDistributedQueueMemberMBean);
    }

    public void setLoadBalancingPolicy(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Round-Robin", "Random"};
        string = LegalChecks.checkInEnum((String)"LoadBalancingPolicy", (String)string, (String[])stringArray);
        String string2 = this.getLoadBalancingPolicy();
        this._customizer.setLoadBalancingPolicy(string);
        this._postSet(12, string2, string);
    }

    public void destroyJMSDistributedQueueMember(JMSDistributedQueueMemberMBean jMSDistributedQueueMemberMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(jMSDistributedQueueMemberMBean, 14);
                JMSDistributedQueueMemberMBean[] jMSDistributedQueueMemberMBeanArray = this.getJMSDistributedQueueMembers();
                JMSDistributedQueueMemberMBean[] jMSDistributedQueueMemberMBeanArray2 = (JMSDistributedQueueMemberMBean[])this._getHelper()._removeElement((Object)jMSDistributedQueueMemberMBeanArray, JMSDistributedQueueMemberMBean.class, (Object)jMSDistributedQueueMemberMBean);
                if (jMSDistributedQueueMemberMBeanArray.length == jMSDistributedQueueMemberMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)jMSDistributedQueueMemberMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)jMSDistributedQueueMemberMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setJMSDistributedQueueMembers(jMSDistributedQueueMemberMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void destroyJMSDistributedQueueMember(String string, JMSDistributedQueueMemberMBean jMSDistributedQueueMemberMBean) {
        this._customizer.destroyJMSDistributedQueueMember(string, jMSDistributedQueueMemberMBean);
    }

    public JMSDistributedQueueMemberMBean lookupJMSDistributedQueueMember(String string) {
        for (JMSDistributedQueueMemberMBeanImpl jMSDistributedQueueMemberMBeanImpl : Arrays.asList((Object[])this._JMSDistributedQueueMembers)) {
            String string2 = string;
            if (!jMSDistributedQueueMemberMBeanImpl.getName().equals(string2)) continue;
            return jMSDistributedQueueMemberMBeanImpl;
        }
        return null;
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public int getForwardDelay() {
        return this._customizer.getForwardDelay();
    }

    public boolean isForwardDelaySet() {
        return this._isSet(15);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setForwardDelay(int n) throws InvalidAttributeValueException {
        int n2 = this.getForwardDelay();
        this._customizer.setForwardDelay(n);
        this._postSet(15, n2, n);
    }

    public boolean getResetDeliveryCountOnForward() {
        return this._ResetDeliveryCountOnForward;
    }

    public boolean isResetDeliveryCountOnForwardSet() {
        return this._isSet(16);
    }

    public void setResetDeliveryCountOnForward(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.getResetDeliveryCountOnForward();
        this._customizer.setResetDeliveryCountOnForward(bl);
        this._postSet(16, bl2, bl);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 15;
        }
        try {
            switch (n) {
                case 15: {
                    this._customizer.setForwardDelay(-1);
                    if (bl) break;
                }
                case 14: {
                    this._JMSDistributedQueueMembers = new JMSDistributedQueueMemberMBean[0];
                    if (bl) break;
                }
                case 10: {
                    this._customizer.setJMSTemplate(null);
                    if (bl) break;
                }
                case 9: {
                    this._customizer.setJNDIName(null);
                    if (bl) break;
                }
                case 12: {
                    this._customizer.setLoadBalancingPolicy("Round-Robin");
                    if (bl) break;
                }
                case 13: {
                    this._customizer.setMembers(new JMSDistributedQueueMemberMBean[0]);
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 3: {
                    this._customizer.setNotes(null);
                    if (bl) break;
                }
                case 16: {
                    this._customizer.setResetDeliveryCountOnForward(true);
                    if (bl) break;
                }
                case 7: {
                    this._customizer.setTargets(new TargetMBean[0]);
                    if (bl) break;
                }
                case 11: {
                    this._customizer.setTemplate(null);
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "JMSDistributedQueue";
    }

    public void putValue(String string, Object object) {
        if (string.equals("ForwardDelay")) {
            int n = this._ForwardDelay;
            this._ForwardDelay = (Integer)object;
            this._postSet(15, n, this._ForwardDelay);
            return;
        }
        if (string.equals("JMSDistributedQueueMembers")) {
            JMSDistributedQueueMemberMBean[] jMSDistributedQueueMemberMBeanArray = this._JMSDistributedQueueMembers;
            this._JMSDistributedQueueMembers = (JMSDistributedQueueMemberMBean[])object;
            this._postSet(14, jMSDistributedQueueMemberMBeanArray, this._JMSDistributedQueueMembers);
            return;
        }
        if (string.equals("JMSTemplate")) {
            JMSTemplateMBean jMSTemplateMBean = this._JMSTemplate;
            this._JMSTemplate = (JMSTemplateMBean)object;
            this._postSet(10, jMSTemplateMBean, this._JMSTemplate);
            return;
        }
        if (string.equals("JNDIName")) {
            String string2 = this._JNDIName;
            this._JNDIName = (String)object;
            this._postSet(9, string2, this._JNDIName);
            return;
        }
        if (string.equals("LoadBalancingPolicy")) {
            String string3 = this._LoadBalancingPolicy;
            this._LoadBalancingPolicy = (String)object;
            this._postSet(12, string3, this._LoadBalancingPolicy);
            return;
        }
        if (string.equals("Members")) {
            JMSDistributedQueueMemberMBean[] jMSDistributedQueueMemberMBeanArray = this._Members;
            this._Members = (JMSDistributedQueueMemberMBean[])object;
            this._postSet(13, jMSDistributedQueueMemberMBeanArray, this._Members);
            return;
        }
        if (string.equals("Name")) {
            String string4 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string4, this._Name);
            return;
        }
        if (string.equals("Notes")) {
            String string5 = this._Notes;
            this._Notes = (String)object;
            this._postSet(3, string5, this._Notes);
            return;
        }
        if (string.equals("ResetDeliveryCountOnForward")) {
            boolean bl = this._ResetDeliveryCountOnForward;
            this._ResetDeliveryCountOnForward = (Boolean)object;
            this._postSet(16, bl, this._ResetDeliveryCountOnForward);
            return;
        }
        if (string.equals("Targets")) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._Targets = (TargetMBean[])object;
            this._postSet(7, targetMBeanArray, this._Targets);
            return;
        }
        if (string.equals("Template")) {
            JMSTemplateMBean jMSTemplateMBean = this._Template;
            this._Template = (JMSTemplateMBean)object;
            this._postSet(11, jMSTemplateMBean, this._Template);
            return;
        }
        if (string.equals("customizer")) {
            JMSDistributedQueue jMSDistributedQueue = this._customizer;
            this._customizer = (JMSDistributedQueue)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("ForwardDelay")) {
            return new Integer(this._ForwardDelay);
        }
        if (string.equals("JMSDistributedQueueMembers")) {
            return this._JMSDistributedQueueMembers;
        }
        if (string.equals("JMSTemplate")) {
            return this._JMSTemplate;
        }
        if (string.equals("JNDIName")) {
            return this._JNDIName;
        }
        if (string.equals("LoadBalancingPolicy")) {
            return this._LoadBalancingPolicy;
        }
        if (string.equals("Members")) {
            return this._Members;
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("Notes")) {
            return this._Notes;
        }
        if (string.equals("ResetDeliveryCountOnForward")) {
            return new Boolean(this._ResetDeliveryCountOnForward);
        }
        if (string.equals("Targets")) {
            return this._Targets;
        }
        if (string.equals("Template")) {
            return this._Template;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends JMSDistributedDestinationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 13: {
                    if (!string.equals("forward-delay")) break;
                    return 15;
                }
                case 28: {
                    if (!string.equals("jms-distributed-queue-member")) break;
                    return 14;
                }
                case 12: {
                    if (!string.equals("jms-template")) break;
                    return 10;
                }
                case 9: {
                    if (!string.equals("jndi-name")) break;
                    return 9;
                }
                case 21: {
                    if (!string.equals("load-balancing-policy")) break;
                    return 12;
                }
                case 6: {
                    if (string.equals("member")) {
                        return 13;
                    }
                    if (!string.equals("target")) break;
                    return 7;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 5: {
                    if (!string.equals("notes")) break;
                    return 3;
                }
                case 31: {
                    if (!string.equals("reset-delivery-count-on-forward")) break;
                    return 16;
                }
                case 8: {
                    if (!string.equals("template")) break;
                    return 11;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                case 14: {
                    return new JMSDistributedQueueMemberMBeanImpl.SchemaHelper2();
                }
                case 10: {
                    return new JMSTemplateMBeanImpl.SchemaHelper2();
                }
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 15: {
                    return "forward-delay";
                }
                case 14: {
                    return "jms-distributed-queue-member";
                }
                case 10: {
                    return "jms-template";
                }
                case 9: {
                    return "jndi-name";
                }
                case 12: {
                    return "load-balancing-policy";
                }
                case 13: {
                    return "member";
                }
                case 2: {
                    return "name";
                }
                case 3: {
                    return "notes";
                }
                case 16: {
                    return "reset-delivery-count-on-forward";
                }
                case 7: {
                    return "target";
                }
                case 11: {
                    return "template";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 14: {
                    return true;
                }
                case 13: {
                    return true;
                }
                case 7: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                case 14: {
                    return true;
                }
                case 10: {
                    return true;
                }
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends JMSDistributedDestinationMBeanImpl.Helper {
        private JMSDistributedQueueMBeanImpl bean;

        protected Helper(JMSDistributedQueueMBeanImpl jMSDistributedQueueMBeanImpl) {
            super(jMSDistributedQueueMBeanImpl);
            this.bean = jMSDistributedQueueMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 15: {
                    return "ForwardDelay";
                }
                case 14: {
                    return "JMSDistributedQueueMembers";
                }
                case 10: {
                    return "JMSTemplate";
                }
                case 9: {
                    return "JNDIName";
                }
                case 12: {
                    return "LoadBalancingPolicy";
                }
                case 13: {
                    return "Members";
                }
                case 2: {
                    return "Name";
                }
                case 3: {
                    return "Notes";
                }
                case 16: {
                    return "ResetDeliveryCountOnForward";
                }
                case 7: {
                    return "Targets";
                }
                case 11: {
                    return "Template";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("ForwardDelay")) {
                return 15;
            }
            if (string.equals("JMSDistributedQueueMembers")) {
                return 14;
            }
            if (string.equals("JMSTemplate")) {
                return 10;
            }
            if (string.equals("JNDIName")) {
                return 9;
            }
            if (string.equals("LoadBalancingPolicy")) {
                return 12;
            }
            if (string.equals("Members")) {
                return 13;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("Notes")) {
                return 3;
            }
            if (string.equals("ResetDeliveryCountOnForward")) {
                return 16;
            }
            if (string.equals("Targets")) {
                return 7;
            }
            if (string.equals("Template")) {
                return 11;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList<ArrayIterator> arrayList = new ArrayList<ArrayIterator>();
            arrayList.add(new ArrayIterator((Object[])this.bean.getJMSDistributedQueueMembers()));
            if (this.bean.getJMSTemplate() != null) {
                arrayList.add(new ArrayIterator((Object[])new JMSTemplateMBean[]{this.bean.getJMSTemplate()}));
            }
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isForwardDelaySet()) {
                    stringBuffer.append("ForwardDelay");
                    stringBuffer.append(String.valueOf(this.bean.getForwardDelay()));
                }
                l2 = 0L;
                for (int i = 0; i < this.bean.getJMSDistributedQueueMembers().length; ++i) {
                    l2 ^= this.computeChildHashValue(this.bean.getJMSDistributedQueueMembers()[i]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getJMSTemplate())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isJNDINameSet()) {
                    stringBuffer.append("JNDIName");
                    stringBuffer.append(String.valueOf(this.bean.getJNDIName()));
                }
                if (this.bean.isLoadBalancingPolicySet()) {
                    stringBuffer.append("LoadBalancingPolicy");
                    stringBuffer.append(String.valueOf(this.bean.getLoadBalancingPolicy()));
                }
                if (this.bean.isMembersSet()) {
                    stringBuffer.append("Members");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getMembers())));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isNotesSet()) {
                    stringBuffer.append("Notes");
                    stringBuffer.append(String.valueOf(this.bean.getNotes()));
                }
                if (this.bean.isResetDeliveryCountOnForwardSet()) {
                    stringBuffer.append("ResetDeliveryCountOnForward");
                    stringBuffer.append(String.valueOf(this.bean.getResetDeliveryCountOnForward()));
                }
                if (this.bean.isTargetsSet()) {
                    stringBuffer.append("Targets");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getTargets())));
                }
                if (this.bean.isTemplateSet()) {
                    stringBuffer.append("Template");
                    stringBuffer.append(String.valueOf(this.bean.getTemplate()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                JMSDistributedQueueMBeanImpl jMSDistributedQueueMBeanImpl = (JMSDistributedQueueMBeanImpl)abstractDescriptorBean;
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ForwardDelay", this.bean.getForwardDelay(), jMSDistributedQueueMBeanImpl.getForwardDelay(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeChildDiff("JMSDistributedQueueMembers", this.bean.getJMSDistributedQueueMembers(), jMSDistributedQueueMBeanImpl.getJMSDistributedQueueMembers(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeChildDiff("JMSTemplate", this.bean.getJMSTemplate(), jMSDistributedQueueMBeanImpl.getJMSTemplate(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("JNDIName", this.bean.getJNDIName(), jMSDistributedQueueMBeanImpl.getJNDIName(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LoadBalancingPolicy", this.bean.getLoadBalancingPolicy(), jMSDistributedQueueMBeanImpl.getLoadBalancingPolicy(), true);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("Members", this.bean.getMembers(), jMSDistributedQueueMBeanImpl.getMembers(), true);
                }
                this.computeDiff("Name", this.bean.getName(), jMSDistributedQueueMBeanImpl.getName(), false);
                this.computeDiff("Notes", this.bean.getNotes(), jMSDistributedQueueMBeanImpl.getNotes(), true);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ResetDeliveryCountOnForward", this.bean.getResetDeliveryCountOnForward(), jMSDistributedQueueMBeanImpl.getResetDeliveryCountOnForward(), true);
                }
                this.computeDiff("Targets", this.bean.getTargets(), jMSDistributedQueueMBeanImpl.getTargets(), true);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("Template", this.bean.getTemplate(), jMSDistributedQueueMBeanImpl.getTemplate(), false);
                }
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                JMSDistributedQueueMBeanImpl jMSDistributedQueueMBeanImpl = (JMSDistributedQueueMBeanImpl)beanUpdateEvent.getSourceBean();
                JMSDistributedQueueMBeanImpl jMSDistributedQueueMBeanImpl2 = (JMSDistributedQueueMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("ForwardDelay")) {
                    jMSDistributedQueueMBeanImpl.setForwardDelay(jMSDistributedQueueMBeanImpl2.getForwardDelay());
                    jMSDistributedQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("JMSDistributedQueueMembers")) {
                    if (n == 2) {
                        propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                        jMSDistributedQueueMBeanImpl.addJMSDistributedQueueMember((JMSDistributedQueueMemberMBean)propertyUpdate.getAddedObject());
                    } else if (n == 3) {
                        jMSDistributedQueueMBeanImpl.removeJMSDistributedQueueMember((JMSDistributedQueueMemberMBean)propertyUpdate.getRemovedObject());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    if (jMSDistributedQueueMBeanImpl.getJMSDistributedQueueMembers() == null || jMSDistributedQueueMBeanImpl.getJMSDistributedQueueMembers().length == 0) {
                        jMSDistributedQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                    }
                } else if (string.equals("JMSTemplate")) {
                    if (n == 2) {
                        jMSDistributedQueueMBeanImpl.setJMSTemplate((JMSTemplateMBean)this.createCopy((AbstractDescriptorBean)jMSDistributedQueueMBeanImpl2.getJMSTemplate()));
                    } else if (n == 3) {
                        jMSDistributedQueueMBeanImpl._destroySingleton("JMSTemplate", jMSDistributedQueueMBeanImpl.getJMSTemplate());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    jMSDistributedQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("JNDIName")) {
                    jMSDistributedQueueMBeanImpl.setJNDIName(jMSDistributedQueueMBeanImpl2.getJNDIName());
                    jMSDistributedQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("LoadBalancingPolicy")) {
                    jMSDistributedQueueMBeanImpl.setLoadBalancingPolicy(jMSDistributedQueueMBeanImpl2.getLoadBalancingPolicy());
                    jMSDistributedQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("Members")) {
                    jMSDistributedQueueMBeanImpl.setMembersAsString(jMSDistributedQueueMBeanImpl2.getMembersAsString());
                    jMSDistributedQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("Name")) {
                    jMSDistributedQueueMBeanImpl.setName(jMSDistributedQueueMBeanImpl2.getName());
                    jMSDistributedQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (string.equals("Notes")) {
                    jMSDistributedQueueMBeanImpl.setNotes(jMSDistributedQueueMBeanImpl2.getNotes());
                    jMSDistributedQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 3);
                } else if (string.equals("ResetDeliveryCountOnForward")) {
                    jMSDistributedQueueMBeanImpl.setResetDeliveryCountOnForward(jMSDistributedQueueMBeanImpl2.getResetDeliveryCountOnForward());
                    jMSDistributedQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else if (string.equals("Targets")) {
                    jMSDistributedQueueMBeanImpl.setTargetsAsString(jMSDistributedQueueMBeanImpl2.getTargetsAsString());
                    jMSDistributedQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("Template")) {
                    jMSDistributedQueueMBeanImpl.setTemplateAsString(jMSDistributedQueueMBeanImpl2.getTemplateAsString());
                    jMSDistributedQueueMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                JMSDistributedQueueMBeanImpl jMSDistributedQueueMBeanImpl = (JMSDistributedQueueMBeanImpl)abstractDescriptorBean;
                super.finishCopy(jMSDistributedQueueMBeanImpl, bl, list);
                if (bl && (list == null || !list.contains("ForwardDelay")) && this.bean.isForwardDelaySet()) {
                    jMSDistributedQueueMBeanImpl.setForwardDelay(this.bean.getForwardDelay());
                }
                if (bl && (list == null || !list.contains("JMSDistributedQueueMembers")) && this.bean.isJMSDistributedQueueMembersSet() && !jMSDistributedQueueMBeanImpl._isSet(14)) {
                    JMSDistributedQueueMemberMBean[] jMSDistributedQueueMemberMBeanArray = this.bean.getJMSDistributedQueueMembers();
                    JMSDistributedQueueMemberMBean[] jMSDistributedQueueMemberMBeanArray2 = new JMSDistributedQueueMemberMBean[jMSDistributedQueueMemberMBeanArray.length];
                    for (int i = 0; i < jMSDistributedQueueMemberMBeanArray2.length; ++i) {
                        jMSDistributedQueueMemberMBeanArray2[i] = (JMSDistributedQueueMemberMBean)this.createCopy((AbstractDescriptorBean)jMSDistributedQueueMemberMBeanArray[i], bl);
                    }
                    jMSDistributedQueueMBeanImpl.setJMSDistributedQueueMembers(jMSDistributedQueueMemberMBeanArray2);
                }
                if (bl && (list == null || !list.contains("JMSTemplate")) && this.bean.isJMSTemplateSet() && !jMSDistributedQueueMBeanImpl._isSet(10)) {
                    JMSTemplateMBean jMSTemplateMBean = this.bean.getJMSTemplate();
                    jMSDistributedQueueMBeanImpl.setJMSTemplate(null);
                    jMSDistributedQueueMBeanImpl.setJMSTemplate(jMSTemplateMBean == null ? null : (JMSTemplateMBean)this.createCopy((AbstractDescriptorBean)jMSTemplateMBean, bl));
                }
                if (bl && (list == null || !list.contains("JNDIName")) && this.bean.isJNDINameSet()) {
                    jMSDistributedQueueMBeanImpl.setJNDIName(this.bean.getJNDIName());
                }
                if (bl && (list == null || !list.contains("LoadBalancingPolicy")) && this.bean.isLoadBalancingPolicySet()) {
                    jMSDistributedQueueMBeanImpl.setLoadBalancingPolicy(this.bean.getLoadBalancingPolicy());
                }
                if (bl && (list == null || !list.contains("Members")) && this.bean.isMembersSet()) {
                    jMSDistributedQueueMBeanImpl._unSet(jMSDistributedQueueMBeanImpl, 13);
                    jMSDistributedQueueMBeanImpl.setMembersAsString(this.bean.getMembersAsString());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    jMSDistributedQueueMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("Notes")) && this.bean.isNotesSet()) {
                    jMSDistributedQueueMBeanImpl.setNotes(this.bean.getNotes());
                }
                if (bl && (list == null || !list.contains("ResetDeliveryCountOnForward")) && this.bean.isResetDeliveryCountOnForwardSet()) {
                    jMSDistributedQueueMBeanImpl.setResetDeliveryCountOnForward(this.bean.getResetDeliveryCountOnForward());
                }
                if ((list == null || !list.contains("Targets")) && this.bean.isTargetsSet()) {
                    jMSDistributedQueueMBeanImpl._unSet(jMSDistributedQueueMBeanImpl, 7);
                    jMSDistributedQueueMBeanImpl.setTargetsAsString(this.bean.getTargetsAsString());
                }
                if (bl && (list == null || !list.contains("Template")) && this.bean.isTemplateSet()) {
                    jMSDistributedQueueMBeanImpl._unSet(jMSDistributedQueueMBeanImpl, 11);
                    jMSDistributedQueueMBeanImpl.setTemplateAsString(this.bean.getTemplateAsString());
                }
                return jMSDistributedQueueMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getJMSDistributedQueueMembers(), clazz, object);
            this.inferSubTree(this.bean.getJMSTemplate(), clazz, object);
            this.inferSubTree(this.bean.getMembers(), clazz, object);
            this.inferSubTree(this.bean.getTargets(), clazz, object);
            this.inferSubTree(this.bean.getTemplate(), clazz, object);
        }
    }
}

