/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.FileStoreMBean;
import weblogic.management.configuration.JMSFileStoreMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.JMSStoreMBeanImpl;
import weblogic.management.mbeans.custom.JMSFileStore;
import weblogic.utils.collections.CombinedIterator;

public class JMSFileStoreMBeanImpl
extends JMSStoreMBeanImpl
implements JMSFileStoreMBean,
Serializable {
    private int _BlockSize;
    private String _CacheDirectory;
    private FileStoreMBean _DelegatedBean;
    private JMSServerMBean _DelegatedJMSServer;
    private String _Directory;
    private boolean _FileLockingEnabled;
    private long _InitialSize;
    private int _IoBufferSize;
    private long _MaxFileSize;
    private int _MaxWindowBufferSize;
    private int _MinWindowBufferSize;
    private String _Name;
    private String _SynchronousWritePolicy;
    private JMSFileStore _customizer;
    private static SchemaHelper2 _schemaHelper;

    public JMSFileStoreMBeanImpl() {
        try {
            this._customizer = new JMSFileStore(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public JMSFileStoreMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new JMSFileStore(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getDirectory() {
        return this._customizer.getDirectory();
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public boolean isDirectorySet() {
        return this._isSet(8);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public void setDelegatedBean(FileStoreMBean fileStoreMBean) {
        this._customizer.setDelegatedBean(fileStoreMBean);
    }

    public FileStoreMBean getDelegatedBean() {
        return this._customizer.getDelegatedBean();
    }

    public boolean isDelegatedBeanSet() {
        return this._isSet(18);
    }

    public void setDirectory(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this.getDirectory();
        this._customizer.setDirectory(string);
        this._postSet(8, string2, string);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public String getSynchronousWritePolicy() {
        return this._customizer.getSynchronousWritePolicy();
    }

    public boolean isSynchronousWritePolicySet() {
        return this._isSet(9);
    }

    public void setDelegatedJMSServer(JMSServerMBean jMSServerMBean) {
        this._customizer.setDelegatedJMSServer(jMSServerMBean);
    }

    public JMSServerMBean getDelegatedJMSServer() {
        return this._customizer.getDelegatedJMSServer();
    }

    public boolean isDelegatedJMSServerSet() {
        return this._isSet(19);
    }

    public void setSynchronousWritePolicy(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Disabled", "Cache-Flush", "Direct-Write", "Direct-Write-With-Cache"};
        string = LegalChecks.checkInEnum((String)"SynchronousWritePolicy", (String)string, (String[])stringArray);
        String string2 = this.getSynchronousWritePolicy();
        this._customizer.setSynchronousWritePolicy(string);
        this._postSet(9, string2, string);
    }

    public String getCacheDirectory() {
        return this._CacheDirectory;
    }

    public boolean isCacheDirectorySet() {
        return this._isSet(10);
    }

    public void setCacheDirectory(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._CacheDirectory;
        this._CacheDirectory = string;
        this._postSet(10, string2, string);
    }

    public int getMinWindowBufferSize() {
        return this._MinWindowBufferSize;
    }

    public boolean isMinWindowBufferSizeSet() {
        return this._isSet(11);
    }

    public void setMinWindowBufferSize(int n) {
        LegalChecks.checkInRange((String)"MinWindowBufferSize", (long)n, (long)-1L, (long)0x40000000L);
        int n2 = this._MinWindowBufferSize;
        this._MinWindowBufferSize = n;
        this._postSet(11, n2, n);
    }

    public int getMaxWindowBufferSize() {
        return this._MaxWindowBufferSize;
    }

    public boolean isMaxWindowBufferSizeSet() {
        return this._isSet(12);
    }

    public void setMaxWindowBufferSize(int n) {
        LegalChecks.checkInRange((String)"MaxWindowBufferSize", (long)n, (long)-1L, (long)0x40000000L);
        int n2 = this._MaxWindowBufferSize;
        this._MaxWindowBufferSize = n;
        this._postSet(12, n2, n);
    }

    public int getIoBufferSize() {
        return this._IoBufferSize;
    }

    public boolean isIoBufferSizeSet() {
        return this._isSet(13);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void setIoBufferSize(int n) {
        LegalChecks.checkInRange((String)"IoBufferSize", (long)n, (long)-1L, (long)0x4000000L);
        int n2 = this._IoBufferSize;
        this._IoBufferSize = n;
        this._postSet(13, n2, n);
    }

    public long getMaxFileSize() {
        return this._MaxFileSize;
    }

    public boolean isMaxFileSizeSet() {
        return this._isSet(14);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setMaxFileSize(long l) {
        LegalChecks.checkMin((String)"MaxFileSize", (long)l, (long)0x100000L);
        long l2 = this._MaxFileSize;
        this._MaxFileSize = l;
        this._postSet(14, l2, l);
    }

    public int getBlockSize() {
        return this._BlockSize;
    }

    public boolean isBlockSizeSet() {
        return this._isSet(15);
    }

    public void setBlockSize(int n) {
        LegalChecks.checkInRange((String)"BlockSize", (long)n, (long)-1L, (long)8192L);
        int n2 = this._BlockSize;
        this._BlockSize = n;
        this._postSet(15, n2, n);
    }

    public long getInitialSize() {
        return this._InitialSize;
    }

    public boolean isInitialSizeSet() {
        return this._isSet(16);
    }

    public void setInitialSize(long l) {
        LegalChecks.checkMin((String)"InitialSize", (long)l, (long)0L);
        long l2 = this._InitialSize;
        this._InitialSize = l;
        this._postSet(16, l2, l);
    }

    public boolean isFileLockingEnabled() {
        return this._FileLockingEnabled;
    }

    public boolean isFileLockingEnabledSet() {
        return this._isSet(17);
    }

    public void setFileLockingEnabled(boolean bl) {
        boolean bl2 = this._FileLockingEnabled;
        this._FileLockingEnabled = bl;
        this._postSet(17, bl2, bl);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 15;
        }
        try {
            switch (n) {
                case 15: {
                    this._BlockSize = -1;
                    if (bl) break;
                }
                case 10: {
                    this._CacheDirectory = null;
                    if (bl) break;
                }
                case 18: {
                    this._customizer.setDelegatedBean(null);
                    if (bl) break;
                }
                case 19: {
                    this._customizer.setDelegatedJMSServer(null);
                    if (bl) break;
                }
                case 8: {
                    this._customizer.setDirectory(null);
                    if (bl) break;
                }
                case 16: {
                    this._InitialSize = 0L;
                    if (bl) break;
                }
                case 13: {
                    this._IoBufferSize = -1;
                    if (bl) break;
                }
                case 14: {
                    this._MaxFileSize = 0x50000000L;
                    if (bl) break;
                }
                case 12: {
                    this._MaxWindowBufferSize = -1;
                    if (bl) break;
                }
                case 11: {
                    this._MinWindowBufferSize = -1;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 9: {
                    this._customizer.setSynchronousWritePolicy("Direct-Write");
                    if (bl) break;
                }
                case 17: {
                    this._FileLockingEnabled = true;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "JMSFileStore";
    }

    public void putValue(String string, Object object) {
        if (string.equals("BlockSize")) {
            int n = this._BlockSize;
            this._BlockSize = (Integer)object;
            this._postSet(15, n, this._BlockSize);
            return;
        }
        if (string.equals("CacheDirectory")) {
            String string2 = this._CacheDirectory;
            this._CacheDirectory = (String)object;
            this._postSet(10, string2, this._CacheDirectory);
            return;
        }
        if (string.equals("DelegatedBean")) {
            FileStoreMBean fileStoreMBean = this._DelegatedBean;
            this._DelegatedBean = (FileStoreMBean)object;
            this._postSet(18, fileStoreMBean, this._DelegatedBean);
            return;
        }
        if (string.equals("DelegatedJMSServer")) {
            JMSServerMBean jMSServerMBean = this._DelegatedJMSServer;
            this._DelegatedJMSServer = (JMSServerMBean)object;
            this._postSet(19, jMSServerMBean, this._DelegatedJMSServer);
            return;
        }
        if (string.equals("Directory")) {
            String string3 = this._Directory;
            this._Directory = (String)object;
            this._postSet(8, string3, this._Directory);
            return;
        }
        if (string.equals("FileLockingEnabled")) {
            boolean bl = this._FileLockingEnabled;
            this._FileLockingEnabled = (Boolean)object;
            this._postSet(17, bl, this._FileLockingEnabled);
            return;
        }
        if (string.equals("InitialSize")) {
            long l = this._InitialSize;
            this._InitialSize = (Long)object;
            this._postSet(16, l, this._InitialSize);
            return;
        }
        if (string.equals("IoBufferSize")) {
            int n = this._IoBufferSize;
            this._IoBufferSize = (Integer)object;
            this._postSet(13, n, this._IoBufferSize);
            return;
        }
        if (string.equals("MaxFileSize")) {
            long l = this._MaxFileSize;
            this._MaxFileSize = (Long)object;
            this._postSet(14, l, this._MaxFileSize);
            return;
        }
        if (string.equals("MaxWindowBufferSize")) {
            int n = this._MaxWindowBufferSize;
            this._MaxWindowBufferSize = (Integer)object;
            this._postSet(12, n, this._MaxWindowBufferSize);
            return;
        }
        if (string.equals("MinWindowBufferSize")) {
            int n = this._MinWindowBufferSize;
            this._MinWindowBufferSize = (Integer)object;
            this._postSet(11, n, this._MinWindowBufferSize);
            return;
        }
        if (string.equals("Name")) {
            String string4 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string4, this._Name);
            return;
        }
        if (string.equals("SynchronousWritePolicy")) {
            String string5 = this._SynchronousWritePolicy;
            this._SynchronousWritePolicy = (String)object;
            this._postSet(9, string5, this._SynchronousWritePolicy);
            return;
        }
        if (string.equals("customizer")) {
            JMSFileStore jMSFileStore = this._customizer;
            this._customizer = (JMSFileStore)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("BlockSize")) {
            return new Integer(this._BlockSize);
        }
        if (string.equals("CacheDirectory")) {
            return this._CacheDirectory;
        }
        if (string.equals("DelegatedBean")) {
            return this._DelegatedBean;
        }
        if (string.equals("DelegatedJMSServer")) {
            return this._DelegatedJMSServer;
        }
        if (string.equals("Directory")) {
            return this._Directory;
        }
        if (string.equals("FileLockingEnabled")) {
            return new Boolean(this._FileLockingEnabled);
        }
        if (string.equals("InitialSize")) {
            return new Long(this._InitialSize);
        }
        if (string.equals("IoBufferSize")) {
            return new Integer(this._IoBufferSize);
        }
        if (string.equals("MaxFileSize")) {
            return new Long(this._MaxFileSize);
        }
        if (string.equals("MaxWindowBufferSize")) {
            return new Integer(this._MaxWindowBufferSize);
        }
        if (string.equals("MinWindowBufferSize")) {
            return new Integer(this._MinWindowBufferSize);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("SynchronousWritePolicy")) {
            return this._SynchronousWritePolicy;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends JMSStoreMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 10: {
                    if (!string.equals("block-size")) break;
                    return 15;
                }
                case 15: {
                    if (!string.equals("cache-directory")) break;
                    return 10;
                }
                case 14: {
                    if (string.equals("delegated-bean")) {
                        return 18;
                    }
                    if (!string.equals("io-buffer-size")) break;
                    return 13;
                }
                case 20: {
                    if (string.equals("delegated-jms-server")) {
                        return 19;
                    }
                    if (!string.equals("file-locking-enabled")) break;
                    return 17;
                }
                case 9: {
                    if (!string.equals("directory")) break;
                    return 8;
                }
                case 12: {
                    if (!string.equals("initial-size")) break;
                    return 16;
                }
                case 13: {
                    if (!string.equals("max-file-size")) break;
                    return 14;
                }
                case 22: {
                    if (string.equals("max-window-buffer-size")) {
                        return 12;
                    }
                    if (!string.equals("min-window-buffer-size")) break;
                    return 11;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 24: {
                    if (!string.equals("synchronous-write-policy")) break;
                    return 9;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 15: {
                    return "block-size";
                }
                case 10: {
                    return "cache-directory";
                }
                case 18: {
                    return "delegated-bean";
                }
                case 19: {
                    return "delegated-jms-server";
                }
                case 8: {
                    return "directory";
                }
                case 16: {
                    return "initial-size";
                }
                case 13: {
                    return "io-buffer-size";
                }
                case 14: {
                    return "max-file-size";
                }
                case 12: {
                    return "max-window-buffer-size";
                }
                case 11: {
                    return "min-window-buffer-size";
                }
                case 2: {
                    return "name";
                }
                case 9: {
                    return "synchronous-write-policy";
                }
                case 17: {
                    return "file-locking-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends JMSStoreMBeanImpl.Helper {
        private JMSFileStoreMBeanImpl bean;

        protected Helper(JMSFileStoreMBeanImpl jMSFileStoreMBeanImpl) {
            super(jMSFileStoreMBeanImpl);
            this.bean = jMSFileStoreMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 15: {
                    return "BlockSize";
                }
                case 10: {
                    return "CacheDirectory";
                }
                case 18: {
                    return "DelegatedBean";
                }
                case 19: {
                    return "DelegatedJMSServer";
                }
                case 8: {
                    return "Directory";
                }
                case 16: {
                    return "InitialSize";
                }
                case 13: {
                    return "IoBufferSize";
                }
                case 14: {
                    return "MaxFileSize";
                }
                case 12: {
                    return "MaxWindowBufferSize";
                }
                case 11: {
                    return "MinWindowBufferSize";
                }
                case 2: {
                    return "Name";
                }
                case 9: {
                    return "SynchronousWritePolicy";
                }
                case 17: {
                    return "FileLockingEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("BlockSize")) {
                return 15;
            }
            if (string.equals("CacheDirectory")) {
                return 10;
            }
            if (string.equals("DelegatedBean")) {
                return 18;
            }
            if (string.equals("DelegatedJMSServer")) {
                return 19;
            }
            if (string.equals("Directory")) {
                return 8;
            }
            if (string.equals("InitialSize")) {
                return 16;
            }
            if (string.equals("IoBufferSize")) {
                return 13;
            }
            if (string.equals("MaxFileSize")) {
                return 14;
            }
            if (string.equals("MaxWindowBufferSize")) {
                return 12;
            }
            if (string.equals("MinWindowBufferSize")) {
                return 11;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("SynchronousWritePolicy")) {
                return 9;
            }
            if (string.equals("FileLockingEnabled")) {
                return 17;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isBlockSizeSet()) {
                    stringBuffer.append("BlockSize");
                    stringBuffer.append(String.valueOf(this.bean.getBlockSize()));
                }
                if (this.bean.isCacheDirectorySet()) {
                    stringBuffer.append("CacheDirectory");
                    stringBuffer.append(String.valueOf(this.bean.getCacheDirectory()));
                }
                if (this.bean.isDelegatedBeanSet()) {
                    stringBuffer.append("DelegatedBean");
                    stringBuffer.append(String.valueOf(this.bean.getDelegatedBean()));
                }
                if (this.bean.isDelegatedJMSServerSet()) {
                    stringBuffer.append("DelegatedJMSServer");
                    stringBuffer.append(String.valueOf(this.bean.getDelegatedJMSServer()));
                }
                if (this.bean.isDirectorySet()) {
                    stringBuffer.append("Directory");
                    stringBuffer.append(String.valueOf(this.bean.getDirectory()));
                }
                if (this.bean.isInitialSizeSet()) {
                    stringBuffer.append("InitialSize");
                    stringBuffer.append(String.valueOf(this.bean.getInitialSize()));
                }
                if (this.bean.isIoBufferSizeSet()) {
                    stringBuffer.append("IoBufferSize");
                    stringBuffer.append(String.valueOf(this.bean.getIoBufferSize()));
                }
                if (this.bean.isMaxFileSizeSet()) {
                    stringBuffer.append("MaxFileSize");
                    stringBuffer.append(String.valueOf(this.bean.getMaxFileSize()));
                }
                if (this.bean.isMaxWindowBufferSizeSet()) {
                    stringBuffer.append("MaxWindowBufferSize");
                    stringBuffer.append(String.valueOf(this.bean.getMaxWindowBufferSize()));
                }
                if (this.bean.isMinWindowBufferSizeSet()) {
                    stringBuffer.append("MinWindowBufferSize");
                    stringBuffer.append(String.valueOf(this.bean.getMinWindowBufferSize()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isSynchronousWritePolicySet()) {
                    stringBuffer.append("SynchronousWritePolicy");
                    stringBuffer.append(String.valueOf(this.bean.getSynchronousWritePolicy()));
                }
                if (this.bean.isFileLockingEnabledSet()) {
                    stringBuffer.append("FileLockingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isFileLockingEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                JMSFileStoreMBeanImpl jMSFileStoreMBeanImpl = (JMSFileStoreMBeanImpl)abstractDescriptorBean;
                this.computeDiff("BlockSize", this.bean.getBlockSize(), jMSFileStoreMBeanImpl.getBlockSize(), true);
                this.computeDiff("CacheDirectory", this.bean.getCacheDirectory(), jMSFileStoreMBeanImpl.getCacheDirectory(), true);
                this.computeDiff("Directory", this.bean.getDirectory(), jMSFileStoreMBeanImpl.getDirectory(), false);
                this.computeDiff("InitialSize", this.bean.getInitialSize(), jMSFileStoreMBeanImpl.getInitialSize(), true);
                this.computeDiff("IoBufferSize", this.bean.getIoBufferSize(), jMSFileStoreMBeanImpl.getIoBufferSize(), true);
                this.computeDiff("MaxFileSize", this.bean.getMaxFileSize(), jMSFileStoreMBeanImpl.getMaxFileSize(), true);
                this.computeDiff("MaxWindowBufferSize", this.bean.getMaxWindowBufferSize(), jMSFileStoreMBeanImpl.getMaxWindowBufferSize(), true);
                this.computeDiff("MinWindowBufferSize", this.bean.getMinWindowBufferSize(), jMSFileStoreMBeanImpl.getMinWindowBufferSize(), true);
                this.computeDiff("Name", this.bean.getName(), jMSFileStoreMBeanImpl.getName(), false);
                this.computeDiff("SynchronousWritePolicy", this.bean.getSynchronousWritePolicy(), jMSFileStoreMBeanImpl.getSynchronousWritePolicy(), true);
                this.computeDiff("FileLockingEnabled", this.bean.isFileLockingEnabled(), jMSFileStoreMBeanImpl.isFileLockingEnabled(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                JMSFileStoreMBeanImpl jMSFileStoreMBeanImpl = (JMSFileStoreMBeanImpl)beanUpdateEvent.getSourceBean();
                JMSFileStoreMBeanImpl jMSFileStoreMBeanImpl2 = (JMSFileStoreMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("BlockSize")) {
                    jMSFileStoreMBeanImpl.setBlockSize(jMSFileStoreMBeanImpl2.getBlockSize());
                    jMSFileStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("CacheDirectory")) {
                    jMSFileStoreMBeanImpl.setCacheDirectory(jMSFileStoreMBeanImpl2.getCacheDirectory());
                    jMSFileStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (!string.equals("DelegatedBean") && !string.equals("DelegatedJMSServer")) {
                    if (string.equals("Directory")) {
                        jMSFileStoreMBeanImpl.setDirectory(jMSFileStoreMBeanImpl2.getDirectory());
                        jMSFileStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                    } else if (string.equals("InitialSize")) {
                        jMSFileStoreMBeanImpl.setInitialSize(jMSFileStoreMBeanImpl2.getInitialSize());
                        jMSFileStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                    } else if (string.equals("IoBufferSize")) {
                        jMSFileStoreMBeanImpl.setIoBufferSize(jMSFileStoreMBeanImpl2.getIoBufferSize());
                        jMSFileStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                    } else if (string.equals("MaxFileSize")) {
                        jMSFileStoreMBeanImpl.setMaxFileSize(jMSFileStoreMBeanImpl2.getMaxFileSize());
                        jMSFileStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                    } else if (string.equals("MaxWindowBufferSize")) {
                        jMSFileStoreMBeanImpl.setMaxWindowBufferSize(jMSFileStoreMBeanImpl2.getMaxWindowBufferSize());
                        jMSFileStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                    } else if (string.equals("MinWindowBufferSize")) {
                        jMSFileStoreMBeanImpl.setMinWindowBufferSize(jMSFileStoreMBeanImpl2.getMinWindowBufferSize());
                        jMSFileStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                    } else if (string.equals("Name")) {
                        jMSFileStoreMBeanImpl.setName(jMSFileStoreMBeanImpl2.getName());
                        jMSFileStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                    } else if (string.equals("SynchronousWritePolicy")) {
                        jMSFileStoreMBeanImpl.setSynchronousWritePolicy(jMSFileStoreMBeanImpl2.getSynchronousWritePolicy());
                        jMSFileStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                    } else if (string.equals("FileLockingEnabled")) {
                        jMSFileStoreMBeanImpl.setFileLockingEnabled(jMSFileStoreMBeanImpl2.isFileLockingEnabled());
                        jMSFileStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                    } else {
                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                JMSFileStoreMBeanImpl jMSFileStoreMBeanImpl = (JMSFileStoreMBeanImpl)abstractDescriptorBean;
                super.finishCopy(jMSFileStoreMBeanImpl, bl, list);
                if ((list == null || !list.contains("BlockSize")) && this.bean.isBlockSizeSet()) {
                    jMSFileStoreMBeanImpl.setBlockSize(this.bean.getBlockSize());
                }
                if ((list == null || !list.contains("CacheDirectory")) && this.bean.isCacheDirectorySet()) {
                    jMSFileStoreMBeanImpl.setCacheDirectory(this.bean.getCacheDirectory());
                }
                if ((list == null || !list.contains("Directory")) && this.bean.isDirectorySet()) {
                    jMSFileStoreMBeanImpl.setDirectory(this.bean.getDirectory());
                }
                if ((list == null || !list.contains("InitialSize")) && this.bean.isInitialSizeSet()) {
                    jMSFileStoreMBeanImpl.setInitialSize(this.bean.getInitialSize());
                }
                if ((list == null || !list.contains("IoBufferSize")) && this.bean.isIoBufferSizeSet()) {
                    jMSFileStoreMBeanImpl.setIoBufferSize(this.bean.getIoBufferSize());
                }
                if ((list == null || !list.contains("MaxFileSize")) && this.bean.isMaxFileSizeSet()) {
                    jMSFileStoreMBeanImpl.setMaxFileSize(this.bean.getMaxFileSize());
                }
                if ((list == null || !list.contains("MaxWindowBufferSize")) && this.bean.isMaxWindowBufferSizeSet()) {
                    jMSFileStoreMBeanImpl.setMaxWindowBufferSize(this.bean.getMaxWindowBufferSize());
                }
                if ((list == null || !list.contains("MinWindowBufferSize")) && this.bean.isMinWindowBufferSizeSet()) {
                    jMSFileStoreMBeanImpl.setMinWindowBufferSize(this.bean.getMinWindowBufferSize());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    jMSFileStoreMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("SynchronousWritePolicy")) && this.bean.isSynchronousWritePolicySet()) {
                    jMSFileStoreMBeanImpl.setSynchronousWritePolicy(this.bean.getSynchronousWritePolicy());
                }
                if ((list == null || !list.contains("FileLockingEnabled")) && this.bean.isFileLockingEnabledSet()) {
                    jMSFileStoreMBeanImpl.setFileLockingEnabled(this.bean.isFileLockingEnabled());
                }
                return jMSFileStoreMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getDelegatedBean(), clazz, object);
            this.inferSubTree(this.bean.getDelegatedJMSServer(), clazz, object);
        }
    }
}

