/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.TemplateBean;
import weblogic.jms.JMSExceptionLogger;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.FileStoreMBean;
import weblogic.management.configuration.GenericFileStoreMBean;
import weblogic.management.configuration.JMSInteropModuleMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.JMSSystemResourceMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.PathServiceMBean;
import weblogic.management.configuration.SAFAgentMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.WLDFServerDiagnosticMBean;
import weblogic.management.internal.ManagementTextTextFormatter;

public final class JMSLegalHelper {
    private static final int DIABLO_VERSION = 9;

    private static boolean targetMatchStoreTarget(DeploymentMBean deploymentMBean, DeploymentMBean deploymentMBean2) {
        TargetMBean[] targetMBeanArray = deploymentMBean.getTargets();
        TargetMBean[] targetMBeanArray2 = deploymentMBean2.getTargets();
        if (targetMBeanArray == null || targetMBeanArray.length == 0 || targetMBeanArray[0] == null) {
            return true;
        }
        if (targetMBeanArray2 == null || targetMBeanArray2.length == 0 || targetMBeanArray2[0] == null) {
            return false;
        }
        return targetMBeanArray[0].getName().equals(targetMBeanArray2[0].getName());
    }

    private static boolean usesMigratableTarget(DeploymentMBean deploymentMBean) {
        TargetMBean[] targetMBeanArray = deploymentMBean.getTargets();
        if (targetMBeanArray == null || targetMBeanArray.length == 0) {
            return false;
        }
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            if (!(targetMBeanArray[i] instanceof MigratableTargetMBean)) continue;
            return true;
        }
        return false;
    }

    private static int getConfigMajorVersion(DomainMBean domainMBean) {
        if (domainMBean == null) {
            return 9;
        }
        String string = domainMBean.getConfigurationVersion();
        if (string == null || string.length() == 0) {
            return 9;
        }
        int n = string.indexOf(46);
        String string2 = n <= 0 ? string : string.substring(0, n);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 9;
        }
    }

    public static void validateJMSServer(JMSServerMBean jMSServerMBean) throws IllegalArgumentException {
        if (JMSLegalHelper.getConfigMajorVersion((DomainMBean)jMSServerMBean.getParent()) >= 9 && jMSServerMBean.getStore() == null && jMSServerMBean.getPersistentStore() == null && jMSServerMBean.getStoreEnabled() && JMSLegalHelper.usesMigratableTarget(jMSServerMBean)) {
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getJMSServerMigratableStore(jMSServerMBean.getName()));
        }
        if (jMSServerMBean.getPersistentStore() != null && jMSServerMBean.getStoreEnabled() && !JMSLegalHelper.targetMatchStoreTarget(jMSServerMBean, jMSServerMBean.getPersistentStore())) {
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getStoreTargetMismatch(jMSServerMBean.getName()));
        }
        if (!(jMSServerMBean.isHostingTemporaryDestinations() || jMSServerMBean.getTemporaryTemplateResource() == null && jMSServerMBean.getTemporaryTemplateName() == null)) {
            throw new IllegalArgumentException("The JMSServer " + jMSServerMBean.getName() + " does not allow temporary destinations to be hosted, but " + " has either the temporary-template-resource or temporary-template-name defined");
        }
        if (jMSServerMBean.isHostingTemporaryDestinations()) {
            String string = jMSServerMBean.getTemporaryTemplateResource();
            String string2 = jMSServerMBean.getTemporaryTemplateName();
            if (string != null && string2 == null) {
                throw new IllegalArgumentException("A temporary template resource was specified (" + string + ") but no temporary template name was given");
            }
            if (string2 != null && string == null) {
                throw new IllegalArgumentException("A temporary template name was specified (" + string2 + ") but no temporary template resource was given");
            }
            if (string2 != null) {
                JMSBean jMSBean;
                DomainMBean domainMBean = JMSBeanHelper.getDomain(jMSServerMBean);
                JMSSystemResourceMBean jMSSystemResourceMBean = null;
                if (string.equals("interop-jms") && ((JMSInteropModuleMBean[])(jMSBean = domainMBean.getJMSInteropModules())).length > 0) {
                    jMSSystemResourceMBean = jMSBean[0];
                }
                if (jMSSystemResourceMBean == null) {
                    jMSSystemResourceMBean = domainMBean.lookupJMSSystemResource(string);
                }
                if (jMSSystemResourceMBean == null) {
                    throw new IllegalArgumentException(JMSExceptionLogger.logNoTemporaryTemplateLoggable((String)jMSServerMBean.getName(), (String)string, (String)string2).getMessage());
                }
                jMSBean = jMSSystemResourceMBean.getJMSResource();
                if (jMSBean == null) {
                    return;
                }
                TemplateBean templateBean = jMSBean.lookupTemplate(string2);
                if (templateBean == null) {
                    throw new IllegalArgumentException("The JMSServer " + jMSServerMBean.getName() + " has a temporary resource of " + string + " and a temporary template name of " + string2 + " but not template of that name can be found in the given resource");
                }
            }
        }
    }

    public static void validateSAFAgent(SAFAgentMBean sAFAgentMBean) throws IllegalArgumentException {
        if (sAFAgentMBean.getStore() == null && JMSLegalHelper.usesMigratableTarget(sAFAgentMBean)) {
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getJMSServerMigratableStore(sAFAgentMBean.getName()));
        }
        if (sAFAgentMBean.getStore() != null && (sAFAgentMBean.getTargets().length > 1 || sAFAgentMBean.getTargets().length == 1 && sAFAgentMBean.getTargets()[0] instanceof ClusterMBean)) {
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getSAFAgentSingleTarget(sAFAgentMBean.getName()));
        }
        if (sAFAgentMBean.getStore() != null && !JMSLegalHelper.targetMatchStoreTarget(sAFAgentMBean, sAFAgentMBean.getStore())) {
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getStoreTargetMismatch(sAFAgentMBean.getName()));
        }
        if (sAFAgentMBean.getTargets().length == 1 && sAFAgentMBean.getTargets()[0] instanceof MigratableTargetMBean && "Receiving-only".equals(sAFAgentMBean.getServiceType())) {
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getReceivingAgentInvlid4MT(sAFAgentMBean.getName()));
        }
    }

    public static void validateServerBytesValues(JMSServerMBean jMSServerMBean) throws IllegalArgumentException {
        if (jMSServerMBean.getBytesMaximum() >= 0L && jMSServerMBean.getBytesThresholdHigh() > jMSServerMBean.getBytesMaximum()) {
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getJMSBytesMaxOverThreshold(jMSServerMBean.getName()));
        }
        if (jMSServerMBean.getBytesThresholdHigh() >= 0L && jMSServerMBean.getBytesThresholdHigh() < jMSServerMBean.getBytesThresholdLow()) {
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getJMSBytesThresholdsReversed(jMSServerMBean.getName()));
        }
    }

    public static void validateServerBytesValues(SAFAgentMBean sAFAgentMBean) throws IllegalArgumentException {
        if (sAFAgentMBean.getBytesMaximum() >= 0L && sAFAgentMBean.getBytesThresholdHigh() > sAFAgentMBean.getBytesMaximum()) {
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getJMSBytesMaxOverThreshold(sAFAgentMBean.getName()));
        }
        if (sAFAgentMBean.getBytesThresholdHigh() >= 0L && sAFAgentMBean.getBytesThresholdHigh() < sAFAgentMBean.getBytesThresholdLow()) {
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getJMSBytesThresholdsReversed(sAFAgentMBean.getName()));
        }
    }

    public static void validateServerMessagesValues(JMSServerMBean jMSServerMBean) throws IllegalArgumentException {
        if (jMSServerMBean.getMessagesMaximum() >= 0L && jMSServerMBean.getMessagesThresholdHigh() > jMSServerMBean.getMessagesMaximum()) {
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getJMSMessagesMaxOverThreshold(jMSServerMBean.getName()));
        }
        if (jMSServerMBean.getMessagesThresholdHigh() >= 0L && jMSServerMBean.getMessagesThresholdHigh() < jMSServerMBean.getMessagesThresholdLow()) {
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getJMSMessagesThresholdsReversed(jMSServerMBean.getName()));
        }
    }

    public static void validateServerMessagesValues(SAFAgentMBean sAFAgentMBean) throws IllegalArgumentException {
        if (sAFAgentMBean.getMessagesMaximum() >= 0L && sAFAgentMBean.getMessagesThresholdHigh() > sAFAgentMBean.getMessagesMaximum()) {
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getJMSMessagesMaxOverThreshold(sAFAgentMBean.getName()));
        }
        if (sAFAgentMBean.getMessagesThresholdHigh() >= 0L && sAFAgentMBean.getMessagesThresholdHigh() < sAFAgentMBean.getMessagesThresholdLow()) {
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getJMSMessagesThresholdsReversed(sAFAgentMBean.getName()));
        }
    }

    public static void validateSingleServerTargets(TargetMBean targetMBean) throws IllegalArgumentException {
        if (targetMBean == null) {
            return;
        }
        if (!(targetMBean instanceof ServerMBean) && !(targetMBean instanceof MigratableTargetMBean)) {
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getSingleTargetRequired() + ": " + targetMBean);
        }
    }

    public static void validateSingleServerTargets(TargetMBean[] targetMBeanArray) throws IllegalArgumentException {
        if (targetMBeanArray == null || targetMBeanArray.length == 0) {
            return;
        }
        if (targetMBeanArray.length > 1) {
            StringBuffer stringBuffer = new StringBuffer("[");
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                TargetMBean targetMBean = targetMBeanArray[i];
                stringBuffer.append(targetMBean.getName());
                if (i >= targetMBeanArray.length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("]");
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getSingleTargetRequired() + ": " + stringBuffer);
        }
        JMSLegalHelper.validateSingleServerTargets(targetMBeanArray[0]);
    }

    public static void validateStoreTargets(DomainMBean domainMBean) throws IllegalArgumentException {
        JMSServerMBean[] jMSServerMBeanArray = domainMBean.getJMSServers();
        for (int i = 0; i < jMSServerMBeanArray.length; ++i) {
            JMSServerMBean jMSServerMBean = jMSServerMBeanArray[i];
            if (jMSServerMBean.getPersistentStore() == null || JMSLegalHelper.targetMatchStoreTarget(jMSServerMBean, jMSServerMBean.getPersistentStore())) continue;
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getStoreTargetMismatch(jMSServerMBean.getName()));
        }
        SAFAgentMBean[] sAFAgentMBeanArray = domainMBean.getSAFAgents();
        for (int i = 0; i < sAFAgentMBeanArray.length; ++i) {
            SAFAgentMBean sAFAgentMBean = sAFAgentMBeanArray[i];
            if (sAFAgentMBean.getStore() == null || JMSLegalHelper.targetMatchStoreTarget(sAFAgentMBean, sAFAgentMBean.getStore())) continue;
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getStoreTargetMismatch(sAFAgentMBean.getName()));
        }
        PathServiceMBean[] pathServiceMBeanArray = domainMBean.getPathServices();
        for (int i = 0; i < pathServiceMBeanArray.length; ++i) {
            PathServiceMBean pathServiceMBean = pathServiceMBeanArray[i];
            if (pathServiceMBean.getPersistentStore() == null || JMSLegalHelper.targetMatchStoreTarget(pathServiceMBean, pathServiceMBean.getPersistentStore())) continue;
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getPathServiceStoreTargetMismatch(pathServiceMBean.getName()));
        }
    }

    public static void validateStoreParams(DomainMBean domainMBean) throws IllegalArgumentException {
        TargetMBean[] targetMBeanArray;
        FileStoreMBean[] fileStoreMBeanArray = domainMBean.getFileStores();
        for (int i = 0; i < fileStoreMBeanArray.length; ++i) {
            TargetMBean targetMBean;
            targetMBeanArray = fileStoreMBeanArray[i];
            TargetMBean[] targetMBeanArray2 = targetMBeanArray.getTargets();
            if (targetMBeanArray2.length != 0 && (targetMBean = targetMBeanArray.getTargets()[0]) != null && targetMBean instanceof MigratableTargetMBean && (targetMBeanArray.getDirectory() == null || targetMBeanArray.getDirectory().trim().equals(""))) {
                throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getMigratableFileStoreDirectoryMissing(targetMBeanArray.getName(), targetMBean.getName()));
            }
            JMSLegalHelper.validateStoreConfig((GenericFileStoreMBean)targetMBeanArray);
        }
        ServerMBean[] serverMBeanArray = domainMBean.getServers();
        targetMBeanArray = serverMBeanArray;
        int n = targetMBeanArray.length;
        for (int i = 0; i < n; ++i) {
            ServerMBean serverMBean = targetMBeanArray[i];
            JMSLegalHelper.validateStoreConfig(serverMBean.getDefaultFileStore());
            JMSLegalHelper.validateDiagnosticStoreConfig(serverMBean.getServerDiagnosticConfig());
        }
        for (TargetMBean targetMBean : targetMBeanArray = domainMBean.getJMSServers()) {
            JMSLegalHelper.validatePagingConfig((JMSServerMBean)targetMBean);
        }
    }

    private static void invalidNumberRange(Object object, String string, Object object2, Object object3, Object object4) {
        throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getInvalidNumberRange(String.valueOf(object), string, String.valueOf(object2), String.valueOf(object3), String.valueOf(object4)));
    }

    private static void validateStoreTuning(int n, int n2, int n3, long l, int n4) {
        if (n != -1 && n < 65536) {
            JMSLegalHelper.invalidNumberRange(n, "MinWindowBufferSize", -1, 65536, 0x40000000);
        }
        if (n2 != -1 && (n2 < 65536 || n2 < n)) {
            Object object = n == -1 ? Integer.valueOf(65536) : "MinWindowBufferSize";
            JMSLegalHelper.invalidNumberRange(n2, "MaxWindowBufferSize", -1, object, 0x40000000);
        }
        if (n3 != -1 && n3 < 0x100000) {
            JMSLegalHelper.invalidNumberRange(n3, "IoBufferSize", -1, 0x100000, 0x4000000);
        }
        if (l != 0L && l < 0x100000L) {
            JMSLegalHelper.invalidNumberRange(l, "InitialSize", 0, 0x100000, 0x10000000000000L);
        }
        if (n4 != -1 && n4 < 512) {
            JMSLegalHelper.invalidNumberRange(n4, "BlockSize", -1, 512, 8192);
        }
    }

    private static void validateDiagnosticStoreConfig(WLDFServerDiagnosticMBean wLDFServerDiagnosticMBean) throws IllegalArgumentException {
        int n = wLDFServerDiagnosticMBean.getDiagnosticStoreMinWindowBufferSize();
        int n2 = wLDFServerDiagnosticMBean.getDiagnosticStoreMaxWindowBufferSize();
        int n3 = wLDFServerDiagnosticMBean.getDiagnosticStoreIoBufferSize();
        int n4 = wLDFServerDiagnosticMBean.getDiagnosticStoreBlockSize();
        JMSLegalHelper.validateStoreTuning(n, n2, n3, 0L, n4);
    }

    private static void validatePagingConfig(JMSServerMBean jMSServerMBean) throws IllegalArgumentException {
        int n = jMSServerMBean.getPagingMinWindowBufferSize();
        int n2 = jMSServerMBean.getPagingMaxWindowBufferSize();
        int n3 = jMSServerMBean.getPagingIoBufferSize();
        int n4 = jMSServerMBean.getPagingBlockSize();
        JMSLegalHelper.validateStoreTuning(n, n2, n3, 0L, n4);
    }

    private static void validateStoreConfig(GenericFileStoreMBean genericFileStoreMBean) throws IllegalArgumentException {
        int n = genericFileStoreMBean.getMinWindowBufferSize();
        int n2 = genericFileStoreMBean.getMaxWindowBufferSize();
        int n3 = genericFileStoreMBean.getIoBufferSize();
        long l = genericFileStoreMBean.getInitialSize();
        int n4 = genericFileStoreMBean.getBlockSize();
        JMSLegalHelper.validateStoreTuning(n, n2, n3, l, n4);
    }

    public static void validateJDBCPrefix(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            return;
        }
        if (string.equalsIgnoreCase("jmsmsg") || string.equalsIgnoreCase("jmsstore") || string.equalsIgnoreCase("jmsstate")) {
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getIllegalJMSJDBCPrefix());
        }
    }

    public static void validateRetryBaseAndMax(SAFAgentMBean sAFAgentMBean) {
        if (sAFAgentMBean.getDefaultRetryDelayMultiplier() > 1.0 && sAFAgentMBean.getDefaultRetryDelayBase() > sAFAgentMBean.getDefaultRetryDelayMaximum()) {
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getIllegalRetryDelayBaseAndMax(sAFAgentMBean.getName(), sAFAgentMBean.getDefaultRetryDelayBase(), sAFAgentMBean.getDefaultRetryDelayMaximum()));
        }
    }

    public static void validateSAFAgentTargets(TargetMBean[] targetMBeanArray) throws IllegalArgumentException {
        if (targetMBeanArray == null || targetMBeanArray.length == 0) {
            return;
        }
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            TargetMBean targetMBean = targetMBeanArray[i];
            if (!(targetMBean instanceof ServerMBean || targetMBean instanceof ClusterMBean || targetMBean instanceof MigratableTargetMBean)) {
                throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getIllegalSAFAgentTargets(targetMBean.getType()));
            }
            if (!(targetMBean instanceof MigratableTargetMBean) || targetMBeanArray.length <= 1) continue;
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getIllegalSAFAgentMigratableTargets());
        }
    }

    public static void validateAcknowledgeIntervalValue(long l) throws IllegalArgumentException {
        if (l <= 0L && l != -1L) {
            throw new IllegalArgumentException(ManagementTextTextFormatter.getInstance().getAcknowledgeIntervalNotValid(l));
        }
    }
}

